/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade;

import com.qualidadeeprodutividade.fmea.ApTableCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.PauseTransition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;

public class CoreTools
extends Application {
    private static Scene scene;
    public static Image APP_ICON;
    private static final Logger LOG;

    public void start(Stage stage) throws IOException {
        try {
            URL iconUrl;
            Locale.setDefault(Locale.ENGLISH);
            String osName = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
            URL uRL = iconUrl = osName.contains("win") ? CoreTools.class.getResource("/icons/icon-windows.png") : CoreTools.class.getResource("/icons/icon.png");
            if (iconUrl == null) {
                iconUrl = CoreTools.class.getResource("/icons/icon.png");
            }
            if (iconUrl != null) {
                APP_ICON = new Image(iconUrl.toExternalForm());
            }
            Stage splash = this.buildSplashStage();
            splash.show();
            long splashShownAt = System.currentTimeMillis();
            Task<Parent> loadTask = new Task<Parent>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                protected Parent call() throws IOException {
                    ApTableCache.ensureLoaded();
                    return CoreTools.loadFXML("MainWindow");
                }
            };
            loadTask.setOnSucceeded(arg_0 -> this.lambda$start$0((Task)loadTask, stage, splash, splashShownAt, arg_0));
            loadTask.setOnFailed(arg_0 -> CoreTools.lambda$start$6(splash, (Task)loadTask, arg_0));
            new Thread((Runnable)loadTask, "CoreTools-UI-Loader").start();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to start CoreTools", ex);
            Alert a = new Alert(Alert.AlertType.ERROR);
            a.setTitle("Startup error");
            a.setHeaderText("Failed to start CoreTools");
            a.setContentText(ex.getMessage() != null ? ex.getMessage() : ex.getClass().getSimpleName());
            a.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
            a.showAndWait();
            Platform.exit();
        }
    }

    private static Parent loadFXML(String fxml) throws IOException {
        String relative;
        Path candidate;
        Path candidate2;
        ClassLoader loader;
        String resourcePath = "/com/qualidadeeprodutividade/" + fxml + ".fxml";
        URL url = CoreTools.class.getResource(resourcePath);
        if (url == null && (loader = Thread.currentThread().getContextClassLoader()) != null) {
            url = loader.getResource((String)(resourcePath.startsWith("/") ? resourcePath.substring(1) : resourcePath));
        }
        if (url == null && (candidate2 = CoreTools.resolveFromCodeSource(resourcePath)) != null && Files.exists(candidate2, new LinkOption[0])) {
            url = candidate2.toUri().toURL();
        }
        if (url == null && Files.exists(candidate2 = CoreTools.resolveFromBase("target/classes", resourcePath), new LinkOption[0])) {
            url = candidate2.toUri().toURL();
        }
        if (url == null && Files.exists(candidate2 = CoreTools.resolveFromBase("src/main/resources", resourcePath), new LinkOption[0])) {
            url = candidate2.toUri().toURL();
        }
        if (url == null && Files.exists(candidate = CoreTools.resolveFromBase("src/main/resources", relative = CoreTools.stripLeadingSlash(resourcePath)), new LinkOption[0])) {
            url = candidate.toUri().toURL();
        }
        if (url == null) {
            Path fromCodeSource = CoreTools.resolveFromCodeSource(resourcePath);
            throw new IllegalStateException("FXML not found at:\n - %s\n - %s\n%sResource id: %s".formatted(CoreTools.safePath(CoreTools.resolveFromBase("target/classes", resourcePath)), CoreTools.safePath(CoreTools.resolveFromBase("src/main/resources", resourcePath)), fromCodeSource != null ? " - " + CoreTools.safePath(fromCodeSource) + System.lineSeparator() : "", resourcePath));
        }
        return (Parent)new FXMLLoader(url).load();
    }

    private static String stripLeadingSlash(String path) {
        return path != null && path.startsWith("/") ? path.substring(1) : path;
    }

    private static Path resolveFromBase(String base, String resourcePath) {
        String relative = CoreTools.stripLeadingSlash(resourcePath);
        Path p = Paths.get(base, new String[0]);
        if (relative == null || relative.isEmpty()) {
            return p;
        }
        for (String segment : relative.split("/")) {
            if (segment.isEmpty()) continue;
            p = p.resolve(segment);
        }
        return p;
    }

    private static Path resolveFromCodeSource(String resourcePath) {
        try {
            CodeSource codeSource = CoreTools.class.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                return null;
            }
            Path location = Paths.get(codeSource.getLocation().toURI());
            if (!Files.isDirectory(location, new LinkOption[0])) {
                return null;
            }
            return CoreTools.resolveFromBase(location.toString(), resourcePath);
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return null;
        }
    }

    private static String safePath(Path path) {
        return path == null ? "<unknown>" : path.toAbsolutePath().toString();
    }

    public static void main(String[] args) {
        CoreTools.launch((String[])new String[0]);
    }

    private void showExitConfirmation(Stage owner) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Confirm exit");
        alert.setHeaderText("Do you really want to quit?");
        alert.setContentText("Click OK to quit.");
        if (owner != null) {
            alert.initOwner((Window)owner);
            alert.initModality(Modality.WINDOW_MODAL);
        }
        if (alert.showAndWait().get() == ButtonType.OK) {
            Platform.exit();
            System.exit(0);
        }
    }

    private Stage buildSplashStage() {
        URL fallback;
        URL sUrl = CoreTools.class.getResource("/splash.png");
        Image splashImg = sUrl != null ? new Image(sUrl.toExternalForm(), 512.0, 512.0, true, true, false) : new Image((fallback = CoreTools.class.getResource("/icons/icon.png")) != null ? fallback.toExternalForm() : "", 512.0, 512.0, true, true, false);
        ImageView iv = new ImageView(splashImg);
        iv.setPreserveRatio(true);
        iv.setSmooth(true);
        iv.setFitWidth(520.0);
        Label title = new Label("CoreTools");
        title.setStyle("-fx-font-size: 28px; -fx-font-weight: bold;");
        ProgressIndicator pi = new ProgressIndicator();
        pi.setMaxSize(36.0, 36.0);
        Label company = new Label("Quality and Productivity. All rights reserved");
        company.setStyle("-fx-font-size: 11px; -fx-text-fill: #666;");
        Label ver = new Label("Version " + CoreTools.appVersion());
        ver.setStyle("-fx-font-size: 11px; -fx-text-fill: #666;");
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        HBox footer = new HBox(10.0, new Node[]{company, spacer, ver});
        footer.setAlignment(Pos.CENTER_LEFT);
        VBox box = new VBox(12.0, new Node[]{iv, title, pi, footer});
        box.setAlignment(Pos.CENTER);
        box.setStyle("-fx-background-color: white;");
        box.setPadding(new Insets(20.0, 20.0, 14.0, 20.0));
        Scene splashScene = new Scene((Parent)box);
        Stage splash = new Stage(StageStyle.UNDECORATED);
        splash.setScene(splashScene);
        splash.initModality(Modality.NONE);
        splash.setAlwaysOnTop(true);
        if (APP_ICON != null) {
            splash.getIcons().setAll((Object[])new Image[]{APP_ICON});
        }
        splash.centerOnScreen();
        return splash;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String appVersion() {
        try (InputStream in2222 = CoreTools.class.getResourceAsStream("/app.properties");){
            if (in2222 != null) {
                Properties p = new Properties();
                p.load(in2222);
                String v = p.getProperty("app.version");
                if (v != null && !v.isBlank()) {
                    String string = v;
                    return string;
                }
            }
        }
        catch (Exception in2222) {
            // empty catch block
        }
        try {
            String v = CoreTools.class.getPackage().getImplementationVersion();
            if (v == null) return "dev";
            if (v.isBlank()) return "dev";
            return v;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "dev";
    }

    private static /* synthetic */ void lambda$start$6(Stage splash, Task loadTask, WorkerStateEvent e) {
        splash.close();
        Throwable ex = loadTask.getException();
        Alert a = new Alert(Alert.AlertType.ERROR);
        a.setTitle("Error");
        a.setHeaderText("Failed to load UI");
        a.setContentText(ex != null ? ex.getMessage() : "");
        a.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        if (APP_ICON != null) {
            ((Stage)a.getDialogPane().getScene().getWindow()).getIcons().setAll((Object[])new Image[]{APP_ICON});
        }
        if (ex != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            TextArea textArea = new TextArea(sw.toString());
            textArea.setEditable(false);
            textArea.setWrapText(true);
            textArea.setMaxWidth(Double.MAX_VALUE);
            textArea.setMaxHeight(Double.MAX_VALUE);
            VBox expContent = new VBox(8.0, new Node[]{new Label("Details:"), textArea});
            VBox.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
            expContent.setMaxWidth(Double.MAX_VALUE);
            a.getDialogPane().setExpandableContent((Node)expContent);
        }
        a.showAndWait();
        Platform.exit();
    }

    private /* synthetic */ void lambda$start$0(Task loadTask, Stage stage, Stage splash, long splashShownAt, WorkerStateEvent e) {
        Parent root = (Parent)loadTask.getValue();
        scene = new Scene(root, 1000.0, 600.0);
        stage.setScene(scene);
        stage.setTitle("CoreTools");
        stage.setResizable(true);
        if (APP_ICON != null) {
            stage.getIcons().setAll((Object[])new Image[]{APP_ICON});
        }
        stage.setOnCloseRequest(event -> {
            event.consume();
            this.showExitConfirmation(stage);
        });
        Runnable showMainWindow = () -> {
            splash.close();
            Platform.runLater(() -> {
                stage.show();
                Window.getWindows().addListener(change -> {
                    if (APP_ICON == null) {
                        return;
                    }
                    while (change.next()) {
                        if (!change.wasAdded()) continue;
                        for (Window w : change.getAddedSubList()) {
                            if (!(w instanceof Stage)) continue;
                            Stage s = (Stage)w;
                            s.getIcons().setAll((Object[])new Image[]{APP_ICON});
                        }
                    }
                });
            });
        };
        long elapsed = System.currentTimeMillis() - splashShownAt;
        if (elapsed >= 3000L) {
            showMainWindow.run();
        } else {
            PauseTransition delay = new PauseTransition(Duration.millis((double)(3000L - elapsed)));
            delay.setOnFinished(evt -> showMainWindow.run());
            delay.play();
        }
    }

    static {
        LOG = Logger.getLogger(CoreTools.class.getName());
    }
}

