/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controlPlan;

import com.qualidadeeprodutividade.controlPlan.ControlPlan;
import com.qualidadeeprodutividade.controlPlan.ControlPlanLevel;
import com.qualidadeeprodutividade.controlPlan.ControlPlanRow;
import com.qualidadeeprodutividade.fmea.RevisionEntry;
import com.qualidadeeprodutividade.pdf.PdfAssets;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.imageio.ImageIO;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ControlPlanExcelExporter {
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final int LOGO_COLUMN_INDEX = 17;
    private static final int LOGO_COLUMN_SPAN = 2;
    private static final int LOGO_ROW_INDEX = 0;
    private static final int LOGO_ROW_SPAN = 5;

    private ControlPlanExcelExporter() {
    }

    public static void export(ControlPlan model, Path targetPath) throws IOException {
        ControlPlanExcelExporter.export(model, targetPath, null);
    }

    public static void export(ControlPlan model, Path targetPath, Path logoPath) throws IOException {
        Objects.requireNonNull(model, "Control plan is null");
        Objects.requireNonNull(targetPath, "Target path is null");
        if (targetPath.getParent() != null) {
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        }
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Sheet sheet = workbook.createSheet("Control Plan");
            sheet.setDisplayGridlines(false);
            sheet.setPrintGridlines(false);
            CellStyle titleStyle = workbook.createCellStyle();
            Font titleFont = workbook.createFont();
            titleFont.setBold(true);
            titleFont.setFontHeightInPoints((short)14);
            titleStyle.setFont(titleFont);
            CellStyle headerStyle = workbook.createCellStyle();
            Font headerFont = workbook.createFont();
            headerFont.setBold(true);
            headerStyle.setFont(headerFont);
            headerStyle.setWrapText(true);
            headerStyle.setVerticalAlignment(VerticalAlignment.TOP);
            ControlPlanExcelExporter.applyThinBorders(headerStyle);
            CellStyle keyStyle = workbook.createCellStyle();
            Font keyFont = workbook.createFont();
            keyFont.setBold(true);
            keyStyle.setFont(keyFont);
            keyStyle.setAlignment(HorizontalAlignment.LEFT);
            ControlPlanExcelExporter.applyThinBorders(keyStyle);
            CellStyle valueStyle = workbook.createCellStyle();
            valueStyle.setWrapText(true);
            valueStyle.setVerticalAlignment(VerticalAlignment.TOP);
            ControlPlanExcelExporter.applyThinBorders(valueStyle);
            int rowIdx = 0;
            Row titleRow = sheet.createRow(rowIdx++);
            Cell titleCell = titleRow.createCell(0);
            titleCell.setCellValue(ControlPlanExcelExporter.resolveTitle(model));
            titleCell.setCellStyle(titleStyle);
            titleRow.setHeightInPoints(36.0f);
            Row subtitleRow = sheet.createRow(rowIdx++);
            subtitleRow.createCell(0).setCellValue("Control Plan Number: " + ControlPlanExcelExporter.nz(model.getCpNumber(), "N/A"));
            subtitleRow.createCell(1).setCellValue("Revision: " + ControlPlanExcelExporter.nz(ControlPlanExcelExporter.resolveRevision(model), "N/A"));
            subtitleRow.createCell(2).setCellValue("Level: " + ControlPlanExcelExporter.nz(ControlPlanExcelExporter.formatLevel(model.getCpLevel()), "N/A"));
            subtitleRow.setHeightInPoints(20.0f);
            ++rowIdx;
            rowIdx = ControlPlanExcelExporter.writeHeaderSection(sheet, rowIdx, keyStyle, valueStyle, model);
            rowIdx += 2;
            List<ColumnSpec> columns = ControlPlanExcelExporter.buildColumnCatalog();
            Row headerRow = sheet.createRow(rowIdx++);
            for (int i = 0; i < columns.size(); ++i) {
                Cell cell = headerRow.createCell(i);
                cell.setCellValue(columns.get((int)i).title);
                cell.setCellStyle(headerStyle);
            }
            for (ControlPlanRow rowModel : ControlPlanExcelExporter.safeList(model.getControlChains())) {
                Row row = sheet.createRow(rowIdx++);
                for (int col = 0; col < columns.size(); ++col) {
                    ColumnSpec spec = columns.get(col);
                    Cell cell = row.createCell(col);
                    cell.setCellValue(spec.extractor.apply(rowModel));
                    cell.setCellStyle(valueStyle);
                }
            }
            for (int i = 0; i < columns.size(); ++i) {
                sheet.autoSizeColumn(i);
            }
            ControlPlanExcelExporter.placeLogo((Workbook)workbook, sheet, logoPath);
            try (OutputStream out = Files.newOutputStream(targetPath, new OpenOption[0]);){
                workbook.write(out);
            }
        }
        catch (Exception ex) {
            throw new IOException("Failed to export Control Plan Excel", ex);
        }
    }

    private static int writeHeaderSection(Sheet sheet, int rowIdx, CellStyle keyStyle, CellStyle valueStyle, ControlPlan model) {
        String[][] rows;
        for (String[] rowValues : rows = new String[][]{{"Control Plan Number", ControlPlanExcelExporter.nz(model.getCpNumber(), "-"), "Part Number", ControlPlanExcelExporter.nz(model.getCpPartNumber(), "-"), "Part Name", ControlPlanExcelExporter.nz(model.getCpPartName(), "-")}, {"Level", ControlPlanExcelExporter.nz(ControlPlanExcelExporter.formatLevel(model.getCpLevel()), "-"), "Revision", ControlPlanExcelExporter.nz(ControlPlanExcelExporter.resolveRevision(model), "-"), "Revision Date", ControlPlanExcelExporter.formatDate(model.getCpRevisionDate())}, {"Date Originated", ControlPlanExcelExporter.formatDate(model.getCpStartDate()), "Key Contact / Phone", ControlPlanExcelExporter.nz(model.getCpKeyContact(), "-"), "Core Team", ControlPlanExcelExporter.nz(model.getCrossFunctionalTeam(), "-")}, {"Supplier Plant", ControlPlanExcelExporter.nz(model.getSupplierPlant(), "-"), "Supplier Code", ControlPlanExcelExporter.nz(model.getSupplierCode(), "-"), "Customer Eng. Approval/Date", ControlPlanExcelExporter.nz(model.getCpCustomerEngApproval(), "-")}, {"Customer Quality Approval/Date", ControlPlanExcelExporter.nz(model.getCpCustomerQualApproval(), "-"), "Customer Other Approval/Date", ControlPlanExcelExporter.nz(model.getCpCustomerOtherApproval(), "-"), "Supplier Plant Approval/Date", ControlPlanExcelExporter.nz(model.getCpSupplierPlantApproval(), "-")}, {"Supplier Other Approval/Date", ControlPlanExcelExporter.nz(model.getCpSupplierOtherApproval(), "-"), "", "", "", ""}}) {
            Row row = sheet.createRow(rowIdx++);
            for (int i = 0; i < rowValues.length; i += 2) {
                Cell keyCell = row.createCell(i);
                keyCell.setCellValue(rowValues[i]);
                keyCell.setCellStyle(keyStyle);
                Cell valueCell = row.createCell(i + 1);
                valueCell.setCellValue(rowValues[i + 1]);
                valueCell.setCellStyle(valueStyle);
            }
        }
        return rowIdx;
    }

    private static String resolveTitle(ControlPlan model) {
        String subject = model.getCpPartName();
        if (subject == null || subject.isBlank()) {
            subject = model.getCpPartNumber();
        }
        if (subject == null || subject.isBlank()) {
            subject = model.getCpNumber();
        }
        if (subject == null || subject.isBlank()) {
            return "Control Plan";
        }
        return "Control Plan for " + subject.trim();
    }

    private static List<ColumnSpec> buildColumnCatalog() {
        ArrayList<ColumnSpec> columns = new ArrayList<ColumnSpec>();
        columns.add(new ColumnSpec("Part/Process Number", row -> ControlPlanExcelExporter.nz(row.getPartOrProcessNumber(), "-")));
        columns.add(new ColumnSpec("Process Name / Operation Description", row -> ControlPlanExcelExporter.nz(row.getProcessNameOrOperationDescription(), "-")));
        columns.add(new ColumnSpec("Machine / Device / Jig / Tool", row -> ControlPlanExcelExporter.nz(row.getMachineDeviceJigToolForMfg(), "-")));
        columns.add(new ColumnSpec("#", row -> ControlPlanExcelExporter.nz(row.getNumber(), "-")));
        columns.add(new ColumnSpec("Product Characteristic", row -> ControlPlanExcelExporter.nz(row.getProductCharacteristic(), "-")));
        columns.add(new ColumnSpec("Process Characteristic", row -> ControlPlanExcelExporter.nz(row.getProcessCharacteristic(), "-")));
        columns.add(new ColumnSpec("CTS", row -> ControlPlanExcelExporter.formatFlag(row.getIsCriticalToSafety())));
        columns.add(new ColumnSpec("CTQ", row -> ControlPlanExcelExporter.formatFlag(row.getIsCriticalToQuality())));
        columns.add(new ColumnSpec("CTP", row -> ControlPlanExcelExporter.formatFlag(row.getIsCriticalToProcess())));
        columns.add(new ColumnSpec("Attribute", row -> ControlPlanExcelExporter.formatFlag(row.getAttribute())));
        columns.add(new ColumnSpec("Lower Limit", row -> ControlPlanExcelExporter.nz(row.getLowerLimit(), "-")));
        columns.add(new ColumnSpec("Target Value", row -> ControlPlanExcelExporter.nz(row.getTargetValue(), "-")));
        columns.add(new ColumnSpec("Upper Limit", row -> ControlPlanExcelExporter.nz(row.getUpperLimit(), "-")));
        columns.add(new ColumnSpec("Evaluation / Measurement Technique", row -> ControlPlanExcelExporter.nz(row.getEvaluationMeasurementTechnique(), "-")));
        columns.add(new ColumnSpec("Sample Size", row -> ControlPlanExcelExporter.nz(row.getSampleSize(), "-")));
        columns.add(new ColumnSpec("Sample Frequency", row -> ControlPlanExcelExporter.nz(row.getSampleFrequency(), "-")));
        columns.add(new ColumnSpec("Control Method", row -> ControlPlanExcelExporter.nz(row.getControlMethod(), "-")));
        columns.add(new ColumnSpec("Reaction Plan", row -> ControlPlanExcelExporter.nz(row.getReactionPlan(), "-")));
        return columns;
    }

    private static void applyThinBorders(CellStyle style) {
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
    }

    private static String resolveRevision(ControlPlan model) {
        if (model == null) {
            return "";
        }
        String revision = model.getCpRevision();
        if (revision != null && !revision.isBlank()) {
            return revision.trim();
        }
        return model.latestApprovedRevision().map(RevisionEntry::getRevisionNumber).map(String::trim).orElse("");
    }

    private static <T> List<T> safeList(List<T> list) {
        return list == null ? List.of() : list;
    }

    private static String formatFlag(Boolean flag) {
        return Boolean.TRUE.equals(flag) ? "X" : "";
    }

    private static String formatDate(LocalDate date) {
        if (date == null) {
            return "-";
        }
        return DATE_FMT.format(date);
    }

    private static String formatLevel(ControlPlanLevel level) {
        if (level == null) {
            return "";
        }
        return level.toString();
    }

    private static String nz(String value, String fallback) {
        if (value == null) {
            return fallback;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? fallback : trimmed;
    }

    private static void placeLogo(Workbook workbook, Sheet sheet, Path logoPath) {
        byte[] logoBytes = PdfAssets.loadLogoBytes(logoPath);
        if (logoBytes == null || logoBytes.length == 0) {
            return;
        }
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(logoBytes));
            if (image == null) {
                return;
            }
            int pictureIdx = workbook.addPicture(logoBytes, 6);
            CreationHelper helper = workbook.getCreationHelper();
            Drawing drawing = sheet.createDrawingPatriarch();
            ClientAnchor anchor = helper.createClientAnchor();
            anchor.setCol1(17);
            anchor.setRow1(0);
            anchor.setDx1(0);
            anchor.setDy1(0);
            anchor.setCol2(19);
            anchor.setRow2(5);
            anchor.setDx2(0);
            anchor.setDy2(0);
            drawing.createPicture(anchor, pictureIdx);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class ColumnSpec {
        final String title;
        final Function<ControlPlanRow, String> extractor;

        ColumnSpec(String title, Function<ControlPlanRow, String> extractor) {
            this.title = title;
            this.extractor = extractor;
        }
    }
}

