/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controlPlan;

import com.qualidadeeprodutividade.controlPlan.ControlPlan;
import com.qualidadeeprodutividade.controlPlan.ControlPlanLevel;
import com.qualidadeeprodutividade.controlPlan.ControlPlanRow;
import com.qualidadeeprodutividade.fmea.RevisionEntry;
import com.qualidadeeprodutividade.pdf.PdfAssets;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.openpdf.text.Chunk;
import org.openpdf.text.Document;
import org.openpdf.text.DocumentException;
import org.openpdf.text.Element;
import org.openpdf.text.Font;
import org.openpdf.text.FontFactory;
import org.openpdf.text.Image;
import org.openpdf.text.PageSize;
import org.openpdf.text.Paragraph;
import org.openpdf.text.Phrase;
import org.openpdf.text.SplitCharacter;
import org.openpdf.text.pdf.PdfPCell;
import org.openpdf.text.pdf.PdfPTable;
import org.openpdf.text.pdf.PdfWriter;

public final class ControlPlanPdfGenerator {
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final SplitCharacter NO_WORD_BREAK = (start, current, end, chars, chunks) -> {
        if (chars == null || chars.length == 0) {
            return false;
        }
        if (current >= chars.length) {
            return false;
        }
        char c = chars[current];
        return Character.isWhitespace(c);
    };

    private ControlPlanPdfGenerator() {
    }

    public static void generateControlPlanPdf(ControlPlan model, Path targetPath) throws IOException, DocumentException {
        ControlPlanPdfGenerator.generateControlPlanPdf(model, targetPath, null);
    }

    public static void generateControlPlanPdf(ControlPlan model, Path targetPath, Path logoPath) throws IOException, DocumentException {
        Objects.requireNonNull(model, "Control plan is null");
        Objects.requireNonNull(targetPath, "Target path is null");
        Document document = new Document(PageSize.A2.rotate(), 24.0f, 24.0f, 24.0f, 24.0f);
        try (FileOutputStream out = new FileOutputStream(targetPath.toFile());){
            PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            ControlPlanPdfGenerator.addTitle(document, model, logoPath);
            ControlPlanPdfGenerator.addHeaderSection(document, model);
            ControlPlanPdfGenerator.addRowsSection(document, model);
            document.close();
        }
    }

    private static void addTitle(Document doc, ControlPlan model, Path logoPath) throws DocumentException {
        String subject = model.getCpPartName();
        if (subject == null || subject.isBlank()) {
            subject = model.getCpPartNumber();
        }
        if (subject == null || subject.isBlank()) {
            subject = model.getCpNumber();
        }
        subject = subject == null || subject.isBlank() ? "Control Plan" : "Control Plan for " + subject.trim();
        Paragraph title = new Paragraph(subject, FontFactory.getFont((String)"Helvetica-Bold", (float)18.0f));
        title.setAlignment(0);
        title.setSpacingAfter(6.0f);
        String subtitle = "Control Plan Number: " + ControlPlanPdfGenerator.nz(model.getCpNumber(), "N/A") + "   Revision: " + ControlPlanPdfGenerator.nz(ControlPlanPdfGenerator.resolveRevision(model), "N/A") + "   Level: " + ControlPlanPdfGenerator.nz(ControlPlanPdfGenerator.formatLevel(model.getCpLevel()), "N/A");
        Paragraph sub = new Paragraph(subtitle, FontFactory.getFont((String)"Helvetica", (float)10.0f));
        sub.setSpacingAfter(0.0f);
        PdfPTable header = new PdfPTable(new float[]{1.0f, 0.35f});
        header.setWidthPercentage(100.0f);
        PdfPCell textCell = new PdfPCell();
        textCell.setBorder(0);
        textCell.setPadding(0.0f);
        textCell.addElement((Element)title);
        textCell.addElement((Element)sub);
        header.addCell(textCell);
        PdfPCell logoCell = new PdfPCell();
        logoCell.setBorder(0);
        logoCell.setPadding(0.0f);
        logoCell.setHorizontalAlignment(2);
        logoCell.setVerticalAlignment(4);
        Image logo = PdfAssets.loadLogo(logoPath);
        if (logo != null) {
            logo.scaleToFit(140.0f, 70.0f);
            logo.setAlignment(2);
            logoCell.addElement((Element)logo);
        }
        header.addCell(logoCell);
        header.setSpacingAfter(10.0f);
        doc.add((Element)header);
    }

    private static void addHeaderSection(Document doc, ControlPlan model) throws DocumentException {
        PdfPTable table = new PdfPTable(new float[]{8.0f, 16.0f, 8.0f, 16.0f, 8.0f, 16.0f});
        float headerWidth = PageSize.A3.rotate().getWidth() - doc.leftMargin() - doc.rightMargin();
        table.setTotalWidth(headerWidth);
        table.setLockedWidth(true);
        table.setHorizontalAlignment(0);
        ControlPlanPdfGenerator.addHeaderRow(table, "Control Plan Number", ControlPlanPdfGenerator.nz(model.getCpNumber(), "-"), "Part Number", ControlPlanPdfGenerator.nz(model.getCpPartNumber(), "-"), "Part Name", ControlPlanPdfGenerator.nz(model.getCpPartName(), "-"));
        ControlPlanPdfGenerator.addHeaderRow(table, "Level", ControlPlanPdfGenerator.nz(ControlPlanPdfGenerator.formatLevel(model.getCpLevel()), "-"), "Revision", ControlPlanPdfGenerator.nz(ControlPlanPdfGenerator.resolveRevision(model), "-"), "Revision Date", ControlPlanPdfGenerator.formatDate(model.getCpRevisionDate()));
        ControlPlanPdfGenerator.addHeaderRow(table, "Date Originated", ControlPlanPdfGenerator.formatDate(model.getCpStartDate()), "Key Contact / Phone", ControlPlanPdfGenerator.nz(model.getCpKeyContact(), "-"), "Core Team", ControlPlanPdfGenerator.nz(model.getCrossFunctionalTeam(), "-"));
        ControlPlanPdfGenerator.addHeaderRow(table, "Supplier Plant", ControlPlanPdfGenerator.nz(model.getSupplierPlant(), "-"), "Supplier Code", ControlPlanPdfGenerator.nz(model.getSupplierCode(), "-"), "Customer Eng. Approval/Date", ControlPlanPdfGenerator.nz(model.getCpCustomerEngApproval(), "-"));
        ControlPlanPdfGenerator.addHeaderRow(table, "Customer Quality Approval/Date", ControlPlanPdfGenerator.nz(model.getCpCustomerQualApproval(), "-"), "Customer Other Approval/Date", ControlPlanPdfGenerator.nz(model.getCpCustomerOtherApproval(), "-"), "Supplier Plant Approval/Date", ControlPlanPdfGenerator.nz(model.getCpSupplierPlantApproval(), "-"));
        ControlPlanPdfGenerator.addHeaderRow(table, "Supplier Other Approval/Date", ControlPlanPdfGenerator.nz(model.getCpSupplierOtherApproval(), "-"), "", "", "", "");
        Paragraph caption = new Paragraph("Planning and Preparation", ControlPlanPdfGenerator.smallBold());
        caption.setSpacingBefore(4.0f);
        caption.setSpacingAfter(6.0f);
        doc.add((Element)caption);
        doc.add((Element)table);
    }

    private static void addHeaderRow(PdfPTable table, String key1, String value1, String key2, String value2, String key3, String value3) {
        table.addCell(ControlPlanPdfGenerator.labelCell(key1));
        table.addCell(ControlPlanPdfGenerator.valueCell(value1));
        table.addCell(ControlPlanPdfGenerator.labelCell(key2));
        table.addCell(ControlPlanPdfGenerator.valueCell(value2));
        table.addCell(ControlPlanPdfGenerator.labelCell(key3));
        table.addCell(ControlPlanPdfGenerator.valueCell(value3));
    }

    private static void addRowsSection(Document doc, ControlPlan model) throws DocumentException {
        List<ColumnSpec> columns = List.of(new ColumnSpec("Part/Process Number", 1.1f, row -> ControlPlanPdfGenerator.nz(row.getPartOrProcessNumber(), "-")), new ColumnSpec("Process Name / Operation Description", 1.5f, row -> ControlPlanPdfGenerator.nz(row.getProcessNameOrOperationDescription(), "-")), new ColumnSpec("Machine / Device / Jig / Tool", 1.3f, row -> ControlPlanPdfGenerator.nz(row.getMachineDeviceJigToolForMfg(), "-")), new ColumnSpec("#", 0.5f, row -> ControlPlanPdfGenerator.nz(row.getNumber(), "-")), new ColumnSpec("Product Characteristic", 1.2f, row -> ControlPlanPdfGenerator.nz(row.getProductCharacteristic(), "-")), new ColumnSpec("Process Characteristic", 1.2f, row -> ControlPlanPdfGenerator.nz(row.getProcessCharacteristic(), "-")), new ColumnSpec("CTS", 0.5f, row -> ControlPlanPdfGenerator.formatFlag(row.getIsCriticalToSafety())), new ColumnSpec("CTQ", 0.5f, row -> ControlPlanPdfGenerator.formatFlag(row.getIsCriticalToQuality())), new ColumnSpec("CTP", 0.5f, row -> ControlPlanPdfGenerator.formatFlag(row.getIsCriticalToProcess())), new ColumnSpec("Attribute", 0.6f, row -> ControlPlanPdfGenerator.formatFlag(row.getAttribute())), new ColumnSpec("Lower Limit", 0.8f, row -> ControlPlanPdfGenerator.nz(row.getLowerLimit(), "-")), new ColumnSpec("Target Value", 0.8f, row -> ControlPlanPdfGenerator.nz(row.getTargetValue(), "-")), new ColumnSpec("Upper Limit", 0.8f, row -> ControlPlanPdfGenerator.nz(row.getUpperLimit(), "-")), new ColumnSpec("Evaluation / Measurement Technique", 1.4f, row -> ControlPlanPdfGenerator.nz(row.getEvaluationMeasurementTechnique(), "-")), new ColumnSpec("Sample Size", 0.7f, row -> ControlPlanPdfGenerator.nz(row.getSampleSize(), "-")), new ColumnSpec("Sample Frequency", 0.8f, row -> ControlPlanPdfGenerator.nz(row.getSampleFrequency(), "-")), new ColumnSpec("Control Method", 1.2f, row -> ControlPlanPdfGenerator.nz(row.getControlMethod(), "-")), new ColumnSpec("Reaction Plan", 1.4f, row -> ControlPlanPdfGenerator.nz(row.getReactionPlan(), "-")));
        ArrayList<ColumnSpec> active = new ArrayList<ColumnSpec>();
        for (ColumnSpec spec : columns) {
            if (!ControlPlanPdfGenerator.hasAnyData(model.getControlChains(), spec)) continue;
            active.add(spec);
        }
        if (active.isEmpty()) {
            Paragraph empty = new Paragraph("No control plan rows available.", ControlPlanPdfGenerator.small());
            empty.setSpacingBefore(8.0f);
            doc.add((Element)empty);
            return;
        }
        PdfPTable table = new PdfPTable(active.size());
        float[] widths = new float[active.size()];
        for (int i = 0; i < active.size(); ++i) {
            widths[i] = ((ColumnSpec)active.get((int)i)).weight;
        }
        table.setWidths(widths);
        float availableWidth = doc.getPageSize().getWidth() - doc.leftMargin() - doc.rightMargin();
        table.setTotalWidth(availableWidth);
        table.setLockedWidth(true);
        for (ColumnSpec columnSpec : active) {
            PdfPCell header = new PdfPCell(ControlPlanPdfGenerator.noBreakPhrase(columnSpec.title, ControlPlanPdfGenerator.smallBold()));
            header.setHorizontalAlignment(1);
            header.setVerticalAlignment(5);
            header.setUseAscender(true);
            header.setUseDescender(true);
            table.addCell(header);
        }
        int rowIndex = 0;
        for (ControlPlanRow row2 : model.getControlChains()) {
            boolean zebra = rowIndex++ % 2 == 1;
            for (ColumnSpec spec : active) {
                String value = spec.extractor.apply(row2);
                PdfPCell cell = new PdfPCell(ControlPlanPdfGenerator.noBreakPhrase(ControlPlanPdfGenerator.nz(value, "-"), ControlPlanPdfGenerator.small()));
                ControlPlanPdfGenerator.styleDataCell(cell, zebra);
                table.addCell(cell);
            }
        }
        Paragraph paragraph = new Paragraph("Control Plan Items", ControlPlanPdfGenerator.smallBold());
        paragraph.setSpacingBefore(10.0f);
        paragraph.setSpacingAfter(6.0f);
        doc.add((Element)paragraph);
        doc.add((Element)table);
    }

    private static boolean hasAnyData(Iterable<ControlPlanRow> rows, ColumnSpec spec) {
        for (ControlPlanRow row : rows) {
            String value = spec.extractor.apply(row);
            if (value == null || value.isBlank() || "-".equals(value.trim())) continue;
            return true;
        }
        return false;
    }

    private static void styleDataCell(PdfPCell cell, boolean zebra) {
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setPadding(3.0f);
        cell.setBorderWidth(0.5f);
        cell.setUseAscender(true);
        cell.setUseDescender(true);
        if (zebra) {
            cell.setGrayFill(0.95f);
        }
    }

    private static PdfPCell labelCell(String text) {
        PdfPCell c = new PdfPCell(ControlPlanPdfGenerator.noBreakPhrase(ControlPlanPdfGenerator.nz(text, ""), ControlPlanPdfGenerator.smallBold()));
        c.setHorizontalAlignment(2);
        c.setVerticalAlignment(5);
        c.setUseAscender(true);
        c.setUseDescender(true);
        return c;
    }

    private static PdfPCell valueCell(String text) {
        PdfPCell c = new PdfPCell(ControlPlanPdfGenerator.noBreakPhrase(ControlPlanPdfGenerator.nz(text, "-"), ControlPlanPdfGenerator.small()));
        c.setHorizontalAlignment(0);
        c.setVerticalAlignment(5);
        c.setUseAscender(true);
        c.setUseDescender(true);
        return c;
    }

    private static String formatFlag(Boolean flag) {
        return flag == null ? "-" : (flag != false ? "Yes" : "No");
    }

    private static String formatLevel(ControlPlanLevel level) {
        return level == null ? "" : level.getDisplayName();
    }

    private static String resolveRevision(ControlPlan model) {
        if (model.getCpRevision() != null && !model.getCpRevision().trim().isEmpty()) {
            return model.getCpRevision().trim();
        }
        return model.latestApprovedRevision().map(RevisionEntry::getRevisionNumber).filter(rev -> rev != null && !rev.trim().isEmpty()).map(String::trim).orElse("");
    }

    private static String formatDate(LocalDate date) {
        return date == null ? "-" : DATE_FMT.format(date);
    }

    private static String nz(String value, String fallback) {
        if (value == null) {
            return fallback;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? fallback : trimmed;
    }

    private static Font small() {
        return FontFactory.getFont((String)"Helvetica", (float)8.0f);
    }

    private static Font smallBold() {
        return FontFactory.getFont((String)"Helvetica-Bold", (float)8.0f);
    }

    private static Phrase noBreakPhrase(String value, Font font) {
        Phrase phrase = new Phrase();
        Chunk chunk = new Chunk(ControlPlanPdfGenerator.nz(value, "-"), font);
        chunk.setSplitCharacter(NO_WORD_BREAK);
        phrase.add((Element)chunk);
        return phrase;
    }

    private record ColumnSpec(String title, float weight, Function<ControlPlanRow, String> extractor) {
    }
}

