/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.eightd.EightD;
import com.qualidadeeprodutividade.eightd.EightDContainmentInventoryRow;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import javafx.util.converter.IntegerStringConverter;

public class ContainmentWindowController {
    private static final List<String> FIXED_LOCATIONS = List.of("At Customer", "In Transit to Customer", "Customer Service Parts Operations", "Finished Goods", "Assembly Lines", "Other Work In Process", "Lineside storage", "Rework Areas", "Scrap Bins", "Material storage racks", "Warehouse", "In transit from supplier", "Supplier location", "Supplier location (sub-supplier in transit to supplier)", "Other");
    @FXML
    private AnchorPane root;
    @FXML
    private Button btnSaveOnly;
    @FXML
    private Button btnSaveExit;
    @FXML
    private TextField txtContainmentChampion;
    @FXML
    private TextField txtIssueNumber;
    @FXML
    private DatePicker dpContainmentDate;
    @FXML
    private TextField txtProductName;
    @FXML
    private TextField txtPartNumber;
    @FXML
    private TextArea txtProductNonconformance;
    @FXML
    private TextArea txtContainmentInstructions;
    @FXML
    private TextField txtSegregateTo;
    @FXML
    private TextField txtIdentificationConforming;
    @FXML
    private TextField txtIdentificationNonConforming;
    @FXML
    private TextField txtQualityManager;
    @FXML
    private TableView<EightDContainmentInventoryRow> tblInventory;
    @FXML
    private TableColumn<EightDContainmentInventoryRow, String> colLocation;
    @FXML
    private TableColumn<EightDContainmentInventoryRow, Integer> colPotentialQty;
    @FXML
    private TableColumn<EightDContainmentInventoryRow, Integer> colQtyFound;
    @FXML
    private TableColumn<EightDContainmentInventoryRow, Integer> colSuspectQty;
    @FXML
    private TableColumn<EightDContainmentInventoryRow, String> colLotChecked;
    @FXML
    private TableColumn<EightDContainmentInventoryRow, String> colResponsible;
    private final ObservableList<EightDContainmentInventoryRow> tableRows = FXCollections.observableArrayList();
    private final EightDContainmentInventoryRow totalRow = new EightDContainmentInventoryRow("Total", true);
    private final List<Runnable> bindingCleanups = new ArrayList<Runnable>();
    private final List<Runnable> rowListenerCleanups = new ArrayList<Runnable>();
    private Image icSave;
    private Image icExit;
    private Stage ownerStage;
    private EightD report;
    private Runnable saveAction = () -> {};
    private Runnable dirtyHook = () -> {};

    @FXML
    private void initialize() {
        this.loadIcons();
        this.configureButtons();
        this.configureTable();
        this.applyDefaultTooltips();
    }

    public void setOwnerStage(Stage stage) {
        this.ownerStage = stage;
        if (stage != null) {
            stage.setResizable(false);
        }
    }

    public void setSaveAction(Runnable saveAction) {
        this.saveAction = saveAction == null ? () -> {} : saveAction;
    }

    public void setDirtyHook(Runnable dirtyHook) {
        this.dirtyHook = dirtyHook == null ? () -> {} : dirtyHook;
    }

    public void setEightD(EightD report) {
        this.clearBindings();
        this.report = report;
        if (report == null) {
            if (this.tblInventory != null) {
                this.tblInventory.setItems(FXCollections.observableArrayList());
            }
            return;
        }
        this.bindTextField(this.txtContainmentChampion, report.d3ContainmentChampionProperty());
        this.bindTextField(this.txtIssueNumber, report.d3ContainmentIssueNumberProperty());
        this.bindDate(this.dpContainmentDate, report.d3ContainmentDateProperty());
        this.bindTextField(this.txtProductName, report.d3ContainmentProductNameProperty());
        this.bindTextField(this.txtPartNumber, report.d3ContainmentPartNumberProperty());
        this.bindTextArea(this.txtProductNonconformance, report.d3ContainmentProductNonconformanceProperty());
        this.bindTextArea(this.txtContainmentInstructions, report.d3ContainmentInstructionsProperty());
        this.bindTextField(this.txtSegregateTo, report.d3ContainmentSegregateToProperty());
        this.bindTextField(this.txtIdentificationConforming, report.d3ContainmentIdentificationConformingProperty());
        this.bindTextField(this.txtIdentificationNonConforming, report.d3ContainmentIdentificationNonConformingProperty());
        this.bindTextField(this.txtQualityManager, report.d3ContainmentQualityManagerProperty());
        this.ensureFixedInventoryRows(report.getD3ContainmentInventoryRows());
        this.bindInventoryRows(report.getD3ContainmentInventoryRows());
        this.rebuildTableRows();
        this.updateTotals();
    }

    private void clearBindings() {
        this.bindingCleanups.forEach(Runnable::run);
        this.bindingCleanups.clear();
        this.clearRowListeners();
    }

    private void clearRowListeners() {
        this.rowListenerCleanups.forEach(Runnable::run);
        this.rowListenerCleanups.clear();
    }

    private void bindTextField(TextField field, StringProperty property) {
        if (field == null || property == null) {
            return;
        }
        field.textProperty().bindBidirectional((Property)property);
        ChangeListener listener = (obs, oldV, newV) -> this.markDirty();
        property.addListener(listener);
        this.bindingCleanups.add(() -> {
            field.textProperty().unbindBidirectional((Property)property);
            property.removeListener(listener);
        });
    }

    private void bindTextArea(TextArea area, StringProperty property) {
        if (area == null || property == null) {
            return;
        }
        area.textProperty().bindBidirectional((Property)property);
        ChangeListener listener = (obs, oldV, newV) -> this.markDirty();
        property.addListener(listener);
        this.bindingCleanups.add(() -> {
            area.textProperty().unbindBidirectional((Property)property);
            property.removeListener(listener);
        });
    }

    private void bindDate(DatePicker picker, ObjectProperty<LocalDate> property) {
        if (picker == null || property == null) {
            return;
        }
        picker.valueProperty().bindBidirectional(property);
        ChangeListener listener = (obs, oldV, newV) -> this.markDirty();
        property.addListener(listener);
        this.bindingCleanups.add(() -> {
            picker.valueProperty().unbindBidirectional((Property)property);
            property.removeListener(listener);
        });
    }

    private void ensureFixedInventoryRows(ObservableList<EightDContainmentInventoryRow> rows) {
        if (rows == null) {
            return;
        }
        LinkedHashMap<String, EightDContainmentInventoryRow> existing = new LinkedHashMap<String, EightDContainmentInventoryRow>();
        for (EightDContainmentInventoryRow row : rows) {
            String location;
            if (row == null || row.isTotalRow() || (location = row.getLocation()) == null || location.isBlank() || existing.containsKey(location)) continue;
            existing.put(location, row);
        }
        rows.clear();
        for (String location : FIXED_LOCATIONS) {
            EightDContainmentInventoryRow row = (EightDContainmentInventoryRow)existing.get(location);
            if (row == null) {
                row = new EightDContainmentInventoryRow(location);
            }
            row.setLocation(location);
            row.setTotalRow(false);
            rows.add((Object)row);
        }
    }

    private void bindInventoryRows(ObservableList<EightDContainmentInventoryRow> rows) {
        if (rows == null) {
            return;
        }
        this.attachRowListeners(rows);
        ListChangeListener listListener = change -> {
            this.attachRowListeners(rows);
            this.rebuildTableRows();
            this.updateTotals();
            this.markDirty();
        };
        rows.addListener(listListener);
        this.bindingCleanups.add(() -> rows.removeListener(listListener));
    }

    private void attachRowListeners(ObservableList<EightDContainmentInventoryRow> rows) {
        this.clearRowListeners();
        if (rows == null) {
            return;
        }
        for (EightDContainmentInventoryRow row : rows) {
            if (row == null || row.isTotalRow()) continue;
            ChangeListener qtyListener = (obs, oldV, newV) -> {
                this.updateTotals();
                this.markDirty();
            };
            row.potentialQtyProperty().addListener(qtyListener);
            row.qtyFoundProperty().addListener(qtyListener);
            row.suspectQtyProperty().addListener(qtyListener);
            this.rowListenerCleanups.add(() -> {
                row.potentialQtyProperty().removeListener(qtyListener);
                row.qtyFoundProperty().removeListener(qtyListener);
                row.suspectQtyProperty().removeListener(qtyListener);
            });
        }
    }

    private void configureButtons() {
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setOnAction(e -> this.onSaveOnly());
            this.btnSaveOnly.setGraphic((Node)this.icon(this.icSave, 18.0));
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setOnAction(e -> this.onSaveAndExit());
            this.btnSaveExit.setGraphic((Node)this.icon(this.icExit, 18.0));
        }
    }

    private void configureTable() {
        if (this.tblInventory == null) {
            return;
        }
        this.tblInventory.setEditable(true);
        this.tblInventory.getSelectionModel().setCellSelectionEnabled(true);
        this.tblInventory.setItems(this.tableRows);
        this.tblInventory.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        for (TableColumn column : this.tblInventory.getColumns()) {
            this.setColumnEditableRecursive(column, true);
        }
        if (this.colLocation != null) {
            this.colLocation.setSortable(false);
            this.colLocation.setEditable(false);
            this.colLocation.setCellValueFactory(c -> ((EightDContainmentInventoryRow)c.getValue()).locationProperty());
            this.colLocation.setCellFactory(col -> new TableCell<EightDContainmentInventoryRow, String>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                protected void updateItem(String item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    this.setAlignment(Pos.CENTER_RIGHT);
                    if (empty) {
                        this.setText(null);
                        return;
                    }
                    this.setText(item == null ? "" : item);
                }
            });
        }
        this.configureQtyColumn(this.colPotentialQty, EightDContainmentInventoryRow::potentialQtyProperty);
        this.configureQtyColumn(this.colQtyFound, EightDContainmentInventoryRow::qtyFoundProperty);
        this.configureQtyColumn(this.colSuspectQty, EightDContainmentInventoryRow::suspectQtyProperty);
        this.configureTextColumn(this.colLotChecked, EightDContainmentInventoryRow::lotCheckedProperty, Pos.CENTER);
        this.configureTextColumn(this.colResponsible, EightDContainmentInventoryRow::responsibleProperty, Pos.CENTER);
        this.tblInventory.setRowFactory(tv -> new TableRow<EightDContainmentInventoryRow>(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void updateItem(EightDContainmentInventoryRow item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setStyle("");
                    return;
                }
                this.setStyle(item.isTotalRow() ? "-fx-font-weight: bold;" : "");
            }
        });
        this.tblInventory.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.F2) {
                this.startEditingSelectedInventoryCell();
                event.consume();
            }
        });
        this.tblInventory.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2) {
                this.startEditingSelectedInventoryCell();
            }
        });
    }

    private void startEditingSelectedInventoryCell() {
        TablePosition first;
        ObservableList selectedCells;
        TablePosition focused;
        if (this.tblInventory == null || this.tblInventory.getSelectionModel() == null) {
            return;
        }
        int rowIndex = -1;
        int columnIndex = -1;
        if (this.tblInventory.getFocusModel() != null && (focused = this.tblInventory.getFocusModel().getFocusedCell()) != null) {
            rowIndex = focused.getRow();
            columnIndex = focused.getColumn();
        }
        if (!(rowIndex >= 0 && columnIndex >= 0 || (selectedCells = this.tblInventory.getSelectionModel().getSelectedCells()) == null || selectedCells.isEmpty() || (first = (TablePosition)selectedCells.get(0)) == null)) {
            rowIndex = first.getRow();
            columnIndex = first.getColumn();
        }
        if (rowIndex < 0 || columnIndex < 0) {
            return;
        }
        TableColumn column = null;
        if (columnIndex >= 0 && columnIndex < this.tblInventory.getVisibleLeafColumns().size()) {
            column = this.tblInventory.getVisibleLeafColumn(columnIndex);
        }
        if (!this.canEditInventoryCell(rowIndex, column)) {
            return;
        }
        this.tblInventory.requestFocus();
        this.tblInventory.getSelectionModel().clearAndSelect(rowIndex, column);
        if (this.tblInventory.getFocusModel() != null) {
            this.tblInventory.getFocusModel().focus(rowIndex, column);
        }
        this.tblInventory.edit(rowIndex, column);
    }

    private boolean canEditInventoryCell(int rowIndex, TableColumn<EightDContainmentInventoryRow, ?> column) {
        if (this.tblInventory == null || column == null || rowIndex < 0) {
            return false;
        }
        if (!this.tblInventory.isEditable() || !column.isEditable()) {
            return false;
        }
        ObservableList items = this.tblInventory.getItems();
        if (items == null || rowIndex >= items.size()) {
            return false;
        }
        EightDContainmentInventoryRow row = (EightDContainmentInventoryRow)items.get(rowIndex);
        return row != null && !row.isTotalRow();
    }

    private void setColumnEditableRecursive(TableColumn<EightDContainmentInventoryRow, ?> column, boolean editable) {
        if (column == null) {
            return;
        }
        column.setEditable(editable);
        for (TableColumn child : column.getColumns()) {
            this.setColumnEditableRecursive(child, editable);
        }
    }

    private void configureQtyColumn(TableColumn<EightDContainmentInventoryRow, Integer> column, Function<EightDContainmentInventoryRow, IntegerProperty> propertyFactory) {
        if (column == null || propertyFactory == null) {
            return;
        }
        column.setSortable(false);
        column.setEditable(true);
        column.setStyle("-fx-alignment: CENTER;");
        column.setCellValueFactory(c -> ((IntegerProperty)propertyFactory.apply((EightDContainmentInventoryRow)c.getValue())).asObject());
        column.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new IntegerStringConverter()));
        column.setOnEditStart(event -> {
            EightDContainmentInventoryRow row = (EightDContainmentInventoryRow)event.getRowValue();
            if (row == null || row.isTotalRow()) {
                event.consume();
                Platform.runLater(() -> {
                    if (this.tblInventory != null) {
                        this.tblInventory.edit(-1, null);
                    }
                });
            }
        });
        column.setOnEditCommit(event -> {
            EightDContainmentInventoryRow row = (EightDContainmentInventoryRow)event.getRowValue();
            if (row == null || row.isTotalRow()) {
                return;
            }
            Integer newValue = (Integer)event.getNewValue();
            ((IntegerProperty)propertyFactory.apply(row)).set(newValue == null ? 0 : Math.max(0, newValue));
            this.updateTotals();
            this.markDirty();
        });
    }

    private void configureTextColumn(TableColumn<EightDContainmentInventoryRow, String> column, Function<EightDContainmentInventoryRow, StringProperty> propertyFactory, Pos alignment) {
        if (column == null || propertyFactory == null) {
            return;
        }
        column.setSortable(false);
        column.setEditable(true);
        if (alignment == Pos.CENTER) {
            column.setStyle("-fx-alignment: CENTER;");
        }
        column.setCellValueFactory(c -> (ObservableValue)propertyFactory.apply((EightDContainmentInventoryRow)c.getValue()));
        column.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new DefaultStringConverter()));
        column.setOnEditStart(event -> {
            EightDContainmentInventoryRow row = (EightDContainmentInventoryRow)event.getRowValue();
            if (row == null || row.isTotalRow()) {
                event.consume();
                Platform.runLater(() -> {
                    if (this.tblInventory != null) {
                        this.tblInventory.edit(-1, null);
                    }
                });
            }
        });
        column.setOnEditCommit(event -> {
            EightDContainmentInventoryRow row = (EightDContainmentInventoryRow)event.getRowValue();
            if (row == null || row.isTotalRow()) {
                return;
            }
            ((StringProperty)propertyFactory.apply(row)).set((Object)(event.getNewValue() == null ? "" : (String)event.getNewValue()));
            this.markDirty();
        });
    }

    private void rebuildTableRows() {
        if (this.report == null || this.report.getD3ContainmentInventoryRows() == null) {
            this.tableRows.setAll((Object[])new EightDContainmentInventoryRow[0]);
            return;
        }
        this.tableRows.setAll(this.report.getD3ContainmentInventoryRows());
        this.totalRow.setTotalRow(true);
        this.totalRow.setLocation("Total");
        this.tableRows.add((Object)this.totalRow);
        if (this.tblInventory != null) {
            this.tblInventory.refresh();
        }
    }

    private void updateTotals() {
        if (this.report == null || this.report.getD3ContainmentInventoryRows() == null) {
            this.totalRow.setPotentialQty(0);
            this.totalRow.setQtyFound(0);
            this.totalRow.setSuspectQty(0);
            return;
        }
        int potential = 0;
        int found = 0;
        int suspect = 0;
        for (EightDContainmentInventoryRow row : this.report.getD3ContainmentInventoryRows()) {
            if (row == null || row.isTotalRow()) continue;
            potential += Math.max(0, row.getPotentialQty());
            found += Math.max(0, row.getQtyFound());
            suspect += Math.max(0, row.getSuspectQty());
        }
        this.totalRow.setPotentialQty(potential);
        this.totalRow.setQtyFound(found);
        this.totalRow.setSuspectQty(suspect);
        this.totalRow.setLotChecked("");
        this.totalRow.setResponsible("");
        if (this.tblInventory != null) {
            this.tblInventory.refresh();
        }
    }

    private void markDirty() {
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private void applyDefaultTooltips() {
        this.ensureTooltip(this.btnSaveOnly, "Save");
        this.ensureTooltip(this.btnSaveExit, "Save and close");
    }

    private void ensureTooltip(Button btn, String fallbackText) {
        if (btn == null) {
            return;
        }
        Tooltip tip = btn.getTooltip();
        if (tip == null || tip.getText() == null || tip.getText().isBlank()) {
            btn.setTooltip(new Tooltip(fallbackText));
        }
    }

    private void loadIcons() {
        this.icSave = this.loadIcon("save", 18.0);
        this.icExit = this.loadIcon("exit", 18.0);
    }

    private Image loadIcon(String name, double size) {
        InputStream stream = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        if (stream == null) {
            return null;
        }
        return new Image(stream, size, size, true, true);
    }

    private ImageView icon(Image img, double size) {
        if (img == null) {
            return null;
        }
        ImageView iv = new ImageView(img);
        iv.setPreserveRatio(true);
        iv.setFitWidth(size);
        iv.setFitHeight(size);
        iv.setSmooth(true);
        return iv;
    }

    private void onSaveOnly() {
        this.runSave();
    }

    private void onSaveAndExit() {
        if (this.runSave()) {
            this.closeWindow();
        }
    }

    private boolean runSave() {
        if (this.report == null) {
            return true;
        }
        try {
            this.saveAction.run();
            return true;
        }
        catch (Exception ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Save error");
            alert.setHeaderText("Failed to save project");
            alert.setContentText(ex.getMessage());
            if (this.ownerStage != null) {
                alert.initOwner((Window)this.ownerStage);
            }
            alert.showAndWait();
            return false;
        }
    }

    private void closeWindow() {
        Stage stage = this.ownerStage;
        if (stage == null && this.root != null && this.root.getScene() != null) {
            stage = (Stage)this.root.getScene().getWindow();
        }
        if (stage != null) {
            stage.close();
        }
    }
}

