/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.controlPlan.ControlPlan;
import com.qualidadeeprodutividade.controlPlan.ControlPlanExcelExporter;
import com.qualidadeeprodutividade.controlPlan.ControlPlanLevel;
import com.qualidadeeprodutividade.controlPlan.ControlPlanPdfGenerator;
import com.qualidadeeprodutividade.controlPlan.ControlPlanRow;
import com.qualidadeeprodutividade.controllers.util.MentionSuggestionBehavior;
import com.qualidadeeprodutividade.controllers.util.TableClipboardHelper;
import com.qualidadeeprodutividade.controllers.util.TableSearchNavigator;
import com.qualidadeeprodutividade.controllers.util.TableUtils;
import com.qualidadeeprodutividade.controllers.util.WrapTextAreaTableCell;
import com.qualidadeeprodutividade.export.ExportDirectoryPreferences;
import com.qualidadeeprodutividade.export.ExportFileNameUtil;
import com.qualidadeeprodutividade.export.ExportLogoPreferences;
import com.qualidadeeprodutividade.fmea.ApprovalStatus;
import com.qualidadeeprodutividade.fmea.RevisionEntry;
import com.qualidadeeprodutividade.item.Characteristic;
import com.qualidadeeprodutividade.item.Item;
import com.qualidadeeprodutividade.processItem.Parameter;
import com.qualidadeeprodutividade.processItem.ProcessItem;
import com.qualidadeeprodutividade.processItem.ProcessType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.openpdf.text.DocumentException;

public class ControlPlanWindowController
implements Initializable {
    private static final String SEARCH_HIGHLIGHT_STYLE = "-fx-background-color: #fff9c4;";
    private static final String SEARCH_HIGHLIGHT_SELECTED_STYLE = "-fx-background-color: -fx-selection-bar, rgba(255,249,196,0.65); -fx-background-insets: 0, 0;";
    private static final String HSCROLL_CACHE_KEY = "controlplan-horizontal-scrollbar";
    @FXML
    private BorderPane root;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab tabDfmeaHeader;
    @FXML
    private Button btnAddControlChain;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnExportToPDF;
    @FXML
    private Button btnSaveOnly;
    @FXML
    private Button btnSaveExit;
    @FXML
    private ImageView imgHeaderIcon;
    @FXML
    private ComboBox<ControlPlanLevel> cbControlPlanLevel;
    @FXML
    private TextField txtControlPlanNumber;
    @FXML
    private TextField txtPartNumber;
    @FXML
    private TextField txtPartName;
    @FXML
    private TextField txtOrganizationPlant;
    @FXML
    private TextField txtOrganizationCode;
    @FXML
    private TextField txtKeyContact;
    @FXML
    private TextField txtCoreTeam;
    @FXML
    private TextField txtOrgPlantApproval;
    @FXML
    private TextField txtOtherApproval;
    @FXML
    private TextField txtCustomerEngApproval;
    @FXML
    private TextField txtCustomerQualityApproval;
    @FXML
    private DatePicker dtDateOriginated;
    @FXML
    private DatePicker dtRevision;
    @FXML
    private TableView<ControlPlanRow> tblControlChains;
    @FXML
    private TableColumn<ControlPlanRow, String> colPartOrProcessNumber;
    @FXML
    private TableColumn<ControlPlanRow, String> colProcessName;
    @FXML
    private TableColumn<ControlPlanRow, String> colMachineDevice;
    @FXML
    private TableColumn<ControlPlanRow, String> colCharacteristicNumber;
    @FXML
    private TableColumn<ControlPlanRow, String> colCharacteristicProduct;
    @FXML
    private TableColumn<ControlPlanRow, String> colCharacteristicProcess;
    @FXML
    private TableColumn<ControlPlanRow, Boolean> colCriticalToSafety;
    @FXML
    private TableColumn<ControlPlanRow, Boolean> colCriticalToQuality;
    @FXML
    private TableColumn<ControlPlanRow, Boolean> colCriticalToProcess;
    @FXML
    private TableColumn<ControlPlanRow, Boolean> colAttribute;
    @FXML
    private TableColumn<ControlPlanRow, String> colTargetValue;
    @FXML
    private TableColumn<ControlPlanRow, String> colLowerLimit;
    @FXML
    private TableColumn<ControlPlanRow, String> colUpperLimit;
    @FXML
    private TableColumn<ControlPlanRow, String> colEvaluationTechnique;
    @FXML
    private TableColumn<ControlPlanRow, String> colSampleSize;
    @FXML
    private TableColumn<ControlPlanRow, String> colSampleFrequency;
    @FXML
    private TableColumn<ControlPlanRow, String> colControlMethod;
    @FXML
    private TableColumn<ControlPlanRow, String> colReactionPlan;
    @FXML
    private TextField txtSearch;
    @FXML
    private Button btnNext;
    @FXML
    private TableView<RevisionEntry> tblRevisions;
    @FXML
    private TableColumn<RevisionEntry, String> colRevNumber;
    @FXML
    private TableColumn<RevisionEntry, LocalDate> colRevDate;
    @FXML
    private TableColumn<RevisionEntry, String> colRevAuthor;
    @FXML
    private TableColumn<RevisionEntry, String> colRevDesc;
    @FXML
    private TableColumn<RevisionEntry, ApprovalStatus> colRevStatus;
    @FXML
    private Button btnRevAdd;
    @FXML
    private Button btnRevEdit;
    @FXML
    private Button btnRevApprove;
    @FXML
    private Button btnRevDelete;
    private Image icControlChain;
    private Image icTrash;
    private Image icPdf;
    private Image icSave;
    private Image icExit;
    private Image icPlus;
    private Image icApprove;
    private Image icEdit;
    private Image icSearch;
    private Stage ownerStage;
    private boolean hasUnsavedChanges = false;
    private boolean programmaticClose = false;
    private ControlPlan controlPlan;
    private TableSearchNavigator<ControlPlanRow> controlPlanSearch;
    private Pattern searchHighlightPattern;
    private final List<Runnable> bindingCleanups = new ArrayList<Runnable>();
    private boolean syncing = false;
    private boolean revisionTabConfigured = false;
    private final List<Item> productRoots = new ArrayList<Item>();
    private final List<ProcessItem> processRoots = new ArrayList<ProcessItem>();
    private final List<String> partNumberSuggestions = new ArrayList<String>();
    private final List<String> processOperationSuggestions = new ArrayList<String>();
    private final List<String> productCharacteristicSuggestions = new ArrayList<String>();
    private final List<String> processParameterSuggestions = new ArrayList<String>();
    private final Map<String, Characteristic> productCharacteristicLookup = new HashMap<String, Characteristic>();
    private final Map<String, Parameter> processParameterLookup = new HashMap<String, Parameter>();
    private final Map<TableColumn<ControlPlanRow, String>, SuggestionProvider> mentionProviders = new HashMap<TableColumn<ControlPlanRow, String>, SuggestionProvider>();
    private static final int MAX_CONTROL_PLAN_UNDO = 50;
    private final Deque<Runnable> controlPlanUndoStack = new ArrayDeque<Runnable>();
    private Runnable saveAction;
    private Runnable dirtyHook = () -> {
        this.hasUnsavedChanges = true;
    };
    private static final StringConverter<ControlPlanLevel> LEVEL_CONVERTER = new StringConverter<ControlPlanLevel>(){

        public String toString(ControlPlanLevel level) {
            return level == null ? "" : level.getDisplayName();
        }

        public ControlPlanLevel fromString(String string) {
            if (string == null || string.isBlank()) {
                return null;
            }
            String trimmed = string.trim();
            for (ControlPlanLevel lvl : ControlPlanLevel.values()) {
                if (!lvl.getDisplayName().equalsIgnoreCase(trimmed) && !lvl.name().equalsIgnoreCase(trimmed)) continue;
                return lvl;
            }
            return null;
        }
    };

    public void initialize(URL location, ResourceBundle resources) {
        this.loadIcons();
        this.configureHeaderIcon();
        this.configureMentionProviders();
        this.applyHeaderReadOnlyMode();
        if (this.cbControlPlanLevel != null) {
            this.cbControlPlanLevel.setItems(FXCollections.observableArrayList((Object[])ControlPlanLevel.values()));
            this.cbControlPlanLevel.setConverter(LEVEL_CONVERTER);
        }
        if (this.btnAddControlChain != null) {
            this.btnAddControlChain.setOnAction(e -> this.onAddRow());
            this.btnAddControlChain.setGraphic((Node)this.icon(this.icControlChain, 18.0));
        }
        if (this.btnDelete != null) {
            this.btnDelete.setOnAction(e -> this.onDeleteRow());
            this.btnDelete.setGraphic((Node)this.icon(this.icTrash, 18.0));
        }
        if (this.btnExportToPDF != null) {
            this.btnExportToPDF.setOnAction(e -> this.onExport());
            this.btnExportToPDF.setGraphic((Node)this.icon(this.icPdf, 16.0));
        }
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setOnAction(e -> this.onSaveOnly());
            this.btnSaveOnly.setTooltip(new Tooltip("Save current control plan"));
            this.btnSaveOnly.setGraphic((Node)this.icon(this.icSave, 18.0));
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setOnAction(e -> this.onSaveAndExit());
            this.btnSaveExit.setTooltip(new Tooltip("Save and close the current control plan"));
            this.btnSaveExit.setGraphic((Node)this.icon(this.icExit, 18.0));
        }
        if (this.tblControlChains != null) {
            this.tblControlChains.setEditable(true);
            this.tblControlChains.setFixedCellSize(-1.0);
            this.tblControlChains.getSelectionModel().setCellSelectionEnabled(true);
            this.tblControlChains.setPlaceholder((Node)new Label("No control items added."));
            this.tblControlChains.getSelectionModel().selectedItemProperty().addListener((obs, ov, nv) -> this.updateDeleteButtonState());
            this.tblControlChains.editingCellProperty().addListener((obs, ov, nv) -> this.updateDeleteButtonState());
            this.stringColumn(this.colPartOrProcessNumber, ControlPlanRow::partOrProcessNumberProperty);
            this.stringColumn(this.colProcessName, ControlPlanRow::processNameOrOperationDescriptionProperty);
            this.stringColumn(this.colMachineDevice, ControlPlanRow::machineDeviceJigToolForMfgProperty);
            this.stringColumn(this.colCharacteristicNumber, ControlPlanRow::numberProperty);
            this.stringColumn(this.colCharacteristicProduct, ControlPlanRow::productCharacteristicProperty);
            this.stringColumn(this.colCharacteristicProcess, ControlPlanRow::processCharacteristicProperty);
            this.booleanColumn(this.colCriticalToSafety, ControlPlanRow::isCriticalToSafetyProperty);
            this.booleanColumn(this.colCriticalToQuality, ControlPlanRow::isCriticalToQualityProperty);
            this.booleanColumn(this.colCriticalToProcess, ControlPlanRow::isCriticalToProcessProperty);
            this.booleanColumn(this.colAttribute, ControlPlanRow::attributeProperty);
            this.stringColumn(this.colTargetValue, ControlPlanRow::targetValueProperty);
            this.stringColumn(this.colLowerLimit, ControlPlanRow::lowerLimitProperty);
            this.stringColumn(this.colUpperLimit, ControlPlanRow::upperLimitProperty);
            this.stringColumn(this.colEvaluationTechnique, ControlPlanRow::evaluationMeasurementTechniqueProperty);
            this.stringColumn(this.colSampleSize, ControlPlanRow::sampleSizeProperty);
            this.stringColumn(this.colSampleFrequency, ControlPlanRow::sampleFrequencyProperty);
            this.stringColumn(this.colControlMethod, ControlPlanRow::controlMethodProperty);
            this.stringColumn(this.colReactionPlan, ControlPlanRow::reactionPlanProperty);
            this.tblControlChains.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
                if (e.getCode() == KeyCode.ENTER && this.tblControlChains.getEditingCell() == null) {
                    TablePosition raw;
                    TablePosition pos = null;
                    if (this.tblControlChains.getFocusModel() != null && (raw = this.tblControlChains.getFocusModel().getFocusedCell()) != null && raw.getTableColumn() != null) {
                        TablePosition tmp;
                        pos = tmp = raw;
                    }
                    if (pos != null && pos.getTableColumn() != null) {
                        this.tblControlChains.edit(pos.getRow(), pos.getTableColumn());
                        e.consume();
                    }
                }
            });
            this.tblControlChains.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
                int row;
                TablePosition raw;
                if (e.isControlDown() && e.getCode() == KeyCode.Z) {
                    TablePosition<ControlPlanRow, ?> snapshot = this.captureControlPlanFocus();
                    if (this.performControlPlanUndo()) {
                        this.restoreControlPlanFocus(snapshot);
                    }
                    e.consume();
                    return;
                }
                if (e.getCode() == KeyCode.DELETE && this.tblControlChains.getEditingCell() == null) {
                    TablePosition<ControlPlanRow, ?> snapshot = this.captureControlPlanFocus();
                    boolean changed = TableClipboardHelper.clearFocusedCell(this.tblControlChains, this::pushControlPlanUndo);
                    if (changed) {
                        this.markDirty();
                    }
                    this.restoreControlPlanFocus(snapshot);
                    e.consume();
                    return;
                }
                if (e.getCode() == KeyCode.ESCAPE && this.tblControlChains.getEditingCell() == null) {
                    e.consume();
                    return;
                }
                if (e.getCode() != KeyCode.TAB || this.tblControlChains.getEditingCell() != null) {
                    return;
                }
                TablePosition pos = null;
                if (this.tblControlChains.getFocusModel() != null && (raw = this.tblControlChains.getFocusModel().getFocusedCell()) != null && raw.getTableColumn() != null) {
                    TablePosition tmp;
                    pos = tmp = raw;
                }
                if ((row = pos != null && pos.getRow() >= 0 ? pos.getRow() : this.tblControlChains.getSelectionModel().getSelectedIndex()) < 0 && !this.tblControlChains.getItems().isEmpty()) {
                    row = 0;
                }
                if (row < 0) {
                    return;
                }
                int colIndex = -1;
                if (pos != null && pos.getTableColumn() != null) {
                    colIndex = this.tblControlChains.getVisibleLeafIndex(pos.getTableColumn());
                } else {
                    TablePosition first;
                    Object patt0$temp;
                    ObservableList rawCells = this.tblControlChains.getSelectionModel().getSelectedCells();
                    if (!rawCells.isEmpty() && (patt0$temp = rawCells.get(0)) instanceof TablePosition && (first = (TablePosition)patt0$temp).getTableColumn() != null) {
                        TableColumn targetCol = first.getTableColumn();
                        colIndex = this.tblControlChains.getVisibleLeafIndex(targetCol);
                    }
                }
                if (colIndex < 0) {
                    colIndex = 0;
                }
                this.navigateFromPosition(this.tblControlChains, row, colIndex, e.isShiftDown() ? -1 : 1);
                e.consume();
            });
            this.configureRowContextMenu();
            this.applyColumnHeaderWraps();
            TableClipboardHelper.install(this.tblControlChains, this::markDirty);
            if (this.txtSearch != null && this.btnNext != null) {
                this.controlPlanSearch = TableSearchNavigator.install(this.tblControlChains, this.txtSearch, this.btnNext);
                if (this.controlPlanSearch != null) {
                    this.updateSearchPattern();
                    this.controlPlanSearch.setOnStateChanged(() -> {
                        this.tblControlChains.refresh();
                        this.updateSearchPattern();
                    });
                    this.btnNext.setGraphic((Node)this.icon(this.icSearch, 16.0));
                    this.btnNext.setText(null);
                } else {
                    this.searchHighlightPattern = null;
                }
            }
        }
        if (this.tabPane != null && this.tabDfmeaHeader != null) {
            BooleanBinding onHeaderTab = Bindings.createBooleanBinding(() -> this.tabPane.getSelectionModel().getSelectedItem() == this.tabDfmeaHeader, (Observable[])new Observable[]{this.tabPane.getSelectionModel().selectedItemProperty()});
            if (this.btnAddControlChain != null) {
                this.btnAddControlChain.disableProperty().bind((ObservableValue)onHeaderTab.not());
            }
            if (this.btnDelete != null && this.tblControlChains != null) {
                onHeaderTab.addListener((obs, old, nv) -> this.updateDeleteButtonState());
            }
        }
        this.initRevisionTab();
        this.applyDefaultTooltips();
        this.updateDeleteButtonState();
    }

    public void setOwnerStage(Stage stage) {
        this.ownerStage = stage;
        this.installCloseHandler();
    }

    public void setSaveAction(Runnable saveAction) {
        this.saveAction = saveAction;
    }

    public void setDirtyHook(Runnable dirtyHook) {
        Runnable delegate = dirtyHook == null ? () -> {} : dirtyHook;
        this.dirtyHook = () -> {
            this.hasUnsavedChanges = true;
            delegate.run();
        };
    }

    public void setProductTrees(List<Item> roots) {
        this.productRoots.clear();
        if (roots != null) {
            this.productRoots.addAll(roots);
        }
        this.rebuildProductSuggestions();
    }

    public void setProcessTrees(List<ProcessItem> roots) {
        this.processRoots.clear();
        if (roots != null) {
            this.processRoots.addAll(roots);
        }
        this.rebuildProcessSuggestions();
    }

    public void setControlPlan(ControlPlan controlPlan) {
        this.clearBindings();
        this.controlPlan = controlPlan;
        this.hasUnsavedChanges = false;
        this.controlPlanUndoStack.clear();
        if (this.tblControlChains != null) {
            this.tblControlChains.setItems(controlPlan == null ? FXCollections.observableArrayList() : controlPlan.getControlChains());
        }
        if (controlPlan == null) {
            this.updateDeleteButtonState();
            return;
        }
        this.syncing = true;
        try {
            this.bindText(this.txtControlPlanNumber, controlPlan.cpNumberProperty());
            this.bindText(this.txtPartNumber, controlPlan.cpPartNumberProperty());
            this.bindText(this.txtPartName, controlPlan.cpPartNameProperty());
            this.bindText(this.txtOrganizationPlant, controlPlan.supplierPlantProperty());
            this.bindText(this.txtOrganizationCode, controlPlan.supplierCodeProperty());
            this.bindText(this.txtKeyContact, controlPlan.cpKeyContactProperty());
            this.bindText(this.txtCoreTeam, controlPlan.crossFunctionalTeamProperty());
            this.bindText(this.txtOrgPlantApproval, controlPlan.cpSupplierPlantApprovalProperty());
            this.bindText(this.txtOtherApproval, controlPlan.cpSupplierOtherApprovalProperty());
            this.bindText(this.txtCustomerEngApproval, controlPlan.cpCustomerEngApprovalProperty());
            this.bindText(this.txtCustomerQualityApproval, controlPlan.cpCustomerQualApprovalProperty());
            this.bindDate(this.dtDateOriginated, controlPlan.cpStartDateProperty());
            this.bindDate(this.dtRevision, controlPlan.cpRevisionDateProperty());
            this.bindCombo(this.cbControlPlanLevel, controlPlan.cpLevelProperty());
        }
        finally {
            this.syncing = false;
        }
        this.initRevisionTab();
        this.updateDeleteButtonState();
    }

    private void bindText(TextField field, StringProperty property) {
        if (field == null || property == null) {
            return;
        }
        field.textProperty().bindBidirectional((Property)property);
        ChangeListener listener = (obs, oldV, newV) -> this.markDirty();
        property.addListener(listener);
        this.bindingCleanups.add(() -> {
            field.textProperty().unbindBidirectional((Property)property);
            property.removeListener(listener);
        });
    }

    private void bindDate(DatePicker picker, ObjectProperty<LocalDate> property) {
        if (picker == null || property == null) {
            return;
        }
        picker.valueProperty().bindBidirectional(property);
        ChangeListener listener = (obs, oldV, newV) -> this.markDirty();
        property.addListener(listener);
        this.bindingCleanups.add(() -> {
            picker.valueProperty().unbindBidirectional((Property)property);
            property.removeListener(listener);
        });
    }

    private void bindCombo(ComboBox<ControlPlanLevel> combo, ObjectProperty<ControlPlanLevel> property) {
        if (combo == null || property == null) {
            return;
        }
        combo.valueProperty().bindBidirectional(property);
        ChangeListener listener = (obs, oldV, newV) -> this.markDirty();
        property.addListener(listener);
        this.bindingCleanups.add(() -> {
            combo.valueProperty().unbindBidirectional((Property)property);
            property.removeListener(listener);
        });
    }

    private void onAddRow() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.controlPlan == null || this.tblControlChains == null) {
            return;
        }
        this.addRowAt(this.controlPlan.getControlChains().size());
    }

    private void onDeleteRow() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.controlPlan == null || this.tblControlChains == null) {
            return;
        }
        ControlPlanRow selected = (ControlPlanRow)this.tblControlChains.getSelectionModel().getSelectedItem();
        if (selected == null) {
            return;
        }
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Delete Control Item");
        alert.setHeaderText("Delete selected control item?");
        alert.setContentText("This action cannot be undone.");
        alert.initOwner((Window)this.ownerStage);
        alert.showAndWait().ifPresent(response -> {
            if (response == ButtonType.OK) {
                ObservableList<ControlPlanRow> rows = this.controlPlan.getControlChains();
                if (rows == null) {
                    return;
                }
                int index = rows.indexOf((Object)selected);
                if (index < 0) {
                    index = 0;
                }
                rows.remove((Object)selected);
                int restoreIndex = index;
                this.pushControlPlanUndo(() -> this.insertRow(selected, Math.min(restoreIndex, this.controlPlan.getControlChains().size()), false, false));
                this.tblControlChains.getSelectionModel().clearSelection();
                this.markDirty();
                this.updateDeleteButtonState();
            }
        });
    }

    private void onSaveOnly() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.performSave(false);
    }

    private void onSaveAndExit() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.performSave(true);
    }

    private void performSave(boolean closeAfter) {
        this.commitPendingEdits();
        try {
            if (this.saveAction != null) {
                this.saveAction.run();
            }
            this.hasUnsavedChanges = false;
            if (closeAfter) {
                this.closeWindow();
            }
        }
        catch (Exception ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Save error");
            alert.setHeaderText("Failed to save project");
            alert.setContentText(ex.getMessage());
            alert.initOwner((Window)this.ownerStage);
            alert.showAndWait();
        }
    }

    private void commitPendingEdits() {
        if (this.tblControlChains != null && this.tblControlChains.getEditingCell() != null) {
            this.tblControlChains.edit(-1, null);
        }
    }

    private void closeWindow() {
        Stage window = null;
        if (this.ownerStage != null) {
            window = this.ownerStage;
        } else if (this.root != null && this.root.getScene() != null) {
            window = this.root.getScene().getWindow();
        }
        if (window == null) {
            return;
        }
        this.programmaticClose = true;
        if (window instanceof Stage) {
            Stage stage = window;
            stage.close();
        } else {
            window.hide();
        }
    }

    private void installCloseHandler() {
        if (this.ownerStage == null) {
            return;
        }
        this.ownerStage.setOnCloseRequest(evt -> {
            if (this.programmaticClose) {
                this.programmaticClose = false;
                return;
            }
            evt.consume();
            this.promptSaveBeforeClose();
        });
    }

    private void promptSaveBeforeClose() {
        if (!this.hasUnsavedChanges) {
            this.closeWindow();
            return;
        }
        Alert confirm = new Alert(Alert.AlertType.CONFIRMATION);
        confirm.setTitle("Save changes?");
        confirm.setHeaderText("Do you want to save before closing?");
        confirm.setContentText("Select Yes to save the current Control Plan.");
        confirm.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        if (this.ownerStage != null) {
            confirm.initOwner((Window)this.ownerStage);
        }
        confirm.showAndWait().ifPresent(result -> {
            if (result == ButtonType.YES) {
                this.performSave(true);
            } else if (result == ButtonType.NO) {
                this.hasUnsavedChanges = false;
                this.closeWindow();
            }
        });
    }

    @FXML
    private void onExport() {
        ExportFormat format = this.promptExportFormat("Select the format for exporting the Control Plan");
        if (format == null) {
            return;
        }
        switch (format.ordinal()) {
            case 0: {
                this.exportToPdf();
                break;
            }
            case 1: {
                this.exportToExcel();
                break;
            }
        }
    }

    private void exportToPdf() {
        File file;
        Object baseName;
        if (this.controlPlan == null) {
            this.showExportError("No Control Plan loaded.");
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Export Control Plan to PDF");
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Arquivos PDF (*.pdf)", new String[]{"*.pdf"}));
        String planName = this.extractPlanNameForFile(this.controlPlan);
        String revision = this.findLastApprovedRevisionForFile(this.controlPlan);
        Object object = baseName = planName.isBlank() ? "Control Plan" : "Control Plan - " + planName;
        if (!revision.isBlank()) {
            baseName = (String)baseName + " Rev " + revision;
        }
        chooser.setInitialFileName(ExportFileNameUtil.suggestedName((String)baseName, "Control Plan", "pdf"));
        ExportDirectoryPreferences.applyInitialDirectory(chooser);
        Window owner = this.resolveWindow();
        File file2 = file = owner != null ? chooser.showSaveDialog(owner) : chooser.showSaveDialog(null);
        if (file == null) {
            return;
        }
        ExportDirectoryPreferences.rememberExportDirectory(file.getParentFile());
        try {
            Path logoPath = ExportLogoPreferences.getRememberedLogoPath().orElse(null);
            ControlPlanPdfGenerator.generateControlPlanPdf(this.controlPlan, file.toPath(), logoPath);
            this.showExportInfo("PDF generated successfully:\n" + file.getAbsolutePath());
        }
        catch (IOException | DocumentException ex) {
            this.showExportError("Error generating PDF: " + this.buildExceptionMessage((Exception)ex));
        }
    }

    private void exportToExcel() {
        File file;
        Object baseName;
        if (this.controlPlan == null) {
            this.showExportError("No Control Plan loaded.");
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Export Control Plan to Excel");
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Planilha Excel (*.xlsx)", new String[]{"*.xlsx"}));
        String planName = this.extractPlanNameForFile(this.controlPlan);
        String revision = this.findLastApprovedRevisionForFile(this.controlPlan);
        Object object = baseName = planName.isBlank() ? "Control Plan" : "Control Plan - " + planName;
        if (!revision.isBlank()) {
            baseName = (String)baseName + " Rev " + revision;
        }
        chooser.setInitialFileName(ExportFileNameUtil.suggestedName((String)baseName, "Control Plan", "xlsx"));
        ExportDirectoryPreferences.applyInitialDirectory(chooser);
        Window owner = this.resolveWindow();
        File file2 = file = owner != null ? chooser.showSaveDialog(owner) : chooser.showSaveDialog(null);
        if (file == null) {
            return;
        }
        ExportDirectoryPreferences.rememberExportDirectory(file.getParentFile());
        try {
            Path logoPath = ExportLogoPreferences.getRememberedLogoPath().orElse(null);
            ControlPlanExcelExporter.export(this.controlPlan, file.toPath(), logoPath);
            this.showExportInfo("Excel file generated successfully:\n" + file.getAbsolutePath());
        }
        catch (IOException ex) {
            this.showExportError("Error generating Excel: " + this.buildExceptionMessage(ex));
        }
    }

    private ExportFormat promptExportFormat(String header) {
        Dialog dialog = new Dialog();
        dialog.setTitle("Export");
        dialog.setHeaderText(header);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        ToggleGroup group = new ToggleGroup();
        RadioButton pdfOption = new RadioButton("PDF");
        pdfOption.setToggleGroup(group);
        pdfOption.setSelected(true);
        RadioButton excelOption = new RadioButton("Excel");
        excelOption.setToggleGroup(group);
        VBox content = new VBox(8.0, new Node[]{pdfOption, excelOption});
        content.setPadding(new Insets(4.0, 0.0, 0.0, 12.0));
        dialog.getDialogPane().setContent((Node)content);
        Window owner = this.resolveWindow();
        if (owner != null) {
            dialog.initOwner(owner);
        }
        dialog.setResultConverter(button -> {
            if (button == ButtonType.OK) {
                return group.getSelectedToggle() == excelOption ? ExportFormat.EXCEL : ExportFormat.PDF;
            }
            return null;
        });
        return dialog.showAndWait().orElse(null);
    }

    private void clearBindings() {
        this.bindingCleanups.forEach(Runnable::run);
        this.bindingCleanups.clear();
    }

    private void markDirty() {
        if (!this.syncing) {
            this.hasUnsavedChanges = true;
        }
        if (!this.syncing && this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private void updateDeleteButtonState() {
        if (this.btnDelete == null || this.tblControlChains == null) {
            return;
        }
        boolean disable = this.controlPlan == null || this.tabPane == null || this.tabPane.getSelectionModel().getSelectedItem() != this.tabDfmeaHeader || this.tblControlChains.getSelectionModel().getSelectedItem() == null || this.tblControlChains.getEditingCell() != null;
        this.btnDelete.setDisable(disable);
    }

    private void showExportInfo(String message) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("Export");
        alert.setHeaderText(null);
        alert.setContentText(message);
        Window owner = this.resolveWindow();
        if (owner != null) {
            alert.initOwner(owner);
        }
        alert.showAndWait();
    }

    private void showExportError(String message) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Erro");
        alert.setHeaderText("Failed to export the file");
        alert.setContentText(message);
        Window owner = this.resolveWindow();
        if (owner != null) {
            alert.initOwner(owner);
        }
        alert.showAndWait();
    }

    private String buildExceptionMessage(Exception ex) {
        if (ex == null) {
            return "";
        }
        String message = ex.getMessage();
        return message == null || message.isBlank() ? ex.getClass().getSimpleName() : message;
    }

    private Window resolveWindow() {
        if (this.ownerStage != null) {
            return this.ownerStage;
        }
        if (this.btnExportToPDF != null && this.btnExportToPDF.getScene() != null) {
            return this.btnExportToPDF.getScene().getWindow();
        }
        if (this.root != null && this.root.getScene() != null) {
            return this.root.getScene().getWindow();
        }
        return null;
    }

    private void applyHeaderReadOnlyMode() {
        boolean editable = true;
        if (this.txtControlPlanNumber != null) {
            this.txtControlPlanNumber.setEditable(editable);
        }
        if (this.txtPartNumber != null) {
            this.txtPartNumber.setEditable(editable);
        }
        if (this.txtPartName != null) {
            this.txtPartName.setEditable(editable);
        }
        if (this.txtOrganizationPlant != null) {
            this.txtOrganizationPlant.setEditable(editable);
        }
        if (this.txtOrganizationCode != null) {
            this.txtOrganizationCode.setEditable(editable);
        }
        if (this.txtKeyContact != null) {
            this.txtKeyContact.setEditable(editable);
        }
        if (this.txtCoreTeam != null) {
            this.txtCoreTeam.setEditable(editable);
        }
        if (this.txtOrgPlantApproval != null) {
            this.txtOrgPlantApproval.setEditable(editable);
        }
        if (this.txtOtherApproval != null) {
            this.txtOtherApproval.setEditable(editable);
        }
        if (this.txtCustomerEngApproval != null) {
            this.txtCustomerEngApproval.setEditable(editable);
        }
        if (this.txtCustomerQualityApproval != null) {
            this.txtCustomerQualityApproval.setEditable(editable);
        }
        if (this.dtDateOriginated != null) {
            this.dtDateOriginated.setDisable(!editable);
        }
        if (this.dtRevision != null) {
            this.dtRevision.setDisable(!editable);
        }
        if (this.cbControlPlanLevel != null) {
            this.cbControlPlanLevel.setDisable(!editable);
        }
    }

    private boolean ensureEditPermission() {
        return true;
    }

    private boolean ensureApprovalPermission() {
        return true;
    }

    private String extractPlanNameForFile(ControlPlan plan) {
        if (plan == null) {
            return "";
        }
        for (String candidate : new String[]{plan.getCpPartName(), plan.getCpPartNumber(), plan.getCpNumber(), plan.getSupplierPlant()}) {
            String trimmed;
            if (candidate == null || (trimmed = candidate.trim()).isEmpty()) continue;
            return trimmed;
        }
        return "";
    }

    private String findLastApprovedRevisionForFile(ControlPlan plan) {
        if (plan == null) {
            return "";
        }
        Optional<String> latestApproved = plan.latestApprovedRevision().map(entry -> {
            String rev = entry.getRevisionNumber();
            return rev != null ? rev.trim() : "";
        }).filter(rev -> !rev.isEmpty());
        if (latestApproved.isPresent()) {
            return latestApproved.get();
        }
        for (String methodName : new String[]{"getLastApprovedRevision", "getApprovedRevision", "getCurrentApprovedRevision"}) {
            try {
                String text;
                Method method = plan.getClass().getMethod(methodName, new Class[0]);
                Object value = method.invoke((Object)plan, new Object[0]);
                if (value == null || (text = value.toString().trim()).isEmpty()) continue;
                return text;
            }
            catch (ReflectiveOperationException method) {
                // empty catch block
            }
        }
        for (String listGetter : new String[]{"getRevisionHistory", "getRevisions", "getControlPlanRevisions"}) {
            try {
                Method getter = plan.getClass().getMethod(listGetter, new Class[0]);
                Object list = getter.invoke((Object)plan, new Object[0]);
                if (!(list instanceof Iterable)) continue;
                Iterable iterable = (Iterable)list;
                String best = "";
                for (Object rev2 : iterable) {
                    boolean approved = false;
                    try {
                        Method approvedMethod = rev2.getClass().getMethod("isApproved", new Class[0]);
                        Object v = approvedMethod.invoke(rev2, new Object[0]);
                        approved = Boolean.TRUE.equals(v);
                    }
                    catch (ReflectiveOperationException ignore) {
                        try {
                            Method statusMethod = rev2.getClass().getMethod("getStatus", new Class[0]);
                            Object status = statusMethod.invoke(rev2, new Object[0]);
                            if (status != null) {
                                String text = status.toString().toUpperCase();
                                approved = text.contains("APPROVED");
                            }
                        }
                        catch (ReflectiveOperationException ignore2) {
                            try {
                                Method approvalStatus = rev2.getClass().getMethod("getApprovalStatus", new Class[0]);
                                Object status = approvalStatus.invoke(rev2, new Object[0]);
                                if (status != null) {
                                    String text = status.toString().toUpperCase();
                                    approved = text.contains("APPROVED");
                                }
                            }
                            catch (ReflectiveOperationException reflectiveOperationException) {
                                // empty catch block
                            }
                        }
                    }
                    if (!approved) continue;
                    String code = null;
                    for (String getterName : new String[]{"getCode", "getRevision", "getRevisionNumber"}) {
                        try {
                            String text;
                            Method codeGetter = rev2.getClass().getMethod(getterName, new Class[0]);
                            Object value = codeGetter.invoke(rev2, new Object[0]);
                            if (value == null || (text = value.toString().trim()).isEmpty()) continue;
                            code = text;
                            break;
                        }
                        catch (ReflectiveOperationException reflectiveOperationException) {
                            // empty catch block
                        }
                    }
                    if (code == null || code.isBlank() || !best.isEmpty() && code.compareTo(best) <= 0) continue;
                    best = code;
                }
                if (best.isEmpty()) continue;
                return best;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        try {
            String text;
            Method method = plan.getClass().getMethod("getCpRevision", new Class[0]);
            Object value = method.invoke((Object)plan, new Object[0]);
            if (value != null && !(text = value.toString().trim()).isEmpty()) {
                return text;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return "";
    }

    private void configureHeaderIcon() {
        this.setIcon(this.imgHeaderIcon, "/icons/controlplan.png");
    }

    private void setIcon(ImageView view, String resourcePath) {
        if (view == null) {
            return;
        }
        URL iconUrl = ControlPlanWindowController.class.getResource(resourcePath);
        if (iconUrl == null) {
            System.err.println("Icon resource not found: " + resourcePath);
            return;
        }
        view.setImage(new Image(iconUrl.toExternalForm()));
    }

    private void configureRowContextMenu() {
        if (this.tblControlChains == null) {
            return;
        }
        this.tblControlChains.setRowFactory(tv -> {
            TableRow<ControlPlanRow> row = new TableRow<ControlPlanRow>(this){
                final /* synthetic */ ControlPlanWindowController this$0;
                {
                    ControlPlanWindowController controlPlanWindowController = this$0;
                    Objects.requireNonNull(controlPlanWindowController);
                    this.this$0 = controlPlanWindowController;
                }

                protected void updateItem(ControlPlanRow item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    this.this$0.applyControlPlanHighlight(this);
                }
            };
            row.indexProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$configureRowContextMenu$1((TableRow)row, arg_0, arg_1, arg_2));
            row.selectedProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$configureRowContextMenu$2((TableRow)row, arg_0, arg_1, arg_2));
            ContextMenu menu = new ContextMenu();
            MenuItem deleteItem = new MenuItem("Delete row");
            deleteItem.setOnAction(arg_0 -> this.lambda$configureRowContextMenu$3((TableRow)row, arg_0));
            MenuItem insertItem = new MenuItem("Insert new row");
            insertItem.setOnAction(arg_0 -> this.lambda$configureRowContextMenu$4((TableRow)row, arg_0));
            MenuItem duplicateItem = new MenuItem("Duplicate row");
            duplicateItem.setOnAction(arg_0 -> this.lambda$configureRowContextMenu$5((TableRow)row, arg_0));
            menu.getItems().addAll((Object[])new MenuItem[]{deleteItem, insertItem, duplicateItem});
            row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)row.emptyProperty()).then((Object)null).otherwise((Object)menu));
            row.setOnContextMenuRequested(arg_0 -> this.lambda$configureRowContextMenu$6((TableRow)row, arg_0));
            return row;
        });
    }

    private void applyControlPlanHighlight(TableRow<ControlPlanRow> row) {
        if (row == null) {
            return;
        }
        if (this.controlPlanSearch == null || this.controlPlanSearch.getLastQuery().isEmpty() || row.isEmpty()) {
            row.setStyle("");
            return;
        }
        if (this.controlPlanSearch.getCurrentMatchRow() == row.getIndex()) {
            if (row.isSelected()) {
                row.setStyle(SEARCH_HIGHLIGHT_SELECTED_STYLE);
            } else {
                row.setStyle(SEARCH_HIGHLIGHT_STYLE);
            }
        } else {
            row.setStyle("");
        }
    }

    private void updateSearchPattern() {
        if (this.controlPlanSearch == null) {
            this.searchHighlightPattern = null;
            return;
        }
        String query = this.controlPlanSearch.getLastQuery();
        this.searchHighlightPattern = query == null || query.isBlank() ? null : Pattern.compile(Pattern.quote(query.trim()), 2);
    }

    private void addRowAt(int index) {
        if (this.controlPlan == null || this.tblControlChains == null) {
            return;
        }
        ControlPlanRow row = new ControlPlanRow();
        this.insertRow(row, index, true, true);
    }

    private void duplicateRow(ControlPlanRow source) {
        if (this.controlPlan == null || this.tblControlChains == null || source == null) {
            return;
        }
        int sourceIndex = this.controlPlan.getControlChains().indexOf((Object)source);
        if (sourceIndex < 0) {
            return;
        }
        ControlPlanRow copy = this.cloneRow(source);
        this.insertRow(copy, sourceIndex + 1, false, true);
    }

    private void insertRow(ControlPlanRow row, int index, boolean beginEdit, boolean recordUndo) {
        if (this.controlPlan == null || this.tblControlChains == null || row == null) {
            return;
        }
        ObservableList<ControlPlanRow> rows = this.controlPlan.getControlChains();
        if (rows == null) {
            return;
        }
        if (index < 0 || index > rows.size()) {
            rows.add((Object)row);
            index = rows.size() - 1;
        } else {
            rows.add(index, (Object)row);
        }
        this.markDirty();
        if (recordUndo || beginEdit) {
            this.focusRow(index, beginEdit);
        }
        this.updateDeleteButtonState();
        if (recordUndo) {
            ControlPlanRow targetRow = row;
            this.pushControlPlanUndo(() -> {
                ObservableList<ControlPlanRow> chains;
                ObservableList<ControlPlanRow> observableList = chains = this.controlPlan == null ? null : this.controlPlan.getControlChains();
                if (chains != null) {
                    chains.remove((Object)targetRow);
                }
                if (this.tblControlChains != null) {
                    this.tblControlChains.refresh();
                }
                this.updateDeleteButtonState();
            });
        }
    }

    private void focusRow(int rowIndex, boolean beginEdit) {
        if (this.tblControlChains == null || rowIndex < 0 || rowIndex >= this.tblControlChains.getItems().size()) {
            return;
        }
        TableColumn<ControlPlanRow, ?> editColumn = this.firstEditableColumn();
        if (editColumn != null) {
            this.tblControlChains.getSelectionModel().clearAndSelect(rowIndex, editColumn);
        } else {
            this.tblControlChains.getSelectionModel().clearAndSelect(rowIndex);
        }
        this.tblControlChains.scrollTo(rowIndex);
        if (beginEdit && editColumn != null) {
            int targetRow = rowIndex;
            Platform.runLater(() -> this.tblControlChains.edit(targetRow, editColumn));
        }
    }

    private TableColumn<ControlPlanRow, ?> firstEditableColumn() {
        if (this.tblControlChains == null) {
            return null;
        }
        if (this.colPartOrProcessNumber != null) {
            return this.colPartOrProcessNumber;
        }
        ObservableList columns = this.tblControlChains.getVisibleLeafColumns();
        return columns.isEmpty() ? null : (TableColumn)columns.get(0);
    }

    private ControlPlanRow cloneRow(ControlPlanRow source) {
        ControlPlanRow copy = new ControlPlanRow();
        copy.setPartOrProcessNumber(source.getPartOrProcessNumber());
        copy.setProcessNameOrOperationDescription(source.getProcessNameOrOperationDescription());
        copy.setMachineDeviceJigToolForMfg(source.getMachineDeviceJigToolForMfg());
        copy.setNumber(source.getNumber());
        copy.setCharacteristicOrParameter(source.getCharacteristicOrParameter());
        copy.setProductCharacteristic(source.getProductCharacteristic());
        copy.setProcessCharacteristic(source.getProcessCharacteristic());
        copy.setIsCriticalToQuality(source.getIsCriticalToQuality());
        copy.setIsCriticalToSafety(source.getIsCriticalToSafety());
        copy.setIsCriticalToProcess(source.getIsCriticalToProcess());
        copy.setAttribute(source.getAttribute());
        copy.setTargetValue(source.getTargetValue());
        copy.setUpperLimit(source.getUpperLimit());
        copy.setLowerLimit(source.getLowerLimit());
        copy.setEvaluationMeasurementTechnique(source.getEvaluationMeasurementTechnique());
        copy.setSampleSize(source.getSampleSize());
        copy.setSampleFrequency(source.getSampleFrequency());
        copy.setControlMethod(source.getControlMethod());
        copy.setReactionPlan(source.getReactionPlan());
        return copy;
    }

    private void stringColumn(TableColumn<ControlPlanRow, String> column, Function<ControlPlanRow, StringProperty> prop) {
        if (column == null) {
            return;
        }
        column.setEditable(true);
        column.setStyle("-fx-alignment: CENTER;");
        column.setCellValueFactory(cd -> (ObservableValue)prop.apply((ControlPlanRow)cd.getValue()));
        SuggestionProvider provider = this.mentionProviders.get(column);
        column.setCellFactory(col -> {
            ContextMenu menu = new ContextMenu();
            WrapTextAreaTableCell cell = new WrapTextAreaTableCell(col, () -> this.searchHighlightPattern, this::navigateFromCell, (c, editor) -> {
                if (provider == null) {
                    return;
                }
                MentionSuggestionBehavior.install((TextInputControl)editor, menu, MentionSuggestionBehavior.config().allowedQueryChar(ch -> !Character.isWhitespace(ch.charValue())).suggestions(provider::suggest).insertionText(Function.identity()).acceptFirstOnEnterOrTab(true).afterInsert((ctx, chosen) -> {
                    ControlPlanRow row = this.currentRowForCell(c);
                    this.applyMentionTextToRow(row, (TableColumn<ControlPlanRow, ?>)col, ctx.newText());
                    this.applyMentionSideEffects(row, (TableColumn<ControlPlanRow, ?>)col, (String)chosen);
                    if (this.tblControlChains != null) {
                        this.tblControlChains.refresh();
                    }
                }));
            });
            cell.displayNode().getStyleClass().add((Object)"control-plan-wrap-cell-text");
            return cell;
        });
        column.setOnEditCommit(edit -> {
            ControlPlanRow row = (ControlPlanRow)edit.getRowValue();
            if (row != null) {
                StringProperty property = (StringProperty)prop.apply(row);
                if (property == null) {
                    return;
                }
                String newValue = (String)edit.getNewValue();
                String oldValue = (String)edit.getOldValue();
                if (Objects.equals(oldValue, newValue)) {
                    return;
                }
                this.pushControlPlanUndo(() -> property.set((Object)oldValue));
                property.set((Object)newValue);
                this.markDirty();
            }
        });
    }

    private ControlPlanRow currentRowForCell(TableCell<ControlPlanRow, ?> cell) {
        Object object;
        if (cell == null) {
            return null;
        }
        if (cell.getTableRow() != null && (object = cell.getTableRow().getItem()) instanceof ControlPlanRow) {
            ControlPlanRow row = (ControlPlanRow)object;
            return row;
        }
        TableView table = cell.getTableView();
        int idx = cell.getIndex();
        if (table != null && idx >= 0 && idx < table.getItems().size()) {
            return (ControlPlanRow)table.getItems().get(idx);
        }
        return null;
    }

    private void configureMentionProviders() {
        this.mentionProviders.clear();
        if (this.colPartOrProcessNumber != null) {
            this.mentionProviders.put(this.colPartOrProcessNumber, this::suggestPartNumberMentions);
        }
        if (this.colProcessName != null) {
            this.mentionProviders.put(this.colProcessName, this::suggestProcessOperationMentions);
        }
        if (this.colCharacteristicProduct != null) {
            this.mentionProviders.put(this.colCharacteristicProduct, this::suggestProductCharacteristicMentions);
        }
        if (this.colCharacteristicProcess != null) {
            this.mentionProviders.put(this.colCharacteristicProcess, this::suggestProcessParameterMentions);
        }
    }

    private List<String> suggestPartNumberMentions(String query) {
        return this.filterSuggestions(this.partNumberSuggestions, query);
    }

    private List<String> suggestProcessOperationMentions(String query) {
        return this.filterSuggestions(this.processOperationSuggestions, query);
    }

    private List<String> suggestProductCharacteristicMentions(String query) {
        return this.filterSuggestions(this.productCharacteristicSuggestions, query);
    }

    private List<String> suggestProcessParameterMentions(String query) {
        return this.filterSuggestions(this.processParameterSuggestions, query);
    }

    private List<String> filterSuggestions(List<String> source, String query) {
        if (source.isEmpty()) {
            return Collections.emptyList();
        }
        String needle = query == null ? "" : query.toLowerCase(Locale.ROOT);
        ArrayList<String> result = new ArrayList<String>();
        for (String entry : source) {
            if (!needle.isEmpty() && !entry.toLowerCase(Locale.ROOT).contains(needle)) continue;
            result.add(entry);
            if (result.size() < 25) continue;
            break;
        }
        return result;
    }

    private void rebuildProductSuggestions() {
        this.partNumberSuggestions.clear();
        this.productCharacteristicSuggestions.clear();
        this.productCharacteristicLookup.clear();
        LinkedHashSet<String> parts = new LinkedHashSet<String>();
        LinkedHashSet<String> chars = new LinkedHashSet<String>();
        for (Item rootItem : this.productRoots) {
            this.collectItemSuggestions(rootItem, parts, chars);
        }
        this.partNumberSuggestions.addAll(parts);
        this.productCharacteristicSuggestions.addAll(chars);
    }

    private void rebuildProcessSuggestions() {
        this.processOperationSuggestions.clear();
        this.processParameterSuggestions.clear();
        this.processParameterLookup.clear();
        LinkedHashSet<String> operations = new LinkedHashSet<String>();
        LinkedHashSet<String> parameters = new LinkedHashSet<String>();
        for (ProcessItem rootProcess : this.processRoots) {
            this.collectProcessSuggestions(rootProcess, operations, parameters);
        }
        this.processOperationSuggestions.addAll(operations);
        this.processParameterSuggestions.addAll(parameters);
    }

    private void collectItemSuggestions(Item item, LinkedHashSet<String> partTarget, LinkedHashSet<String> charTarget) {
        if (item == null) {
            return;
        }
        String part = this.formatPartSuggestion(item);
        if (part != null && !part.isBlank()) {
            partTarget.add(part);
        }
        if (item.getCharacteristics() != null) {
            for (Characteristic ch : item.getCharacteristics()) {
                String desc = ControlPlanWindowController.safe(ch.getDescription()).trim();
                if (desc.isEmpty()) continue;
                charTarget.add(desc);
                this.productCharacteristicLookup.putIfAbsent(desc, ch);
            }
        }
        if (item.getChildren() != null) {
            for (Item child : item.getChildren()) {
                this.collectItemSuggestions(child, partTarget, charTarget);
            }
        }
    }

    private void collectProcessSuggestions(ProcessItem item, LinkedHashSet<String> operationTarget, LinkedHashSet<String> parameterTarget) {
        String desc;
        if (item == null) {
            return;
        }
        ProcessType type = item.getType();
        if (type == ProcessType.OPERATION && !(desc = ControlPlanWindowController.safe(item.getDescription()).trim()).isEmpty()) {
            operationTarget.add(desc);
        }
        if (item.getParameters() != null) {
            for (Parameter parameter : item.getParameters()) {
                String desc2 = ControlPlanWindowController.safe(parameter.getDescription()).trim();
                if (desc2.isEmpty()) continue;
                parameterTarget.add(desc2);
                this.processParameterLookup.putIfAbsent(desc2, parameter);
            }
        }
        if (item.getChildren() != null) {
            for (ProcessItem child : item.getChildren()) {
                this.collectProcessSuggestions(child, operationTarget, parameterTarget);
            }
        }
    }

    private void applyMentionSideEffects(ControlPlanRow row, TableColumn<ControlPlanRow, ?> column, String suggestion) {
        Parameter parameter;
        if (row == null || column == null || suggestion == null) {
            return;
        }
        String key = suggestion.trim();
        if (key.isEmpty()) {
            return;
        }
        if (column == this.colCharacteristicProduct) {
            Characteristic characteristic = this.productCharacteristicLookup.get(key);
            if (characteristic != null) {
                this.applyToleranceValues(row, this.preferredToleranceValue(characteristic.getTargetValueText(), characteristic.getTargetValue()), this.preferredToleranceValue(characteristic.getLowerLimitText(), characteristic.getLowerLimit()), this.preferredToleranceValue(characteristic.getUpperLimitText(), characteristic.getUpperLimit()));
                this.applyFlagValues(row, characteristic.isAttribute(), characteristic.isCriticalToSafety(), characteristic.isCriticalToQuality(), characteristic.isCriticalToProcess());
            }
        } else if (column == this.colCharacteristicProcess && (parameter = this.processParameterLookup.get(key)) != null) {
            this.applyToleranceValues(row, this.preferredToleranceValue(parameter.getTargetValueText(), parameter.getTargetValue()), this.preferredToleranceValue(parameter.getLowerLimitText(), parameter.getLowerLimit()), this.preferredToleranceValue(parameter.getUpperLimitText(), parameter.getUpperLimit()));
            this.applyFlagValues(row, parameter.isAttribute(), parameter.isCriticalToSafety(), parameter.isCriticalToQuality(), parameter.isCriticalToProcess());
        }
    }

    private void applyMentionTextToRow(ControlPlanRow row, TableColumn<ControlPlanRow, ?> column, String text) {
        String newText;
        if (row == null || column == null) {
            return;
        }
        String string = newText = text == null ? "" : text;
        if (column == this.colCharacteristicProduct) {
            String old = row.getProductCharacteristic();
            if (Objects.equals(old, newText)) {
                return;
            }
            this.pushControlPlanUndo(() -> row.setProductCharacteristic(old));
            row.setProductCharacteristic(newText);
            this.markDirty();
        } else if (column == this.colCharacteristicProcess) {
            String old = row.getProcessCharacteristic();
            if (Objects.equals(old, newText)) {
                return;
            }
            this.pushControlPlanUndo(() -> row.setProcessCharacteristic(old));
            row.setProcessCharacteristic(newText);
            this.markDirty();
        }
    }

    private void applyFlagValues(ControlPlanRow row, boolean attribute, boolean criticalToSafety, boolean criticalToQuality, boolean criticalToProcess) {
        boolean changed;
        if (row == null) {
            return;
        }
        boolean oldAttribute = Boolean.TRUE.equals(row.getAttribute());
        boolean oldSafety = Boolean.TRUE.equals(row.getIsCriticalToSafety());
        boolean oldQuality = Boolean.TRUE.equals(row.getIsCriticalToQuality());
        boolean oldProcess = Boolean.TRUE.equals(row.getIsCriticalToProcess());
        boolean bl = changed = oldAttribute != attribute || oldSafety != criticalToSafety || oldQuality != criticalToQuality || oldProcess != criticalToProcess;
        if (!changed) {
            return;
        }
        this.pushControlPlanUndo(() -> {
            row.setAttribute(oldAttribute);
            row.setIsCriticalToSafety(oldSafety);
            row.setIsCriticalToQuality(oldQuality);
            row.setIsCriticalToProcess(oldProcess);
        });
        row.setAttribute(attribute);
        row.setIsCriticalToSafety(criticalToSafety);
        row.setIsCriticalToQuality(criticalToQuality);
        row.setIsCriticalToProcess(criticalToProcess);
        this.markDirty();
    }

    private void applyToleranceValues(ControlPlanRow row, String target, String lower, String upper) {
        boolean changed;
        if (row == null) {
            return;
        }
        String newTarget = this.cleanToleranceValue(target);
        String newLower = this.cleanToleranceValue(lower);
        String newUpper = this.cleanToleranceValue(upper);
        String oldTarget = row.getTargetValue();
        String oldLower = row.getLowerLimit();
        String oldUpper = row.getUpperLimit();
        boolean bl = changed = !Objects.equals(oldTarget, newTarget) || !Objects.equals(oldLower, newLower) || !Objects.equals(oldUpper, newUpper);
        if (!changed) {
            return;
        }
        this.pushControlPlanUndo(() -> {
            row.setTargetValue(oldTarget);
            row.setLowerLimit(oldLower);
            row.setUpperLimit(oldUpper);
        });
        row.setTargetValue(newTarget);
        row.setLowerLimit(newLower);
        row.setUpperLimit(newUpper);
        this.markDirty();
    }

    private String preferredToleranceValue(String textValue, double numericValue) {
        String cleaned = this.cleanToleranceValue(textValue);
        if (!cleaned.isEmpty()) {
            return cleaned;
        }
        String fallback = ControlPlanWindowController.formatDoubleValue(numericValue);
        return this.cleanToleranceValue(fallback);
    }

    private String cleanToleranceValue(String value) {
        return value == null ? "" : value.trim();
    }

    private String formatPartSuggestion(Item item) {
        String pn = ControlPlanWindowController.safe(item.getPartNumber()).trim();
        String desc = ControlPlanWindowController.safe(item.getDescription()).trim();
        if (pn.isEmpty() && desc.isEmpty()) {
            return null;
        }
        if (pn.isEmpty()) {
            return desc;
        }
        if (desc.isEmpty()) {
            return pn;
        }
        return pn + " - " + desc;
    }

    private void booleanColumn(TableColumn<ControlPlanRow, Boolean> column, Function<ControlPlanRow, ObjectProperty<Boolean>> prop) {
        if (column == null) {
            return;
        }
        column.setEditable(true);
        column.setStyle("-fx-alignment: CENTER;");
        column.setCellValueFactory(cd -> (ObservableValue)prop.apply((ControlPlanRow)cd.getValue()));
        column.setCellFactory(col -> new BooleanCheckBoxCell(this, prop));
    }

    private void initRevisionTab() {
        if (this.tblRevisions == null) {
            return;
        }
        if (!this.revisionTabConfigured) {
            this.colRevNumber.setCellValueFactory((Callback)new PropertyValueFactory("revisionNumber"));
            this.colRevDate.setCellValueFactory((Callback)new PropertyValueFactory("revisionDate"));
            this.colRevAuthor.setCellValueFactory((Callback)new PropertyValueFactory("authorName"));
            this.colRevDesc.setCellValueFactory((Callback)new PropertyValueFactory("descriptionOfChanges"));
            this.colRevStatus.setCellValueFactory((Callback)new PropertyValueFactory("approvalStatus"));
            this.colRevStatus.setCellFactory(col -> new TableCell<RevisionEntry, ApprovalStatus>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                protected void updateItem(ApprovalStatus status, boolean empty) {
                    super.updateItem((Object)status, empty);
                    this.setText(empty || status == null ? "" : status.getApprovalStatus());
                }
            });
            this.tblRevisions.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
                boolean has;
                boolean bl = has = nv != null;
                if (this.btnRevEdit != null) {
                    this.btnRevEdit.setDisable(!has);
                }
                if (this.btnRevApprove != null) {
                    this.btnRevApprove.setDisable(!has);
                }
                if (this.btnRevDelete != null) {
                    this.btnRevDelete.setDisable(!has);
                }
            });
            if (this.btnRevAdd != null) {
                this.btnRevAdd.setOnAction(e -> this.onRevAdd());
            }
            if (this.btnRevEdit != null) {
                this.btnRevEdit.setOnAction(e -> this.onRevEdit());
            }
            if (this.btnRevApprove != null) {
                this.btnRevApprove.setOnAction(e -> this.onRevApprove());
            }
            if (this.btnRevDelete != null) {
                this.btnRevDelete.setOnAction(e -> this.onRevDelete());
            }
            if (this.btnRevAdd != null) {
                this.btnRevAdd.setGraphic((Node)this.icon(this.icPlus, 16.0));
            }
            if (this.btnRevEdit != null) {
                this.btnRevEdit.setGraphic((Node)this.icon(this.icEdit, 16.0));
            }
            if (this.btnRevApprove != null) {
                this.btnRevApprove.setGraphic((Node)this.icon(this.icApprove, 16.0));
            }
            if (this.btnRevDelete != null) {
                this.btnRevDelete.setGraphic((Node)this.icon(this.icTrash, 16.0));
            }
            this.revisionTabConfigured = true;
        }
        if (this.controlPlan != null) {
            this.tblRevisions.setItems(this.controlPlan.getRevisionHistory());
        } else {
            this.tblRevisions.setItems(FXCollections.observableArrayList());
        }
        this.tblRevisions.refresh();
        this.tblRevisions.getSelectionModel().clearSelection();
        if (this.btnRevEdit != null) {
            this.btnRevEdit.setDisable(true);
        }
        if (this.btnRevApprove != null) {
            this.btnRevApprove.setDisable(true);
        }
        if (this.btnRevDelete != null) {
            this.btnRevDelete.setDisable(true);
        }
    }

    private void onRevAdd() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.controlPlan == null) {
            return;
        }
        RevisionEntry data = this.showRevisionDialog(null);
        if (data == null) {
            return;
        }
        this.controlPlan.getRevisionHistory().add((Object)data);
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        if (this.tblRevisions != null) {
            this.tblRevisions.getSelectionModel().select((Object)data);
            this.tblRevisions.scrollTo((Object)data);
            this.tblRevisions.refresh();
        }
    }

    private void onRevEdit() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.tblRevisions == null || this.controlPlan == null) {
            return;
        }
        RevisionEntry sel = (RevisionEntry)this.tblRevisions.getSelectionModel().getSelectedItem();
        if (sel == null) {
            return;
        }
        RevisionEntry edited = this.showRevisionDialog(sel);
        if (edited == null) {
            return;
        }
        sel.setRevisionNumber(edited.getRevisionNumber());
        sel.setRevisionDate(edited.getRevisionDate());
        sel.setAuthorName(edited.getAuthorName());
        sel.setDescriptionOfChanges(edited.getDescriptionOfChanges());
        this.tblRevisions.refresh();
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private void onRevApprove() {
        if (!this.ensureApprovalPermission()) {
            return;
        }
        if (this.tblRevisions == null || this.controlPlan == null) {
            return;
        }
        RevisionEntry sel = (RevisionEntry)this.tblRevisions.getSelectionModel().getSelectedItem();
        if (sel == null) {
            return;
        }
        this.controlPlan.approveRevision(sel);
        this.tblRevisions.refresh();
        this.tblRevisions.getSelectionModel().clearSelection();
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private void onRevDelete() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.tblRevisions == null || this.controlPlan == null) {
            return;
        }
        RevisionEntry sel = (RevisionEntry)this.tblRevisions.getSelectionModel().getSelectedItem();
        if (sel == null) {
            return;
        }
        this.controlPlan.removeRevision(sel);
        if (this.tblRevisions != null) {
            this.tblRevisions.refresh();
            this.tblRevisions.getSelectionModel().clearSelection();
        }
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private RevisionEntry showRevisionDialog(RevisionEntry existing) {
        Dialog dlg = new Dialog();
        dlg.setTitle(existing == null ? "Add Revision" : "Edit Revision");
        dlg.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        TextField tfRev = new TextField(existing == null ? "" : ControlPlanWindowController.safe(existing.getRevisionNumber()));
        DatePicker dpDate = new DatePicker(existing == null ? LocalDate.now() : existing.getRevisionDate());
        TextField tfAuth = new TextField(existing == null ? "" : ControlPlanWindowController.safe(existing.getAuthorName()));
        TextArea taDesc = new TextArea(existing == null ? "" : ControlPlanWindowController.safe(existing.getDescriptionOfChanges()));
        taDesc.setPrefRowCount(4);
        GridPane gp = new GridPane();
        gp.setHgap(8.0);
        gp.setVgap(8.0);
        gp.setPadding(new Insets(10.0));
        gp.add((Node)new Label("Revision:"), 0, 0);
        gp.add((Node)tfRev, 1, 0);
        gp.add((Node)new Label("Date:"), 0, 1);
        gp.add((Node)dpDate, 1, 1);
        gp.add((Node)new Label("Author:"), 0, 2);
        gp.add((Node)tfAuth, 1, 2);
        gp.add((Node)new Label("Description:"), 0, 3);
        gp.add((Node)taDesc, 1, 3);
        dlg.getDialogPane().setContent((Node)gp);
        Node okBtn = dlg.getDialogPane().lookupButton(ButtonType.OK);
        okBtn.disableProperty().bind((ObservableValue)tfRev.textProperty().isEmpty().or((ObservableBooleanValue)tfAuth.textProperty().isEmpty()).or((ObservableBooleanValue)dpDate.valueProperty().isNull()));
        Optional res = dlg.showAndWait();
        if (res.isEmpty() || res.get() != ButtonType.OK) {
            return null;
        }
        if (existing == null) {
            return new RevisionEntry(tfRev.getText().trim(), (LocalDate)dpDate.getValue(), tfAuth.getText().trim(), taDesc.getText().trim(), ApprovalStatus.DRAFT);
        }
        return new RevisionEntry(tfRev.getText().trim(), (LocalDate)dpDate.getValue(), tfAuth.getText().trim(), taDesc.getText().trim(), existing.getApprovalStatus());
    }

    private static String safe(String value) {
        return value == null ? "" : value;
    }

    private static String formatDoubleValue(Double value) {
        if (value == null) {
            return "";
        }
        double v = value;
        if (Double.isNaN(v) || Double.isInfinite(v)) {
            return "";
        }
        String text = Double.toString(v);
        if (text.indexOf(69) >= 0 || text.indexOf(101) >= 0) {
            return text;
        }
        if (text.indexOf(46) >= 0) {
            while (text.endsWith("0")) {
                text = text.substring(0, text.length() - 1);
            }
            if (text.endsWith(".")) {
                text = text.substring(0, text.length() - 1);
            }
        }
        return text;
    }

    private void pushControlPlanUndo(Runnable action) {
        if (action == null) {
            return;
        }
        this.controlPlanUndoStack.addFirst(action);
        while (this.controlPlanUndoStack.size() > 50) {
            this.controlPlanUndoStack.removeLast();
        }
    }

    private boolean performControlPlanUndo() {
        Runnable action = this.controlPlanUndoStack.pollFirst();
        if (action == null) {
            return false;
        }
        action.run();
        this.markDirty();
        if (this.tblControlChains != null) {
            this.tblControlChains.refresh();
        }
        this.updateDeleteButtonState();
        return true;
    }

    private TablePosition<ControlPlanRow, ?> captureControlPlanFocus() {
        TablePosition first;
        ObservableList cells;
        TablePosition focused;
        if (this.tblControlChains == null) {
            return null;
        }
        TableView.TableViewFocusModel focusModel = this.tblControlChains.getFocusModel();
        if (focusModel != null && (focused = focusModel.getFocusedCell()) != null && focused.getTableColumn() != null && focused.getRow() >= 0) {
            return new TablePosition(this.tblControlChains, focused.getRow(), focused.getTableColumn());
        }
        TableView.TableViewSelectionModel selection = this.tblControlChains.getSelectionModel();
        if (selection != null && !(cells = selection.getSelectedCells()).isEmpty() && (first = (TablePosition)cells.get(0)) != null && first.getTableColumn() != null && first.getRow() >= 0) {
            return new TablePosition(this.tblControlChains, first.getRow(), first.getTableColumn());
        }
        return null;
    }

    private void restoreControlPlanFocus(TablePosition<ControlPlanRow, ?> snapshot) {
        if (this.tblControlChains == null || snapshot == null) {
            return;
        }
        ObservableList items = this.tblControlChains.getItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        int row = Math.max(0, Math.min(snapshot.getRow(), items.size() - 1));
        TableColumn column = snapshot.getTableColumn();
        ArrayList visible = new ArrayList(this.tblControlChains.getVisibleLeafColumns());
        if (visible.isEmpty()) {
            return;
        }
        if (column == null || !visible.contains(column)) {
            int idx = this.tblControlChains.getVisibleLeafIndex(column);
            if (idx < 0 || idx >= visible.size()) {
                idx = 0;
            }
            column = (TableColumn)visible.get(idx);
        }
        TableView.TableViewSelectionModel selection = this.tblControlChains.getSelectionModel();
        TableView.TableViewFocusModel focus = this.tblControlChains.getFocusModel();
        if (selection != null) {
            selection.clearAndSelect(row, column);
        }
        if (focus != null) {
            focus.focus(row, column);
        }
    }

    private void navigateFromCell(TableCell<ControlPlanRow, ?> cell, int step) {
        TableView table = cell.getTableView();
        if (table == null) {
            return;
        }
        int row = cell.getIndex();
        if (row < 0) {
            return;
        }
        TableColumn cellColumn = cell.getTableColumn();
        int colIndex = -1;
        if (cellColumn != null) {
            colIndex = table.getVisibleLeafIndex(cellColumn);
        } else if (!table.getVisibleLeafColumns().isEmpty()) {
            colIndex = 0;
        }
        if (colIndex < 0) {
            colIndex = 0;
        }
        this.navigateFromPosition((TableView<ControlPlanRow>)table, row, colIndex, step);
    }

    private void navigateFromPosition(TableView<ControlPlanRow> table, int row, int colIndex, int step) {
        int currentColIdx;
        if (table == null) {
            return;
        }
        ObservableList items = table.getItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        ObservableList visibleColumns = table.getVisibleLeafColumns();
        if (visibleColumns.isEmpty()) {
            return;
        }
        ArrayList<TableColumn> navigable = new ArrayList<TableColumn>();
        for (TableColumn col : visibleColumns) {
            if (col == null || !col.isVisible() || !col.isEditable()) continue;
            navigable.add(col);
        }
        if (navigable.isEmpty()) {
            navigable.addAll((Collection<TableColumn>)visibleColumns);
        }
        if (navigable.isEmpty()) {
            return;
        }
        int rowCount = items.size();
        int safeRow = Math.max(0, Math.min(rowCount - 1, row));
        TableColumn currentColumn = null;
        if (colIndex >= 0 && colIndex < visibleColumns.size()) {
            currentColumn = (TableColumn)visibleColumns.get(colIndex);
        }
        int n = currentColIdx = currentColumn != null ? navigable.indexOf(currentColumn) : -1;
        if (currentColIdx < 0) {
            currentColIdx = Math.max(0, Math.min(navigable.size() - 1, colIndex));
        }
        int totalCols = navigable.size();
        int totalCells = rowCount * totalCols;
        if (totalCols == 0 || totalCells == 0) {
            return;
        }
        int linearIndex = safeRow * totalCols + currentColIdx;
        int targetIndex = Math.max(0, Math.min(totalCells - 1, linearIndex + step));
        int targetRow = targetIndex / totalCols;
        int targetCol = targetIndex % totalCols;
        if (targetRow < 0 || targetRow >= rowCount) {
            return;
        }
        TableColumn targetColumn = (TableColumn)navigable.get(targetCol);
        if (targetColumn == null) {
            return;
        }
        HorizontalScrollState snapshot = ControlPlanWindowController.captureHorizontalScrollState(table);
        table.getSelectionModel().clearAndSelect(targetRow, targetColumn);
        table.getFocusModel().focus(targetRow, targetColumn);
        int rowFinal = targetRow;
        TableColumn columnFinal = targetColumn;
        boolean shouldEdit = table.isEditable() && targetColumn.isEditable();
        Platform.runLater(() -> {
            ControlPlanWindowController.ensureColumnVisible(table, columnFinal, snapshot);
            if (shouldEdit) {
                table.edit(rowFinal, columnFinal);
            }
        });
    }

    private static HorizontalScrollState captureHorizontalScrollState(TableView<?> table) {
        ScrollBar bar = ControlPlanWindowController.findHorizontalScrollBar(table);
        if (bar == null) {
            return null;
        }
        return new HorizontalScrollState(bar.getValue());
    }

    private static void ensureColumnVisible(TableView<?> table, TableColumn<?, ?> target, HorizontalScrollState state) {
        double current;
        ScrollBar bar = ControlPlanWindowController.findHorizontalScrollBar(table);
        if (bar == null || target == null) {
            return;
        }
        double viewport = bar.getVisibleAmount();
        if (viewport <= 0.0) {
            return;
        }
        double left = ControlPlanWindowController.computeColumnLeft(table, target);
        double right = left + Math.max(target.getWidth(), 1.0);
        double desired = current = state != null ? state.value : bar.getValue();
        if (right > current + viewport) {
            desired = right - viewport;
        } else if (left < current) {
            desired = left;
        }
        desired = Math.max(bar.getMin(), Math.min(bar.getMax(), desired));
        bar.setValue(desired);
    }

    private static double computeColumnLeft(TableView<?> table, TableColumn<?, ?> target) {
        TableColumn col;
        double left = 0.0;
        Iterator iterator = table.getVisibleLeafColumns().iterator();
        while (iterator.hasNext() && (col = (TableColumn)iterator.next()) != target) {
            left += col.getWidth();
        }
        return left;
    }

    private static ScrollBar findHorizontalScrollBar(TableView<?> table) {
        ScrollBar sb;
        if (table == null) {
            return null;
        }
        Object cached = table.getProperties().get((Object)HSCROLL_CACHE_KEY);
        if (cached instanceof ScrollBar && (sb = (ScrollBar)cached).getParent() != null) {
            return sb;
        }
        ScrollBar found = ControlPlanWindowController.lookupHorizontalScrollBar(table);
        if (found != null) {
            table.getProperties().put((Object)HSCROLL_CACHE_KEY, (Object)found);
        }
        return found;
    }

    private static ScrollBar lookupHorizontalScrollBar(TableView<?> table) {
        if (table == null || table.getScene() == null) {
            return null;
        }
        for (Node node : table.lookupAll(".scroll-bar")) {
            ScrollBar sb;
            if (!(node instanceof ScrollBar) || (sb = (ScrollBar)node).getOrientation() != Orientation.HORIZONTAL) continue;
            return sb;
        }
        return null;
    }

    private void applyColumnHeaderWraps() {
        TableUtils.wrapHeader(this.colPartOrProcessNumber);
        TableUtils.wrapHeader(this.colProcessName);
        TableUtils.wrapHeader(this.colMachineDevice);
        TableUtils.wrapHeader(this.colCharacteristicNumber);
        TableUtils.wrapHeader(this.colCharacteristicProduct);
        TableUtils.wrapHeader(this.colCharacteristicProcess);
        TableUtils.wrapHeader(this.colCriticalToSafety);
        TableUtils.wrapHeader(this.colCriticalToQuality);
        TableUtils.wrapHeader(this.colCriticalToProcess);
        TableUtils.wrapHeader(this.colAttribute);
        TableUtils.wrapHeader(this.colEvaluationTechnique);
        TableUtils.wrapHeader(this.colSampleSize);
        TableUtils.wrapHeader(this.colSampleFrequency);
        TableUtils.wrapHeader(this.colControlMethod);
        TableUtils.wrapHeader(this.colReactionPlan);
        TableUtils.wrapHeader(this.colRevNumber);
        TableUtils.wrapHeader(this.colRevDate);
        TableUtils.wrapHeader(this.colRevAuthor);
        TableUtils.wrapHeader(this.colRevDesc);
        TableUtils.wrapHeader(this.colRevStatus);
        if (this.tblControlChains != null) {
            Platform.runLater(() -> this.tblControlChains.layout());
        }
        if (this.tblRevisions != null) {
            Platform.runLater(() -> this.tblRevisions.layout());
        }
    }

    private Image loadIcon(String name, double size) {
        InputStream stream = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        if (stream == null) {
            return null;
        }
        return new Image(stream, size, size, true, true);
    }

    private ImageView icon(Image img, double size) {
        if (img == null) {
            return null;
        }
        ImageView iv = new ImageView(img);
        iv.setPreserveRatio(true);
        iv.setFitWidth(size);
        iv.setFitHeight(size);
        iv.setSmooth(true);
        return iv;
    }

    private void loadIcons() {
        this.icControlChain = this.loadIcon("control_chain", 18.0);
        this.icTrash = this.loadIcon("trash", 16.0);
        this.icPdf = this.loadIcon("pdf", 16.0);
        this.icSave = this.loadIcon("save", 18.0);
        this.icExit = this.loadIcon("exit", 18.0);
        this.icPlus = this.loadIcon("plus", 16.0);
        this.icApprove = this.loadIcon("approve", 16.0);
        this.icEdit = this.loadIcon("edit", 16.0);
        this.icSearch = this.loadIcon("search", 16.0);
    }

    private void ensureTooltip(Button btn, String fallbackText) {
        if (btn == null) {
            return;
        }
        String text = btn.getText();
        if ((text == null || text.isBlank()) && fallbackText != null) {
            text = fallbackText;
        }
        if (text == null || text.isBlank()) {
            return;
        }
        Tooltip tip = btn.getTooltip();
        if (tip == null || tip.getText() == null || tip.getText().isBlank()) {
            btn.setTooltip(new Tooltip(text));
        }
    }

    private void applyDefaultTooltips() {
        this.ensureTooltip(this.btnAddControlChain, "Add control chain");
        this.ensureTooltip(this.btnDelete, "Delete selected control chain");
        this.ensureTooltip(this.btnSaveOnly, "Save control plan");
        this.ensureTooltip(this.btnSaveExit, "Save and close");
        this.ensureTooltip(this.btnExportToPDF, "Export control plan");
        this.ensureTooltip(this.btnNext, "Search next match");
        this.ensureTooltip(this.btnRevAdd, "Add revision");
        this.ensureTooltip(this.btnRevEdit, "Edit revision");
        this.ensureTooltip(this.btnRevApprove, "Approve revision");
        this.ensureTooltip(this.btnRevDelete, "Delete revision");
    }

    private /* synthetic */ void lambda$configureRowContextMenu$6(TableRow row, ContextMenuEvent evt) {
        if (!row.isEmpty()) {
            this.tblControlChains.getSelectionModel().clearAndSelect(row.getIndex());
        }
    }

    private /* synthetic */ void lambda$configureRowContextMenu$5(TableRow row, ActionEvent evt) {
        if (row.isEmpty()) {
            return;
        }
        this.duplicateRow((ControlPlanRow)row.getItem());
    }

    private /* synthetic */ void lambda$configureRowContextMenu$4(TableRow row, ActionEvent evt) {
        if (row.isEmpty()) {
            return;
        }
        this.addRowAt(row.getIndex() + 1);
    }

    private /* synthetic */ void lambda$configureRowContextMenu$3(TableRow row, ActionEvent evt) {
        if (row.isEmpty()) {
            return;
        }
        this.tblControlChains.getSelectionModel().clearAndSelect(row.getIndex());
        this.onDeleteRow();
    }

    private /* synthetic */ void lambda$configureRowContextMenu$2(TableRow row, ObservableValue obs, Boolean old, Boolean sel) {
        this.applyControlPlanHighlight((TableRow<ControlPlanRow>)row);
    }

    private /* synthetic */ void lambda$configureRowContextMenu$1(TableRow row, ObservableValue obs, Number old, Number idx) {
        this.applyControlPlanHighlight((TableRow<ControlPlanRow>)row);
    }

    private static enum ExportFormat {
        PDF,
        EXCEL;

    }

    @FunctionalInterface
    private static interface SuggestionProvider {
        public List<String> suggest(String var1);
    }

    private static final class HorizontalScrollState {
        final double value;

        HorizontalScrollState(double value) {
            this.value = value;
        }
    }

    private final class BooleanCheckBoxCell
    extends TableCell<ControlPlanRow, Boolean> {
        private final CheckBox checkBox;
        private ObjectProperty<Boolean> currentProperty;
        private final ChangeListener<Boolean> propertyListener;
        private final Function<ControlPlanRow, ObjectProperty<Boolean>> extractor;

        private BooleanCheckBoxCell(ControlPlanWindowController controlPlanWindowController, Function<ControlPlanRow, ObjectProperty<Boolean>> extractor) {
            Objects.requireNonNull(controlPlanWindowController);
            this.checkBox = new CheckBox();
            this.propertyListener = (obs, oldV, newV) -> {
                boolean selected = Boolean.TRUE.equals(newV);
                if (this.checkBox.isSelected() != selected) {
                    this.checkBox.setSelected(selected);
                }
            };
            this.extractor = extractor;
            this.setAlignment(Pos.CENTER);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.checkBox.setAllowIndeterminate(false);
            this.checkBox.setFocusTraversable(false);
            this.checkBox.setOnAction(e -> {
                boolean selected;
                boolean previous;
                if (this.currentProperty != null && (previous = Boolean.TRUE.equals(this.currentProperty.get())) != (selected = this.checkBox.isSelected())) {
                    ObjectProperty<Boolean> targetProperty = this.currentProperty;
                    controlPlanWindowController.pushControlPlanUndo(() -> targetProperty.set((Object)previous));
                    this.currentProperty.set((Object)selected);
                    controlPlanWindowController.markDirty();
                }
            });
        }

        protected void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (this.currentProperty != null) {
                this.currentProperty.removeListener(this.propertyListener);
                this.currentProperty = null;
            }
            if (empty) {
                this.setGraphic(null);
                return;
            }
            ControlPlanRow row = null;
            if (this.getTableRow() != null) {
                row = (ControlPlanRow)this.getTableRow().getItem();
            }
            if (row == null) {
                TableView table = this.getTableView();
                int idx = this.getIndex();
                if (table != null && idx >= 0 && idx < table.getItems().size()) {
                    row = (ControlPlanRow)table.getItems().get(idx);
                }
            }
            if (row == null) {
                this.setGraphic(null);
                return;
            }
            ObjectProperty<Boolean> property = this.extractor.apply(row);
            if (property != null) {
                this.currentProperty = property;
                this.checkBox.setSelected(Boolean.TRUE.equals(property.get()));
                property.addListener(this.propertyListener);
            } else {
                this.checkBox.setSelected(false);
            }
            this.setGraphic((Node)this.checkBox);
        }
    }
}

