/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.controllers.util.MentionSuggestionBehavior;
import com.qualidadeeprodutividade.controllers.util.TableClipboardHelper;
import com.qualidadeeprodutividade.controllers.util.TableHeaderStyler;
import com.qualidadeeprodutividade.controllers.util.TableSearchNavigator;
import com.qualidadeeprodutividade.controllers.util.TableSelectionStyler;
import com.qualidadeeprodutividade.controllers.util.TableUtils;
import com.qualidadeeprodutividade.controllers.util.WrapTextAreaTableCell;
import com.qualidadeeprodutividade.export.ExportDirectoryPreferences;
import com.qualidadeeprodutividade.export.ExportFileNameUtil;
import com.qualidadeeprodutividade.export.ExportLogoPreferences;
import com.qualidadeeprodutividade.fmea.ApTableCache;
import com.qualidadeeprodutividade.fmea.ApprovalStatus;
import com.qualidadeeprodutividade.fmea.ConfidentialityLevel;
import com.qualidadeeprodutividade.fmea.Dfmea;
import com.qualidadeeprodutividade.fmea.DfmeaExcelExporter;
import com.qualidadeeprodutividade.fmea.DfmeaPdfGenerator;
import com.qualidadeeprodutividade.fmea.DfmeaRow;
import com.qualidadeeprodutividade.fmea.RevisionEntry;
import com.qualidadeeprodutividade.item.Characteristic;
import com.qualidadeeprodutividade.item.Item;
import com.qualidadeeprodutividade.item.ItemType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.net.URL;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;
import org.openpdf.text.DocumentException;

public class DfmeaWindowController
implements Initializable {
    private static final DfmeaRow.ActionPriority[][][] AP = new DfmeaRow.ActionPriority[11][11][11];
    private static final Object AP_LOAD_LOCK = new Object();
    private static volatile boolean apTableInitialized = false;
    private static final String HSCROLL_CACHE_KEY = "dfmea-horizontal-scrollbar";
    private static final String TEXT_FIELD_NAV_KEY = "dfmea-text-field-nav";
    @FXML
    private PieChart chartActionPriority;
    @FXML
    private PieChart chartActionPriorityAfter;
    @FXML
    private WebView webFta;
    @FXML
    private Button btnExportToPDF;
    @FXML
    private ImageView imgHeaderIcon;
    @FXML
    private Tab tabDfmeaTreeChart;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab tabFailureChains;
    @FXML
    private BarChart<String, Number> chartStatus;
    @FXML
    private BarChart<String, Number> chartSeverityCount;
    @FXML
    private BarChart<String, Number> chartOcurrenceCount;
    @FXML
    private BarChart<String, Number> chartDetectionCount;
    @FXML
    private TableView<DfmeaRow> tblActions;
    @FXML
    private TableColumn<DfmeaRow, String> colSummaryFocusElement;
    @FXML
    private TableColumn<DfmeaRow, String> colSummaryFailureMode;
    @FXML
    private TableColumn<DfmeaRow, String> colPreventionActionSummary;
    @FXML
    private TableColumn<DfmeaRow, String> colDetectionActionSummary;
    @FXML
    private TableColumn<DfmeaRow, String> colStatusSummary;
    @FXML
    private TableColumn<DfmeaRow, String> colResponsibleSummary;
    @FXML
    private TableColumn<DfmeaRow, LocalDate> colTargetDateSummary;
    @FXML
    private TableView<DfmeaRow> tblRows;
    @FXML
    private TableColumn<DfmeaRow, Number> colIssue;
    @FXML
    private TableColumn<DfmeaRow, String> colChangeAuthorization;
    @FXML
    private TableColumn<DfmeaRow, String> colNextHigherLevel;
    @FXML
    private TableColumn<DfmeaRow, String> colFocusElement;
    @FXML
    private TableColumn<DfmeaRow, String> colNextLowerLevelOrCharacteristic;
    @FXML
    private TableColumn<DfmeaRow, String> colNextHigherLevelFunction;
    @FXML
    private TableColumn<DfmeaRow, String> colFocusElementFunctionRequirement;
    @FXML
    private TableColumn<DfmeaRow, String> colNextLowerLevelFunctionRequirementOrCharacteristic;
    @FXML
    private TableColumn<DfmeaRow, String> colFailureEffect;
    @FXML
    private TableColumn<DfmeaRow, DfmeaRow.Severity> colSeverity;
    @FXML
    private TableColumn<DfmeaRow, String> colFailureMode;
    @FXML
    private TableColumn<DfmeaRow, String> colFailureCause;
    @FXML
    private TableColumn<DfmeaRow, String> colPreventionControl;
    @FXML
    private TableColumn<DfmeaRow, DfmeaRow.Occurrence> colOccurrence;
    @FXML
    private TableColumn<DfmeaRow, String> colDetectionControl;
    @FXML
    private TableColumn<DfmeaRow, DfmeaRow.Detection> colDetection;
    @FXML
    private TableColumn<DfmeaRow, DfmeaRow.ActionPriority> colActionPriority;
    @FXML
    private TableColumn<DfmeaRow, Number> colRpn;
    @FXML
    private TableColumn<DfmeaRow, String> colFilterCode;
    @FXML
    private TableColumn<DfmeaRow, String> colPreventiveAction;
    @FXML
    private TableColumn<DfmeaRow, String> colDetectionAction;
    @FXML
    private TableColumn<DfmeaRow, String> colResponsiblePerson;
    @FXML
    private TableColumn<DfmeaRow, LocalDate> colTargetCompletionDate;
    @FXML
    private TableColumn<DfmeaRow, LocalDate> colCompletionDate;
    @FXML
    private TableColumn<DfmeaRow, DfmeaRow.DfmeaStatus> colStatus;
    @FXML
    private TableColumn<DfmeaRow, String> colActionTakenEvidence;
    @FXML
    private TableColumn<DfmeaRow, DfmeaRow.Severity> colCurrentSeverity;
    @FXML
    private TableColumn<DfmeaRow, DfmeaRow.Occurrence> colCurrentOccurrence;
    @FXML
    private TableColumn<DfmeaRow, DfmeaRow.Detection> colCurrentDetection;
    @FXML
    private TableColumn<DfmeaRow, DfmeaRow.ActionPriority> colCurrentActionPriority;
    @FXML
    private TableColumn<DfmeaRow, String> colRemarks;
    private static final String SEARCH_HIGHLIGHT_STYLE = "-fx-background-color: #fff9c4;";
    private static final String SEARCH_HIGHLIGHT_SELECTED_STYLE = "-fx-background-color: -fx-selection-bar, rgba(255,249,196,0.65); -fx-background-insets: 0, 0;";
    @FXML
    private BorderPane root;
    @FXML
    private TextField txtSearch;
    @FXML
    private Button btnNext;
    private TableSearchNavigator<DfmeaRow> failureChainSearch;
    private Pattern searchHighlightPattern;
    @FXML
    private Button btnAddFailureChain;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnDfmeaTables;
    @FXML
    private Button btnSaveOnly;
    @FXML
    private Button btnSaveExit;
    @FXML
    private TableView<RevisionEntry> tblRevisions;
    @FXML
    private TableColumn<RevisionEntry, String> colRevNumber;
    @FXML
    private TableColumn<RevisionEntry, LocalDate> colRevDate;
    @FXML
    private TableColumn<RevisionEntry, String> colRevAuthor;
    @FXML
    private TableColumn<RevisionEntry, String> colRevDesc;
    @FXML
    private TableColumn<RevisionEntry, ApprovalStatus> colRevStatus;
    @FXML
    private Button btnRevAdd;
    @FXML
    private Button btnRevEdit;
    @FXML
    private Button btnRevApprove;
    @FXML
    private Button btnRevDelete;
    private Image icFailureChain;
    private Image icPdf;
    private Image icExcel;
    private Image icTable;
    private Image icPlus;
    private Image icTrash;
    private Image icApprove;
    private Image icEdit;
    private Image icSave;
    private Image icExit;
    private Image icSearch;
    @FXML
    private TextField txtCompanyName;
    @FXML
    private TextField txtEngineeringLocation;
    @FXML
    private TextField txtCustomerName;
    @FXML
    private TextField txtModelYearPlatform;
    @FXML
    private TextField txtDfmeaSubject;
    @FXML
    private DatePicker dpDfmeaStartDate;
    @FXML
    private DatePicker dpDfmeaRevisionDate;
    @FXML
    private TextField txtCrossFunctionalTeam;
    @FXML
    private TextField txtDfmeaIdNumber;
    @FXML
    private TextField txtDesignResponsibility;
    @FXML
    private ComboBox<ConfidentialityLevel> cbConfidentialityLevel;
    private boolean treeLoaded = false;
    private Supplier<List<Item>> productProvider;
    private final ContextMenu mentionPopup = new ContextMenu();
    private Stage ownerStage;
    private boolean hasUnsavedChanges = false;
    private boolean programmaticClose = false;
    private Runnable dirtyHook = () -> {
        this.hasUnsavedChanges = true;
    };
    private static final int MAX_DFMEA_UNDO = 50;
    private final Deque<Runnable> dfmeaUndoStack = new ArrayDeque<Runnable>();
    private Dfmea dfmea;
    private Runnable saveAction;
    private boolean verticalHeadersApplied = false;

    public static DfmeaRow.ActionPriority getAp(int s, int o, int d) {
        DfmeaWindowController.ensureApTableLoaded();
        if (s < 1 || s > 10 || o < 1 || o > 10 || d < 1 || d > 10) {
            return null;
        }
        return AP[s][o][d];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureApTableLoaded() {
        if (apTableInitialized) {
            return;
        }
        Object object = AP_LOAD_LOCK;
        synchronized (object) {
            if (apTableInitialized) {
                return;
            }
            ApTableCache.ensureLoaded();
            for (int s = 1; s <= 10; ++s) {
                for (int o = 1; o <= 10; ++o) {
                    for (int d = 1; d <= 10; ++d) {
                        DfmeaWindowController.AP[s][o][d] = DfmeaWindowController.toDfmeaPriority(ApTableCache.levelAt(s, o, d));
                    }
                }
            }
            apTableInitialized = true;
        }
    }

    private static DfmeaRow.ActionPriority toDfmeaPriority(ApTableCache.PriorityLevel level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case ApTableCache.PriorityLevel.HIGH -> DfmeaRow.ActionPriority.HIGH;
            case ApTableCache.PriorityLevel.MEDIUM -> DfmeaRow.ActionPriority.MEDIUM;
            case ApTableCache.PriorityLevel.LOW -> DfmeaRow.ActionPriority.LOW;
        };
    }

    public void setSaveAction(Runnable action) {
        this.saveAction = action;
    }

    private void textColWrapped(TableColumn<DfmeaRow, String> column, Function<DfmeaRow, StringProperty> prop) {
        if (column == null) {
            return;
        }
        column.setCellValueFactory(cell -> (ObservableValue)prop.apply((DfmeaRow)cell.getValue()));
        column.setCellFactory(col -> new WrapTextAreaTableCell(col, () -> this.searchHighlightPattern, DfmeaWindowController::navigateFromCell));
        column.setStyle("-fx-alignment: CENTER;");
        column.setOnEditCommit(edit -> {
            DfmeaRow row = (DfmeaRow)edit.getRowValue();
            if (row == null) {
                return;
            }
            StringProperty property = (StringProperty)prop.apply(row);
            if (property == null) {
                return;
            }
            String newValue = (String)edit.getNewValue();
            String oldValue = (String)property.get();
            if (Objects.equals(oldValue, newValue)) {
                return;
            }
            this.pushDfmeaUndo(() -> property.set((Object)oldValue));
            property.set((Object)newValue);
            if (this.dirtyHook != null) {
                this.dirtyHook.run();
            }
        });
    }

    private void applyFailureChainHighlight(TableRow<DfmeaRow> row) {
        if (row == null) {
            return;
        }
        if (this.failureChainSearch == null || this.failureChainSearch.getLastQuery().isEmpty() || row.isEmpty()) {
            row.setStyle("");
            return;
        }
        int matchRow = this.failureChainSearch.getCurrentMatchRow();
        if (matchRow == row.getIndex()) {
            if (row.isSelected()) {
                row.setStyle(SEARCH_HIGHLIGHT_SELECTED_STYLE);
            } else {
                row.setStyle(SEARCH_HIGHLIGHT_STYLE);
            }
        } else {
            row.setStyle("");
        }
    }

    public void setOwnerStage(Stage s) {
        this.ownerStage = s;
        this.installCloseHandler();
    }

    public void setDirtyHook(Runnable r) {
        Runnable delegate = r != null ? r : () -> {};
        this.dirtyHook = () -> {
            this.hasUnsavedChanges = true;
            delegate.run();
        };
    }

    private void handleTableClipboardPaste() {
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        this.scheduleSummaryRefresh();
        this.scheduleTreeRefresh();
    }

    public void setProductProvider(Supplier<List<Item>> provider) {
        this.productProvider = provider;
    }

    public void setDfmea(Dfmea model) {
        DfmeaWindowController.ensureApTableLoaded();
        this.dfmea = model;
        this.hasUnsavedChanges = false;
        this.dfmeaUndoStack.clear();
        this.loadHeaderFromModel();
        this.wireHeaderBindings();
        this.enableSubjectMentions();
        this.updateWindowTitle(DfmeaWindowController.s(this.dfmea.getDfmeaSubject()));
        this.initRevisionTab();
        if (this.tblRows != null) {
            this.tblRows.setItems(this.dfmea.getFailureChains());
            this.tblRows.setFixedCellSize(-1.0);
            Platform.runLater(() -> this.tblRows.requestFocus());
        }
        if (this.btnAddFailureChain != null) {
            this.btnAddFailureChain.setOnAction(e -> this.onAddChain());
            this.btnAddFailureChain.setTooltip(new Tooltip("Add DFMEA failure chain"));
            this.btnAddFailureChain.setGraphic((Node)this.icon(this.icFailureChain, 18.0));
        }
        if (this.btnDelete != null) {
            this.btnDelete.setOnAction(e -> this.onDeleteSelectedChain());
            this.btnDelete.setTooltip(new Tooltip("Delete selected row"));
            this.btnDelete.setGraphic((Node)this.icon(this.icTrash, 18.0));
        }
        for (DfmeaRow r : this.dfmea.getFailureChains()) {
            if (r.getSeverity() == null) {
                r.setSeverity(DfmeaRow.Severity.ONE);
            }
            if (r.getOccurrence() == null) {
                r.setOccurrence(DfmeaRow.Occurrence.ONE);
            }
            if (r.getDetection() == null) {
                r.setDetection(DfmeaRow.Detection.ONE);
            }
            if (r.getCurrentSeverity() == null) {
                r.setCurrentSeverity(DfmeaRow.Severity.ONE);
            }
            if (r.getCurrentOccurrence() == null) {
                r.setCurrentOccurrence(DfmeaRow.Occurrence.ONE);
            }
            if (r.getCurrentDetection() == null) {
                r.setCurrentDetection(DfmeaRow.Detection.ONE);
            }
            this.attachApListeners(r);
            this.wireSummaryRowListeners(r);
            this.attachTreeRefreshRowListeners(r);
        }
        this.scheduleSummaryRefresh();
        this.dfmea.getFailureChains().addListener(c -> {
            boolean changed = false;
            while (c.next()) {
                if (c.wasAdded()) {
                    for (DfmeaRow r : c.getAddedSubList()) {
                        if (r.getSeverity() == null) {
                            r.setSeverity(DfmeaRow.Severity.ONE);
                        }
                        if (r.getOccurrence() == null) {
                            r.setOccurrence(DfmeaRow.Occurrence.ONE);
                        }
                        if (r.getDetection() == null) {
                            r.setDetection(DfmeaRow.Detection.ONE);
                        }
                        if (r.getCurrentSeverity() == null) {
                            r.setCurrentSeverity(DfmeaRow.Severity.ONE);
                        }
                        if (r.getCurrentOccurrence() == null) {
                            r.setCurrentOccurrence(DfmeaRow.Occurrence.ONE);
                        }
                        if (r.getCurrentDetection() == null) {
                            r.setCurrentDetection(DfmeaRow.Detection.ONE);
                        }
                        this.attachApListeners(r);
                        this.wireSummaryRowListeners(r);
                        this.attachTreeRefreshRowListeners(r);
                    }
                    changed = true;
                }
                if (!c.wasRemoved()) continue;
                changed = true;
            }
            if (changed) {
                this.scheduleSummaryRefresh();
            }
            this.scheduleTreeRefresh();
        });
        if (this.tblActions != null && this.dfmea != null) {
            this.updateActionsTable((List<DfmeaRow>)this.dfmea.getFailureChains());
        }
        if (this.btnExportToPDF != null && this.btnExportToPDF.getOnAction() == null) {
            this.wireExportButton();
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        BooleanBinding deleteDisable;
        BooleanBinding onFailureTab;
        this.loadIcons();
        this.configureHeaderIcon();
        TableSelectionStyler.ensureAll(new Control[]{this.tblRows, this.tblActions});
        TableHeaderStyler.ensureAll(new Control[]{this.tblRows, this.tblActions});
        this.applyHeaderReadOnlyMode();
        if (this.btnAddFailureChain != null) {
            this.btnAddFailureChain.setOnAction(e -> this.onAddChain());
            this.btnAddFailureChain.setTooltip(new Tooltip("Add DFMEA failure chain"));
        }
        if (this.btnDelete != null) {
            this.btnDelete.setOnAction(e -> this.onDeleteSelectedChain());
            this.btnDelete.setTooltip(new Tooltip("Delete selected row"));
            this.btnDelete.disableProperty().bind((ObservableValue)Bindings.isNotNull((ObservableObjectValue)this.tblRows.editingCellProperty()).or((ObservableBooleanValue)this.tblRows.getSelectionModel().selectedItemProperty().isNull()));
        }
        if (this.tabPane != null && this.tabFailureChains != null) {
            onFailureTab = Bindings.createBooleanBinding(() -> this.tabPane.getSelectionModel().getSelectedItem() == this.tabFailureChains, (Observable[])new Observable[]{this.tabPane.getSelectionModel().selectedItemProperty()});
            if (this.btnAddFailureChain != null) {
                this.btnAddFailureChain.disableProperty().unbind();
                this.btnAddFailureChain.disableProperty().bind((ObservableValue)onFailureTab.not());
            }
            if (this.btnDelete != null && this.tblRows != null) {
                this.btnDelete.disableProperty().unbind();
                deleteDisable = onFailureTab.not().or((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.tblRows.editingCellProperty())).or((ObservableBooleanValue)this.tblRows.getSelectionModel().selectedItemProperty().isNull());
                this.btnDelete.disableProperty().bind((ObservableValue)deleteDisable);
            }
        }
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setOnAction(e -> this.onSaveOnly());
            this.btnSaveOnly.setTooltip(new Tooltip("Save current DFMEA"));
            this.btnSaveOnly.setGraphic((Node)this.icon(this.icSave, 18.0));
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setOnAction(e -> this.onSaveAndExit());
            this.btnSaveExit.setTooltip(new Tooltip("Save current DFMEA and close"));
            this.btnSaveExit.setGraphic((Node)this.icon(this.icExit, 18.0));
        }
        if (this.btnExportToPDF != null) {
            this.btnExportToPDF.setGraphic((Node)this.icon(this.icPdf, 16.0));
        }
        if (this.btnDfmeaTables != null) {
            this.btnDfmeaTables.setGraphic((Node)this.icon(this.icTable, 18.0));
            this.btnDfmeaTables.setContentDisplay(ContentDisplay.LEFT);
            this.btnDfmeaTables.setOnAction(e -> this.onOpenDfmeaTables());
        }
        if (this.tblRows != null) {
            this.tblRows.setFixedCellSize(-1.0);
            this.tblRows.setStyle("-fx-cell-size: -1;");
            this.configureRowContextMenu();
            TableClipboardHelper.install(this.tblRows, this::handleTableClipboardPaste);
            if (this.txtSearch != null && this.btnNext != null) {
                this.failureChainSearch = TableSearchNavigator.install(this.tblRows, this.txtSearch, this.btnNext);
                if (this.failureChainSearch != null) {
                    this.updateSearchPattern();
                    this.failureChainSearch.setOnStateChanged(() -> {
                        this.tblRows.refresh();
                        this.updateSearchPattern();
                    });
                    this.btnNext.setGraphic((Node)this.icon(this.icSearch, 16.0));
                    this.btnNext.setText(null);
                    this.ensureTooltip(this.btnNext, "Search next match");
                } else {
                    this.searchHighlightPattern = null;
                }
            }
        }
        this.centerCells(this.colIssue, this.colChangeAuthorization, this.colSeverity, this.colOccurrence, this.colDetection, this.colCurrentSeverity, this.colCurrentOccurrence, this.colCurrentDetection, this.colActionPriority, this.colCurrentActionPriority, this.colFilterCode, this.colStatus, this.colRpn);
        this.setupFailureChainsTable();
        if (this.cbConfidentialityLevel != null) {
            this.cbConfidentialityLevel.setItems(FXCollections.observableArrayList((Object[])ConfidentialityLevel.values()));
        }
        this.applyVerticalHeadersWhenSkinReady();
        if (this.tabPane != null && this.tabFailureChains != null) {
            onFailureTab = Bindings.createBooleanBinding(() -> this.tabPane.getSelectionModel().getSelectedItem() == this.tabFailureChains, (Observable[])new Observable[]{this.tabPane.getSelectionModel().selectedItemProperty()});
            if (this.btnAddFailureChain != null) {
                this.btnAddFailureChain.disableProperty().unbind();
                this.btnAddFailureChain.disableProperty().bind((ObservableValue)onFailureTab.not());
            }
            if (this.btnDelete != null && this.tblRows != null) {
                this.btnDelete.disableProperty().unbind();
                deleteDisable = onFailureTab.not().or((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.tblRows.editingCellProperty())).or((ObservableBooleanValue)this.tblRows.getSelectionModel().selectedItemProperty().isNull());
                this.btnDelete.disableProperty().bind((ObservableValue)deleteDisable);
            }
        }
        if (this.tabPane != null && this.tabDfmeaTreeChart != null) {
            this.tabPane.getSelectionModel().selectedItemProperty().addListener((obs, oldTab, newTab) -> {
                if (newTab == this.tabDfmeaTreeChart && !this.treeLoaded) {
                    this.loadDfmeaTreePage();
                    this.treeLoaded = true;
                }
            });
        }
        this.wireExportButton();
    }

    private void loadDfmeaTreePage() {
        if (this.webFta == null) {
            return;
        }
        WebEngine engine = this.webFta.getEngine();
        URL url = this.getClass().getResource("/html/dfmea-tree.html");
        if (url == null) {
            engine.loadContent("<h3>dfmea-tree.html not found.</h3>");
            return;
        }
        engine.getLoadWorker().stateProperty().addListener((o, old, st) -> {
            if (st == Worker.State.SUCCEEDED) {
                Platform.runLater(this::sendDfmeaJsonToPage);
            }
        });
        engine.load(url.toExternalForm());
    }

    private void sendDfmeaJsonToPage() {
        if (this.webFta == null || this.dfmea == null) {
            return;
        }
        String json = this.toDfmeaJson(this.dfmea);
        try {
            this.webFta.getEngine().executeScript("window.renderDfmea && window.renderDfmea(" + json + ");");
        }
        catch (Exception ex) {
            System.err.println("[DFMEA] renderDfmea call failed: " + ex.getMessage());
        }
    }

    private String toDfmeaJson(Dfmea model) {
        String subject = model.getDfmeaSubject() != null && !model.getDfmeaSubject().isBlank() ? model.getDfmeaSubject() : "Product Tree Root";
        StringBuilder sb = new StringBuilder(1024);
        sb.append("{\"subject\":\"").append(DfmeaWindowController.escapeJson(subject)).append("\",\"rows\":[");
        boolean first = true;
        for (DfmeaRow r : model.getFailureChains()) {
            if (!first) {
                sb.append(',');
            }
            first = false;
            String higherTxt = DfmeaWindowController.nz(r.getNextHigherLevelText());
            String higherFn = DfmeaWindowController.nz(r.getNextHigherLevelFunction());
            String focusTxt = DfmeaWindowController.nz(r.getFocusElementText());
            String focusFn = DfmeaWindowController.nz(r.getFocusElementFunctionRequirement());
            String lowerTxt = DfmeaWindowController.nz(r.getNextLowerLevelOrCharacteristicText());
            String lowerFn = DfmeaWindowController.nz(r.getNextLowerLevelFunctionRequirementOrCharacteristic());
            String fe = DfmeaWindowController.nz(r.getFailureEffect());
            String fm = DfmeaWindowController.nz(r.getFailureMode());
            String fc = DfmeaWindowController.nz(r.getFailureCause());
            String prevCtrl = DfmeaWindowController.nz(r.getPreventionControl());
            String detCtrl = DfmeaWindowController.nz(r.getDetectionControl());
            String ap = r.getActionPriority() == null ? "LOW" : r.getActionPriority().name();
            sb.append("{").append("\"nextHigherLevelText\":\"").append(DfmeaWindowController.escapeJson(higherTxt)).append("\",").append("\"nextHigherLevelFunction\":\"").append(DfmeaWindowController.escapeJson(higherFn)).append("\",").append("\"focusElementText\":\"").append(DfmeaWindowController.escapeJson(focusTxt)).append("\",").append("\"focusElementFunctionRequirement\":\"").append(DfmeaWindowController.escapeJson(focusFn)).append("\",").append("\"nextLowerLevelOrCharacteristicText\":\"").append(DfmeaWindowController.escapeJson(lowerTxt)).append("\",").append("\"nextLowerLevelFunctionRequirementOrCharacteristic\":\"").append(DfmeaWindowController.escapeJson(lowerFn)).append("\",").append("\"failureEffect\":\"").append(DfmeaWindowController.escapeJson(fe)).append("\",").append("\"failureMode\":\"").append(DfmeaWindowController.escapeJson(fm)).append("\",").append("\"failureCause\":\"").append(DfmeaWindowController.escapeJson(fc)).append("\",").append("\"preventionControl\":\"").append(DfmeaWindowController.escapeJson(prevCtrl)).append("\",").append("\"detectionControl\":\"").append(DfmeaWindowController.escapeJson(detCtrl)).append("\",").append("\"actionPriority\":\"").append(DfmeaWindowController.escapeJson(ap)).append("\"").append("}");
        }
        sb.append("]}");
        return sb.toString();
    }

    private static String nz(String s) {
        return s == null ? "" : s;
    }

    private static String escapeJson(String s) {
        StringBuilder out = new StringBuilder(s.length() + 16);
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    out.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    out.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    out.append("\\b");
                    continue block9;
                }
                case '\f': {
                    out.append("\\f");
                    continue block9;
                }
                case '\n': {
                    out.append("\\n");
                    continue block9;
                }
                case '\r': {
                    out.append("\\r");
                    continue block9;
                }
                case '\t': {
                    out.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        out.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    private void loadHeaderFromModel() {
        if (this.dfmea == null) {
            return;
        }
        if (this.txtCompanyName != null) {
            this.txtCompanyName.setText(DfmeaWindowController.s(this.dfmea.getCompanyName()));
        }
        if (this.txtEngineeringLocation != null) {
            this.txtEngineeringLocation.setText(DfmeaWindowController.s(this.dfmea.getEngineeringLocation()));
        }
        if (this.txtCustomerName != null) {
            this.txtCustomerName.setText(DfmeaWindowController.s(this.dfmea.getCustomerName()));
        }
        if (this.txtModelYearPlatform != null) {
            this.txtModelYearPlatform.setText(DfmeaWindowController.s(this.dfmea.getModelYearPlatform()));
        }
        if (this.txtDfmeaSubject != null) {
            this.txtDfmeaSubject.setText(DfmeaWindowController.s(this.dfmea.getDfmeaSubject()));
        }
        if (this.dpDfmeaStartDate != null) {
            this.dpDfmeaStartDate.setValue((Object)this.dfmea.getDfmeaStartDate());
        }
        if (this.dpDfmeaRevisionDate != null) {
            this.dpDfmeaRevisionDate.setValue((Object)this.dfmea.getDfmeaLastRevisionDate());
        }
        if (this.txtCrossFunctionalTeam != null) {
            this.txtCrossFunctionalTeam.setText(DfmeaWindowController.s(this.dfmea.getCrossFunctionalTeam()));
        }
        if (this.txtDfmeaIdNumber != null) {
            this.txtDfmeaIdNumber.setText(DfmeaWindowController.s(this.dfmea.getDfmeaIdNumber()));
        }
        if (this.txtDesignResponsibility != null) {
            this.txtDesignResponsibility.setText(DfmeaWindowController.s(this.dfmea.getDesignResponsibility()));
        }
        if (this.cbConfidentialityLevel != null) {
            this.cbConfidentialityLevel.setValue((Object)this.dfmea.getConfidentialityLevel());
        }
        this.updateWindowTitle(DfmeaWindowController.s(this.dfmea.getDfmeaSubject()));
    }

    private void wireHeaderBindings() {
        if (this.dfmea == null) {
            return;
        }
        this.onText(this.txtCompanyName, this.dfmea::setCompanyName);
        this.onText(this.txtEngineeringLocation, this.dfmea::setEngineeringLocation);
        this.onText(this.txtCustomerName, this.dfmea::setProductName);
        this.onText(this.txtModelYearPlatform, this.dfmea::setModelYearPlatform);
        this.onText(this.txtDfmeaSubject, v -> {
            this.dfmea.setDfmeaSubject((String)v);
            this.updateWindowTitle((String)v);
        });
        this.onDate(this.dpDfmeaStartDate, this.dfmea::setDfmeaStartDate);
        this.onDate(this.dpDfmeaRevisionDate, this.dfmea::setDfmeaLastRevisionDate);
        this.onText(this.txtCrossFunctionalTeam, this.dfmea::setCrossFunctionalTeam);
        this.onText(this.txtDfmeaIdNumber, this.dfmea::setDfmeaIdNumber);
        this.onText(this.txtDesignResponsibility, this.dfmea::setDesignResponsibility);
        if (this.cbConfidentialityLevel != null) {
            this.cbConfidentialityLevel.valueProperty().addListener((o, ov, nv) -> {
                this.dfmea.setConfidentialityLevel((ConfidentialityLevel)((Object)nv));
                this.dirtyHook.run();
            });
        }
    }

    private void enableSubjectMentions() {
        if (this.txtDfmeaSubject == null) {
            return;
        }
        MentionSuggestionBehavior.install((TextInputControl)this.txtDfmeaSubject, this.mentionPopup, MentionSuggestionBehavior.config().allowedQueryChar(ch -> Character.isLetterOrDigit(ch.charValue()) || ch.charValue() == '_' || ch.charValue() == '-' || ch.charValue() == ' ').suggestions(this::findMatches).menuBuilder(this::buildMentionMenu).insertionText(this::subjectMentionText));
    }

    private List<Item> findMatches(String partial) {
        List<Item> all;
        List<Item> list = all = this.productProvider == null ? null : this.productProvider.get();
        if (all == null || all.isEmpty()) {
            return List.of();
        }
        String p = partial == null ? "" : partial.trim().toLowerCase();
        return all.stream().filter(it -> it.getType() == ItemType.PRODUCT || it.getType() == ItemType.SYSTEM).filter(it -> p.isBlank() || it.getDescription() != null && it.getDescription().toLowerCase().contains(p)).limit(200L).toList();
    }

    private void buildMentionMenu(ContextMenu menu, List<Item> items, Consumer<Item> onChoose) {
        boolean first;
        MenuItem header;
        menu.getItems().clear();
        ArrayList<Item> products = new ArrayList<Item>();
        ArrayList systems = new ArrayList();
        for (Item it : items) {
            (it.getType() == ItemType.PRODUCT ? products : systems).add(it);
        }
        boolean addedHeader = false;
        if (!products.isEmpty()) {
            header = new MenuItem("\u2014 Products \u2014");
            header.setDisable(true);
            menu.getItems().add((Object)header);
            first = true;
            for (Item it : products) {
                if (!first) {
                    menu.getItems().add((Object)new SeparatorMenuItem());
                }
                first = false;
                menu.getItems().add((Object)this.makeMentionMenuItem(it, onChoose));
            }
            addedHeader = true;
        }
        if (addedHeader && !systems.isEmpty()) {
            menu.getItems().add((Object)new SeparatorMenuItem());
        }
        if (!systems.isEmpty()) {
            header = new MenuItem("\u2014 Systems \u2014");
            header.setDisable(true);
            menu.getItems().add((Object)header);
            first = true;
            for (Item it : systems) {
                if (!first) {
                    menu.getItems().add((Object)new SeparatorMenuItem());
                }
                first = false;
                menu.getItems().add((Object)this.makeMentionMenuItem(it, onChoose));
            }
        }
    }

    private String subjectMentionText(Item it) {
        if (it == null) {
            return "";
        }
        String name = it.getDescription();
        return name == null || name.isBlank() ? "(unnamed)" : name;
    }

    private MenuItem makeMentionMenuItem(Item it, Consumer<Item> onChoose) {
        String name = this.subjectMentionText(it);
        String function = it.getFunction() == null ? "" : it.getFunction().trim();
        String typeTag = it.getType() == ItemType.PRODUCT ? "Product" : "System";
        Label title = new Label(name);
        title.setStyle("-fx-font-size: 12px;");
        String subText = (String)(function.isBlank() ? "" : function + "  \u00b7 ") + typeTag;
        Label sub = new Label(subText);
        sub.setStyle("-fx-text-fill: #666666; -fx-font-size: 11px;");
        VBox box = new VBox(2.0, new Node[]{title, sub});
        MenuItem mi = new MenuItem();
        mi.setGraphic((Node)box);
        mi.setMnemonicParsing(false);
        mi.setOnAction(e -> onChoose.accept(it));
        return mi;
    }

    private void onText(TextField tf, Consumer<String> writeBack) {
        if (tf == null) {
            return;
        }
        tf.textProperty().addListener((o, ov, nv) -> {
            writeBack.accept(nv == null ? "" : nv);
            this.dirtyHook.run();
        });
    }

    private void onDate(DatePicker dp, Consumer<LocalDate> writeBack) {
        if (dp == null) {
            return;
        }
        dp.valueProperty().addListener((o, ov, nv) -> {
            writeBack.accept((LocalDate)nv);
            this.dirtyHook.run();
        });
    }

    private void updateWindowTitle(String subject) {
        if (this.ownerStage == null) {
            return;
        }
        this.ownerStage.setTitle((String)(subject == null || subject.isBlank() ? "DFMEA" : "DFMEA \u2014 " + subject));
    }

    private static String s(String v) {
        return v == null ? "" : v;
    }

    private void initRevisionTab() {
        if (this.tblRevisions == null) {
            return;
        }
        this.colRevNumber.setCellValueFactory((Callback)new PropertyValueFactory("revisionNumber"));
        this.colRevDate.setCellValueFactory((Callback)new PropertyValueFactory("revisionDate"));
        this.colRevAuthor.setCellValueFactory((Callback)new PropertyValueFactory("authorName"));
        this.colRevDesc.setCellValueFactory((Callback)new PropertyValueFactory("descriptionOfChanges"));
        this.colRevStatus.setCellValueFactory((Callback)new PropertyValueFactory("approvalStatus"));
        this.colRevStatus.setCellFactory(col -> new TableCell<RevisionEntry, ApprovalStatus>(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void updateItem(ApprovalStatus status, boolean empty) {
                super.updateItem((Object)status, empty);
                this.setText(empty || status == null ? "" : status.getApprovalStatus());
            }
        });
        this.tblRevisions.setItems(this.dfmea.getRevisionHistory());
        this.tblRevisions.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            boolean has;
            boolean bl = has = nv != null;
            if (this.btnRevEdit != null) {
                this.btnRevEdit.setDisable(!has);
            }
            if (this.btnRevApprove != null) {
                this.btnRevApprove.setDisable(!has);
            }
            if (this.btnRevDelete != null) {
                this.btnRevDelete.setDisable(!has);
            }
        });
        if (this.btnRevAdd != null) {
            this.btnRevAdd.setOnAction(e -> this.onRevAdd());
        }
        if (this.btnRevEdit != null) {
            this.btnRevEdit.setOnAction(e -> this.onRevEdit());
        }
        if (this.btnRevApprove != null) {
            this.btnRevApprove.setOnAction(e -> this.onRevApprove());
        }
        if (this.btnRevDelete != null) {
            this.btnRevDelete.setOnAction(e -> this.onRevDelete());
        }
        if (this.btnRevAdd != null) {
            this.btnRevAdd.setGraphic((Node)this.icon(this.icPlus, 16.0));
        }
        if (this.btnRevEdit != null) {
            this.btnRevEdit.setGraphic((Node)this.icon(this.icEdit, 16.0));
        }
        if (this.btnRevApprove != null) {
            this.btnRevApprove.setGraphic((Node)this.icon(this.icApprove, 16.0));
        }
        if (this.btnRevDelete != null) {
            this.btnRevDelete.setGraphic((Node)this.icon(this.icTrash, 16.0));
        }
        this.applyDefaultTooltips();
    }

    private void onRevAdd() {
        if (!this.ensureEditPermission()) {
            return;
        }
        RevisionEntry data = this.showRevisionDialog(null);
        if (data == null) {
            return;
        }
        this.dfmea.getRevisionHistory().add((Object)data);
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        if (this.tblRevisions != null) {
            this.tblRevisions.getSelectionModel().select((Object)data);
            this.tblRevisions.scrollTo((Object)data);
        }
    }

    private void onRevEdit() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.tblRevisions == null) {
            return;
        }
        RevisionEntry sel = (RevisionEntry)this.tblRevisions.getSelectionModel().getSelectedItem();
        if (sel == null) {
            return;
        }
        RevisionEntry edited = this.showRevisionDialog(sel);
        if (edited == null) {
            return;
        }
        sel.setRevisionNumber(edited.getRevisionNumber());
        sel.setRevisionDate(edited.getRevisionDate());
        sel.setAuthorName(edited.getAuthorName());
        sel.setDescriptionOfChanges(edited.getDescriptionOfChanges());
        this.tblRevisions.refresh();
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private void onRevApprove() {
        if (!this.ensureApprovalPermission()) {
            return;
        }
        if (this.tblRevisions == null) {
            return;
        }
        RevisionEntry sel = (RevisionEntry)this.tblRevisions.getSelectionModel().getSelectedItem();
        if (sel == null) {
            return;
        }
        this.dfmea.approveRevision(sel);
        this.tblRevisions.refresh();
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private void onRevDelete() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.tblRevisions == null) {
            return;
        }
        RevisionEntry sel = (RevisionEntry)this.tblRevisions.getSelectionModel().getSelectedItem();
        if (sel == null) {
            return;
        }
        this.dfmea.removeRevision(sel);
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private RevisionEntry showRevisionDialog(RevisionEntry existing) {
        Dialog dlg = new Dialog();
        dlg.setTitle(existing == null ? "Add Revision" : "Edit Revision");
        dlg.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        TextField tfRev = new TextField(existing == null ? "" : DfmeaWindowController.s(existing.getRevisionNumber()));
        DatePicker dpDate = new DatePicker(existing == null ? LocalDate.now() : existing.getRevisionDate());
        TextField tfAuth = new TextField(existing == null ? "" : DfmeaWindowController.s(existing.getAuthorName()));
        TextArea taDesc = new TextArea(existing == null ? "" : DfmeaWindowController.s(existing.getDescriptionOfChanges()));
        taDesc.setPrefRowCount(4);
        GridPane gp = new GridPane();
        gp.setHgap(8.0);
        gp.setVgap(8.0);
        gp.setPadding(new Insets(10.0));
        gp.add((Node)new Label("Revision:"), 0, 0);
        gp.add((Node)tfRev, 1, 0);
        gp.add((Node)new Label("Date:"), 0, 1);
        gp.add((Node)dpDate, 1, 1);
        gp.add((Node)new Label("Author:"), 0, 2);
        gp.add((Node)tfAuth, 1, 2);
        gp.add((Node)new Label("Description:"), 0, 3);
        gp.add((Node)taDesc, 1, 3);
        dlg.getDialogPane().setContent((Node)gp);
        Node okBtn = dlg.getDialogPane().lookupButton(ButtonType.OK);
        okBtn.disableProperty().bind((ObservableValue)tfRev.textProperty().isEmpty().or((ObservableBooleanValue)tfAuth.textProperty().isEmpty()).or((ObservableBooleanValue)dpDate.valueProperty().isNull()));
        Optional res = dlg.showAndWait();
        if (res.isEmpty() || res.get() != ButtonType.OK) {
            return null;
        }
        if (existing == null) {
            return new RevisionEntry(tfRev.getText().trim(), (LocalDate)dpDate.getValue(), tfAuth.getText().trim(), taDesc.getText().trim(), ApprovalStatus.DRAFT);
        }
        return new RevisionEntry(tfRev.getText().trim(), (LocalDate)dpDate.getValue(), tfAuth.getText().trim(), taDesc.getText().trim(), existing.getApprovalStatus());
    }

    private void setupFailureChainsTable() {
        if (this.tblRows == null) {
            return;
        }
        this.tblRows.setEditable(true);
        this.tblRows.getSelectionModel().setCellSelectionEnabled(true);
        this.mentionTextCol(this.colNextHigherLevel, DfmeaRow::nextHigherLevelTextProperty, MentionKind.HIGHER);
        this.mentionTextCol(this.colFocusElement, DfmeaRow::focusElementTextProperty, MentionKind.FOCUS);
        this.mentionTextCol(this.colNextLowerLevelOrCharacteristic, DfmeaRow::nextLowerLevelOrCharacteristicTextProperty, MentionKind.LOWER);
        this.textColWrapped(this.colChangeAuthorization, DfmeaRow::changeAuthorizationProperty);
        this.textColWrapped(this.colNextHigherLevelFunction, DfmeaRow::nextHigherLevelFunctionProperty);
        this.textColWrapped(this.colFocusElementFunctionRequirement, DfmeaRow::focusElementFunctionRequirementProperty);
        this.textColWrapped(this.colNextLowerLevelFunctionRequirementOrCharacteristic, DfmeaRow::nextLowerLevelFunctionRequirementOrCharacteristicProperty);
        this.textColWrapped(this.colFailureEffect, DfmeaRow::failureEffectProperty);
        this.textColWrapped(this.colFailureMode, DfmeaRow::failureModeProperty);
        this.textColWrapped(this.colFailureCause, DfmeaRow::failureCauseProperty);
        this.textColWrapped(this.colPreventionControl, DfmeaRow::preventionControlProperty);
        this.textColWrapped(this.colDetectionControl, DfmeaRow::detectionControlProperty);
        this.textColWrapped(this.colFilterCode, DfmeaRow::filterCodeProperty);
        this.textColWrapped(this.colPreventiveAction, DfmeaRow::preventiveActionProperty);
        this.textColWrapped(this.colDetectionAction, DfmeaRow::detectionActionProperty);
        this.textColWrapped(this.colResponsiblePerson, DfmeaRow::responsiblePersonProperty);
        this.datePickerCol(this.colTargetCompletionDate, DfmeaRow::targetCompletionDateProperty);
        this.datePickerCol(this.colCompletionDate, DfmeaRow::completionDateProperty);
        this.textColWrapped(this.colActionTakenEvidence, DfmeaRow::actionTakenEvidenceProperty);
        this.textColWrapped(this.colRemarks, DfmeaRow::remarksProperty);
        this.integerCol(this.colIssue, DfmeaRow::issueNumberProperty);
        this.enumCol(this.colSeverity, DfmeaRow.Severity.values(), DfmeaRow::severityProperty, DfmeaRow.Severity::getValue);
        this.enumCol(this.colOccurrence, DfmeaRow.Occurrence.values(), DfmeaRow::occurrenceProperty, DfmeaRow.Occurrence::getValue);
        this.enumCol(this.colDetection, DfmeaRow.Detection.values(), DfmeaRow::detectionProperty, DfmeaRow.Detection::getValue);
        this.enumCol(this.colCurrentSeverity, DfmeaRow.Severity.values(), DfmeaRow::currentSeverityProperty, DfmeaRow.Severity::getValue);
        this.enumCol(this.colCurrentOccurrence, DfmeaRow.Occurrence.values(), DfmeaRow::currentOccurrenceProperty, DfmeaRow.Occurrence::getValue);
        this.enumCol(this.colCurrentDetection, DfmeaRow.Detection.values(), DfmeaRow::currentDetectionProperty, DfmeaRow.Detection::getValue);
        this.readOnlyApCol(this.colActionPriority, DfmeaRow::actionPriorityProperty);
        this.readOnlyApCol(this.colCurrentActionPriority, DfmeaRow::currentActionPriorityProperty);
        this.colStatus.setCellValueFactory(cell -> ((DfmeaRow)cell.getValue()).statusProperty());
        StringConverter<DfmeaRow.DfmeaStatus> statusConverter = new StringConverter<DfmeaRow.DfmeaStatus>(this){
            {
                Objects.requireNonNull(this$0);
            }

            public String toString(DfmeaRow.DfmeaStatus s) {
                if (s == null) {
                    return "";
                }
                return switch (s) {
                    default -> throw new MatchException(null, null);
                    case DfmeaRow.DfmeaStatus.OPEN -> "Open";
                    case DfmeaRow.DfmeaStatus.PENDING_DECISION -> "Pending decision";
                    case DfmeaRow.DfmeaStatus.PENDING_IMPLEMENTATION -> "Pending implementation";
                    case DfmeaRow.DfmeaStatus.COMPLETED -> "Completed";
                    case DfmeaRow.DfmeaStatus.NOT_IMPLEMENTED -> "Not implemented";
                };
            }

            public DfmeaRow.DfmeaStatus fromString(String s) {
                return null;
            }
        };
        this.colStatus.setCellFactory(ComboBoxTableCell.forTableColumn((StringConverter)statusConverter, (ObservableList)FXCollections.observableArrayList((Object[])DfmeaRow.DfmeaStatus.values())));
        this.colStatus.setOnEditCommit(edit -> {
            DfmeaRow.DfmeaStatus newValue;
            DfmeaRow row = (DfmeaRow)edit.getRowValue();
            if (row == null) {
                return;
            }
            DfmeaRow.DfmeaStatus oldValue = row.getStatus();
            if (Objects.equals((Object)oldValue, (Object)(newValue = (DfmeaRow.DfmeaStatus)((Object)((Object)edit.getNewValue()))))) {
                return;
            }
            this.pushDfmeaUndo(() -> row.setStatus(oldValue));
            row.setStatus(newValue);
            if (this.dirtyHook != null) {
                this.dirtyHook.run();
            }
            if (this.tblRows != null) {
                this.tblRows.refresh();
            }
        });
        this.colRpn.setCellValueFactory(cd -> Bindings.createIntegerBinding(() -> {
            DfmeaRow row = (DfmeaRow)cd.getValue();
            int s = row.getSeverity() != null ? row.getSeverity().getValue() : 0;
            int o = row.getOccurrence() != null ? row.getOccurrence().getValue() : 0;
            int d = row.getDetection() != null ? row.getDetection().getValue() : 0;
            return s * o * d;
        }, (Observable[])new Observable[]{((DfmeaRow)cd.getValue()).severityProperty(), ((DfmeaRow)cd.getValue()).occurrenceProperty(), ((DfmeaRow)cd.getValue()).detectionProperty()}));
        this.tblRows.setOnKeyPressed(keyEvent -> {
            if (keyEvent.isControlDown() && keyEvent.getCode() == KeyCode.Z) {
                TablePosition<DfmeaRow, ?> snapshot = this.captureDfmeaFocus();
                if (this.performDfmeaUndo()) {
                    this.restoreDfmeaFocus(snapshot);
                }
                keyEvent.consume();
                return;
            }
            switch (keyEvent.getCode()) {
                case INSERT: {
                    this.onAddChain();
                    break;
                }
                case DELETE: {
                    boolean changed;
                    if (this.tblRows.getEditingCell() == null && (changed = TableClipboardHelper.clearFocusedCell(this.tblRows, this::pushDfmeaUndo)) && this.dirtyHook != null) {
                        this.dirtyHook.run();
                    }
                    keyEvent.consume();
                    break;
                }
            }
        });
    }

    private void applyVerticalHeadersWhenSkinReady() {
        if (this.tblRows == null) {
            return;
        }
        this.tblRows.skinProperty().addListener((o, oldSkin, newSkin) -> {
            if (newSkin != null && !this.verticalHeadersApplied) {
                this.applyVerticalHeadersNow();
                this.verticalHeadersApplied = true;
            }
        });
        if (this.tblRows.getSkin() != null && !this.verticalHeadersApplied) {
            this.applyVerticalHeadersNow();
            this.verticalHeadersApplied = true;
        }
    }

    private void applyVerticalHeadersNow() {
        TableUtils.makeHeaderVertical(this.tblRows, this.colSeverity, 86.0);
        TableUtils.makeHeaderVertical(this.tblRows, this.colCurrentSeverity, 86.0);
        TableUtils.makeHeaderVertical(this.tblRows, this.colOccurrence, 86.0);
        TableUtils.makeHeaderVertical(this.tblRows, this.colCurrentOccurrence, 86.0);
        TableUtils.makeHeaderVertical(this.tblRows, this.colDetection, 86.0);
        TableUtils.makeHeaderVertical(this.tblRows, this.colCurrentDetection, 86.0);
        TableUtils.wrapHeader(this.tblRows, this.colIssue, "Issue");
        TableUtils.wrapHeader(this.tblRows, this.colChangeAuthorization, "Change or Improvement Authorization");
        TableUtils.wrapHeader(this.tblRows, this.colNextHigherLevel, "Next Higher Level");
        TableUtils.wrapHeader(this.tblRows, this.colFocusElement, "Focus Element");
        TableUtils.wrapHeader(this.tblRows, this.colNextLowerLevelOrCharacteristic, "Next Lower Level or Characteristic");
        TableUtils.wrapHeader(this.tblRows, this.colNextHigherLevelFunction, "Higher Level Function");
        TableUtils.wrapHeader(this.tblRows, this.colFocusElementFunctionRequirement, "Focus Element Function or Requirement");
        TableUtils.wrapHeader(this.tblRows, this.colNextLowerLevelFunctionRequirementOrCharacteristic, "Lower Level Function, Requirement or Characteristic");
        TableUtils.wrapHeader(this.tblRows, this.colFailureEffect, "Failure Effect");
        TableUtils.wrapHeader(this.tblRows, this.colFailureMode, "Failure Mode");
        TableUtils.wrapHeader(this.tblRows, this.colFailureCause, "Failure Cause");
        TableUtils.wrapHeader(this.tblRows, this.colPreventionControl, "Prevention Control");
        TableUtils.wrapHeader(this.tblRows, this.colDetectionControl, "Detection Control");
        TableUtils.wrapHeader(this.tblRows, this.colActionPriority, "Action Priority");
        TableUtils.wrapHeader(this.tblRows, this.colRpn, "RPN");
        TableUtils.wrapHeader(this.tblRows, this.colFilterCode, "Filter Code");
        TableUtils.wrapHeader(this.tblRows, this.colPreventiveAction, "Preventive Action");
        TableUtils.wrapHeader(this.tblRows, this.colDetectionAction, "Detection Action");
        TableUtils.wrapHeader(this.tblRows, this.colResponsiblePerson, "Responsible Person");
        TableUtils.wrapHeader(this.tblRows, this.colTargetCompletionDate, "Target Date");
        TableUtils.wrapHeader(this.tblRows, this.colCompletionDate, "Completion Date");
        TableUtils.wrapHeader(this.tblRows, this.colStatus, "Status");
        TableUtils.wrapHeader(this.tblRows, this.colActionTakenEvidence, "Action Taken with Pointer to Evidence");
        TableUtils.wrapHeader(this.tblRows, this.colCurrentActionPriority, "Current Action Priority");
        TableUtils.wrapHeader(this.tblRows, this.colRemarks, "Remarks");
        TableUtils.setHeaderBackground(this.colNextHigherLevel, "#E0C2CD");
        TableUtils.setHeaderBackground(this.colNextHigherLevelFunction, "#E0C2CD");
        TableUtils.setHeaderBackground(this.colFailureEffect, "#E0C2CD");
        TableUtils.setHeaderBackground(this.colFocusElement, "#729FCF");
        TableUtils.setHeaderBackground(this.colFocusElementFunctionRequirement, "#729FCF");
        TableUtils.setHeaderBackground(this.colFailureMode, "#729FCF");
        TableUtils.setHeaderBackground(this.colNextLowerLevelOrCharacteristic, "#8E86AE");
        TableUtils.setHeaderBackground(this.colNextLowerLevelFunctionRequirementOrCharacteristic, "#8E86AE");
        TableUtils.setHeaderBackground(this.colFailureCause, "#8E86AE");
        this.tblRows.layout();
    }

    private void integerCol(final TableColumn<DfmeaRow, Number> column, Function<DfmeaRow, IntegerProperty> prop) {
        if (column == null) {
            return;
        }
        final NumberStringConverter converter = new NumberStringConverter();
        column.setCellValueFactory(cell -> (ObservableValue)prop.apply((DfmeaRow)cell.getValue()));
        column.setCellFactory(col -> new TextFieldTableCell<DfmeaRow, Number>(this, (StringConverter)converter){
            {
                Objects.requireNonNull(this$0);
                super(arg0);
                this.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
                    TableView tv;
                    if (e.getButton() != MouseButton.PRIMARY || e.getClickCount() < 2) {
                        return;
                    }
                    if (!this.isEmpty() && !this.isEditing() && (tv = this.getTableView()) != null) {
                        tv.edit(this.getIndex(), column);
                        e.consume();
                    }
                });
            }

            public void startEdit() {
                super.startEdit();
                Node node = this.getGraphic();
                if (node instanceof TextField) {
                    TextField tf = (TextField)node;
                    tf.selectAll();
                    this.installNavigationHandlers(tf, converter);
                }
            }

            public void cancelEdit() {
                super.cancelEdit();
            }

            public void commitEdit(Number newValue) {
                super.commitEdit((Object)newValue);
            }

            private void installNavigationHandlers(TextField tf, NumberStringConverter conv) {
                if (!Boolean.TRUE.equals(tf.getProperties().get((Object)DfmeaWindowController.TEXT_FIELD_NAV_KEY))) {
                    tf.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
                        if (e.getCode() == KeyCode.TAB) {
                            this.commitSafely(tf.getText(), conv);
                            DfmeaWindowController.navigateFromCell(this, e.isShiftDown() ? -1 : 1);
                            e.consume();
                        } else if (e.getCode() == KeyCode.ESCAPE) {
                            this.cancelEdit();
                            e.consume();
                        }
                    });
                    tf.focusedProperty().addListener((o, was, isNow) -> {
                        if (!isNow.booleanValue() && this.isEditing()) {
                            this.commitSafely(tf.getText(), conv);
                        }
                    });
                    tf.getProperties().put((Object)DfmeaWindowController.TEXT_FIELD_NAV_KEY, (Object)Boolean.TRUE);
                }
            }

            private void commitSafely(String txt, NumberStringConverter conv) {
                try {
                    Number n = conv.fromString(txt);
                    this.commitEdit(n);
                }
                catch (Exception ex) {
                    this.cancelEdit();
                }
            }
        });
        column.setOnEditCommit(edit -> {
            DfmeaRow row;
            int value;
            Number nv = (Number)edit.getNewValue();
            int n = value = nv == null ? 0 : nv.intValue();
            if (value < 0) {
                value = 0;
            }
            if ((row = (DfmeaRow)edit.getRowValue()) == null) {
                return;
            }
            IntegerProperty property = (IntegerProperty)prop.apply(row);
            if (property == null) {
                return;
            }
            int oldValue = property.get();
            if (oldValue == value) {
                return;
            }
            this.pushDfmeaUndo(() -> property.set(oldValue));
            property.set(value);
            if (this.dirtyHook != null) {
                this.dirtyHook.run();
            }
            if (this.tblRows != null) {
                this.tblRows.refresh();
            }
        });
    }

    private <E> void enumCol(TableColumn<DfmeaRow, E> column, E[] values, Function<DfmeaRow, ObjectProperty<E>> prop, final Function<E, Integer> codeFn) {
        if (column == null) {
            return;
        }
        StringConverter converter = new StringConverter<E>(this){
            {
                Objects.requireNonNull(this$0);
            }

            public String toString(E e) {
                if (e == null) {
                    return "N/A";
                }
                Integer code = (Integer)codeFn.apply(e);
                return code != null && code > 0 ? Integer.toString(code) : e.toString();
            }

            public E fromString(String s) {
                return null;
            }
        };
        column.setEditable(true);
        column.setCellValueFactory(cell -> (ObservableValue)prop.apply((DfmeaRow)cell.getValue()));
        column.setStyle("-fx-alignment: CENTER;");
        column.setCellFactory(arg_0 -> this.lambda$enumCol$1(values, (StringConverter)converter, column, arg_0));
        column.setOnEditCommit(edit -> {
            DfmeaRow row = (DfmeaRow)edit.getRowValue();
            if (row == null) {
                return;
            }
            ObjectProperty property = (ObjectProperty)prop.apply(row);
            if (property == null) {
                return;
            }
            Object newValue = edit.getNewValue();
            Object oldValue = property.get();
            if (Objects.equals(oldValue, newValue)) {
                return;
            }
            this.pushDfmeaUndo(() -> property.set(oldValue));
            property.set(newValue);
            if (this.dirtyHook != null) {
                this.dirtyHook.run();
            }
            if (this.tblRows != null) {
                this.tblRows.refresh();
            }
        });
    }

    private void configureHeaderIcon() {
        this.setIcon(this.imgHeaderIcon, "/icons/fmea.png");
    }

    private void setIcon(ImageView view, String resourcePath) {
        if (view == null) {
            return;
        }
        URL iconUrl = DfmeaWindowController.class.getResource(resourcePath);
        if (iconUrl == null) {
            System.err.println("Icon resource not found: " + resourcePath);
            return;
        }
        view.setImage(new Image(iconUrl.toExternalForm()));
    }

    private void configureRowContextMenu() {
        if (this.tblRows == null) {
            return;
        }
        this.tblRows.setRowFactory(tv -> {
            TableRow<DfmeaRow> row = new TableRow<DfmeaRow>(this){
                final /* synthetic */ DfmeaWindowController this$0;
                {
                    DfmeaWindowController dfmeaWindowController = this$0;
                    Objects.requireNonNull(dfmeaWindowController);
                    this.this$0 = dfmeaWindowController;
                }

                protected void updateItem(DfmeaRow item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    this.this$0.applyFailureChainHighlight(this);
                }
            };
            row.indexProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$configureRowContextMenu$1((TableRow)row, arg_0, arg_1, arg_2));
            row.selectedProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$configureRowContextMenu$2((TableRow)row, arg_0, arg_1, arg_2));
            ContextMenu menu = new ContextMenu();
            MenuItem deleteItem = new MenuItem("Delete row");
            deleteItem.setOnAction(arg_0 -> this.lambda$configureRowContextMenu$3((TableRow)row, arg_0));
            MenuItem insertItem = new MenuItem("Insert new row");
            insertItem.setOnAction(arg_0 -> this.lambda$configureRowContextMenu$4((TableRow)row, arg_0));
            MenuItem duplicateItem = new MenuItem("Duplicate row");
            duplicateItem.setOnAction(arg_0 -> this.lambda$configureRowContextMenu$5((TableRow)row, arg_0));
            menu.getItems().addAll((Object[])new MenuItem[]{deleteItem, insertItem, duplicateItem});
            row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)row.emptyProperty()).then((Object)null).otherwise((Object)menu));
            row.setOnContextMenuRequested(arg_0 -> this.lambda$configureRowContextMenu$6((TableRow)row, arg_0));
            return row;
        });
    }

    private void addChainAt(int index) {
        if (this.dfmea == null) {
            return;
        }
        DfmeaRow row = this.createDefaultDfmeaRow();
        this.insertChain(row, index, true);
    }

    private void insertChain(DfmeaRow row, int index) {
        this.insertChain(row, index, true);
    }

    private void insertChain(DfmeaRow row, int index, boolean recordUndo) {
        if (this.dfmea == null || row == null) {
            return;
        }
        ObservableList<DfmeaRow> rows = this.dfmea.getFailureChains();
        if (rows == null) {
            return;
        }
        int targetIndex = index < 0 || index > rows.size() ? rows.size() : index;
        rows.add(targetIndex, (Object)row);
        if (row.getIssueNumber() <= 0) {
            row.setIssueNumber(targetIndex + 1);
        }
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        if (recordUndo) {
            this.highlightDfmeaRow(row);
        }
        this.scheduleSummaryRefresh();
        this.scheduleTreeRefresh();
        if (recordUndo) {
            this.pushDfmeaUndo(() -> {
                rows.remove((Object)row);
                if (this.tblRows != null) {
                    this.tblRows.refresh();
                }
                this.scheduleSummaryRefresh();
                this.scheduleTreeRefresh();
            });
        }
    }

    private void duplicateChain(DfmeaRow source) {
        if (this.dfmea == null || this.tblRows == null || source == null) {
            return;
        }
        int index = this.dfmea.getFailureChains().indexOf((Object)source);
        if (index < 0) {
            return;
        }
        DfmeaRow copy = this.cloneDfmeaRow(source);
        this.insertChain(copy, index + 1);
    }

    private void highlightDfmeaRow(DfmeaRow row) {
        if (this.tblRows == null || row == null) {
            return;
        }
        this.tblRows.getSelectionModel().clearSelection();
        this.tblRows.getSelectionModel().select((Object)row);
        this.tblRows.scrollTo((Object)row);
        Platform.runLater(() -> {
            int idx = this.tblRows.getItems().indexOf((Object)row);
            if (idx >= 0) {
                this.tblRows.getFocusModel().focus(idx);
            }
            this.tblRows.requestFocus();
        });
    }

    private DfmeaRow createDefaultDfmeaRow() {
        DfmeaRow row = new DfmeaRow();
        row.setSeverity(DfmeaRow.Severity.ONE);
        row.setOccurrence(DfmeaRow.Occurrence.ONE);
        row.setDetection(DfmeaRow.Detection.ONE);
        row.setCurrentSeverity(DfmeaRow.Severity.ONE);
        row.setCurrentOccurrence(DfmeaRow.Occurrence.ONE);
        row.setCurrentDetection(DfmeaRow.Detection.ONE);
        return row;
    }

    private DfmeaRow cloneDfmeaRow(DfmeaRow source) {
        DfmeaRow copy = new DfmeaRow();
        copy.setIssueNumber(source.getIssueNumber());
        copy.setChangeAuthorization(source.getChangeAuthorization());
        copy.setNextHigherLevel(source.getNextHigherLevel());
        copy.setFocusElement(source.getFocusElement());
        copy.setNextLowerLevelOrCharacteristic(source.getNextLowerLevelOrCharacteristic());
        copy.setNextHigherLevelFunction(source.getNextHigherLevelFunction());
        copy.setFocusElementFunctionRequirement(source.getFocusElementFunctionRequirement());
        copy.setNextLowerLevelFunctionRequirementOrCharacteristic(source.getNextLowerLevelFunctionRequirementOrCharacteristic());
        copy.setNextHigherLevelText(source.getNextHigherLevelText());
        copy.setFocusElementText(source.getFocusElementText());
        copy.setNextLowerLevelOrCharacteristicText(source.getNextLowerLevelOrCharacteristicText());
        copy.setFailureEffect(source.getFailureEffect());
        copy.setSeverity(source.getSeverity());
        copy.setFailureMode(source.getFailureMode());
        copy.setFailureCause(source.getFailureCause());
        copy.setPreventionControl(source.getPreventionControl());
        copy.setOccurrence(source.getOccurrence());
        copy.setDetectionControl(source.getDetectionControl());
        copy.setDetection(source.getDetection());
        copy.setActionPriority(source.getActionPriority());
        copy.setFilterCode(source.getFilterCode());
        copy.setPreventiveAction(source.getPreventiveAction());
        copy.setDetectionAction(source.getDetectionAction());
        copy.setResponsiblePerson(source.getResponsiblePerson());
        copy.setTargetCompletionDate(source.getTargetCompletionDate());
        copy.setStatus(source.getStatus());
        copy.setActionTakenEvidence(source.getActionTakenEvidence());
        copy.setCompletionDate(source.getCompletionDate());
        copy.setCurrentSeverity(source.getCurrentSeverity());
        copy.setCurrentOccurrence(source.getCurrentOccurrence());
        copy.setCurrentDetection(source.getCurrentDetection());
        copy.setCurrentActionPriority(source.getCurrentActionPriority());
        copy.setRemarks(source.getRemarks());
        return copy;
    }

    private void onAddChain() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.dfmea == null || this.tblRows == null) {
            return;
        }
        this.addChainAt(this.dfmea.getFailureChains().size());
    }

    private void onDeleteSelectedChain() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.dfmea == null || this.tblRows == null) {
            return;
        }
        if (this.tblRows.getEditingCell() != null) {
            return;
        }
        DfmeaRow sel = (DfmeaRow)this.tblRows.getSelectionModel().getSelectedItem();
        if (sel == null) {
            return;
        }
        ObservableList<DfmeaRow> rows = this.dfmea.getFailureChains();
        if (rows == null) {
            return;
        }
        int index = rows.indexOf((Object)sel);
        if (index < 0) {
            return;
        }
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Delete DFMEA Row");
        alert.setHeaderText("Delete selected DFMEA row?");
        alert.setContentText("This action cannot be undone.");
        alert.initOwner((Window)this.ownerStage);
        Optional confirmation = alert.showAndWait();
        if (confirmation.isEmpty() || confirmation.get() != ButtonType.OK) {
            return;
        }
        this.dfmea.removeChain(sel);
        int restoreIndex = index;
        this.pushDfmeaUndo(() -> this.insertChain(sel, Math.min(restoreIndex, this.dfmea.getFailureChains().size()), false));
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        this.scheduleSummaryRefresh();
        this.scheduleTreeRefresh();
        if (this.tblRows != null) {
            this.tblRows.refresh();
        }
    }

    private void mentionTextCol(TableColumn<DfmeaRow, String> col, Function<DfmeaRow, StringProperty> textProp, MentionKind kind) {
        if (col == null) {
            return;
        }
        col.setCellValueFactory(cd -> (ObservableValue)textProp.apply((DfmeaRow)cd.getValue()));
        col.setCellFactory(tc -> {
            ContextMenu popup = new ContextMenu();
            return new WrapTextAreaTableCell(tc, () -> this.searchHighlightPattern, DfmeaWindowController::navigateFromCell, (cell, editor) -> MentionSuggestionBehavior.install((TextInputControl)editor, popup, MentionSuggestionBehavior.config().allowedQueryChar(ch -> Character.isLetterOrDigit(ch.charValue()) || ch.charValue() == '_' || ch.charValue() == '-' || ch.charValue() == ' ').suggestions(query -> {
                DfmeaRow rowObj;
                DfmeaRow dfmeaRow = rowObj = cell.getTableRow() == null ? null : (DfmeaRow)cell.getTableRow().getItem();
                if (!(rowObj instanceof DfmeaRow)) {
                    return List.of();
                }
                DfmeaRow row = rowObj;
                return switch (kind.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> this.suggestHigher((String)query);
                    case 1 -> this.suggestFocus(row, (String)query);
                    case 2 -> this.suggestLower(row, (String)query);
                };
            }).menuBuilder(this::buildMentionMenuForCell).insertionText(this::displayName).afterInsert((ctx, chosen) -> {
                DfmeaRow rowObj;
                DfmeaRow dfmeaRow = rowObj = cell.getTableRow() == null ? null : (DfmeaRow)cell.getTableRow().getItem();
                if (!(rowObj instanceof DfmeaRow)) {
                    return;
                }
                DfmeaRow row = rowObj;
                StringProperty property = (StringProperty)textProp.apply(row);
                if (property != null) {
                    property.set((Object)ctx.newText());
                }
                this.applySelection(kind, row, chosen);
            })));
        });
        col.setEditable(true);
    }

    private List<Item> roots() {
        return this.productProvider == null ? List.of() : this.productProvider.get();
    }

    private List<Object> suggestHigher(String q) {
        String filter = this.norm(q);
        LinkedHashSet<Object> seen = new LinkedHashSet<Object>();
        for (Item rootItem : this.roots()) {
            this.collectToSet(rootItem, seen, filter, true, true, false);
        }
        return new ArrayList<Object>(seen);
    }

    private List<Object> suggestFocus(DfmeaRow row, String query) {
        String filter = this.norm(query);
        Item higher = row.getNextHigherLevel();
        if (higher == null) {
            LinkedHashSet<Object> seen = new LinkedHashSet<Object>();
            for (Item rootItem : this.roots()) {
                this.collectToSet(rootItem, seen, filter, false, true, true);
            }
            return new ArrayList<Object>(seen);
        }
        LinkedHashSet<Item> seen = new LinkedHashSet<Item>();
        if (higher.getChildren() != null) {
            for (Item child : higher.getChildren()) {
                if (child.getType() != ItemType.SYSTEM && child.getType() != ItemType.PART || !this.matches(child, filter)) continue;
                seen.add(child);
            }
        }
        return new ArrayList<Object>(seen);
    }

    private List<Object> suggestLower(DfmeaRow row, String q) {
        String f = this.norm(q);
        Item focus = row.getFocusElement();
        ArrayList<Object> out = new ArrayList<Object>();
        if (focus != null) {
            if (focus.getChildren() != null) {
                for (Item ch : focus.getChildren()) {
                    if (ch.getType() != ItemType.SYSTEM && ch.getType() != ItemType.PART || !this.matches(ch, f)) continue;
                    out.add(ch);
                }
            }
            if (focus.getCharacteristics() != null) {
                for (Characteristic c : focus.getCharacteristics()) {
                    if (!this.matches(c, f)) continue;
                    out.add(c);
                }
            }
        }
        return out;
    }

    private void collectToSet(Item item, Set<Object> out, String filter, boolean allowProduct, boolean allowSystem, boolean allowPart) {
        boolean allowed;
        if (item == null) {
            return;
        }
        boolean bl = allowed = allowProduct && item.getType() == ItemType.PRODUCT || allowSystem && item.getType() == ItemType.SYSTEM || allowPart && item.getType() == ItemType.PART;
        if (allowed && this.matches(item, filter)) {
            out.add(item);
        }
        if (item.getChildren() != null) {
            for (Item child : item.getChildren()) {
                this.collectToSet(child, out, filter, allowProduct, allowSystem, allowPart);
            }
        }
    }

    private void buildMentionMenuForCell(ContextMenu menu, List<Object> options, Consumer<Object> onChoose) {
        menu.getItems().clear();
        boolean first = true;
        for (Object obj : options) {
            if (!first) {
                menu.getItems().add((Object)new SeparatorMenuItem());
            }
            first = false;
            String title = this.displayName(obj);
            Object object = obj;
            int n = 0;
            String subtitle = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Item.class, Characteristic.class}, (Object)object, n)) {
                case -1 -> "";
                case 0 -> {
                    Item it = (Item)object;
                    yield DfmeaWindowController.s(it.getFunction());
                }
                case 1 -> {
                    Characteristic ch = (Characteristic)object;
                    yield this.formatCharacteristic(ch);
                }
                default -> "";
            };
            Label l1 = new Label(title);
            l1.setStyle("-fx-font-size: 12px;");
            Label l2 = new Label(subtitle);
            l2.setStyle("-fx-text-fill: #666; -fx-font-size: 11px;");
            l2.setWrapText(true);
            VBox box = new VBox(2.0, new Node[]{l1, l2});
            MenuItem mi = new MenuItem();
            mi.setGraphic((Node)box);
            mi.setMnemonicParsing(false);
            mi.setOnAction(e -> onChoose.accept(obj));
            menu.getItems().add((Object)mi);
        }
    }

    private String displayName(Object obj) {
        if (obj instanceof Item) {
            Item it = (Item)obj;
            String d = it.getDescription();
            return d == null || d.isBlank() ? "(unnamed)" : d;
        }
        if (obj instanceof Characteristic) {
            Characteristic ch = (Characteristic)obj;
            String d = ch.getDescription();
            return d == null || d.isBlank() ? "(characteristic)" : d;
        }
        return String.valueOf(obj);
    }

    private String norm(String s) {
        return s == null ? "" : s.trim().toLowerCase();
    }

    private void applySelection(MentionKind kind, DfmeaRow row, Object chosen) {
        block0 : switch (kind.ordinal()) {
            case 0: {
                if (!(chosen instanceof Item)) break;
                Item item = (Item)chosen;
                row.setNextHigherLevel(item);
                if (this.isBlank(row.getNextHigherLevelText())) {
                    row.setNextHigherLevelText(this.displayName(item));
                }
                if (!this.isBlank(row.getNextHigherLevelFunction())) break;
                row.setNextHigherLevelFunction(DfmeaWindowController.s(item.getFunction()));
                break;
            }
            case 1: {
                if (!(chosen instanceof Item)) break;
                Item item = (Item)chosen;
                row.setFocusElement(item);
                row.setFocusElementText(this.displayName(item));
                row.setFocusElementFunctionRequirement(DfmeaWindowController.s(item.getFunction()));
                Item parent = this.findParentOf(item);
                if (parent != null) {
                    row.setNextHigherLevel(parent);
                    row.setNextHigherLevelText(this.displayName(parent));
                    row.setNextHigherLevelFunction(DfmeaWindowController.s(parent.getFunction()));
                }
                if (this.dirtyHook != null) {
                    this.dirtyHook.run();
                }
                if (this.tblRows == null) break;
                this.tblRows.refresh();
                break;
            }
            case 2: {
                row.setNextLowerLevelOrCharacteristic(chosen);
                Object object = chosen;
                Objects.requireNonNull(object);
                Object object2 = object;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Item.class, Characteristic.class}, (Object)object2, n)) {
                    case 0: {
                        Item item = (Item)object2;
                        if (item.getType() == ItemType.PART && this.isBlank(row.getNextLowerLevelFunctionRequirementOrCharacteristic())) {
                            row.setNextLowerLevelFunctionRequirementOrCharacteristic(DfmeaWindowController.s(item.getFunction()));
                        }
                        row.setNextLowerLevelOrCharacteristicText(this.displayName(item));
                        break block0;
                    }
                    case 1: {
                        Characteristic ch = (Characteristic)object2;
                        String formatted = this.formatCharacteristic(ch);
                        row.setNextLowerLevelOrCharacteristicText(formatted);
                        row.setNextLowerLevelFunctionRequirementOrCharacteristic(formatted);
                        break block0;
                    }
                }
                row.setNextLowerLevelOrCharacteristicText(this.displayName(chosen));
            }
        }
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        if (this.tblRows != null) {
            this.tblRows.refresh();
        }
    }

    private Item findParentOf(Item target) {
        for (Item r : this.roots()) {
            Item p = this.findParentDfs(r, target, null);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private Item findParentDfs(Item cur, Item target, Item parent) {
        if (cur == null) {
            return null;
        }
        if (cur == target) {
            return parent;
        }
        if (cur.getChildren() != null) {
            for (Item c : cur.getChildren()) {
                Item p = this.findParentDfs(c, target, cur);
                if (p == null) continue;
                return p;
            }
        }
        return null;
    }

    private boolean matches(Item it, String f) {
        String q;
        if (it == null) {
            return false;
        }
        String string = q = f == null ? "" : f.trim().toLowerCase();
        if (q.isEmpty()) {
            return true;
        }
        String d = it.getDescription();
        String pn = it.getPartNumber();
        String fn = it.getFunction();
        return d != null && d.toLowerCase().contains(q) || pn != null && pn.toLowerCase().contains(q) || fn != null && fn.toLowerCase().contains(q);
    }

    private boolean matches(Characteristic ch, String f) {
        String q;
        if (ch == null) {
            return false;
        }
        String string = q = f == null ? "" : f.trim().toLowerCase();
        if (q.isEmpty()) {
            return true;
        }
        String d = ch.getDescription();
        return d != null && d.toLowerCase().contains(q);
    }

    private boolean isBlank(String v) {
        return v == null || v.trim().isEmpty();
    }

    private void pushDfmeaUndo(Runnable action) {
        if (action == null) {
            return;
        }
        this.dfmeaUndoStack.addFirst(action);
        while (this.dfmeaUndoStack.size() > 50) {
            this.dfmeaUndoStack.removeLast();
        }
    }

    private boolean performDfmeaUndo() {
        Runnable action = this.dfmeaUndoStack.pollFirst();
        if (action == null) {
            return false;
        }
        action.run();
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        this.scheduleSummaryRefresh();
        this.scheduleTreeRefresh();
        if (this.tblRows != null) {
            this.tblRows.refresh();
        }
        return true;
    }

    private TablePosition<DfmeaRow, ?> captureDfmeaFocus() {
        TablePosition first;
        ObservableList cells;
        TablePosition focused;
        if (this.tblRows == null) {
            return null;
        }
        TableView.TableViewFocusModel focusModel = this.tblRows.getFocusModel();
        if (focusModel != null && (focused = focusModel.getFocusedCell()) != null && focused.getTableColumn() != null && focused.getRow() >= 0) {
            return new TablePosition(this.tblRows, focused.getRow(), focused.getTableColumn());
        }
        TableView.TableViewSelectionModel selection = this.tblRows.getSelectionModel();
        if (selection != null && !(cells = selection.getSelectedCells()).isEmpty() && (first = (TablePosition)cells.get(0)) != null && first.getTableColumn() != null && first.getRow() >= 0) {
            return new TablePosition(this.tblRows, first.getRow(), first.getTableColumn());
        }
        return null;
    }

    private void restoreDfmeaFocus(TablePosition<DfmeaRow, ?> snapshot) {
        if (this.tblRows == null || snapshot == null) {
            return;
        }
        ObservableList items = this.tblRows.getItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        int row = Math.max(0, Math.min(snapshot.getRow(), items.size() - 1));
        TableColumn column = snapshot.getTableColumn();
        ArrayList visible = new ArrayList(this.tblRows.getVisibleLeafColumns());
        if (visible.isEmpty()) {
            return;
        }
        if (column == null || !visible.contains(column)) {
            int idx = this.tblRows.getVisibleLeafIndex(column);
            if (idx < 0 || idx >= visible.size()) {
                idx = 0;
            }
            column = (TableColumn)visible.get(idx);
        }
        TableView.TableViewSelectionModel selection = this.tblRows.getSelectionModel();
        TableView.TableViewFocusModel focus = this.tblRows.getFocusModel();
        if (selection != null) {
            selection.clearAndSelect(row, column);
        }
        if (focus != null) {
            focus.focus(row, column);
        }
    }

    private String formatCharacteristic(Characteristic ch) {
        String target = this.valueWithFallback(ch.getTargetValueText(), ch.getTargetValue());
        String usl = this.valueWithFallback(ch.getUpperLimitText(), ch.getUpperLimit());
        String lsl = this.valueWithFallback(ch.getLowerLimitText(), ch.getLowerLimit());
        StringBuilder sb = new StringBuilder();
        sb.append("Nominal: ").append(target).append("\n");
        sb.append("Upper Specification Limit: ").append(usl).append("\n");
        sb.append("Lower Specification Limit: ").append(lsl);
        return sb.toString();
    }

    private String valueWithFallback(String text, double numeric) {
        if (text != null && !text.isBlank()) {
            return text.trim();
        }
        if (Double.isNaN(numeric)) {
            return "";
        }
        return this.formatNumber(numeric);
    }

    private String formatNumber(double value) {
        String text = Double.toString(value);
        if (text.indexOf(69) >= 0 || text.indexOf(101) >= 0) {
            return text;
        }
        if (text.indexOf(46) >= 0) {
            while (text.endsWith("0")) {
                text = text.substring(0, text.length() - 1);
            }
            if (text.endsWith(".")) {
                text = text.substring(0, text.length() - 1);
            }
        }
        return text;
    }

    private void datePickerCol(TableColumn<DfmeaRow, LocalDate> column, final Function<DfmeaRow, ObjectProperty<LocalDate>> prop) {
        if (column == null) {
            return;
        }
        column.setCellValueFactory(cell -> (ObservableValue)prop.apply((DfmeaRow)cell.getValue()));
        column.setCellFactory(tc -> new TableCell<DfmeaRow, LocalDate>(this){
            private final DatePicker picker;
            private final StackPane wrapper;
            final /* synthetic */ DfmeaWindowController this$0;
            {
                DfmeaWindowController dfmeaWindowController = this$0;
                Objects.requireNonNull(dfmeaWindowController);
                this.this$0 = dfmeaWindowController;
                this.picker = new DatePicker();
                this.wrapper = new StackPane(new Node[]{this.picker});
                this.picker.setMaxWidth(Double.MAX_VALUE);
                this.wrapper.setAlignment(Pos.CENTER);
                this.picker.valueProperty().addListener((o, ov, nv) -> {
                    if (this.isEmpty()) {
                        return;
                    }
                    TableView table = this.getTableView();
                    if (table == null || this.getIndex() < 0 || this.getIndex() >= table.getItems().size()) {
                        return;
                    }
                    DfmeaRow row = (DfmeaRow)table.getItems().get(this.getIndex());
                    ObjectProperty property = (ObjectProperty)prop.apply(row);
                    if (property == null) {
                        return;
                    }
                    LocalDate previous = (LocalDate)property.get();
                    if (Objects.equals(previous, nv)) {
                        return;
                    }
                    this.this$0.pushDfmeaUndo(() -> property.set((Object)previous));
                    property.set(nv);
                    if (this.this$0.dirtyHook != null) {
                        this.this$0.dirtyHook.run();
                    }
                });
            }

            protected void updateItem(LocalDate item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setGraphic(null);
                } else {
                    this.picker.setValue((Object)item);
                    this.setGraphic((Node)this.wrapper);
                }
            }
        });
    }

    @SafeVarargs
    private void centerCells(TableColumn<?, ?> ... columns) {
        for (TableColumn<?, ?> column : columns) {
            if (column == null) continue;
            column.setStyle("-fx-alignment: CENTER;");
        }
    }

    private void readOnlyApCol(TableColumn<DfmeaRow, DfmeaRow.ActionPriority> column, Function<DfmeaRow, ObjectProperty<DfmeaRow.ActionPriority>> prop) {
        if (column == null) {
            return;
        }
        column.setEditable(false);
        column.setCellValueFactory(cell -> (ObservableValue)prop.apply((DfmeaRow)cell.getValue()));
        column.setCellFactory(col -> new TableCell<DfmeaRow, DfmeaRow.ActionPriority>(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void updateItem(DfmeaRow.ActionPriority item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setText("");
                    this.setStyle("");
                    return;
                }
                switch (item) {
                    case HIGH: {
                        this.setText("High");
                        this.setStyle("-fx-background-color: lightcoral; -fx-text-fill: black;");
                        break;
                    }
                    case MEDIUM: {
                        this.setText("Medium");
                        this.setStyle("-fx-background-color: khaki; -fx-text-fill: black;");
                        break;
                    }
                    case LOW: {
                        this.setText("Low");
                        this.setStyle("-fx-background-color: lightgreen; -fx-text-fill: black;");
                    }
                }
                this.setAlignment(Pos.CENTER);
            }
        });
    }

    private void attachApListeners(DfmeaRow r) {
        ChangeListener recalc = (obs, ov, nv) -> this.updateApFromSOD(r);
        r.severityProperty().addListener(recalc);
        r.occurrenceProperty().addListener(recalc);
        r.detectionProperty().addListener(recalc);
        r.currentSeverityProperty().addListener(recalc);
        r.currentOccurrenceProperty().addListener(recalc);
        r.currentDetectionProperty().addListener(recalc);
        this.updateApFromSOD(r);
    }

    private void updateApFromSOD(DfmeaRow r) {
        Integer dc;
        Integer d0;
        Integer s0 = r.getSeverity() != null ? Integer.valueOf(r.getSeverity().getValue()) : null;
        Integer o0 = r.getOccurrence() != null ? Integer.valueOf(r.getOccurrence().getValue()) : null;
        Integer n = d0 = r.getDetection() != null ? Integer.valueOf(r.getDetection().getValue()) : null;
        if (s0 != null && o0 != null && d0 != null) {
            r.setActionPriority(DfmeaWindowController.getAp(s0, o0, d0));
        }
        Integer sc = r.getCurrentSeverity() != null ? Integer.valueOf(r.getCurrentSeverity().getValue()) : null;
        Integer oc = r.getCurrentOccurrence() != null ? Integer.valueOf(r.getCurrentOccurrence().getValue()) : null;
        Integer n2 = dc = r.getCurrentDetection() != null ? Integer.valueOf(r.getCurrentDetection().getValue()) : null;
        if (sc != null && oc != null && dc != null) {
            r.setCurrentActionPriority(DfmeaWindowController.getAp(sc, oc, dc));
        } else {
            r.setCurrentActionPriority(null);
        }
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        if (this.tblRows != null) {
            this.tblRows.refresh();
        }
    }

    @FXML
    private void onSaveOnly() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.performSave(false);
    }

    private void onSaveAndExit() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.performSave(true);
    }

    private void performSave(boolean closeAfter) {
        this.commitPendingEdits();
        try {
            if (this.saveAction != null) {
                this.saveAction.run();
            }
            this.hasUnsavedChanges = false;
            if (closeAfter) {
                this.closeWindow();
            }
        }
        catch (Exception ex) {
            System.err.println("[DFMEA] Save failed: " + ex.getMessage());
            new Alert(Alert.AlertType.ERROR, "Failed to save DFMEA:\n" + ex.getMessage(), new ButtonType[0]).showAndWait();
        }
    }

    private void commitPendingEdits() {
        if (this.tblRows != null && this.tblRows.getEditingCell() != null) {
            this.tblRows.edit(-1, null);
        }
    }

    private void closeWindow() {
        Stage window = null;
        if (this.ownerStage != null) {
            window = this.ownerStage;
        } else if (this.root != null && this.root.getScene() != null) {
            window = this.root.getScene().getWindow();
        }
        if (window == null) {
            return;
        }
        this.programmaticClose = true;
        if (window instanceof Stage) {
            Stage stage = window;
            stage.close();
        } else {
            window.hide();
        }
    }

    private void installCloseHandler() {
        if (this.ownerStage == null) {
            return;
        }
        this.ownerStage.setOnCloseRequest(evt -> {
            if (this.programmaticClose) {
                this.programmaticClose = false;
                return;
            }
            evt.consume();
            this.promptSaveBeforeClose();
        });
    }

    private void promptSaveBeforeClose() {
        if (!this.hasUnsavedChanges) {
            this.closeWindow();
            return;
        }
        Alert confirm = new Alert(Alert.AlertType.CONFIRMATION);
        confirm.setTitle("Save changes?");
        confirm.setHeaderText("Do you want to save before closing?");
        confirm.setContentText("Select Yes to save the current DFMEA.");
        confirm.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        if (this.ownerStage != null) {
            confirm.initOwner((Window)this.ownerStage);
        }
        confirm.showAndWait().ifPresent(result -> {
            if (result == ButtonType.YES) {
                this.performSave(true);
            } else if (result == ButtonType.NO) {
                this.hasUnsavedChanges = false;
                this.closeWindow();
            }
        });
    }

    private void wireSummaryTableColumns() {
        if (this.colPreventionActionSummary.getCellValueFactory() != null) {
            return;
        }
        if (this.colSummaryFocusElement != null) {
            this.colSummaryFocusElement.setCellValueFactory(c -> ((DfmeaRow)c.getValue()).focusElementTextProperty());
        }
        if (this.colSummaryFailureMode != null) {
            this.colSummaryFailureMode.setCellValueFactory(c -> ((DfmeaRow)c.getValue()).failureModeProperty());
        }
        this.colPreventionActionSummary.setCellValueFactory(c -> ((DfmeaRow)c.getValue()).preventiveActionProperty());
        this.colDetectionActionSummary.setCellValueFactory(c -> ((DfmeaRow)c.getValue()).detectionActionProperty());
        this.colStatusSummary.setCellValueFactory(c -> {
            DfmeaRow.DfmeaStatus st = (DfmeaRow.DfmeaStatus)((Object)((Object)((DfmeaRow)c.getValue()).statusProperty().get()));
            String txt = st == null ? "" : DfmeaWindowController.dfmeaStatusText(st);
            return new SimpleStringProperty(txt);
        });
        this.colResponsibleSummary.setCellValueFactory(c -> ((DfmeaRow)c.getValue()).responsiblePersonProperty());
        this.colTargetDateSummary.setCellValueFactory(c -> ((DfmeaRow)c.getValue()).targetCompletionDateProperty());
        this.colTargetDateSummary.setCellFactory(col -> new TableCell<DfmeaRow, LocalDate>(this){
            private final DateTimeFormatter fmt;
            {
                Objects.requireNonNull(this$0);
                this.fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            }

            protected void updateItem(LocalDate item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setText(empty || item == null ? "" : this.fmt.format(item));
            }
        });
    }

    private void updateActionsTable(List<DfmeaRow> rows) {
        List<DfmeaRow> filtered = rows.stream().filter(r -> DfmeaWindowController.hasText((String)r.preventiveActionProperty().get()) || DfmeaWindowController.hasText((String)r.detectionActionProperty().get())).filter(this::isOpenOrPending).toList();
        this.tblActions.setItems(FXCollections.observableArrayList(filtered));
        this.wireSummaryTableColumns();
        this.updateSummaryCharts(rows);
    }

    private static boolean hasText(String s) {
        return s != null && !s.isBlank();
    }

    private boolean isOpenOrPending(DfmeaRow r) {
        DfmeaRow.DfmeaStatus s = (DfmeaRow.DfmeaStatus)((Object)r.statusProperty().get());
        return s == DfmeaRow.DfmeaStatus.OPEN || s == DfmeaRow.DfmeaStatus.PENDING_DECISION || s == DfmeaRow.DfmeaStatus.PENDING_IMPLEMENTATION;
    }

    private static String dfmeaStatusText(DfmeaRow.DfmeaStatus s) {
        if (s == null) {
            return "";
        }
        return switch (s) {
            default -> throw new MatchException(null, null);
            case DfmeaRow.DfmeaStatus.OPEN -> "Open";
            case DfmeaRow.DfmeaStatus.PENDING_DECISION -> "Pending decision";
            case DfmeaRow.DfmeaStatus.PENDING_IMPLEMENTATION -> "Pending implementation";
            case DfmeaRow.DfmeaStatus.COMPLETED -> "Completed";
            case DfmeaRow.DfmeaStatus.NOT_IMPLEMENTED -> "Not implemented";
        };
    }

    private void updateSummaryCharts(List<DfmeaRow> rows) {
        DfmeaRow.DfmeaStatus st;
        if (rows == null) {
            return;
        }
        if (this.chartActionPriority != null) {
            this.chartActionPriority.setLegendVisible(false);
        }
        if (this.chartActionPriorityAfter != null) {
            this.chartActionPriorityAfter.setLegendVisible(false);
        }
        if (this.chartStatus != null) {
            this.chartStatus.setLegendVisible(false);
            this.chartStatus.setAnimated(true);
        }
        if (this.chartSeverityCount != null) {
            this.chartSeverityCount.setLegendVisible(false);
            this.chartSeverityCount.setAnimated(true);
        }
        if (this.chartOcurrenceCount != null) {
            this.chartOcurrenceCount.setLegendVisible(false);
            this.chartOcurrenceCount.setAnimated(true);
        }
        if (this.chartDetectionCount != null) {
            this.chartDetectionCount.setLegendVisible(false);
            this.chartDetectionCount.setAnimated(true);
        }
        int low = 0;
        int med = 0;
        int high = 0;
        int currentLow = 0;
        int currentMed = 0;
        int currentHigh = 0;
        for (DfmeaRow r2 : rows) {
            DfmeaRow.ActionPriority current;
            DfmeaRow.ActionPriority ap = r2.getActionPriority();
            if (ap != null) {
                switch (ap) {
                    case LOW: {
                        ++low;
                        break;
                    }
                    case MEDIUM: {
                        ++med;
                        break;
                    }
                    case HIGH: {
                        ++high;
                    }
                }
            }
            if ((current = r2.getCurrentActionPriority()) == null) continue;
            switch (current) {
                case LOW: {
                    ++currentLow;
                    break;
                }
                case MEDIUM: {
                    ++currentMed;
                    break;
                }
                case HIGH: {
                    ++currentHigh;
                }
            }
        }
        this.updateActionPriorityChart(this.chartActionPriority, "Action Priority Distribution", high, med, low);
        this.updateActionPriorityChart(this.chartActionPriorityAfter, "Action Priority Distribution (Final)", currentHigh, currentMed, currentLow);
        int open = 0;
        int pendDec = 0;
        int pendImpl = 0;
        int comp = 0;
        int notImpl = 0;
        for (DfmeaRow r3 : rows) {
            st = r3.getStatus();
            if (st == null) continue;
            switch (st) {
                case OPEN: {
                    ++open;
                    break;
                }
                case PENDING_DECISION: {
                    ++pendDec;
                    break;
                }
                case PENDING_IMPLEMENTATION: {
                    ++pendImpl;
                    break;
                }
                case COMPLETED: {
                    ++comp;
                    break;
                }
                case NOT_IMPLEMENTED: {
                    ++notImpl;
                }
            }
        }
        XYChart.Series sStatus = new XYChart.Series();
        sStatus.getData().add((Object)new XYChart.Data((Object)"Open", (Object)open));
        sStatus.getData().add((Object)new XYChart.Data((Object)"Pending decision", (Object)pendDec));
        sStatus.getData().add((Object)new XYChart.Data((Object)"Pending implementation", (Object)pendImpl));
        sStatus.getData().add((Object)new XYChart.Data((Object)"Completed", (Object)comp));
        sStatus.getData().add((Object)new XYChart.Data((Object)"Not implemented", (Object)notImpl));
        if (this.chartStatus != null) {
            this.chartStatus.getData().clear();
            this.chartStatus.getData().add((Object)sStatus);
            this.chartStatus.setTitle("Actions by Status");
            this.adjustValueAxis(this.chartStatus, (XYChart.Series<String, Number>)sStatus);
            st = this.chartStatus.getXAxis();
            if (st instanceof CategoryAxis) {
                CategoryAxis categoryAxis = (CategoryAxis)st;
                categoryAxis.setTickLabelRotation(-20.0);
                categoryAxis.setTickLabelGap(10.0);
            }
            Platform.runLater(() -> this.addLabelsForSeries((XYChart.Series<String, Number>)sStatus));
            Platform.runLater(() -> {
                for (XYChart.Data d : sStatus.getData()) {
                    String category;
                    if (d.getNode() == null) continue;
                    switch (category = (String)d.getXValue()) {
                        case "Open": {
                            d.getNode().setStyle("-fx-bar-fill: blue;");
                            break;
                        }
                        case "Pending decision": {
                            d.getNode().setStyle("-fx-bar-fill: lightgray;");
                            break;
                        }
                        case "Pending implementation": {
                            d.getNode().setStyle("-fx-bar-fill: gold;");
                            break;
                        }
                        case "Completed": {
                            d.getNode().setStyle("-fx-bar-fill: green;");
                            break;
                        }
                        case "Not implemented": {
                            d.getNode().setStyle("-fx-bar-fill: gray;");
                        }
                    }
                }
            });
        }
        XYChart.Series sSev = new XYChart.Series();
        for (int i = 10; i >= 1; --i) {
            int code = i;
            long c = rows.stream().filter(r -> r.getSeverity() != null && r.getSeverity().getValue() == code).count();
            sSev.getData().add((Object)new XYChart.Data((Object)String.valueOf(i), (Object)c));
        }
        if (this.chartSeverityCount != null) {
            this.chartSeverityCount.getData().clear();
            this.chartSeverityCount.getData().add((Object)sSev);
            this.chartSeverityCount.setTitle("Severity (1\u201310)");
            this.adjustValueAxis(this.chartSeverityCount, (XYChart.Series<String, Number>)sSev);
            this.addLabelsForSeries((XYChart.Series<String, Number>)sSev);
            Platform.runLater(() -> {
                for (XYChart.Data d : sSev.getData()) {
                    try {
                        int level = Integer.parseInt((String)d.getXValue());
                        if (d.getNode() != null) {
                            d.getNode().setStyle("-fx-bar-fill: " + DfmeaWindowController.colorForLevel(level) + ";");
                            continue;
                        }
                        d.nodeProperty().addListener((o, ov, nv) -> {
                            if (nv != null) {
                                nv.setStyle("-fx-bar-fill: " + DfmeaWindowController.colorForLevel(level) + ";");
                            }
                        });
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            });
        }
        XYChart.Series sOcc = new XYChart.Series();
        for (int i = 10; i >= 1; --i) {
            int code = i;
            long c = rows.stream().filter(r -> r.getOccurrence() != null && r.getOccurrence().getValue() == code).count();
            sOcc.getData().add((Object)new XYChart.Data((Object)String.valueOf(i), (Object)c));
        }
        if (this.chartOcurrenceCount != null) {
            this.chartOcurrenceCount.getData().clear();
            this.chartOcurrenceCount.getData().add((Object)sOcc);
            this.chartOcurrenceCount.setTitle("Occurrence (1\u201310)");
            this.adjustValueAxis(this.chartOcurrenceCount, (XYChart.Series<String, Number>)sOcc);
            Platform.runLater(() -> this.addLabelsForSeries((XYChart.Series<String, Number>)sOcc));
            Platform.runLater(() -> {
                for (XYChart.Data d : sOcc.getData()) {
                    try {
                        int level = Integer.parseInt((String)d.getXValue());
                        if (d.getNode() != null) {
                            d.getNode().setStyle("-fx-bar-fill: " + DfmeaWindowController.colorForLevel(level) + ";");
                            continue;
                        }
                        d.nodeProperty().addListener((o, ov, nv) -> {
                            if (nv != null) {
                                nv.setStyle("-fx-bar-fill: " + DfmeaWindowController.colorForLevel(level) + ";");
                            }
                        });
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            });
        }
        XYChart.Series sDet = new XYChart.Series();
        for (int i = 10; i >= 1; --i) {
            int code = i;
            long c = rows.stream().filter(r -> r.getDetection() != null && r.getDetection().getValue() == code).count();
            sDet.getData().add((Object)new XYChart.Data((Object)String.valueOf(i), (Object)c));
        }
        if (this.chartDetectionCount != null) {
            this.chartDetectionCount.getData().clear();
            this.chartDetectionCount.getData().add((Object)sDet);
            this.chartDetectionCount.setTitle("Detection (1\u201310)");
            this.adjustValueAxis(this.chartDetectionCount, (XYChart.Series<String, Number>)sDet);
            Platform.runLater(() -> this.addLabelsForSeries((XYChart.Series<String, Number>)sDet));
            Platform.runLater(() -> {
                for (XYChart.Data d : sDet.getData()) {
                    try {
                        int level = Integer.parseInt((String)d.getXValue());
                        if (d.getNode() != null) {
                            d.getNode().setStyle("-fx-bar-fill: " + DfmeaWindowController.colorForLevel(level) + ";");
                            continue;
                        }
                        d.nodeProperty().addListener((o, ov, nv) -> {
                            if (nv != null) {
                                nv.setStyle("-fx-bar-fill: " + DfmeaWindowController.colorForLevel(level) + ";");
                            }
                        });
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            });
        }
    }

    private static String colorForLevel(int level) {
        double hue;
        if (level < 1) {
            level = 1;
        }
        if (level > 10) {
            level = 10;
        }
        if (level >= 5) {
            double f = (10.0 - (double)level) / 5.0;
            hue = 0.0 + f * 60.0;
        } else {
            double f = (5.0 - (double)level) / 4.0;
            hue = 60.0 + f * 60.0;
        }
        return DfmeaWindowController.hsbToHex(hue, 0.9, 0.9);
    }

    private static String hsbToHex(double h, double s, double v) {
        double b1;
        double g1;
        double r1;
        double c = v * s;
        double hh = h % 360.0 / 60.0;
        double x = c * (1.0 - Math.abs(hh % 2.0 - 1.0));
        if (0.0 <= hh && hh < 1.0) {
            r1 = c;
            g1 = x;
            b1 = 0.0;
        } else if (1.0 <= hh && hh < 2.0) {
            r1 = x;
            g1 = c;
            b1 = 0.0;
        } else if (2.0 <= hh && hh < 3.0) {
            r1 = 0.0;
            g1 = c;
            b1 = x;
        } else if (3.0 <= hh && hh < 4.0) {
            r1 = 0.0;
            g1 = x;
            b1 = c;
        } else if (4.0 <= hh && hh < 5.0) {
            r1 = x;
            g1 = 0.0;
            b1 = c;
        } else {
            r1 = c;
            g1 = 0.0;
            b1 = x;
        }
        double m = v - c;
        int r = (int)Math.round((r1 + m) * 255.0);
        int g = (int)Math.round((g1 + m) * 255.0);
        int b = (int)Math.round((b1 + m) * 255.0);
        r = Math.max(0, Math.min(255, r));
        g = Math.max(0, Math.min(255, g));
        b = Math.max(0, Math.min(255, b));
        return String.format("#%02X%02X%02X", r, g, b);
    }

    private void adjustValueAxis(BarChart<String, Number> chart, XYChart.Series<String, Number> series) {
        if (chart == null || series == null) {
            return;
        }
        Axis axis = chart.getYAxis();
        if (!(axis instanceof NumberAxis)) {
            return;
        }
        NumberAxis axis2 = (NumberAxis)axis;
        double max = series.getData().stream().mapToDouble(data -> {
            Number value = (Number)data.getYValue();
            return value == null ? 0.0 : value.doubleValue();
        }).max().orElse(0.0);
        double padding = Math.max(1.0, max * 0.15);
        double upperBound = Math.max(1.0, max + padding);
        axis2.setAutoRanging(false);
        axis2.setLowerBound(0.0);
        double upper = Math.ceil(upperBound);
        axis2.setUpperBound(upper);
        double tick = Math.max(1.0, Math.ceil(upper / 5.0));
        axis2.setTickUnit(tick);
    }

    private void addLabelsForSeries(XYChart.Series<String, Number> series) {
        Platform.runLater(() -> {
            for (XYChart.Data d : series.getData()) {
                if (d.getNode() == null) {
                    d.nodeProperty().addListener((o, ov, nv) -> {
                        if (nv != null) {
                            this.attachLabelToBarNode((StackPane)nv, (XYChart.Data<String, Number>)d);
                        }
                    });
                    continue;
                }
                this.attachLabelToBarNode((StackPane)d.getNode(), (XYChart.Data<String, Number>)d);
            }
        });
    }

    private void attachLabelToBarNode(StackPane bar, XYChart.Data<String, Number> d) {
        String KEY = "bar-label";
        Label lbl = (Label)bar.getProperties().get((Object)"bar-label");
        if (lbl == null) {
            lbl = new Label(String.valueOf(d.getYValue()));
            lbl.setStyle("-fx-font-weight: bold; -fx-text-fill: black;");
            lbl.setMouseTransparent(true);
            bar.getProperties().put((Object)"bar-label", (Object)lbl);
            bar.getChildren().add((Object)lbl);
            StackPane.setAlignment((Node)lbl, (Pos)Pos.TOP_CENTER);
            lbl.translateYProperty().bind((ObservableValue)lbl.heightProperty().multiply(-1).subtract(4));
        } else {
            lbl.setText(String.valueOf(d.getYValue()));
            if (!bar.getChildren().contains((Object)lbl)) {
                bar.getChildren().add((Object)lbl);
                StackPane.setAlignment((Node)lbl, (Pos)Pos.TOP_CENTER);
                lbl.translateYProperty().bind((ObservableValue)lbl.heightProperty().multiply(-1).subtract(4));
            }
        }
        Label labelRef = lbl;
        d.YValueProperty().addListener((o, ov, nv) -> labelRef.setText(String.valueOf(nv)));
    }

    private void scheduleSummaryRefresh() {
        Platform.runLater(() -> {
            if (this.dfmea != null) {
                this.updateActionsTable((List<DfmeaRow>)this.dfmea.getFailureChains());
            }
        });
    }

    private void wireSummaryRowListeners(DfmeaRow r) {
        r.preventiveActionProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        r.detectionActionProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        r.statusProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        r.responsiblePersonProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        r.targetCompletionDateProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        r.severityProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        r.occurrenceProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        r.detectionProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        r.currentSeverityProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        r.currentOccurrenceProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        r.currentDetectionProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
    }

    private void attachTreeRefreshRowListeners(DfmeaRow r) {
        r.nextHigherLevelTextProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        r.nextHigherLevelFunctionProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        r.focusElementTextProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        r.focusElementFunctionRequirementProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        r.nextLowerLevelOrCharacteristicTextProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        r.nextLowerLevelFunctionRequirementOrCharacteristicProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        r.failureEffectProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        r.failureModeProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        r.failureCauseProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        r.actionPriorityProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
    }

    private void scheduleTreeRefresh() {
        if (this.treeLoaded && this.webFta != null) {
            Platform.runLater(this::sendDfmeaJsonToPage);
        }
    }

    private void updateActionPriorityChart(PieChart chart, String title, int high, int med, int low) {
        if (chart == null) {
            return;
        }
        ObservableList data = FXCollections.observableArrayList((Object[])new PieChart.Data[]{new PieChart.Data("High", (double)high), new PieChart.Data("Medium", (double)med), new PieChart.Data("Low", (double)low)});
        HashMap baseNames = new HashMap();
        data.forEach(d -> baseNames.put(d, d.getName()));
        int total = high + med + low;
        chart.setData(data);
        chart.setTitle(title);
        chart.setLabelsVisible(true);
        chart.setLegendVisible(true);
        chart.setLegendSide(Side.RIGHT);
        Map<String, String> colorByName = Map.of("High", "#EF4444", "Medium", "#F59E0B", "Low", "#10B981");
        Platform.runLater(() -> {
            for (PieChart.Data d : data) {
                String baseName = baseNames.getOrDefault(d, d.getName().split(":")[0]);
                String color = colorByName.getOrDefault(baseName, "#10B981");
                if (d.getNode() != null) {
                    d.getNode().setStyle("-fx-pie-color: " + color + ";");
                }
                d.nodeProperty().addListener((obs, oldNode, newNode) -> {
                    if (newNode != null) {
                        newNode.setStyle("-fx-pie-color: " + color + ";");
                    }
                });
                double value = d.getPieValue();
                double pct = total == 0 ? 0.0 : value / (double)total * 100.0;
                d.setName(String.format("%s: %.0f (%.0f%%)", baseName, value, pct));
            }
            chart.applyCss();
            chart.layout();
            for (Node node : chart.lookupAll(".chart-legend-item")) {
                if (!(node instanceof HBox)) continue;
                HBox item = (HBox)node;
                Region symbol = (Region)item.lookup(".chart-legend-item-symbol");
                Label label = item.getChildren().stream().filter(child -> child instanceof Label).findFirst().orElse(null);
                if (symbol == null || label == null) continue;
                String baseName = label.getText().split(":")[0];
                String color = colorByName.getOrDefault(baseName, "#10B981");
                symbol.setStyle("-fx-background-color: " + color + ";-fx-background-insets: 0;-fx-background-radius: 6px;");
            }
        });
    }

    private static <S> void navigateFromCell(TableCell<S, ?> cell, int step) {
        if (cell == null || step == 0) {
            return;
        }
        TableView tv = cell.getTableView();
        if (tv == null) {
            return;
        }
        TableColumn current = cell.getTableColumn();
        if (current == null) {
            return;
        }
        TableView.TableViewSelectionModel selectionModel = tv.getSelectionModel();
        TableView.TableViewFocusModel focusModel = tv.getFocusModel();
        if (selectionModel == null || focusModel == null) {
            return;
        }
        ObservableList items = tv.getItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        for (TableColumn col : tv.getVisibleLeafColumns()) {
            if (col == null || !col.isVisible() || !col.isEditable()) continue;
            columns.add(col);
        }
        if (columns.isEmpty()) {
            columns.addAll((Collection<TableColumn>)tv.getVisibleLeafColumns());
        }
        if (columns.isEmpty()) {
            return;
        }
        int rowIdx = Math.max(0, Math.min(items.size() - 1, cell.getIndex()));
        int colIdx = columns.indexOf(current);
        if (colIdx < 0) {
            colIdx = tv.getVisibleLeafIndex(current);
        }
        if (colIdx < 0) {
            colIdx = 0;
        }
        colIdx = Math.min(colIdx, columns.size() - 1);
        int totalCols = columns.size();
        if (totalCols == 0) {
            return;
        }
        int totalCells = items.size() * totalCols;
        if (totalCells == 0) {
            return;
        }
        int linearIndex = rowIdx * totalCols + colIdx;
        int targetIndex = Math.max(0, Math.min(totalCells - 1, linearIndex + step));
        int targetRow = targetIndex / totalCols;
        int targetCol = targetIndex % totalCols;
        TableColumn target = (TableColumn)columns.get(targetCol);
        if (target == null) {
            return;
        }
        HorizontalScrollState snapshot = DfmeaWindowController.captureHorizontalScrollState(tv);
        selectionModel.clearAndSelect(targetRow, target);
        focusModel.focus(targetRow, target);
        TableColumn targetColumn = target;
        int rowFinal = targetRow;
        boolean shouldEdit = tv.isEditable() && targetColumn.isEditable();
        Platform.runLater(() -> {
            DfmeaWindowController.ensureColumnVisible(tv, targetColumn, snapshot);
            if (shouldEdit) {
                tv.edit(rowFinal, targetColumn);
            }
        });
    }

    private static HorizontalScrollState captureHorizontalScrollState(TableView<?> tv) {
        ScrollBar bar = DfmeaWindowController.findHorizontalScrollBar(tv);
        if (bar == null) {
            return null;
        }
        return new HorizontalScrollState(bar.getValue());
    }

    private static void ensureColumnVisible(TableView<?> tv, TableColumn<?, ?> target, HorizontalScrollState before) {
        double current;
        ScrollBar bar = DfmeaWindowController.findHorizontalScrollBar(tv);
        if (bar == null || target == null) {
            return;
        }
        double viewport = bar.getVisibleAmount();
        if (viewport <= 0.0) {
            return;
        }
        double left = DfmeaWindowController.computeColumnLeft(tv, target);
        double right = left + Math.max(target.getWidth(), 1.0);
        double desired = current = before != null ? before.value : bar.getValue();
        if (right > current + viewport) {
            desired = right - viewport;
        } else if (left < current) {
            desired = left;
        }
        desired = Math.max(bar.getMin(), Math.min(bar.getMax(), desired));
        bar.setValue(desired);
    }

    private static double computeColumnLeft(TableView tv, TableColumn target) {
        Object colObj;
        TableColumn col;
        double left = 0.0;
        Iterator iterator = tv.getVisibleLeafColumns().iterator();
        while (iterator.hasNext() && (col = (TableColumn)(colObj = iterator.next())) != target) {
            left += col.getWidth();
        }
        return left;
    }

    private static ScrollBar findHorizontalScrollBar(TableView<?> tv) {
        ScrollBar sb;
        if (tv == null) {
            return null;
        }
        Object cached = tv.getProperties().get((Object)HSCROLL_CACHE_KEY);
        if (cached instanceof ScrollBar && (sb = (ScrollBar)cached).getParent() != null) {
            return sb;
        }
        ScrollBar found = DfmeaWindowController.lookupHorizontalScrollBar(tv);
        if (found != null) {
            tv.getProperties().put((Object)HSCROLL_CACHE_KEY, (Object)found);
        }
        return found;
    }

    private static ScrollBar lookupHorizontalScrollBar(TableView<?> tv) {
        if (tv == null || tv.getScene() == null) {
            return null;
        }
        for (Node node : tv.lookupAll(".scroll-bar")) {
            ScrollBar sb;
            if (!(node instanceof ScrollBar) || (sb = (ScrollBar)node).getOrientation() != Orientation.HORIZONTAL) continue;
            return sb;
        }
        return null;
    }

    private void wireExportButton() {
        if (this.btnExportToPDF != null) {
            this.btnExportToPDF.setOnAction(event -> this.onExport());
        }
    }

    @FXML
    private void onOpenDfmeaTables() {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/DfmeaTables.fxml"));
            Parent dialogContent = (Parent)loader.load();
            Stage dialog = new Stage();
            dialog.setTitle("DFMEA S-O-D Tables");
            if (this.btnDfmeaTables != null && this.btnDfmeaTables.getScene() != null) {
                dialog.initOwner(this.btnDfmeaTables.getScene().getWindow());
            }
            dialog.setScene(new Scene(dialogContent));
            dialog.show();
        }
        catch (IOException ex) {
            this.showError("Unable to open DFMEA tables window.", ex);
        }
    }

    @FXML
    private void onExport() {
        ExportFormat format = this.promptExportFormat("Select the format for exporting the DFMEA");
        if (format == null) {
            return;
        }
        switch (format.ordinal()) {
            case 0: {
                this.exportToPdf();
                break;
            }
            case 1: {
                this.exportToExcel();
                break;
            }
        }
    }

    private void exportToPdf() {
        File file;
        if (this.dfmea == null) {
            this.showExportError("No DFMEA loaded.");
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Export DFMEA to PDF");
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Arquivos PDF (*.pdf)", new String[]{"*.pdf"}));
        String product = this.extractProductNameForFile(this.dfmea);
        String rev = this.findLastApprovedRevisionForFile(this.dfmea);
        String baseName = ("DFMEA for " + (product.isBlank() ? "Product" : product) + (String)(rev.isBlank() ? "" : " Rev " + rev)).trim();
        chooser.setInitialFileName(ExportFileNameUtil.suggestedName(baseName, "DFMEA for Product", "pdf"));
        ExportDirectoryPreferences.applyInitialDirectory(chooser);
        Window owner = this.btnExportToPDF != null && this.btnExportToPDF.getScene() != null ? this.btnExportToPDF.getScene().getWindow() : null;
        File file2 = file = owner != null ? chooser.showSaveDialog(owner) : chooser.showSaveDialog(null);
        if (file == null) {
            return;
        }
        ExportDirectoryPreferences.rememberExportDirectory(file.getParentFile());
        try {
            Path logoPath = ExportLogoPreferences.getRememberedLogoPath().orElse(null);
            DfmeaPdfGenerator.generateDfmeaPdf(this.dfmea, file.toPath(), logoPath);
            this.showExportInfo("PDF generated successfully:\n" + file.getAbsolutePath());
        }
        catch (IOException | DocumentException ex) {
            this.showExportError("Error generating PDF: " + this.buildExceptionMessage((Exception)ex));
        }
    }

    private void exportToExcel() {
        File file;
        if (this.dfmea == null) {
            this.showExportError("No DFMEA loaded.");
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Export DFMEA to Excel");
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Planilha Excel (*.xlsx)", new String[]{"*.xlsx"}));
        String product = this.extractProductNameForFile(this.dfmea);
        String rev = this.findLastApprovedRevisionForFile(this.dfmea);
        String baseName = ("DFMEA for " + (product.isBlank() ? "Product" : product) + (String)(rev.isBlank() ? "" : " Rev " + rev)).trim();
        chooser.setInitialFileName(ExportFileNameUtil.suggestedName(baseName, "DFMEA for Product", "xlsx"));
        ExportDirectoryPreferences.applyInitialDirectory(chooser);
        Window owner = this.btnExportToPDF != null && this.btnExportToPDF.getScene() != null ? this.btnExportToPDF.getScene().getWindow() : null;
        File file2 = file = owner != null ? chooser.showSaveDialog(owner) : chooser.showSaveDialog(null);
        if (file == null) {
            return;
        }
        ExportDirectoryPreferences.rememberExportDirectory(file.getParentFile());
        try {
            Path logoPath = ExportLogoPreferences.getRememberedLogoPath().orElse(null);
            DfmeaExcelExporter.export(this.dfmea, file.toPath(), logoPath);
            this.showExportInfo("Excel file generated successfully:\n" + file.getAbsolutePath());
        }
        catch (IOException ex) {
            this.showExportError("Error generating Excel: " + this.buildExceptionMessage(ex));
        }
    }

    private ExportFormat promptExportFormat(String header) {
        Window owner;
        Dialog dialog = new Dialog();
        dialog.setTitle("Export");
        dialog.setHeaderText(header);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        ToggleGroup group = new ToggleGroup();
        RadioButton pdfOption = new RadioButton("PDF");
        pdfOption.setToggleGroup(group);
        pdfOption.setSelected(true);
        RadioButton excelOption = new RadioButton("Excel");
        excelOption.setToggleGroup(group);
        pdfOption.setGraphic((Node)this.icon(this.icPdf, 14.0));
        excelOption.setGraphic((Node)this.icon(this.icExcel, 14.0));
        VBox content = new VBox(8.0, new Node[]{pdfOption, excelOption});
        content.setPadding(new Insets(4.0, 0.0, 0.0, 12.0));
        dialog.getDialogPane().setContent((Node)content);
        Window window = owner = this.btnExportToPDF != null && this.btnExportToPDF.getScene() != null ? this.btnExportToPDF.getScene().getWindow() : null;
        if (owner != null) {
            dialog.initOwner(owner);
        }
        dialog.setResultConverter(button -> {
            if (button == ButtonType.OK) {
                return group.getSelectedToggle() == excelOption ? ExportFormat.EXCEL : ExportFormat.PDF;
            }
            return null;
        });
        return dialog.showAndWait().orElse(null);
    }

    private void loadIcons() {
        this.icFailureChain = this.loadIcon("failure_chain", 18.0);
        this.icPdf = this.loadIcon("pdf", 14.0);
        this.icExcel = this.loadIcon("excel", 14.0);
        this.icTable = this.loadIcon("table", 16.0);
        this.icPlus = this.loadIcon("plus", 16.0);
        this.icTrash = this.loadIcon("trash", 16.0);
        this.icApprove = this.loadIcon("approve", 16.0);
        this.icEdit = this.loadIcon("edit", 16.0);
        this.icSave = this.loadIcon("save", 18.0);
        this.icExit = this.loadIcon("exit", 18.0);
        this.icSearch = this.loadIcon("search", 24.0);
    }

    private Image loadIcon(String name, double size) {
        InputStream stream = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        if (stream == null) {
            return null;
        }
        return new Image(stream, size, size, true, true);
    }

    private ImageView icon(Image img, double size) {
        if (img == null) {
            return null;
        }
        ImageView iv = new ImageView(img);
        iv.setPreserveRatio(true);
        iv.setFitWidth(size);
        iv.setFitHeight(size);
        iv.setSmooth(true);
        return iv;
    }

    private void ensureTooltip(Button btn, String fallbackText) {
        if (btn == null) {
            return;
        }
        String text = btn.getText();
        if ((text == null || text.isBlank()) && fallbackText != null) {
            text = fallbackText;
        }
        if (text == null || text.isBlank()) {
            return;
        }
        Tooltip tip = btn.getTooltip();
        if (tip == null || tip.getText() == null || tip.getText().isBlank()) {
            btn.setTooltip(new Tooltip(text));
        }
    }

    private void applyDefaultTooltips() {
        this.ensureTooltip(this.btnAddFailureChain, "Add failure chain");
        this.ensureTooltip(this.btnDelete, "Delete selected row");
        this.ensureTooltip(this.btnSaveOnly, "Save current DFMEA");
        this.ensureTooltip(this.btnSaveExit, "Save current DFMEA and close");
        this.ensureTooltip(this.btnDfmeaTables, "Open S-O-D tables");
        this.ensureTooltip(this.btnExportToPDF, "Export DFMEA");
        this.ensureTooltip(this.btnRevAdd, "Add revision");
        this.ensureTooltip(this.btnRevEdit, "Edit revision");
        this.ensureTooltip(this.btnRevApprove, "Approve revision");
        this.ensureTooltip(this.btnRevDelete, "Delete revision");
        this.ensureTooltip(this.btnNext, "Search next match");
    }

    private void showExportInfo(String msg) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("Export");
        alert.setHeaderText(null);
        alert.setContentText(msg);
        alert.showAndWait();
    }

    private void showExportError(String msg) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Erro");
        alert.setHeaderText("Falha ao Export o arquivo");
        alert.setContentText(msg);
        alert.showAndWait();
    }

    private String buildExceptionMessage(Exception ex) {
        if (ex == null) {
            return "";
        }
        String message = ex.getMessage();
        return message == null || message.isBlank() ? ex.getClass().getSimpleName() : message;
    }

    private void showError(String message, Exception ex) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Error");
        alert.setHeaderText("DFMEA");
        alert.setContentText((String)(ex == null ? message : message + "\n" + this.buildExceptionMessage(ex)));
        alert.showAndWait();
    }

    private boolean ensureEditPermission() {
        return true;
    }

    private boolean ensureApprovalPermission() {
        return true;
    }

    private void applyHeaderReadOnlyMode() {
        boolean editable = true;
        if (this.txtCompanyName != null) {
            this.txtCompanyName.setEditable(editable);
        }
        if (this.txtEngineeringLocation != null) {
            this.txtEngineeringLocation.setEditable(editable);
        }
        if (this.txtCustomerName != null) {
            this.txtCustomerName.setEditable(editable);
        }
        if (this.txtModelYearPlatform != null) {
            this.txtModelYearPlatform.setEditable(editable);
        }
        if (this.txtDfmeaSubject != null) {
            this.txtDfmeaSubject.setEditable(editable);
        }
        if (this.txtCrossFunctionalTeam != null) {
            this.txtCrossFunctionalTeam.setEditable(editable);
        }
        if (this.txtDfmeaIdNumber != null) {
            this.txtDfmeaIdNumber.setEditable(editable);
        }
        if (this.txtDesignResponsibility != null) {
            this.txtDesignResponsibility.setEditable(editable);
        }
        if (this.dpDfmeaStartDate != null) {
            this.dpDfmeaStartDate.setDisable(!editable);
        }
        if (this.dpDfmeaRevisionDate != null) {
            this.dpDfmeaRevisionDate.setDisable(!editable);
        }
        if (this.cbConfidentialityLevel != null) {
            this.cbConfidentialityLevel.setDisable(!editable);
        }
    }

    private String extractProductNameForFile(Dfmea model) {
        Object v;
        Method m2;
        if (model == null) {
            return "";
        }
        String subject = model.getDfmeaSubject();
        if (subject != null && !subject.trim().isEmpty()) {
            return subject.trim();
        }
        Item prod = model.getAssociatedProduct();
        if (prod == null) {
            return "";
        }
        try {
            m2 = prod.getClass().getMethod("getDescription", new Class[0]);
            v = m2.invoke((Object)prod, new Object[0]);
            if (v != null && !v.toString().trim().isEmpty()) {
                return v.toString().trim();
            }
        }
        catch (ReflectiveOperationException m2) {
            // empty catch block
        }
        try {
            m2 = prod.getClass().getMethod("getName", new Class[0]);
            v = m2.invoke((Object)prod, new Object[0]);
            if (v != null && !v.toString().trim().isEmpty()) {
                return v.toString().trim();
            }
        }
        catch (ReflectiveOperationException m3) {
            // empty catch block
        }
        String s = ((Object)prod).toString();
        return s == null ? "" : s.trim();
    }

    private String findLastApprovedRevisionForFile(Dfmea model) {
        if (model == null) {
            return "";
        }
        Optional<String> latestApproved = model.latestApprovedRevision().map(entry -> {
            String rev = entry.getRevisionNumber();
            return rev != null ? rev.trim() : "";
        }).filter(rev -> !rev.isEmpty());
        if (latestApproved.isPresent()) {
            return latestApproved.get();
        }
        for (String m : new String[]{"getLastApprovedRevision", "getApprovedRevision", "getCurrentApprovedRevision"}) {
            try {
                Method mm = model.getClass().getMethod(m, new Class[0]);
                Object v = mm.invoke((Object)model, new Object[0]);
                if (v == null || v.toString().trim().isEmpty()) continue;
                return v.toString().trim();
            }
            catch (ReflectiveOperationException mm) {
                // empty catch block
            }
        }
        for (String listGetter : new String[]{"getRevisions", "getRevisionHistory", "getDfmeaRevisions"}) {
            try {
                Method mg = model.getClass().getMethod(listGetter, new Class[0]);
                Object list = mg.invoke((Object)model, new Object[0]);
                if (!(list instanceof Iterable)) continue;
                Iterable it = (Iterable)list;
                String best = "";
                for (Object rev2 : it) {
                    boolean approved = false;
                    try {
                        Method ma = rev2.getClass().getMethod("isApproved", new Class[0]);
                        Object a = ma.invoke(rev2, new Object[0]);
                        approved = Boolean.TRUE.equals(a);
                    }
                    catch (ReflectiveOperationException ignore) {
                        try {
                            Method ms = rev2.getClass().getMethod("getStatus", new Class[0]);
                            Object st = ms.invoke(rev2, new Object[0]);
                            if (st != null) {
                                String s = st.toString().toUpperCase();
                                approved = s.contains("APPROVED");
                            }
                        }
                        catch (ReflectiveOperationException ignore2) {
                            try {
                                Method ma2 = rev2.getClass().getMethod("getApprovalStatus", new Class[0]);
                                Object st = ma2.invoke(rev2, new Object[0]);
                                if (st != null) {
                                    String s = st.toString().toUpperCase();
                                    approved = s.contains("APPROVED");
                                }
                            }
                            catch (ReflectiveOperationException reflectiveOperationException) {
                                // empty catch block
                            }
                        }
                    }
                    if (!approved) continue;
                    String code = null;
                    for (String cg : new String[]{"getCode", "getRevision", "getRevisionNumber"}) {
                        try {
                            Method mc = rev2.getClass().getMethod(cg, new Class[0]);
                            Object v = mc.invoke(rev2, new Object[0]);
                            if (v == null || v.toString().trim().isEmpty()) continue;
                            code = v.toString().trim();
                            break;
                        }
                        catch (ReflectiveOperationException reflectiveOperationException) {
                            // empty catch block
                        }
                    }
                    if (code == null || code.isBlank() || !best.isEmpty() && code.compareTo(best) <= 0) continue;
                    best = code;
                }
                if (best.isEmpty()) continue;
                return best;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        try {
            Method m = model.getClass().getMethod("getDfmeaRevision", new Class[0]);
            Object v = m.invoke((Object)model, new Object[0]);
            if (v != null && !v.toString().trim().isEmpty()) {
                return v.toString().trim();
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return "";
    }

    private void updateSearchPattern() {
        if (this.failureChainSearch == null) {
            this.searchHighlightPattern = null;
            return;
        }
        String query = this.failureChainSearch.getLastQuery();
        this.searchHighlightPattern = query == null || query.isBlank() ? null : Pattern.compile(Pattern.quote(query.trim()), 2);
    }

    private /* synthetic */ void lambda$configureRowContextMenu$6(TableRow row, ContextMenuEvent evt) {
        if (!row.isEmpty()) {
            this.tblRows.getSelectionModel().clearAndSelect(row.getIndex());
        }
    }

    private /* synthetic */ void lambda$configureRowContextMenu$5(TableRow row, ActionEvent evt) {
        if (row.isEmpty()) {
            return;
        }
        this.duplicateChain((DfmeaRow)row.getItem());
    }

    private /* synthetic */ void lambda$configureRowContextMenu$4(TableRow row, ActionEvent evt) {
        if (row.isEmpty()) {
            return;
        }
        this.addChainAt(row.getIndex() + 1);
    }

    private /* synthetic */ void lambda$configureRowContextMenu$3(TableRow row, ActionEvent evt) {
        if (row.isEmpty()) {
            return;
        }
        this.tblRows.getSelectionModel().clearAndSelect(row.getIndex());
        this.onDeleteSelectedChain();
    }

    private /* synthetic */ void lambda$configureRowContextMenu$2(TableRow row, ObservableValue obs, Boolean old, Boolean sel) {
        this.applyFailureChainHighlight((TableRow<DfmeaRow>)row);
    }

    private /* synthetic */ void lambda$configureRowContextMenu$1(TableRow row, ObservableValue obs, Number old, Number idx) {
        this.applyFailureChainHighlight((TableRow<DfmeaRow>)row);
    }

    private /* synthetic */ TableCell lambda$enumCol$1(final Object[] values, final StringConverter converter, final TableColumn column, TableColumn col) {
        return new TableCell<DfmeaRow, E>(this){
            private final ComboBox<E> cb;
            {
                Objects.requireNonNull(this$0);
                this.cb = new ComboBox(FXCollections.observableArrayList((Object[])values));
                this.cb.setConverter(converter);
                this.cb.setMaxWidth(Double.MAX_VALUE);
                this.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
                    TableView tv;
                    if (e.getButton() != MouseButton.PRIMARY || e.getClickCount() < 2) {
                        return;
                    }
                    if (!this.isEmpty() && !this.isEditing() && (tv = this.getTableView()) != null) {
                        tv.edit(this.getIndex(), column);
                        e.consume();
                    }
                });
                this.cb.setOnAction(ev -> {
                    if (this.isEditing()) {
                        this.commitEdit(this.cb.getValue());
                    }
                });
                this.cb.focusedProperty().addListener((o, was, isNow) -> {
                    if (!isNow.booleanValue() && this.isEditing()) {
                        this.commitEdit(this.cb.getValue());
                    }
                });
                this.cb.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
                    if (e.getCode() == KeyCode.TAB) {
                        if (this.isEditing()) {
                            this.commitEdit(this.cb.getValue());
                        }
                        DfmeaWindowController.navigateFromCell(this, e.isShiftDown() ? -1 : 1);
                        e.consume();
                    } else if (e.getCode() == KeyCode.ESCAPE) {
                        this.cancelEdit();
                        e.consume();
                    }
                });
            }

            public void startEdit() {
                super.startEdit();
                if (this.isEmpty()) {
                    return;
                }
                this.cb.getSelectionModel().select(this.getItem());
                this.setGraphic((Node)this.cb);
                this.setText(null);
                Platform.runLater(() -> {
                    this.cb.requestFocus();
                    this.cb.show();
                });
            }

            public void cancelEdit() {
                super.cancelEdit();
                this.setText(converter.toString(this.getItem()));
                this.setGraphic(null);
            }

            public void commitEdit(E newValue) {
                super.commitEdit(newValue);
                this.setText(converter.toString(newValue));
                this.setGraphic(null);
            }

            protected void updateItem(E item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else if (this.isEditing()) {
                    this.cb.getSelectionModel().select(item);
                    this.setGraphic((Node)this.cb);
                    this.setText(null);
                } else {
                    this.setText(converter.toString(item));
                    this.setGraphic(null);
                    this.setAlignment(Pos.CENTER);
                }
            }
        };
    }

    private static enum MentionKind {
        HIGHER,
        FOCUS,
        LOWER;

    }

    private static final class HorizontalScrollState {
        final double value;

        HorizontalScrollState(double value) {
            this.value = value;
        }
    }

    private static enum ExportFormat {
        PDF,
        EXCEL;

    }
}

