/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.eightd.EightD;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.Window;

public class DifferenceAndChangeAnalysisWindowController {
    @FXML
    private AnchorPane root;
    @FXML
    private Button btnSaveOnly;
    @FXML
    private Button btnSaveExit;
    @FXML
    private TextArea txtDiffContrast1;
    @FXML
    private TextArea txtDiffChange1;
    @FXML
    private TextArea txtDiffContrast2;
    @FXML
    private TextArea txtDiffChange2;
    @FXML
    private TextArea txtDiffContrast3;
    @FXML
    private TextArea txtDiffChange3;
    @FXML
    private TextArea txtDiffContrast4;
    @FXML
    private TextArea txtDiffChange4;
    private Image icSave;
    private Image icExit;
    private Stage ownerStage;
    private EightD report;
    private Runnable saveAction = () -> {};
    private Runnable dirtyHook = () -> {};
    private final List<Runnable> bindingCleanups = new ArrayList<Runnable>();

    @FXML
    private void initialize() {
        this.loadIcons();
        this.configureButtons();
        this.applyDefaultTooltips();
    }

    public void setOwnerStage(Stage stage) {
        this.ownerStage = stage;
        if (stage != null) {
            stage.setResizable(false);
        }
    }

    public void setSaveAction(Runnable saveAction) {
        this.saveAction = saveAction == null ? () -> {} : saveAction;
    }

    public void setDirtyHook(Runnable dirtyHook) {
        this.dirtyHook = dirtyHook == null ? () -> {} : dirtyHook;
    }

    public void setEightD(EightD report) {
        this.clearBindings();
        this.report = report;
        if (report == null) {
            return;
        }
        this.bindTextArea(this.txtDiffContrast1, report.d2DiffContrast1Property());
        this.bindTextArea(this.txtDiffChange1, report.d2DiffChange1Property());
        this.bindTextArea(this.txtDiffContrast2, report.d2DiffContrast2Property());
        this.bindTextArea(this.txtDiffChange2, report.d2DiffChange2Property());
        this.bindTextArea(this.txtDiffContrast3, report.d2DiffContrast3Property());
        this.bindTextArea(this.txtDiffChange3, report.d2DiffChange3Property());
        this.bindTextArea(this.txtDiffContrast4, report.d2DiffContrast4Property());
        this.bindTextArea(this.txtDiffChange4, report.d2DiffChange4Property());
    }

    private void clearBindings() {
        this.bindingCleanups.forEach(Runnable::run);
        this.bindingCleanups.clear();
    }

    private void bindTextArea(TextArea area, StringProperty property) {
        if (area == null || property == null) {
            return;
        }
        area.textProperty().bindBidirectional((Property)property);
        ChangeListener listener = (obs, oldV, newV) -> this.markDirty();
        property.addListener(listener);
        this.bindingCleanups.add(() -> {
            area.textProperty().unbindBidirectional((Property)property);
            property.removeListener(listener);
        });
    }

    private void markDirty() {
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private void configureButtons() {
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setOnAction(e -> this.onSaveOnly());
            this.btnSaveOnly.setGraphic((Node)this.icon(this.icSave, 18.0));
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setOnAction(e -> this.onSaveAndExit());
            this.btnSaveExit.setGraphic((Node)this.icon(this.icExit, 18.0));
        }
    }

    private void applyDefaultTooltips() {
        this.ensureTooltip(this.btnSaveOnly, "Save");
        this.ensureTooltip(this.btnSaveExit, "Save and close");
    }

    private void ensureTooltip(Button btn, String fallbackText) {
        if (btn == null) {
            return;
        }
        Tooltip tip = btn.getTooltip();
        if (tip == null || tip.getText() == null || tip.getText().isBlank()) {
            btn.setTooltip(new Tooltip(fallbackText));
        }
    }

    private void loadIcons() {
        this.icSave = this.loadIcon("save", 18.0);
        this.icExit = this.loadIcon("exit", 18.0);
    }

    private Image loadIcon(String name, double size) {
        InputStream stream = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        if (stream == null) {
            return null;
        }
        return new Image(stream, size, size, true, true);
    }

    private ImageView icon(Image img, double size) {
        if (img == null) {
            return null;
        }
        ImageView iv = new ImageView(img);
        iv.setPreserveRatio(true);
        iv.setFitWidth(size);
        iv.setFitHeight(size);
        iv.setSmooth(true);
        return iv;
    }

    private void onSaveOnly() {
        this.runSave();
    }

    private void onSaveAndExit() {
        if (this.runSave()) {
            this.closeWindow();
        }
    }

    private boolean runSave() {
        if (this.report == null) {
            return true;
        }
        try {
            this.saveAction.run();
            return true;
        }
        catch (Exception ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Save error");
            alert.setHeaderText("Failed to save project");
            alert.setContentText(ex.getMessage());
            if (this.ownerStage != null) {
                alert.initOwner((Window)this.ownerStage);
            }
            alert.showAndWait();
            return false;
        }
    }

    private void closeWindow() {
        Stage stage = this.ownerStage;
        if (stage == null && this.root != null && this.root.getScene() != null) {
            stage = (Stage)this.root.getScene().getWindow();
        }
        if (stage != null) {
            stage.close();
        }
    }
}

