/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.controlPlan.ControlPlan;
import com.qualidadeeprodutividade.controllers.util.DocumentCloneUtils;
import com.qualidadeeprodutividade.controllers.util.DragDropStyler;
import com.qualidadeeprodutividade.fmea.Dfmea;
import com.qualidadeeprodutividade.fmea.Pfmea;
import com.qualidadeeprodutividade.io.XmlIO;
import com.qualidadeeprodutividade.item.Item;
import com.qualidadeeprodutividade.processItem.ProcessItem;
import com.qualidadeeprodutividade.project.Project;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class DocImportController {
    @FXML
    private AnchorPane root;
    @FXML
    private TreeView<Object> treeProjectOrigin;
    @FXML
    private TreeView<Object> treeProjectDestination;
    @FXML
    private Label lblPath;
    @FXML
    private Button btnFileChooser;
    @FXML
    private Button btnSaveOnly;
    @FXML
    private Button btnSaveExit;
    private Stage owner;
    private Runnable saveAction = () -> {};
    private Runnable changeHook = () -> {};
    private Project targetProject;
    private Project sourceProject;
    private File selectedFile;
    private Object dragPayload;
    private final List<Item> pendingProducts = new ArrayList<Item>();
    private final List<ProcessItem> pendingProcesses = new ArrayList<ProcessItem>();
    private final List<Dfmea> pendingDfmeas = new ArrayList<Dfmea>();
    private final List<Pfmea> pendingPfmeas = new ArrayList<Pfmea>();
    private final List<ControlPlan> pendingControlPlans = new ArrayList<ControlPlan>();
    private Image projectImg;
    private Image productImg;
    private Image processImg;
    private Image dfmeaImg;
    private Image pfmeaImg;
    private Image controlPlanImg;
    private Image icFolder;
    private Image icSave;
    private Image icExit;
    private static final String DND_MARKER = "DOC_IMPORT_NODE";
    private static final PseudoClass DND_TARGET = PseudoClass.getPseudoClass((String)"drag-target");

    @FXML
    private void initialize() {
        this.loadIcons();
        this.configureButtons();
        this.configureTrees();
        this.rebuildOriginTree();
        this.rebuildSelectionTree();
        this.updateFileLabel(null);
    }

    public void setOwnerStage(Stage stage) {
        this.owner = stage;
    }

    public void setTargetProject(Project project) {
        this.targetProject = project;
    }

    public void setSaveAction(Runnable action) {
        this.saveAction = action == null ? () -> {} : action;
    }

    public void setChangeHook(Runnable hook) {
        this.changeHook = hook == null ? () -> {} : hook;
    }

    private void configureButtons() {
        if (this.btnFileChooser != null) {
            this.btnFileChooser.setTooltip(new Tooltip("Select an external project (.xml)"));
            this.btnFileChooser.setOnAction(e -> this.openFileChooser());
            this.btnFileChooser.setGraphic((Node)this.icon(this.icFolder, 16.0));
        }
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setTooltip(new Tooltip("Import and save project"));
            this.btnSaveOnly.setOnAction(e -> this.onSaveOnly());
            this.btnSaveOnly.setGraphic((Node)this.icon(this.icSave, 16.0));
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setTooltip(new Tooltip("Import, save and close"));
            this.btnSaveExit.setOnAction(e -> this.onSaveAndExit());
            this.btnSaveExit.setGraphic((Node)this.icon(this.icExit, 16.0));
        }
        this.updateSaveButtons();
    }

    private void configureTrees() {
        if (this.treeProjectOrigin != null) {
            this.treeProjectOrigin.setShowRoot(true);
            DragDropStyler.ensure(this.treeProjectOrigin);
            this.treeProjectOrigin.setCellFactory(tv -> this.createOriginCell());
        }
        if (this.treeProjectDestination != null) {
            this.treeProjectDestination.setShowRoot(true);
            DragDropStyler.ensure(this.treeProjectDestination);
            this.treeProjectDestination.setCellFactory(tv -> this.createDestinationCell());
            this.treeProjectDestination.setOnDragOver(event -> {
                if (this.isValidDrag(event.getDragboard())) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                    this.markDestinationHighlight(true);
                } else {
                    this.markDestinationHighlight(false);
                }
                event.consume();
            });
            this.treeProjectDestination.setOnDragExited(event -> {
                this.markDestinationHighlight(false);
                event.consume();
            });
            this.treeProjectDestination.setOnDragDropped(event -> {
                boolean success = false;
                if (this.isValidDrag(event.getDragboard())) {
                    success = this.queuePayloadForImport(this.dragPayload);
                }
                event.setDropCompleted(success);
                this.dragPayload = null;
                this.markDestinationHighlight(false);
                event.consume();
            });
        }
    }

    private TreeCell<Object> createOriginCell() {
        TreeCell<Object> cell = new TreeCell<Object>(this){
            final /* synthetic */ DocImportController this$0;
            {
                DocImportController docImportController = this$0;
                Objects.requireNonNull(docImportController);
                this.this$0 = docImportController;
            }

            protected void updateItem(Object value, boolean empty) {
                super.updateItem(value, empty);
                this.this$0.updateCellDisplay(this, value, empty);
            }
        };
        cell.setOnDragDetected(arg_0 -> this.lambda$createOriginCell$0((TreeCell)cell, arg_0));
        cell.setOnDragDone(event -> {
            this.dragPayload = null;
            event.consume();
        });
        return cell;
    }

    private TreeCell<Object> createDestinationCell() {
        TreeCell<Object> cell = new TreeCell<Object>(this){
            final /* synthetic */ DocImportController this$0;
            {
                DocImportController docImportController = this$0;
                Objects.requireNonNull(docImportController);
                this.this$0 = docImportController;
            }

            protected void updateItem(Object value, boolean empty) {
                super.updateItem(value, empty);
                this.this$0.updateCellDisplay(this, value, empty);
                if (empty || !this.this$0.isImportable(value)) {
                    this.setContextMenu(null);
                }
            }
        };
        MenuItem remove = new MenuItem("Remove from selection");
        ContextMenu menu = new ContextMenu(new MenuItem[]{remove});
        remove.setOnAction(arg_0 -> this.lambda$createDestinationCell$0((TreeCell)cell, arg_0));
        cell.itemProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$createDestinationCell$1((TreeCell)cell, menu, arg_0, arg_1, arg_2));
        cell.emptyProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$createDestinationCell$2((TreeCell)cell, menu, arg_0, arg_1, arg_2));
        return cell;
    }

    private void openFileChooser() {
        Stage window;
        File file;
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Select project");
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Project XML", new String[]{"*.xml"}));
        File initialDir = this.initialDirectory();
        if (initialDir != null && initialDir.exists()) {
            chooser.setInitialDirectory(initialDir);
        }
        if ((file = chooser.showOpenDialog((Window)(window = this.owner != null ? this.owner : (this.root != null ? this.root.getScene().getWindow() : null)))) != null) {
            this.loadSourceProject(file);
        }
    }

    private File initialDirectory() {
        if (this.selectedFile != null && this.selectedFile.getParentFile() != null) {
            return this.selectedFile.getParentFile();
        }
        Path home = Path.of(System.getProperty("user.home", "."), new String[0]);
        Path desktop = home.resolve("Desktop");
        if (Files.isDirectory(desktop, new LinkOption[0])) {
            return desktop.toFile();
        }
        return Files.isDirectory(home, new LinkOption[0]) ? home.toFile() : null;
    }

    private void loadSourceProject(File file) {
        try {
            Project loaded;
            this.sourceProject = loaded = XmlIO.openProject(file);
            this.selectedFile = file;
            this.updateFileLabel(file);
            this.rebuildOriginTree();
        }
        catch (Exception ex) {
            this.sourceProject = null;
            this.showAlert(Alert.AlertType.ERROR, "Failed to open project", ex.getMessage());
            this.rebuildOriginTree();
        }
    }

    private void updateFileLabel(File file) {
        if (this.lblPath == null) {
            return;
        }
        if (file == null) {
            this.lblPath.setText("No file selected");
        } else {
            this.lblPath.setText(file.getAbsolutePath());
        }
    }

    private void rebuildOriginTree() {
        TreeItem rootItem;
        if (this.treeProjectOrigin == null) {
            return;
        }
        if (this.sourceProject == null) {
            rootItem = new TreeItem((Object)"Select a project file to list documents");
        } else {
            rootItem = new TreeItem((Object)this.sourceProject);
            rootItem.getChildren().setAll(this.buildSectionNodes(this.sourceProject));
        }
        rootItem.setExpanded(true);
        this.treeProjectOrigin.setRoot(rootItem);
        this.expandTree(rootItem);
    }

    private void rebuildSelectionTree() {
        if (this.treeProjectDestination == null) {
            return;
        }
        TreeItem rootItem = !this.hasPendingImports() ? new TreeItem((Object)"No elements selected") : new TreeItem((Object)("Elements selected (" + this.pendingCount() + ")"));
        rootItem.getChildren().setAll(List.of(this.buildSelectionSection("Product Trees", this.pendingProducts), this.buildSelectionSection("Process Trees", this.pendingProcesses), this.buildSelectionSection("DFMEAs", this.pendingDfmeas), this.buildSelectionSection("PFMEAs", this.pendingPfmeas), this.buildSelectionSection("Control Plans", this.pendingControlPlans)));
        rootItem.setExpanded(true);
        this.treeProjectDestination.setRoot(rootItem);
        this.expandTree(rootItem);
        this.updateSaveButtons();
    }

    private List<TreeItem<Object>> buildSectionNodes(Project project) {
        ArrayList<TreeItem<Object>> sections = new ArrayList<TreeItem<Object>>(5);
        sections.add(this.buildSection("Product Trees", (List<?>)project.getProductTrees()));
        sections.add(this.buildSection("Process Trees", (List<?>)project.getProcessTrees()));
        sections.add(this.buildSection("DFMEAs", (List<?>)project.getDfmeas()));
        sections.add(this.buildSection("PFMEAs", (List<?>)project.getPfmeas()));
        sections.add(this.buildSection("Control Plans", (List<?>)project.getControlPlans()));
        return sections;
    }

    private TreeItem<Object> buildSection(String title, List<?> entries) {
        TreeItem section = new TreeItem((Object)title);
        for (Object entry : entries) {
            section.getChildren().add((Object)new TreeItem(entry));
        }
        section.setExpanded(true);
        return section;
    }

    private TreeItem<Object> buildSelectionSection(String title, List<?> entries) {
        String label = title + " (" + entries.size() + ")";
        TreeItem section = new TreeItem((Object)label);
        for (Object entry : entries) {
            section.getChildren().add((Object)new TreeItem(entry));
        }
        section.setExpanded(true);
        return section;
    }

    private void expandTree(TreeItem<?> item) {
        if (item == null) {
            return;
        }
        item.setExpanded(true);
        for (TreeItem child : item.getChildren()) {
            this.expandTree(child);
        }
    }

    private void updateCellDisplay(TreeCell<Object> cell, Object value, boolean empty) {
        if (empty || value == null) {
            cell.setText(null);
            cell.setGraphic(null);
            return;
        }
        if (value instanceof String) {
            String str = (String)value;
            cell.setText(str);
            cell.setGraphic(null);
            return;
        }
        if (value instanceof Project) {
            Project project = (Project)value;
            cell.setText(project.getName() == null ? "External project" : project.getName());
            cell.setGraphic((Node)this.imageView(this.projectImg));
            return;
        }
        if (value instanceof Item) {
            Item item = (Item)value;
            cell.setText(this.safe(item.getDescription()));
            cell.setGraphic((Node)this.imageView(this.productImg));
            return;
        }
        if (value instanceof ProcessItem) {
            ProcessItem process = (ProcessItem)value;
            cell.setText(this.safe(process.getDescription()));
            cell.setGraphic((Node)this.imageView(this.processImg));
            return;
        }
        if (value instanceof Dfmea) {
            Dfmea dfmea = (Dfmea)value;
            cell.setText(this.safe(dfmea.getDfmeaSubject()));
            cell.setGraphic((Node)this.imageView(this.dfmeaImg));
            return;
        }
        if (value instanceof Pfmea) {
            Pfmea pfmea = (Pfmea)value;
            cell.setText(this.safe(pfmea.getPfmeaSubject()));
            cell.setGraphic((Node)this.imageView(this.pfmeaImg));
            return;
        }
        if (value instanceof ControlPlan) {
            ControlPlan controlPlan = (ControlPlan)value;
            cell.setText(this.safe(controlPlan.getCpPartNumber()));
            cell.setGraphic((Node)this.imageView(this.controlPlanImg));
            return;
        }
        cell.setText(String.valueOf(value));
        cell.setGraphic(null);
    }

    private ImageView imageView(Image img) {
        return img == null ? null : new ImageView(img);
    }

    private boolean isImportable(Object value) {
        return value instanceof Item || value instanceof ProcessItem || value instanceof Dfmea || value instanceof Pfmea || value instanceof ControlPlan;
    }

    private boolean queuePayloadForImport(Object payload) {
        if (!this.isImportable(payload)) {
            return false;
        }
        Object clone = this.cloneDocument(payload);
        if (clone == null) {
            return false;
        }
        if (clone instanceof Item) {
            Item item = (Item)clone;
            this.pendingProducts.add(item);
        } else if (clone instanceof ProcessItem) {
            ProcessItem process = (ProcessItem)clone;
            this.pendingProcesses.add(process);
        } else if (clone instanceof Dfmea) {
            Dfmea dfmea = (Dfmea)clone;
            this.pendingDfmeas.add(dfmea);
        } else if (clone instanceof Pfmea) {
            Pfmea pfmea = (Pfmea)clone;
            this.pendingPfmeas.add(pfmea);
        } else if (clone instanceof ControlPlan) {
            ControlPlan controlPlan = (ControlPlan)clone;
            this.pendingControlPlans.add(controlPlan);
        }
        this.rebuildSelectionTree();
        return true;
    }

    private Object cloneDocument(Object payload) {
        if (payload instanceof Item) {
            Item item = (Item)payload;
            return DocumentCloneUtils.cloneItem(item);
        }
        if (payload instanceof ProcessItem) {
            ProcessItem process = (ProcessItem)payload;
            return DocumentCloneUtils.cloneProcessItem(process);
        }
        if (payload instanceof Dfmea) {
            Dfmea dfmea = (Dfmea)payload;
            return DocumentCloneUtils.cloneDfmea(dfmea);
        }
        if (payload instanceof Pfmea) {
            Pfmea pfmea = (Pfmea)payload;
            return DocumentCloneUtils.clonePfmea(pfmea);
        }
        if (payload instanceof ControlPlan) {
            ControlPlan controlPlan = (ControlPlan)payload;
            return DocumentCloneUtils.cloneControlPlan(controlPlan);
        }
        return null;
    }

    private void removeSelection(Object value) {
        boolean removed = false;
        if (value instanceof Item) {
            Item item = (Item)value;
            removed = this.pendingProducts.remove(item);
        } else if (value instanceof ProcessItem) {
            ProcessItem process = (ProcessItem)value;
            removed = this.pendingProcesses.remove(process);
        } else if (value instanceof Dfmea) {
            Dfmea dfmea = (Dfmea)value;
            removed = this.pendingDfmeas.remove(dfmea);
        } else if (value instanceof Pfmea) {
            Pfmea pfmea = (Pfmea)value;
            removed = this.pendingPfmeas.remove(pfmea);
        } else if (value instanceof ControlPlan) {
            ControlPlan controlPlan = (ControlPlan)value;
            removed = this.pendingControlPlans.remove(controlPlan);
        }
        if (removed) {
            this.rebuildSelectionTree();
        }
    }

    private void onSaveOnly() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (!this.commitImports()) {
            return;
        }
        this.runSaveAction();
    }

    private void onSaveAndExit() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (!this.commitImports()) {
            return;
        }
        if (this.runSaveAction()) {
            this.closeWindow();
        }
    }

    private boolean commitImports() {
        if (!this.hasPendingImports()) {
            return true;
        }
        if (this.targetProject == null) {
            this.showAlert(Alert.AlertType.WARNING, "No project available", "There is no project open to receive these documents.");
            return false;
        }
        this.targetProject.getProductTrees().addAll(this.pendingProducts);
        this.targetProject.getProcessTrees().addAll(this.pendingProcesses);
        this.targetProject.getDfmeas().addAll(this.pendingDfmeas);
        this.targetProject.getPfmeas().addAll(this.pendingPfmeas);
        this.targetProject.getControlPlans().addAll(this.pendingControlPlans);
        this.pendingProducts.clear();
        this.pendingProcesses.clear();
        this.pendingDfmeas.clear();
        this.pendingPfmeas.clear();
        this.pendingControlPlans.clear();
        this.rebuildSelectionTree();
        this.changeHook.run();
        return true;
    }

    private boolean runSaveAction() {
        try {
            this.saveAction.run();
            return true;
        }
        catch (Exception ex) {
            this.showAlert(Alert.AlertType.ERROR, "Failed to save", ex.getMessage());
            return false;
        }
    }

    private void closeWindow() {
        Stage stage = this.owner;
        if (stage == null && this.root != null && this.root.getScene() != null) {
            stage = (Stage)this.root.getScene().getWindow();
        }
        if (stage != null) {
            stage.close();
        }
    }

    private void showAlert(Alert.AlertType type, String header, String message) {
        Stage window;
        Alert alert = new Alert(type);
        alert.setHeaderText(header);
        alert.setContentText(message == null || message.isBlank() ? header : message);
        Object object = this.owner != null ? this.owner : (window = this.root != null ? this.root.getScene().getWindow() : null);
        if (window != null) {
            alert.initOwner((Window)window);
        }
        alert.showAndWait();
    }

    private void markDestinationHighlight(boolean active) {
        if (this.treeProjectDestination != null) {
            this.treeProjectDestination.pseudoClassStateChanged(DND_TARGET, active);
        }
    }

    private boolean isValidDrag(Dragboard dragboard) {
        return this.dragPayload != null && dragboard != null && dragboard.hasString() && DND_MARKER.equals(dragboard.getString());
    }

    private void updateSaveButtons() {
        boolean disabled;
        boolean bl = disabled = !this.hasPendingImports();
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setDisable(disabled);
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setDisable(false);
        }
    }

    private boolean ensureEditPermission() {
        return true;
    }

    private boolean hasPendingImports() {
        return this.pendingCount() > 0;
    }

    private int pendingCount() {
        return this.pendingProducts.size() + this.pendingProcesses.size() + this.pendingDfmeas.size() + this.pendingPfmeas.size() + this.pendingControlPlans.size();
    }

    private void loadIcons() {
        this.projectImg = this.loadIcon("project");
        this.productImg = this.loadIcon("product");
        this.processImg = this.loadIcon("process");
        this.dfmeaImg = this.loadIcon("fmea");
        this.pfmeaImg = this.loadIcon("fmea");
        this.controlPlanImg = this.loadIcon("controlplan");
        this.icFolder = this.loadIcon("folder");
        this.icSave = this.loadIcon("save");
        this.icExit = this.loadIcon("exit");
    }

    private Image loadIcon(String name) {
        InputStream stream = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        if (stream == null) {
            return null;
        }
        return new Image(stream, 24.0, 24.0, true, true);
    }

    private ImageView icon(Image img, double size) {
        if (img == null) {
            return null;
        }
        ImageView iv = new ImageView(img);
        iv.setPreserveRatio(true);
        iv.setFitWidth(size);
        iv.setFitHeight(size);
        iv.setSmooth(true);
        return iv;
    }

    private String safe(String value) {
        return value == null || value.isBlank() ? "(untitled)" : value;
    }

    private /* synthetic */ void lambda$createDestinationCell$2(TreeCell cell, ContextMenu menu, ObservableValue obs, Boolean wasEmpty, Boolean isEmpty) {
        if (isEmpty.booleanValue()) {
            cell.setContextMenu(null);
        } else if (this.isImportable(cell.getItem())) {
            cell.setContextMenu(menu);
        }
    }

    private /* synthetic */ void lambda$createDestinationCell$1(TreeCell cell, ContextMenu menu, ObservableValue obs, Object oldVal, Object newVal) {
        if (cell.isEmpty() || !this.isImportable(newVal)) {
            cell.setContextMenu(null);
        } else {
            cell.setContextMenu(menu);
        }
    }

    private /* synthetic */ void lambda$createDestinationCell$0(TreeCell cell, ActionEvent e) {
        Object value = cell.getItem();
        if (value != null) {
            this.removeSelection(value);
        }
    }

    private /* synthetic */ void lambda$createOriginCell$0(TreeCell cell, MouseEvent event) {
        if (cell.isEmpty()) {
            return;
        }
        Object value = cell.getItem();
        if (!this.isImportable(value)) {
            return;
        }
        this.dragPayload = value;
        Dragboard db = cell.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
        ClipboardContent content = new ClipboardContent();
        content.putString(DND_MARKER);
        db.setContent((Map)content);
        event.consume();
    }
}

