/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.controllers.ContainmentWindowController;
import com.qualidadeeprodutividade.controllers.DifferenceAndChangeAnalysisWindowController;
import com.qualidadeeprodutividade.controllers.EventsWindowController;
import com.qualidadeeprodutividade.controllers.FiveWhysWindowController;
import com.qualidadeeprodutividade.controllers.IshikawaWindowController;
import com.qualidadeeprodutividade.controllers.ToBeNotToBeWindowController;
import com.qualidadeeprodutividade.eightd.EightD;
import com.qualidadeeprodutividade.eightd.EightDContainmentAction;
import com.qualidadeeprodutividade.eightd.EightDCorrectiveAction;
import com.qualidadeeprodutividade.eightd.EightDEffectivenessVerification;
import com.qualidadeeprodutividade.eightd.EightDExportOptions;
import com.qualidadeeprodutividade.eightd.EightDImage;
import com.qualidadeeprodutividade.eightd.EightDImageStorage;
import com.qualidadeeprodutividade.eightd.EightDPdfGenerator;
import com.qualidadeeprodutividade.eightd.EightDPreventiveAction;
import com.qualidadeeprodutividade.eightd.EightDTeamMember;
import com.qualidadeeprodutividade.export.ExportDirectoryPreferences;
import com.qualidadeeprodutividade.export.ExportFileNameUtil;
import com.qualidadeeprodutividade.export.ExportLogoPreferences;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.openpdf.text.DocumentException;

public class EightDWindowController {
    @FXML
    private BorderPane root;
    @FXML
    private ImageView imgHeaderIcon;
    @FXML
    private Button btnSaveOnly;
    @FXML
    private Button btnSaveExit;
    @FXML
    private Button btnExportReport;
    @FXML
    private DatePicker dpDateOpened;
    @FXML
    private DatePicker dpDateRevised;
    @FXML
    private DatePicker dpClosedDate;
    @FXML
    private DatePicker dpContainmentDueDate;
    @FXML
    private ComboBox<String> cbStatus;
    @FXML
    private TextField txtInternalClaimNumber;
    @FXML
    private TextField txtCustomerClaimNumber;
    @FXML
    private TextField txtCustomer;
    @FXML
    private TextField txtCustomerContact;
    @FXML
    private TextField txtInternalContact;
    @FXML
    private TextField txtPartNumber;
    @FXML
    private TextField txtPartDescription;
    @FXML
    private TextField txtQuantity;
    @FXML
    private TextArea txtNonConformance;
    @FXML
    private TableView<EightDTeamMember> tblTeamMembers;
    @FXML
    private TableColumn<EightDTeamMember, String> colTeamName;
    @FXML
    private TableColumn<EightDTeamMember, String> colTeamRole;
    @FXML
    private TableColumn<EightDTeamMember, String> colTeamDepartment;
    @FXML
    private TableColumn<EightDTeamMember, String> colTeamCompany;
    @FXML
    private TableColumn<EightDTeamMember, String> colTeamResponsibility;
    @FXML
    private TableColumn<EightDTeamMember, String> colTeamEmail;
    @FXML
    private Button btnAddTeamMember;
    @FXML
    private Button btnDeleteTeamMember;
    @FXML
    private TableView<EightDContainmentAction> tblContainmentActions;
    @FXML
    private TableColumn<EightDContainmentAction, String> colContainmentAction;
    @FXML
    private TableColumn<EightDContainmentAction, String> colContainmentResponsiblePerson;
    @FXML
    private TableColumn<EightDContainmentAction, LocalDate> colContainmentTargetDate;
    @FXML
    private TableColumn<EightDContainmentAction, LocalDate> colContainmentImplementationDate;
    @FXML
    private TableColumn<EightDContainmentAction, String> colContainmentMethod;
    @FXML
    private TableColumn<EightDContainmentAction, String> colContainmentQtyContained;
    @FXML
    private TableColumn<EightDContainmentAction, String> colContainmentQtyRejected;
    @FXML
    private Button btnAddContainmentAction;
    @FXML
    private Button btnDeleteContainmentAction;
    @FXML
    private TableView<EightDCorrectiveAction> tblD5CorrectiveActions;
    @FXML
    private TableColumn<EightDCorrectiveAction, String> colD5CorrectiveAction;
    @FXML
    private TableColumn<EightDCorrectiveAction, String> colD5ResponsiblePerson;
    @FXML
    private TableColumn<EightDCorrectiveAction, LocalDate> colD5TargetDate;
    @FXML
    private TableColumn<EightDCorrectiveAction, LocalDate> colD5ImplementationDate;
    @FXML
    private Button btnAddD5CorrectiveAction;
    @FXML
    private Button btnDeleteD5CorrectiveAction;
    @FXML
    private TableView<EightDEffectivenessVerification> tblD6EffectivenessVerifications;
    @FXML
    private TableColumn<EightDEffectivenessVerification, String> colD6Method;
    @FXML
    private TableColumn<EightDEffectivenessVerification, String> colD6Result;
    @FXML
    private TableColumn<EightDEffectivenessVerification, LocalDate> colD6Date;
    @FXML
    private Button btnAddD6Verification;
    @FXML
    private Button btnDeleteD6Verification;
    @FXML
    private TableView<EightDPreventiveAction> tblD7PreventiveActions;
    @FXML
    private TableColumn<EightDPreventiveAction, String> colD7Product;
    @FXML
    private TableColumn<EightDPreventiveAction, String> colD7Lines;
    @FXML
    private TableColumn<EightDPreventiveAction, String> colD7ResponsiblePerson;
    @FXML
    private TableColumn<EightDPreventiveAction, LocalDate> colD7TargetDate;
    @FXML
    private TableColumn<EightDPreventiveAction, LocalDate> colD7ImplementationDate;
    @FXML
    private TableColumn<EightDPreventiveAction, String> colD7VerificationMethod;
    @FXML
    private TableColumn<EightDPreventiveAction, String> colD7VerificationResult;
    @FXML
    private TableColumn<EightDPreventiveAction, LocalDate> colD7VerificationDate;
    @FXML
    private Button btnAddD7PreventiveAction;
    @FXML
    private Button btnDeleteD7PreventiveAction;
    @FXML
    private CheckBox chkD7DesignFmea;
    @FXML
    private DatePicker dpD7DesignFmeaDate;
    @FXML
    private CheckBox chkD7ProcessFmea;
    @FXML
    private DatePicker dpD7ProcessFmeaDate;
    @FXML
    private CheckBox chkD7ControlPlans;
    @FXML
    private DatePicker dpD7ControlPlansDate;
    @FXML
    private CheckBox chkD7GageDrawing;
    @FXML
    private DatePicker dpD7GageDrawingDate;
    @FXML
    private CheckBox chkD7ProcessFlow;
    @FXML
    private DatePicker dpD7ProcessFlowDate;
    @FXML
    private CheckBox chkD7WorkInstructions;
    @FXML
    private DatePicker dpD7WorkInstructionsDate;
    @FXML
    private CheckBox chkD7Drawing;
    @FXML
    private DatePicker dpD7DrawingDate;
    @FXML
    private CheckBox chkD7DesignStandards;
    @FXML
    private DatePicker dpD7DesignStandardsDate;
    @FXML
    private CheckBox chkD7PackingSpecs;
    @FXML
    private DatePicker dpD7PackingSpecsDate;
    @FXML
    private CheckBox chkD7InternalAudit;
    @FXML
    private DatePicker dpD7InternalAuditDate;
    @FXML
    private CheckBox chkD7ToolingDrawing;
    @FXML
    private DatePicker dpD7ToolingDrawingDate;
    @FXML
    private CheckBox chkD7OperatorTraining;
    @FXML
    private DatePicker dpD7OperatorTrainingDate;
    @FXML
    private TextField txtD8SubmittedBy;
    @FXML
    private DatePicker dpD8SubmissionDate;
    @FXML
    private TextField txtD8InternalQualityRepresentative;
    @FXML
    private DatePicker dpD8InternalQualityApprovalDate;
    @FXML
    private TextField txtD8InternalRepresentative1;
    @FXML
    private DatePicker dpD8InternalRepresentative1ApprovalDate;
    @FXML
    private TextField txtD8InternalRepresentative2;
    @FXML
    private DatePicker dpD8InternalRepresentative2ApprovalDate;
    @FXML
    private TableView<String> tblD4MethodCauses;
    @FXML
    private TableColumn<String, String> colD4MethodCause;
    @FXML
    private Button btnAddD4MethodCause;
    @FXML
    private Button btnDeleteD4MethodCause;
    @FXML
    private TableView<String> tblD4MachineCauses;
    @FXML
    private TableColumn<String, String> colD4MachineCause;
    @FXML
    private Button btnAddD4MachineCause;
    @FXML
    private Button btnDeleteD4MachineCause;
    @FXML
    private TableView<String> tblD4MaterialCauses;
    @FXML
    private TableColumn<String, String> colD4MaterialCause;
    @FXML
    private Button btnAddD4MaterialCause;
    @FXML
    private Button btnDeleteD4MaterialCause;
    @FXML
    private TableView<String> tblD4ManpowerCauses;
    @FXML
    private TableColumn<String, String> colD4ManpowerCause;
    @FXML
    private Button btnAddD4ManpowerCause;
    @FXML
    private Button btnDeleteD4ManpowerCause;
    @FXML
    private TextArea txtProblemDescription;
    @FXML
    private MenuButton menuD2Tools;
    @FXML
    private MenuButton menuD3Tools;
    @FXML
    private MenuButton menuD4Tools;
    @FXML
    private TilePane tileImages;
    @FXML
    private ImageView imgSelected;
    @FXML
    private Button btnAddImage;
    @FXML
    private Button btnRemoveImage;
    private Image icSave;
    private Image icExit;
    private Image icExport;
    private Image icPlus;
    private Image icTrash;
    private Image icEdit;
    private Image icTable;
    private Image icSearch;
    private Stage ownerStage;
    private boolean hasUnsavedChanges = false;
    private boolean programmaticClose = false;
    private boolean syncing = false;
    private EightD report;
    private EightDImage selectedImage;
    private final Map<EightDImage, StackPane> imageTiles = new HashMap<EightDImage, StackPane>();
    private final List<Runnable> bindingCleanups = new ArrayList<Runnable>();
    private Runnable saveAction;
    private Runnable dirtyHook = () -> {
        this.hasUnsavedChanges = true;
    };
    private Supplier<List<EightD>> eightDReportsProvider;
    private Supplier<String> projectIdProvider;

    @FXML
    private void initialize() {
        this.loadIcons();
        this.configureHeaderIcon();
        this.configureToolbar();
        this.configureStatusOptions();
        this.configureTeamTable();
        this.configureContainmentTable();
        this.configureD5CorrectiveActionsTable();
        this.configureD6EffectivenessVerificationTable();
        this.configureD7PreventiveActionsTable();
        this.configurePossibleCausesTables();
        this.configureImagePane();
        this.configureD2Tools();
        this.configureD3Tools();
        this.configureD4Tools();
        this.applyDefaultTooltips();
    }

    public void setOwnerStage(Stage stage) {
        this.ownerStage = stage;
        if (stage != null) {
            stage.setMinWidth(1000.0);
            stage.setMinHeight(700.0);
        }
        this.installCloseHandler();
    }

    public void setSaveAction(Runnable saveAction) {
        this.saveAction = saveAction;
    }

    public void setDirtyHook(Runnable dirtyHook) {
        Runnable delegate = dirtyHook == null ? () -> {} : dirtyHook;
        this.dirtyHook = () -> {
            this.hasUnsavedChanges = true;
            delegate.run();
        };
    }

    public void setEightDReportsProvider(Supplier<List<EightD>> provider) {
        this.eightDReportsProvider = provider;
    }

    public void setProjectIdProvider(Supplier<String> provider) {
        this.projectIdProvider = provider;
    }

    public void setEightD(EightD report) {
        this.clearBindings();
        this.report = report;
        this.hasUnsavedChanges = false;
        this.selectedImage = null;
        if (this.tblTeamMembers != null) {
            this.tblTeamMembers.setItems(report == null ? FXCollections.observableArrayList() : report.getTeamMembers());
        }
        if (this.tblContainmentActions != null) {
            this.tblContainmentActions.setItems(report == null ? FXCollections.observableArrayList() : report.getContainmentActions());
        }
        if (this.tblD5CorrectiveActions != null) {
            this.tblD5CorrectiveActions.setItems(report == null ? FXCollections.observableArrayList() : report.getCorrectiveActions());
        }
        if (this.tblD6EffectivenessVerifications != null) {
            this.tblD6EffectivenessVerifications.setItems(report == null ? FXCollections.observableArrayList() : report.getEffectivenessVerifications());
        }
        if (this.tblD7PreventiveActions != null) {
            this.tblD7PreventiveActions.setItems(report == null ? FXCollections.observableArrayList() : report.getPreventiveActions());
        }
        if (this.tblD4MethodCauses != null) {
            this.tblD4MethodCauses.setItems(report == null ? FXCollections.observableArrayList() : report.getPossibleCausesMethod());
        }
        if (this.tblD4MachineCauses != null) {
            this.tblD4MachineCauses.setItems(report == null ? FXCollections.observableArrayList() : report.getPossibleCausesMachine());
        }
        if (this.tblD4MaterialCauses != null) {
            this.tblD4MaterialCauses.setItems(report == null ? FXCollections.observableArrayList() : report.getPossibleCausesMaterial());
        }
        if (this.tblD4ManpowerCauses != null) {
            this.tblD4ManpowerCauses.setItems(report == null ? FXCollections.observableArrayList() : report.getPossibleCausesManpower());
        }
        this.updateRemoveTeamMemberState();
        this.updateRemoveContainmentActionState();
        this.updateRemoveD5CorrectiveActionState();
        this.updateRemoveD6VerificationState();
        this.updateRemoveD7PreventiveActionState();
        this.updateRemoveD4MethodCauseState();
        this.updateRemoveD4MachineCauseState();
        this.updateRemoveD4MaterialCauseState();
        this.updateRemoveD4ManpowerCauseState();
        if (report == null) {
            this.refreshImageTiles();
            return;
        }
        this.syncing = true;
        try {
            this.bindDate(this.dpDateOpened, report.dateOpenedProperty());
            this.bindDate(this.dpDateRevised, report.dateRevisedProperty());
            this.bindDate(this.dpClosedDate, report.closedDateProperty());
            this.bindDate(this.dpContainmentDueDate, report.containmentDueDateProperty());
            this.bindCombo(this.cbStatus, report.statusProperty());
            this.bindText(this.txtInternalClaimNumber, report.internalClaimNumberProperty());
            this.bindText(this.txtCustomerClaimNumber, report.customerClaimNumberProperty());
            this.bindText(this.txtCustomer, report.customerProperty());
            this.bindText(this.txtCustomerContact, report.customerContactProperty());
            this.bindText(this.txtInternalContact, report.internalContactProperty());
            this.bindText(this.txtPartNumber, report.partNumberProperty());
            this.bindText(this.txtPartDescription, report.partDescriptionProperty());
            this.bindText(this.txtQuantity, report.quantityProperty());
            this.bindTextArea(this.txtNonConformance, report.nonConformanceNotificationProperty());
            this.bindTextArea(this.txtProblemDescription, report.problemDescriptionProperty());
            this.bindText(this.txtD8SubmittedBy, report.d8SubmittedByProperty());
            this.bindDate(this.dpD8SubmissionDate, report.d8SubmissionDateProperty());
            this.bindText(this.txtD8InternalQualityRepresentative, report.d8InternalQualityRepresentativeProperty());
            this.bindDate(this.dpD8InternalQualityApprovalDate, report.d8InternalQualityApprovalDateProperty());
            this.bindText(this.txtD8InternalRepresentative1, report.d8InternalRepresentative1Property());
            this.bindDate(this.dpD8InternalRepresentative1ApprovalDate, report.d8InternalRepresentative1ApprovalDateProperty());
            this.bindText(this.txtD8InternalRepresentative2, report.d8InternalRepresentative2Property());
            this.bindDate(this.dpD8InternalRepresentative2ApprovalDate, report.d8InternalRepresentative2ApprovalDateProperty());
            this.bindPossibleCauses(report.getPossibleCausesMethod());
            this.bindPossibleCauses(report.getPossibleCausesMachine());
            this.bindPossibleCauses(report.getPossibleCausesMaterial());
            this.bindPossibleCauses(report.getPossibleCausesManpower());
            this.bindContainmentActions(report.getContainmentActions());
            this.bindCorrectiveActions(report.getCorrectiveActions());
            this.bindEffectivenessVerifications(report.getEffectivenessVerifications());
            this.bindPreventiveActions(report.getPreventiveActions());
            this.bindChecklistPair(this.chkD7DesignFmea, this.dpD7DesignFmeaDate, report.d7DesignFmeaCheckedProperty(), report.d7DesignFmeaDateProperty());
            this.bindChecklistPair(this.chkD7ProcessFmea, this.dpD7ProcessFmeaDate, report.d7ProcessFmeaCheckedProperty(), report.d7ProcessFmeaDateProperty());
            this.bindChecklistPair(this.chkD7ControlPlans, this.dpD7ControlPlansDate, report.d7ControlPlansCheckedProperty(), report.d7ControlPlansDateProperty());
            this.bindChecklistPair(this.chkD7GageDrawing, this.dpD7GageDrawingDate, report.d7GageDrawingCheckedProperty(), report.d7GageDrawingDateProperty());
            this.bindChecklistPair(this.chkD7ProcessFlow, this.dpD7ProcessFlowDate, report.d7ProcessFlowCheckedProperty(), report.d7ProcessFlowDateProperty());
            this.bindChecklistPair(this.chkD7WorkInstructions, this.dpD7WorkInstructionsDate, report.d7WorkInstructionsCheckedProperty(), report.d7WorkInstructionsDateProperty());
            this.bindChecklistPair(this.chkD7Drawing, this.dpD7DrawingDate, report.d7DrawingCheckedProperty(), report.d7DrawingDateProperty());
            this.bindChecklistPair(this.chkD7DesignStandards, this.dpD7DesignStandardsDate, report.d7DesignStandardsCheckedProperty(), report.d7DesignStandardsDateProperty());
            this.bindChecklistPair(this.chkD7PackingSpecs, this.dpD7PackingSpecsDate, report.d7PackingSpecsCheckedProperty(), report.d7PackingSpecsDateProperty());
            this.bindChecklistPair(this.chkD7InternalAudit, this.dpD7InternalAuditDate, report.d7InternalAuditCheckedProperty(), report.d7InternalAuditDateProperty());
            this.bindChecklistPair(this.chkD7ToolingDrawing, this.dpD7ToolingDrawingDate, report.d7ToolingDrawingCheckedProperty(), report.d7ToolingDrawingDateProperty());
            this.bindChecklistPair(this.chkD7OperatorTraining, this.dpD7OperatorTrainingDate, report.d7OperatorTrainingCheckedProperty(), report.d7OperatorTrainingDateProperty());
            this.bindTeamMembers(report.getTeamMembers());
            this.bindImages(report.getImages());
        }
        finally {
            this.syncing = false;
        }
    }

    private void clearBindings() {
        this.bindingCleanups.forEach(Runnable::run);
        this.bindingCleanups.clear();
    }

    private void bindText(TextField field, StringProperty property) {
        if (field == null || property == null) {
            return;
        }
        field.textProperty().bindBidirectional((Property)property);
        ChangeListener listener = (obs, oldV, newV) -> this.markDirty();
        property.addListener(listener);
        this.bindingCleanups.add(() -> {
            field.textProperty().unbindBidirectional((Property)property);
            property.removeListener(listener);
        });
    }

    private void bindTextArea(TextArea area, StringProperty property) {
        if (area == null || property == null) {
            return;
        }
        area.textProperty().bindBidirectional((Property)property);
        ChangeListener listener = (obs, oldV, newV) -> this.markDirty();
        property.addListener(listener);
        this.bindingCleanups.add(() -> {
            area.textProperty().unbindBidirectional((Property)property);
            property.removeListener(listener);
        });
    }

    private void bindDate(DatePicker picker, ObjectProperty<LocalDate> property) {
        if (picker == null || property == null) {
            return;
        }
        picker.valueProperty().bindBidirectional(property);
        ChangeListener listener = (obs, oldV, newV) -> this.markDirty();
        property.addListener(listener);
        this.bindingCleanups.add(() -> {
            picker.valueProperty().unbindBidirectional((Property)property);
            property.removeListener(listener);
        });
    }

    private void bindBoolean(CheckBox checkBox, BooleanProperty property) {
        if (checkBox == null || property == null) {
            return;
        }
        checkBox.selectedProperty().bindBidirectional((Property)property);
        ChangeListener listener = (obs, oldV, newV) -> this.markDirty();
        property.addListener(listener);
        this.bindingCleanups.add(() -> {
            checkBox.selectedProperty().unbindBidirectional((Property)property);
            property.removeListener(listener);
        });
    }

    private void bindCombo(ComboBox<String> combo, StringProperty property) {
        if (combo == null || property == null) {
            return;
        }
        combo.setEditable(true);
        combo.getEditor().textProperty().bindBidirectional((Property)property);
        ChangeListener listener = (obs, oldV, newV) -> this.markDirty();
        property.addListener(listener);
        this.bindingCleanups.add(() -> {
            combo.getEditor().textProperty().unbindBidirectional((Property)property);
            property.removeListener(listener);
        });
    }

    private void bindTeamMembers(ObservableList<EightDTeamMember> members) {
        if (members == null) {
            return;
        }
        ListChangeListener listener = change -> this.markDirty();
        members.addListener(listener);
        this.bindingCleanups.add(() -> members.removeListener(listener));
    }

    private void bindContainmentActions(ObservableList<EightDContainmentAction> actions) {
        if (actions == null) {
            return;
        }
        ListChangeListener listener = change -> this.markDirty();
        actions.addListener(listener);
        this.bindingCleanups.add(() -> actions.removeListener(listener));
    }

    private void bindCorrectiveActions(ObservableList<EightDCorrectiveAction> actions) {
        if (actions == null) {
            return;
        }
        ListChangeListener listener = change -> this.markDirty();
        actions.addListener(listener);
        this.bindingCleanups.add(() -> actions.removeListener(listener));
    }

    private void bindEffectivenessVerifications(ObservableList<EightDEffectivenessVerification> verifications) {
        if (verifications == null) {
            return;
        }
        ListChangeListener listener = change -> this.markDirty();
        verifications.addListener(listener);
        this.bindingCleanups.add(() -> verifications.removeListener(listener));
    }

    private void bindPreventiveActions(ObservableList<EightDPreventiveAction> actions) {
        if (actions == null) {
            return;
        }
        ListChangeListener listener = change -> this.markDirty();
        actions.addListener(listener);
        this.bindingCleanups.add(() -> actions.removeListener(listener));
    }

    private void bindChecklistPair(CheckBox checkBox, DatePicker datePicker, BooleanProperty checkedProperty, ObjectProperty<LocalDate> dateProperty) {
        this.bindBoolean(checkBox, checkedProperty);
        this.bindDate(datePicker, dateProperty);
        if (checkBox == null || datePicker == null) {
            return;
        }
        datePicker.disableProperty().bind((ObservableValue)checkBox.selectedProperty().not());
        this.bindingCleanups.add(() -> datePicker.disableProperty().unbind());
    }

    private void bindPossibleCauses(ObservableList<String> causes) {
        if (causes == null) {
            return;
        }
        ListChangeListener listener = change -> this.markDirty();
        causes.addListener(listener);
        this.bindingCleanups.add(() -> causes.removeListener(listener));
    }

    private void bindImages(ObservableList<EightDImage> images) {
        if (images == null) {
            return;
        }
        ListChangeListener listener = change -> {
            this.markDirty();
            this.refreshImageTiles();
        };
        images.addListener(listener);
        this.bindingCleanups.add(() -> images.removeListener(listener));
        this.refreshImageTiles();
    }

    private void configureToolbar() {
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setOnAction(e -> this.onSaveOnly());
            this.btnSaveOnly.setGraphic((Node)this.icon(this.icSave, 18.0));
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setOnAction(e -> this.onSaveAndExit());
            this.btnSaveExit.setGraphic((Node)this.icon(this.icExit, 18.0));
        }
        if (this.btnExportReport != null) {
            this.btnExportReport.setOnAction(e -> this.onExportReport());
            this.btnExportReport.setGraphic((Node)this.icon(this.icExport, 16.0));
        }
    }

    private void configureStatusOptions() {
        if (this.cbStatus == null) {
            return;
        }
        this.cbStatus.setItems(FXCollections.observableArrayList((Object[])new String[]{"Open", "In Progress", "Closed", "On Hold"}));
    }

    private void configureTeamTable() {
        if (this.tblTeamMembers == null) {
            return;
        }
        this.tblTeamMembers.setEditable(true);
        this.tblTeamMembers.getSelectionModel().setCellSelectionEnabled(true);
        this.tblTeamMembers.setPlaceholder((Node)new Label("No team members added."));
        this.stringColumn(this.colTeamName, EightDTeamMember::nameProperty);
        this.stringColumn(this.colTeamRole, EightDTeamMember::roleFunctionProperty);
        this.stringColumn(this.colTeamDepartment, EightDTeamMember::departmentProperty);
        this.stringColumn(this.colTeamCompany, EightDTeamMember::companyProperty);
        this.stringColumn(this.colTeamResponsibility, EightDTeamMember::responsibilityProperty);
        this.stringColumn(this.colTeamEmail, EightDTeamMember::emailProperty);
        if (this.btnAddTeamMember != null) {
            this.btnAddTeamMember.setOnAction(e -> this.addTeamMember());
            this.btnAddTeamMember.setGraphic((Node)this.icon(this.icPlus, 14.0));
        }
        if (this.btnDeleteTeamMember != null) {
            this.btnDeleteTeamMember.setOnAction(e -> this.removeSelectedTeamMember());
            this.btnDeleteTeamMember.setGraphic((Node)this.icon(this.icTrash, 14.0));
        }
        this.tblTeamMembers.getSelectionModel().selectedItemProperty().addListener((obs, oldV, newV) -> this.updateRemoveTeamMemberState());
        this.tblTeamMembers.setOnKeyPressed(event -> {
            switch (event.getCode()) {
                case INSERT: {
                    this.addTeamMember();
                    event.consume();
                    break;
                }
                case DELETE: {
                    this.removeSelectedTeamMember();
                    event.consume();
                    break;
                }
                case F2: {
                    this.startEditingSelectedTeamMember();
                    event.consume();
                    break;
                }
            }
        });
        MenuItem addFromTable = new MenuItem("Add member", (Node)this.icon(this.icPlus, 12.0));
        addFromTable.setOnAction(e -> this.addTeamMember());
        this.tblTeamMembers.setContextMenu(new ContextMenu(new MenuItem[]{addFromTable}));
        this.tblTeamMembers.setRowFactory(tv -> {
            TableRow row = new TableRow();
            MenuItem add = new MenuItem("Add member", (Node)this.icon(this.icPlus, 12.0));
            add.setOnAction(e -> this.addTeamMember());
            MenuItem edit = new MenuItem("Edit member", (Node)this.icon(this.icEdit, 12.0));
            edit.setOnAction(e -> {
                if (row.isEmpty()) {
                    return;
                }
                this.tblTeamMembers.getSelectionModel().clearAndSelect(row.getIndex());
                this.startEditingSelectedTeamMember();
            });
            MenuItem remove = new MenuItem("Remove member", (Node)this.icon(this.icTrash, 12.0));
            remove.setOnAction(e -> {
                if (row.isEmpty()) {
                    return;
                }
                this.tblTeamMembers.getSelectionModel().clearAndSelect(row.getIndex());
                this.removeSelectedTeamMember();
            });
            ContextMenu rowMenu = new ContextMenu(new MenuItem[]{add, edit, remove});
            row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)row.emptyProperty()).then((Object)null).otherwise((Object)rowMenu));
            row.setOnContextMenuRequested(e -> {
                if (!row.isEmpty()) {
                    this.tblTeamMembers.getSelectionModel().clearAndSelect(row.getIndex());
                }
            });
            return row;
        });
        this.updateRemoveTeamMemberState();
    }

    private void configureContainmentTable() {
        if (this.tblContainmentActions == null) {
            return;
        }
        this.tblContainmentActions.setEditable(true);
        this.tblContainmentActions.getSelectionModel().setCellSelectionEnabled(true);
        this.tblContainmentActions.setPlaceholder((Node)new Label("No containment actions added."));
        this.containmentStringColumn(this.colContainmentAction, EightDContainmentAction::actionProperty);
        this.containmentStringColumn(this.colContainmentResponsiblePerson, EightDContainmentAction::responsiblePersonProperty);
        this.containmentDateColumn(this.colContainmentTargetDate, EightDContainmentAction::targetDateProperty);
        this.containmentDateColumn(this.colContainmentImplementationDate, EightDContainmentAction::implementationDateProperty);
        this.containmentStringColumn(this.colContainmentMethod, EightDContainmentAction::verificationMethodProperty);
        this.containmentStringColumn(this.colContainmentQtyContained, EightDContainmentAction::qtyContainedProperty);
        this.containmentStringColumn(this.colContainmentQtyRejected, EightDContainmentAction::qtyRejectedProperty);
        if (this.btnAddContainmentAction != null) {
            this.btnAddContainmentAction.setOnAction(e -> this.addContainmentAction());
            this.btnAddContainmentAction.setGraphic((Node)this.icon(this.icPlus, 14.0));
        }
        if (this.btnDeleteContainmentAction != null) {
            this.btnDeleteContainmentAction.setOnAction(e -> this.removeSelectedContainmentAction());
            this.btnDeleteContainmentAction.setGraphic((Node)this.icon(this.icTrash, 14.0));
        }
        this.tblContainmentActions.getSelectionModel().selectedItemProperty().addListener((obs, oldV, newV) -> this.updateRemoveContainmentActionState());
        this.tblContainmentActions.setOnKeyPressed(event -> {
            switch (event.getCode()) {
                case INSERT: {
                    this.addContainmentAction();
                    event.consume();
                    break;
                }
                case DELETE: {
                    this.removeSelectedContainmentAction();
                    event.consume();
                    break;
                }
                case F2: {
                    this.startEditingSelectedContainmentAction();
                    event.consume();
                    break;
                }
            }
        });
        MenuItem addFromTable = new MenuItem("Add action", (Node)this.icon(this.icPlus, 12.0));
        addFromTable.setOnAction(e -> this.addContainmentAction());
        this.tblContainmentActions.setContextMenu(new ContextMenu(new MenuItem[]{addFromTable}));
        this.tblContainmentActions.setRowFactory(tv -> {
            TableRow row = new TableRow();
            MenuItem add = new MenuItem("Add action", (Node)this.icon(this.icPlus, 12.0));
            add.setOnAction(e -> this.addContainmentAction());
            MenuItem edit = new MenuItem("Edit action", (Node)this.icon(this.icEdit, 12.0));
            edit.setOnAction(e -> {
                if (row.isEmpty()) {
                    return;
                }
                this.tblContainmentActions.getSelectionModel().clearAndSelect(row.getIndex());
                this.startEditingSelectedContainmentAction();
            });
            MenuItem remove = new MenuItem("Remove action", (Node)this.icon(this.icTrash, 12.0));
            remove.setOnAction(e -> {
                if (row.isEmpty()) {
                    return;
                }
                this.tblContainmentActions.getSelectionModel().clearAndSelect(row.getIndex());
                this.removeSelectedContainmentAction();
            });
            ContextMenu rowMenu = new ContextMenu(new MenuItem[]{add, edit, remove});
            row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)row.emptyProperty()).then((Object)null).otherwise((Object)rowMenu));
            row.setOnContextMenuRequested(e -> {
                if (!row.isEmpty()) {
                    this.tblContainmentActions.getSelectionModel().clearAndSelect(row.getIndex());
                }
            });
            return row;
        });
        this.updateRemoveContainmentActionState();
    }

    private void configureD5CorrectiveActionsTable() {
        if (this.tblD5CorrectiveActions == null) {
            return;
        }
        this.tblD5CorrectiveActions.setEditable(true);
        this.tblD5CorrectiveActions.getSelectionModel().setCellSelectionEnabled(true);
        this.tblD5CorrectiveActions.setPlaceholder((Node)new Label("No corrective actions added."));
        this.correctiveStringColumn(this.colD5CorrectiveAction, EightDCorrectiveAction::actionProperty);
        this.correctiveStringColumn(this.colD5ResponsiblePerson, EightDCorrectiveAction::responsiblePersonProperty);
        this.correctiveDateColumn(this.colD5TargetDate, EightDCorrectiveAction::targetDateProperty);
        this.correctiveDateColumn(this.colD5ImplementationDate, EightDCorrectiveAction::implementationDateProperty);
        if (this.btnAddD5CorrectiveAction != null) {
            this.btnAddD5CorrectiveAction.setOnAction(e -> this.addD5CorrectiveAction());
            this.btnAddD5CorrectiveAction.setGraphic((Node)this.icon(this.icPlus, 14.0));
        }
        if (this.btnDeleteD5CorrectiveAction != null) {
            this.btnDeleteD5CorrectiveAction.setOnAction(e -> this.removeSelectedD5CorrectiveAction());
            this.btnDeleteD5CorrectiveAction.setGraphic((Node)this.icon(this.icTrash, 14.0));
        }
        this.tblD5CorrectiveActions.getSelectionModel().selectedItemProperty().addListener((obs, oldV, newV) -> this.updateRemoveD5CorrectiveActionState());
        this.tblD5CorrectiveActions.setOnKeyPressed(event -> {
            switch (event.getCode()) {
                case INSERT: {
                    this.addD5CorrectiveAction();
                    event.consume();
                    break;
                }
                case DELETE: {
                    this.removeSelectedD5CorrectiveAction();
                    event.consume();
                    break;
                }
                case F2: {
                    this.startEditingSelectedD5CorrectiveAction();
                    event.consume();
                    break;
                }
            }
        });
        MenuItem addFromTable = new MenuItem("Add corrective action", (Node)this.icon(this.icPlus, 12.0));
        addFromTable.setOnAction(e -> this.addD5CorrectiveAction());
        this.tblD5CorrectiveActions.setContextMenu(new ContextMenu(new MenuItem[]{addFromTable}));
        this.tblD5CorrectiveActions.setRowFactory(tv -> {
            TableRow row = new TableRow();
            MenuItem add = new MenuItem("Add corrective action", (Node)this.icon(this.icPlus, 12.0));
            add.setOnAction(e -> this.addD5CorrectiveAction());
            MenuItem edit = new MenuItem("Edit corrective action", (Node)this.icon(this.icEdit, 12.0));
            edit.setOnAction(e -> {
                if (row.isEmpty()) {
                    return;
                }
                this.tblD5CorrectiveActions.getSelectionModel().clearAndSelect(row.getIndex());
                this.startEditingSelectedD5CorrectiveAction();
            });
            MenuItem remove = new MenuItem("Remove corrective action", (Node)this.icon(this.icTrash, 12.0));
            remove.setOnAction(e -> {
                if (row.isEmpty()) {
                    return;
                }
                this.tblD5CorrectiveActions.getSelectionModel().clearAndSelect(row.getIndex());
                this.removeSelectedD5CorrectiveAction();
            });
            ContextMenu rowMenu = new ContextMenu(new MenuItem[]{add, edit, remove});
            row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)row.emptyProperty()).then((Object)null).otherwise((Object)rowMenu));
            row.setOnContextMenuRequested(e -> {
                if (!row.isEmpty()) {
                    this.tblD5CorrectiveActions.getSelectionModel().clearAndSelect(row.getIndex());
                }
            });
            return row;
        });
        this.updateRemoveD5CorrectiveActionState();
    }

    private void configureD6EffectivenessVerificationTable() {
        if (this.tblD6EffectivenessVerifications == null) {
            return;
        }
        this.tblD6EffectivenessVerifications.setEditable(true);
        this.tblD6EffectivenessVerifications.getSelectionModel().setCellSelectionEnabled(true);
        this.tblD6EffectivenessVerifications.setPlaceholder((Node)new Label("No verifications added."));
        this.d6StringColumn(this.colD6Method, EightDEffectivenessVerification::methodProperty);
        this.d6StringColumn(this.colD6Result, EightDEffectivenessVerification::resultProperty);
        this.d6DateColumn(this.colD6Date, EightDEffectivenessVerification::dateProperty);
        if (this.btnAddD6Verification != null) {
            this.btnAddD6Verification.setOnAction(e -> this.addD6Verification());
            this.btnAddD6Verification.setGraphic((Node)this.icon(this.icPlus, 14.0));
        }
        if (this.btnDeleteD6Verification != null) {
            this.btnDeleteD6Verification.setOnAction(e -> this.removeSelectedD6Verification());
            this.btnDeleteD6Verification.setGraphic((Node)this.icon(this.icTrash, 14.0));
        }
        this.tblD6EffectivenessVerifications.getSelectionModel().selectedItemProperty().addListener((obs, oldV, newV) -> this.updateRemoveD6VerificationState());
        this.tblD6EffectivenessVerifications.setOnKeyPressed(event -> {
            switch (event.getCode()) {
                case INSERT: {
                    this.addD6Verification();
                    event.consume();
                    break;
                }
                case DELETE: {
                    this.removeSelectedD6Verification();
                    event.consume();
                    break;
                }
                case F2: {
                    this.startEditingSelectedD6Verification();
                    event.consume();
                    break;
                }
            }
        });
        MenuItem addFromTable = new MenuItem("Add verification", (Node)this.icon(this.icPlus, 12.0));
        addFromTable.setOnAction(e -> this.addD6Verification());
        this.tblD6EffectivenessVerifications.setContextMenu(new ContextMenu(new MenuItem[]{addFromTable}));
        this.tblD6EffectivenessVerifications.setRowFactory(tv -> {
            TableRow row = new TableRow();
            MenuItem add = new MenuItem("Add verification", (Node)this.icon(this.icPlus, 12.0));
            add.setOnAction(e -> this.addD6Verification());
            MenuItem edit = new MenuItem("Edit verification", (Node)this.icon(this.icEdit, 12.0));
            edit.setOnAction(e -> {
                if (row.isEmpty()) {
                    return;
                }
                this.tblD6EffectivenessVerifications.getSelectionModel().clearAndSelect(row.getIndex());
                this.startEditingSelectedD6Verification();
            });
            MenuItem remove = new MenuItem("Remove verification", (Node)this.icon(this.icTrash, 12.0));
            remove.setOnAction(e -> {
                if (row.isEmpty()) {
                    return;
                }
                this.tblD6EffectivenessVerifications.getSelectionModel().clearAndSelect(row.getIndex());
                this.removeSelectedD6Verification();
            });
            ContextMenu rowMenu = new ContextMenu(new MenuItem[]{add, edit, remove});
            row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)row.emptyProperty()).then((Object)null).otherwise((Object)rowMenu));
            row.setOnContextMenuRequested(e -> {
                if (!row.isEmpty()) {
                    this.tblD6EffectivenessVerifications.getSelectionModel().clearAndSelect(row.getIndex());
                }
            });
            return row;
        });
        this.updateRemoveD6VerificationState();
    }

    private void configureD7PreventiveActionsTable() {
        if (this.tblD7PreventiveActions == null) {
            return;
        }
        this.tblD7PreventiveActions.setEditable(true);
        this.tblD7PreventiveActions.getSelectionModel().setCellSelectionEnabled(true);
        this.tblD7PreventiveActions.setPlaceholder((Node)new Label("No preventive actions added."));
        this.d7StringColumn(this.colD7Product, EightDPreventiveAction::productProperty);
        this.d7StringColumn(this.colD7Lines, EightDPreventiveAction::linesProperty);
        this.d7StringColumn(this.colD7ResponsiblePerson, EightDPreventiveAction::responsiblePersonProperty);
        this.d7DateColumn(this.colD7TargetDate, EightDPreventiveAction::targetDateProperty);
        this.d7DateColumn(this.colD7ImplementationDate, EightDPreventiveAction::implementationDateProperty);
        this.d7StringColumn(this.colD7VerificationMethod, EightDPreventiveAction::verificationMethodProperty);
        this.d7StringColumn(this.colD7VerificationResult, EightDPreventiveAction::verificationResultProperty);
        this.d7DateColumn(this.colD7VerificationDate, EightDPreventiveAction::verificationDateProperty);
        if (this.btnAddD7PreventiveAction != null) {
            this.btnAddD7PreventiveAction.setOnAction(e -> this.addD7PreventiveAction());
            this.btnAddD7PreventiveAction.setGraphic((Node)this.icon(this.icPlus, 14.0));
        }
        if (this.btnDeleteD7PreventiveAction != null) {
            this.btnDeleteD7PreventiveAction.setOnAction(e -> this.removeSelectedD7PreventiveAction());
            this.btnDeleteD7PreventiveAction.setGraphic((Node)this.icon(this.icTrash, 14.0));
        }
        this.tblD7PreventiveActions.getSelectionModel().selectedItemProperty().addListener((obs, oldV, newV) -> this.updateRemoveD7PreventiveActionState());
        this.tblD7PreventiveActions.setOnKeyPressed(event -> {
            switch (event.getCode()) {
                case INSERT: {
                    this.addD7PreventiveAction();
                    event.consume();
                    break;
                }
                case DELETE: {
                    this.removeSelectedD7PreventiveAction();
                    event.consume();
                    break;
                }
                case F2: {
                    this.startEditingSelectedD7PreventiveAction();
                    event.consume();
                    break;
                }
            }
        });
        MenuItem addFromTable = new MenuItem("Add preventive action", (Node)this.icon(this.icPlus, 12.0));
        addFromTable.setOnAction(e -> this.addD7PreventiveAction());
        this.tblD7PreventiveActions.setContextMenu(new ContextMenu(new MenuItem[]{addFromTable}));
        this.tblD7PreventiveActions.setRowFactory(tv -> {
            TableRow row = new TableRow();
            MenuItem add = new MenuItem("Add preventive action", (Node)this.icon(this.icPlus, 12.0));
            add.setOnAction(e -> this.addD7PreventiveAction());
            MenuItem edit = new MenuItem("Edit preventive action", (Node)this.icon(this.icEdit, 12.0));
            edit.setOnAction(e -> {
                if (row.isEmpty()) {
                    return;
                }
                this.tblD7PreventiveActions.getSelectionModel().clearAndSelect(row.getIndex());
                this.startEditingSelectedD7PreventiveAction();
            });
            MenuItem remove = new MenuItem("Remove preventive action", (Node)this.icon(this.icTrash, 12.0));
            remove.setOnAction(e -> {
                if (row.isEmpty()) {
                    return;
                }
                this.tblD7PreventiveActions.getSelectionModel().clearAndSelect(row.getIndex());
                this.removeSelectedD7PreventiveAction();
            });
            ContextMenu rowMenu = new ContextMenu(new MenuItem[]{add, edit, remove});
            row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)row.emptyProperty()).then((Object)null).otherwise((Object)rowMenu));
            row.setOnContextMenuRequested(e -> {
                if (!row.isEmpty()) {
                    this.tblD7PreventiveActions.getSelectionModel().clearAndSelect(row.getIndex());
                }
            });
            return row;
        });
        this.updateRemoveD7PreventiveActionState();
    }

    private void configurePossibleCausesTables() {
        this.configurePossibleCauseTable(this.tblD4MethodCauses, this.colD4MethodCause, this.btnAddD4MethodCause, this.btnDeleteD4MethodCause, "No entries added.", this::addD4MethodCause, this::removeSelectedD4MethodCause, this::startEditingSelectedD4MethodCause, this::updateRemoveD4MethodCauseState);
        this.configurePossibleCauseTable(this.tblD4MachineCauses, this.colD4MachineCause, this.btnAddD4MachineCause, this.btnDeleteD4MachineCause, "No entries added.", this::addD4MachineCause, this::removeSelectedD4MachineCause, this::startEditingSelectedD4MachineCause, this::updateRemoveD4MachineCauseState);
        this.configurePossibleCauseTable(this.tblD4MaterialCauses, this.colD4MaterialCause, this.btnAddD4MaterialCause, this.btnDeleteD4MaterialCause, "No entries added.", this::addD4MaterialCause, this::removeSelectedD4MaterialCause, this::startEditingSelectedD4MaterialCause, this::updateRemoveD4MaterialCauseState);
        this.configurePossibleCauseTable(this.tblD4ManpowerCauses, this.colD4ManpowerCause, this.btnAddD4ManpowerCause, this.btnDeleteD4ManpowerCause, "No entries added.", this::addD4ManpowerCause, this::removeSelectedD4ManpowerCause, this::startEditingSelectedD4ManpowerCause, this::updateRemoveD4ManpowerCauseState);
    }

    private void configurePossibleCauseTable(TableView<String> table, TableColumn<String, String> col, Button addButton, Button deleteButton, String emptyText, Runnable onAdd, Runnable onRemove, Runnable onEdit, Runnable updateState) {
        if (table == null || col == null) {
            return;
        }
        table.setEditable(true);
        table.getSelectionModel().setCellSelectionEnabled(true);
        table.setPlaceholder((Node)new Label(emptyText));
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        col.setEditable(true);
        col.setCellValueFactory(c -> new ReadOnlyStringWrapper((String)c.getValue()));
        col.setCellFactory(TextFieldTableCell.forTableColumn());
        col.setOnEditCommit(event -> {
            TableView view = event.getTableView();
            if (view == null) {
                return;
            }
            int row = event.getTablePosition().getRow();
            ObservableList items = view.getItems();
            if (items == null || row < 0 || row >= items.size()) {
                return;
            }
            String newValue = event.getNewValue() == null ? "" : (String)event.getNewValue();
            items.set(row, (Object)newValue);
            this.markDirty();
        });
        if (addButton != null) {
            addButton.setOnAction(e -> onAdd.run());
            addButton.setGraphic((Node)this.icon(this.icPlus, 14.0));
        }
        if (deleteButton != null) {
            deleteButton.setOnAction(e -> onRemove.run());
            deleteButton.setGraphic((Node)this.icon(this.icTrash, 14.0));
        }
        table.getSelectionModel().selectedItemProperty().addListener((obs, oldV, newV) -> updateState.run());
        table.setOnKeyPressed(event -> {
            switch (event.getCode()) {
                case INSERT: {
                    onAdd.run();
                    event.consume();
                    break;
                }
                case DELETE: {
                    onRemove.run();
                    event.consume();
                    break;
                }
                case F2: {
                    onEdit.run();
                    event.consume();
                    break;
                }
            }
        });
        MenuItem addFromTable = new MenuItem("Add entry", (Node)this.icon(this.icPlus, 12.0));
        addFromTable.setOnAction(e -> onAdd.run());
        table.setContextMenu(new ContextMenu(new MenuItem[]{addFromTable}));
        table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            MenuItem add = new MenuItem("Add entry", (Node)this.icon(this.icPlus, 12.0));
            add.setOnAction(e -> onAdd.run());
            MenuItem edit = new MenuItem("Edit entry", (Node)this.icon(this.icEdit, 12.0));
            edit.setOnAction(e -> {
                if (row.isEmpty()) {
                    return;
                }
                table.getSelectionModel().clearAndSelect(row.getIndex());
                onEdit.run();
            });
            MenuItem remove = new MenuItem("Remove entry", (Node)this.icon(this.icTrash, 12.0));
            remove.setOnAction(e -> {
                if (row.isEmpty()) {
                    return;
                }
                table.getSelectionModel().clearAndSelect(row.getIndex());
                onRemove.run();
            });
            ContextMenu rowMenu = new ContextMenu(new MenuItem[]{add, edit, remove});
            row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)row.emptyProperty()).then((Object)null).otherwise((Object)rowMenu));
            row.setOnContextMenuRequested(e -> {
                if (!row.isEmpty()) {
                    table.getSelectionModel().clearAndSelect(row.getIndex());
                }
            });
            return row;
        });
        updateState.run();
    }

    private void configureImagePane() {
        if (this.tileImages != null) {
            this.tileImages.setPrefTileWidth(120.0);
            this.tileImages.setPrefTileHeight(90.0);
        }
        if (this.btnAddImage != null) {
            this.btnAddImage.setOnAction(e -> this.onAddImage());
            this.btnAddImage.setGraphic((Node)this.icon(this.icPlus, 14.0));
        }
        if (this.btnRemoveImage != null) {
            this.btnRemoveImage.setOnAction(e -> this.onRemoveImage());
            this.btnRemoveImage.setGraphic((Node)this.icon(this.icTrash, 14.0));
        }
        this.updateRemoveImageState();
    }

    private void configureD2Tools() {
        if (this.menuD2Tools != null) {
            MenuItem isXIsNot = new MenuItem("Is x Is Not", (Node)this.icon(this.icTable, 12.0));
            isXIsNot.setOnAction(e -> this.openIsXIsNotWindow());
            MenuItem diffAndChanges = new MenuItem("Diff & Changes", (Node)this.icon(this.icSearch, 12.0));
            diffAndChanges.setOnAction(e -> this.openDifferenceAndChangeAnalysisWindow());
            MenuItem events = new MenuItem("Events", (Node)this.icon(this.icPlus, 12.0));
            events.setOnAction(e -> this.openEventsWindow());
            this.menuD2Tools.getItems().setAll((Object[])new MenuItem[]{isXIsNot, diffAndChanges, events});
            if (this.menuD2Tools.getTooltip() == null) {
                this.menuD2Tools.setTooltip(new Tooltip("Open D2 tools menu"));
            }
        }
    }

    private void configureD3Tools() {
        if (this.menuD3Tools != null) {
            MenuItem containment = new MenuItem("Containment Window", (Node)this.icon(this.icTable, 12.0));
            containment.setOnAction(e -> this.openContainmentWindow());
            this.menuD3Tools.getItems().setAll((Object[])new MenuItem[]{containment});
            if (this.menuD3Tools.getTooltip() == null) {
                this.menuD3Tools.setTooltip(new Tooltip("Open D3 tools menu"));
            }
        }
    }

    private void configureD4Tools() {
        if (this.menuD4Tools != null) {
            MenuItem ishikawa = new MenuItem("Ishikawa", (Node)this.icon(this.icTable, 12.0));
            ishikawa.setOnAction(e -> this.openIshikawaWindow());
            MenuItem fiveWhys = new MenuItem("5-Why", (Node)this.icon(this.icSearch, 12.0));
            fiveWhys.setOnAction(e -> this.openFiveWhysWindow());
            this.menuD4Tools.getItems().setAll((Object[])new MenuItem[]{ishikawa, fiveWhys});
            if (this.menuD4Tools.getTooltip() == null) {
                this.menuD4Tools.setTooltip(new Tooltip("Open D4 tools menu"));
            }
        }
    }

    private void openIsXIsNotWindow() {
        if (this.report == null) {
            return;
        }
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/ToBeNotToBeWindow.fxml"));
            Parent ui = (Parent)loader.load();
            ToBeNotToBeWindowController controller = (ToBeNotToBeWindowController)loader.getController();
            Stage dialog = new Stage(StageStyle.DECORATED);
            controller.setOwnerStage(dialog);
            controller.setSaveAction(() -> this.performSave(false));
            controller.setDirtyHook(this::markDirty);
            controller.setEightD(this.report);
            dialog.setTitle("Is x Is Not");
            Stage owner = this.ownerStage;
            if (owner == null && this.root != null && this.root.getScene() != null) {
                owner = this.root.getScene().getWindow();
            }
            if (owner != null) {
                dialog.initOwner((Window)owner);
            }
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.setResizable(false);
            dialog.setScene(new Scene(ui));
            this.sizeDialogToContent(dialog, ui);
            dialog.showAndWait();
        }
        catch (IOException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Window error");
            alert.setHeaderText("Failed to open Is x Is Not");
            alert.setContentText(ex.getMessage());
            if (this.ownerStage != null) {
                alert.initOwner((Window)this.ownerStage);
            }
            alert.showAndWait();
        }
    }

    private void openDifferenceAndChangeAnalysisWindow() {
        if (this.report == null) {
            return;
        }
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/DifferenceAndChangeAnalysisWindow.fxml"));
            Parent ui = (Parent)loader.load();
            DifferenceAndChangeAnalysisWindowController controller = (DifferenceAndChangeAnalysisWindowController)loader.getController();
            Stage dialog = new Stage(StageStyle.DECORATED);
            controller.setOwnerStage(dialog);
            controller.setSaveAction(() -> this.performSave(false));
            controller.setDirtyHook(this::markDirty);
            controller.setEightD(this.report);
            dialog.setTitle("Difference and Change Analysis");
            Stage owner = this.ownerStage;
            if (owner == null && this.root != null && this.root.getScene() != null) {
                owner = this.root.getScene().getWindow();
            }
            if (owner != null) {
                dialog.initOwner((Window)owner);
            }
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.setResizable(false);
            dialog.setScene(new Scene(ui));
            this.sizeDialogToContent(dialog, ui);
            dialog.showAndWait();
        }
        catch (IOException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Window error");
            alert.setHeaderText("Failed to open Difference and Change Analysis");
            alert.setContentText(ex.getMessage());
            if (this.ownerStage != null) {
                alert.initOwner((Window)this.ownerStage);
            }
            alert.showAndWait();
        }
    }

    private void openEventsWindow() {
        if (this.report == null) {
            return;
        }
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/EventsWindow.fxml"));
            Parent ui = (Parent)loader.load();
            EventsWindowController controller = (EventsWindowController)loader.getController();
            Stage dialog = new Stage(StageStyle.DECORATED);
            controller.setOwnerStage(dialog);
            controller.setSaveAction(() -> this.performSave(false));
            controller.setDirtyHook(this::markDirty);
            controller.setEightD(this.report);
            dialog.setTitle("Events");
            Stage owner = this.ownerStage;
            if (owner == null && this.root != null && this.root.getScene() != null) {
                owner = this.root.getScene().getWindow();
            }
            if (owner != null) {
                dialog.initOwner((Window)owner);
            }
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.setResizable(false);
            dialog.setScene(new Scene(ui));
            this.sizeDialogToContent(dialog, ui);
            dialog.showAndWait();
        }
        catch (IOException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Window error");
            alert.setHeaderText("Failed to open Events");
            alert.setContentText(ex.getMessage());
            if (this.ownerStage != null) {
                alert.initOwner((Window)this.ownerStage);
            }
            alert.showAndWait();
        }
    }

    private void openIshikawaWindow() {
        if (this.report == null) {
            return;
        }
        this.commitPendingEdits();
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/IshikawaWindow.fxml"));
            Parent ui = (Parent)loader.load();
            IshikawaWindowController controller = (IshikawaWindowController)loader.getController();
            Stage dialog = new Stage(StageStyle.DECORATED);
            controller.setOwnerStage(dialog);
            controller.setSaveAction(() -> this.performSave(false));
            controller.setDirtyHook(this::markDirty);
            controller.setEightD(this.report);
            dialog.setTitle("Ishikawa");
            Stage owner = this.ownerStage;
            if (owner == null && this.root != null && this.root.getScene() != null) {
                owner = this.root.getScene().getWindow();
            }
            if (owner != null) {
                dialog.initOwner((Window)owner);
            }
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.setResizable(false);
            dialog.setScene(new Scene(ui));
            this.sizeDialogToContent(dialog, ui);
            dialog.showAndWait();
        }
        catch (IOException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Window error");
            alert.setHeaderText("Failed to open Ishikawa");
            alert.setContentText(ex.getMessage());
            if (this.ownerStage != null) {
                alert.initOwner((Window)this.ownerStage);
            }
            alert.showAndWait();
        }
    }

    private void openFiveWhysWindow() {
        if (this.report == null) {
            return;
        }
        this.commitPendingEdits();
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/FiveWhys.fxml"));
            Parent ui = (Parent)loader.load();
            FiveWhysWindowController controller = (FiveWhysWindowController)loader.getController();
            Stage dialog = new Stage(StageStyle.DECORATED);
            controller.setOwnerStage(dialog);
            controller.setSaveAction(() -> this.performSave(false));
            controller.setDirtyHook(this::markDirty);
            controller.setEightD(this.report);
            dialog.setTitle("5-Why");
            Stage owner = this.ownerStage;
            if (owner == null && this.root != null && this.root.getScene() != null) {
                owner = this.root.getScene().getWindow();
            }
            if (owner != null) {
                dialog.initOwner((Window)owner);
            }
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.setResizable(false);
            dialog.setScene(new Scene(ui));
            this.sizeDialogToContent(dialog, ui);
            dialog.showAndWait();
        }
        catch (IOException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Window error");
            alert.setHeaderText("Failed to open 5-Why");
            alert.setContentText(ex.getMessage());
            if (this.ownerStage != null) {
                alert.initOwner((Window)this.ownerStage);
            }
            alert.showAndWait();
        }
    }

    private void openContainmentWindow() {
        if (this.report == null) {
            return;
        }
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/ContainmentWindow.fxml"));
            Parent ui = (Parent)loader.load();
            ContainmentWindowController controller = (ContainmentWindowController)loader.getController();
            Stage dialog = new Stage(StageStyle.DECORATED);
            controller.setOwnerStage(dialog);
            controller.setSaveAction(() -> this.performSave(false));
            controller.setDirtyHook(this::markDirty);
            controller.setEightD(this.report);
            dialog.setTitle("Containment");
            Stage owner = this.ownerStage;
            if (owner == null && this.root != null && this.root.getScene() != null) {
                owner = this.root.getScene().getWindow();
            }
            if (owner != null) {
                dialog.initOwner((Window)owner);
            }
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.setResizable(false);
            dialog.setScene(new Scene(ui));
            this.sizeDialogToContent(dialog, ui);
            dialog.showAndWait();
        }
        catch (IOException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Window error");
            alert.setHeaderText("Failed to open Containment");
            alert.setContentText(ex.getMessage());
            if (this.ownerStage != null) {
                alert.initOwner((Window)this.ownerStage);
            }
            alert.showAndWait();
        }
    }

    private void sizeDialogToContent(Stage dialog, Parent content) {
        if (dialog == null || content == null) {
            return;
        }
        if (content instanceof Region) {
            Region region = (Region)content;
            double prefW = region.getPrefWidth();
            double prefH = region.getPrefHeight();
            if (prefW > 0.0) {
                dialog.setMinWidth(prefW);
            }
            if (prefH > 0.0) {
                dialog.setMinHeight(prefH);
            }
        }
        dialog.sizeToScene();
        dialog.centerOnScreen();
    }

    private void addTeamMember() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.report == null || this.report.getTeamMembers() == null) {
            return;
        }
        EightDTeamMember member = new EightDTeamMember();
        this.report.getTeamMembers().add((Object)member);
        if (this.tblTeamMembers != null) {
            int rowIndex = this.report.getTeamMembers().indexOf((Object)member);
            TableColumn<EightDTeamMember, ?> col = this.firstEditableTeamColumn();
            if (rowIndex >= 0) {
                if (col != null) {
                    this.tblTeamMembers.getSelectionModel().clearAndSelect(rowIndex, col);
                    if (this.tblTeamMembers.getFocusModel() != null) {
                        this.tblTeamMembers.getFocusModel().focus(rowIndex, col);
                    }
                    this.tblTeamMembers.edit(rowIndex, col);
                } else {
                    this.tblTeamMembers.getSelectionModel().select((Object)member);
                }
            } else {
                this.tblTeamMembers.getSelectionModel().select((Object)member);
            }
            this.tblTeamMembers.scrollTo((Object)member);
        }
        this.updateRemoveTeamMemberState();
        this.markDirty();
    }

    private void removeSelectedTeamMember() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.report == null || this.report.getTeamMembers() == null || this.tblTeamMembers == null) {
            return;
        }
        EightDTeamMember selected = (EightDTeamMember)this.tblTeamMembers.getSelectionModel().getSelectedItem();
        if (selected == null) {
            return;
        }
        this.report.getTeamMembers().remove((Object)selected);
        this.updateRemoveTeamMemberState();
        this.markDirty();
    }

    private void addContainmentAction() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.report == null || this.report.getContainmentActions() == null) {
            return;
        }
        EightDContainmentAction action = new EightDContainmentAction();
        this.report.getContainmentActions().add((Object)action);
        if (this.tblContainmentActions != null) {
            int rowIndex = this.report.getContainmentActions().indexOf((Object)action);
            TableColumn<EightDContainmentAction, ?> col = this.firstEditableContainmentColumn();
            if (rowIndex >= 0) {
                if (col != null) {
                    this.tblContainmentActions.getSelectionModel().clearAndSelect(rowIndex, col);
                    if (this.tblContainmentActions.getFocusModel() != null) {
                        this.tblContainmentActions.getFocusModel().focus(rowIndex, col);
                    }
                    this.tblContainmentActions.edit(rowIndex, col);
                } else {
                    this.tblContainmentActions.getSelectionModel().select((Object)action);
                }
            } else {
                this.tblContainmentActions.getSelectionModel().select((Object)action);
            }
            this.tblContainmentActions.scrollTo((Object)action);
        }
        this.updateRemoveContainmentActionState();
        this.markDirty();
    }

    private void removeSelectedContainmentAction() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.report == null || this.report.getContainmentActions() == null || this.tblContainmentActions == null) {
            return;
        }
        EightDContainmentAction selected = (EightDContainmentAction)this.tblContainmentActions.getSelectionModel().getSelectedItem();
        if (selected == null) {
            return;
        }
        this.report.getContainmentActions().remove((Object)selected);
        this.updateRemoveContainmentActionState();
        this.markDirty();
    }

    private void addD5CorrectiveAction() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.report == null || this.report.getCorrectiveActions() == null) {
            return;
        }
        EightDCorrectiveAction action = new EightDCorrectiveAction();
        this.report.getCorrectiveActions().add((Object)action);
        if (this.tblD5CorrectiveActions != null) {
            int rowIndex = this.report.getCorrectiveActions().indexOf((Object)action);
            TableColumn<EightDCorrectiveAction, ?> col = this.firstEditableD5CorrectiveColumn();
            if (rowIndex >= 0) {
                if (col != null) {
                    this.tblD5CorrectiveActions.getSelectionModel().clearAndSelect(rowIndex, col);
                    if (this.tblD5CorrectiveActions.getFocusModel() != null) {
                        this.tblD5CorrectiveActions.getFocusModel().focus(rowIndex, col);
                    }
                    this.tblD5CorrectiveActions.edit(rowIndex, col);
                } else {
                    this.tblD5CorrectiveActions.getSelectionModel().select((Object)action);
                }
            } else {
                this.tblD5CorrectiveActions.getSelectionModel().select((Object)action);
            }
            this.tblD5CorrectiveActions.scrollTo((Object)action);
        }
        this.updateRemoveD5CorrectiveActionState();
        this.markDirty();
    }

    private void removeSelectedD5CorrectiveAction() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.report == null || this.report.getCorrectiveActions() == null || this.tblD5CorrectiveActions == null) {
            return;
        }
        EightDCorrectiveAction selected = (EightDCorrectiveAction)this.tblD5CorrectiveActions.getSelectionModel().getSelectedItem();
        if (selected == null) {
            return;
        }
        this.report.getCorrectiveActions().remove((Object)selected);
        this.updateRemoveD5CorrectiveActionState();
        this.markDirty();
    }

    private void addD6Verification() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.report == null || this.report.getEffectivenessVerifications() == null) {
            return;
        }
        EightDEffectivenessVerification verification = new EightDEffectivenessVerification();
        this.report.getEffectivenessVerifications().add((Object)verification);
        if (this.tblD6EffectivenessVerifications != null) {
            int rowIndex = this.report.getEffectivenessVerifications().indexOf((Object)verification);
            TableColumn<EightDEffectivenessVerification, ?> col = this.firstEditableD6VerificationColumn();
            if (rowIndex >= 0) {
                if (col != null) {
                    this.tblD6EffectivenessVerifications.getSelectionModel().clearAndSelect(rowIndex, col);
                    if (this.tblD6EffectivenessVerifications.getFocusModel() != null) {
                        this.tblD6EffectivenessVerifications.getFocusModel().focus(rowIndex, col);
                    }
                    this.tblD6EffectivenessVerifications.edit(rowIndex, col);
                } else {
                    this.tblD6EffectivenessVerifications.getSelectionModel().select((Object)verification);
                }
            } else {
                this.tblD6EffectivenessVerifications.getSelectionModel().select((Object)verification);
            }
            this.tblD6EffectivenessVerifications.scrollTo((Object)verification);
        }
        this.updateRemoveD6VerificationState();
        this.markDirty();
    }

    private void removeSelectedD6Verification() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.report == null || this.report.getEffectivenessVerifications() == null || this.tblD6EffectivenessVerifications == null) {
            return;
        }
        EightDEffectivenessVerification selected = (EightDEffectivenessVerification)this.tblD6EffectivenessVerifications.getSelectionModel().getSelectedItem();
        if (selected == null) {
            return;
        }
        this.report.getEffectivenessVerifications().remove((Object)selected);
        this.updateRemoveD6VerificationState();
        this.markDirty();
    }

    private void addD7PreventiveAction() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.report == null || this.report.getPreventiveActions() == null) {
            return;
        }
        EightDPreventiveAction action = new EightDPreventiveAction();
        this.report.getPreventiveActions().add((Object)action);
        if (this.tblD7PreventiveActions != null) {
            int rowIndex = this.report.getPreventiveActions().indexOf((Object)action);
            TableColumn<EightDPreventiveAction, ?> col = this.firstEditableD7PreventiveActionColumn();
            if (rowIndex >= 0) {
                if (col != null) {
                    this.tblD7PreventiveActions.getSelectionModel().clearAndSelect(rowIndex, col);
                    if (this.tblD7PreventiveActions.getFocusModel() != null) {
                        this.tblD7PreventiveActions.getFocusModel().focus(rowIndex, col);
                    }
                    this.tblD7PreventiveActions.edit(rowIndex, col);
                } else {
                    this.tblD7PreventiveActions.getSelectionModel().select((Object)action);
                }
            } else {
                this.tblD7PreventiveActions.getSelectionModel().select((Object)action);
            }
            this.tblD7PreventiveActions.scrollTo((Object)action);
        }
        this.updateRemoveD7PreventiveActionState();
        this.markDirty();
    }

    private void removeSelectedD7PreventiveAction() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.report == null || this.report.getPreventiveActions() == null || this.tblD7PreventiveActions == null) {
            return;
        }
        EightDPreventiveAction selected = (EightDPreventiveAction)this.tblD7PreventiveActions.getSelectionModel().getSelectedItem();
        if (selected == null) {
            return;
        }
        this.report.getPreventiveActions().remove((Object)selected);
        this.updateRemoveD7PreventiveActionState();
        this.markDirty();
    }

    private void addD4MethodCause() {
        this.addStringEntry(this.report == null ? null : this.report.getPossibleCausesMethod(), this.tblD4MethodCauses, this.colD4MethodCause, this::updateRemoveD4MethodCauseState);
    }

    private void removeSelectedD4MethodCause() {
        this.removeSelectedStringEntry(this.report == null ? null : this.report.getPossibleCausesMethod(), this.tblD4MethodCauses, this::updateRemoveD4MethodCauseState);
    }

    private void startEditingSelectedD4MethodCause() {
        this.startEditingSelectedStringEntry(this.tblD4MethodCauses, this.colD4MethodCause);
    }

    private void addD4MachineCause() {
        this.addStringEntry(this.report == null ? null : this.report.getPossibleCausesMachine(), this.tblD4MachineCauses, this.colD4MachineCause, this::updateRemoveD4MachineCauseState);
    }

    private void removeSelectedD4MachineCause() {
        this.removeSelectedStringEntry(this.report == null ? null : this.report.getPossibleCausesMachine(), this.tblD4MachineCauses, this::updateRemoveD4MachineCauseState);
    }

    private void startEditingSelectedD4MachineCause() {
        this.startEditingSelectedStringEntry(this.tblD4MachineCauses, this.colD4MachineCause);
    }

    private void addD4MaterialCause() {
        this.addStringEntry(this.report == null ? null : this.report.getPossibleCausesMaterial(), this.tblD4MaterialCauses, this.colD4MaterialCause, this::updateRemoveD4MaterialCauseState);
    }

    private void removeSelectedD4MaterialCause() {
        this.removeSelectedStringEntry(this.report == null ? null : this.report.getPossibleCausesMaterial(), this.tblD4MaterialCauses, this::updateRemoveD4MaterialCauseState);
    }

    private void startEditingSelectedD4MaterialCause() {
        this.startEditingSelectedStringEntry(this.tblD4MaterialCauses, this.colD4MaterialCause);
    }

    private void addD4ManpowerCause() {
        this.addStringEntry(this.report == null ? null : this.report.getPossibleCausesManpower(), this.tblD4ManpowerCauses, this.colD4ManpowerCause, this::updateRemoveD4ManpowerCauseState);
    }

    private void removeSelectedD4ManpowerCause() {
        this.removeSelectedStringEntry(this.report == null ? null : this.report.getPossibleCausesManpower(), this.tblD4ManpowerCauses, this::updateRemoveD4ManpowerCauseState);
    }

    private void startEditingSelectedD4ManpowerCause() {
        this.startEditingSelectedStringEntry(this.tblD4ManpowerCauses, this.colD4ManpowerCause);
    }

    private void addStringEntry(ObservableList<String> items, TableView<String> table, TableColumn<String, ?> firstColumn, Runnable updateState) {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (items == null || table == null) {
            return;
        }
        items.add((Object)"");
        int rowIndex = items.size() - 1;
        if (rowIndex >= 0) {
            if (firstColumn != null) {
                table.getSelectionModel().clearAndSelect(rowIndex, firstColumn);
                if (table.getFocusModel() != null) {
                    table.getFocusModel().focus(rowIndex, firstColumn);
                }
                table.edit(rowIndex, firstColumn);
            } else {
                table.getSelectionModel().select(rowIndex);
            }
            table.scrollTo(rowIndex);
        }
        if (updateState != null) {
            updateState.run();
        }
        this.markDirty();
    }

    private void removeSelectedStringEntry(ObservableList<String> items, TableView<String> table, Runnable updateState) {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (items == null || table == null) {
            return;
        }
        int index = table.getSelectionModel().getSelectedIndex();
        if (index < 0 || index >= items.size()) {
            return;
        }
        items.remove(index);
        if (updateState != null) {
            updateState.run();
        }
        this.markDirty();
    }

    private void startEditingSelectedStringEntry(TableView<String> table, TableColumn<String, ?> column) {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (table == null || column == null) {
            return;
        }
        int rowIndex = table.getSelectionModel().getSelectedIndex();
        if (rowIndex < 0) {
            return;
        }
        table.requestFocus();
        table.getSelectionModel().clearAndSelect(rowIndex, column);
        if (table.getFocusModel() != null) {
            table.getFocusModel().focus(rowIndex, column);
        }
        table.edit(rowIndex, column);
    }

    private void onAddImage() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.report == null) {
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Add images");
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Images", new String[]{"*.png", "*.jpg", "*.jpeg", "*.gif", "*.bmp"})});
        Stage owner = this.ownerStage != null ? this.ownerStage : (this.root != null && this.root.getScene() != null ? this.root.getScene().getWindow() : null);
        List files = chooser.showOpenMultipleDialog((Window)owner);
        if (files == null || files.isEmpty()) {
            return;
        }
        boolean addedAny = false;
        String projectId = this.resolveProjectIdForStorage();
        for (File file : files) {
            if (file == null || !file.isFile()) continue;
            try {
                boolean exists;
                String persistedIdentifier = EightDImageStorage.storeCopy(projectId, file);
                if (persistedIdentifier == null || persistedIdentifier.isBlank() || (exists = this.report.getImages().stream().anyMatch(img -> persistedIdentifier.equalsIgnoreCase(img.getPath())))) continue;
                this.report.getImages().add((Object)new EightDImage(persistedIdentifier));
                addedAny = true;
            }
            catch (IOException ex) {
                this.showImageCopyError(file, ex);
            }
        }
        if (addedAny) {
            this.markDirty();
        }
    }

    private String resolveProjectIdForStorage() {
        if (this.projectIdProvider == null) {
            return null;
        }
        try {
            return this.projectIdProvider.get();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void showImageCopyError(File file, Exception ex) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Image add error");
        alert.setHeaderText("Failed to copy image");
        String source = file == null ? "<unknown>" : file.getAbsolutePath();
        String message = ex == null ? "Unknown error." : ex.getMessage();
        alert.setContentText("Source: " + source + "\nReason: " + message);
        if (this.ownerStage != null) {
            alert.initOwner((Window)this.ownerStage);
        }
        alert.showAndWait();
    }

    private void onRemoveImage() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.report == null || this.selectedImage == null) {
            return;
        }
        String persistedIdentifier = this.selectedImage.getPath();
        this.report.getImages().remove((Object)this.selectedImage);
        this.deleteManagedImageIfUnreferenced(persistedIdentifier);
        this.markDirty();
    }

    private void deleteManagedImageIfUnreferenced(String persistedIdentifier) {
        if (!EightDImageStorage.isManagedIdentifier(persistedIdentifier)) {
            return;
        }
        if (!this.canCheckOtherEightDReferences()) {
            return;
        }
        if (this.isImageStillReferenced(persistedIdentifier)) {
            return;
        }
        EightDImageStorage.deleteManagedFile(persistedIdentifier);
    }

    private boolean canCheckOtherEightDReferences() {
        return this.eightDReportsProvider != null;
    }

    private boolean isImageStillReferenced(String persistedIdentifier) {
        List<EightD> reports;
        if (persistedIdentifier == null || persistedIdentifier.isBlank()) {
            return false;
        }
        try {
            reports = this.eightDReportsProvider.get();
        }
        catch (Exception ex) {
            return true;
        }
        if (reports == null || reports.isEmpty()) {
            return false;
        }
        for (EightD candidate : reports) {
            if (candidate == null || candidate.getImages() == null) continue;
            for (EightDImage image : candidate.getImages()) {
                if (image == null || image.getPath() == null || !persistedIdentifier.equalsIgnoreCase(image.getPath())) continue;
                return true;
            }
        }
        return false;
    }

    private void refreshImageTiles() {
        if (this.tileImages == null) {
            return;
        }
        this.tileImages.getChildren().clear();
        this.imageTiles.clear();
        if (this.report == null || this.report.getImages() == null || this.report.getImages().isEmpty()) {
            this.selectImage(null);
            this.updateRemoveImageState();
            return;
        }
        for (EightDImage image : this.report.getImages()) {
            StackPane tile = this.buildImageTile(image);
            this.imageTiles.put(image, tile);
            this.tileImages.getChildren().add((Object)tile);
        }
        if (this.selectedImage != null && this.imageTiles.containsKey(this.selectedImage)) {
            this.applySelectionStyles();
            this.updateSelectedImageView();
        } else {
            this.selectImage((EightDImage)this.report.getImages().get(0));
        }
    }

    private StackPane buildImageTile(EightDImage image) {
        StackPane tile = new StackPane();
        tile.setPrefSize(120.0, 90.0);
        tile.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        tile.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        tile.setStyle("-fx-border-color: transparent; -fx-border-width: 2; -fx-padding: 2; -fx-background-color: #f6f6f6;");
        Node content = this.buildImagePreviewNode(image);
        if (content != null) {
            tile.getChildren().add((Object)content);
        }
        tile.setOnMouseClicked(evt -> this.selectImage(image));
        return tile;
    }

    private Node buildImagePreviewNode(EightDImage image) {
        if (image == null) {
            return new Label("No image");
        }
        String path = image.getPath();
        if (path == null || path.isBlank()) {
            return new Label("No image");
        }
        File file = EightDImageStorage.resolveStoredFile(path);
        if (file == null || !file.exists()) {
            return new Label("Missing");
        }
        try {
            Image img = new Image(file.toURI().toString(), 120.0, 90.0, true, true, true);
            if (img.isError()) {
                return new Label("Invalid");
            }
            ImageView view = new ImageView(img);
            view.setPreserveRatio(true);
            view.setFitWidth(110.0);
            view.setFitHeight(80.0);
            view.setSmooth(true);
            return view;
        }
        catch (Exception ex) {
            return new Label("Invalid");
        }
    }

    private void selectImage(EightDImage image) {
        this.selectedImage = image;
        this.applySelectionStyles();
        this.updateSelectedImageView();
        this.updateRemoveImageState();
    }

    private void applySelectionStyles() {
        for (Map.Entry<EightDImage, StackPane> entry : this.imageTiles.entrySet()) {
            boolean selected;
            boolean bl = selected = entry.getKey() != null && entry.getKey().equals(this.selectedImage);
            StackPane tile = entry.getValue();
            if (tile == null) continue;
            if (selected) {
                tile.setStyle("-fx-border-color: #2a74f5; -fx-border-width: 2; -fx-padding: 2; -fx-background-color: #f6f6f6;");
                continue;
            }
            tile.setStyle("-fx-border-color: transparent; -fx-border-width: 2; -fx-padding: 2; -fx-background-color: #f6f6f6;");
        }
    }

    private void updateSelectedImageView() {
        if (this.imgSelected == null) {
            return;
        }
        if (this.selectedImage == null) {
            this.imgSelected.setImage(null);
            return;
        }
        String path = this.selectedImage.getPath();
        if (path == null || path.isBlank()) {
            this.imgSelected.setImage(null);
            return;
        }
        File file = EightDImageStorage.resolveStoredFile(path);
        if (file == null || !file.exists()) {
            this.imgSelected.setImage(null);
            return;
        }
        try {
            Image image = new Image(file.toURI().toString());
            this.imgSelected.setImage(image.isError() ? null : image);
        }
        catch (Exception ex) {
            this.imgSelected.setImage(null);
        }
    }

    private void updateRemoveImageState() {
        if (this.btnRemoveImage != null) {
            this.btnRemoveImage.setDisable(this.selectedImage == null);
        }
    }

    private void stringColumn(TableColumn<EightDTeamMember, String> col, Function<EightDTeamMember, StringProperty> prop) {
        if (col == null || prop == null) {
            return;
        }
        col.setEditable(true);
        col.setCellValueFactory(c -> (ObservableValue)prop.apply((EightDTeamMember)c.getValue()));
        col.setCellFactory(TextFieldTableCell.forTableColumn());
        col.setOnEditCommit(e -> {
            EightDTeamMember row = (EightDTeamMember)e.getRowValue();
            if (row != null) {
                String newValue = e.getNewValue() == null ? "" : (String)e.getNewValue();
                ((StringProperty)prop.apply(row)).set((Object)newValue);
            }
            this.markDirty();
        });
    }

    private void containmentStringColumn(TableColumn<EightDContainmentAction, String> col, Function<EightDContainmentAction, StringProperty> prop) {
        if (col == null || prop == null) {
            return;
        }
        col.setEditable(true);
        col.setCellValueFactory(c -> (ObservableValue)prop.apply((EightDContainmentAction)c.getValue()));
        col.setCellFactory(TextFieldTableCell.forTableColumn());
        col.setOnEditCommit(e -> {
            EightDContainmentAction row = (EightDContainmentAction)e.getRowValue();
            if (row != null) {
                String newValue = e.getNewValue() == null ? "" : (String)e.getNewValue();
                ((StringProperty)prop.apply(row)).set((Object)newValue);
            }
            this.markDirty();
        });
    }

    private void containmentDateColumn(TableColumn<EightDContainmentAction, LocalDate> col, Function<EightDContainmentAction, ObjectProperty<LocalDate>> prop) {
        if (col == null || prop == null) {
            return;
        }
        col.setEditable(true);
        col.setCellValueFactory(c -> (ObservableValue)prop.apply((EightDContainmentAction)c.getValue()));
        col.setCellFactory(c -> new LocalDatePickerTableCell(this));
        col.setOnEditCommit(e -> {
            EightDContainmentAction row = (EightDContainmentAction)e.getRowValue();
            if (row != null) {
                ((ObjectProperty)prop.apply(row)).set((Object)((LocalDate)e.getNewValue()));
            }
            this.markDirty();
        });
    }

    private void correctiveStringColumn(TableColumn<EightDCorrectiveAction, String> col, Function<EightDCorrectiveAction, StringProperty> prop) {
        if (col == null || prop == null) {
            return;
        }
        col.setEditable(true);
        col.setCellValueFactory(c -> (ObservableValue)prop.apply((EightDCorrectiveAction)c.getValue()));
        col.setCellFactory(TextFieldTableCell.forTableColumn());
        col.setOnEditCommit(e -> {
            EightDCorrectiveAction row = (EightDCorrectiveAction)e.getRowValue();
            if (row != null) {
                String newValue = e.getNewValue() == null ? "" : (String)e.getNewValue();
                ((StringProperty)prop.apply(row)).set((Object)newValue);
            }
            this.markDirty();
        });
    }

    private void correctiveDateColumn(TableColumn<EightDCorrectiveAction, LocalDate> col, Function<EightDCorrectiveAction, ObjectProperty<LocalDate>> prop) {
        if (col == null || prop == null) {
            return;
        }
        col.setEditable(true);
        col.setCellValueFactory(c -> (ObservableValue)prop.apply((EightDCorrectiveAction)c.getValue()));
        col.setCellFactory(c -> new LocalDatePickerTableCell(this));
        col.setOnEditCommit(e -> {
            EightDCorrectiveAction row = (EightDCorrectiveAction)e.getRowValue();
            if (row != null) {
                ((ObjectProperty)prop.apply(row)).set((Object)((LocalDate)e.getNewValue()));
            }
            this.markDirty();
        });
    }

    private void d6StringColumn(TableColumn<EightDEffectivenessVerification, String> col, Function<EightDEffectivenessVerification, StringProperty> prop) {
        if (col == null || prop == null) {
            return;
        }
        col.setEditable(true);
        col.setCellValueFactory(c -> (ObservableValue)prop.apply((EightDEffectivenessVerification)c.getValue()));
        col.setCellFactory(TextFieldTableCell.forTableColumn());
        col.setOnEditCommit(e -> {
            EightDEffectivenessVerification row = (EightDEffectivenessVerification)e.getRowValue();
            if (row != null) {
                String newValue = e.getNewValue() == null ? "" : (String)e.getNewValue();
                ((StringProperty)prop.apply(row)).set((Object)newValue);
            }
            this.markDirty();
        });
    }

    private void d6DateColumn(TableColumn<EightDEffectivenessVerification, LocalDate> col, Function<EightDEffectivenessVerification, ObjectProperty<LocalDate>> prop) {
        if (col == null || prop == null) {
            return;
        }
        col.setEditable(true);
        col.setCellValueFactory(c -> (ObservableValue)prop.apply((EightDEffectivenessVerification)c.getValue()));
        col.setCellFactory(c -> new LocalDatePickerTableCell(this));
        col.setOnEditCommit(e -> {
            EightDEffectivenessVerification row = (EightDEffectivenessVerification)e.getRowValue();
            if (row != null) {
                ((ObjectProperty)prop.apply(row)).set((Object)((LocalDate)e.getNewValue()));
            }
            this.markDirty();
        });
    }

    private void d7StringColumn(TableColumn<EightDPreventiveAction, String> col, Function<EightDPreventiveAction, StringProperty> prop) {
        if (col == null || prop == null) {
            return;
        }
        col.setEditable(true);
        col.setCellValueFactory(c -> (ObservableValue)prop.apply((EightDPreventiveAction)c.getValue()));
        col.setCellFactory(TextFieldTableCell.forTableColumn());
        col.setOnEditCommit(e -> {
            EightDPreventiveAction row = (EightDPreventiveAction)e.getRowValue();
            if (row != null) {
                String newValue = e.getNewValue() == null ? "" : (String)e.getNewValue();
                ((StringProperty)prop.apply(row)).set((Object)newValue);
            }
            this.markDirty();
        });
    }

    private void d7DateColumn(TableColumn<EightDPreventiveAction, LocalDate> col, Function<EightDPreventiveAction, ObjectProperty<LocalDate>> prop) {
        if (col == null || prop == null) {
            return;
        }
        col.setEditable(true);
        col.setCellValueFactory(c -> (ObservableValue)prop.apply((EightDPreventiveAction)c.getValue()));
        col.setCellFactory(c -> new LocalDatePickerTableCell(this));
        col.setOnEditCommit(e -> {
            EightDPreventiveAction row = (EightDPreventiveAction)e.getRowValue();
            if (row != null) {
                ((ObjectProperty)prop.apply(row)).set((Object)((LocalDate)e.getNewValue()));
            }
            this.markDirty();
        });
    }

    private void startEditingSelectedTeamMember() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.tblTeamMembers == null) {
            return;
        }
        int rowIndex = this.tblTeamMembers.getSelectionModel().getSelectedIndex();
        if (rowIndex < 0) {
            return;
        }
        TableColumn<EightDTeamMember, ?> col = this.firstEditableTeamColumn();
        if (col == null) {
            return;
        }
        this.tblTeamMembers.requestFocus();
        this.tblTeamMembers.getSelectionModel().clearAndSelect(rowIndex, col);
        if (this.tblTeamMembers.getFocusModel() != null) {
            this.tblTeamMembers.getFocusModel().focus(rowIndex, col);
        }
        this.tblTeamMembers.edit(rowIndex, col);
    }

    private void startEditingSelectedContainmentAction() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.tblContainmentActions == null) {
            return;
        }
        int rowIndex = this.tblContainmentActions.getSelectionModel().getSelectedIndex();
        if (rowIndex < 0) {
            return;
        }
        TableColumn<EightDContainmentAction, ?> col = this.firstEditableContainmentColumn();
        if (col == null) {
            return;
        }
        this.tblContainmentActions.requestFocus();
        this.tblContainmentActions.getSelectionModel().clearAndSelect(rowIndex, col);
        if (this.tblContainmentActions.getFocusModel() != null) {
            this.tblContainmentActions.getFocusModel().focus(rowIndex, col);
        }
        this.tblContainmentActions.edit(rowIndex, col);
    }

    private void startEditingSelectedD5CorrectiveAction() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.tblD5CorrectiveActions == null) {
            return;
        }
        int rowIndex = this.tblD5CorrectiveActions.getSelectionModel().getSelectedIndex();
        if (rowIndex < 0) {
            return;
        }
        TableColumn<EightDCorrectiveAction, ?> col = this.firstEditableD5CorrectiveColumn();
        if (col == null) {
            return;
        }
        this.tblD5CorrectiveActions.requestFocus();
        this.tblD5CorrectiveActions.getSelectionModel().clearAndSelect(rowIndex, col);
        if (this.tblD5CorrectiveActions.getFocusModel() != null) {
            this.tblD5CorrectiveActions.getFocusModel().focus(rowIndex, col);
        }
        this.tblD5CorrectiveActions.edit(rowIndex, col);
    }

    private void startEditingSelectedD6Verification() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.tblD6EffectivenessVerifications == null) {
            return;
        }
        int rowIndex = this.tblD6EffectivenessVerifications.getSelectionModel().getSelectedIndex();
        if (rowIndex < 0) {
            return;
        }
        TableColumn<EightDEffectivenessVerification, ?> col = this.firstEditableD6VerificationColumn();
        if (col == null) {
            return;
        }
        this.tblD6EffectivenessVerifications.requestFocus();
        this.tblD6EffectivenessVerifications.getSelectionModel().clearAndSelect(rowIndex, col);
        if (this.tblD6EffectivenessVerifications.getFocusModel() != null) {
            this.tblD6EffectivenessVerifications.getFocusModel().focus(rowIndex, col);
        }
        this.tblD6EffectivenessVerifications.edit(rowIndex, col);
    }

    private void startEditingSelectedD7PreventiveAction() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.tblD7PreventiveActions == null) {
            return;
        }
        int rowIndex = this.tblD7PreventiveActions.getSelectionModel().getSelectedIndex();
        if (rowIndex < 0) {
            return;
        }
        TableColumn<EightDPreventiveAction, ?> col = this.firstEditableD7PreventiveActionColumn();
        if (col == null) {
            return;
        }
        this.tblD7PreventiveActions.requestFocus();
        this.tblD7PreventiveActions.getSelectionModel().clearAndSelect(rowIndex, col);
        if (this.tblD7PreventiveActions.getFocusModel() != null) {
            this.tblD7PreventiveActions.getFocusModel().focus(rowIndex, col);
        }
        this.tblD7PreventiveActions.edit(rowIndex, col);
    }

    private TableColumn<EightDTeamMember, ?> firstEditableTeamColumn() {
        if (this.colTeamName != null && this.colTeamName.isEditable()) {
            return this.colTeamName;
        }
        if (this.tblTeamMembers == null) {
            return null;
        }
        for (TableColumn col : this.tblTeamMembers.getColumns()) {
            if (col == null || !col.isEditable()) continue;
            return col;
        }
        return null;
    }

    private TableColumn<EightDContainmentAction, ?> firstEditableContainmentColumn() {
        if (this.colContainmentAction != null && this.colContainmentAction.isEditable()) {
            return this.colContainmentAction;
        }
        if (this.colContainmentResponsiblePerson != null && this.colContainmentResponsiblePerson.isEditable()) {
            return this.colContainmentResponsiblePerson;
        }
        if (this.colContainmentTargetDate != null && this.colContainmentTargetDate.isEditable()) {
            return this.colContainmentTargetDate;
        }
        if (this.colContainmentImplementationDate != null && this.colContainmentImplementationDate.isEditable()) {
            return this.colContainmentImplementationDate;
        }
        if (this.colContainmentMethod != null && this.colContainmentMethod.isEditable()) {
            return this.colContainmentMethod;
        }
        if (this.colContainmentQtyContained != null && this.colContainmentQtyContained.isEditable()) {
            return this.colContainmentQtyContained;
        }
        if (this.colContainmentQtyRejected != null && this.colContainmentQtyRejected.isEditable()) {
            return this.colContainmentQtyRejected;
        }
        return null;
    }

    private TableColumn<EightDCorrectiveAction, ?> firstEditableD5CorrectiveColumn() {
        if (this.colD5CorrectiveAction != null && this.colD5CorrectiveAction.isEditable()) {
            return this.colD5CorrectiveAction;
        }
        if (this.colD5ResponsiblePerson != null && this.colD5ResponsiblePerson.isEditable()) {
            return this.colD5ResponsiblePerson;
        }
        if (this.colD5TargetDate != null && this.colD5TargetDate.isEditable()) {
            return this.colD5TargetDate;
        }
        if (this.colD5ImplementationDate != null && this.colD5ImplementationDate.isEditable()) {
            return this.colD5ImplementationDate;
        }
        return null;
    }

    private TableColumn<EightDEffectivenessVerification, ?> firstEditableD6VerificationColumn() {
        if (this.colD6Method != null && this.colD6Method.isEditable()) {
            return this.colD6Method;
        }
        if (this.colD6Result != null && this.colD6Result.isEditable()) {
            return this.colD6Result;
        }
        if (this.colD6Date != null && this.colD6Date.isEditable()) {
            return this.colD6Date;
        }
        return null;
    }

    private TableColumn<EightDPreventiveAction, ?> firstEditableD7PreventiveActionColumn() {
        if (this.colD7Product != null && this.colD7Product.isEditable()) {
            return this.colD7Product;
        }
        if (this.colD7Lines != null && this.colD7Lines.isEditable()) {
            return this.colD7Lines;
        }
        if (this.colD7ResponsiblePerson != null && this.colD7ResponsiblePerson.isEditable()) {
            return this.colD7ResponsiblePerson;
        }
        if (this.colD7TargetDate != null && this.colD7TargetDate.isEditable()) {
            return this.colD7TargetDate;
        }
        if (this.colD7ImplementationDate != null && this.colD7ImplementationDate.isEditable()) {
            return this.colD7ImplementationDate;
        }
        if (this.colD7VerificationMethod != null && this.colD7VerificationMethod.isEditable()) {
            return this.colD7VerificationMethod;
        }
        if (this.colD7VerificationResult != null && this.colD7VerificationResult.isEditable()) {
            return this.colD7VerificationResult;
        }
        if (this.colD7VerificationDate != null && this.colD7VerificationDate.isEditable()) {
            return this.colD7VerificationDate;
        }
        return null;
    }

    private void updateRemoveTeamMemberState() {
        if (this.btnDeleteTeamMember == null) {
            return;
        }
        boolean disabled = this.report == null || this.tblTeamMembers == null || this.tblTeamMembers.getSelectionModel() == null || this.tblTeamMembers.getSelectionModel().getSelectedItem() == null;
        this.btnDeleteTeamMember.setDisable(disabled);
    }

    private void updateRemoveContainmentActionState() {
        if (this.btnDeleteContainmentAction == null) {
            return;
        }
        boolean disabled = this.report == null || this.tblContainmentActions == null || this.tblContainmentActions.getSelectionModel() == null || this.tblContainmentActions.getSelectionModel().getSelectedItem() == null;
        this.btnDeleteContainmentAction.setDisable(disabled);
    }

    private void updateRemoveD5CorrectiveActionState() {
        if (this.btnDeleteD5CorrectiveAction == null) {
            return;
        }
        boolean disabled = this.report == null || this.tblD5CorrectiveActions == null || this.tblD5CorrectiveActions.getSelectionModel() == null || this.tblD5CorrectiveActions.getSelectionModel().getSelectedItem() == null;
        this.btnDeleteD5CorrectiveAction.setDisable(disabled);
    }

    private void updateRemoveD6VerificationState() {
        if (this.btnDeleteD6Verification == null) {
            return;
        }
        boolean disabled = this.report == null || this.tblD6EffectivenessVerifications == null || this.tblD6EffectivenessVerifications.getSelectionModel() == null || this.tblD6EffectivenessVerifications.getSelectionModel().getSelectedItem() == null;
        this.btnDeleteD6Verification.setDisable(disabled);
    }

    private void updateRemoveD7PreventiveActionState() {
        if (this.btnDeleteD7PreventiveAction == null) {
            return;
        }
        boolean disabled = this.report == null || this.tblD7PreventiveActions == null || this.tblD7PreventiveActions.getSelectionModel() == null || this.tblD7PreventiveActions.getSelectionModel().getSelectedItem() == null;
        this.btnDeleteD7PreventiveAction.setDisable(disabled);
    }

    private void updateRemoveD4MethodCauseState() {
        this.updateDeleteButtonState(this.btnDeleteD4MethodCause, this.tblD4MethodCauses);
    }

    private void updateRemoveD4MachineCauseState() {
        this.updateDeleteButtonState(this.btnDeleteD4MachineCause, this.tblD4MachineCauses);
    }

    private void updateRemoveD4MaterialCauseState() {
        this.updateDeleteButtonState(this.btnDeleteD4MaterialCause, this.tblD4MaterialCauses);
    }

    private void updateRemoveD4ManpowerCauseState() {
        this.updateDeleteButtonState(this.btnDeleteD4ManpowerCause, this.tblD4ManpowerCauses);
    }

    private void updateDeleteButtonState(Button button, TableView<String> table) {
        if (button == null) {
            return;
        }
        boolean disabled = this.report == null || table == null || table.getSelectionModel() == null || table.getSelectionModel().getSelectedIndex() < 0;
        button.setDisable(disabled);
    }

    private String formatDate(LocalDate value) {
        return value == null ? "" : value.toString();
    }

    private void onSaveOnly() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.performSave(false);
    }

    private void onSaveAndExit() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.performSave(true);
    }

    private void onExportReport() {
        if (this.report == null) {
            this.showExportError("No 8D report loaded.");
            return;
        }
        this.commitPendingEdits();
        EightDExportOptions options = this.promptExportOptions().orElse(null);
        if (options == null) {
            return;
        }
        if (!options.includesAnyStage()) {
            this.showExportError("Select at least one 8D stage to export.");
            return;
        }
        File target = this.promptExportTargetPdf();
        if (target == null) {
            return;
        }
        Path logoPath = ExportLogoPreferences.getRememberedLogoPath().orElse(null);
        try {
            EightDPdfGenerator.export(this.report, options, target.toPath(), logoPath);
            this.showExportInfo("PDF exported successfully:\n" + target.getAbsolutePath());
        }
        catch (IOException | DocumentException ex) {
            String message = ex.getMessage();
            this.showExportError("Failed to export PDF: " + (message == null || message.isBlank() ? ex.getClass().getSimpleName() : message));
        }
    }

    private Optional<EightDExportOptions> promptExportOptions() {
        Dialog dialog = new Dialog();
        dialog.setTitle("Export 8D");
        dialog.setHeaderText("Select stages and auxiliary tools to include");
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        CheckBox chkD1 = new CheckBox("D1 Team Members");
        CheckBox chkD2 = new CheckBox("D2 Problem Description");
        CheckBox chkD3 = new CheckBox("D3 Containment Actions");
        CheckBox chkD4 = new CheckBox("D4 Possible Causes");
        CheckBox chkD5 = new CheckBox("D5 Corrective Actions");
        CheckBox chkD6 = new CheckBox("D6 Effectiveness Verification");
        CheckBox chkD7 = new CheckBox("D7 Preventive Actions");
        CheckBox chkD8 = new CheckBox("D8 Review and Approvals");
        List<CheckBox> stageChecks = List.of(chkD1, chkD2, chkD3, chkD4, chkD5, chkD6, chkD7, chkD8);
        for (CheckBox checkBox : stageChecks) {
            checkBox.setSelected(true);
        }
        CheckBox chkD2IsNot = new CheckBox("D2 tool: Is x Is Not");
        CheckBox chkD2Diff = new CheckBox("D2 tool: Diff & Changes");
        CheckBox chkD2Events = new CheckBox("D2 tool: Events");
        CheckBox chkD3ContainmentTool = new CheckBox("D3 tool: Containment Window");
        CheckBox chkD4Ishikawa = new CheckBox("D4 tool: Ishikawa");
        CheckBox chkD4FiveWhys = new CheckBox("D4 tool: 5-Why");
        List<CheckBox> toolChecks = List.of(chkD2IsNot, chkD2Diff, chkD2Events, chkD3ContainmentTool, chkD4Ishikawa, chkD4FiveWhys);
        for (CheckBox checkBox : toolChecks) {
            checkBox.setSelected(true);
        }
        GridPane content = new GridPane();
        content.setHgap(18.0);
        content.setVgap(6.0);
        content.setPadding(new Insets(6.0, 10.0, 2.0, 12.0));
        content.add((Node)new Label("Stages"), 0, 0);
        content.add((Node)new Label("Auxiliary tools"), 1, 0);
        content.add((Node)chkD1, 0, 1);
        content.add((Node)chkD2, 0, 2);
        content.add((Node)chkD3, 0, 3);
        content.add((Node)chkD4, 0, 4);
        content.add((Node)chkD5, 0, 5);
        content.add((Node)chkD6, 0, 6);
        content.add((Node)chkD7, 0, 7);
        content.add((Node)chkD8, 0, 8);
        content.add((Node)chkD2IsNot, 1, 2);
        content.add((Node)chkD2Diff, 1, 3);
        content.add((Node)chkD2Events, 1, 4);
        content.add((Node)chkD3ContainmentTool, 1, 5);
        content.add((Node)chkD4Ishikawa, 1, 6);
        content.add((Node)chkD4FiveWhys, 1, 7);
        dialog.getDialogPane().setContent((Node)content);
        Button okButton = (Button)dialog.getDialogPane().lookupButton(ButtonType.OK);
        Runnable refreshState = () -> {
            boolean anyStage = false;
            for (CheckBox cb : stageChecks) {
                if (!cb.isSelected()) continue;
                anyStage = true;
                break;
            }
            boolean d2 = chkD2.isSelected();
            boolean d3 = chkD3.isSelected();
            boolean d4 = chkD4.isSelected();
            chkD2IsNot.setDisable(!d2);
            chkD2Diff.setDisable(!d2);
            chkD2Events.setDisable(!d2);
            chkD3ContainmentTool.setDisable(!d3);
            chkD4Ishikawa.setDisable(!d4);
            chkD4FiveWhys.setDisable(!d4);
            if (!d2) {
                chkD2IsNot.setSelected(false);
                chkD2Diff.setSelected(false);
                chkD2Events.setSelected(false);
            }
            if (!d3) {
                chkD3ContainmentTool.setSelected(false);
            }
            if (!d4) {
                chkD4Ishikawa.setSelected(false);
                chkD4FiveWhys.setSelected(false);
            }
            okButton.setDisable(!anyStage);
        };
        for (CheckBox cb : stageChecks) {
            cb.selectedProperty().addListener((obs, oldV, newV) -> refreshState.run());
        }
        refreshState.run();
        Window owner = this.resolveWindow();
        if (owner != null) {
            dialog.initOwner(owner);
        }
        dialog.setResultConverter(btn -> {
            if (btn != ButtonType.OK) {
                return null;
            }
            return new EightDExportOptions(chkD1.isSelected(), chkD2.isSelected(), chkD3.isSelected(), chkD4.isSelected(), chkD5.isSelected(), chkD6.isSelected(), chkD7.isSelected(), chkD8.isSelected(), chkD2IsNot.isSelected(), chkD2Diff.isSelected(), chkD2Events.isSelected(), chkD3ContainmentTool.isSelected(), chkD4Ishikawa.isSelected(), chkD4FiveWhys.isSelected());
        });
        return dialog.showAndWait();
    }

    private File promptExportTargetPdf() {
        File selected;
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Export 8D report to PDF");
        String extension = "pdf";
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("PDF (*." + extension + ")", new String[]{"*." + extension});
        chooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{filter});
        chooser.setSelectedExtensionFilter(filter);
        File preferredDir = this.preferredExportDirectory();
        if (preferredDir != null && preferredDir.isDirectory()) {
            chooser.setInitialDirectory(preferredDir);
        }
        chooser.setInitialFileName(this.defaultExportFileName(extension));
        Window owner = this.resolveWindow();
        File file = selected = owner != null ? chooser.showSaveDialog(owner) : chooser.showSaveDialog(null);
        if (selected == null) {
            return null;
        }
        try {
            File target = this.normalizeExportTarget(selected, extension, preferredDir);
            this.rememberExportDirectory(target.getParentFile());
            return target;
        }
        catch (IOException ex) {
            this.showExportError("Failed to prepare export destination: " + ex.getMessage());
            return null;
        }
    }

    private File normalizeExportTarget(File selected, String extension, File baseDirectory) throws IOException {
        String lower;
        Path path = this.expandTilde(selected.toPath());
        if (!path.isAbsolute()) {
            Path base = baseDirectory != null ? baseDirectory.toPath() : this.preferredExportDirectory().toPath();
            path = base.resolve(path).normalize();
        } else {
            path = path.normalize();
        }
        Path parent = path.getParent();
        if (parent == null) {
            parent = this.preferredExportDirectory().toPath();
        }
        Files.createDirectories(parent, new FileAttribute[0]);
        String string = lower = path.getFileName() == null ? "" : path.getFileName().toString().toLowerCase();
        if (!lower.endsWith("." + extension.toLowerCase())) {
            String name = path.getFileName() == null || path.getFileName().toString().isBlank() ? this.defaultExportFileName(extension) : path.getFileName().toString() + "." + extension;
            path = parent.resolve(name).normalize();
        }
        if (!Files.isWritable(parent)) {
            throw new IOException("Destination folder is not writable: " + String.valueOf(parent));
        }
        return path.toFile();
    }

    private Path expandTilde(Path path) {
        if (path == null) {
            return Paths.get(System.getProperty("user.home", "."), new String[0]);
        }
        String raw = path.toString();
        if (raw.equals("~")) {
            return Paths.get(System.getProperty("user.home", "."), new String[0]);
        }
        String marker = "~" + File.separator;
        if (raw.startsWith(marker)) {
            return Paths.get(System.getProperty("user.home", "."), new String[0]).resolve(raw.substring(marker.length()));
        }
        return path;
    }

    private File preferredExportDirectory() {
        return ExportDirectoryPreferences.getLastExportDirectory();
    }

    private void rememberExportDirectory(File directory) {
        ExportDirectoryPreferences.rememberExportDirectory(directory);
    }

    private String defaultExportFileName(String extension) {
        String baseName = this.firstNonBlank(this.safeFileSegment(this.report == null ? null : this.report.getInternalClaimNumber()), this.safeFileSegment(this.report == null ? null : this.report.getCustomerClaimNumber()), this.safeFileSegment(this.report == null ? null : this.report.getPartNumber()), "8D_Report");
        return ExportFileNameUtil.suggestedName(baseName, "8D_Report", extension);
    }

    private String safeFileSegment(String value) {
        if (value == null) {
            return "";
        }
        String trimmed = value.trim();
        if (trimmed.isEmpty()) {
            return "";
        }
        String normalized = trimmed.replaceAll("[\\\\/:*?\"<>|]+", " ").replaceAll("\\s+", "_");
        return normalized.isBlank() ? "" : normalized;
    }

    private String firstNonBlank(String ... values) {
        if (values == null) {
            return "";
        }
        for (String value : values) {
            if (value == null || value.isBlank()) continue;
            return value;
        }
        return "";
    }

    private void showExportInfo(String message) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("Export");
        alert.setHeaderText(null);
        alert.setContentText(message);
        Window owner = this.resolveWindow();
        if (owner != null) {
            alert.initOwner(owner);
        }
        alert.showAndWait();
    }

    private void showExportError(String message) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Export error");
        alert.setHeaderText("Failed to export 8D report");
        alert.setContentText(message);
        Window owner = this.resolveWindow();
        if (owner != null) {
            alert.initOwner(owner);
        }
        alert.showAndWait();
    }

    private Window resolveWindow() {
        if (this.ownerStage != null) {
            return this.ownerStage;
        }
        if (this.root != null && this.root.getScene() != null) {
            return this.root.getScene().getWindow();
        }
        return null;
    }

    private void performSave(boolean closeAfter) {
        this.commitPendingEdits();
        try {
            if (this.saveAction != null) {
                this.saveAction.run();
            }
            this.hasUnsavedChanges = false;
            if (closeAfter) {
                this.closeWindow();
            }
        }
        catch (Exception ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Save error");
            alert.setHeaderText("Failed to save project");
            alert.setContentText(ex.getMessage());
            if (this.ownerStage != null) {
                alert.initOwner((Window)this.ownerStage);
            }
            alert.showAndWait();
        }
    }

    private void commitPendingEdits() {
        if (this.tblTeamMembers != null && this.tblTeamMembers.getEditingCell() != null) {
            this.tblTeamMembers.edit(-1, null);
        }
        if (this.tblContainmentActions != null && this.tblContainmentActions.getEditingCell() != null) {
            this.tblContainmentActions.edit(-1, null);
        }
        if (this.tblD5CorrectiveActions != null && this.tblD5CorrectiveActions.getEditingCell() != null) {
            this.tblD5CorrectiveActions.edit(-1, null);
        }
        if (this.tblD6EffectivenessVerifications != null && this.tblD6EffectivenessVerifications.getEditingCell() != null) {
            this.tblD6EffectivenessVerifications.edit(-1, null);
        }
        if (this.tblD7PreventiveActions != null && this.tblD7PreventiveActions.getEditingCell() != null) {
            this.tblD7PreventiveActions.edit(-1, null);
        }
        if (this.tblD4MethodCauses != null && this.tblD4MethodCauses.getEditingCell() != null) {
            this.tblD4MethodCauses.edit(-1, null);
        }
        if (this.tblD4MachineCauses != null && this.tblD4MachineCauses.getEditingCell() != null) {
            this.tblD4MachineCauses.edit(-1, null);
        }
        if (this.tblD4MaterialCauses != null && this.tblD4MaterialCauses.getEditingCell() != null) {
            this.tblD4MaterialCauses.edit(-1, null);
        }
        if (this.tblD4ManpowerCauses != null && this.tblD4ManpowerCauses.getEditingCell() != null) {
            this.tblD4ManpowerCauses.edit(-1, null);
        }
    }

    private void closeWindow() {
        Stage window = null;
        if (this.ownerStage != null) {
            window = this.ownerStage;
        } else if (this.root != null && this.root.getScene() != null) {
            window = this.root.getScene().getWindow();
        }
        if (window == null) {
            return;
        }
        this.programmaticClose = true;
        if (window instanceof Stage) {
            Stage stage = window;
            stage.close();
        } else {
            window.hide();
        }
    }

    private void installCloseHandler() {
        if (this.ownerStage == null) {
            return;
        }
        this.ownerStage.setOnCloseRequest(evt -> {
            if (this.programmaticClose) {
                this.programmaticClose = false;
                return;
            }
            evt.consume();
            this.promptSaveBeforeClose();
        });
    }

    private void promptSaveBeforeClose() {
        if (!this.hasUnsavedChanges) {
            this.closeWindow();
            return;
        }
        Alert confirm = new Alert(Alert.AlertType.CONFIRMATION);
        confirm.setTitle("Save changes?");
        confirm.setHeaderText("Do you want to save before closing?");
        confirm.setContentText("Select Yes to save the current 8D report.");
        confirm.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        if (this.ownerStage != null) {
            confirm.initOwner((Window)this.ownerStage);
        }
        confirm.showAndWait().ifPresent(result -> {
            if (result == ButtonType.YES) {
                this.performSave(true);
            } else if (result == ButtonType.NO) {
                this.hasUnsavedChanges = false;
                this.closeWindow();
            }
        });
    }

    private boolean ensureEditPermission() {
        return true;
    }

    private void markDirty() {
        if (this.syncing) {
            return;
        }
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        } else {
            this.hasUnsavedChanges = true;
        }
    }

    private void configureHeaderIcon() {
        this.setIcon(this.imgHeaderIcon, "/icons/eight_d.png");
    }

    private void setIcon(ImageView view, String resourcePath) {
        if (view == null) {
            return;
        }
        URL iconUrl = EightDWindowController.class.getResource(resourcePath);
        if (iconUrl == null) {
            System.err.println("Icon resource not found: " + resourcePath);
            return;
        }
        view.setImage(new Image(iconUrl.toExternalForm()));
    }

    private Image loadIcon(String name, double size) {
        InputStream stream = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        if (stream == null) {
            return null;
        }
        return new Image(stream, size, size, true, true);
    }

    private ImageView icon(Image img, double size) {
        if (img == null) {
            return null;
        }
        ImageView iv = new ImageView(img);
        iv.setPreserveRatio(true);
        iv.setFitWidth(size);
        iv.setFitHeight(size);
        iv.setSmooth(true);
        return iv;
    }

    private void loadIcons() {
        this.icSave = this.loadIcon("save", 18.0);
        this.icExit = this.loadIcon("exit", 18.0);
        this.icExport = this.loadIcon("export", 16.0);
        this.icPlus = this.loadIcon("plus", 14.0);
        this.icTrash = this.loadIcon("trash", 14.0);
        this.icEdit = this.loadIcon("edit", 14.0);
        this.icTable = this.loadIcon("table", 14.0);
        this.icSearch = this.loadIcon("search", 14.0);
    }

    private void ensureTooltip(Button btn, String fallbackText) {
        if (btn == null) {
            return;
        }
        String text = btn.getText();
        if ((text == null || text.isBlank()) && fallbackText != null) {
            text = fallbackText;
        }
        if (text == null || text.isBlank()) {
            return;
        }
        Tooltip tip = btn.getTooltip();
        if (tip == null || tip.getText() == null || tip.getText().isBlank()) {
            btn.setTooltip(new Tooltip(text));
        }
    }

    private void applyDefaultTooltips() {
        this.ensureTooltip(this.btnSaveOnly, "Save 8D report");
        this.ensureTooltip(this.btnSaveExit, "Save and close");
        this.ensureTooltip(this.btnExportReport, "Export 8D report");
        this.ensureTooltip(this.btnAddTeamMember, "Add team member");
        this.ensureTooltip(this.btnDeleteTeamMember, "Remove selected team member");
        this.ensureTooltip(this.btnAddContainmentAction, "Add containment action");
        this.ensureTooltip(this.btnDeleteContainmentAction, "Remove selected containment action");
        this.ensureTooltip(this.btnAddD5CorrectiveAction, "Add corrective action");
        this.ensureTooltip(this.btnDeleteD5CorrectiveAction, "Remove selected corrective action");
        this.ensureTooltip(this.btnAddD6Verification, "Add effectiveness verification");
        this.ensureTooltip(this.btnDeleteD6Verification, "Remove selected effectiveness verification");
        this.ensureTooltip(this.btnAddD7PreventiveAction, "Add preventive action");
        this.ensureTooltip(this.btnDeleteD7PreventiveAction, "Remove selected preventive action");
        this.ensureTooltip(this.btnAddD4MethodCause, "Add possible root cause for occurrence");
        this.ensureTooltip(this.btnDeleteD4MethodCause, "Remove selected possible root cause for occurrence");
        this.ensureTooltip(this.btnAddD4MachineCause, "Add probable root cause for occurrence");
        this.ensureTooltip(this.btnDeleteD4MachineCause, "Remove selected probable root cause for occurrence");
        this.ensureTooltip(this.btnAddD4MaterialCause, "Add possible cause of non-detection");
        this.ensureTooltip(this.btnDeleteD4MaterialCause, "Remove selected possible cause of non-detection");
        this.ensureTooltip(this.btnAddD4ManpowerCause, "Add probable cause of non-detection");
        this.ensureTooltip(this.btnDeleteD4ManpowerCause, "Remove selected probable cause of non-detection");
        this.ensureTooltip(this.btnAddImage, "Add image");
        this.ensureTooltip(this.btnRemoveImage, "Remove selected image");
    }

    private final class LocalDatePickerTableCell<S>
    extends TableCell<S, LocalDate> {
        private final DatePicker datePicker;
        final /* synthetic */ EightDWindowController this$0;

        private LocalDatePickerTableCell(EightDWindowController eightDWindowController) {
            EightDWindowController eightDWindowController2 = eightDWindowController;
            Objects.requireNonNull(eightDWindowController2);
            this.this$0 = eightDWindowController2;
            this.datePicker = new DatePicker();
            this.setAlignment(Pos.CENTER);
            this.datePicker.setEditable(false);
            this.datePicker.setOnAction(e -> {
                if (this.isEditing()) {
                    this.commitEdit((LocalDate)this.datePicker.getValue());
                }
            });
            this.datePicker.focusedProperty().addListener((obs, oldV, newV) -> {
                if (!newV.booleanValue() && this.isEditing()) {
                    this.commitEdit((LocalDate)this.datePicker.getValue());
                }
            });
            this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        }

        public void startEdit() {
            if (!this.isEditable() || this.getTableView() == null || !this.getTableView().isEditable() || this.getTableColumn() == null || !this.getTableColumn().isEditable() || this.getTableRow() == null || this.getTableRow().isEmpty()) {
                return;
            }
            super.startEdit();
            this.datePicker.setValue((Object)((LocalDate)this.getItem()));
            this.setText(null);
            this.setGraphic((Node)this.datePicker);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            Platform.runLater(() -> ((DatePicker)this.datePicker).show());
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setGraphic(null);
            this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            this.setText(this.this$0.formatDate((LocalDate)this.getItem()));
        }

        protected void updateItem(LocalDate item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                return;
            }
            if (this.isEditing()) {
                this.datePicker.setValue((Object)item);
                this.setText(null);
                this.setGraphic((Node)this.datePicker);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.this$0.formatDate(item));
                this.setGraphic(null);
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }
}

