/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.eightd.EightD;
import com.qualidadeeprodutividade.eightd.EightDEvent;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.Window;

public class EventsWindowController {
    @FXML
    private AnchorPane root;
    @FXML
    private Button btnSaveOnly;
    @FXML
    private Button btnSaveExit;
    @FXML
    private Button btnAddEvent;
    @FXML
    private Button btnDeleteEvent;
    @FXML
    private TableView<EightDEvent> tblEvents;
    @FXML
    private TableColumn<EightDEvent, LocalDate> colEventDate;
    @FXML
    private TableColumn<EightDEvent, String> colEventDescription;
    @FXML
    private TableColumn<EightDEvent, String> colEventWho;
    @FXML
    private TableColumn<EightDEvent, String> colEventWhere;
    private Image icSave;
    private Image icExit;
    private Image icPlus;
    private Image icTrash;
    private Stage ownerStage;
    private EightD report;
    private Runnable saveAction = () -> {};
    private Runnable dirtyHook = () -> {};
    private final List<Runnable> bindingCleanups = new ArrayList<Runnable>();

    @FXML
    private void initialize() {
        this.loadIcons();
        this.configureButtons();
        this.configureTable();
        this.applyDefaultTooltips();
    }

    public void setOwnerStage(Stage stage) {
        this.ownerStage = stage;
        if (stage != null) {
            stage.setResizable(false);
        }
    }

    public void setSaveAction(Runnable saveAction) {
        this.saveAction = saveAction == null ? () -> {} : saveAction;
    }

    public void setDirtyHook(Runnable dirtyHook) {
        this.dirtyHook = dirtyHook == null ? () -> {} : dirtyHook;
    }

    public void setEightD(EightD report) {
        this.clearBindings();
        this.report = report;
        if (this.tblEvents != null) {
            this.tblEvents.setItems(report == null ? FXCollections.observableArrayList() : report.getEvents());
        }
        if (report != null && report.getEvents() != null) {
            ListChangeListener listener = change -> this.markDirty();
            report.getEvents().addListener(listener);
            this.bindingCleanups.add(() -> report.getEvents().removeListener(listener));
        }
        this.updateDeleteState();
    }

    private void clearBindings() {
        this.bindingCleanups.forEach(Runnable::run);
        this.bindingCleanups.clear();
    }

    private void configureButtons() {
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setOnAction(e -> this.onSaveOnly());
            this.btnSaveOnly.setGraphic((Node)this.icon(this.icSave, 18.0));
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setOnAction(e -> this.onSaveAndExit());
            this.btnSaveExit.setGraphic((Node)this.icon(this.icExit, 18.0));
        }
        if (this.btnAddEvent != null) {
            this.btnAddEvent.setOnAction(e -> this.addEvent());
            this.btnAddEvent.setGraphic((Node)this.icon(this.icPlus, 14.0));
        }
        if (this.btnDeleteEvent != null) {
            this.btnDeleteEvent.setOnAction(e -> this.removeSelectedEvent());
            this.btnDeleteEvent.setGraphic((Node)this.icon(this.icTrash, 14.0));
        }
    }

    private void configureTable() {
        if (this.tblEvents == null) {
            return;
        }
        this.tblEvents.setEditable(true);
        this.tblEvents.getSelectionModel().setCellSelectionEnabled(true);
        this.tblEvents.setPlaceholder((Node)new Label("No events added."));
        if (this.colEventDate != null) {
            this.colEventDate.setEditable(true);
            this.colEventDate.setCellValueFactory(c -> ((EightDEvent)c.getValue()).dateProperty());
            this.colEventDate.setCellFactory(col -> new LocalDatePickerTableCell(this));
            this.colEventDate.setOnEditCommit(event -> {
                EightDEvent item = (EightDEvent)event.getRowValue();
                if (item == null) {
                    return;
                }
                item.setDate((LocalDate)event.getNewValue());
                this.markDirty();
            });
        }
        this.configureTextColumn(this.colEventDescription, EightDEvent::descriptionProperty);
        this.configureTextColumn(this.colEventWho, EightDEvent::whoProperty);
        this.configureTextColumn(this.colEventWhere, EightDEvent::whereProperty);
        this.tblEvents.getSelectionModel().selectedItemProperty().addListener((obs, oldV, newV) -> this.updateDeleteState());
    }

    private void configureTextColumn(TableColumn<EightDEvent, String> column, Function<EightDEvent, StringProperty> propertyFactory) {
        if (column == null) {
            return;
        }
        column.setEditable(true);
        column.setCellValueFactory(c -> (ObservableValue)propertyFactory.apply((EightDEvent)c.getValue()));
        column.setCellFactory(TextFieldTableCell.forTableColumn());
        column.setOnEditCommit(event -> {
            EightDEvent row = (EightDEvent)event.getRowValue();
            if (row == null) {
                return;
            }
            String value = event.getNewValue() == null ? "" : (String)event.getNewValue();
            ((StringProperty)propertyFactory.apply(row)).set((Object)value);
            this.markDirty();
        });
    }

    private void addEvent() {
        if (this.report == null || this.report.getEvents() == null) {
            return;
        }
        EightDEvent event = new EightDEvent();
        this.report.getEvents().add((Object)event);
        if (this.tblEvents != null) {
            this.tblEvents.getSelectionModel().select((Object)event);
            this.tblEvents.scrollTo((Object)event);
        }
        this.updateDeleteState();
        this.markDirty();
    }

    private void removeSelectedEvent() {
        if (this.report == null || this.report.getEvents() == null || this.tblEvents == null) {
            return;
        }
        EightDEvent selected = (EightDEvent)this.tblEvents.getSelectionModel().getSelectedItem();
        if (selected == null) {
            return;
        }
        this.report.getEvents().remove((Object)selected);
        this.updateDeleteState();
        this.markDirty();
    }

    private void updateDeleteState() {
        if (this.btnDeleteEvent == null) {
            return;
        }
        boolean disabled = this.report == null || this.tblEvents == null || this.tblEvents.getSelectionModel() == null || this.tblEvents.getSelectionModel().getSelectedItem() == null;
        this.btnDeleteEvent.setDisable(disabled);
    }

    private void markDirty() {
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private void applyDefaultTooltips() {
        this.ensureTooltip(this.btnSaveOnly, "Save");
        this.ensureTooltip(this.btnSaveExit, "Save and close");
        this.ensureTooltip(this.btnAddEvent, "Add event");
        this.ensureTooltip(this.btnDeleteEvent, "Remove selected event");
    }

    private void ensureTooltip(Button btn, String fallbackText) {
        if (btn == null) {
            return;
        }
        Tooltip tip = btn.getTooltip();
        if (tip == null || tip.getText() == null || tip.getText().isBlank()) {
            btn.setTooltip(new Tooltip(fallbackText));
        }
    }

    private void loadIcons() {
        this.icSave = this.loadIcon("save", 18.0);
        this.icExit = this.loadIcon("exit", 18.0);
        this.icPlus = this.loadIcon("plus", 14.0);
        this.icTrash = this.loadIcon("trash", 14.0);
    }

    private Image loadIcon(String name, double size) {
        InputStream stream = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        if (stream == null) {
            return null;
        }
        return new Image(stream, size, size, true, true);
    }

    private ImageView icon(Image img, double size) {
        if (img == null) {
            return null;
        }
        ImageView iv = new ImageView(img);
        iv.setPreserveRatio(true);
        iv.setFitWidth(size);
        iv.setFitHeight(size);
        iv.setSmooth(true);
        return iv;
    }

    private void onSaveOnly() {
        this.runSave();
    }

    private void onSaveAndExit() {
        if (this.runSave()) {
            this.closeWindow();
        }
    }

    private boolean runSave() {
        if (this.report == null) {
            return true;
        }
        try {
            this.saveAction.run();
            return true;
        }
        catch (Exception ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Save error");
            alert.setHeaderText("Failed to save project");
            alert.setContentText(ex.getMessage());
            if (this.ownerStage != null) {
                alert.initOwner((Window)this.ownerStage);
            }
            alert.showAndWait();
            return false;
        }
    }

    private void closeWindow() {
        Stage stage = this.ownerStage;
        if (stage == null && this.root != null && this.root.getScene() != null) {
            stage = (Stage)this.root.getScene().getWindow();
        }
        if (stage != null) {
            stage.close();
        }
    }

    private String formatDate(LocalDate value) {
        return value == null ? "" : value.toString();
    }

    private final class LocalDatePickerTableCell<S>
    extends TableCell<S, LocalDate> {
        private final DatePicker datePicker;
        final /* synthetic */ EventsWindowController this$0;

        private LocalDatePickerTableCell(EventsWindowController eventsWindowController) {
            EventsWindowController eventsWindowController2 = eventsWindowController;
            Objects.requireNonNull(eventsWindowController2);
            this.this$0 = eventsWindowController2;
            this.datePicker = new DatePicker();
            this.setAlignment(Pos.CENTER);
            this.datePicker.setEditable(false);
            this.datePicker.setOnAction(e -> {
                if (this.isEditing()) {
                    this.commitEdit((LocalDate)this.datePicker.getValue());
                }
            });
            this.datePicker.focusedProperty().addListener((obs, oldV, newV) -> {
                if (!newV.booleanValue() && this.isEditing()) {
                    this.commitEdit((LocalDate)this.datePicker.getValue());
                }
            });
            this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        }

        public void startEdit() {
            if (!this.isEditable() || this.getTableView() == null || !this.getTableView().isEditable() || this.getTableColumn() == null || !this.getTableColumn().isEditable() || this.getTableRow() == null || this.getTableRow().isEmpty()) {
                return;
            }
            super.startEdit();
            this.datePicker.setValue((Object)((LocalDate)this.getItem()));
            this.setText(null);
            this.setGraphic((Node)this.datePicker);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            Platform.runLater(() -> ((DatePicker)this.datePicker).show());
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setGraphic(null);
            this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            this.setText(this.this$0.formatDate((LocalDate)this.getItem()));
        }

        protected void updateItem(LocalDate item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                return;
            }
            if (this.isEditing()) {
                this.datePicker.setValue((Object)item);
                this.setText(null);
                this.setGraphic((Node)this.datePicker);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            } else {
                this.setText(this.this$0.formatDate(item));
                this.setGraphic(null);
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        }
    }
}

