/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.eightd.EightD;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.Window;

public class FiveWhysWindowController {
    private static final int DEFAULT_VISIBLE_ROWS = 5;
    @FXML
    private AnchorPane root;
    @FXML
    private Button btnSaveOnly;
    @FXML
    private Button btnSaveExit;
    @FXML
    private Button btnAddRow;
    @FXML
    private Button btnDeleteRow;
    @FXML
    private TextField txtFailureDescription;
    @FXML
    private TextArea txtProposedActions;
    @FXML
    private TableView<FiveWhysRow> tblFiveWhys;
    @FXML
    private TableColumn<FiveWhysRow, String> colWhy;
    @FXML
    private TableColumn<FiveWhysRow, String> colAnswer;
    private final ObservableList<FiveWhysRow> rows = FXCollections.observableArrayList();
    private final List<Runnable> bindingCleanups = new ArrayList<Runnable>();
    private Image icSave;
    private Image icExit;
    private Image icPlus;
    private Image icTrash;
    private Stage ownerStage;
    private EightD report;
    private Runnable saveAction = () -> {};
    private Runnable dirtyHook = () -> {};

    @FXML
    private void initialize() {
        this.loadIcons();
        this.configureButtons();
        this.configureTable();
        this.applyDefaultTooltips();
    }

    public void setOwnerStage(Stage stage) {
        this.ownerStage = stage;
        if (stage != null) {
            stage.setResizable(false);
        }
    }

    public void setSaveAction(Runnable saveAction) {
        this.saveAction = saveAction == null ? () -> {} : saveAction;
    }

    public void setDirtyHook(Runnable dirtyHook) {
        this.dirtyHook = dirtyHook == null ? () -> {} : dirtyHook;
    }

    public void setEightD(EightD report) {
        this.clearBindings();
        this.report = report;
        this.loadRowsFromReport();
        this.bindFailureDescription();
        this.bindProposedActions();
        this.updateDeleteState();
    }

    private void clearBindings() {
        this.bindingCleanups.forEach(Runnable::run);
        this.bindingCleanups.clear();
    }

    private void configureButtons() {
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setOnAction(e -> this.onSaveOnly());
            this.btnSaveOnly.setGraphic((Node)this.icon(this.icSave, 18.0));
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setOnAction(e -> this.onSaveAndExit());
            this.btnSaveExit.setGraphic((Node)this.icon(this.icExit, 18.0));
        }
        if (this.btnAddRow != null) {
            this.btnAddRow.setOnAction(e -> this.addRow());
            this.btnAddRow.setGraphic((Node)this.icon(this.icPlus, 14.0));
        }
        if (this.btnDeleteRow != null) {
            this.btnDeleteRow.setOnAction(e -> this.removeSelectedRow());
            this.btnDeleteRow.setGraphic((Node)this.icon(this.icTrash, 14.0));
        }
    }

    private void configureTable() {
        if (this.tblFiveWhys == null) {
            return;
        }
        this.tblFiveWhys.setEditable(true);
        this.tblFiveWhys.getSelectionModel().setCellSelectionEnabled(true);
        this.tblFiveWhys.setPlaceholder((Node)new Label("No 5-Why rows added."));
        this.tblFiveWhys.setItems(this.rows);
        this.configureTextColumn(this.colWhy, FiveWhysRow::whyProperty);
        this.configureTextColumn(this.colAnswer, FiveWhysRow::answerProperty);
        this.tblFiveWhys.getSelectionModel().selectedItemProperty().addListener((obs, oldV, newV) -> this.updateDeleteState());
        this.tblFiveWhys.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.INSERT) {
                this.addRow();
                event.consume();
            } else if (event.getCode() == KeyCode.DELETE) {
                this.removeSelectedRow();
                event.consume();
            }
        });
        MenuItem add = new MenuItem("Add row", (Node)this.icon(this.icPlus, 12.0));
        add.setOnAction(e -> this.addRow());
        MenuItem remove = new MenuItem("Remove row", (Node)this.icon(this.icTrash, 12.0));
        remove.setOnAction(e -> this.removeSelectedRow());
        this.tblFiveWhys.setContextMenu(new ContextMenu(new MenuItem[]{add, remove}));
    }

    private void configureTextColumn(TableColumn<FiveWhysRow, String> column, Function<FiveWhysRow, StringProperty> propertyFactory) {
        if (column == null) {
            return;
        }
        column.setEditable(true);
        column.setCellValueFactory(cell -> (ObservableValue)propertyFactory.apply((FiveWhysRow)cell.getValue()));
        column.setCellFactory(TextFieldTableCell.forTableColumn());
        column.setOnEditCommit(event -> {
            FiveWhysRow row = (FiveWhysRow)event.getRowValue();
            if (row == null) {
                return;
            }
            ((StringProperty)propertyFactory.apply(row)).set((Object)(event.getNewValue() == null ? "" : (String)event.getNewValue()));
            this.syncRowsToReport();
            this.markDirty();
        });
    }

    private void bindFailureDescription() {
        if (this.txtFailureDescription == null) {
            return;
        }
        this.txtFailureDescription.setText(this.resolveInitialFailureDescription());
        this.txtFailureDescription.setDisable(this.report == null);
        ChangeListener listener = (obs, oldV, newV) -> {
            if (this.report == null) {
                return;
            }
            this.report.setFiveWhysFailureDescription(newV == null ? "" : newV);
            this.markDirty();
        };
        this.txtFailureDescription.textProperty().addListener(listener);
        this.bindingCleanups.add(() -> this.txtFailureDescription.textProperty().removeListener(listener));
    }

    private void bindProposedActions() {
        if (this.txtProposedActions == null) {
            return;
        }
        this.txtProposedActions.setText(this.report == null ? "" : this.nz(this.report.getFiveWhysProposedActions()));
        this.txtProposedActions.setDisable(this.report == null);
        ChangeListener listener = (obs, oldV, newV) -> {
            if (this.report == null) {
                return;
            }
            this.report.setFiveWhysProposedActions(newV == null ? "" : newV);
            this.markDirty();
        };
        this.txtProposedActions.textProperty().addListener(listener);
        this.bindingCleanups.add(() -> this.txtProposedActions.textProperty().removeListener(listener));
    }

    private String resolveInitialFailureDescription() {
        if (this.report == null) {
            return "";
        }
        String currentFailure = this.trimToNull(this.report.getFiveWhysFailureDescription());
        if (currentFailure != null) {
            return currentFailure;
        }
        String nonConformance = this.trimToNull(this.report.getNonConformanceNotification());
        if (nonConformance != null) {
            this.report.setFiveWhysFailureDescription(nonConformance);
            this.markDirty();
            return nonConformance;
        }
        return "";
    }

    private void loadRowsFromReport() {
        this.rows.clear();
        if (this.report == null) {
            return;
        }
        int rowCount = Math.max(this.listSize((List<String>)this.report.getFiveWhysWhy()), this.listSize((List<String>)this.report.getFiveWhysAnswers()));
        for (int i = 0; i < rowCount; ++i) {
            this.rows.add((Object)new FiveWhysRow(this.valueAt((List<String>)this.report.getFiveWhysWhy(), i), this.valueAt((List<String>)this.report.getFiveWhysAnswers(), i)));
        }
        while (this.rows.size() < 5) {
            this.rows.add((Object)new FiveWhysRow());
        }
    }

    private int listSize(List<String> list) {
        return list == null ? 0 : list.size();
    }

    private String valueAt(List<String> list, int index) {
        if (list == null || index < 0 || index >= list.size()) {
            return "";
        }
        String value = list.get(index);
        return value == null ? "" : value;
    }

    private void addRow() {
        this.rows.add((Object)new FiveWhysRow());
        int last = this.rows.size() - 1;
        if (last >= 0 && this.tblFiveWhys != null && this.colWhy != null) {
            this.tblFiveWhys.getSelectionModel().clearAndSelect(last, this.colWhy);
            if (this.tblFiveWhys.getFocusModel() != null) {
                this.tblFiveWhys.getFocusModel().focus(last, this.colWhy);
            }
            this.tblFiveWhys.edit(last, this.colWhy);
            this.tblFiveWhys.scrollTo(last);
        }
        this.syncRowsToReport();
        this.updateDeleteState();
        this.markDirty();
    }

    private void removeSelectedRow() {
        if (this.tblFiveWhys == null) {
            return;
        }
        int selectedIndex = this.tblFiveWhys.getSelectionModel().getSelectedIndex();
        if (selectedIndex < 0 || selectedIndex >= this.rows.size()) {
            return;
        }
        this.rows.remove(selectedIndex);
        this.syncRowsToReport();
        this.updateDeleteState();
        this.markDirty();
    }

    private void syncRowsToReport() {
        FiveWhysRow row;
        int i;
        if (this.report == null) {
            return;
        }
        this.report.getFiveWhysWhy().clear();
        this.report.getFiveWhysAnswers().clear();
        int lastMeaningful = -1;
        for (i = 0; i < this.rows.size(); ++i) {
            row = (FiveWhysRow)this.rows.get(i);
            if (this.trimToNull(row.getWhy()) == null && this.trimToNull(row.getAnswer()) == null) continue;
            lastMeaningful = i;
        }
        for (i = 0; i <= lastMeaningful; ++i) {
            row = (FiveWhysRow)this.rows.get(i);
            this.report.getFiveWhysWhy().add((Object)this.normalizeCellForStorage(row.getWhy()));
            this.report.getFiveWhysAnswers().add((Object)this.normalizeCellForStorage(row.getAnswer()));
        }
    }

    private String normalizeCellForStorage(String value) {
        return value == null ? "" : value.trim();
    }

    private String nz(String value) {
        return value == null ? "" : value;
    }

    private String trimToNull(String value) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    private void updateDeleteState() {
        if (this.btnDeleteRow == null) {
            return;
        }
        boolean disabled = this.tblFiveWhys == null || this.tblFiveWhys.getSelectionModel() == null || this.tblFiveWhys.getSelectionModel().getSelectedIndex() < 0;
        this.btnDeleteRow.setDisable(disabled);
    }

    private void markDirty() {
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private void onSaveOnly() {
        this.runSave();
    }

    private void onSaveAndExit() {
        if (this.runSave()) {
            this.closeWindow();
        }
    }

    private boolean runSave() {
        if (this.report == null) {
            return true;
        }
        this.syncRowsToReport();
        try {
            this.saveAction.run();
            return true;
        }
        catch (Exception ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Save error");
            alert.setHeaderText("Failed to save project");
            alert.setContentText(ex.getMessage());
            if (this.ownerStage != null) {
                alert.initOwner((Window)this.ownerStage);
            }
            alert.showAndWait();
            return false;
        }
    }

    private void closeWindow() {
        Stage stage = this.ownerStage;
        if (stage == null && this.root != null && this.root.getScene() != null) {
            stage = (Stage)this.root.getScene().getWindow();
        }
        if (stage != null) {
            stage.close();
        }
    }

    private void applyDefaultTooltips() {
        this.ensureTooltip(this.btnSaveOnly, "Save");
        this.ensureTooltip(this.btnSaveExit, "Save and close");
        this.ensureTooltip(this.btnAddRow, "Add row");
        this.ensureTooltip(this.btnDeleteRow, "Remove selected row");
    }

    private void ensureTooltip(Button button, String fallbackText) {
        if (button == null) {
            return;
        }
        Tooltip tooltip = button.getTooltip();
        if (tooltip == null || tooltip.getText() == null || tooltip.getText().isBlank()) {
            button.setTooltip(new Tooltip(fallbackText));
        }
    }

    private void loadIcons() {
        this.icSave = this.loadIcon("save", 18.0);
        this.icExit = this.loadIcon("exit", 18.0);
        this.icPlus = this.loadIcon("plus", 14.0);
        this.icTrash = this.loadIcon("trash", 14.0);
    }

    private Image loadIcon(String name, double size) {
        InputStream stream = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        if (stream == null) {
            return null;
        }
        return new Image(stream, size, size, true, true);
    }

    private ImageView icon(Image image, double size) {
        if (image == null) {
            return null;
        }
        ImageView view = new ImageView(image);
        view.setPreserveRatio(true);
        view.setFitWidth(size);
        view.setFitHeight(size);
        view.setSmooth(true);
        return view;
    }

    private static final class FiveWhysRow {
        private final StringProperty why = new SimpleStringProperty((Object)this, "why", "");
        private final StringProperty answer = new SimpleStringProperty((Object)this, "answer", "");

        private FiveWhysRow() {
            this("", "");
        }

        private FiveWhysRow(String why, String answer) {
            this.setWhy(why);
            this.setAnswer(answer);
        }

        public StringProperty whyProperty() {
            return this.why;
        }

        public StringProperty answerProperty() {
            return this.answer;
        }

        public String getWhy() {
            return (String)this.why.get();
        }

        public String getAnswer() {
            return (String)this.answer.get();
        }

        public void setWhy(String value) {
            this.why.set((Object)(value == null ? "" : value));
        }

        public void setAnswer(String value) {
            this.answer.set((Object)(value == null ? "" : value));
        }
    }
}

