/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.eightd.EightD;
import com.qualidadeeprodutividade.export.ExportDirectoryPreferences;
import com.qualidadeeprodutividade.export.ExportFileNameUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.imageio.ImageIO;

public class IshikawaWindowController {
    private static final int DEFAULT_VISIBLE_ROWS = 15;
    @FXML
    private AnchorPane root;
    @FXML
    private Button btnSaveOnly;
    @FXML
    private Button btnSaveExit;
    @FXML
    private Button btnAddCause;
    @FXML
    private Button btnDeleteCause;
    @FXML
    private TextField txtFailureDescription;
    @FXML
    private TableView<IshikawaRow> tblCauses;
    @FXML
    private TableColumn<IshikawaRow, String> colMethod;
    @FXML
    private TableColumn<IshikawaRow, String> colMachine;
    @FXML
    private TableColumn<IshikawaRow, String> colMeasurements;
    @FXML
    private TableColumn<IshikawaRow, String> colEnvironment;
    @FXML
    private TableColumn<IshikawaRow, String> colMaterial;
    @FXML
    private TableColumn<IshikawaRow, String> colManpower;
    @FXML
    private WebView webIshikawa;
    private final ObservableList<IshikawaRow> rows = FXCollections.observableArrayList();
    private final List<Runnable> bindingCleanups = new ArrayList<Runnable>();
    private javafx.scene.image.Image icSave;
    private javafx.scene.image.Image icExit;
    private javafx.scene.image.Image icPlus;
    private javafx.scene.image.Image icTrash;
    private Stage ownerStage;
    private EightD report;
    private Runnable saveAction = () -> {};
    private Runnable dirtyHook = () -> {};
    private boolean pageRequested = false;
    private boolean pageReady = false;

    @FXML
    private void initialize() {
        this.loadIcons();
        this.configureButtons();
        this.configureTable();
        this.loadDiagramPage();
        this.applyDefaultTooltips();
    }

    public void setOwnerStage(Stage stage) {
        this.ownerStage = stage;
        if (stage != null) {
            stage.setResizable(false);
        }
    }

    public void setSaveAction(Runnable saveAction) {
        this.saveAction = saveAction == null ? () -> {} : saveAction;
    }

    public void setDirtyHook(Runnable dirtyHook) {
        this.dirtyHook = dirtyHook == null ? () -> {} : dirtyHook;
    }

    public void setEightD(EightD report) {
        this.clearBindings();
        this.report = report;
        this.loadRowsFromReport();
        this.bindFailureDescription();
        this.updateDeleteState();
        this.refreshDiagram();
    }

    private void clearBindings() {
        this.bindingCleanups.forEach(Runnable::run);
        this.bindingCleanups.clear();
    }

    private void configureButtons() {
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setOnAction(e -> this.onSaveOnly());
            this.btnSaveOnly.setGraphic((Node)this.icon(this.icSave, 18.0));
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setOnAction(e -> this.onSaveAndExit());
            this.btnSaveExit.setGraphic((Node)this.icon(this.icExit, 18.0));
        }
        if (this.btnAddCause != null) {
            this.btnAddCause.setOnAction(e -> this.addRow());
            this.btnAddCause.setGraphic((Node)this.icon(this.icPlus, 14.0));
        }
        if (this.btnDeleteCause != null) {
            this.btnDeleteCause.setOnAction(e -> this.removeSelectedRow());
            this.btnDeleteCause.setGraphic((Node)this.icon(this.icTrash, 14.0));
        }
    }

    private void configureTable() {
        if (this.tblCauses == null) {
            return;
        }
        this.tblCauses.setEditable(true);
        this.tblCauses.getSelectionModel().setCellSelectionEnabled(true);
        this.tblCauses.setPlaceholder((Node)new Label("No causes added."));
        this.tblCauses.setItems(this.rows);
        this.configureTextColumn(this.colMethod, IshikawaRow::methodProperty);
        this.configureTextColumn(this.colMachine, IshikawaRow::machineProperty);
        this.configureTextColumn(this.colMeasurements, IshikawaRow::measurementsProperty);
        this.configureTextColumn(this.colEnvironment, IshikawaRow::environmentProperty);
        this.configureTextColumn(this.colMaterial, IshikawaRow::materialProperty);
        this.configureTextColumn(this.colManpower, IshikawaRow::manpowerProperty);
        this.tblCauses.getSelectionModel().selectedItemProperty().addListener((obs, oldV, newV) -> this.updateDeleteState());
        this.tblCauses.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.INSERT) {
                this.addRow();
                event.consume();
            } else if (event.getCode() == KeyCode.DELETE) {
                this.removeSelectedRow();
                event.consume();
            }
        });
        MenuItem add = new MenuItem("Add row", (Node)this.icon(this.icPlus, 12.0));
        add.setOnAction(e -> this.addRow());
        MenuItem remove = new MenuItem("Remove row", (Node)this.icon(this.icTrash, 12.0));
        remove.setOnAction(e -> this.removeSelectedRow());
        this.tblCauses.setContextMenu(new ContextMenu(new MenuItem[]{add, remove}));
    }

    private void configureTextColumn(TableColumn<IshikawaRow, String> column, Function<IshikawaRow, StringProperty> propertyFactory) {
        if (column == null) {
            return;
        }
        column.setEditable(true);
        column.setCellValueFactory(cell -> (ObservableValue)propertyFactory.apply((IshikawaRow)cell.getValue()));
        column.setCellFactory(TextFieldTableCell.forTableColumn());
        column.setOnEditCommit(event -> {
            IshikawaRow row = (IshikawaRow)event.getRowValue();
            if (row == null) {
                return;
            }
            ((StringProperty)propertyFactory.apply(row)).set((Object)(event.getNewValue() == null ? "" : (String)event.getNewValue()));
            this.syncRowsToReport();
            this.markDirty();
            this.refreshDiagram();
        });
    }

    private void bindFailureDescription() {
        if (this.txtFailureDescription == null) {
            return;
        }
        this.txtFailureDescription.setText(this.resolveInitialFailureDescription());
        this.txtFailureDescription.setDisable(this.report == null);
        ChangeListener listener = (obs, oldV, newV) -> {
            if (this.report == null) {
                return;
            }
            this.report.setIshikawaFailureDescription(newV == null ? "" : newV);
            this.markDirty();
            this.refreshDiagram();
        };
        this.txtFailureDescription.textProperty().addListener(listener);
        this.bindingCleanups.add(() -> this.txtFailureDescription.textProperty().removeListener(listener));
    }

    private String resolveInitialFailureDescription() {
        if (this.report == null) {
            return "";
        }
        String currentFailure = this.trimToNull(this.report.getIshikawaFailureDescription());
        if (currentFailure != null) {
            return currentFailure;
        }
        String nonConformance = this.trimToNull(this.report.getNonConformanceNotification());
        if (nonConformance != null) {
            this.report.setIshikawaFailureDescription(nonConformance);
            this.markDirty();
            return nonConformance;
        }
        return "";
    }

    private void loadRowsFromReport() {
        this.rows.clear();
        if (this.report == null) {
            return;
        }
        int rowCount = Math.max(this.listSize((List<String>)this.report.getIshikawaCausesMethod()), this.listSize((List<String>)this.report.getIshikawaCausesMachine()));
        rowCount = Math.max(rowCount, this.listSize((List<String>)this.report.getIshikawaCausesMeasurements()));
        rowCount = Math.max(rowCount, this.listSize((List<String>)this.report.getIshikawaCausesEnvironment()));
        rowCount = Math.max(rowCount, this.listSize((List<String>)this.report.getIshikawaCausesMaterial()));
        rowCount = Math.max(rowCount, this.listSize((List<String>)this.report.getIshikawaCausesManpower()));
        for (int i = 0; i < rowCount; ++i) {
            this.rows.add((Object)new IshikawaRow(this.valueAt((List<String>)this.report.getIshikawaCausesMethod(), i), this.valueAt((List<String>)this.report.getIshikawaCausesMachine(), i), this.valueAt((List<String>)this.report.getIshikawaCausesMeasurements(), i), this.valueAt((List<String>)this.report.getIshikawaCausesEnvironment(), i), this.valueAt((List<String>)this.report.getIshikawaCausesMaterial(), i), this.valueAt((List<String>)this.report.getIshikawaCausesManpower(), i)));
        }
        while (this.rows.size() < 15) {
            this.rows.add((Object)new IshikawaRow());
        }
    }

    private int listSize(List<String> list) {
        return list == null ? 0 : list.size();
    }

    private String valueAt(List<String> list, int index) {
        if (list == null || index < 0 || index >= list.size()) {
            return "";
        }
        String value = list.get(index);
        return value == null ? "" : value;
    }

    private void addRow() {
        this.rows.add((Object)new IshikawaRow());
        int last = this.rows.size() - 1;
        if (last >= 0 && this.tblCauses != null && this.colMethod != null) {
            this.tblCauses.getSelectionModel().clearAndSelect(last, this.colMethod);
            if (this.tblCauses.getFocusModel() != null) {
                this.tblCauses.getFocusModel().focus(last, this.colMethod);
            }
            this.tblCauses.edit(last, this.colMethod);
            this.tblCauses.scrollTo(last);
        }
        this.syncRowsToReport();
        this.updateDeleteState();
        this.markDirty();
        this.refreshDiagram();
    }

    private void removeSelectedRow() {
        if (this.tblCauses == null) {
            return;
        }
        int selectedIndex = this.tblCauses.getSelectionModel().getSelectedIndex();
        if (selectedIndex < 0 || selectedIndex >= this.rows.size()) {
            return;
        }
        this.rows.remove(selectedIndex);
        this.syncRowsToReport();
        this.updateDeleteState();
        this.markDirty();
        this.refreshDiagram();
    }

    private void syncRowsToReport() {
        if (this.report == null) {
            return;
        }
        this.report.getIshikawaCausesMethod().clear();
        this.report.getIshikawaCausesMachine().clear();
        this.report.getIshikawaCausesMeasurements().clear();
        this.report.getIshikawaCausesEnvironment().clear();
        this.report.getIshikawaCausesMaterial().clear();
        this.report.getIshikawaCausesManpower().clear();
        for (IshikawaRow row : this.rows) {
            this.appendNonBlank((List<String>)this.report.getIshikawaCausesMethod(), row.getMethod());
            this.appendNonBlank((List<String>)this.report.getIshikawaCausesMachine(), row.getMachine());
            this.appendNonBlank((List<String>)this.report.getIshikawaCausesMeasurements(), row.getMeasurements());
            this.appendNonBlank((List<String>)this.report.getIshikawaCausesEnvironment(), row.getEnvironment());
            this.appendNonBlank((List<String>)this.report.getIshikawaCausesMaterial(), row.getMaterial());
            this.appendNonBlank((List<String>)this.report.getIshikawaCausesManpower(), row.getManpower());
        }
    }

    private void appendNonBlank(List<String> target, String value) {
        if (target == null) {
            return;
        }
        String normalized = this.trimToNull(value);
        if (normalized != null) {
            target.add(normalized);
        }
    }

    private String trimToNull(String value) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    private void updateDeleteState() {
        if (this.btnDeleteCause == null) {
            return;
        }
        boolean disabled = this.tblCauses == null || this.tblCauses.getSelectionModel() == null || this.tblCauses.getSelectionModel().getSelectedIndex() < 0;
        this.btnDeleteCause.setDisable(disabled);
    }

    private void loadDiagramPage() {
        if (this.pageRequested || this.webIshikawa == null) {
            return;
        }
        this.pageRequested = true;
        URL url = this.getClass().getResource("/html/ishikawa-diagram.html");
        if (url == null) {
            this.webIshikawa.getEngine().loadContent("<h3>ishikawa-diagram.html not found.</h3>");
            return;
        }
        this.webIshikawa.getEngine().getLoadWorker().stateProperty().addListener((obs, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                this.pageReady = true;
                this.installWebBridge();
                Platform.runLater(this::refreshDiagram);
            }
        });
        this.webIshikawa.getEngine().load(url.toExternalForm());
    }

    private void installWebBridge() {
        if (this.webIshikawa == null) {
            return;
        }
        try {
            Object winObj = this.webIshikawa.getEngine().executeScript("window");
            if (winObj != null) {
                winObj.getClass().getMethod("setMember", String.class, Object.class).invoke(winObj, "ishikawaHost", new IshikawaHostBridge(this));
            }
        }
        catch (ReflectiveOperationException | RuntimeException ex) {
            System.err.println("[Ishikawa] JS bridge install failed: " + ex.getMessage());
        }
    }

    private void refreshDiagram() {
        if (!this.pageReady || this.webIshikawa == null) {
            return;
        }
        try {
            this.webIshikawa.getEngine().executeScript("window.renderIshikawa && window.renderIshikawa(" + this.toIshikawaJson() + ");");
        }
        catch (Exception ex) {
            System.err.println("[Ishikawa] renderIshikawa call failed: " + ex.getMessage());
        }
    }

    private String toIshikawaJson() {
        StringBuilder sb = new StringBuilder(2048);
        sb.append("{\"failureDescription\":\"").append(this.escapeJson(this.resolveFailureDescription())).append("\",");
        sb.append("\"branches\":[");
        this.appendBranch(sb, "Method", this.causesForBranch(IshikawaRow::getMethod));
        sb.append(",");
        this.appendBranch(sb, "Machine", this.causesForBranch(IshikawaRow::getMachine));
        sb.append(",");
        this.appendBranch(sb, "Measurements", this.causesForBranch(IshikawaRow::getMeasurements));
        sb.append(",");
        this.appendBranch(sb, "Environment", this.causesForBranch(IshikawaRow::getEnvironment));
        sb.append(",");
        this.appendBranch(sb, "Material", this.causesForBranch(IshikawaRow::getMaterial));
        sb.append(",");
        this.appendBranch(sb, "Manpower", this.causesForBranch(IshikawaRow::getManpower));
        sb.append("]}");
        return sb.toString();
    }

    private void appendBranch(StringBuilder sb, String name, List<String> causes) {
        sb.append("{\"name\":\"").append(this.escapeJson(name)).append("\",\"causes\":[");
        for (int i = 0; i < causes.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("\"").append(this.escapeJson(causes.get(i))).append("\"");
        }
        sb.append("]}");
    }

    private List<String> causesForBranch(Function<IshikawaRow, String> valueGetter) {
        ArrayList<String> values = new ArrayList<String>();
        for (IshikawaRow row : this.rows) {
            String value = this.trimToNull(valueGetter.apply(row));
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    private String resolveFailureDescription() {
        String value;
        if (this.txtFailureDescription != null && (value = this.trimToNull(this.txtFailureDescription.getText())) != null) {
            return value;
        }
        return this.report == null ? "" : this.nz(this.report.getIshikawaFailureDescription());
    }

    private String nz(String value) {
        return value == null ? "" : value;
    }

    private String escapeJson(String value) {
        if (value == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(value.length() + 16);
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\\': {
                    out.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    out.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    out.append("\\b");
                    continue block9;
                }
                case '\f': {
                    out.append("\\f");
                    continue block9;
                }
                case '\n': {
                    out.append("\\n");
                    continue block9;
                }
                case '\r': {
                    out.append("\\r");
                    continue block9;
                }
                case '\t': {
                    out.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        out.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    private void markDirty() {
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private void onSaveOnly() {
        this.runSave();
    }

    private void onSaveAndExit() {
        if (this.runSave()) {
            this.closeWindow();
        }
    }

    private boolean runSave() {
        if (this.report == null) {
            return true;
        }
        this.syncRowsToReport();
        try {
            this.saveAction.run();
            return true;
        }
        catch (Exception ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Save error");
            alert.setHeaderText("Failed to save project");
            alert.setContentText(ex.getMessage());
            if (this.ownerStage != null) {
                alert.initOwner((Window)this.ownerStage);
            }
            alert.showAndWait();
            return false;
        }
    }

    private void exportDiagram(String format) {
        File output;
        String normalizedFormat;
        if (this.webIshikawa == null) {
            return;
        }
        String string = normalizedFormat = format == null ? "png" : format.trim().toLowerCase(Locale.ROOT);
        if (!("png".equals(normalizedFormat) || "jpg".equals(normalizedFormat) || "jpeg".equals(normalizedFormat))) {
            normalizedFormat = "png";
        }
        String extension = "jpeg".equals(normalizedFormat) ? "jpg" : normalizedFormat;
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Export Ishikawa as " + extension.toUpperCase(Locale.ROOT));
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter(extension.toUpperCase(Locale.ROOT) + " image", new String[]{"*." + extension});
        chooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{filter});
        chooser.setSelectedExtensionFilter(filter);
        File preferredDir = this.preferredExportDirectory();
        if (preferredDir != null && preferredDir.isDirectory()) {
            chooser.setInitialDirectory(preferredDir);
        }
        chooser.setInitialFileName(this.defaultExportFileName(extension));
        Stage owner = this.ownerStage != null ? this.ownerStage : (this.root != null && this.root.getScene() != null ? this.root.getScene().getWindow() : null);
        File selected = chooser.showSaveDialog((Window)owner);
        if (selected == null) {
            return;
        }
        ToolbarRect toolbarRect = this.readToolbarRect();
        try {
            output = this.normalizeExportTarget(selected, extension, preferredDir);
            this.rememberExportDirectory(output.getParentFile());
        }
        catch (IOException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Export error");
            alert.setHeaderText("Failed to export Ishikawa image");
            alert.setContentText("Failed to prepare export destination: " + ex.getMessage());
            if (this.ownerStage != null) {
                alert.initOwner((Window)this.ownerStage);
            }
            alert.showAndWait();
            return;
        }
        this.toggleWebToolbarForExport(true);
        PauseTransition waitForRender = new PauseTransition(Duration.millis((double)120.0));
        waitForRender.setOnFinished(evt -> {
            try {
                SnapshotParameters params = new SnapshotParameters();
                params.setFill((Paint)javafx.scene.paint.Color.WHITE);
                WritableImage snapshot = this.webIshikawa.snapshot(params, null);
                BufferedImage fxImage = SwingFXUtils.fromFXImage((javafx.scene.image.Image)snapshot, null);
                if (fxImage == null) {
                    throw new IOException("Could not capture the diagram image.");
                }
                this.eraseToolbarArea(fxImage, toolbarRect);
                BufferedImage outputImage = fxImage;
                if ("jpg".equals(extension)) {
                    outputImage = new BufferedImage(fxImage.getWidth(), fxImage.getHeight(), 1);
                    Graphics2D g2 = outputImage.createGraphics();
                    try {
                        g2.setColor(Color.WHITE);
                        g2.fillRect(0, 0, outputImage.getWidth(), outputImage.getHeight());
                        g2.drawImage((Image)fxImage, 0, 0, null);
                    }
                    finally {
                        g2.dispose();
                    }
                }
                this.eraseToolbarArea(outputImage, toolbarRect);
                boolean written = ImageIO.write((RenderedImage)outputImage, extension, output);
                if (!written) {
                    throw new IOException("Image writer for ." + extension + " not available.");
                }
            }
            catch (IOException | RuntimeException ex) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Export error");
                alert.setHeaderText("Failed to export Ishikawa image");
                alert.setContentText(ex.getMessage());
                if (this.ownerStage != null) {
                    alert.initOwner((Window)this.ownerStage);
                }
                alert.showAndWait();
            }
            finally {
                this.toggleWebToolbarForExport(false);
            }
        });
        waitForRender.play();
    }

    private ToolbarRect readToolbarRect() {
        if (!this.pageReady || this.webIshikawa == null) {
            return null;
        }
        try {
            Object result = this.webIshikawa.getEngine().executeScript("(() => {const t = document.getElementById('web-toolbar');if (!t) return '';const r = t.getBoundingClientRect();const vw = window.innerWidth || document.documentElement.clientWidth || 0;const vh = window.innerHeight || document.documentElement.clientHeight || 0;return [r.left, r.top, r.width, r.height, vw, vh].join(',');})()");
            if (result == null) {
                return null;
            }
            String raw = String.valueOf(result).trim();
            if (raw.isBlank()) {
                return null;
            }
            String[] parts = raw.split(",");
            if (parts.length != 6) {
                return null;
            }
            double x = Double.parseDouble(parts[0]);
            double y = Double.parseDouble(parts[1]);
            double w = Double.parseDouble(parts[2]);
            double h = Double.parseDouble(parts[3]);
            double vw = Double.parseDouble(parts[4]);
            double vh = Double.parseDouble(parts[5]);
            if (w <= 0.0 || h <= 0.0) {
                return null;
            }
            return new ToolbarRect(x, y, w, h, vw, vh);
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eraseToolbarArea(BufferedImage image, ToolbarRect rect) {
        if (image == null || rect == null || this.webIshikawa == null) {
            return;
        }
        double nodeWidth = rect.viewportWidth > 0.0 ? rect.viewportWidth : Math.max(1.0, this.webIshikawa.getWidth());
        double nodeHeight = rect.viewportHeight > 0.0 ? rect.viewportHeight : Math.max(1.0, this.webIshikawa.getHeight());
        double scaleX = (double)image.getWidth() / nodeWidth;
        double scaleY = (double)image.getHeight() / nodeHeight;
        int x = (int)Math.floor(rect.x * scaleX) - 12;
        int y = (int)Math.floor(rect.y * scaleY) - 12;
        int w = (int)Math.ceil(rect.width * scaleX) + 24;
        int h = (int)Math.ceil(rect.height * scaleY) + 24;
        if (x < 0) {
            w += x;
            x = 0;
        }
        if (y < 0) {
            h += y;
            y = 0;
        }
        if (x + w > image.getWidth()) {
            w = image.getWidth() - x;
        }
        if (y + h > image.getHeight()) {
            h = image.getHeight() - y;
        }
        if (w <= 0 || h <= 0) {
            return;
        }
        Graphics2D g2 = image.createGraphics();
        try {
            g2.setColor(Color.WHITE);
            g2.fillRect(x, y, w, h);
        }
        finally {
            g2.dispose();
        }
    }

    private void toggleWebToolbarForExport(boolean exporting) {
        if (!this.pageReady || this.webIshikawa == null) {
            return;
        }
        try {
            this.webIshikawa.getEngine().executeScript("window.__setExportMode && window.__setExportMode(" + (exporting ? "true" : "false") + ");");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String defaultExportFileName(String extension) {
        String base;
        String failure = this.trimToNull(this.resolveFailureDescription());
        String string = base = failure == null ? "ishikawa" : this.sanitizeFileName(failure.toLowerCase(Locale.ROOT));
        if (base == null || base.isBlank()) {
            base = "ishikawa";
        }
        String stamp = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss").format(LocalDateTime.now());
        return ExportFileNameUtil.suggestedName(base + "_" + stamp, "ishikawa_" + stamp, extension);
    }

    private File normalizeExportTarget(File selected, String extension, File baseDirectory) throws IOException {
        Path path = this.expandTilde(selected.toPath());
        if (!path.isAbsolute()) {
            Path base = baseDirectory != null ? baseDirectory.toPath() : this.preferredExportDirectory().toPath();
            path = base.resolve(path).normalize();
        } else {
            path = path.normalize();
        }
        Path parent = path.getParent();
        if (parent == null) {
            parent = this.preferredExportDirectory().toPath();
        }
        Files.createDirectories(parent, new FileAttribute[0]);
        String fileName = path.getFileName() == null ? "" : path.getFileName().toString();
        String lower = fileName.toLowerCase(Locale.ROOT);
        if (!lower.endsWith("." + extension.toLowerCase(Locale.ROOT))) {
            Object adjusted = fileName.isBlank() ? this.defaultExportFileName(extension) : fileName + "." + extension;
            path = parent.resolve((String)adjusted).normalize();
        }
        if (!Files.isWritable(parent)) {
            throw new IOException("Destination folder is not writable: " + String.valueOf(parent));
        }
        return path.toFile();
    }

    private Path expandTilde(Path path) {
        if (path == null) {
            return Paths.get(System.getProperty("user.home", "."), new String[0]);
        }
        String raw = path.toString();
        if (raw.equals("~")) {
            return Paths.get(System.getProperty("user.home", "."), new String[0]);
        }
        String marker = "~" + File.separator;
        if (raw.startsWith(marker)) {
            return Paths.get(System.getProperty("user.home", "."), new String[0]).resolve(raw.substring(marker.length()));
        }
        return path;
    }

    private File preferredExportDirectory() {
        return ExportDirectoryPreferences.getLastExportDirectory();
    }

    private void rememberExportDirectory(File directory) {
        ExportDirectoryPreferences.rememberExportDirectory(directory);
    }

    private String sanitizeFileName(String value) {
        if (value == null) {
            return null;
        }
        String sanitized = value.replaceAll("[\\\\/:*?\"<>|]+", " ").trim().replaceAll("\\s+", "_");
        return sanitized.isBlank() ? "ishikawa" : sanitized;
    }

    private void closeWindow() {
        Stage stage = this.ownerStage;
        if (stage == null && this.root != null && this.root.getScene() != null) {
            stage = (Stage)this.root.getScene().getWindow();
        }
        if (stage != null) {
            stage.close();
        }
    }

    private void applyDefaultTooltips() {
        this.ensureTooltip(this.btnSaveOnly, "Save");
        this.ensureTooltip(this.btnSaveExit, "Save and close");
        this.ensureTooltip(this.btnAddCause, "Add row");
        this.ensureTooltip(this.btnDeleteCause, "Remove selected row");
    }

    private void ensureTooltip(Button button, String fallbackText) {
        if (button == null) {
            return;
        }
        Tooltip tooltip = button.getTooltip();
        if (tooltip == null || tooltip.getText() == null || tooltip.getText().isBlank()) {
            button.setTooltip(new Tooltip(fallbackText));
        }
    }

    private void loadIcons() {
        this.icSave = this.loadIcon("save", 18.0);
        this.icExit = this.loadIcon("exit", 18.0);
        this.icPlus = this.loadIcon("plus", 14.0);
        this.icTrash = this.loadIcon("trash", 14.0);
    }

    private javafx.scene.image.Image loadIcon(String name, double size) {
        InputStream stream = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        if (stream == null) {
            return null;
        }
        return new javafx.scene.image.Image(stream, size, size, true, true);
    }

    private ImageView icon(javafx.scene.image.Image image, double size) {
        if (image == null) {
            return null;
        }
        ImageView view = new ImageView(image);
        view.setPreserveRatio(true);
        view.setFitWidth(size);
        view.setFitHeight(size);
        view.setSmooth(true);
        return view;
    }

    private static final class IshikawaRow {
        private final StringProperty method = new SimpleStringProperty((Object)this, "method", "");
        private final StringProperty machine = new SimpleStringProperty((Object)this, "machine", "");
        private final StringProperty measurements = new SimpleStringProperty((Object)this, "measurements", "");
        private final StringProperty environment = new SimpleStringProperty((Object)this, "environment", "");
        private final StringProperty material = new SimpleStringProperty((Object)this, "material", "");
        private final StringProperty manpower = new SimpleStringProperty((Object)this, "manpower", "");

        private IshikawaRow() {
            this("", "", "", "", "", "");
        }

        private IshikawaRow(String method, String machine, String measurements, String environment, String material, String manpower) {
            this.setMethod(method);
            this.setMachine(machine);
            this.setMeasurements(measurements);
            this.setEnvironment(environment);
            this.setMaterial(material);
            this.setManpower(manpower);
        }

        public StringProperty methodProperty() {
            return this.method;
        }

        public StringProperty machineProperty() {
            return this.machine;
        }

        public StringProperty measurementsProperty() {
            return this.measurements;
        }

        public StringProperty environmentProperty() {
            return this.environment;
        }

        public StringProperty materialProperty() {
            return this.material;
        }

        public StringProperty manpowerProperty() {
            return this.manpower;
        }

        public String getMethod() {
            return (String)this.method.get();
        }

        public String getMachine() {
            return (String)this.machine.get();
        }

        public String getMeasurements() {
            return (String)this.measurements.get();
        }

        public String getEnvironment() {
            return (String)this.environment.get();
        }

        public String getMaterial() {
            return (String)this.material.get();
        }

        public String getManpower() {
            return (String)this.manpower.get();
        }

        public void setMethod(String value) {
            this.method.set((Object)(value == null ? "" : value));
        }

        public void setMachine(String value) {
            this.machine.set((Object)(value == null ? "" : value));
        }

        public void setMeasurements(String value) {
            this.measurements.set((Object)(value == null ? "" : value));
        }

        public void setEnvironment(String value) {
            this.environment.set((Object)(value == null ? "" : value));
        }

        public void setMaterial(String value) {
            this.material.set((Object)(value == null ? "" : value));
        }

        public void setManpower(String value) {
            this.manpower.set((Object)(value == null ? "" : value));
        }
    }

    public final class IshikawaHostBridge {
        final /* synthetic */ IshikawaWindowController this$0;

        public IshikawaHostBridge(IshikawaWindowController this$0) {
            IshikawaWindowController ishikawaWindowController = this$0;
            Objects.requireNonNull(ishikawaWindowController);
            this.this$0 = ishikawaWindowController;
        }

        public void exportDiagram(String format) {
            Platform.runLater(() -> this.this$0.exportDiagram(format));
        }
    }

    private static final class ToolbarRect {
        private final double x;
        private final double y;
        private final double width;
        private final double height;
        private final double viewportWidth;
        private final double viewportHeight;

        private ToolbarRect(double x, double y, double width, double height, double viewportWidth, double viewportHeight) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.viewportWidth = viewportWidth;
            this.viewportHeight = viewportHeight;
        }
    }
}

