/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.CoreTools;
import com.qualidadeeprodutividade.controlPlan.ControlPlan;
import com.qualidadeeprodutividade.controllers.ControlPlanWindowController;
import com.qualidadeeprodutividade.controllers.DfmeaWindowController;
import com.qualidadeeprodutividade.controllers.DocImportController;
import com.qualidadeeprodutividade.controllers.EightDWindowController;
import com.qualidadeeprodutividade.controllers.PfmeaWindowController;
import com.qualidadeeprodutividade.controllers.ProcessTreeManagerController;
import com.qualidadeeprodutividade.controllers.ProductTreeManagerController;
import com.qualidadeeprodutividade.controllers.util.DocumentCloneUtils;
import com.qualidadeeprodutividade.eightd.EightD;
import com.qualidadeeprodutividade.eightd.EightDImage;
import com.qualidadeeprodutividade.eightd.EightDImageStorage;
import com.qualidadeeprodutividade.excelimport.ImportReport;
import com.qualidadeeprodutividade.excelimport.ImportService;
import com.qualidadeeprodutividade.export.ExportDirectoryPreferences;
import com.qualidadeeprodutividade.export.ExportLogoDialog;
import com.qualidadeeprodutividade.fmea.ConfidentialityLevel;
import com.qualidadeeprodutividade.fmea.Dfmea;
import com.qualidadeeprodutividade.fmea.Pfmea;
import com.qualidadeeprodutividade.io.XmlIO;
import com.qualidadeeprodutividade.item.Item;
import com.qualidadeeprodutividade.item.ItemType;
import com.qualidadeeprodutividade.platform.AppPaths;
import com.qualidadeeprodutividade.processItem.ProcessItem;
import com.qualidadeeprodutividade.processItem.ProcessType;
import com.qualidadeeprodutividade.project.Project;
import com.qualidadeeprodutividade.project.ProjectStatus;
import jakarta.xml.bind.JAXBException;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import javafx.util.converter.LocalDateStringConverter;

public class MainWindowController
implements Initializable {
    private static final DateTimeFormatter ISO = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final LocalDateStringConverter DATE_Converter = new LocalDateStringConverter(ISO, ISO);
    private static final String LOCK_IN_USE_MESSAGE = "This project is currently being edited by another user. Please try again later.";
    private static final String DEMO_FILE_NAME = "CoreTools-Demo-Bicycle.xml";
    @FXML
    private Parent root;
    @FXML
    private Stage stage;
    @FXML
    private TreeView<Object> projectTree;
    @FXML
    private TableView<PropertyRow> detailsTable;
    @FXML
    private TableColumn<PropertyRow, String> colField;
    @FXML
    private TableColumn<PropertyRow, String> colValue;
    @FXML
    private MenuItem mnuNew;
    @FXML
    private MenuItem mnuOpen;
    @FXML
    private MenuItem mnuSave;
    @FXML
    private MenuItem mnuSaveAs;
    @FXML
    private MenuItem mnuClose;
    @FXML
    private MenuItem mnuExportLogo;
    @FXML
    private MenuItem mnuQuit;
    @FXML
    private MenuItem mnuImportExcel;
    @FXML
    private MenuItem mnuImportDocuments;
    @FXML
    private MenuItem mnuExportImportTemplate;
    @FXML
    private MenuItem mnuHelp;
    @FXML
    private MenuItem mnuAbout;
    private ObservableList<PropertyRow> currentRows = FXCollections.observableArrayList();
    private final BooleanProperty dirty = new SimpleBooleanProperty(false);
    private File currentFile;
    private Project currentProject = new Project();
    private Image projectImg;
    private Image productImg;
    private Image processImg;
    private Image dfmeaImg;
    private Image pfmeaImg;
    private Image controlplanImg;
    private Image eightDImg;
    private Image plusImg;
    private Image trashImg;
    private Path currentLockPath;
    private Path userDemoDirectory;
    private final Thread lockCleanupHook;
    private static final String APP_NAME = "CoreTools";
    private static final String APP_SITE = "https://www.qualidadeprodutividade.com";
    private static final String APP_AUTHOR = "Qualidade e Produtividade Treinamentos e Consultoria. All rights reserved.";
    private static final String APP_COPY = String.valueOf(Year.now()) + " Qualidade e Produtividade Treinamentos e Consultoria. All rights reserved.";
    private static final StringConverter<ItemType> ITEMTYPE_Converter = new StringConverter<ItemType>(){

        public String toString(ItemType t) {
            return t == null ? "" : t.toString();
        }

        public ItemType fromString(String s) {
            if (s == null || s.isBlank()) {
                return null;
            }
            for (ItemType it : ItemType.values()) {
                if (!it.toString().equalsIgnoreCase(s) && !it.name().equalsIgnoreCase(s)) continue;
                return it;
            }
            try {
                return ItemType.valueOf(s.trim().toUpperCase());
            }
            catch (Exception ex) {
                return null;
            }
        }
    };
    private static final StringConverter<ProjectStatus> STATUS_Converter = new StringConverter<ProjectStatus>(){

        public String toString(ProjectStatus st) {
            return st == null ? "" : st.toString();
        }

        public ProjectStatus fromString(String s) {
            if (s == null || s.isBlank()) {
                return null;
            }
            for (ProjectStatus ps : ProjectStatus.values()) {
                if (!ps.toString().equalsIgnoreCase(s) && !ps.getDescription().equalsIgnoreCase(s)) continue;
                return ps;
            }
            try {
                return ProjectStatus.valueOf(s.trim().toUpperCase());
            }
            catch (Exception ex) {
                return null;
            }
        }
    };
    private static final StringConverter<ConfidentialityLevel> CONFIDENTIALITY_Converter = new StringConverter<ConfidentialityLevel>(){

        public String toString(ConfidentialityLevel level) {
            return level == null ? "" : level.toString();
        }

        public ConfidentialityLevel fromString(String string) {
            if (string == null || string.isBlank()) {
                return ConfidentialityLevel.INTERNAL;
            }
            String normalized = string.trim();
            for (ConfidentialityLevel lvl : ConfidentialityLevel.values()) {
                if (!lvl.toString().equalsIgnoreCase(normalized) && !lvl.name().equalsIgnoreCase(normalized)) continue;
                return lvl;
            }
            try {
                return ConfidentialityLevel.valueOf(normalized.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                return ConfidentialityLevel.INTERNAL;
            }
        }
    };
    private final InvalidationListener markDirtyListener = obs -> {
        if (!this.dirty.get()) {
            this.setDirty(true);
        }
        this.updateWindowTitle();
    };
    private final ListChangeListener<Object> listDirtyListener = ch -> {
        if (!this.dirty.get()) {
            this.setDirty(true);
        }
        this.updateWindowTitle();
    };

    public MainWindowController() {
        this.lockCleanupHook = new Thread(this::releaseLockQuietly, "coretools-lock-cleanup");
        Runtime.getRuntime().addShutdownHook(this.lockCleanupHook);
    }

    private Image loadImg(String name) {
        InputStream is = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        return is == null ? null : new Image(is);
    }

    private void initIcons() {
        this.projectImg = this.loadImg("project");
        this.productImg = this.loadImg("product");
        this.processImg = this.loadImg("process");
        this.dfmeaImg = this.loadImg("fmea");
        this.pfmeaImg = this.loadImg("fmea");
        this.controlplanImg = this.loadImg("controlplan");
        this.eightDImg = this.loadImg("eight_d");
        this.plusImg = this.loadImg("plus");
        this.trashImg = this.loadImg("trash");
    }

    private Path lockPathFor(File xmlFile) {
        String lockFileName = xmlFile.getName() + ".lock";
        return xmlFile.toPath().resolveSibling(lockFileName);
    }

    private Path userCoreToolsDirectory() {
        return AppPaths.applicationDataDirectory();
    }

    private Path userDemoDirectory() {
        return this.userCoreToolsDirectory().resolve("demos");
    }

    private Path userDemoPath() {
        return this.userDemoDirectory().resolve(DEMO_FILE_NAME);
    }

    private void addDemoCandidates(List<Path> candidates, Path baseDir) {
        if (baseDir == null) {
            return;
        }
        Path normalizedBaseDir = baseDir.toAbsolutePath().normalize();
        candidates.add(normalizedBaseDir.resolve(DEMO_FILE_NAME));
        candidates.add(normalizedBaseDir.resolve("lib").resolve(DEMO_FILE_NAME));
        candidates.add(normalizedBaseDir.resolve("coretools").resolve(DEMO_FILE_NAME));
        Path parent = normalizedBaseDir.getParent();
        if (parent != null) {
            candidates.add(parent.resolve(DEMO_FILE_NAME).normalize());
            candidates.add(parent.resolve("lib").resolve(DEMO_FILE_NAME).normalize());
            candidates.add(parent.resolve("coretools").resolve(DEMO_FILE_NAME).normalize());
            Path grandParent = parent.getParent();
            if (grandParent != null) {
                candidates.add(grandParent.resolve(DEMO_FILE_NAME).normalize());
                candidates.add(grandParent.resolve("coretools").resolve(DEMO_FILE_NAME).normalize());
            }
        }
    }

    private Path resolvePackagedDemoPath() {
        ArrayList<Path> candidates = new ArrayList<Path>();
        this.addDemoCandidates(candidates, Path.of(System.getProperty("user.dir", "."), new String[0]));
        String appPathRaw = System.getProperty("jpackage.app-path");
        if (appPathRaw != null && !appPathRaw.isBlank()) {
            try {
                Path appPath = Path.of(appPathRaw, new String[0]).toAbsolutePath().normalize();
                Path binDir = appPath.getParent();
                if (binDir != null) {
                    this.addDemoCandidates(candidates, binDir);
                }
            }
            catch (IllegalArgumentException appPath) {
                // empty catch block
            }
        }
        try {
            URI codeLocation = CoreTools.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            Path location = Path.of(codeLocation).toAbsolutePath().normalize();
            Path baseDir = Files.isRegularFile(location, new LinkOption[0]) ? location.getParent() : location;
            this.addDemoCandidates(candidates, baseDir);
        }
        catch (IllegalArgumentException | URISyntaxException exception) {
            // empty catch block
        }
        for (Path candidate : candidates) {
            if (candidate == null || !Files.isRegularFile(candidate, new LinkOption[0])) continue;
            return candidate;
        }
        return null;
    }

    private void ensureUserDemoAvailable() {
        try {
            this.userDemoDirectory = this.userDemoDirectory();
            Files.createDirectories(this.userDemoDirectory, new FileAttribute[0]);
            Path target = this.userDemoPath();
            if (Files.isRegularFile(target, new LinkOption[0])) {
                return;
            }
            Path packagedDemo = this.resolvePackagedDemoPath();
            if (packagedDemo != null) {
                Files.copy(packagedDemo, target, new CopyOption[0]);
                return;
            }
            try (InputStream in = this.getClass().getResourceAsStream("/CoreTools-Demo-Bicycle.xml");){
                if (in != null) {
                    Files.copy(in, target, new CopyOption[0]);
                }
            }
        }
        catch (IOException | IllegalArgumentException | SecurityException ex) {
            System.err.println("Failed to prepare user demo file: " + ex.getMessage());
        }
    }

    private File preferredProjectOpenDirectory() {
        if (this.currentFile != null && this.currentFile.getParentFile() != null && this.currentFile.getParentFile().isDirectory()) {
            return this.currentFile.getParentFile();
        }
        if (this.userDemoDirectory != null && Files.isDirectory(this.userDemoDirectory, new LinkOption[0])) {
            return this.userDemoDirectory.toFile();
        }
        Path home = Path.of(System.getProperty("user.home", "."), new String[0]);
        if (Files.isDirectory(home, new LinkOption[0])) {
            return home.toFile();
        }
        return null;
    }

    private Path userLockPathFor(File xmlFile) {
        Path projectPath = xmlFile.toPath().toAbsolutePath().normalize();
        String projectId = UUID.nameUUIDFromBytes(projectPath.toString().getBytes(StandardCharsets.UTF_8)).toString();
        String lockFileName = xmlFile.getName() + "." + projectId + ".lock";
        return AppPaths.locksDirectory().resolve(lockFileName);
    }

    private Path importReportPathFor(File sourceFile) {
        return sourceFile.toPath().resolveSibling(sourceFile.getName() + ".import-report.txt");
    }

    private Path userImportReportPathFor(File sourceFile) {
        Path sourcePath = sourceFile.toPath().toAbsolutePath().normalize();
        String sourceId = UUID.nameUUIDFromBytes(sourcePath.toString().getBytes(StandardCharsets.UTF_8)).toString();
        String reportName = sourceFile.getName() + "." + sourceId + ".import-report.txt";
        return AppPaths.reportsDirectory().resolve(reportName);
    }

    private Path writeImportReport(File sourceFile, String reportText) throws IOException {
        Path nearSource = this.importReportPathFor(sourceFile);
        try {
            Files.writeString(nearSource, (CharSequence)reportText, new OpenOption[0]);
            return nearSource;
        }
        catch (AccessDeniedException e) {
            Path userReportPath = this.userImportReportPathFor(sourceFile);
            Files.createDirectories(userReportPath.getParent(), new FileAttribute[0]);
            Files.writeString(userReportPath, (CharSequence)reportText, new OpenOption[0]);
            return userReportPath;
        }
    }

    private Path tryCreateLock(File xmlFile) throws IOException {
        Path lockPath = this.lockPathFor(xmlFile);
        try {
            Files.createFile(lockPath, new FileAttribute[0]);
            return lockPath;
        }
        catch (FileAlreadyExistsException e) {
            return null;
        }
        catch (AccessDeniedException e) {
            Path userLockPath = this.userLockPathFor(xmlFile);
            try {
                Files.createDirectories(userLockPath.getParent(), new FileAttribute[0]);
                Files.createFile(userLockPath, new FileAttribute[0]);
                return userLockPath;
            }
            catch (FileAlreadyExistsException ignored) {
                return null;
            }
        }
    }

    private void deleteLockFile(Path lockPath) {
        if (lockPath == null) {
            return;
        }
        try {
            Files.deleteIfExists(lockPath);
        }
        catch (IOException ex) {
            System.err.println("Failed to delete lock file " + String.valueOf(lockPath) + ": " + ex.getMessage());
        }
    }

    private synchronized void releaseCurrentLock() {
        if (this.currentLockPath == null) {
            return;
        }
        this.deleteLockFile(this.currentLockPath);
        this.currentLockPath = null;
    }

    private void releaseLockQuietly() {
        this.releaseCurrentLock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String appVersion() {
        try {
            String v = CoreTools.class.getPackage().getImplementationVersion();
            if (v != null && !v.isBlank()) {
                return v;
            }
        }
        catch (Throwable v) {
            // empty catch block
        }
        try (InputStream in = MainWindowController.class.getResourceAsStream("/app.properties");){
            if (in == null) return "dev";
            Properties p = new Properties();
            p.load(in);
            String v = p.getProperty("app.version");
            if (v == null) return "dev";
            if (v.isBlank()) return "dev";
            String string = v;
            return string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "dev";
    }

    private static void openLink(String url) {
        try {
            MainWindowController.openInSystemBrowser(new URI(url));
        }
        catch (IllegalArgumentException | URISyntaxException exception) {
            // empty catch block
        }
    }

    @FXML
    private void onHelp() {
        URL helpUrl = CoreTools.class.getResource("/html/CoreTools_Users_Guide.html");
        if (helpUrl == null) {
            this.showHelpError("Help file not found inside application resources.");
            return;
        }
        try {
            URI targetUri;
            if ("file".equalsIgnoreCase(helpUrl.getProtocol())) {
                targetUri = helpUrl.toURI();
            } else {
                Path tempFile = Files.createTempFile("coretools-help-", ".html", new FileAttribute[0]);
                tempFile.toFile().deleteOnExit();
                try (InputStream in = helpUrl.openStream();
                     OutputStream out = Files.newOutputStream(tempFile, new OpenOption[0]);){
                    in.transferTo(out);
                }
                targetUri = tempFile.toUri();
            }
            String openError = MainWindowController.openInSystemBrowser(targetUri);
            if (openError != null) {
                throw new UnsupportedOperationException(openError);
            }
        }
        catch (IOException | UnsupportedOperationException | URISyntaxException ex) {
            String message = ex.getMessage();
            if (message == null || message.isBlank()) {
                message = ex.getClass().getSimpleName();
            }
            this.showHelpError(message);
        }
    }

    private static String openInSystemBrowser(URI targetUri) {
        if (targetUri == null) {
            return "Invalid help URL.";
        }
        String osName = System.getProperty("os.name", "").toLowerCase();
        String uri = targetUri.toString();
        if (osName.contains("linux")) {
            if (MainWindowController.launchOpenCommand("xdg-open", uri)) {
                return null;
            }
            if (MainWindowController.launchOpenCommand("gio", "open", uri)) {
                return null;
            }
            if (MainWindowController.launchOpenCommand("sensible-browser", uri)) {
                return null;
            }
            return "Could not find a browser launcher (xdg-open, gio, or sensible-browser).";
        }
        try {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(targetUri);
                return null;
            }
        }
        catch (IOException | SecurityException | UnsupportedOperationException exception) {
            // empty catch block
        }
        if (osName.contains("win")) {
            if (MainWindowController.launchOpenCommand("cmd", "/c", "start", "", uri)) {
                return null;
            }
            return "Unable to open the browser using Windows shell command.";
        }
        if (osName.contains("mac")) {
            if (MainWindowController.launchOpenCommand("open", uri)) {
                return null;
            }
            return "Unable to open the browser using macOS open command.";
        }
        return "Could not open the browser on this platform.";
    }

    private static boolean launchOpenCommand(String ... command) {
        try {
            new ProcessBuilder(command).start();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @FXML
    private void onExportLogoSettings() {
        Stage owner = this.stage != null ? this.stage : (this.root != null && this.root.getScene() != null ? this.root.getScene().getWindow() : null);
        ExportLogoDialog.prompt((Window)owner);
    }

    private void showHelpError(String details) {
        Stage owner;
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Help");
        alert.setHeaderText("Unable to open help contents.");
        alert.setContentText(details != null && !details.isBlank() ? details : "Unknown error.");
        Object object = this.stage != null ? this.stage : (owner = this.root != null && this.root.getScene() != null ? this.root.getScene().getWindow() : null);
        if (owner != null) {
            alert.initOwner((Window)owner);
        }
        alert.showAndWait();
    }

    @FXML
    private void onAbout() {
        String version = MainWindowController.appVersion();
        Label title = new Label("CoreTools v" + version);
        title.setStyle("-fx-font-size: 18px; -fx-font-weight: bold;");
        Label description = new Label("Software for managing Product Structures, Process Structures, FMEAs, and Control Plans.\nDeveloped by Fernando Ferrari Fernandes using Java Language.\n");
        description.setWrapText(true);
        description.setTextAlignment(TextAlignment.LEFT);
        description.setMaxWidth(Double.MAX_VALUE);
        description.setMinHeight(Double.NEGATIVE_INFINITY);
        Hyperlink site = new Hyperlink(APP_SITE);
        site.setOnAction(e -> MainWindowController.openLink(APP_SITE));
        URL iconUrl = this.getClass().getResource("/icons/icon.png");
        ImageView bigIcon = null;
        if (iconUrl != null) {
            bigIcon = new ImageView(new Image(iconUrl.toExternalForm(), 156.0, 156.0, true, true, true));
            bigIcon.setPreserveRatio(true);
            bigIcon.setSmooth(true);
        } else if (this.projectImg != null) {
            bigIcon = this.iv(this.projectImg, 128.0);
        }
        HBox header = new HBox(12.0);
        header.setAlignment(Pos.CENTER_LEFT);
        if (bigIcon != null) {
            header.getChildren().add((Object)bigIcon);
        }
        header.getChildren().add((Object)title);
        Label copyright = new Label(APP_COPY);
        VBox box = new VBox(12.0, new Node[]{header, description, site, new Separator(), copyright});
        box.setPadding(new Insets(12.0));
        box.setMinWidth(Double.NEGATIVE_INFINITY);
        box.setPrefWidth(550.0);
        Dialog about = new Dialog();
        about.setTitle("About");
        about.initModality(Modality.APPLICATION_MODAL);
        if (this.stage != null) {
            about.initOwner((Window)this.stage);
        }
        about.setResizable(false);
        DialogPane pane = about.getDialogPane();
        pane.setContent((Node)box);
        pane.setGraphic(null);
        pane.setHeaderText(null);
        ButtonType closeType = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
        pane.getButtonTypes().setAll((Object[])new ButtonType[]{closeType});
        pane.setMinWidth(550.0);
        pane.setPrefWidth(600.0);
        pane.setMinHeight(360.0);
        pane.setPrefHeight(420.0);
        Button closeBtn = (Button)pane.lookupButton(closeType);
        if (closeBtn != null) {
            Image exitIcon = this.loadImg("exit");
            if (exitIcon != null) {
                closeBtn.setGraphic((Node)this.iv(exitIcon, 16.0));
            }
            closeBtn.setOnAction(evt -> about.close());
            closeBtn.setDefaultButton(true);
        }
        description.prefWidthProperty().bind((ObservableValue)pane.widthProperty().subtract(40));
        about.setOnShown(evt -> {
            Stage dlgStage = (Stage)pane.getScene().getWindow();
            if (dlgStage != null) {
                dlgStage.setResizable(false);
                if (iconUrl != null) {
                    dlgStage.getIcons().setAll((Object[])new Image[]{new Image(iconUrl.toExternalForm())});
                }
                dlgStage.sizeToScene();
                if (dlgStage.getHeight() < 420.0) {
                    dlgStage.setHeight(420.0);
                }
                dlgStage.centerOnScreen();
            }
        });
        about.showAndWait();
    }

    public ImageView iv(Image img, double size) {
        if (img == null) {
            return null;
        }
        ImageView v = new ImageView(img);
        v.setFitWidth(size);
        v.setFitHeight(size);
        v.setPreserveRatio(true);
        return v;
    }

    private static String safeText(String s) {
        return s == null ? "" : s;
    }

    public BooleanProperty dirtyProperty() {
        return this.dirty;
    }

    public boolean isDirty() {
        return this.dirty.get();
    }

    public void setDirty(boolean v) {
        this.dirty.set(v);
        this.updateWindowTitle();
    }

    @FXML
    public void initialize(URL location, ResourceBundle resources) {
        this.root.sceneProperty().addListener((obsScene, oldScene, newScene) -> {
            if (newScene != null) {
                newScene.windowProperty().addListener((obsWin, oldWin, newWin) -> {
                    if (newWin != null) {
                        this.stage = (Stage)newWin;
                        this.stage.setOnCloseRequest(evt -> {
                            evt.consume();
                            this.showExitConfirmation(this.stage);
                        });
                        this.updateWindowTitle();
                    }
                });
            }
        });
        this.initIcons();
        this.ensureUserDemoAvailable();
        if (this.mnuNew != null) {
            this.mnuNew.setOnAction(e -> this.onNewProject());
        }
        if (this.mnuOpen != null) {
            this.mnuOpen.setOnAction(e -> this.onOpenProject());
        }
        if (this.mnuSave != null) {
            this.mnuSave.setOnAction(e -> this.onSaveProject());
        }
        if (this.mnuSaveAs != null) {
            this.mnuSaveAs.setOnAction(e -> this.onSaveProjectAs());
        }
        if (this.mnuClose != null) {
            this.mnuClose.setOnAction(e -> this.onCloseProject());
        }
        if (this.mnuExportLogo != null) {
            this.mnuExportLogo.setOnAction(e -> this.onExportLogoSettings());
        }
        if (this.mnuQuit != null) {
            this.mnuQuit.setOnAction(e -> this.exitApp());
        }
        if (this.mnuImportExcel != null) {
            this.mnuImportExcel.setOnAction(e -> this.onImportExcel());
        }
        if (this.mnuImportDocuments != null) {
            this.mnuImportDocuments.setOnAction(e -> this.onImportDocuments());
        }
        if (this.mnuExportImportTemplate != null) {
            this.mnuExportImportTemplate.setOnAction(e -> this.onExportImportTemplate());
        }
        if (this.mnuHelp != null) {
            this.mnuHelp.setOnAction(e -> this.onHelp());
        }
        if (this.mnuAbout != null) {
            this.mnuAbout.setOnAction(e -> this.onAbout());
        }
        TreeItem treeRoot = new TreeItem((Object)this.currentProject);
        treeRoot.setExpanded(true);
        treeRoot.getChildren().addAll((Object[])new TreeItem[]{new TreeItem((Object)"Product Trees"), new TreeItem((Object)"Process Trees"), new TreeItem((Object)"DFMEAs"), new TreeItem((Object)"PFMEAs"), new TreeItem((Object)"Control Plans"), new TreeItem((Object)"8D Report")});
        this.projectTree.setRoot(treeRoot);
        this.projectTree.setShowRoot(true);
        this.projectTree.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.setProjectIntoUI(this.currentProject);
        this.projectTree.setCellFactory(tv -> new TreeCell<Object>(this){
            private Project listeningProject;
            private ChangeListener<String> nameListener;
            private final MenuItem miInsert;
            private final MenuItem miDuplicate;
            private final MenuItem miDelete;
            private final ContextMenu ctx;
            final /* synthetic */ MainWindowController this$0;
            {
                MainWindowController mainWindowController = this$0;
                Objects.requireNonNull(mainWindowController);
                this.this$0 = mainWindowController;
                this.listeningProject = null;
                this.nameListener = null;
                this.miInsert = new MenuItem("Insert new");
                this.miDuplicate = new MenuItem("Duplicate");
                this.miDelete = new MenuItem("Delete");
                this.ctx = new ContextMenu(new MenuItem[]{this.miInsert, this.miDuplicate, this.miDelete});
                this.miInsert.setOnAction(e -> {
                    TreeItem node = this.getTreeItem();
                    if (node == null) {
                        return;
                    }
                    TreeItem section = node.getParent();
                    if (section == null) {
                        return;
                    }
                    this.this$0.onSectionAdd((TreeItem<Object>)section);
                    ObservableList children = section.getChildren();
                    if (!children.isEmpty()) {
                        this.this$0.projectTree.getSelectionModel().select((Object)((TreeItem)children.get(children.size() - 1)));
                    }
                    this.this$0.setDirty(true);
                });
                this.miDuplicate.setOnAction(e -> {
                    TreeItem node = this.getTreeItem();
                    if (node == null) {
                        return;
                    }
                    this.this$0.projectTree.getSelectionModel().select((Object)node);
                    this.this$0.duplicateSectionChild((TreeItem<Object>)node);
                    this.this$0.setDirty(true);
                });
                this.miDelete.setOnAction(e -> {
                    TreeItem node = this.getTreeItem();
                    if (node == null) {
                        return;
                    }
                    TreeItem section = node.getParent();
                    if (section == null) {
                        return;
                    }
                    this.this$0.projectTree.getSelectionModel().select((Object)node);
                    this.this$0.onSectionDelete((TreeItem<Object>)section);
                    this.this$0.setDirty(true);
                });
            }

            private int computeDepth(TreeItem<?> item) {
                int depth = 0;
                for (TreeItem parent = item.getParent(); parent != null; parent = parent.getParent()) {
                    ++depth;
                }
                return depth;
            }

            private boolean isEditableChildNode(TreeItem<Object> node) {
                if (node == null) {
                    return false;
                }
                Object value = node.getValue();
                if (value instanceof Project) {
                    return false;
                }
                if (value instanceof String) {
                    return false;
                }
                return this.computeDepth(node) >= 2;
            }

            protected void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                this.setStyle("");
                if (this.listeningProject != null && this.nameListener != null) {
                    this.listeningProject.nameProperty().removeListener(this.nameListener);
                    this.listeningProject = null;
                    this.nameListener = null;
                }
                if (empty || item == null) {
                    this.setText(null);
                    this.setGraphic(null);
                    this.setContentDisplay(ContentDisplay.LEFT);
                    return;
                }
                Object object = item;
                Objects.requireNonNull(object);
                Object object2 = object;
                int n = 0;
                block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Project.class, Item.class, ProcessItem.class, Dfmea.class, Pfmea.class, ControlPlan.class, EightD.class, String.class}, (Object)object2, n)) {
                    case 0: {
                        Project p = (Project)object2;
                        this.setGraphic((Node)this.this$0.iv(this.this$0.projectImg, 45.0));
                        this.setStyle("-fx-font-weight: bold; -fx-font-size: 16px;");
                        this.setText("Project: " + p.getName());
                        this.setContentDisplay(ContentDisplay.LEFT);
                        this.nameListener = (obs, oldV, newV) -> this.setText("Project: " + newV);
                        p.nameProperty().addListener(this.nameListener);
                        this.listeningProject = p;
                        break;
                    }
                    case 1: {
                        Item i = (Item)object2;
                        this.setStyle("");
                        this.setText(i.getDescription() != null ? i.getDescription() : "Item");
                        this.setGraphic((Node)this.this$0.iv(this.this$0.productImg, 36.0));
                        this.setContentDisplay(ContentDisplay.LEFT);
                        break;
                    }
                    case 2: {
                        ProcessItem pi = (ProcessItem)object2;
                        this.setStyle("");
                        this.setText(pi.getDescription() != null ? pi.getDescription() : "Process");
                        this.setGraphic((Node)this.this$0.iv(this.this$0.processImg, 36.0));
                        this.setContentDisplay(ContentDisplay.LEFT);
                        break;
                    }
                    case 3: {
                        Dfmea dfi = (Dfmea)object2;
                        this.setStyle("");
                        this.setText(dfi.getDfmeaSubject() != null ? dfi.getDfmeaSubject() : "DFMEA");
                        this.setGraphic((Node)this.this$0.iv(this.this$0.dfmeaImg, 36.0));
                        this.setContentDisplay(ContentDisplay.LEFT);
                        break;
                    }
                    case 4: {
                        Pfmea pfi = (Pfmea)object2;
                        this.setStyle("");
                        this.setText(pfi.getPfmeaSubject() != null ? pfi.getPfmeaSubject() : "PFMEA");
                        this.setGraphic((Node)this.this$0.iv(this.this$0.pfmeaImg, 36.0));
                        this.setContentDisplay(ContentDisplay.LEFT);
                        break;
                    }
                    case 5: {
                        ControlPlan cp = (ControlPlan)object2;
                        this.setStyle("");
                        String cpLabel = MainWindowController.safeText(cp.getCpPartNumber());
                        if (cpLabel.isBlank()) {
                            cpLabel = MainWindowController.safeText(cp.getCpPartName());
                        }
                        if (cpLabel.isBlank()) {
                            cpLabel = MainWindowController.safeText(cp.getCpNumber());
                        }
                        if (cpLabel.isBlank()) {
                            cpLabel = "Control Plan";
                        }
                        this.setText(cpLabel);
                        this.setGraphic((Node)this.this$0.iv(this.this$0.controlplanImg, 36.0));
                        this.setContentDisplay(ContentDisplay.LEFT);
                        break;
                    }
                    case 6: {
                        EightD report = (EightD)object2;
                        this.setStyle("");
                        String label = MainWindowController.safeText(report.getInternalClaimNumber());
                        if (label.isBlank()) {
                            label = MainWindowController.safeText(report.getCustomerClaimNumber());
                        }
                        if (label.isBlank()) {
                            label = MainWindowController.safeText(report.getPartNumber());
                        }
                        if (label.isBlank()) {
                            label = "8D Report";
                        }
                        this.setText(label);
                        this.setGraphic((Node)this.this$0.iv(this.this$0.eightDImg, 36.0));
                        this.setContentDisplay(ContentDisplay.LEFT);
                        break;
                    }
                    case 7: {
                        String s;
                        ImageView icon = switch (s = (String)object2) {
                            case "Product Trees" -> this.this$0.iv(this.this$0.productImg, 40.0);
                            case "Process Trees" -> this.this$0.iv(this.this$0.processImg, 40.0);
                            case "DFMEAs" -> this.this$0.iv(this.this$0.dfmeaImg, 40.0);
                            case "PFMEAs" -> this.this$0.iv(this.this$0.pfmeaImg, 40.0);
                            case "Control Plans" -> this.this$0.iv(this.this$0.controlplanImg, 40.0);
                            case "8D Report" -> this.this$0.iv(this.this$0.eightDImg, 40.0);
                            default -> null;
                        };
                        this.setText(s);
                        this.setContentDisplay(ContentDisplay.LEFT);
                        switch (s) {
                            case "Product Trees": 
                            case "Process Trees": 
                            case "DFMEAs": 
                            case "PFMEAs": 
                            case "Control Plans": 
                            case "8D Report": {
                                this.setText(null);
                                this.setContentDisplay(ContentDisplay.LEFT);
                                HBox content = new HBox(2.0);
                                content.setAlignment(Pos.CENTER_LEFT);
                                if (icon != null) {
                                    content.getChildren().add((Object)icon);
                                }
                                Label lbl = new Label(s);
                                lbl.setStyle("-fx-font-weight: bold;");
                                Region spacer = new Region();
                                HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                                Button btnAdd = this.this$0.mkMiniBtn(this.this$0.plusImg, "+", "Add new item", (EventHandler<ActionEvent>)((EventHandler)e -> this.this$0.onSectionAdd((TreeItem<Object>)this.getTreeItem())));
                                Button btnDel = this.this$0.mkMiniBtn(this.this$0.trashImg, "x", "Delete selected", (EventHandler<ActionEvent>)((EventHandler)e -> this.this$0.onSectionDelete((TreeItem<Object>)this.getTreeItem())));
                                btnDel.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                                    TreeItem sel = (TreeItem)this.this$0.projectTree.getSelectionModel().getSelectedItem();
                                    return sel == null || sel.getParent() != this.getTreeItem();
                                }, (Observable[])new Observable[]{this.this$0.projectTree.getSelectionModel().selectedItemProperty()}));
                                content.getChildren().addAll((Object[])new Node[]{lbl, spacer, btnAdd, btnDel});
                                this.setGraphic((Node)content);
                                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                                break block0;
                            }
                        }
                        this.setText(s);
                        this.setGraphic((Node)icon);
                        this.setContentDisplay(ContentDisplay.LEFT);
                        break;
                    }
                    default: {
                        this.setGraphic(null);
                    }
                }
                if (!empty && this.isEditableChildNode((TreeItem<Object>)this.getTreeItem())) {
                    this.setContextMenu(this.ctx);
                } else {
                    this.setContextMenu(null);
                }
            }
        });
        this.projectTree.setOnMouseClicked(ev -> {
            Item it;
            if (ev.getClickCount() != 2) {
                return;
            }
            TreeItem sel = (TreeItem)this.projectTree.getSelectionModel().getSelectedItem();
            if (sel == null) {
                return;
            }
            Object val = sel.getValue();
            if (val == null) {
                return;
            }
            if (val instanceof Item && (it = (Item)val).getType() == ItemType.PRODUCT) {
                this.openProductTreeManager(it);
            } else if (val instanceof ProcessItem) {
                ProcessItem process = (ProcessItem)val;
                this.openProcessTreeManager(process);
            } else if (val instanceof Dfmea) {
                Dfmea dfmea = (Dfmea)val;
                this.openDfmeaWindow(dfmea);
            } else if (val instanceof Pfmea) {
                Pfmea pfmea = (Pfmea)val;
                this.openPfmeaWindow(pfmea);
            } else if (val instanceof ControlPlan) {
                ControlPlan controlPlan = (ControlPlan)val;
                this.openControlPlanWindow(controlPlan);
            } else if (val instanceof EightD) {
                EightD report = (EightD)val;
                this.openEightDWindow(report);
            }
        });
        this.colField.setCellValueFactory(c -> ((PropertyRow)c.getValue()).labelProperty());
        this.colField.setEditable(false);
        this.colField.setCellFactory(col -> new TableCell<PropertyRow, String>(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void updateItem(String item, boolean empty) {
                boolean isFunction;
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                    this.setAlignment(Pos.CENTER_LEFT);
                    this.setStyle("");
                    return;
                }
                this.setText(item == null ? "" : item);
                boolean bl = isFunction = item != null && "Function".equalsIgnoreCase(item);
                if (isFunction) {
                    this.setAlignment(Pos.TOP_LEFT);
                    this.setStyle("-fx-alignment: top-left;");
                } else {
                    this.setAlignment(Pos.CENTER_LEFT);
                    this.setStyle("");
                }
            }
        });
        this.colValue.setCellValueFactory(c -> ((PropertyRow)c.getValue()).valueProperty());
        boolean allowEdit = true;
        this.detailsTable.setEditable(allowEdit);
        this.colField.setEditable(false);
        this.colValue.setEditable(allowEdit);
        this.colValue.setCellFactory(col -> new TextFieldTableCell<PropertyRow, String>(this, (StringConverter)new DefaultStringConverter()){
            private final DatePicker datePicker;
            private final Text measurer;
            private final Text multilineDisplay;
            private TextArea multilineEditor;
            final /* synthetic */ MainWindowController this$0;
            {
                MainWindowController mainWindowController = this$0;
                Objects.requireNonNull(mainWindowController);
                this.this$0 = mainWindowController;
                super(arg0);
                this.datePicker = new DatePicker();
                this.measurer = new Text();
                this.multilineDisplay = new Text();
                this.datePicker.setEditable(false);
                this.datePicker.valueProperty().addListener((obs, oldVal, newVal) -> this.pushDatePickerValue());
                this.multilineDisplay.wrappingWidthProperty().bind((ObservableValue)col.widthProperty().subtract(16));
            }

            private void pushDatePickerValue() {
                int rowIndex = this.getIndex();
                ObservableList items = this.getTableView().getItems();
                if (rowIndex < 0 || rowIndex >= items.size()) {
                    return;
                }
                PropertyRow propertyRow = (PropertyRow)items.get(rowIndex);
                if (propertyRow == null) {
                    return;
                }
                LocalDate picked = (LocalDate)this.datePicker.getValue();
                String asText = picked == null ? "" : DATE_Converter.toString(picked);
                propertyRow.valueProperty().set((Object)asText);
                this.this$0.setDirty(true);
            }

            private void adjustMultilineDisplayHeight(String text) {
                String t = text == null || text.isEmpty() ? " " : text;
                double wrap = Math.max(60.0, this.getTableColumn().getWidth() - 16.0);
                this.measurer.setWrappingWidth(wrap);
                this.measurer.setText(t + "\n");
                double h = Math.ceil(this.measurer.getLayoutBounds().getHeight());
                double target = Math.max(28.0, h + 6.0);
                this.setPrefHeight(target);
                this.setMinHeight(target);
                if (this.getTableRow() != null) {
                    this.getTableRow().setPrefHeight(target);
                    this.getTableRow().requestLayout();
                }
            }

            private void adjustMultilineEditorHeight() {
                if (this.multilineEditor == null) {
                    return;
                }
                String text = this.multilineEditor.getText();
                double wrap = Math.max(60.0, this.getTableColumn().getWidth() - 16.0);
                this.measurer.setWrappingWidth(wrap);
                this.measurer.setText((text == null || text.isEmpty() ? " " : text) + "\n");
                double h = Math.ceil(this.measurer.getLayoutBounds().getHeight());
                double target = Math.max(50.0, h + 6.0);
                this.multilineEditor.setPrefWidth(wrap);
                this.multilineEditor.setPrefHeight(target);
                this.setPrefHeight(target);
                this.setMinHeight(target);
                if (this.getTableRow() != null) {
                    this.getTableRow().setPrefHeight(target);
                    this.getTableRow().requestLayout();
                }
            }

            private void resetHeights() {
                this.setPrefHeight(-1.0);
                this.setMinHeight(-1.0);
                if (this.getTableRow() != null) {
                    this.getTableRow().setPrefHeight(-1.0);
                    this.getTableRow().requestLayout();
                }
            }

            public void startEdit() {
                Object object;
                PropertyRow pr = null;
                if (this.getTableRow() != null && (object = this.getTableRow().getItem()) instanceof PropertyRow) {
                    PropertyRow r;
                    pr = r = (PropertyRow)object;
                }
                if (pr == null || this.isEmpty()) {
                    return;
                }
                if (pr.editorKind() == PropertyRow.EditorKind.READ_ONLY) {
                    return;
                }
                if (pr.editorKind() == PropertyRow.EditorKind.TEXT) {
                    super.startEdit();
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    return;
                }
                if (pr.editorKind() == PropertyRow.EditorKind.MULTILINE) {
                    super.startEdit();
                    if (!this.isEditing()) {
                        return;
                    }
                    if (this.multilineEditor == null) {
                        this.multilineEditor = new TextArea();
                        this.multilineEditor.setWrapText(true);
                        this.multilineEditor.setPrefRowCount(3);
                        this.multilineEditor.textProperty().addListener((o, ov, nv) -> this.adjustMultilineEditorHeight());
                        this.multilineEditor.focusedProperty().addListener((o, was, isNow) -> {
                            if (!isNow.booleanValue() && this.isEditing()) {
                                this.commitEdit(this.multilineEditor.getText());
                            }
                        });
                    }
                    this.multilineEditor.setText((String)this.getItem());
                    this.adjustMultilineEditorHeight();
                    this.setGraphic((Node)this.multilineEditor);
                    this.setText(null);
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    Platform.runLater(() -> {
                        this.multilineEditor.requestFocus();
                        this.multilineEditor.positionCaret(this.multilineEditor.getText().length());
                    });
                }
            }

            public void cancelEdit() {
                Object object;
                boolean wasMultiline = false;
                if (this.getTableRow() != null && (object = this.getTableRow().getItem()) instanceof PropertyRow) {
                    PropertyRow r = (PropertyRow)object;
                    wasMultiline = r.editorKind() == PropertyRow.EditorKind.MULTILINE;
                }
                super.cancelEdit();
                if (wasMultiline) {
                    this.multilineDisplay.setText((String)this.getItem());
                    this.adjustMultilineDisplayHeight((String)this.getItem());
                    this.setGraphic((Node)this.multilineDisplay);
                    this.setText(null);
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                } else {
                    this.setGraphic(null);
                    this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                }
            }

            public void updateItem(String item, boolean empty) {
                ComboBox combo;
                Object object;
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setGraphic(null);
                    this.setText(null);
                    return;
                }
                PropertyRow propertyRow = null;
                if (this.getTableRow() != null && (object = this.getTableRow().getItem()) instanceof PropertyRow) {
                    PropertyRow pr;
                    propertyRow = pr = (PropertyRow)object;
                }
                if (propertyRow == null) {
                    this.setGraphic(null);
                    this.setText(item == null ? "" : item);
                    return;
                }
                PropertyRow.EditorKind kind = propertyRow.editorKind();
                if (kind == PropertyRow.EditorKind.READ_ONLY) {
                    this.setEditable(false);
                    this.setGraphic(null);
                    this.setText(item == null ? "" : item);
                    this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                    return;
                }
                this.setEditable(true);
                if (kind == PropertyRow.EditorKind.TEXT) {
                    if (this.isEditing()) {
                        return;
                    }
                    this.setGraphic(null);
                    this.setText(item == null ? "" : item);
                    this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                    return;
                }
                if (kind == PropertyRow.EditorKind.MULTILINE) {
                    if (this.isEditing()) {
                        return;
                    }
                    this.multilineDisplay.setText(item == null ? "" : item);
                    this.adjustMultilineDisplayHeight(item);
                    this.setGraphic((Node)this.multilineDisplay);
                    this.setText(null);
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    return;
                }
                if (kind == PropertyRow.EditorKind.DATE) {
                    if (item == null || item.isBlank()) {
                        this.datePicker.setValue(null);
                    } else {
                        try {
                            this.datePicker.setValue((Object)DATE_Converter.fromString(item));
                        }
                        catch (Exception ex) {
                            this.datePicker.setValue(null);
                        }
                    }
                    this.setGraphic((Node)this.datePicker);
                    this.setText(null);
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    this.setEditable(false);
                    return;
                }
                if (kind == PropertyRow.EditorKind.PROJECT_STATUS) {
                    combo = new ComboBox(FXCollections.observableArrayList((Object[])ProjectStatus.values()));
                    combo.setMaxWidth(Double.MAX_VALUE);
                    combo.setEditable(false);
                    combo.setConverter(STATUS_Converter);
                    ProjectStatus current = (ProjectStatus)((Object)STATUS_Converter.fromString((String)this.getItem()));
                    combo.setValue((Object)current);
                    PropertyRow rowRef = propertyRow;
                    combo.valueProperty().addListener((obs, oldVal, newVal) -> {
                        Object patt0$temp;
                        if (newVal == null) {
                            return;
                        }
                        String asString = STATUS_Converter.toString((Object)newVal);
                        rowRef.valueProperty().set((Object)asString);
                        TreeItem sel = (TreeItem)this.this$0.projectTree.getSelectionModel().getSelectedItem();
                        if (sel != null && (patt0$temp = sel.getValue()) instanceof Project) {
                            Project selectedProj = (Project)patt0$temp;
                            selectedProj.setStatus((ProjectStatus)((Object)newVal));
                        }
                        this.setText(asString);
                        this.setContentDisplay(ContentDisplay.LEFT);
                        this.this$0.setDirty(true);
                    });
                    this.setGraphic((Node)combo);
                    this.setText(null);
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    return;
                }
                if (kind == PropertyRow.EditorKind.CONFIDENTIALITY) {
                    combo = new ComboBox(FXCollections.observableArrayList((Object[])ConfidentialityLevel.values()));
                    combo.setMaxWidth(Double.MAX_VALUE);
                    combo.setEditable(false);
                    combo.setConverter(CONFIDENTIALITY_Converter);
                    ConfidentialityLevel current = (ConfidentialityLevel)((Object)CONFIDENTIALITY_Converter.fromString((String)this.getItem()));
                    combo.setValue((Object)current);
                    PropertyRow rowRef = propertyRow;
                    combo.valueProperty().addListener((obs, oldVal, newVal) -> {
                        if (newVal == null) {
                            return;
                        }
                        String asString = CONFIDENTIALITY_Converter.toString((Object)newVal);
                        rowRef.valueProperty().set((Object)asString);
                        this.setText(asString);
                        this.setContentDisplay(ContentDisplay.LEFT);
                        this.this$0.setDirty(true);
                    });
                    this.setGraphic((Node)combo);
                    this.setText(null);
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    return;
                }
                if (kind == PropertyRow.EditorKind.ITEM_TYPE) {
                    combo = new ComboBox(FXCollections.observableArrayList((Object[])ItemType.values()));
                    combo.setMaxWidth(Double.MAX_VALUE);
                    combo.setEditable(false);
                    combo.setConverter(ITEMTYPE_Converter);
                    ItemType current = (ItemType)((Object)ITEMTYPE_Converter.fromString((String)this.getItem()));
                    combo.setValue((Object)current);
                    PropertyRow rowRef = propertyRow;
                    combo.valueProperty().addListener((obs, oldV, newV) -> {
                        Object patt0$temp;
                        if (newV == null) {
                            return;
                        }
                        String asString = ITEMTYPE_Converter.toString((Object)newV);
                        rowRef.valueProperty().set((Object)asString);
                        TreeItem sel = (TreeItem)this.this$0.projectTree.getSelectionModel().getSelectedItem();
                        if (sel != null && (patt0$temp = sel.getValue()) instanceof Item) {
                            Item selectedItem = (Item)patt0$temp;
                            selectedItem.setType((ItemType)((Object)newV));
                        }
                        this.setText(asString);
                        this.setContentDisplay(ContentDisplay.LEFT);
                        this.this$0.setDirty(true);
                    });
                    this.setGraphic((Node)combo);
                    this.setText(null);
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    return;
                }
                this.setGraphic(null);
                this.setText(item == null ? "" : item);
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        });
        this.colValue.setOnEditCommit(e -> {
            ((PropertyRow)e.getRowValue()).valueProperty().set((Object)((String)e.getNewValue()));
            this.detailsTable.refresh();
            this.setDirty(true);
        });
        this.projectTree.getSelectionModel().selectedItemProperty().addListener((obs, oldTi, newTi) -> {
            if (newTi == null) {
                this.currentRows.forEach(PropertyRow::dispose);
                this.currentRows = FXCollections.observableArrayList();
                this.detailsTable.getItems().clear();
                this.detailsTable.refresh();
                return;
            }
            Object item = newTi.getValue();
            if (this.detailsTable != null) {
                this.detailsTable.setEditable(true);
            }
            Object object = item;
            Objects.requireNonNull(object);
            Object selector0$temp = object;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Project.class, Item.class, ProcessItem.class, Dfmea.class, Pfmea.class, ControlPlan.class, EightD.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    Project p = (Project)selector0$temp;
                    this.showProjectDetails(p);
                    break;
                }
                case 1: {
                    Item it = (Item)selector0$temp;
                    this.showItemDetails(it);
                    break;
                }
                case 2: {
                    ProcessItem process = (ProcessItem)selector0$temp;
                    this.showProcessDetails(process);
                    break;
                }
                case 3: {
                    Dfmea dfmea = (Dfmea)selector0$temp;
                    this.showDfmeaDetails(dfmea);
                    break;
                }
                case 4: {
                    Pfmea pfmea = (Pfmea)selector0$temp;
                    this.showPfmeaDetails(pfmea);
                    break;
                }
                case 5: {
                    ControlPlan cp = (ControlPlan)selector0$temp;
                    this.showControlPlanDetails(cp);
                    break;
                }
                case 6: {
                    EightD report = (EightD)selector0$temp;
                    this.showEightDDetails(report);
                    break;
                }
                default: {
                    this.currentRows.forEach(PropertyRow::dispose);
                    this.currentRows = FXCollections.observableArrayList();
                    this.detailsTable.getItems().clear();
                    this.detailsTable.refresh();
                }
            }
        });
    }

    private void showProjectDetails(Project p) {
        ObservableList rows;
        this.currentRows.forEach(PropertyRow::dispose);
        this.currentRows = rows = FXCollections.observableArrayList((Object[])new PropertyRow[]{PropertyRow.of("Name", p.nameProperty()), PropertyRow.of("Description", p.descriptionProperty()), PropertyRow.of("Project leader", p.projectLeaderProperty()), PropertyRow.of("Project team", p.projectTeamProperty()), PropertyRow.ofConv("Start date", p.startDateProperty(), DATE_Converter).withEditor(PropertyRow.EditorKind.DATE), PropertyRow.of("Plant", p.plantProperty()), PropertyRow.of("Plant location", p.plantLocationProperty()), PropertyRow.ofConv("Status", p.statusProperty(), STATUS_Converter).withEditor(PropertyRow.EditorKind.PROJECT_STATUS)});
        this.detailsTable.setItems(rows);
        this.detailsTable.refresh();
    }

    private void showDfmeaDetails(Dfmea dfmea) {
        ObservableList rows;
        this.currentRows.forEach(PropertyRow::dispose);
        this.currentRows = rows = FXCollections.observableArrayList((Object[])new PropertyRow[]{PropertyRow.of("Subject", dfmea.dfmeaSubjectProperty()), PropertyRow.of("Company name", dfmea.companyNameProperty()), PropertyRow.of("Engineering location", dfmea.engineeringLocationProperty()), PropertyRow.of("Customer / product", dfmea.productNameProperty()), PropertyRow.of("Model year / platform", dfmea.modelYearPlatformProperty()), PropertyRow.ofConv("Start date", dfmea.dfmeaStartDateProperty(), DATE_Converter).withEditor(PropertyRow.EditorKind.DATE), PropertyRow.ofConv("Last revision date", dfmea.dfmeaLastRevisionDateProperty(), DATE_Converter).withEditor(PropertyRow.EditorKind.DATE), PropertyRow.of("Cross functional team", dfmea.crossFunctionalTeamProperty()), PropertyRow.of("DFMEA ID number", dfmea.dfmeaIdNumberProperty()), PropertyRow.of("Design responsibility", dfmea.designResponsibilityProperty()), PropertyRow.ofConv("Confidentiality level", dfmea.confidentialityLevelProperty(), CONFIDENTIALITY_Converter).withEditor(PropertyRow.EditorKind.CONFIDENTIALITY)});
        this.detailsTable.setItems(rows);
        this.detailsTable.refresh();
    }

    private void showPfmeaDetails(Pfmea pfmea) {
        ObservableList rows;
        this.currentRows.forEach(PropertyRow::dispose);
        this.currentRows = rows = FXCollections.observableArrayList((Object[])new PropertyRow[]{PropertyRow.of("Subject", pfmea.pfmeaSubjectProperty()), PropertyRow.of("Company name", pfmea.companyNameProperty()), PropertyRow.of("Plant location", pfmea.plantLocationProperty()), PropertyRow.of("Customer name", pfmea.customerNameProperty()), PropertyRow.of("Model year / platform", pfmea.modelYearPlatformProperty()), PropertyRow.ofConv("Start date", pfmea.pfmeaStartDateProperty(), DATE_Converter).withEditor(PropertyRow.EditorKind.DATE), PropertyRow.ofConv("Last revision date", pfmea.pfmeaLastRevisionDateProperty(), DATE_Converter).withEditor(PropertyRow.EditorKind.DATE), PropertyRow.of("Cross functional team", pfmea.crossFunctionalTeamProperty()), PropertyRow.of("PFMEA ID number", pfmea.pfmeaIdNumberProperty()), PropertyRow.of("Process responsibility", pfmea.processResponsibilityProperty()), PropertyRow.ofConv("Confidentiality level", pfmea.confidentialityLevelProperty(), CONFIDENTIALITY_Converter).withEditor(PropertyRow.EditorKind.CONFIDENTIALITY)});
        this.detailsTable.setItems(rows);
        this.detailsTable.refresh();
    }

    private void showControlPlanDetails(ControlPlan cp) {
        ObservableList rows;
        this.currentRows.forEach(PropertyRow::dispose);
        this.currentRows = rows = FXCollections.observableArrayList((Object[])new PropertyRow[]{PropertyRow.of("Control Plan Number", cp.cpNumberProperty()), PropertyRow.of("Part Number", cp.cpPartNumberProperty()), PropertyRow.of("Part Name / Description", cp.cpPartNameProperty()), PropertyRow.of("Cross Functional Team", cp.crossFunctionalTeamProperty()), PropertyRow.of("Supplier Plant", cp.supplierPlantProperty()), PropertyRow.of("Supplier Code", cp.supplierCodeProperty()), PropertyRow.of("Key Contact / Phone", cp.cpKeyContactProperty()), PropertyRow.of("Customer Eng. Approval", cp.cpCustomerEngApprovalProperty()), PropertyRow.of("Customer Quality Approval", cp.cpCustomerQualApprovalProperty()), PropertyRow.of("Customer Other Approval", cp.cpSupplierPlantApprovalProperty()), PropertyRow.of("Supplier Approval", cp.cpSupplierOtherApprovalProperty()), PropertyRow.ofConv("Start Date", cp.cpStartDateProperty(), DATE_Converter).withEditor(PropertyRow.EditorKind.DATE), PropertyRow.ofConv("Revision Date", cp.cpRevisionDateProperty(), DATE_Converter).withEditor(PropertyRow.EditorKind.DATE)});
        this.detailsTable.setItems(rows);
        this.detailsTable.refresh();
    }

    private void showEightDDetails(EightD report) {
        ObservableList rows;
        this.currentRows.forEach(PropertyRow::dispose);
        this.currentRows = rows = FXCollections.observableArrayList((Object[])new PropertyRow[]{PropertyRow.ofConv("Date opened", report.dateOpenedProperty(), DATE_Converter).withEditor(PropertyRow.EditorKind.DATE), PropertyRow.ofConv("Date revised", report.dateRevisedProperty(), DATE_Converter).withEditor(PropertyRow.EditorKind.DATE), PropertyRow.ofConv("Closed date", report.closedDateProperty(), DATE_Converter).withEditor(PropertyRow.EditorKind.DATE), PropertyRow.ofConv("Containment due date", report.containmentDueDateProperty(), DATE_Converter).withEditor(PropertyRow.EditorKind.DATE), PropertyRow.of("Status", report.statusProperty()).withEditor(PropertyRow.EditorKind.READ_ONLY), PropertyRow.of("Internal claim number", report.internalClaimNumberProperty()), PropertyRow.of("Customer claim number", report.customerClaimNumberProperty()), PropertyRow.of("Customer", report.customerProperty()), PropertyRow.of("Internal contact", report.internalContactProperty()), PropertyRow.of("Customer contact", report.customerContactProperty()), PropertyRow.of("Part number", report.partNumberProperty()), PropertyRow.of("Part description", report.partDescriptionProperty()), PropertyRow.of("Quantity", report.quantityProperty()), PropertyRow.of("Non-conformance notification", report.nonConformanceNotificationProperty()).withEditor(PropertyRow.EditorKind.MULTILINE)});
        this.detailsTable.setItems(rows);
        this.detailsTable.refresh();
    }

    private void showItemDetails(Item item) {
        ObservableList rows;
        this.currentRows.forEach(PropertyRow::dispose);
        this.currentRows = rows = FXCollections.observableArrayList((Object[])new PropertyRow[]{PropertyRow.of("Description", item.descriptionProperty()), PropertyRow.of("Function", item.functionProperty()).withEditor(PropertyRow.EditorKind.MULTILINE), PropertyRow.of("Part number", item.partNumberProperty())});
        this.detailsTable.setItems(rows);
        this.detailsTable.refresh();
    }

    private void showProcessDetails(ProcessItem process) {
        ObservableList rows;
        this.currentRows.forEach(PropertyRow::dispose);
        this.currentRows = rows = FXCollections.observableArrayList((Object[])new PropertyRow[]{PropertyRow.of("Description", process.descriptionProperty()), PropertyRow.of("Function", process.functionProperty())});
        this.detailsTable.setItems(rows);
        this.detailsTable.refresh();
    }

    private Button mkMiniBtn(Image icon, String fallbackText, String tip, EventHandler<ActionEvent> handler) {
        Button b = new Button();
        if (icon != null) {
            b.setGraphic((Node)this.iv(icon, 12.0));
            b.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        } else {
            b.setText(fallbackText);
        }
        b.setOnAction(ev -> {
            ev.consume();
            handler.handle(ev);
        });
        b.setFocusTraversable(false);
        b.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        b.setPrefWidth(26.0);
        b.setPrefHeight(26.0);
        b.setTooltip(new Tooltip(tip));
        b.setStyle("-fx-font-size: 11px; -fx-padding: 1 6 1 6;");
        return b;
    }

    private void onSectionAdd(TreeItem<Object> sectionItem) {
        if (sectionItem == null) {
            return;
        }
        Object section = sectionItem.getValue();
        if (!this.ensureEditPermission()) {
            return;
        }
        sectionItem.getChildren().add((Object)(switch (String.valueOf(section)) {
            case "Product Trees" -> {
                Item it = new Item();
                it.setType(ItemType.PRODUCT);
                it.setDescription("Untitled Product");
                this.currentProject.getProductTrees().add((Object)it);
                yield new TreeItem((Object)it);
            }
            case "Process Trees" -> {
                ProcessItem p = new ProcessItem();
                p.setDescription("Untitled Process");
                p.setType(ProcessType.PROCESS);
                this.currentProject.getProcessTrees().add((Object)p);
                yield new TreeItem((Object)p);
            }
            case "DFMEAs" -> {
                Dfmea df = new Dfmea();
                df.setDfmeaSubject("Untitled DFMEA");
                df.setProductName("Untitled");
                this.currentProject.getDfmeas().add((Object)df);
                yield new TreeItem((Object)df);
            }
            case "PFMEAs" -> {
                Pfmea pf = new Pfmea();
                pf.setPfmeaSubject("Untitled PFMEA");
                this.currentProject.getPfmeas().add((Object)pf);
                yield new TreeItem((Object)pf);
            }
            case "Control Plans" -> {
                ControlPlan cp = new ControlPlan();
                cp.setCpPartNumber("Untitled Control Plan");
                this.currentProject.getControlPlans().add((Object)cp);
                yield new TreeItem((Object)cp);
            }
            case "8D Report" -> {
                EightD report = new EightD();
                report.setInternalClaimNumber("Untitled 8D");
                report.setDateOpened(LocalDate.now());
                report.setStatus("Open");
                this.currentProject.getEightDReports().add((Object)report);
                yield new TreeItem((Object)report);
            }
            default -> new TreeItem((Object)"Untitled");
        }));
        sectionItem.setExpanded(true);
        this.setDirty(true);
    }

    private void onSectionDelete(TreeItem<Object> sectionItem) {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (sectionItem == null) {
            return;
        }
        TreeItem sel = (TreeItem)this.projectTree.getSelectionModel().getSelectedItem();
        if (sel == null || sel == sectionItem || sel.getParent() != sectionItem) {
            new Alert(Alert.AlertType.INFORMATION, "Select an item under \"" + String.valueOf(sectionItem.getValue()) + "\" to delete.", new ButtonType[0]).showAndWait();
            return;
        }
        Object val = sel.getValue();
        Alert a = new Alert(Alert.AlertType.CONFIRMATION);
        a.setTitle("Delete");
        a.setHeaderText("Delete selected item?");
        a.setContentText("This cannot be undone.");
        a.showAndWait().ifPresent(bt -> {
            if (bt == ButtonType.OK) {
                Object object = val;
                Objects.requireNonNull(object);
                Object selector0$temp = object;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Item.class, ProcessItem.class, Dfmea.class, Pfmea.class, ControlPlan.class, EightD.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        Item i = (Item)selector0$temp;
                        this.currentProject.getProductTrees().remove((Object)i);
                        break;
                    }
                    case 1: {
                        ProcessItem p = (ProcessItem)selector0$temp;
                        this.currentProject.getProcessTrees().remove((Object)p);
                        break;
                    }
                    case 2: {
                        Dfmea d = (Dfmea)selector0$temp;
                        this.currentProject.getDfmeas().remove((Object)d);
                        break;
                    }
                    case 3: {
                        Pfmea f = (Pfmea)selector0$temp;
                        this.currentProject.getPfmeas().remove((Object)f);
                        break;
                    }
                    case 4: {
                        ControlPlan c = (ControlPlan)selector0$temp;
                        this.currentProject.getControlPlans().remove((Object)c);
                        break;
                    }
                    case 5: {
                        EightD report = (EightD)selector0$temp;
                        this.deleteEightDManagedImages(report);
                        this.currentProject.getEightDReports().remove((Object)report);
                        break;
                    }
                }
                sel.getParent().getChildren().remove((Object)sel);
                this.setDirty(true);
            }
        });
    }

    private void deleteEightDManagedImages(EightD report) {
        if (report == null || report.getImages() == null) {
            return;
        }
        LinkedHashSet<String> identifiers = new LinkedHashSet<String>();
        for (EightDImage image : report.getImages()) {
            if (image == null || image.getPath() == null || image.getPath().isBlank()) continue;
            identifiers.add(image.getPath());
        }
        for (String id : identifiers) {
            if (!EightDImageStorage.isManagedIdentifier(id) || this.isImageReferencedByOtherEightD(id, report)) continue;
            EightDImageStorage.deleteManagedFile(id);
        }
    }

    private boolean isImageReferencedByOtherEightD(String imageId, EightD reportBeingRemoved) {
        if (imageId == null || imageId.isBlank() || this.currentProject == null) {
            return false;
        }
        for (EightD other : this.currentProject.getEightDReports()) {
            if (other == null || other == reportBeingRemoved || other.getImages() == null) continue;
            for (EightDImage image : other.getImages()) {
                if (image == null || image.getPath() == null || !imageId.equalsIgnoreCase(image.getPath())) continue;
                return true;
            }
        }
        return false;
    }

    @FXML
    private void exitApp() {
        this.showExitConfirmation(this.stage);
    }

    private void showExitConfirmation(Stage stage) {
        if (!this.checkDirtyAndAsk()) {
            return;
        }
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Confirm exit");
        alert.setHeaderText("Do you really want to quit?");
        alert.setContentText("Click OK to quit.");
        if (stage != null) {
            alert.initOwner((Window)stage);
            alert.initModality(Modality.WINDOW_MODAL);
        }
        if (alert.showAndWait().filter(bt -> bt == ButtonType.OK).isPresent()) {
            Platform.exit();
            System.exit(0);
        }
    }

    private void updateWindowTitle() {
        if (this.stage == null) {
            return;
        }
        String projectName = this.currentProject != null && this.currentProject.getName() != null && !this.currentProject.getName().isBlank() ? this.currentProject.getName() : "Untitled Project";
        String fileName = this.currentFile != null ? this.currentFile.getName() : "Unsaved";
        String mark = this.isDirty() ? " *" : "";
        this.stage.setTitle("CoreTools - " + projectName + " - " + fileName + mark);
    }

    private void showInfo(String message) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("Information");
        alert.setHeaderText("Operation completed");
        Label content = new Label(message);
        content.setWrapText(true);
        content.setStyle("-fx-font-size: 13px;");
        content.setMaxWidth(Double.MAX_VALUE);
        content.setMnemonicParsing(false);
        DialogPane pane = alert.getDialogPane();
        pane.setContent((Node)content);
        pane.setMinWidth(520.0);
        pane.setPrefWidth(560.0);
        if (this.stage != null) {
            alert.initOwner((Window)this.stage);
        }
        Stage window = (Stage)pane.getScene().getWindow();
        if (CoreTools.APP_ICON != null && window != null) {
            window.getIcons().setAll((Object[])new Image[]{CoreTools.APP_ICON});
        }
        alert.showAndWait();
    }

    private void showWarning(String message) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setTitle("Warning");
        alert.setHeaderText(null);
        alert.setContentText(message);
        alert.showAndWait();
    }

    private void wireProjectListeners(Project p) {
        if (p == null) {
            return;
        }
        p.nameProperty().addListener(this.markDirtyListener);
        p.statusProperty().addListener(this.markDirtyListener);
        p.startDateProperty().addListener(this.markDirtyListener);
        p.projectTeamProperty().addListener(this.markDirtyListener);
        p.descriptionProperty().addListener(this.markDirtyListener);
        p.projectLeaderProperty().addListener(this.markDirtyListener);
        p.plantProperty().addListener(this.markDirtyListener);
        p.plantLocationProperty().addListener(this.markDirtyListener);
        p.getProductTrees().addListener(this.listDirtyListener);
        p.getProcessTrees().addListener(this.listDirtyListener);
        p.getDfmeas().addListener(this.listDirtyListener);
        p.getPfmeas().addListener(this.listDirtyListener);
        p.getControlPlans().addListener(this.listDirtyListener);
        p.getEightDReports().addListener(this.listDirtyListener);
    }

    private void detachProjectListeners(Project p) {
        if (p == null) {
            return;
        }
        p.nameProperty().removeListener(this.markDirtyListener);
        p.statusProperty().removeListener(this.markDirtyListener);
        p.startDateProperty().removeListener(this.markDirtyListener);
        p.projectTeamProperty().removeListener(this.markDirtyListener);
        p.descriptionProperty().removeListener(this.markDirtyListener);
        p.projectLeaderProperty().removeListener(this.markDirtyListener);
        p.plantProperty().removeListener(this.markDirtyListener);
        p.plantLocationProperty().removeListener(this.markDirtyListener);
        p.getProductTrees().removeListener(this.listDirtyListener);
        p.getProcessTrees().removeListener(this.listDirtyListener);
        p.getDfmeas().removeListener(this.listDirtyListener);
        p.getPfmeas().removeListener(this.listDirtyListener);
        p.getControlPlans().removeListener(this.listDirtyListener);
        p.getEightDReports().removeListener(this.listDirtyListener);
    }

    private void showError(String message, Exception ex) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Error");
        alert.setHeaderText(message);
        alert.setContentText(ex.getMessage());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String exceptionText = sw.toString();
        TextArea textArea = new TextArea(exceptionText);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)new Label("The exception stacktrace was:"), 0, 0);
        expContent.add((Node)textArea, 0, 1);
        alert.getDialogPane().setExpandableContent((Node)expContent);
        alert.showAndWait();
    }

    private void sizeChildStage(Stage stage) {
        if (stage == null) {
            return;
        }
        Screen screen = this.screenFor(stage.getOwner());
        if (screen == null) {
            screen = Screen.getPrimary();
        }
        Rectangle2D bounds = screen.getVisualBounds();
        double width = bounds.getWidth() * 0.9;
        double height = bounds.getHeight() * 0.9;
        stage.setWidth(width);
        stage.setHeight(height);
        double x = bounds.getMinX() + (bounds.getWidth() - width) / 2.0;
        double y = bounds.getMinY() + (bounds.getHeight() - height) / 2.0;
        stage.setX(x);
        stage.setY(y);
    }

    private Screen screenFor(Window owner) {
        double h;
        double w;
        double y;
        double x;
        ObservableList screens;
        if (owner != null && !(screens = Screen.getScreensForRectangle((double)(x = owner.getX()), (double)(y = owner.getY()), (double)(w = owner.getWidth() > 0.0 ? owner.getWidth() : 1.0), (double)(h = owner.getHeight() > 0.0 ? owner.getHeight() : 1.0))).isEmpty()) {
            return (Screen)screens.get(0);
        }
        return Screen.getPrimary();
    }

    private void setProjectIntoUI(Project p) {
        if (p == null) {
            p = this.makeEmptyProject();
        }
        this.detachProjectListeners(this.currentProject);
        this.currentProject = p;
        this.wireProjectListeners(this.currentProject);
        this.rebuildTreeFromProject();
        this.setDirty(false);
    }

    private Project getProjectFromUI() {
        return this.currentProject;
    }

    private Project makeEmptyProject() {
        Project p = new Project();
        p.setStatus(ProjectStatus.PENDING_START);
        p.setProjectLeader("To be defined");
        p.setProjectTeam("To be defined");
        p.setStartDate(LocalDate.now());
        p.setPlant("To be defined");
        p.setPlantLocation("To be defined");
        p.setName("Untitled Project");
        p.setProjectTeam("");
        return p;
    }

    @SafeVarargs
    public static List<TreeItem<Object>> asList(TreeItem<Object> ... nodes) {
        if (nodes == null || nodes.length == 0) {
            return List.of();
        }
        ArrayList<TreeItem<Object>> list = new ArrayList<TreeItem<Object>>(nodes.length);
        Collections.addAll(list, nodes);
        return list;
    }

    private void rebuildTreeFromProject() {
        if (this.currentProject == null) {
            return;
        }
        TreeItem treeRoot = new TreeItem((Object)this.currentProject);
        treeRoot.setExpanded(true);
        TreeItem secProducts = new TreeItem((Object)"Product Trees");
        TreeItem secProcesses = new TreeItem((Object)"Process Trees");
        TreeItem secDfmeas = new TreeItem((Object)"DFMEAs");
        TreeItem secPfmeas = new TreeItem((Object)"PFMEAs");
        TreeItem secControlPlans = new TreeItem((Object)"Control Plans");
        TreeItem secEightD = new TreeItem((Object)"8D Report");
        for (Item it : this.currentProject.getProductTrees()) {
            secProducts.getChildren().add((Object)new TreeItem((Object)it));
        }
        for (ProcessItem pr : this.currentProject.getProcessTrees()) {
            secProcesses.getChildren().add((Object)new TreeItem((Object)pr));
        }
        for (Dfmea d : this.currentProject.getDfmeas()) {
            secDfmeas.getChildren().add((Object)new TreeItem((Object)d));
        }
        for (Pfmea f : this.currentProject.getPfmeas()) {
            secPfmeas.getChildren().add((Object)new TreeItem((Object)f));
        }
        for (ControlPlan c : this.currentProject.getControlPlans()) {
            secControlPlans.getChildren().add((Object)new TreeItem((Object)c));
        }
        for (EightD r : this.currentProject.getEightDReports()) {
            secEightD.getChildren().add((Object)new TreeItem((Object)r));
        }
        treeRoot.getChildren().setAll(MainWindowController.asList(secProducts, secProcesses, secDfmeas, secPfmeas, secControlPlans, secEightD));
        this.projectTree.setRoot(treeRoot);
        this.expandTree(treeRoot);
    }

    private void expandTree(TreeItem<?> item) {
        if (item == null) {
            return;
        }
        item.setExpanded(true);
        for (TreeItem child : item.getChildren()) {
            this.expandTree(child);
        }
    }

    @FXML
    private void onNewProject() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (!this.checkDirtyAndAsk()) {
            return;
        }
        this.releaseCurrentLock();
        Project fresh = this.makeEmptyProject();
        this.setProjectIntoUI(fresh);
        this.promptProjectName(fresh);
        this.currentFile = null;
        this.setDirty(false);
    }

    private void promptProjectName(Project p) {
        TextInputDialog d = new TextInputDialog(p.getName());
        d.setTitle("New Project");
        d.setHeaderText("Project name");
        d.setContentText("Enter a name:");
        d.showAndWait().ifPresent(name -> {
            p.setName((String)name);
            this.updateWindowTitle();
        });
    }

    @FXML
    private void onImportDocuments() {
        if (!this.ensureEditPermission()) {
            return;
        }
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/DocImport.fxml"));
            Parent ui = (Parent)loader.load();
            DocImportController controller = (DocImportController)loader.getController();
            Stage dialog = new Stage(StageStyle.DECORATED);
            dialog.setTitle("Import documents");
            dialog.setResizable(false);
            controller.setOwnerStage(dialog);
            controller.setTargetProject(this.currentProject);
            controller.setSaveAction(this::saveProjectSilently);
            controller.setChangeHook(() -> {
                this.setDirty(true);
                this.rebuildTreeFromProject();
                this.projectTree.refresh();
            });
            dialog.initOwner((Window)this.stage);
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.setScene(new Scene(ui));
            this.sizeDialogToContent(dialog, ui);
            dialog.show();
        }
        catch (IOException ex) {
            this.showError("Failed to open document import window", ex);
        }
    }

    @FXML
    private void onImportExcel() {
        if (!this.ensureEditPermission()) {
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Import from Excel");
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Excel (*.xlsx)", new String[]{"*.xlsx"}));
        File file = chooser.showOpenDialog((Window)this.stage);
        if (file == null) {
            return;
        }
        try {
            ImportService service = new ImportService();
            List<ImportReport> reports = service.importWorkbook(file.toPath(), this.currentProject);
            this.setDirty(true);
            this.rebuildTreeFromProject();
            this.projectTree.refresh();
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String header = "Import report - " + file.getName() + "\nGenerated at: " + LocalDateTime.now().format(fmt) + "\n\n";
            String details = reports.isEmpty() ? "No recognized sheets found in the workbook." : reports.stream().map(ImportReport::toText).collect(Collectors.joining("\n"));
            String reportText = header + details;
            Path reportTxt = this.writeImportReport(file, reportText);
            this.showInfo(reportText + "\nSaved to:\n" + String.valueOf(reportTxt));
        }
        catch (IOException ex) {
            this.showError("Error importing Excel: " + ex.getMessage(), ex);
        }
    }

    @FXML
    private void onExportImportTemplate() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Export import template");
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Excel (*.xlsx)", new String[]{"*.xlsx"}));
        chooser.setInitialFileName("CoreTools-Import-Template.xlsx");
        ExportDirectoryPreferences.applyInitialDirectory(chooser);
        File file = chooser.showSaveDialog((Window)this.stage);
        if (file == null) {
            return;
        }
        ExportDirectoryPreferences.rememberExportDirectory(file.getParentFile());
        try {
            ImportService service = new ImportService();
            service.writeTemplate(file.toPath());
            this.showInfo("Template saved to:\n" + file.getAbsolutePath());
        }
        catch (IOException ex) {
            this.showError("Error generating template: " + ex.getMessage(), ex);
        }
    }

    @FXML
    private void onOpenProject() {
        File file;
        if (!this.checkDirtyAndAsk()) {
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Project XML", new String[]{"*.xml"}));
        File initialDir = this.preferredProjectOpenDirectory();
        if (initialDir != null && initialDir.isDirectory()) {
            chooser.setInitialDirectory(initialDir);
        }
        if ((file = chooser.showOpenDialog((Window)this.stage)) != null) {
            Path newLock = null;
            try {
                newLock = this.tryCreateLock(file);
                if (newLock == null) {
                    this.showWarning(LOCK_IN_USE_MESSAGE);
                    return;
                }
                Project p = XmlIO.openProject(file);
                this.releaseCurrentLock();
                this.setProjectIntoUI(p);
                this.currentLockPath = newLock;
                this.currentFile = file;
            }
            catch (JAXBException | IOException | IllegalArgumentException ex) {
                if (newLock != null) {
                    this.deleteLockFile(newLock);
                }
                this.showError("Error opening project", (Exception)ex);
            }
        }
    }

    @FXML
    private void onSaveProject() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.saveProjectInternal(true);
    }

    private void saveProjectSilently() {
        if (!this.saveProjectInternal(false)) {
            throw new IllegalStateException("Project was not saved.");
        }
    }

    private boolean saveProjectInternal(boolean notifyUser) {
        if (!this.ensureEditPermission()) {
            return false;
        }
        if (this.currentFile == null) {
            return this.saveProjectAsInternal(notifyUser);
        }
        try {
            XmlIO.saveProject(this.currentFile, this.getProjectFromUI());
            this.setDirty(false);
            if (notifyUser) {
                this.showInfo("Project saved successfully.");
            }
            return true;
        }
        catch (JAXBException | IllegalArgumentException ex) {
            if (this.isAccessDeniedError(ex)) {
                this.showWarning("Current location is read-only.\nPlease choose a writable folder to save the project.");
                return this.saveProjectAsInternal(notifyUser);
            }
            this.showError("Error saving project", (Exception)ex);
            return false;
        }
    }

    @FXML
    private void onSaveProjectAs() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.saveProjectAsInternal(true);
    }

    private boolean saveProjectAsInternal(boolean notifyUser) {
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Project XML", new String[]{"*.xml"}));
        ExportDirectoryPreferences.applyInitialDirectory(chooser);
        File file = chooser.showSaveDialog((Window)this.stage);
        if (file != null) {
            boolean sameFile = this.currentFile != null && this.currentFile.equals(file);
            Path newLock = null;
            try {
                if (!sameFile && (newLock = this.tryCreateLock(file)) == null) {
                    this.showWarning(LOCK_IN_USE_MESSAGE);
                    return false;
                }
                XmlIO.saveProject(file, this.getProjectFromUI());
                if (!sameFile) {
                    this.releaseCurrentLock();
                    this.currentLockPath = newLock;
                }
                this.currentFile = file;
                ExportDirectoryPreferences.rememberExportDirectory(file.getParentFile());
                this.setDirty(false);
                if (notifyUser) {
                    this.showInfo("Project saved successfully.");
                }
                return true;
            }
            catch (JAXBException | IOException | IllegalArgumentException ex) {
                if (!sameFile && newLock != null) {
                    this.deleteLockFile(newLock);
                }
                this.showError("Error saving project", (Exception)ex);
                return false;
            }
        }
        return false;
    }

    private boolean isAccessDeniedError(Throwable ex) {
        for (Throwable current = ex; current != null; current = current.getCause()) {
            String lower;
            Throwable linked;
            JAXBException jaxb;
            if (current instanceof AccessDeniedException || current instanceof FileNotFoundException) {
                return true;
            }
            if (current instanceof JAXBException && (jaxb = (JAXBException)current).getLinkedException() != null && this.isAccessDeniedError(linked = jaxb.getLinkedException())) {
                return true;
            }
            String msg = current.getMessage();
            if (msg == null || !(lower = msg.toLowerCase()).contains("permission denied") && !lower.contains("permiss\u00e3o negada") && !lower.contains("access is denied")) continue;
            return true;
        }
        return false;
    }

    @FXML
    private void onCloseProject() {
        if (!this.checkDirtyAndAsk()) {
            return;
        }
        this.releaseCurrentLock();
        this.setProjectIntoUI(new Project());
        this.currentFile = null;
        this.setDirty(false);
    }

    private void openProductTreeManager(Item productRoot) {
        try {
            FXMLLoader l = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/ProductTreeWindow.fxml"));
            Parent ui = (Parent)l.load();
            ProductTreeManagerController c = (ProductTreeManagerController)l.getController();
            Stage dlg = new Stage(StageStyle.DECORATED);
            c.setOwnerStage(dlg);
            c.setProductRoot(productRoot);
            ArrayList<Item> projectProducts = this.currentProject == null ? List.of() : new ArrayList<Item>((Collection<Item>)this.currentProject.getProductTrees());
            c.setProjectProducts((List<Item>)projectProducts);
            c.setDirtyHook(() -> {
                this.setDirty(true);
                this.projectTree.refresh();
            });
            c.setSaveAction(this::saveProjectSilently);
            dlg.setTitle("Product Tree Manager - " + (productRoot.getDescription() == null ? "Product" : productRoot.getDescription()));
            dlg.initOwner((Window)this.stage);
            dlg.initModality(Modality.WINDOW_MODAL);
            dlg.setScene(new Scene(ui));
            this.sizeChildStage(dlg);
            dlg.setOnHidden(e -> this.projectTree.refresh());
            dlg.show();
        }
        catch (IOException ex) {
            this.showError("Failed to open Product Tree Manager", ex);
        }
    }

    private void openProcessTreeManager(ProcessItem processRoot) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/ProcessTreeWindow.fxml"));
            Parent ui = (Parent)loader.load();
            ProcessTreeManagerController controller = (ProcessTreeManagerController)loader.getController();
            Stage dialog = new Stage(StageStyle.DECORATED);
            controller.setOwnerStage(dialog);
            ArrayList<ProcessItem> projectProcesses = this.currentProject == null ? List.of() : new ArrayList<ProcessItem>((Collection<ProcessItem>)this.currentProject.getProcessTrees());
            controller.setProjectProcesses((List<ProcessItem>)projectProcesses);
            controller.setProcessRoot(processRoot);
            controller.setSaveAction(this::saveProjectSilently);
            controller.setDirtyHook(() -> {
                this.setDirty(true);
                this.projectTree.refresh();
            });
            controller.setSaveAction(this::saveProjectSilently);
            dialog.setTitle("Process Tree Manager - " + (processRoot.getDescription() == null ? "Process" : processRoot.getDescription()));
            dialog.initOwner((Window)this.stage);
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.setScene(new Scene(ui));
            this.sizeChildStage(dialog);
            dialog.setOnHidden(e -> this.projectTree.refresh());
            dialog.show();
        }
        catch (IOException ex) {
            this.showError("Failed to open Process Tree Manager", ex);
        }
    }

    private void openDfmeaWindow(Dfmea dfmea) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/DfmeaWindow.fxml"));
            Parent ui = (Parent)loader.load();
            DfmeaWindowController c = (DfmeaWindowController)loader.getController();
            Stage dlg = new Stage(StageStyle.DECORATED);
            c.setOwnerStage(dlg);
            c.setSaveAction(this::saveProjectSilently);
            c.setProductProvider(() -> this.allProductsWithDescendants());
            c.setDirtyHook(() -> {
                this.setDirty(true);
                this.projectTree.refresh();
            });
            c.setDfmea(dfmea);
            String title = dfmea.getDfmeaSubject() == null || dfmea.getDfmeaSubject().isBlank() ? "DFMEA" : dfmea.getDfmeaSubject();
            dlg.setTitle("DFMEA - " + title);
            dlg.initOwner((Window)this.stage);
            dlg.initModality(Modality.WINDOW_MODAL);
            dlg.setScene(new Scene(ui));
            this.sizeChildStage(dlg);
            dlg.setOnHidden(e -> this.projectTree.refresh());
            dlg.show();
        }
        catch (IOException ex) {
            this.showError("Failed to open DFMEA editor", ex);
        }
    }

    private void openPfmeaWindow(Pfmea pfmea) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/PfmeaWindow.fxml"));
            Parent ui = (Parent)loader.load();
            PfmeaWindowController controller = (PfmeaWindowController)loader.getController();
            Stage dlg = new Stage(StageStyle.DECORATED);
            controller.setOwnerStage(dlg);
            controller.setSaveAction(this::saveProjectSilently);
            controller.setProcessProvider(() -> this.allProcessesWithDescendants());
            controller.setDirtyHook(() -> {
                this.setDirty(true);
                this.projectTree.refresh();
            });
            controller.setPfmea(pfmea);
            String title = pfmea.getPfmeaSubject() == null || pfmea.getPfmeaSubject().isBlank() ? "PFMEA" : pfmea.getPfmeaSubject();
            dlg.setTitle("PFMEA - " + title);
            dlg.initOwner((Window)this.stage);
            dlg.initModality(Modality.WINDOW_MODAL);
            dlg.setScene(new Scene(ui));
            this.sizeChildStage(dlg);
            dlg.setOnHidden(e -> this.projectTree.refresh());
            dlg.show();
        }
        catch (IOException ex) {
            this.showError("Failed to open PFMEA editor", ex);
        }
    }

    private void openControlPlanWindow(ControlPlan controlPlan) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/ControlPlanWindow.fxml"));
            Parent ui = (Parent)loader.load();
            ControlPlanWindowController controller = (ControlPlanWindowController)loader.getController();
            Stage dlg = new Stage(StageStyle.DECORATED);
            controller.setOwnerStage(dlg);
            controller.setSaveAction(this::saveProjectSilently);
            controller.setDirtyHook(() -> {
                this.setDirty(true);
                this.projectTree.refresh();
            });
            controller.setProductTrees(new ArrayList<Item>((Collection<Item>)this.currentProject.getProductTrees()));
            controller.setProcessTrees(new ArrayList<ProcessItem>((Collection<ProcessItem>)this.currentProject.getProcessTrees()));
            controller.setControlPlan(controlPlan);
            String title = controlPlan.getCpPartNumber() == null || controlPlan.getCpPartNumber().isBlank() ? "Control Plan" : controlPlan.getCpPartNumber();
            dlg.setTitle("Control Plan - " + title);
            dlg.initOwner((Window)this.stage);
            dlg.initModality(Modality.WINDOW_MODAL);
            dlg.setScene(new Scene(ui));
            this.sizeChildStage(dlg);
            dlg.setOnHidden(e -> this.projectTree.refresh());
            dlg.show();
        }
        catch (IOException ex) {
            this.showError("Failed to open Control Plan editor", ex);
        }
    }

    private void openEightDWindow(EightD report) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/EightDWindow.fxml"));
            Parent ui = (Parent)loader.load();
            EightDWindowController controller = (EightDWindowController)loader.getController();
            Stage dlg = new Stage(StageStyle.DECORATED);
            controller.setOwnerStage(dlg);
            controller.setSaveAction(this::saveProjectSilently);
            controller.setDirtyHook(() -> {
                this.setDirty(true);
                this.projectTree.refresh();
            });
            controller.setEightDReportsProvider(() -> this.currentProject == null ? List.of() : this.currentProject.getEightDReports());
            controller.setProjectIdProvider(() -> this.currentProject == null ? null : this.currentProject.getId());
            controller.setEightD(report);
            String title = MainWindowController.safeText(report.getInternalClaimNumber());
            if (title.isBlank()) {
                title = MainWindowController.safeText(report.getCustomerClaimNumber());
            }
            if (title.isBlank()) {
                title = MainWindowController.safeText(report.getPartNumber());
            }
            if (title.isBlank()) {
                title = "8D Report";
            }
            dlg.setTitle("8D - " + title);
            dlg.initOwner((Window)this.stage);
            dlg.initModality(Modality.WINDOW_MODAL);
            dlg.setScene(new Scene(ui));
            this.sizeChildStage(dlg);
            dlg.setOnHidden(e -> this.projectTree.refresh());
            dlg.show();
        }
        catch (IOException ex) {
            this.showError("Failed to open 8D editor", ex);
        }
    }

    private boolean checkDirtyAndAsk() {
        if (!this.dirty.get()) {
            return true;
        }
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Unsaved Changes");
        alert.setHeaderText("This project has unsaved changes");
        alert.setContentText("Do you want to save before continuing?");
        ButtonType saveBtn = new ButtonType("Save");
        ButtonType dontSaveBtn = new ButtonType("Don't Save");
        ButtonType cancelBtn = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{saveBtn, dontSaveBtn, cancelBtn});
        Optional result = alert.showAndWait();
        if (result.isEmpty()) {
            return false;
        }
        if (result.get() == saveBtn) {
            this.onSaveProject();
            return !this.dirty.get();
        }
        return result.get() == dontSaveBtn;
    }

    private static List<ProcessItem> flattenProcessTree(ProcessItem root) {
        ArrayList<ProcessItem> out = new ArrayList<ProcessItem>();
        if (root == null) {
            return out;
        }
        ArrayDeque<ProcessItem> stack = new ArrayDeque<ProcessItem>();
        stack.push(root);
        while (!stack.isEmpty()) {
            ProcessItem it = (ProcessItem)stack.pop();
            out.add(it);
            ObservableList<ProcessItem> children = it.getChildren();
            if (children == null) continue;
            for (int i = children.size() - 1; i >= 0; --i) {
                ProcessItem ch = (ProcessItem)children.get(i);
                if (ch == null) continue;
                stack.push(ch);
            }
        }
        LinkedHashSet<ProcessItem> seen = new LinkedHashSet<ProcessItem>(out);
        return new ArrayList<ProcessItem>(seen);
    }

    private List<ProcessItem> allProcessesWithDescendants() {
        ArrayList<ProcessItem> all = new ArrayList<ProcessItem>();
        if (this.currentProject == null) {
            return all;
        }
        for (ProcessItem rootProcess : this.currentProject.getProcessTrees()) {
            all.addAll(MainWindowController.flattenProcessTree(rootProcess));
        }
        LinkedHashSet<ProcessItem> seen = new LinkedHashSet<ProcessItem>(all);
        return new ArrayList<ProcessItem>(seen);
    }

    private static List<Item> flattenProductTree(Item root) {
        ArrayList<Item> out = new ArrayList<Item>();
        if (root == null) {
            return out;
        }
        ArrayDeque<Item> stack = new ArrayDeque<Item>();
        stack.push(root);
        while (!stack.isEmpty()) {
            Item it = (Item)stack.pop();
            out.add(it);
            ObservableList<Item> children = it.getChildren();
            if (children == null) continue;
            for (int i = children.size() - 1; i >= 0; --i) {
                Item ch = (Item)children.get(i);
                if (ch == null) continue;
                stack.push(ch);
            }
        }
        LinkedHashSet<Item> seen = new LinkedHashSet<Item>(out);
        return new ArrayList<Item>(seen);
    }

    private List<Item> allProductsWithDescendants() {
        ArrayList<Item> all = new ArrayList<Item>();
        if (this.currentProject == null) {
            return all;
        }
        for (Item rootItem : this.currentProject.getProductTrees()) {
            all.addAll(MainWindowController.flattenProductTree(rootItem));
        }
        LinkedHashSet<Item> seen = new LinkedHashSet<Item>(all);
        return new ArrayList<Item>(seen);
    }

    private void selectNode(TreeItem<Object> node) {
        if (node == null) {
            return;
        }
        this.projectTree.getSelectionModel().select(node);
    }

    private void duplicateSectionChild(TreeItem<Object> childNode) {
        Object value;
        TreeItem sectionNode = childNode.getParent();
        if (sectionNode == null) {
            return;
        }
        Object object = value = childNode.getValue();
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Item.class, ProcessItem.class, Dfmea.class, Pfmea.class, ControlPlan.class, EightD.class}, (Object)object2, n)) {
            case 0: {
                Item item = (Item)object2;
                this.insertCloneInTreeAndModel((TreeItem<Object>)sectionNode, childNode, DocumentCloneUtils.cloneItem(item), (List)this.currentProject.getProductTrees(), (Object)item);
                break;
            }
            case 1: {
                ProcessItem processItem = (ProcessItem)object2;
                this.insertCloneInTreeAndModel((TreeItem<Object>)sectionNode, childNode, DocumentCloneUtils.cloneProcessItem(processItem), (List)this.currentProject.getProcessTrees(), (Object)processItem);
                break;
            }
            case 2: {
                Dfmea dfmea = (Dfmea)object2;
                this.insertCloneInTreeAndModel((TreeItem<Object>)sectionNode, childNode, DocumentCloneUtils.cloneDfmea(dfmea), (List)this.currentProject.getDfmeas(), (Object)dfmea);
                break;
            }
            case 3: {
                Pfmea pfmea = (Pfmea)object2;
                this.insertCloneInTreeAndModel((TreeItem<Object>)sectionNode, childNode, DocumentCloneUtils.clonePfmea(pfmea), (List)this.currentProject.getPfmeas(), (Object)pfmea);
                break;
            }
            case 4: {
                ControlPlan controlPlan = (ControlPlan)object2;
                this.insertCloneInTreeAndModel((TreeItem<Object>)sectionNode, childNode, DocumentCloneUtils.cloneControlPlan(controlPlan), (List)this.currentProject.getControlPlans(), (Object)controlPlan);
                break;
            }
            case 5: {
                EightD report = (EightD)object2;
                this.insertCloneInTreeAndModel((TreeItem<Object>)sectionNode, childNode, DocumentCloneUtils.cloneEightD(report), (List)this.currentProject.getEightDReports(), (Object)report);
                break;
            }
            default: {
                return;
            }
        }
        this.setDirty(true);
        this.projectTree.refresh();
    }

    private <T> void insertCloneInTreeAndModel(TreeItem<Object> sectionNode, TreeItem<Object> sourceNode, Object cloned, List<T> modelList, T sourceModelObj) {
        if (cloned == null) {
            return;
        }
        int uiIndex = sectionNode.getChildren().indexOf(sourceNode);
        TreeItem cloneNode = new TreeItem(cloned);
        sectionNode.getChildren().add(uiIndex + 1, (Object)cloneNode);
        int modelIndex = modelList.indexOf(sourceModelObj);
        if (modelIndex >= 0 && modelIndex < modelList.size()) {
            modelList.add(modelIndex + 1, cloned);
        } else {
            modelList.add(cloned);
        }
        this.selectNode((TreeItem<Object>)cloneNode);
    }

    private void sizeDialogToContent(Stage dialog, Parent content) {
        if (dialog == null || content == null) {
            return;
        }
        if (content instanceof Region) {
            Region region = (Region)content;
            double prefW = region.getPrefWidth();
            double prefH = region.getPrefHeight();
            if (prefW > 0.0) {
                dialog.setWidth(prefW);
                dialog.setMinWidth(prefW);
            }
            if (prefH > 0.0) {
                dialog.setHeight(prefH);
                dialog.setMinHeight(prefH);
            }
        }
        dialog.sizeToScene();
        dialog.centerOnScreen();
    }

    private boolean ensureEditPermission() {
        return true;
    }

    public static class PropertyRow {
        private final StringProperty label;
        private final StringProperty value;
        private Runnable disposer = () -> {};
        private EditorKind editorKind = EditorKind.TEXT;

        public PropertyRow(StringProperty label, StringProperty value) {
            this.label = label;
            this.value = value;
        }

        public StringProperty labelProperty() {
            return this.label;
        }

        public StringProperty valueProperty() {
            return this.value;
        }

        public PropertyRow withEditor(EditorKind kind) {
            this.editorKind = kind == null ? EditorKind.TEXT : kind;
            return this;
        }

        public EditorKind editorKind() {
            return this.editorKind;
        }

        public <T> PropertyRow bindBidirectional(Property<T> prop, StringConverter<T> conv) {
            if (conv == null && prop instanceof StringProperty) {
                StringProperty sp = (StringProperty)prop;
                this.value.bindBidirectional((Property)sp);
                this.disposer = () -> this.value.unbindBidirectional((Property)sp);
            } else {
                Bindings.bindBidirectional((Property)this.value, prop, conv);
                this.disposer = () -> Bindings.unbindBidirectional((Object)this.value, (Object)prop);
            }
            return this;
        }

        public void dispose() {
            this.disposer.run();
        }

        public static PropertyRow of(String label, StringProperty p) {
            return new PropertyRow((StringProperty)new SimpleStringProperty(label), (StringProperty)new SimpleStringProperty((String)p.get())).bindBidirectional((Property)p, null);
        }

        public static <T> PropertyRow ofConv(String label, ObjectProperty<T> p, StringConverter<T> conv) {
            return new PropertyRow((StringProperty)new SimpleStringProperty(label), (StringProperty)new SimpleStringProperty(p.get() == null ? "" : conv.toString(p.get()))).bindBidirectional((Property<T>)p, conv);
        }

        public static enum EditorKind {
            READ_ONLY,
            TEXT,
            DATE,
            PROJECT_STATUS,
            CONFIDENTIALITY,
            ITEM_TYPE,
            MULTILINE;

        }
    }
}

