/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.controllers.util.MentionSuggestionBehavior;
import com.qualidadeeprodutividade.controllers.util.TableClipboardHelper;
import com.qualidadeeprodutividade.controllers.util.TableHeaderStyler;
import com.qualidadeeprodutividade.controllers.util.TableSearchNavigator;
import com.qualidadeeprodutividade.controllers.util.TableSelectionStyler;
import com.qualidadeeprodutividade.controllers.util.TableUtils;
import com.qualidadeeprodutividade.controllers.util.WrapTextAreaTableCell;
import com.qualidadeeprodutividade.export.ExportDirectoryPreferences;
import com.qualidadeeprodutividade.export.ExportFileNameUtil;
import com.qualidadeeprodutividade.export.ExportLogoPreferences;
import com.qualidadeeprodutividade.fmea.ApTableCache;
import com.qualidadeeprodutividade.fmea.ApprovalStatus;
import com.qualidadeeprodutividade.fmea.ConfidentialityLevel;
import com.qualidadeeprodutividade.fmea.Pfmea;
import com.qualidadeeprodutividade.fmea.PfmeaExcelExporter;
import com.qualidadeeprodutividade.fmea.PfmeaPdfGenerator;
import com.qualidadeeprodutividade.fmea.PfmeaRow;
import com.qualidadeeprodutividade.fmea.RevisionEntry;
import com.qualidadeeprodutividade.processItem.Ishikawa;
import com.qualidadeeprodutividade.processItem.Parameter;
import com.qualidadeeprodutividade.processItem.ProcessItem;
import com.qualidadeeprodutividade.processItem.ProcessType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.net.URL;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;
import org.openpdf.text.DocumentException;

public class PfmeaWindowController
implements Initializable {
    private static final String SEARCH_HIGHLIGHT_STYLE = "-fx-background-color: #fff9c4;";
    private static final String SEARCH_HIGHLIGHT_SELECTED_STYLE = "-fx-background-color: -fx-selection-bar, rgba(255,249,196,0.65); -fx-background-insets: 0, 0;";
    private static final PfmeaRow.ActionPriority[][][] AP = new PfmeaRow.ActionPriority[11][11][11];
    private static final Object AP_LOAD_LOCK = new Object();
    private static volatile boolean apTableInitialized = false;
    private static final String HSCROLL_CACHE_KEY = "pfmea-horizontal-scrollbar";
    private static final String TEXT_FIELD_NAV_KEY = "pfmea-text-field-nav";
    @FXML
    private PieChart chartActionPriority;
    @FXML
    private PieChart chartActionPriorityAfter;
    @FXML
    private WebView webFta;
    @FXML
    private Tab tabPfmeaTreeChart;
    @FXML
    private TabPane tabPane;
    @FXML
    private Label lblPath;
    @FXML
    private Tab tabFailureChains;
    @FXML
    private BarChart<String, Number> chartStatus;
    @FXML
    private BarChart<String, Number> chartSeverityCount;
    @FXML
    private BarChart<String, Number> chartOcurrenceCount;
    @FXML
    private BarChart<String, Number> chartDetectionCount;
    @FXML
    private TableView<PfmeaRow> tblActions;
    @FXML
    private TableColumn<PfmeaRow, String> colSummaryFocusElement;
    @FXML
    private TableColumn<PfmeaRow, String> colSummaryFailureMode;
    @FXML
    private TableColumn<PfmeaRow, String> colPreventionActionSummary;
    @FXML
    private TableColumn<PfmeaRow, String> colDetectionActionSummary;
    @FXML
    private TableColumn<PfmeaRow, String> colStatusSummary;
    @FXML
    private TableColumn<PfmeaRow, String> colResponsibleSummary;
    @FXML
    private TableColumn<PfmeaRow, LocalDate> colTargetDateSummary;
    @FXML
    private TableView<PfmeaRow> tblRows;
    @FXML
    private TableColumn<PfmeaRow, Number> colIssue;
    @FXML
    private TableColumn<PfmeaRow, String> colChangeAuthorization;
    @FXML
    private TableColumn<PfmeaRow, String> colNextHigherLevel;
    @FXML
    private TableColumn<PfmeaRow, String> colFocusElement;
    @FXML
    private TableColumn<PfmeaRow, String> colNextLowerLevelOrParameter;
    @FXML
    private TableColumn<PfmeaRow, String> colNextHigherLevelFunction;
    @FXML
    private TableColumn<PfmeaRow, String> colFocusElementFunctionRequirement;
    @FXML
    private TableColumn<PfmeaRow, String> colNextLowerLevelFunctionRequirementOrParameter;
    @FXML
    private TableColumn<PfmeaRow, String> colFailureEffect;
    @FXML
    private TableColumn<PfmeaRow, PfmeaRow.Severity> colSeverity;
    @FXML
    private TableColumn<PfmeaRow, String> colFailureMode;
    @FXML
    private TableColumn<PfmeaRow, String> colFailureCause;
    @FXML
    private TableColumn<PfmeaRow, String> colPreventionControl;
    @FXML
    private TableColumn<PfmeaRow, PfmeaRow.Occurrence> colOccurrence;
    @FXML
    private TableColumn<PfmeaRow, String> colDetectionControl;
    @FXML
    private TableColumn<PfmeaRow, PfmeaRow.Detection> colDetection;
    @FXML
    private TableColumn<PfmeaRow, PfmeaRow.ActionPriority> colActionPriority;
    @FXML
    private TableColumn<PfmeaRow, Number> colRpn;
    @FXML
    private TableColumn<PfmeaRow, String> colFilterCode;
    @FXML
    private TableColumn<PfmeaRow, String> colPreventiveAction;
    @FXML
    private TableColumn<PfmeaRow, String> colDetectionAction;
    @FXML
    private TableColumn<PfmeaRow, String> colResponsiblePerson;
    @FXML
    private TableColumn<PfmeaRow, LocalDate> colTargetCompletionDate;
    @FXML
    private TableColumn<PfmeaRow, LocalDate> colCompletionDate;
    @FXML
    private TableColumn<PfmeaRow, PfmeaRow.PfmeaStatus> colStatus;
    @FXML
    private TableColumn<PfmeaRow, String> colActionTakenEvidence;
    @FXML
    private TableColumn<PfmeaRow, PfmeaRow.Severity> colCurrentSeverity;
    @FXML
    private TableColumn<PfmeaRow, PfmeaRow.Occurrence> colCurrentOccurrence;
    @FXML
    private TableColumn<PfmeaRow, PfmeaRow.Detection> colCurrentDetection;
    @FXML
    private TableColumn<PfmeaRow, PfmeaRow.ActionPriority> colCurrentActionPriority;
    @FXML
    private TableColumn<PfmeaRow, String> colRemarks;
    @FXML
    private BorderPane root;
    @FXML
    private TextField txtSearch;
    @FXML
    private Button btnNext;
    private TableSearchNavigator<PfmeaRow> failureChainSearch;
    private Pattern searchHighlightPattern;
    @FXML
    private Button btnAddFailureChain;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnPfmeaTables;
    @FXML
    private Button btnExportToPDF;
    @FXML
    private ImageView imgHeaderIcon;
    @FXML
    private Button btnSaveOnly;
    @FXML
    private Button btnSaveExit;
    @FXML
    private TableView<RevisionEntry> tblRevisions;
    @FXML
    private TableColumn<RevisionEntry, String> colRevNumber;
    @FXML
    private TableColumn<RevisionEntry, LocalDate> colRevDate;
    @FXML
    private TableColumn<RevisionEntry, String> colRevAuthor;
    @FXML
    private TableColumn<RevisionEntry, String> colRevDesc;
    @FXML
    private TableColumn<RevisionEntry, ApprovalStatus> colRevStatus;
    @FXML
    private Button btnRevAdd;
    @FXML
    private Button btnRevEdit;
    @FXML
    private Button btnRevApprove;
    @FXML
    private Button btnRevDelete;
    private Image icFailureChain;
    private Image icPdf;
    private Image icExcel;
    private Image icTable;
    private Image icPlus;
    private Image icTrash;
    private Image icApprove;
    private Image icEdit;
    private Image icSave;
    private Image icExit;
    private Image icSearch;
    @FXML
    private TextField txtCompanyName;
    @FXML
    private TextField txtPlantLocation;
    @FXML
    private TextField txtCustomerName;
    @FXML
    private TextField txtModelYearPlatform;
    @FXML
    private TextField txtPfmeaSubject;
    @FXML
    private DatePicker dpPfmeaStartDate;
    @FXML
    private DatePicker dpPfmeaRevisionDate;
    @FXML
    private TextField txtCrossFunctionalTeam;
    @FXML
    private TextField txtPfmeaIdNumber;
    @FXML
    private TextField txtProcessResponsibility;
    @FXML
    private ComboBox<ConfidentialityLevel> cbConfidentialityLevel;
    private boolean treeLoaded = false;
    private Supplier<List<ProcessItem>> processProvider;
    private final ContextMenu mentionPopup = new ContextMenu();
    private Stage ownerStage;
    private boolean hasUnsavedChanges = false;
    private boolean programmaticClose = false;
    private Runnable dirtyHook = () -> {
        this.hasUnsavedChanges = true;
    };
    private static final int MAX_PFMEA_UNDO = 50;
    private final Deque<Runnable> pfmeaUndoStack = new ArrayDeque<Runnable>();
    private Pfmea pfmea;
    private Runnable saveAction;
    private boolean verticalHeadersApplied = false;

    public static PfmeaRow.ActionPriority getAp(int s, int o, int d) {
        PfmeaWindowController.ensureApTableLoaded();
        if (s < 1 || s > 10 || o < 1 || o > 10 || d < 1 || d > 10) {
            return null;
        }
        return AP[s][o][d];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureApTableLoaded() {
        if (apTableInitialized) {
            return;
        }
        Object object = AP_LOAD_LOCK;
        synchronized (object) {
            if (apTableInitialized) {
                return;
            }
            ApTableCache.ensureLoaded();
            for (int s = 1; s <= 10; ++s) {
                for (int o = 1; o <= 10; ++o) {
                    for (int d = 1; d <= 10; ++d) {
                        PfmeaWindowController.AP[s][o][d] = PfmeaWindowController.toPfmeaPriority(ApTableCache.levelAt(s, o, d));
                    }
                }
            }
            apTableInitialized = true;
        }
    }

    private static PfmeaRow.ActionPriority toPfmeaPriority(ApTableCache.PriorityLevel level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case ApTableCache.PriorityLevel.HIGH -> PfmeaRow.ActionPriority.HIGH;
            case ApTableCache.PriorityLevel.MEDIUM -> PfmeaRow.ActionPriority.MEDIUM;
            case ApTableCache.PriorityLevel.LOW -> PfmeaRow.ActionPriority.LOW;
        };
    }

    public void setSaveAction(Runnable action) {
        this.saveAction = action;
    }

    private void textColWrapped(TableColumn<PfmeaRow, String> column, Function<PfmeaRow, StringProperty> prop) {
        if (column == null) {
            return;
        }
        column.setCellValueFactory(cell -> (ObservableValue)prop.apply((PfmeaRow)cell.getValue()));
        column.setCellFactory(col -> new WrapTextAreaTableCell(col, () -> this.searchHighlightPattern, PfmeaWindowController::navigateFromCell));
        column.setStyle("-fx-alignment: CENTER;");
        column.setOnEditCommit(edit -> {
            PfmeaRow row = (PfmeaRow)edit.getRowValue();
            if (row == null) {
                return;
            }
            StringProperty property = (StringProperty)prop.apply(row);
            if (property == null) {
                return;
            }
            String newValue = (String)edit.getNewValue();
            String oldValue = (String)property.get();
            if (Objects.equals(oldValue, newValue)) {
                return;
            }
            this.pushPfmeaUndo(() -> property.set((Object)oldValue));
            property.set((Object)newValue);
            if (this.dirtyHook != null) {
                this.dirtyHook.run();
            }
        });
    }

    public void setOwnerStage(Stage s) {
        this.ownerStage = s;
        this.installCloseHandler();
    }

    public void setDirtyHook(Runnable r) {
        Runnable delegate = r != null ? r : () -> {};
        this.dirtyHook = () -> {
            this.hasUnsavedChanges = true;
            delegate.run();
        };
    }

    private void handleTableClipboardPaste() {
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        this.scheduleSummaryRefresh();
        this.scheduleTreeRefresh();
    }

    public void setProcessProvider(Supplier<List<ProcessItem>> provider) {
        this.processProvider = provider;
        this.updatePathLabel();
    }

    public void setPfmea(Pfmea model) {
        PfmeaWindowController.ensureApTableLoaded();
        this.pfmea = model;
        this.hasUnsavedChanges = false;
        this.pfmeaUndoStack.clear();
        this.pfmeaUndoStack.clear();
        this.loadHeaderFromModel();
        this.wireHeaderBindings();
        this.enableSubjectMentions();
        this.updateWindowTitle(PfmeaWindowController.s(this.pfmea.getPfmeaSubject()));
        this.updatePathLabel();
        this.initRevisionTab();
        if (this.tblRows != null) {
            this.tblRows.setItems(this.pfmea.getFailureChains());
            this.configureRowContextMenu();
            this.tblRows.setFixedCellSize(-1.0);
            this.centerAllPfmeaColumns();
            Platform.runLater(() -> this.tblRows.requestFocus());
        }
        if (this.btnAddFailureChain != null) {
            this.btnAddFailureChain.setOnAction(e -> this.onAddChain());
            this.btnAddFailureChain.setTooltip(new Tooltip("Add PFMEA failure chain"));
        }
        if (this.btnDelete != null) {
            this.btnDelete.setOnAction(e -> this.onDeleteSelectedChain());
            this.btnDelete.setTooltip(new Tooltip("Delete selected row"));
        }
        this.wireExportButton();
        for (PfmeaRow r : this.pfmea.getFailureChains()) {
            if (r.getSeverity() == null) {
                r.setSeverity(PfmeaRow.Severity.ONE);
            }
            if (r.getOccurrence() == null) {
                r.setOccurrence(PfmeaRow.Occurrence.ONE);
            }
            if (r.getDetection() == null) {
                r.setDetection(PfmeaRow.Detection.ONE);
            }
            if (r.getCurrentSeverity() == null) {
                r.setCurrentSeverity(PfmeaRow.Severity.ONE);
            }
            if (r.getCurrentOccurrence() == null) {
                r.setCurrentOccurrence(PfmeaRow.Occurrence.ONE);
            }
            if (r.getCurrentDetection() == null) {
                r.setCurrentDetection(PfmeaRow.Detection.ONE);
            }
            this.attachApListeners(r);
            this.wireSummaryRowListeners(r);
            this.attachTreeRefreshRowListeners(r);
        }
        this.scheduleSummaryRefresh();
        this.pfmea.getFailureChains().addListener(c -> {
            boolean changed = false;
            while (c.next()) {
                if (c.wasAdded()) {
                    for (PfmeaRow r : c.getAddedSubList()) {
                        if (r.getSeverity() == null) {
                            r.setSeverity(PfmeaRow.Severity.ONE);
                        }
                        if (r.getOccurrence() == null) {
                            r.setOccurrence(PfmeaRow.Occurrence.ONE);
                        }
                        if (r.getDetection() == null) {
                            r.setDetection(PfmeaRow.Detection.ONE);
                        }
                        if (r.getCurrentSeverity() == null) {
                            r.setCurrentSeverity(PfmeaRow.Severity.ONE);
                        }
                        if (r.getCurrentOccurrence() == null) {
                            r.setCurrentOccurrence(PfmeaRow.Occurrence.ONE);
                        }
                        if (r.getCurrentDetection() == null) {
                            r.setCurrentDetection(PfmeaRow.Detection.ONE);
                        }
                        this.attachApListeners(r);
                        this.wireSummaryRowListeners(r);
                        this.attachTreeRefreshRowListeners(r);
                    }
                    changed = true;
                }
                if (!c.wasRemoved()) continue;
                changed = true;
            }
            if (changed) {
                this.scheduleSummaryRefresh();
            }
            this.scheduleTreeRefresh();
        });
        if (this.tblActions != null && this.pfmea != null) {
            this.updateActionsTable((List<PfmeaRow>)this.pfmea.getFailureChains());
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        BooleanBinding deleteDisable;
        BooleanBinding onFailureTab;
        this.loadIcons();
        this.configureHeaderIcon();
        TableSelectionStyler.ensureAll(new Control[]{this.tblRows, this.tblActions});
        TableHeaderStyler.ensureAll(new Control[]{this.tblRows, this.tblActions});
        this.applyHeaderReadOnlyMode();
        if (this.btnAddFailureChain != null) {
            this.btnAddFailureChain.setOnAction(e -> this.onAddChain());
            this.btnAddFailureChain.setTooltip(new Tooltip("Add PFMEA failure chain"));
            this.btnAddFailureChain.setGraphic((Node)this.icon(this.icFailureChain, 18.0));
        }
        if (this.btnDelete != null) {
            this.btnDelete.setOnAction(e -> this.onDeleteSelectedChain());
            this.btnDelete.setTooltip(new Tooltip("Delete selected row"));
            this.btnDelete.disableProperty().bind((ObservableValue)Bindings.isNotNull((ObservableObjectValue)this.tblRows.editingCellProperty()).or((ObservableBooleanValue)this.tblRows.getSelectionModel().selectedItemProperty().isNull()));
            this.btnDelete.setGraphic((Node)this.icon(this.icTrash, 18.0));
        }
        if (this.tabPane != null && this.tabFailureChains != null) {
            onFailureTab = Bindings.createBooleanBinding(() -> this.tabPane.getSelectionModel().getSelectedItem() == this.tabFailureChains, (Observable[])new Observable[]{this.tabPane.getSelectionModel().selectedItemProperty()});
            if (this.btnAddFailureChain != null) {
                this.btnAddFailureChain.disableProperty().unbind();
                this.btnAddFailureChain.disableProperty().bind((ObservableValue)onFailureTab.not());
            }
            if (this.btnDelete != null && this.tblRows != null) {
                this.btnDelete.disableProperty().unbind();
                deleteDisable = onFailureTab.not().or((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.tblRows.editingCellProperty())).or((ObservableBooleanValue)this.tblRows.getSelectionModel().selectedItemProperty().isNull());
                this.btnDelete.disableProperty().bind((ObservableValue)deleteDisable);
            }
        }
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setOnAction(e -> this.onSaveOnly());
            this.btnSaveOnly.setTooltip(new Tooltip("Save current PFMEA"));
            this.btnSaveOnly.setGraphic((Node)this.icon(this.icSave, 18.0));
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setOnAction(e -> this.onSaveAndExit());
            this.btnSaveExit.setTooltip(new Tooltip("Save current PFMEA and close"));
            this.btnSaveExit.setGraphic((Node)this.icon(this.icExit, 18.0));
        }
        if (this.btnExportToPDF != null) {
            this.btnExportToPDF.setGraphic((Node)this.icon(this.icPdf, 16.0));
        }
        if (this.btnPfmeaTables != null) {
            this.btnPfmeaTables.setGraphic((Node)this.icon(this.icTable, 18.0));
            this.btnPfmeaTables.setText(null);
            this.btnPfmeaTables.setContentDisplay(ContentDisplay.CENTER);
            this.btnPfmeaTables.setOnAction(e -> this.onOpenPfmeaTables());
        }
        if (this.tblRows != null) {
            this.tblRows.setFixedCellSize(-1.0);
            this.tblRows.setStyle("-fx-cell-size: -1;");
            TableClipboardHelper.install(this.tblRows, this::handleTableClipboardPaste);
            if (this.txtSearch != null && this.btnNext != null) {
                this.failureChainSearch = TableSearchNavigator.install(this.tblRows, this.txtSearch, this.btnNext);
                if (this.failureChainSearch != null) {
                    this.updateSearchPattern();
                    this.failureChainSearch.setOnStateChanged(() -> {
                        this.tblRows.refresh();
                        this.updateSearchPattern();
                    });
                    this.btnNext.setGraphic((Node)this.icon(this.icSearch, 16.0));
                    this.btnNext.setText(null);
                } else {
                    this.searchHighlightPattern = null;
                }
            }
        }
        this.applyDefaultTooltips();
        this.centerCells(this.colIssue, this.colChangeAuthorization, this.colSeverity, this.colOccurrence, this.colDetection, this.colCurrentSeverity, this.colCurrentOccurrence, this.colCurrentDetection, this.colActionPriority, this.colCurrentActionPriority, this.colFilterCode, this.colStatus, this.colRpn);
        this.setupFailureChainsTable();
        if (this.cbConfidentialityLevel != null) {
            this.cbConfidentialityLevel.setItems(FXCollections.observableArrayList((Object[])ConfidentialityLevel.values()));
        }
        this.applyVerticalHeadersWhenSkinReady();
        if (this.tabPane != null && this.tabFailureChains != null) {
            onFailureTab = Bindings.createBooleanBinding(() -> this.tabPane.getSelectionModel().getSelectedItem() == this.tabFailureChains, (Observable[])new Observable[]{this.tabPane.getSelectionModel().selectedItemProperty()});
            if (this.btnAddFailureChain != null) {
                this.btnAddFailureChain.disableProperty().unbind();
                this.btnAddFailureChain.disableProperty().bind((ObservableValue)onFailureTab.not());
            }
            if (this.btnDelete != null && this.tblRows != null) {
                this.btnDelete.disableProperty().unbind();
                deleteDisable = onFailureTab.not().or((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.tblRows.editingCellProperty())).or((ObservableBooleanValue)this.tblRows.getSelectionModel().selectedItemProperty().isNull());
                this.btnDelete.disableProperty().bind((ObservableValue)deleteDisable);
            }
        }
        if (this.tabPane != null && this.tabPfmeaTreeChart != null) {
            this.tabPane.getSelectionModel().selectedItemProperty().addListener((obs, oldTab, newTab) -> {
                if (newTab == this.tabPfmeaTreeChart && !this.treeLoaded) {
                    this.loadPfmeaTreePage();
                    this.treeLoaded = true;
                }
            });
        }
        this.wireExportButton();
    }

    private void wireExportButton() {
        if (this.btnExportToPDF != null && this.btnExportToPDF.getOnAction() == null) {
            this.btnExportToPDF.setOnAction(event -> this.onExport());
        }
    }

    @FXML
    private void onOpenPfmeaTables() {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/PfmeaTables.fxml"));
            Parent dialogContent = (Parent)loader.load();
            Stage dialog = new Stage();
            dialog.setTitle("PFMEA S-O-D Tables");
            if (this.btnPfmeaTables != null && this.btnPfmeaTables.getScene() != null) {
                dialog.initOwner(this.btnPfmeaTables.getScene().getWindow());
            }
            dialog.setScene(new Scene(dialogContent));
            dialog.show();
        }
        catch (IOException ex) {
            this.showError("Unable to open PFMEA tables window.", ex);
        }
    }

    @FXML
    private void onExport() {
        ExportFormat format = this.promptExportFormat("Select the format for exporting the PFMEA");
        if (format == null) {
            return;
        }
        switch (format.ordinal()) {
            case 0: {
                this.exportToPdf();
                break;
            }
            case 1: {
                this.exportToExcel();
                break;
            }
        }
    }

    private void exportToPdf() {
        File file;
        if (this.pfmea == null) {
            this.showExportError("No PFMEA loaded.");
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Export PFMEA to PDF");
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Arquivos PDF (*.pdf)", new String[]{"*.pdf"}));
        String processName = this.extractProcessNameForFile(this.pfmea);
        String revision = this.findLastApprovedRevisionForFile(this.pfmea);
        String baseName = ("PFMEA for " + (processName.isBlank() ? "Process" : processName) + (String)(revision.isBlank() ? "" : " Rev " + revision)).trim();
        chooser.setInitialFileName(ExportFileNameUtil.suggestedName(baseName, "PFMEA for Process", "pdf"));
        ExportDirectoryPreferences.applyInitialDirectory(chooser);
        Window owner = this.btnExportToPDF != null && this.btnExportToPDF.getScene() != null ? this.btnExportToPDF.getScene().getWindow() : null;
        File file2 = file = owner != null ? chooser.showSaveDialog(owner) : chooser.showSaveDialog(null);
        if (file == null) {
            return;
        }
        ExportDirectoryPreferences.rememberExportDirectory(file.getParentFile());
        try {
            Path logoPath = ExportLogoPreferences.getRememberedLogoPath().orElse(null);
            PfmeaPdfGenerator.generatePfmeaPdf(this.pfmea, file.toPath(), logoPath);
            this.showExportInfo("PDF generated successfully:\n" + file.getAbsolutePath());
        }
        catch (IOException | DocumentException ex) {
            this.showExportError("Error generating PDF: " + this.buildExceptionMessage((Exception)ex));
        }
    }

    private void exportToExcel() {
        File file;
        if (this.pfmea == null) {
            this.showExportError("No PFMEA loaded.");
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Export PFMEA to Excel");
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Planilha Excel (*.xlsx)", new String[]{"*.xlsx"}));
        String processName = this.extractProcessNameForFile(this.pfmea);
        String revision = this.findLastApprovedRevisionForFile(this.pfmea);
        String baseName = ("PFMEA for " + (processName.isBlank() ? "Process" : processName) + (String)(revision.isBlank() ? "" : " Rev " + revision)).trim();
        chooser.setInitialFileName(ExportFileNameUtil.suggestedName(baseName, "PFMEA for Process", "xlsx"));
        ExportDirectoryPreferences.applyInitialDirectory(chooser);
        Window owner = this.resolveWindowForButton();
        File file2 = file = owner != null ? chooser.showSaveDialog(owner) : chooser.showSaveDialog(null);
        if (file == null) {
            return;
        }
        ExportDirectoryPreferences.rememberExportDirectory(file.getParentFile());
        try {
            Path logoPath = ExportLogoPreferences.getRememberedLogoPath().orElse(null);
            PfmeaExcelExporter.export(this.pfmea, file.toPath(), logoPath);
            this.showExportInfo("Excel file generated successfully:\n" + file.getAbsolutePath());
        }
        catch (IOException ex) {
            this.showExportError("Error generating Excel: " + this.buildExceptionMessage(ex));
        }
    }

    private ExportFormat promptExportFormat(String header) {
        Dialog dialog = new Dialog();
        dialog.setTitle("Export");
        dialog.setHeaderText(header);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        ToggleGroup group = new ToggleGroup();
        RadioButton pdfOption = new RadioButton("PDF");
        pdfOption.setToggleGroup(group);
        pdfOption.setSelected(true);
        RadioButton excelOption = new RadioButton("Excel");
        excelOption.setToggleGroup(group);
        pdfOption.setGraphic((Node)this.icon(this.icPdf, 14.0));
        excelOption.setGraphic((Node)this.icon(this.icExcel, 14.0));
        VBox box = new VBox(8.0, new Node[]{pdfOption, excelOption});
        box.setPadding(new Insets(4.0, 0.0, 0.0, 12.0));
        dialog.getDialogPane().setContent((Node)box);
        Window owner = this.resolveWindowForButton();
        if (owner != null) {
            dialog.initOwner(owner);
        }
        dialog.setResultConverter(button -> {
            if (button == ButtonType.OK) {
                return group.getSelectedToggle() == excelOption ? ExportFormat.EXCEL : ExportFormat.PDF;
            }
            return null;
        });
        return dialog.showAndWait().orElse(null);
    }

    private void loadIcons() {
        this.icFailureChain = this.loadIcon("failure_chain", 18.0);
        this.icPdf = this.loadIcon("pdf", 14.0);
        this.icExcel = this.loadIcon("excel", 14.0);
        this.icTable = this.loadIcon("table", 16.0);
        this.icPlus = this.loadIcon("plus", 16.0);
        this.icTrash = this.loadIcon("trash", 16.0);
        this.icApprove = this.loadIcon("approve", 16.0);
        this.icEdit = this.loadIcon("edit", 16.0);
        this.icSave = this.loadIcon("save", 18.0);
        this.icExit = this.loadIcon("exit", 18.0);
        this.icSearch = this.loadIcon("search", 24.0);
    }

    private Image loadIcon(String name, double size) {
        InputStream stream = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        if (stream == null) {
            return null;
        }
        return new Image(stream, size, size, true, true);
    }

    private ImageView icon(Image img, double size) {
        if (img == null) {
            return null;
        }
        ImageView iv = new ImageView(img);
        iv.setPreserveRatio(true);
        iv.setFitWidth(size);
        iv.setFitHeight(size);
        iv.setSmooth(true);
        return iv;
    }

    private void ensureTooltip(Button btn, String fallbackText) {
        if (btn == null) {
            return;
        }
        String text = btn.getText();
        if ((text == null || text.isBlank()) && fallbackText != null) {
            text = fallbackText;
        }
        if (text == null || text.isBlank()) {
            return;
        }
        Tooltip tip = btn.getTooltip();
        if (tip == null || tip.getText() == null || tip.getText().isBlank()) {
            btn.setTooltip(new Tooltip(text));
        }
    }

    private void applyDefaultTooltips() {
        this.ensureTooltip(this.btnAddFailureChain, "Add failure chain");
        this.ensureTooltip(this.btnDelete, "Delete selected row");
        this.ensureTooltip(this.btnSaveOnly, "Save current PFMEA");
        this.ensureTooltip(this.btnSaveExit, "Save current PFMEA and close");
        this.ensureTooltip(this.btnPfmeaTables, "Open S-O-D tables");
        this.ensureTooltip(this.btnExportToPDF, "Export PFMEA");
        this.ensureTooltip(this.btnRevAdd, "Add revision");
        this.ensureTooltip(this.btnRevEdit, "Edit revision");
        this.ensureTooltip(this.btnRevApprove, "Approve revision");
        this.ensureTooltip(this.btnRevDelete, "Delete revision");
        this.ensureTooltip(this.btnNext, "Search next match");
    }

    private Window resolveWindowForButton() {
        if (this.ownerStage != null) {
            return this.ownerStage;
        }
        if (this.btnExportToPDF != null && this.btnExportToPDF.getScene() != null) {
            return this.btnExportToPDF.getScene().getWindow();
        }
        return null;
    }

    private void showExportInfo(String msg) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("Export");
        alert.setHeaderText(null);
        alert.setContentText(msg);
        alert.showAndWait();
    }

    private void showExportError(String msg) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Erro");
        alert.setHeaderText("Failed to export the file");
        alert.setContentText(msg);
        alert.showAndWait();
    }

    private String buildExceptionMessage(Exception ex) {
        if (ex == null) {
            return "";
        }
        String message = ex.getMessage();
        return message == null || message.isBlank() ? ex.getClass().getSimpleName() : message;
    }

    private String extractProcessNameForFile(Pfmea model) {
        String[] candidates;
        if (model == null) {
            return "";
        }
        for (String candidate : candidates = new String[]{model.getPfmeaSubject(), model.getProcessResponsibility(), model.getCustomerName(), model.getCompanyName()}) {
            String trimmed;
            if (candidate == null || (trimmed = candidate.trim()).isEmpty()) continue;
            return trimmed;
        }
        return "";
    }

    private String findLastApprovedRevisionForFile(Pfmea model) {
        if (model == null) {
            return "";
        }
        Optional<String> latestApproved = model.latestApprovedRevision().map(entry -> {
            String rev = entry.getRevisionNumber();
            return rev != null ? rev.trim() : "";
        }).filter(rev -> !rev.isEmpty());
        if (latestApproved.isPresent()) {
            return latestApproved.get();
        }
        for (String m : new String[]{"getLastApprovedRevision", "getApprovedRevision", "getCurrentApprovedRevision"}) {
            try {
                Method mm = model.getClass().getMethod(m, new Class[0]);
                Object v = mm.invoke((Object)model, new Object[0]);
                if (v == null || v.toString().trim().isEmpty()) continue;
                return v.toString().trim();
            }
            catch (ReflectiveOperationException mm) {
                // empty catch block
            }
        }
        for (String listGetter : new String[]{"getRevisions", "getRevisionHistory", "getPfmeaRevisions"}) {
            try {
                Method mg = model.getClass().getMethod(listGetter, new Class[0]);
                Object list = mg.invoke((Object)model, new Object[0]);
                if (!(list instanceof Iterable)) continue;
                Iterable it = (Iterable)list;
                String best = "";
                for (Object rev2 : it) {
                    boolean approved = false;
                    try {
                        Method ma = rev2.getClass().getMethod("isApproved", new Class[0]);
                        Object a = ma.invoke(rev2, new Object[0]);
                        approved = Boolean.TRUE.equals(a);
                    }
                    catch (ReflectiveOperationException ignore) {
                        try {
                            Method ms = rev2.getClass().getMethod("getStatus", new Class[0]);
                            Object st = ms.invoke(rev2, new Object[0]);
                            if (st != null) {
                                String s = st.toString().toUpperCase();
                                approved = s.contains("APPROVED");
                            }
                        }
                        catch (ReflectiveOperationException ignore2) {
                            try {
                                Method ma2 = rev2.getClass().getMethod("getApprovalStatus", new Class[0]);
                                Object st = ma2.invoke(rev2, new Object[0]);
                                if (st != null) {
                                    String s = st.toString().toUpperCase();
                                    approved = s.contains("APPROVED");
                                }
                            }
                            catch (ReflectiveOperationException reflectiveOperationException) {
                                // empty catch block
                            }
                        }
                    }
                    if (!approved) continue;
                    String code = null;
                    for (String cg : new String[]{"getCode", "getRevision", "getRevisionNumber"}) {
                        try {
                            Method mc = rev2.getClass().getMethod(cg, new Class[0]);
                            Object v = mc.invoke(rev2, new Object[0]);
                            if (v == null || v.toString().trim().isEmpty()) continue;
                            code = v.toString().trim();
                            break;
                        }
                        catch (ReflectiveOperationException reflectiveOperationException) {
                            // empty catch block
                        }
                    }
                    if (code == null || code.isBlank() || !best.isEmpty() && code.compareTo(best) <= 0) continue;
                    best = code;
                }
                if (best.isEmpty()) continue;
                return best;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        try {
            Method m = model.getClass().getMethod("getPfmeaRevision", new Class[0]);
            Object v = m.invoke((Object)model, new Object[0]);
            if (v != null && !v.toString().trim().isEmpty()) {
                return v.toString().trim();
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return "";
    }

    private void loadPfmeaTreePage() {
        if (this.webFta == null) {
            return;
        }
        WebEngine engine = this.webFta.getEngine();
        URL url = this.getClass().getResource("/html/pfmea-tree.html");
        if (url == null) {
            engine.loadContent("<h3>pfmea-tree.html not found</h3>");
            return;
        }
        engine.getLoadWorker().stateProperty().addListener((o, old, st) -> {
            if (st == Worker.State.SUCCEEDED) {
                Platform.runLater(this::sendPfmeaJsonToPage);
            }
        });
        engine.load(url.toExternalForm());
    }

    private void sendPfmeaJsonToPage() {
        if (this.webFta == null || this.pfmea == null) {
            return;
        }
        String json = this.toPfmeaJson(this.pfmea);
        try {
            this.webFta.getEngine().executeScript("window.renderPfmea && window.renderPfmea(" + json + ");");
        }
        catch (Exception ex) {
            System.err.println("[PFMEA] renderPfmea call failed: " + ex.getMessage());
        }
    }

    private String toPfmeaJson(Pfmea model) {
        String subject = model.getPfmeaSubject() != null && !model.getPfmeaSubject().isBlank() ? model.getPfmeaSubject() : "Process Tree Root";
        StringBuilder sb = new StringBuilder(1024);
        sb.append("{\"subject\":\"").append(PfmeaWindowController.escapeJson(subject)).append("\",\"rows\":[");
        boolean first = true;
        for (PfmeaRow r : model.getFailureChains()) {
            if (!first) {
                sb.append(',');
            }
            first = false;
            String higherTxt = PfmeaWindowController.nz(r.getNextHigherLevelText());
            String higherFn = PfmeaWindowController.nz(r.getNextHigherLevelFunction());
            String focusTxt = PfmeaWindowController.nz(r.getFocusElementText());
            String focusFn = PfmeaWindowController.nz(r.getFocusElementFunctionRequirement());
            String lowerTxtParam = PfmeaWindowController.nz(r.getNextLowerLevelOrParameterText());
            String lowerFnParam = PfmeaWindowController.nz(r.getNextLowerLevelFunctionRequirementOrParameter());
            String fe = PfmeaWindowController.nz(r.getFailureEffect());
            String fm = PfmeaWindowController.nz(r.getFailureMode());
            String fc = PfmeaWindowController.nz(r.getFailureCause());
            String prevCtrl = PfmeaWindowController.nz(r.getPreventionControl());
            String detCtrl = PfmeaWindowController.nz(r.getDetectionControl());
            String ap = r.getActionPriority() == null ? "LOW" : r.getActionPriority().name();
            sb.append("{").append("\"nextHigherLevelText\":\"").append(PfmeaWindowController.escapeJson(higherTxt)).append("\",").append("\"nextHigherLevelFunction\":\"").append(PfmeaWindowController.escapeJson(higherFn)).append("\",").append("\"focusElementText\":\"").append(PfmeaWindowController.escapeJson(focusTxt)).append("\",").append("\"focusElementFunctionRequirement\":\"").append(PfmeaWindowController.escapeJson(focusFn)).append("\",").append("\"nextLowerLevelOrParameterText\":\"").append(PfmeaWindowController.escapeJson(lowerTxtParam)).append("\",").append("\"nextLowerLevelFunctionRequirementOrParameter\":\"").append(PfmeaWindowController.escapeJson(lowerFnParam)).append("\",").append("\"nextLowerLevelOrCharacteristicText\":\"").append(PfmeaWindowController.escapeJson(lowerTxtParam)).append("\",").append("\"nextLowerLevelFunctionRequirementOrCharacteristic\":\"").append(PfmeaWindowController.escapeJson(lowerFnParam)).append("\",").append("\"failureEffect\":\"").append(PfmeaWindowController.escapeJson(fe)).append("\",").append("\"failureMode\":\"").append(PfmeaWindowController.escapeJson(fm)).append("\",").append("\"failureCause\":\"").append(PfmeaWindowController.escapeJson(fc)).append("\",").append("\"preventionControl\":\"").append(PfmeaWindowController.escapeJson(prevCtrl)).append("\",").append("\"detectionControl\":\"").append(PfmeaWindowController.escapeJson(detCtrl)).append("\",").append("\"actionPriority\":\"").append(PfmeaWindowController.escapeJson(ap)).append("\"").append("}");
        }
        sb.append("]}");
        return sb.toString();
    }

    private static String nz(String s) {
        return s == null ? "" : s;
    }

    private static String escapeJson(String s) {
        StringBuilder out = new StringBuilder(s.length() + 16);
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    out.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    out.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    out.append("\\b");
                    continue block9;
                }
                case '\f': {
                    out.append("\\f");
                    continue block9;
                }
                case '\n': {
                    out.append("\\n");
                    continue block9;
                }
                case '\r': {
                    out.append("\\r");
                    continue block9;
                }
                case '\t': {
                    out.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        out.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    private void loadHeaderFromModel() {
        if (this.pfmea == null) {
            return;
        }
        if (this.txtCompanyName != null) {
            this.txtCompanyName.setText(PfmeaWindowController.s(this.pfmea.getCompanyName()));
        }
        if (this.txtPlantLocation != null) {
            this.txtPlantLocation.setText(PfmeaWindowController.s(this.pfmea.getPlantLocation()));
        }
        if (this.txtCustomerName != null) {
            this.txtCustomerName.setText(PfmeaWindowController.s(this.pfmea.getCustomerName()));
        }
        if (this.txtModelYearPlatform != null) {
            this.txtModelYearPlatform.setText(PfmeaWindowController.s(this.pfmea.getModelYearPlatform()));
        }
        if (this.txtPfmeaSubject != null) {
            this.txtPfmeaSubject.setText(PfmeaWindowController.s(this.pfmea.getPfmeaSubject()));
        }
        if (this.dpPfmeaStartDate != null) {
            this.dpPfmeaStartDate.setValue((Object)this.pfmea.getPfmeaStartDate());
        }
        if (this.dpPfmeaRevisionDate != null) {
            this.dpPfmeaRevisionDate.setValue((Object)this.pfmea.getPfmeaLastRevisionDate());
        }
        if (this.txtCrossFunctionalTeam != null) {
            this.txtCrossFunctionalTeam.setText(PfmeaWindowController.s(this.pfmea.getCrossFunctionalTeam()));
        }
        if (this.txtPfmeaIdNumber != null) {
            this.txtPfmeaIdNumber.setText(PfmeaWindowController.s(this.pfmea.getPfmeaIdNumber()));
        }
        if (this.txtProcessResponsibility != null) {
            this.txtProcessResponsibility.setText(PfmeaWindowController.s(this.pfmea.getProcessResponsibility()));
        }
        if (this.cbConfidentialityLevel != null) {
            this.cbConfidentialityLevel.setValue((Object)this.pfmea.getConfidentialityLevel());
        }
        this.updateWindowTitle(PfmeaWindowController.s(this.pfmea.getPfmeaSubject()));
    }

    private void wireHeaderBindings() {
        if (this.pfmea == null) {
            return;
        }
        this.onText(this.txtCompanyName, this.pfmea::setCompanyName);
        this.onText(this.txtPlantLocation, this.pfmea::setPlantLocation);
        this.onText(this.txtCustomerName, this.pfmea::setCustomerName);
        this.onText(this.txtModelYearPlatform, this.pfmea::setModelYearPlatform);
        this.onText(this.txtPfmeaSubject, v -> {
            this.pfmea.setPfmeaSubject((String)v);
            this.updateWindowTitle((String)v);
            this.updatePathLabel();
        });
        this.onDate(this.dpPfmeaStartDate, this.pfmea::setPfmeaStartDate);
        this.onDate(this.dpPfmeaRevisionDate, this.pfmea::setPfmeaLastRevisionDate);
        this.onText(this.txtCrossFunctionalTeam, this.pfmea::setCrossFunctionalTeam);
        this.onText(this.txtPfmeaIdNumber, this.pfmea::setPfmeaIdNumber);
        this.onText(this.txtProcessResponsibility, this.pfmea::setProcessResponsibility);
        if (this.cbConfidentialityLevel != null) {
            this.cbConfidentialityLevel.valueProperty().addListener((o, ov, nv) -> {
                this.pfmea.setConfidentialityLevel((ConfidentialityLevel)((Object)nv));
                this.dirtyHook.run();
            });
        }
    }

    private List<ProcessItem> findMatches(String partial) {
        List<ProcessItem> all;
        List<ProcessItem> list = all = this.processProvider == null ? null : this.processProvider.get();
        if (all == null || all.isEmpty()) {
            return List.of();
        }
        String p = partial == null ? "" : partial.trim().toLowerCase();
        return all.stream().filter(it -> p.isBlank() || it.getDescription() != null && it.getDescription().toLowerCase().contains(p) || it.getFunction() != null && it.getFunction().toLowerCase().contains(p)).limit(200L).toList();
    }

    private void buildMentionMenu(ContextMenu menu, List<ProcessItem> items, Consumer<ProcessItem> onChoose) {
        menu.getItems().clear();
        EnumMap<ProcessType, List> byType = new EnumMap<ProcessType, List>(ProcessType.class);
        for (ProcessType type : ProcessType.values()) {
            byType.put(type, new ArrayList());
        }
        for (ProcessItem it : items) {
            byType.getOrDefault((Object)it.getType(), (List)byType.get((Object)ProcessType.PROCESS)).add(it);
        }
        boolean firstGroup = true;
        for (ProcessType type : ProcessType.values()) {
            List grouped = (List)byType.get((Object)type);
            if (grouped == null || grouped.isEmpty()) continue;
            if (!firstGroup) {
                menu.getItems().add((Object)new SeparatorMenuItem());
            }
            firstGroup = false;
            MenuItem header = new MenuItem("\u2014 " + this.plural(type.getLabel()) + " \u2014");
            header.setDisable(true);
            menu.getItems().add((Object)header);
            boolean first = true;
            for (ProcessItem it : grouped) {
                if (!first) {
                    menu.getItems().add((Object)new SeparatorMenuItem());
                }
                first = false;
                menu.getItems().add((Object)this.makeMentionMenuItem(it, onChoose));
            }
        }
    }

    private String subjectMentionText(ProcessItem it) {
        if (it == null) {
            return "";
        }
        String name = it.getDescription();
        return name == null || name.isBlank() ? "(unnamed)" : name;
    }

    private MenuItem makeMentionMenuItem(ProcessItem it, Consumer<ProcessItem> onChoose) {
        String name = this.subjectMentionText(it);
        String function = it.getFunction() == null ? "" : it.getFunction().trim();
        String typeTag = it.getType() == null ? "" : it.getType().getLabel();
        Label title = new Label(name);
        title.setStyle("-fx-font-size: 12px;");
        String subText = (String)(function.isBlank() ? "" : function + "  \u00b7 ") + typeTag;
        Label sub = new Label(subText);
        sub.setStyle("-fx-text-fill: #666666; -fx-font-size: 11px;");
        VBox box = new VBox(2.0, new Node[]{title, sub});
        MenuItem mi = new MenuItem();
        mi.setGraphic((Node)box);
        mi.setMnemonicParsing(false);
        mi.setOnAction(e -> onChoose.accept(it));
        return mi;
    }

    private void onText(TextField tf, Consumer<String> writeBack) {
        if (tf == null) {
            return;
        }
        tf.textProperty().addListener((o, ov, nv) -> {
            writeBack.accept(nv == null ? "" : nv);
            this.dirtyHook.run();
        });
    }

    private void onDate(DatePicker dp, Consumer<LocalDate> writeBack) {
        if (dp == null) {
            return;
        }
        dp.valueProperty().addListener((o, ov, nv) -> {
            writeBack.accept((LocalDate)nv);
            this.dirtyHook.run();
        });
    }

    private void updateWindowTitle(String subject) {
        if (this.ownerStage == null) {
            return;
        }
        this.ownerStage.setTitle((String)(subject == null || subject.isBlank() ? "PFMEA" : "PFMEA - " + subject));
    }

    private void updatePathLabel() {
        List<ProcessItem> processes;
        String subject;
        if (this.lblPath == null) {
            return;
        }
        String string = subject = this.pfmea == null ? "" : PfmeaWindowController.s(this.pfmea.getPfmeaSubject());
        if (subject.isBlank() && !(processes = this.availableProcesses()).isEmpty()) {
            subject = this.displayName(processes.get(0));
        }
        this.lblPath.setText(subject.isBlank() ? "(unspecified PFMEA)" : subject);
    }

    private List<ProcessItem> availableProcesses() {
        if (this.processProvider == null) {
            return List.of();
        }
        List<ProcessItem> items = this.processProvider.get();
        return items == null ? List.of() : items;
    }

    private static String s(String v) {
        return v == null ? "" : v;
    }

    private void initRevisionTab() {
        if (this.tblRevisions == null) {
            return;
        }
        this.colRevNumber.setCellValueFactory((Callback)new PropertyValueFactory("revisionNumber"));
        this.colRevDate.setCellValueFactory((Callback)new PropertyValueFactory("revisionDate"));
        this.colRevAuthor.setCellValueFactory((Callback)new PropertyValueFactory("authorName"));
        this.colRevDesc.setCellValueFactory((Callback)new PropertyValueFactory("descriptionOfChanges"));
        this.colRevStatus.setCellValueFactory((Callback)new PropertyValueFactory("approvalStatus"));
        this.colRevStatus.setCellFactory(col -> new TableCell<RevisionEntry, ApprovalStatus>(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void updateItem(ApprovalStatus status, boolean empty) {
                super.updateItem((Object)status, empty);
                this.setText(empty || status == null ? "" : status.getApprovalStatus());
            }
        });
        this.tblRevisions.setItems(this.pfmea.getRevisionHistory());
        this.tblRevisions.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            boolean has;
            boolean bl = has = nv != null;
            if (this.btnRevEdit != null) {
                this.btnRevEdit.setDisable(!has);
            }
            if (this.btnRevApprove != null) {
                this.btnRevApprove.setDisable(!has);
            }
            if (this.btnRevDelete != null) {
                this.btnRevDelete.setDisable(!has);
            }
        });
        if (this.btnRevAdd != null) {
            this.btnRevAdd.setOnAction(e -> this.onRevAdd());
        }
        if (this.btnRevEdit != null) {
            this.btnRevEdit.setOnAction(e -> this.onRevEdit());
        }
        if (this.btnRevApprove != null) {
            this.btnRevApprove.setOnAction(e -> this.onRevApprove());
        }
        if (this.btnRevDelete != null) {
            this.btnRevDelete.setOnAction(e -> this.onRevDelete());
        }
        if (this.btnRevAdd != null) {
            this.btnRevAdd.setGraphic((Node)this.icon(this.icPlus, 16.0));
        }
        if (this.btnRevEdit != null) {
            this.btnRevEdit.setGraphic((Node)this.icon(this.icEdit, 16.0));
        }
        if (this.btnRevApprove != null) {
            this.btnRevApprove.setGraphic((Node)this.icon(this.icApprove, 16.0));
        }
        if (this.btnRevDelete != null) {
            this.btnRevDelete.setGraphic((Node)this.icon(this.icTrash, 16.0));
        }
    }

    private void onRevAdd() {
        if (!this.ensureEditPermission()) {
            return;
        }
        RevisionEntry data = this.showRevisionDialog(null);
        if (data == null) {
            return;
        }
        this.pfmea.getRevisionHistory().add((Object)data);
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        if (this.tblRevisions != null) {
            this.tblRevisions.getSelectionModel().select((Object)data);
            this.tblRevisions.scrollTo((Object)data);
        }
    }

    private void onRevEdit() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.tblRevisions == null) {
            return;
        }
        RevisionEntry sel = (RevisionEntry)this.tblRevisions.getSelectionModel().getSelectedItem();
        if (sel == null) {
            return;
        }
        RevisionEntry edited = this.showRevisionDialog(sel);
        if (edited == null) {
            return;
        }
        sel.setRevisionNumber(edited.getRevisionNumber());
        sel.setRevisionDate(edited.getRevisionDate());
        sel.setAuthorName(edited.getAuthorName());
        sel.setDescriptionOfChanges(edited.getDescriptionOfChanges());
        this.tblRevisions.refresh();
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private void onRevApprove() {
        if (!this.ensureApprovalPermission()) {
            return;
        }
        if (this.tblRevisions == null) {
            return;
        }
        RevisionEntry sel = (RevisionEntry)this.tblRevisions.getSelectionModel().getSelectedItem();
        if (sel == null) {
            return;
        }
        this.pfmea.approveRevision(sel);
        this.tblRevisions.refresh();
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private void onRevDelete() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.tblRevisions == null) {
            return;
        }
        RevisionEntry sel = (RevisionEntry)this.tblRevisions.getSelectionModel().getSelectedItem();
        if (sel == null) {
            return;
        }
        this.pfmea.removeRevision(sel);
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private RevisionEntry showRevisionDialog(RevisionEntry existing) {
        Dialog dlg = new Dialog();
        dlg.setTitle(existing == null ? "Add Revision" : "Edit Revision");
        dlg.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        TextField tfRev = new TextField(existing == null ? "" : PfmeaWindowController.s(existing.getRevisionNumber()));
        DatePicker dpDate = new DatePicker(existing == null ? LocalDate.now() : existing.getRevisionDate());
        TextField tfAuth = new TextField(existing == null ? "" : PfmeaWindowController.s(existing.getAuthorName()));
        TextArea taDesc = new TextArea(existing == null ? "" : PfmeaWindowController.s(existing.getDescriptionOfChanges()));
        taDesc.setPrefRowCount(4);
        GridPane gp = new GridPane();
        gp.setHgap(8.0);
        gp.setVgap(8.0);
        gp.setPadding(new Insets(10.0));
        gp.add((Node)new Label("Revision:"), 0, 0);
        gp.add((Node)tfRev, 1, 0);
        gp.add((Node)new Label("Date:"), 0, 1);
        gp.add((Node)dpDate, 1, 1);
        gp.add((Node)new Label("Author:"), 0, 2);
        gp.add((Node)tfAuth, 1, 2);
        gp.add((Node)new Label("Description:"), 0, 3);
        gp.add((Node)taDesc, 1, 3);
        dlg.getDialogPane().setContent((Node)gp);
        Node okBtn = dlg.getDialogPane().lookupButton(ButtonType.OK);
        okBtn.disableProperty().bind((ObservableValue)tfRev.textProperty().isEmpty().or((ObservableBooleanValue)tfAuth.textProperty().isEmpty()).or((ObservableBooleanValue)dpDate.valueProperty().isNull()));
        Optional res = dlg.showAndWait();
        if (res.isEmpty() || res.get() != ButtonType.OK) {
            return null;
        }
        if (existing == null) {
            return new RevisionEntry(tfRev.getText().trim(), (LocalDate)dpDate.getValue(), tfAuth.getText().trim(), taDesc.getText().trim(), ApprovalStatus.DRAFT);
        }
        return new RevisionEntry(tfRev.getText().trim(), (LocalDate)dpDate.getValue(), tfAuth.getText().trim(), taDesc.getText().trim(), existing.getApprovalStatus());
    }

    private void setupFailureChainsTable() {
        if (this.tblRows == null) {
            return;
        }
        this.tblRows.setEditable(true);
        this.tblRows.getSelectionModel().setCellSelectionEnabled(true);
        this.mentionTextCol(this.colNextHigherLevel, PfmeaRow::nextHigherLevelTextProperty, MentionKind.HIGHER);
        this.mentionTextCol(this.colFocusElement, PfmeaRow::focusElementTextProperty, MentionKind.FOCUS);
        this.mentionTextCol(this.colNextLowerLevelOrParameter, PfmeaRow::nextLowerLevelOrParameterTextProperty, MentionKind.LOWER);
        this.textColWrapped(this.colChangeAuthorization, PfmeaRow::changeAuthorizationProperty);
        this.textColWrapped(this.colNextHigherLevelFunction, PfmeaRow::nextHigherLevelFunctionProperty);
        this.textColWrapped(this.colFocusElementFunctionRequirement, PfmeaRow::focusElementFunctionRequirementProperty);
        this.textColWrapped(this.colNextLowerLevelFunctionRequirementOrParameter, PfmeaRow::nextLowerLevelFunctionRequirementOrParameterProperty);
        this.textColWrapped(this.colFailureEffect, PfmeaRow::failureEffectProperty);
        this.textColWrapped(this.colFailureMode, PfmeaRow::failureModeProperty);
        this.textColWrapped(this.colFailureCause, PfmeaRow::failureCauseProperty);
        this.textColWrapped(this.colPreventionControl, PfmeaRow::preventionControlProperty);
        this.textColWrapped(this.colDetectionControl, PfmeaRow::detectionControlProperty);
        this.textColWrapped(this.colFilterCode, PfmeaRow::filterCodeProperty);
        this.textColWrapped(this.colPreventiveAction, PfmeaRow::preventiveActionProperty);
        this.textColWrapped(this.colDetectionAction, PfmeaRow::detectionActionProperty);
        this.textColWrapped(this.colResponsiblePerson, PfmeaRow::responsiblePersonProperty);
        this.datePickerCol(this.colTargetCompletionDate, PfmeaRow::targetCompletionDateProperty);
        this.datePickerCol(this.colCompletionDate, PfmeaRow::completionDateProperty);
        this.textColWrapped(this.colActionTakenEvidence, PfmeaRow::actionTakenEvidenceProperty);
        this.textColWrapped(this.colRemarks, PfmeaRow::remarksProperty);
        this.integerCol(this.colIssue, PfmeaRow::issueNumberProperty);
        this.enumCol(this.colSeverity, PfmeaRow.Severity.values(), PfmeaRow::severityProperty, PfmeaRow.Severity::getValue);
        this.enumCol(this.colOccurrence, PfmeaRow.Occurrence.values(), PfmeaRow::occurrenceProperty, PfmeaRow.Occurrence::getValue);
        this.enumCol(this.colDetection, PfmeaRow.Detection.values(), PfmeaRow::detectionProperty, PfmeaRow.Detection::getValue);
        this.enumCol(this.colCurrentSeverity, PfmeaRow.Severity.values(), PfmeaRow::currentSeverityProperty, PfmeaRow.Severity::getValue);
        this.enumCol(this.colCurrentOccurrence, PfmeaRow.Occurrence.values(), PfmeaRow::currentOccurrenceProperty, PfmeaRow.Occurrence::getValue);
        this.enumCol(this.colCurrentDetection, PfmeaRow.Detection.values(), PfmeaRow::currentDetectionProperty, PfmeaRow.Detection::getValue);
        this.readOnlyApCol(this.colActionPriority, PfmeaRow::actionPriorityProperty);
        this.readOnlyApCol(this.colCurrentActionPriority, PfmeaRow::currentActionPriorityProperty);
        this.colStatus.setCellValueFactory(cell -> ((PfmeaRow)cell.getValue()).statusProperty());
        StringConverter<PfmeaRow.PfmeaStatus> statusConverter = new StringConverter<PfmeaRow.PfmeaStatus>(this){
            {
                Objects.requireNonNull(this$0);
            }

            public String toString(PfmeaRow.PfmeaStatus s) {
                if (s == null) {
                    return "";
                }
                return switch (s) {
                    default -> throw new MatchException(null, null);
                    case PfmeaRow.PfmeaStatus.OPEN -> "Open";
                    case PfmeaRow.PfmeaStatus.PENDING_DECISION -> "Pending decision";
                    case PfmeaRow.PfmeaStatus.PENDING_IMPLEMENTATION -> "Pending implementation";
                    case PfmeaRow.PfmeaStatus.COMPLETED -> "Completed";
                    case PfmeaRow.PfmeaStatus.NOT_IMPLEMENTED -> "Not implemented";
                };
            }

            public PfmeaRow.PfmeaStatus fromString(String s) {
                return null;
            }
        };
        this.colStatus.setCellFactory(ComboBoxTableCell.forTableColumn((StringConverter)statusConverter, (ObservableList)FXCollections.observableArrayList((Object[])PfmeaRow.PfmeaStatus.values())));
        this.colStatus.setOnEditCommit(edit -> {
            PfmeaRow.PfmeaStatus newValue;
            PfmeaRow row = (PfmeaRow)edit.getRowValue();
            if (row == null) {
                return;
            }
            PfmeaRow.PfmeaStatus oldValue = row.getStatus();
            if (Objects.equals((Object)oldValue, (Object)(newValue = (PfmeaRow.PfmeaStatus)((Object)((Object)edit.getNewValue()))))) {
                return;
            }
            this.pushPfmeaUndo(() -> row.setStatus(oldValue));
            row.setStatus(newValue);
            if (this.dirtyHook != null) {
                this.dirtyHook.run();
            }
            if (this.tblRows != null) {
                this.tblRows.refresh();
            }
        });
        this.colRpn.setCellValueFactory(cd -> Bindings.createIntegerBinding(() -> {
            PfmeaRow row = (PfmeaRow)cd.getValue();
            int s = row.getSeverity() != null ? row.getSeverity().getValue() : 0;
            int o = row.getOccurrence() != null ? row.getOccurrence().getValue() : 0;
            int d = row.getDetection() != null ? row.getDetection().getValue() : 0;
            return s * o * d;
        }, (Observable[])new Observable[]{((PfmeaRow)cd.getValue()).severityProperty(), ((PfmeaRow)cd.getValue()).occurrenceProperty(), ((PfmeaRow)cd.getValue()).detectionProperty()}));
        this.tblRows.setOnKeyPressed(keyEvent -> {
            if (keyEvent.isControlDown() && keyEvent.getCode() == KeyCode.Z) {
                TablePosition<PfmeaRow, ?> snapshot = this.capturePfmeaFocus();
                if (this.performPfmeaUndo()) {
                    this.restorePfmeaFocus(snapshot);
                }
                keyEvent.consume();
                return;
            }
            switch (keyEvent.getCode()) {
                case INSERT: {
                    this.onAddChain();
                    break;
                }
                case DELETE: {
                    boolean changed;
                    if (this.tblRows.getEditingCell() == null && (changed = TableClipboardHelper.clearFocusedCell(this.tblRows, this::pushPfmeaUndo)) && this.dirtyHook != null) {
                        this.dirtyHook.run();
                    }
                    keyEvent.consume();
                    break;
                }
            }
        });
    }

    private void applyVerticalHeadersWhenSkinReady() {
        if (this.tblRows == null) {
            return;
        }
        this.tblRows.skinProperty().addListener((o, oldSkin, newSkin) -> {
            if (newSkin != null && !this.verticalHeadersApplied) {
                this.applyVerticalHeadersNow();
                this.verticalHeadersApplied = true;
            }
        });
        if (this.tblRows.getSkin() != null && !this.verticalHeadersApplied) {
            this.applyVerticalHeadersNow();
            this.verticalHeadersApplied = true;
        }
    }

    private void applyVerticalHeadersNow() {
        if (this.tblRows == null) {
            return;
        }
        TableUtils.makeHeaderVertical(this.tblRows, this.colSeverity, 110.0);
        TableUtils.makeHeaderVertical(this.tblRows, this.colCurrentSeverity, 110.0);
        TableUtils.makeHeaderVertical(this.tblRows, this.colOccurrence, 110.0);
        TableUtils.makeHeaderVertical(this.tblRows, this.colCurrentOccurrence, 110.0);
        TableUtils.makeHeaderVertical(this.tblRows, this.colDetection, 110.0);
        TableUtils.makeHeaderVertical(this.tblRows, this.colCurrentDetection, 110.0);
        TableUtils.wrapHeader(this.tblRows, this.colIssue, "Issue");
        TableUtils.wrapHeader(this.tblRows, this.colChangeAuthorization, "Change or Improvement Authorization");
        TableUtils.wrapHeader(this.tblRows, this.colNextHigherLevel, "Next Higher Level");
        TableUtils.wrapHeader(this.tblRows, this.colFocusElement, "Focus Element");
        TableUtils.wrapHeader(this.tblRows, this.colNextLowerLevelOrParameter, "Next Lower Level or Parameter");
        TableUtils.wrapHeader(this.tblRows, this.colNextHigherLevelFunction, "Higher Level Function");
        TableUtils.wrapHeader(this.tblRows, this.colFocusElementFunctionRequirement, "Focus Element Function or Requirement");
        TableUtils.wrapHeader(this.tblRows, this.colNextLowerLevelFunctionRequirementOrParameter, "Lower Level Function, Requirement or Parameter");
        TableUtils.wrapHeader(this.tblRows, this.colFailureEffect, "Failure Effect");
        TableUtils.wrapHeader(this.tblRows, this.colFailureMode, "Failure Mode");
        TableUtils.wrapHeader(this.tblRows, this.colFailureCause, "Failure Cause");
        TableUtils.wrapHeader(this.tblRows, this.colPreventionControl, "Prevention Control");
        TableUtils.wrapHeader(this.tblRows, this.colDetectionControl, "Detection Control");
        TableUtils.wrapHeader(this.tblRows, this.colActionPriority, "Action Priority");
        TableUtils.wrapHeader(this.tblRows, this.colRpn, "RPN");
        TableUtils.wrapHeader(this.tblRows, this.colFilterCode, "Filter Code");
        TableUtils.wrapHeader(this.tblRows, this.colPreventiveAction, "Preventive Action");
        TableUtils.wrapHeader(this.tblRows, this.colDetectionAction, "Detection Action");
        TableUtils.wrapHeader(this.tblRows, this.colResponsiblePerson, "Responsible Person");
        TableUtils.wrapHeader(this.tblRows, this.colTargetCompletionDate, "Target Date");
        TableUtils.wrapHeader(this.tblRows, this.colCompletionDate, "Completion Date");
        TableUtils.wrapHeader(this.tblRows, this.colStatus, "Status");
        TableUtils.wrapHeader(this.tblRows, this.colActionTakenEvidence, "Action Taken with Pointer to Evidence");
        TableUtils.wrapHeader(this.tblRows, this.colCurrentActionPriority, "Current Action Priority");
        TableUtils.wrapHeader(this.tblRows, this.colRemarks, "Remarks");
        TableUtils.setHeaderBackground(this.colNextHigherLevel, "#E0C2CD");
        TableUtils.setHeaderBackground(this.colNextHigherLevelFunction, "#E0C2CD");
        TableUtils.setHeaderBackground(this.colFailureEffect, "#E0C2CD");
        TableUtils.setHeaderBackground(this.colFocusElement, "#729FCF");
        TableUtils.setHeaderBackground(this.colFocusElementFunctionRequirement, "#729FCF");
        TableUtils.setHeaderBackground(this.colFailureMode, "#729FCF");
        TableUtils.setHeaderBackground(this.colNextLowerLevelOrParameter, "#8E86AE");
        TableUtils.setHeaderBackground(this.colNextLowerLevelFunctionRequirementOrParameter, "#8E86AE");
        TableUtils.setHeaderBackground(this.colFailureCause, "#8E86AE");
        this.tblRows.layout();
    }

    private void enableSubjectMentions() {
        if (this.txtPfmeaSubject == null) {
            return;
        }
        this.txtPfmeaSubject.textProperty().addListener((o, ov, nv) -> this.updatePathLabel());
        MentionSuggestionBehavior.install((TextInputControl)this.txtPfmeaSubject, this.mentionPopup, MentionSuggestionBehavior.config().allowedQueryChar(ch -> Character.isLetterOrDigit(ch.charValue()) || ch.charValue() == '_' || ch.charValue() == '-' || ch.charValue() == ' ').suggestions(this::findMatches).menuBuilder(this::buildMentionMenu).insertionText(this::subjectMentionText));
    }

    private void mentionTextCol(TableColumn<PfmeaRow, String> col, Function<PfmeaRow, StringProperty> textProp, MentionKind kind) {
        if (col == null) {
            return;
        }
        col.setCellValueFactory(cd -> (ObservableValue)textProp.apply((PfmeaRow)cd.getValue()));
        col.setCellFactory(tc -> {
            ContextMenu popup = new ContextMenu();
            return new WrapTextAreaTableCell(tc, () -> this.searchHighlightPattern, PfmeaWindowController::navigateFromCell, (cell, editor) -> MentionSuggestionBehavior.install((TextInputControl)editor, popup, MentionSuggestionBehavior.config().allowedQueryChar(ch -> Character.isLetterOrDigit(ch.charValue()) || ch.charValue() == '_' || ch.charValue() == '-' || ch.charValue() == ' ').suggestions(query -> {
                PfmeaRow rowObj;
                PfmeaRow pfmeaRow = rowObj = cell.getTableRow() == null ? null : (PfmeaRow)cell.getTableRow().getItem();
                if (!(rowObj instanceof PfmeaRow)) {
                    return List.of();
                }
                PfmeaRow row = rowObj;
                return switch (kind.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> this.suggestHigher((String)query);
                    case 1 -> this.suggestFocus(row, (String)query);
                    case 2 -> this.suggestLower(row, (String)query);
                };
            }).menuBuilder(this::buildMentionMenuForCell).insertionText(this::displayName).afterInsert((ctx, chosen) -> {
                PfmeaRow rowObj;
                PfmeaRow pfmeaRow = rowObj = cell.getTableRow() == null ? null : (PfmeaRow)cell.getTableRow().getItem();
                if (!(rowObj instanceof PfmeaRow)) {
                    return;
                }
                PfmeaRow row = rowObj;
                StringProperty property = (StringProperty)textProp.apply(row);
                if (property != null) {
                    property.set((Object)ctx.newText());
                }
                this.applySelection(kind, row, chosen);
            })));
        });
        col.setEditable(true);
    }

    private List<Object> suggestHigher(String query) {
        String filter = this.norm(query);
        LinkedHashSet<Object> seen = new LinkedHashSet<Object>();
        for (ProcessItem rootProcess : this.availableProcesses()) {
            this.collectToSet(rootProcess, seen, filter, true, true, false);
        }
        return new ArrayList<Object>(seen);
    }

    private List<Object> suggestFocus(PfmeaRow row, String query) {
        LinkedHashSet<Object> seen;
        block3: {
            ProcessItem higher;
            String filter;
            block2: {
                filter = this.norm(query);
                higher = row.getNextHigherLevel();
                seen = new LinkedHashSet<Object>();
                if (higher != null) break block2;
                for (ProcessItem rootProcess : this.availableProcesses()) {
                    this.collectToSet(rootProcess, seen, filter, false, true, false);
                }
                break block3;
            }
            if (higher.getChildren() == null) break block3;
            for (ProcessItem child : higher.getChildren()) {
                if (!this.matches(child, filter)) continue;
                seen.add(child);
            }
        }
        return new ArrayList<Object>(seen);
    }

    private List<Object> suggestLower(PfmeaRow row, String query) {
        String filter = this.norm(query);
        ProcessItem focus = row.getFocusElement();
        LinkedHashSet<Object> out = new LinkedHashSet<Object>();
        if (focus != null) {
            if (focus.getChildren() != null) {
                for (ProcessItem child : focus.getChildren()) {
                    if (!this.matches(child, filter)) continue;
                    out.add(child);
                }
            }
            if (focus.getParameters() != null) {
                for (Parameter parameter : focus.getParameters()) {
                    if (!this.matches(parameter, filter)) continue;
                    out.add(parameter);
                }
            }
        }
        return new ArrayList<Object>(out);
    }

    private void collectToSet(ProcessItem current, Set<Object> out, String filter, boolean includeSelf, boolean includeChildren, boolean includeParameters) {
        if (current == null) {
            return;
        }
        if (includeSelf && this.matches(current, filter)) {
            out.add(current);
        }
        if (includeParameters && current.getParameters() != null) {
            for (Parameter parameter : current.getParameters()) {
                if (!this.matches(parameter, filter)) continue;
                out.add(parameter);
            }
        }
        if (!includeChildren || current.getChildren() == null) {
            return;
        }
        for (ProcessItem child : current.getChildren()) {
            this.collectToSet(child, out, filter, true, true, includeParameters);
        }
    }

    private void buildMentionMenuForCell(ContextMenu menu, List<Object> options, Consumer<Object> onChoose) {
        menu.getItems().clear();
        boolean first = true;
        for (Object option : options) {
            if (!first) {
                menu.getItems().add((Object)new SeparatorMenuItem());
            }
            first = false;
            menu.getItems().add((Object)this.makeMentionMenuItem(option, onChoose));
        }
    }

    private MenuItem makeMentionMenuItem(Object obj, Consumer<Object> onChoose) {
        VBox box;
        String title = this.displayName(obj);
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        String subtitle = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProcessItem.class, Parameter.class}, (Object)object2, n)) {
            case 0 -> {
                String type;
                ProcessItem it = (ProcessItem)object2;
                String function = PfmeaWindowController.s(it.getFunction());
                String v1 = type = it.getType() == null ? "" : it.getType().getLabel();
                if (!function.isBlank() && !type.isBlank()) {
                    yield function + " - " + type;
                }
                if (!function.isBlank()) {
                    yield function;
                }
                yield type;
            }
            case 1 -> {
                Parameter param = (Parameter)object2;
                yield this.formatParameter(param);
            }
            default -> "";
        };
        Label l1 = new Label(title);
        l1.setStyle("-fx-font-size: 12px;");
        if (subtitle == null || subtitle.isBlank()) {
            box = new VBox(new Node[]{l1});
        } else {
            Label l2 = new Label(subtitle);
            l2.setStyle("-fx-text-fill: #666666; -fx-font-size: 11px;");
            l2.setWrapText(true);
            box = new VBox(2.0, new Node[]{l1, l2});
        }
        MenuItem mi = new MenuItem();
        mi.setGraphic((Node)box);
        mi.setMnemonicParsing(false);
        mi.setOnAction(e -> onChoose.accept(obj));
        return mi;
    }

    private String displayName(ProcessItem item) {
        if (item == null) {
            return "";
        }
        String description = PfmeaWindowController.s(item.getDescription());
        if (!description.isBlank()) {
            return description;
        }
        String function = PfmeaWindowController.s(item.getFunction());
        if (!function.isBlank()) {
            return function;
        }
        ProcessType type = item.getType();
        return type != null ? type.getLabel() : "(process)";
    }

    private String displayName(Parameter parameter) {
        if (parameter == null) {
            return "";
        }
        String description = PfmeaWindowController.s(parameter.getDescription());
        return description.isBlank() ? "(parameter)" : description;
    }

    private String displayName(Object obj) {
        if (obj instanceof ProcessItem) {
            ProcessItem item = (ProcessItem)obj;
            return this.displayName(item);
        }
        if (obj instanceof Parameter) {
            Parameter parameter = (Parameter)obj;
            return this.displayName(parameter);
        }
        return obj == null ? "" : obj.toString();
    }

    private String norm(String s) {
        return s == null ? "" : s.trim().toLowerCase();
    }

    private boolean isBlank(String v) {
        return v == null || v.trim().isEmpty();
    }

    private boolean matches(ProcessItem item, String filter) {
        if (item == null) {
            return false;
        }
        if (filter == null || filter.isBlank()) {
            return true;
        }
        String desc = PfmeaWindowController.s(item.getDescription()).toLowerCase();
        String fn = PfmeaWindowController.s(item.getFunction()).toLowerCase();
        String type = item.getType() == null ? "" : item.getType().getLabel().toLowerCase();
        String f = filter.toLowerCase();
        return desc.contains(f) || fn.contains(f) || type.contains(f);
    }

    private boolean matches(Parameter parameter, String filter) {
        if (parameter == null) {
            return false;
        }
        if (filter == null || filter.isBlank()) {
            return true;
        }
        String desc = PfmeaWindowController.s(parameter.getDescription()).toLowerCase();
        return desc.contains(filter.toLowerCase());
    }

    private String formatParameter(Parameter param) {
        if (param == null) {
            return "";
        }
        String target = this.valueWithFallback(param.getTargetValueText(), param.getTargetValue());
        String usl = this.valueWithFallback(param.getUpperLimitText(), param.getUpperLimit());
        String lsl = this.valueWithFallback(param.getLowerLimitText(), param.getLowerLimit());
        StringBuilder sb = new StringBuilder();
        sb.append("Target: ").append(target);
        sb.append("  USL: ").append(usl);
        sb.append("  LSL: ").append(lsl);
        return sb.toString();
    }

    private String valueWithFallback(String text, double numeric) {
        if (text != null && !text.isBlank()) {
            return text.trim();
        }
        if (Double.isNaN(numeric)) {
            return "";
        }
        return this.formatNumber(numeric);
    }

    private String formatNumber(double value) {
        String text = Double.toString(value);
        if (text.indexOf(69) >= 0 || text.indexOf(101) >= 0) {
            return text;
        }
        if (text.indexOf(46) >= 0) {
            while (text.endsWith("0")) {
                text = text.substring(0, text.length() - 1);
            }
            if (text.endsWith(".")) {
                text = text.substring(0, text.length() - 1);
            }
        }
        return text;
    }

    private ProcessItem findParentOf(ProcessItem target) {
        if (target == null) {
            return null;
        }
        for (ProcessItem rootProcess : this.availableProcesses()) {
            ProcessItem parent = this.findParentDfs(rootProcess, target, null);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    private ProcessItem findParentDfs(ProcessItem current, ProcessItem target, ProcessItem parent) {
        if (current == null) {
            return null;
        }
        if (current == target) {
            return parent;
        }
        if (current.getChildren() != null) {
            for (ProcessItem child : current.getChildren()) {
                ProcessItem found = this.findParentDfs(child, target, current);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    private String plural(String label) {
        if (label == null) {
            return "";
        }
        String trimmed = label.trim();
        if (trimmed.isEmpty()) {
            return "";
        }
        return switch (trimmed) {
            case "Process" -> "Processes";
            case "Activity" -> "Activities";
            case "Operation" -> "Operations";
            default -> trimmed + "s";
        };
    }

    private void applySelection(MentionKind kind, PfmeaRow row, Object chosen) {
        block16: {
            if (row == null || chosen == null) {
                return;
            }
            block0 : switch (kind.ordinal()) {
                case 0: {
                    if (!(chosen instanceof ProcessItem)) break;
                    ProcessItem item = (ProcessItem)chosen;
                    row.setNextHigherLevel(item);
                    if (this.isBlank(row.getNextHigherLevelText())) {
                        row.setNextHigherLevelText(this.displayName(item));
                    }
                    if (!this.isBlank(row.getNextHigherLevelFunction())) break;
                    row.setNextHigherLevelFunction(PfmeaWindowController.s(item.getFunction()));
                    break;
                }
                case 1: {
                    Ishikawa ishikawa;
                    if (!(chosen instanceof ProcessItem)) break;
                    ProcessItem item = (ProcessItem)chosen;
                    row.setFocusElement(item);
                    row.setFocusElementText(this.displayName(item));
                    row.setFocusElementFunctionRequirement(PfmeaWindowController.s(item.getFunction()));
                    ProcessItem parent = this.findParentOf(item);
                    if (parent != null) {
                        row.setNextHigherLevel(parent);
                        row.setNextHigherLevelText(this.displayName(parent));
                        row.setNextHigherLevelFunction(PfmeaWindowController.s(parent.getFunction()));
                    }
                    if ((ishikawa = item.getIshikawa()) != null) {
                        row.setNextLowerLevelOrParameter(null);
                        row.setNextLowerLevelOrParameterText(ishikawa.getDescription());
                        break;
                    }
                    row.setNextLowerLevelOrParameter(null);
                    row.setNextLowerLevelOrParameterText("");
                    break;
                }
                case 2: {
                    row.setNextLowerLevelOrParameter(chosen);
                    Object object = chosen;
                    Objects.requireNonNull(object);
                    Object object2 = object;
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProcessItem.class, Parameter.class}, (Object)object2, n)) {
                        case 0: {
                            ProcessItem item = (ProcessItem)object2;
                            row.setNextLowerLevelOrParameterText(this.displayName(item));
                            if (this.isBlank(row.getNextLowerLevelFunctionRequirementOrParameter())) {
                                row.setNextLowerLevelFunctionRequirementOrParameter(PfmeaWindowController.s(item.getFunction()));
                                break block0;
                            }
                            break block16;
                        }
                        case 1: {
                            Parameter parameter = (Parameter)object2;
                            row.setNextLowerLevelOrParameterText(this.displayName(parameter));
                            row.setNextLowerLevelFunctionRequirementOrParameter(this.formatParameter(parameter));
                            break block0;
                        }
                    }
                }
            }
        }
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        if (this.tblRows != null) {
            this.tblRows.refresh();
        }
    }

    private void attachApListeners(PfmeaRow row) {
        if (row == null) {
            return;
        }
        ChangeListener recalc = (obs, ov, nv) -> this.updateApFromSOD(row);
        row.severityProperty().addListener(recalc);
        row.occurrenceProperty().addListener(recalc);
        row.detectionProperty().addListener(recalc);
        row.currentSeverityProperty().addListener(recalc);
        row.currentOccurrenceProperty().addListener(recalc);
        row.currentDetectionProperty().addListener(recalc);
        this.updateApFromSOD(row);
    }

    private void updateApFromSOD(PfmeaRow row) {
        if (row == null) {
            return;
        }
        PfmeaRow.Severity s0 = row.getSeverity();
        PfmeaRow.Occurrence o0 = row.getOccurrence();
        PfmeaRow.Detection d0 = row.getDetection();
        if (s0 != null && o0 != null && d0 != null) {
            row.setActionPriority(PfmeaWindowController.getAp(s0.getValue(), o0.getValue(), d0.getValue()));
        }
        PfmeaRow.Severity sc = row.getCurrentSeverity();
        PfmeaRow.Occurrence oc = row.getCurrentOccurrence();
        PfmeaRow.Detection dc = row.getCurrentDetection();
        if (sc != null && oc != null && dc != null) {
            row.setCurrentActionPriority(PfmeaWindowController.getAp(sc.getValue(), oc.getValue(), dc.getValue()));
        } else {
            row.setCurrentActionPriority(null);
        }
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
    }

    private void scheduleSummaryRefresh() {
        Platform.runLater(() -> {
            if (this.pfmea == null) {
                return;
            }
            this.wireSummaryTableColumns();
            ObservableList<PfmeaRow> rows = this.pfmea.getFailureChains();
            this.updateActionsTable((List<PfmeaRow>)rows);
            this.updateSummaryCharts((List<PfmeaRow>)rows);
        });
    }

    private void wireSummaryRowListeners(PfmeaRow row) {
        if (row == null) {
            return;
        }
        row.preventiveActionProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        row.detectionActionProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        row.statusProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        row.responsiblePersonProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        row.targetCompletionDateProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        row.severityProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        row.occurrenceProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        row.detectionProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        row.currentSeverityProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        row.currentOccurrenceProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
        row.currentDetectionProperty().addListener((o, ov, nv) -> this.scheduleSummaryRefresh());
    }

    private void attachTreeRefreshRowListeners(PfmeaRow row) {
        if (row == null) {
            return;
        }
        row.nextHigherLevelTextProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        row.nextHigherLevelFunctionProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        row.focusElementTextProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        row.focusElementFunctionRequirementProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        row.nextLowerLevelOrParameterTextProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        row.nextLowerLevelFunctionRequirementOrParameterProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        row.failureEffectProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        row.failureModeProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        row.failureCauseProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
        row.actionPriorityProperty().addListener((o, ov, nv) -> this.scheduleTreeRefresh());
    }

    private void scheduleTreeRefresh() {
        if (this.treeLoaded && this.webFta != null) {
            Platform.runLater(this::sendPfmeaJsonToPage);
        }
    }

    private void updateActionsTable(List<PfmeaRow> rows) {
        if (this.tblActions == null) {
            return;
        }
        if (rows == null) {
            this.tblActions.setItems(FXCollections.emptyObservableList());
            return;
        }
        List<PfmeaRow> filtered = rows.stream().filter(r -> PfmeaWindowController.hasText(r.getPreventiveAction()) || PfmeaWindowController.hasText(r.getDetectionAction())).filter(this::isOpenOrPending).toList();
        this.tblActions.setItems(FXCollections.observableArrayList(filtered));
    }

    private void wireSummaryTableColumns() {
        if (this.tblActions == null) {
            return;
        }
        if (this.colPreventionActionSummary != null && this.colPreventionActionSummary.getCellValueFactory() != null) {
            return;
        }
        if (this.colSummaryFocusElement != null) {
            this.colSummaryFocusElement.setCellValueFactory(c -> ((PfmeaRow)c.getValue()).focusElementTextProperty());
        }
        if (this.colSummaryFailureMode != null) {
            this.colSummaryFailureMode.setCellValueFactory(c -> ((PfmeaRow)c.getValue()).failureModeProperty());
        }
        if (this.colPreventionActionSummary != null) {
            this.colPreventionActionSummary.setCellValueFactory(c -> ((PfmeaRow)c.getValue()).preventiveActionProperty());
        }
        if (this.colDetectionActionSummary != null) {
            this.colDetectionActionSummary.setCellValueFactory(c -> ((PfmeaRow)c.getValue()).detectionActionProperty());
        }
        if (this.colStatusSummary != null) {
            this.colStatusSummary.setCellValueFactory(c -> new SimpleStringProperty(PfmeaWindowController.pfmeaStatusText((PfmeaRow.PfmeaStatus)((Object)((Object)((PfmeaRow)c.getValue()).statusProperty().get())))));
        }
        if (this.colResponsibleSummary != null) {
            this.colResponsibleSummary.setCellValueFactory(c -> ((PfmeaRow)c.getValue()).responsiblePersonProperty());
        }
        if (this.colTargetDateSummary != null) {
            this.colTargetDateSummary.setCellValueFactory(c -> ((PfmeaRow)c.getValue()).targetCompletionDateProperty());
            this.colTargetDateSummary.setCellFactory(col -> new TableCell<PfmeaRow, LocalDate>(this){
                private final DateTimeFormatter fmt;
                {
                    Objects.requireNonNull(this$0);
                    this.fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                }

                protected void updateItem(LocalDate item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    this.setText(empty || item == null ? "" : this.fmt.format(item));
                }
            });
        }
    }

    private static boolean hasText(String value) {
        return value != null && !value.isBlank();
    }

    private boolean isOpenOrPending(PfmeaRow row) {
        if (row == null) {
            return false;
        }
        PfmeaRow.PfmeaStatus status = row.getStatus();
        return status == PfmeaRow.PfmeaStatus.OPEN || status == PfmeaRow.PfmeaStatus.PENDING_DECISION || status == PfmeaRow.PfmeaStatus.PENDING_IMPLEMENTATION;
    }

    private static String pfmeaStatusText(PfmeaRow.PfmeaStatus status) {
        if (status == null) {
            return "";
        }
        return switch (status) {
            default -> throw new MatchException(null, null);
            case PfmeaRow.PfmeaStatus.OPEN -> "Open";
            case PfmeaRow.PfmeaStatus.PENDING_DECISION -> "Pending decision";
            case PfmeaRow.PfmeaStatus.PENDING_IMPLEMENTATION -> "Pending implementation";
            case PfmeaRow.PfmeaStatus.COMPLETED -> "Completed";
            case PfmeaRow.PfmeaStatus.NOT_IMPLEMENTED -> "Not implemented";
        };
    }

    private void pushPfmeaUndo(Runnable action) {
        if (action == null) {
            return;
        }
        this.pfmeaUndoStack.addFirst(action);
        while (this.pfmeaUndoStack.size() > 50) {
            this.pfmeaUndoStack.removeLast();
        }
    }

    private boolean performPfmeaUndo() {
        Runnable action = this.pfmeaUndoStack.pollFirst();
        if (action == null) {
            return false;
        }
        action.run();
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        this.scheduleSummaryRefresh();
        this.scheduleTreeRefresh();
        if (this.tblRows != null) {
            this.tblRows.refresh();
        }
        return true;
    }

    private TablePosition<PfmeaRow, ?> capturePfmeaFocus() {
        TablePosition first;
        ObservableList cells;
        TablePosition focused;
        if (this.tblRows == null) {
            return null;
        }
        TableView.TableViewFocusModel focusModel = this.tblRows.getFocusModel();
        if (focusModel != null && (focused = focusModel.getFocusedCell()) != null && focused.getTableColumn() != null && focused.getRow() >= 0) {
            return new TablePosition(this.tblRows, focused.getRow(), focused.getTableColumn());
        }
        TableView.TableViewSelectionModel selection = this.tblRows.getSelectionModel();
        if (selection != null && !(cells = selection.getSelectedCells()).isEmpty() && (first = (TablePosition)cells.get(0)) != null && first.getTableColumn() != null && first.getRow() >= 0) {
            return new TablePosition(this.tblRows, first.getRow(), first.getTableColumn());
        }
        return null;
    }

    private void restorePfmeaFocus(TablePosition<PfmeaRow, ?> snapshot) {
        if (this.tblRows == null || snapshot == null) {
            return;
        }
        ObservableList items = this.tblRows.getItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        int row = Math.max(0, Math.min(snapshot.getRow(), items.size() - 1));
        TableColumn column = snapshot.getTableColumn();
        ObservableList visible = this.tblRows.getVisibleLeafColumns();
        if (column == null || !visible.contains(column)) {
            if (visible.isEmpty()) {
                return;
            }
            int fallbackIndex = this.tblRows.getVisibleLeafIndex(column);
            column = fallbackIndex < 0 || fallbackIndex >= visible.size() ? (TableColumn)visible.get(0) : (TableColumn)visible.get(fallbackIndex);
        }
        TableView.TableViewSelectionModel selection = this.tblRows.getSelectionModel();
        TableView.TableViewFocusModel focus = this.tblRows.getFocusModel();
        if (selection != null) {
            selection.clearAndSelect(row, column);
        }
        if (focus != null) {
            focus.focus(row, column);
        }
    }

    @SafeVarargs
    private void centerCells(TableColumn<?, ?> ... columns) {
        if (columns == null) {
            return;
        }
        for (TableColumn<?, ?> col : columns) {
            if (col == null) continue;
            col.setStyle("-fx-alignment: CENTER;");
        }
    }

    private void centerAllPfmeaColumns() {
        if (this.tblRows == null) {
            return;
        }
        this.centerColumnsRecursive(this.tblRows.getColumns());
    }

    private void centerColumnsRecursive(ObservableList<? extends TableColumn<?, ?>> columns) {
        if (columns == null) {
            return;
        }
        for (TableColumn col : columns) {
            if (col == null) continue;
            col.setStyle("-fx-alignment: CENTER;");
            if (col.getColumns().isEmpty()) continue;
            this.centerColumnsRecursive(col.getColumns());
        }
    }

    private void integerCol(final TableColumn<PfmeaRow, Number> column, Function<PfmeaRow, IntegerProperty> property) {
        if (column == null) {
            return;
        }
        final NumberStringConverter converter = new NumberStringConverter();
        column.setCellValueFactory(cd -> (ObservableValue)property.apply((PfmeaRow)cd.getValue()));
        column.setCellFactory(col -> new TextFieldTableCell<PfmeaRow, Number>(this, (StringConverter)converter){
            {
                Objects.requireNonNull(this$0);
                super(arg0);
                this.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
                    TableView tv;
                    if (e.getButton() != MouseButton.PRIMARY || e.getClickCount() < 2) {
                        return;
                    }
                    if (!this.isEmpty() && !this.isEditing() && (tv = this.getTableView()) != null) {
                        tv.edit(this.getIndex(), column);
                        e.consume();
                    }
                });
            }

            public void startEdit() {
                super.startEdit();
                Node node = this.getGraphic();
                if (node instanceof TextField) {
                    TextField tf = (TextField)node;
                    tf.selectAll();
                    this.installNavigationHandlers(tf, converter);
                }
            }

            public void cancelEdit() {
                super.cancelEdit();
            }

            public void commitEdit(Number newValue) {
                super.commitEdit((Object)newValue);
            }

            private void installNavigationHandlers(TextField tf, NumberStringConverter conv) {
                if (!Boolean.TRUE.equals(tf.getProperties().get((Object)PfmeaWindowController.TEXT_FIELD_NAV_KEY))) {
                    tf.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
                        if (e.getCode() == KeyCode.TAB) {
                            this.commitSafely(tf.getText(), conv);
                            PfmeaWindowController.navigateFromCell(this, e.isShiftDown() ? -1 : 1);
                            e.consume();
                        } else if (e.getCode() == KeyCode.ESCAPE) {
                            this.cancelEdit();
                            e.consume();
                        }
                    });
                    tf.focusedProperty().addListener((o, was, isNow) -> {
                        if (!isNow.booleanValue() && this.isEditing()) {
                            this.commitSafely(tf.getText(), conv);
                        }
                    });
                    tf.getProperties().put((Object)PfmeaWindowController.TEXT_FIELD_NAV_KEY, (Object)Boolean.TRUE);
                }
            }

            private void commitSafely(String txt, NumberStringConverter conv) {
                try {
                    Number n = conv.fromString(txt);
                    this.commitEdit(n);
                }
                catch (Exception ex) {
                    this.cancelEdit();
                }
            }
        });
        column.setOnEditCommit(evt -> {
            PfmeaRow row = (PfmeaRow)evt.getRowValue();
            if (row == null) {
                return;
            }
            IntegerProperty propRef = (IntegerProperty)property.apply(row);
            if (propRef == null) {
                return;
            }
            Number newVal = (Number)evt.getNewValue();
            int newValue = newVal == null ? 0 : newVal.intValue();
            int oldValue = propRef.get();
            if (oldValue == newValue) {
                return;
            }
            this.pushPfmeaUndo(() -> propRef.set(oldValue));
            propRef.set(newValue);
            if (this.dirtyHook != null) {
                this.dirtyHook.run();
            }
            if (this.tblRows != null) {
                this.tblRows.refresh();
            }
        });
    }

    private <E extends Enum<E>> void enumCol(TableColumn<PfmeaRow, E> column, E[] options, Function<PfmeaRow, ObjectProperty<E>> property, final Function<E, Integer> toNumericLabel) {
        if (column == null) {
            return;
        }
        StringConverter converter = new StringConverter<E>(this){
            {
                Objects.requireNonNull(this$0);
            }

            public String toString(E value) {
                Integer code;
                if (value == null) {
                    return "N/A";
                }
                if (toNumericLabel != null && (code = (Integer)toNumericLabel.apply(value)) != null && code > 0) {
                    return Integer.toString(code);
                }
                String n = ((Enum)value).name().toLowerCase().replace('_', ' ');
                return Character.toUpperCase(n.charAt(0)) + n.substring(1);
            }

            public E fromString(String string) {
                return null;
            }
        };
        column.setEditable(true);
        column.setCellValueFactory(cd -> (ObservableValue)property.apply((PfmeaRow)cd.getValue()));
        column.setStyle("-fx-alignment: CENTER;");
        column.setCellFactory(arg_0 -> this.lambda$enumCol$1(options, (StringConverter)converter, column, arg_0));
        column.setOnEditCommit(evt -> {
            PfmeaRow row = (PfmeaRow)evt.getRowValue();
            if (row == null) {
                return;
            }
            ObjectProperty propRef = (ObjectProperty)property.apply(row);
            if (propRef == null) {
                return;
            }
            Enum newValue = (Enum)evt.getNewValue();
            Enum oldValue = (Enum)propRef.get();
            if (Objects.equals(oldValue, newValue)) {
                return;
            }
            this.pushPfmeaUndo(() -> propRef.set((Object)oldValue));
            propRef.set((Object)newValue);
            if (this.dirtyHook != null) {
                this.dirtyHook.run();
            }
            if (this.tblRows != null) {
                this.tblRows.refresh();
            }
        });
    }

    private void readOnlyApCol(TableColumn<PfmeaRow, PfmeaRow.ActionPriority> column, Function<PfmeaRow, ObjectProperty<PfmeaRow.ActionPriority>> property) {
        if (column == null) {
            return;
        }
        column.setEditable(false);
        column.setCellValueFactory(cd -> (ObservableValue)property.apply((PfmeaRow)cd.getValue()));
        column.setCellFactory(col -> new TableCell<PfmeaRow, PfmeaRow.ActionPriority>(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void updateItem(PfmeaRow.ActionPriority ap, boolean empty) {
                super.updateItem((Object)ap, empty);
                if (empty || ap == null) {
                    this.setText("");
                    this.setStyle("");
                    return;
                }
                switch (ap) {
                    case HIGH: {
                        this.setText("High");
                        this.setStyle("-fx-background-color: lightcoral; -fx-text-fill: black;");
                        break;
                    }
                    case MEDIUM: {
                        this.setText("Medium");
                        this.setStyle("-fx-background-color: khaki; -fx-text-fill: black;");
                        break;
                    }
                    case LOW: {
                        this.setText("Low");
                        this.setStyle("-fx-background-color: lightgreen; -fx-text-fill: black;");
                    }
                }
                this.setAlignment(Pos.CENTER);
            }
        });
    }

    private void datePickerCol(TableColumn<PfmeaRow, LocalDate> column, final Function<PfmeaRow, ObjectProperty<LocalDate>> property) {
        if (column == null) {
            return;
        }
        column.setCellValueFactory(cd -> (ObservableValue)property.apply((PfmeaRow)cd.getValue()));
        column.setCellFactory(col -> new TableCell<PfmeaRow, LocalDate>(this){
            private DatePicker editor;
            final /* synthetic */ PfmeaWindowController this$0;
            {
                PfmeaWindowController pfmeaWindowController = this$0;
                Objects.requireNonNull(pfmeaWindowController);
                this.this$0 = pfmeaWindowController;
            }

            public void startEdit() {
                super.startEdit();
                if (this.isEmpty()) {
                    return;
                }
                if (this.editor == null) {
                    this.createEditor();
                }
                this.editor.setValue((Object)((LocalDate)this.getItem()));
                this.setGraphic((Node)this.editor);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                Platform.runLater(() -> this.editor.requestFocus());
            }

            protected void updateItem(LocalDate value, boolean empty) {
                super.updateItem((Object)value, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                    this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                    return;
                }
                if (this.isEditing()) {
                    if (this.editor == null) {
                        this.createEditor();
                    }
                    this.editor.setValue((Object)value);
                    this.setGraphic((Node)this.editor);
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                } else {
                    this.setText(value == null ? "" : value.toString());
                    this.setGraphic(null);
                    this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                }
            }

            public void cancelEdit() {
                super.cancelEdit();
                this.setText(this.getItem() == null ? "" : ((LocalDate)this.getItem()).toString());
                this.setGraphic(null);
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }

            private void createEditor() {
                this.editor = new DatePicker();
                this.editor.setEditable(false);
                this.editor.valueProperty().addListener((o, ov, nv) -> {
                    if (!this.isEditing()) {
                        return;
                    }
                    this.commitEdit((LocalDate)nv);
                });
                this.editor.setOnAction(e -> {
                    if (this.isEditing()) {
                        this.commitEdit((LocalDate)this.editor.getValue());
                    }
                });
                this.editor.focusedProperty().addListener((o, was, isNow) -> {
                    if (!isNow.booleanValue() && this.isEditing()) {
                        this.commitEdit((LocalDate)this.editor.getValue());
                    }
                });
            }

            public void commitEdit(LocalDate newValue) {
                super.commitEdit((Object)newValue);
                TableView table = this.getTableView();
                if (table == null || this.getIndex() < 0 || this.getIndex() >= table.getItems().size()) {
                    return;
                }
                PfmeaRow row = (PfmeaRow)table.getItems().get(this.getIndex());
                ObjectProperty propRef = (ObjectProperty)property.apply(row);
                if (row == null || propRef == null) {
                    return;
                }
                LocalDate oldValue = (LocalDate)propRef.get();
                if (Objects.equals(oldValue, newValue)) {
                    return;
                }
                this.this$0.pushPfmeaUndo(() -> propRef.set((Object)oldValue));
                propRef.set((Object)newValue);
                if (this.this$0.dirtyHook != null) {
                    this.this$0.dirtyHook.run();
                }
                this.setText(newValue == null ? "" : newValue.toString());
                this.setGraphic(null);
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            }
        });
    }

    private void configureHeaderIcon() {
        this.setIcon(this.imgHeaderIcon, "/icons/fmea.png");
    }

    private void setIcon(ImageView view, String resourcePath) {
        if (view == null) {
            return;
        }
        URL iconUrl = PfmeaWindowController.class.getResource(resourcePath);
        if (iconUrl == null) {
            System.err.println("Icon resource not found: " + resourcePath);
            return;
        }
        view.setImage(new Image(iconUrl.toExternalForm()));
    }

    private void configureRowContextMenu() {
        if (this.tblRows == null) {
            return;
        }
        this.tblRows.setRowFactory(tv -> {
            TableRow<PfmeaRow> row = new TableRow<PfmeaRow>(this){
                final /* synthetic */ PfmeaWindowController this$0;
                {
                    PfmeaWindowController pfmeaWindowController = this$0;
                    Objects.requireNonNull(pfmeaWindowController);
                    this.this$0 = pfmeaWindowController;
                }

                protected void updateItem(PfmeaRow item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    this.this$0.applyFailureChainHighlight(this);
                }
            };
            row.indexProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$configureRowContextMenu$1((TableRow)row, arg_0, arg_1, arg_2));
            row.selectedProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$configureRowContextMenu$2((TableRow)row, arg_0, arg_1, arg_2));
            ContextMenu menu = new ContextMenu();
            MenuItem deleteItem = new MenuItem("\u274c Delete row");
            deleteItem.setOnAction(arg_0 -> this.lambda$configureRowContextMenu$3((TableRow)row, arg_0));
            MenuItem insertItem = new MenuItem("\u2795 Insert new row");
            insertItem.setOnAction(arg_0 -> this.lambda$configureRowContextMenu$4((TableRow)row, arg_0));
            MenuItem duplicateItem = new MenuItem("\ud83d\udcc4 Duplicate row");
            duplicateItem.setOnAction(arg_0 -> this.lambda$configureRowContextMenu$5((TableRow)row, arg_0));
            menu.getItems().addAll((Object[])new MenuItem[]{deleteItem, insertItem, duplicateItem});
            row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)row.emptyProperty()).then((Object)null).otherwise((Object)menu));
            row.setOnContextMenuRequested(arg_0 -> this.lambda$configureRowContextMenu$6((TableRow)row, arg_0));
            return row;
        });
    }

    private void addRowAt(int index, boolean startEdit) {
        if (this.pfmea == null || this.tblRows == null) {
            return;
        }
        PfmeaRow row = this.createDefaultPfmeaRow();
        this.insertRow(row, index, startEdit, true);
    }

    private void duplicateRow(PfmeaRow source) {
        if (this.pfmea == null || this.tblRows == null || source == null) {
            return;
        }
        int index = this.pfmea.getFailureChains().indexOf((Object)source);
        if (index < 0) {
            return;
        }
        PfmeaRow copy = this.clonePfmeaRow(source);
        this.insertRow(copy, index + 1, false);
    }

    private void insertRow(PfmeaRow row, int index, boolean startEdit) {
        this.insertRow(row, index, startEdit, true);
    }

    private void insertRow(PfmeaRow row, int index, boolean startEdit, boolean recordUndo) {
        int targetIndex;
        if (this.pfmea == null || this.tblRows == null || row == null) {
            return;
        }
        ObservableList<PfmeaRow> rows = this.pfmea.getFailureChains();
        if (rows == null) {
            return;
        }
        this.attachApListeners(row);
        this.wireSummaryRowListeners(row);
        this.attachTreeRefreshRowListeners(row);
        if (index < 0 || index > rows.size()) {
            rows.add((Object)row);
            targetIndex = rows.size() - 1;
        } else {
            rows.add(index, (Object)row);
            targetIndex = index;
        }
        if (recordUndo || startEdit) {
            this.tblRows.getSelectionModel().clearAndSelect(targetIndex);
            this.tblRows.scrollTo(targetIndex);
            if (startEdit) {
                int target = targetIndex;
                Platform.runLater(() -> this.tblRows.edit(target, this.colFailureMode));
            }
        }
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        this.scheduleSummaryRefresh();
        this.scheduleTreeRefresh();
        if (recordUndo) {
            this.pushPfmeaUndo(() -> {
                rows.remove((Object)row);
                if (this.tblRows != null) {
                    this.tblRows.refresh();
                }
                this.scheduleSummaryRefresh();
                this.scheduleTreeRefresh();
            });
        }
    }

    private PfmeaRow createDefaultPfmeaRow() {
        PfmeaRow row = new PfmeaRow();
        row.setSeverity(PfmeaRow.Severity.ONE);
        row.setOccurrence(PfmeaRow.Occurrence.ONE);
        row.setDetection(PfmeaRow.Detection.ONE);
        row.setCurrentSeverity(PfmeaRow.Severity.ONE);
        row.setCurrentOccurrence(PfmeaRow.Occurrence.ONE);
        row.setCurrentDetection(PfmeaRow.Detection.ONE);
        return row;
    }

    private PfmeaRow clonePfmeaRow(PfmeaRow source) {
        PfmeaRow copy = new PfmeaRow();
        copy.setIssueNumber(source.getIssueNumber());
        copy.setChangeAuthorization(source.getChangeAuthorization());
        copy.setNextHigherLevel(source.getNextHigherLevel());
        copy.setFocusElement(source.getFocusElement());
        copy.setNextLowerLevelOrParameter(source.getNextLowerLevelOrParameter());
        copy.setNextHigherLevelFunction(source.getNextHigherLevelFunction());
        copy.setFocusElementFunctionRequirement(source.getFocusElementFunctionRequirement());
        copy.setNextLowerLevelFunctionRequirementOrParameter(source.getNextLowerLevelFunctionRequirementOrParameter());
        copy.setNextHigherLevelText(source.getNextHigherLevelText());
        copy.setFocusElementText(source.getFocusElementText());
        copy.setNextLowerLevelOrParameterText(source.getNextLowerLevelOrParameterText());
        copy.setFailureEffect(source.getFailureEffect());
        copy.setSeverity(source.getSeverity());
        copy.setFailureMode(source.getFailureMode());
        copy.setFailureCause(source.getFailureCause());
        copy.setPreventionControl(source.getPreventionControl());
        copy.setOccurrence(source.getOccurrence());
        copy.setDetectionControl(source.getDetectionControl());
        copy.setDetection(source.getDetection());
        copy.setActionPriority(source.getActionPriority());
        copy.setFilterCode(source.getFilterCode());
        copy.setPreventiveAction(source.getPreventiveAction());
        copy.setDetectionAction(source.getDetectionAction());
        copy.setResponsiblePerson(source.getResponsiblePerson());
        copy.setTargetCompletionDate(source.getTargetCompletionDate());
        copy.setStatus(source.getStatus());
        copy.setActionTakenEvidence(source.getActionTakenEvidence());
        copy.setCompletionDate(source.getCompletionDate());
        copy.setCurrentSeverity(source.getCurrentSeverity());
        copy.setCurrentOccurrence(source.getCurrentOccurrence());
        copy.setCurrentDetection(source.getCurrentDetection());
        copy.setCurrentActionPriority(source.getCurrentActionPriority());
        copy.setRemarks(source.getRemarks());
        return copy;
    }

    private void onAddChain() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.pfmea == null || this.tblRows == null) {
            return;
        }
        this.addRowAt(this.pfmea.getFailureChains().size(), true);
    }

    private void onDeleteSelectedChain() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.pfmea == null || this.tblRows == null) {
            return;
        }
        PfmeaRow selected = (PfmeaRow)this.tblRows.getSelectionModel().getSelectedItem();
        if (selected == null) {
            return;
        }
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Delete PFMEA Row");
        alert.setHeaderText("Delete selected PFMEA row?");
        alert.setContentText("This action cannot be undone.");
        alert.initOwner((Window)this.ownerStage);
        Optional res = alert.showAndWait();
        if (res.isEmpty() || res.get() != ButtonType.OK) {
            return;
        }
        ObservableList<PfmeaRow> rows = this.pfmea.getFailureChains();
        if (rows == null) {
            return;
        }
        int index = rows.indexOf((Object)selected);
        if (index < 0) {
            return;
        }
        rows.remove((Object)selected);
        int restoreIndex = index;
        this.pushPfmeaUndo(() -> this.insertRow(selected, Math.min(restoreIndex, this.pfmea.getFailureChains().size()), false, false));
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        this.scheduleSummaryRefresh();
        this.scheduleTreeRefresh();
        if (this.tblRows != null) {
            this.tblRows.refresh();
        }
    }

    private void onSaveOnly() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.performSave(false);
    }

    private void onSaveAndExit() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.performSave(true);
    }

    private void performSave(boolean closeAfter) {
        this.commitPendingEdits();
        try {
            if (this.saveAction != null) {
                this.saveAction.run();
            }
            this.hasUnsavedChanges = false;
            if (closeAfter) {
                this.closeWindow();
            }
        }
        catch (Exception ex) {
            this.showError("Error while saving PFMEA", ex);
        }
    }

    private void commitPendingEdits() {
        if (this.tblRows != null && this.tblRows.getEditingCell() != null) {
            this.tblRows.edit(-1, null);
        }
    }

    private void closeWindow() {
        Stage window = null;
        if (this.ownerStage != null) {
            window = this.ownerStage;
        } else if (this.root != null && this.root.getScene() != null) {
            window = this.root.getScene().getWindow();
        }
        if (window == null) {
            return;
        }
        this.programmaticClose = true;
        if (window instanceof Stage) {
            Stage stage = window;
            stage.close();
        } else {
            window.hide();
        }
    }

    private void installCloseHandler() {
        if (this.ownerStage == null) {
            return;
        }
        this.ownerStage.setOnCloseRequest(evt -> {
            if (this.programmaticClose) {
                this.programmaticClose = false;
                return;
            }
            evt.consume();
            this.promptSaveBeforeClose();
        });
    }

    private void promptSaveBeforeClose() {
        if (!this.hasUnsavedChanges) {
            this.closeWindow();
            return;
        }
        Alert confirm = new Alert(Alert.AlertType.CONFIRMATION);
        confirm.setTitle("Save changes?");
        confirm.setHeaderText("Do you want to save before closing?");
        confirm.setContentText("Select Yes to save the current PFMEA.");
        confirm.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        if (this.ownerStage != null) {
            confirm.initOwner((Window)this.ownerStage);
        }
        confirm.showAndWait().ifPresent(result -> {
            if (result == ButtonType.YES) {
                this.performSave(true);
            } else if (result == ButtonType.NO) {
                this.hasUnsavedChanges = false;
                this.closeWindow();
            }
        });
    }

    private void showError(String title, Exception ex) {
        Alert a = new Alert(Alert.AlertType.ERROR);
        a.setTitle(title == null ? "Error" : title);
        a.setHeaderText(title == null ? "Error" : title);
        a.setContentText((String)(ex == null ? "" : ex.getClass().getName() + ": " + String.valueOf(ex.getMessage())));
        a.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        a.showAndWait();
    }

    private boolean ensureEditPermission() {
        return true;
    }

    private boolean ensureApprovalPermission() {
        return true;
    }

    private void applyHeaderReadOnlyMode() {
        boolean editable = true;
        if (this.txtCompanyName != null) {
            this.txtCompanyName.setEditable(editable);
        }
        if (this.txtPlantLocation != null) {
            this.txtPlantLocation.setEditable(editable);
        }
        if (this.txtCustomerName != null) {
            this.txtCustomerName.setEditable(editable);
        }
        if (this.txtModelYearPlatform != null) {
            this.txtModelYearPlatform.setEditable(editable);
        }
        if (this.txtPfmeaSubject != null) {
            this.txtPfmeaSubject.setEditable(editable);
        }
        if (this.txtCrossFunctionalTeam != null) {
            this.txtCrossFunctionalTeam.setEditable(editable);
        }
        if (this.txtPfmeaIdNumber != null) {
            this.txtPfmeaIdNumber.setEditable(editable);
        }
        if (this.txtProcessResponsibility != null) {
            this.txtProcessResponsibility.setEditable(editable);
        }
        if (this.dpPfmeaStartDate != null) {
            this.dpPfmeaStartDate.setDisable(!editable);
        }
        if (this.dpPfmeaRevisionDate != null) {
            this.dpPfmeaRevisionDate.setDisable(!editable);
        }
        if (this.cbConfidentialityLevel != null) {
            this.cbConfidentialityLevel.setDisable(!editable);
        }
    }

    private void updateActionPriorityChart(PieChart chart, String title, int high, int med, int low) {
        if (chart == null) {
            return;
        }
        ObservableList data = FXCollections.observableArrayList((Object[])new PieChart.Data[]{new PieChart.Data("High", (double)high), new PieChart.Data("Medium", (double)med), new PieChart.Data("Low", (double)low)});
        HashMap baseNames = new HashMap();
        data.forEach(d -> baseNames.put(d, d.getName()));
        int total = high + med + low;
        chart.setData(data);
        chart.setTitle(title);
        chart.setLabelsVisible(true);
        chart.setLegendVisible(true);
        chart.setLegendSide(Side.RIGHT);
        Map<String, String> colorByName = Map.of("High", "#EF4444", "Medium", "#F59E0B", "Low", "#10B981");
        Platform.runLater(() -> {
            for (PieChart.Data d : data) {
                String baseName = baseNames.getOrDefault(d, d.getName().split(":")[0]);
                String color = colorByName.getOrDefault(baseName, "#10B981");
                if (d.getNode() != null) {
                    d.getNode().setStyle("-fx-pie-color: " + color + ";");
                }
                d.nodeProperty().addListener((obs, oldNode, newNode) -> {
                    if (newNode != null) {
                        newNode.setStyle("-fx-pie-color: " + color + ";");
                    }
                });
                double value = d.getPieValue();
                double pct = total == 0 ? 0.0 : value / (double)total * 100.0;
                d.setName(String.format("%s: %.0f (%.0f%%)", baseName, value, pct));
            }
            chart.applyCss();
            chart.layout();
            for (Node node : chart.lookupAll(".chart-legend-item")) {
                if (!(node instanceof HBox)) continue;
                HBox item = (HBox)node;
                Region symbol = (Region)item.lookup(".chart-legend-item-symbol");
                Label label = null;
                for (Node child : item.getChildren()) {
                    Label lbl;
                    if (!(child instanceof Label)) continue;
                    label = lbl = (Label)child;
                    break;
                }
                if (symbol == null || label == null) continue;
                String baseName = label.getText().split(":")[0];
                String color = colorByName.getOrDefault(baseName, "#10B981");
                symbol.setStyle("-fx-background-color: " + color + ";-fx-background-insets: 0;-fx-background-radius: 6px;");
            }
        });
    }

    private void updateSummaryCharts(List<PfmeaRow> rows) {
        if (rows == null) {
            return;
        }
        if (this.chartActionPriority != null) {
            this.chartActionPriority.setLegendVisible(false);
            this.chartActionPriority.setAnimated(false);
        }
        if (this.chartActionPriorityAfter != null) {
            this.chartActionPriorityAfter.setLegendVisible(false);
            this.chartActionPriorityAfter.setAnimated(false);
        }
        if (this.chartStatus != null) {
            this.chartStatus.setLegendVisible(false);
            this.chartStatus.setAnimated(false);
            this.chartStatus.setTitle("Actions by Status");
        }
        if (this.chartSeverityCount != null) {
            this.chartSeverityCount.setLegendVisible(false);
            this.chartSeverityCount.setAnimated(false);
            this.chartSeverityCount.setTitle("Severity (1-10)");
        }
        if (this.chartOcurrenceCount != null) {
            this.chartOcurrenceCount.setLegendVisible(false);
            this.chartOcurrenceCount.setAnimated(false);
            this.chartOcurrenceCount.setTitle("Occurrence (1-10)");
        }
        if (this.chartDetectionCount != null) {
            this.chartDetectionCount.setLegendVisible(false);
            this.chartDetectionCount.setAnimated(false);
            this.chartDetectionCount.setTitle("Detection (1-10)");
        }
        int low = 0;
        int med = 0;
        int high = 0;
        int currentLow = 0;
        int currentMed = 0;
        int currentHigh = 0;
        for (PfmeaRow pfmeaRow : rows) {
            PfmeaRow.ActionPriority current;
            PfmeaRow.ActionPriority ap = pfmeaRow.getActionPriority();
            if (ap != null) {
                switch (ap) {
                    case LOW: {
                        ++low;
                        break;
                    }
                    case MEDIUM: {
                        ++med;
                        break;
                    }
                    case HIGH: {
                        ++high;
                    }
                }
            }
            if ((current = pfmeaRow.getCurrentActionPriority()) == null) continue;
            switch (current) {
                case LOW: {
                    ++currentLow;
                    break;
                }
                case MEDIUM: {
                    ++currentMed;
                    break;
                }
                case HIGH: {
                    ++currentHigh;
                }
            }
        }
        this.updateActionPriorityChart(this.chartActionPriority, "Action Priority Distribution", high, med, low);
        this.updateActionPriorityChart(this.chartActionPriorityAfter, "Action Priority Distribution (Final)", currentHigh, currentMed, currentLow);
        if (this.chartStatus != null) {
            EnumMap<PfmeaRow.PfmeaStatus, Integer> statusCounts = new EnumMap<PfmeaRow.PfmeaStatus, Integer>(PfmeaRow.PfmeaStatus.class);
            for (PfmeaRow.PfmeaStatus s2 : PfmeaRow.PfmeaStatus.values()) {
                statusCounts.put(s2, 0);
            }
            for (PfmeaRow r : rows) {
                PfmeaRow.PfmeaStatus s3 = r.getStatus();
                if (s3 == null) continue;
                statusCounts.put(s3, (Integer)statusCounts.get((Object)s3) + 1);
            }
            this.chartStatus.getData().clear();
            XYChart.Series series = new XYChart.Series();
            series.getData().add((Object)new XYChart.Data((Object)"Open", (Object)((Number)statusCounts.get((Object)PfmeaRow.PfmeaStatus.OPEN))));
            series.getData().add((Object)new XYChart.Data((Object)"Pending decision", (Object)((Number)statusCounts.get((Object)PfmeaRow.PfmeaStatus.PENDING_DECISION))));
            series.getData().add((Object)new XYChart.Data((Object)"Pending implementation", (Object)((Number)statusCounts.get((Object)PfmeaRow.PfmeaStatus.PENDING_IMPLEMENTATION))));
            series.getData().add((Object)new XYChart.Data((Object)"Completed", (Object)((Number)statusCounts.get((Object)PfmeaRow.PfmeaStatus.COMPLETED))));
            series.getData().add((Object)new XYChart.Data((Object)"Not implemented", (Object)((Number)statusCounts.get((Object)PfmeaRow.PfmeaStatus.NOT_IMPLEMENTED))));
            this.chartStatus.getData().add((Object)series);
            this.adjustValueAxis(this.chartStatus, (XYChart.Series<String, Number>)series);
            Axis s3 = this.chartStatus.getXAxis();
            if (s3 instanceof CategoryAxis) {
                CategoryAxis categoryAxis = (CategoryAxis)s3;
                categoryAxis.setTickLabelRotation(-20.0);
                categoryAxis.setTickLabelGap(10.0);
            }
            this.addLabelsForSeries((XYChart.Series<String, Number>)series);
            Platform.runLater(() -> {
                for (XYChart.Data dta : series.getData()) {
                    if (dta.getNode() == null) continue;
                    switch ((String)dta.getXValue()) {
                        case "Open": {
                            dta.getNode().setStyle("-fx-bar-fill: blue;");
                            break;
                        }
                        case "Pending decision": {
                            dta.getNode().setStyle("-fx-bar-fill: lightgray;");
                            break;
                        }
                        case "Pending implementation": {
                            dta.getNode().setStyle("-fx-bar-fill: gold;");
                            break;
                        }
                        case "Completed": {
                            dta.getNode().setStyle("-fx-bar-fill: green;");
                            break;
                        }
                        case "Not implemented": {
                            dta.getNode().setStyle("-fx-bar-fill: gray;");
                        }
                    }
                }
            });
        }
        int[] sev = new int[11];
        int[] nArray = new int[11];
        int[] det = new int[11];
        for (PfmeaRow r : rows) {
            if (r.getSeverity() != null) {
                int n = r.getSeverity().getValue();
                sev[n] = sev[n] + 1;
            }
            if (r.getOccurrence() != null) {
                int n = r.getOccurrence().getValue();
                nArray[n] = nArray[n] + 1;
            }
            if (r.getDetection() == null) continue;
            int n = r.getDetection().getValue();
            det[n] = det[n] + 1;
        }
        if (this.chartSeverityCount != null) {
            this.chartSeverityCount.getData().clear();
            XYChart.Series s = new XYChart.Series();
            for (int i = 10; i >= 1; --i) {
                s.getData().add((Object)new XYChart.Data((Object)String.valueOf(i), (Object)sev[i]));
            }
            this.chartSeverityCount.getData().add((Object)s);
            this.adjustValueAxis(this.chartSeverityCount, (XYChart.Series<String, Number>)s);
            this.addLabelsForSeries((XYChart.Series<String, Number>)s);
            this.applyLevelPalette((XYChart.Series<String, Number>)s);
        }
        if (this.chartOcurrenceCount != null) {
            this.chartOcurrenceCount.getData().clear();
            XYChart.Series o = new XYChart.Series();
            for (int i = 10; i >= 1; --i) {
                o.getData().add((Object)new XYChart.Data((Object)String.valueOf(i), (Object)nArray[i]));
            }
            this.chartOcurrenceCount.getData().add((Object)o);
            this.adjustValueAxis(this.chartOcurrenceCount, (XYChart.Series<String, Number>)o);
            this.addLabelsForSeries((XYChart.Series<String, Number>)o);
            this.applyLevelPalette((XYChart.Series<String, Number>)o);
        }
        if (this.chartDetectionCount != null) {
            this.chartDetectionCount.getData().clear();
            XYChart.Series d = new XYChart.Series();
            for (int i = 10; i >= 1; --i) {
                d.getData().add((Object)new XYChart.Data((Object)String.valueOf(i), (Object)det[i]));
            }
            this.chartDetectionCount.getData().add((Object)d);
            this.adjustValueAxis(this.chartDetectionCount, (XYChart.Series<String, Number>)d);
            this.addLabelsForSeries((XYChart.Series<String, Number>)d);
            this.applyLevelPalette((XYChart.Series<String, Number>)d);
        }
    }

    private void applyLevelPalette(XYChart.Series<String, Number> series) {
        Platform.runLater(() -> {
            for (XYChart.Data d : series.getData()) {
                try {
                    int level = Integer.parseInt((String)d.getXValue());
                    if (d.getNode() != null) {
                        d.getNode().setStyle("-fx-bar-fill: " + PfmeaWindowController.colorForLevel(level) + ";");
                        continue;
                    }
                    d.nodeProperty().addListener((o, ov, nv) -> {
                        if (nv != null) {
                            nv.setStyle("-fx-bar-fill: " + PfmeaWindowController.colorForLevel(level) + ";");
                        }
                    });
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
    }

    private static String colorForLevel(int level) {
        double hue;
        if (level < 1) {
            level = 1;
        }
        if (level > 10) {
            level = 10;
        }
        if (level >= 5) {
            double f = (10.0 - (double)level) / 5.0;
            hue = 0.0 + f * 60.0;
        } else {
            double f = (5.0 - (double)level) / 4.0;
            hue = 60.0 + f * 60.0;
        }
        return PfmeaWindowController.hsbToHex(hue, 0.9, 0.9);
    }

    private static String hsbToHex(double h, double s, double v) {
        double b1;
        double g1;
        double r1;
        double c = v * s;
        double hh = h % 360.0 / 60.0;
        double x = c * (1.0 - Math.abs(hh % 2.0 - 1.0));
        if (0.0 <= hh && hh < 1.0) {
            r1 = c;
            g1 = x;
            b1 = 0.0;
        } else if (1.0 <= hh && hh < 2.0) {
            r1 = x;
            g1 = c;
            b1 = 0.0;
        } else if (2.0 <= hh && hh < 3.0) {
            r1 = 0.0;
            g1 = c;
            b1 = x;
        } else if (3.0 <= hh && hh < 4.0) {
            r1 = 0.0;
            g1 = x;
            b1 = c;
        } else if (4.0 <= hh && hh < 5.0) {
            r1 = x;
            g1 = 0.0;
            b1 = c;
        } else {
            r1 = c;
            g1 = 0.0;
            b1 = x;
        }
        double m = v - c;
        int r = PfmeaWindowController.roundToByte((r1 + m) * 255.0);
        int g = PfmeaWindowController.roundToByte((g1 + m) * 255.0);
        int b = PfmeaWindowController.roundToByte((b1 + m) * 255.0);
        return String.format("#%02X%02X%02X", r, g, b);
    }

    private static int roundToByte(double value) {
        int v = (int)Math.round(value);
        if (v < 0) {
            return 0;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }

    private void adjustValueAxis(BarChart<String, Number> chart, XYChart.Series<String, Number> series) {
        if (chart == null || series == null) {
            return;
        }
        Axis axis = chart.getYAxis();
        if (!(axis instanceof NumberAxis)) {
            return;
        }
        NumberAxis axis2 = (NumberAxis)axis;
        double max = series.getData().stream().mapToDouble(data -> {
            Number value = (Number)data.getYValue();
            return value == null ? 0.0 : value.doubleValue();
        }).max().orElse(0.0);
        double padding = Math.max(1.0, max * 0.15);
        double upperBound = Math.max(1.0, max + padding);
        axis2.setAutoRanging(false);
        axis2.setLowerBound(0.0);
        double upper = Math.ceil(upperBound);
        axis2.setUpperBound(upper);
        double tick = Math.max(1.0, Math.ceil(upper / 5.0));
        axis2.setTickUnit(tick);
    }

    private void addLabelsForSeries(XYChart.Series<String, Number> series) {
        Platform.runLater(() -> {
            for (XYChart.Data d : series.getData()) {
                if (d.getNode() == null) {
                    d.nodeProperty().addListener((o, ov, nv) -> {
                        if (nv != null) {
                            this.attachLabelToBarNode((StackPane)nv, (XYChart.Data<String, Number>)d);
                        }
                    });
                    continue;
                }
                this.attachLabelToBarNode((StackPane)d.getNode(), (XYChart.Data<String, Number>)d);
            }
        });
    }

    private void attachLabelToBarNode(StackPane bar, XYChart.Data<String, Number> d) {
        String KEY = "bar-label";
        Label lbl = (Label)bar.getProperties().get((Object)"bar-label");
        if (lbl == null) {
            lbl = new Label(String.valueOf(d.getYValue()));
            lbl.setStyle("-fx-font-weight: bold; -fx-text-fill: black;");
            lbl.setMouseTransparent(true);
            bar.getProperties().put((Object)"bar-label", (Object)lbl);
            bar.getChildren().add((Object)lbl);
            StackPane.setAlignment((Node)lbl, (Pos)Pos.TOP_CENTER);
            lbl.translateYProperty().bind((ObservableValue)lbl.heightProperty().multiply(-1).subtract(4));
        } else {
            lbl.setText(String.valueOf(d.getYValue()));
            if (!bar.getChildren().contains((Object)lbl)) {
                bar.getChildren().add((Object)lbl);
                StackPane.setAlignment((Node)lbl, (Pos)Pos.TOP_CENTER);
                lbl.translateYProperty().bind((ObservableValue)lbl.heightProperty().multiply(-1).subtract(4));
            }
        }
        Label labelRef = lbl;
        d.YValueProperty().addListener((o, ov, nv) -> labelRef.setText(String.valueOf(nv)));
    }

    private static <S> void navigateFromCell(TableCell<S, ?> cell, int step) {
        if (cell == null || step == 0) {
            return;
        }
        TableView tv = cell.getTableView();
        if (tv == null) {
            return;
        }
        TableColumn current = cell.getTableColumn();
        if (current == null) {
            return;
        }
        TableView.TableViewSelectionModel selectionModel = tv.getSelectionModel();
        TableView.TableViewFocusModel focusModel = tv.getFocusModel();
        if (selectionModel == null || focusModel == null) {
            return;
        }
        ObservableList items = tv.getItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        for (TableColumn col : tv.getVisibleLeafColumns()) {
            if (col == null || !col.isVisible() || !col.isEditable()) continue;
            columns.add(col);
        }
        if (columns.isEmpty()) {
            columns.addAll((Collection<TableColumn>)tv.getVisibleLeafColumns());
        }
        if (columns.isEmpty()) {
            return;
        }
        int rowIdx = Math.max(0, Math.min(items.size() - 1, cell.getIndex()));
        int colIdx = columns.indexOf(current);
        if (colIdx < 0) {
            colIdx = tv.getVisibleLeafIndex(current);
        }
        if (colIdx < 0) {
            colIdx = 0;
        }
        colIdx = Math.min(colIdx, columns.size() - 1);
        int totalCols = columns.size();
        if (totalCols == 0) {
            return;
        }
        int totalCells = items.size() * totalCols;
        if (totalCells == 0) {
            return;
        }
        int linearIndex = rowIdx * totalCols + colIdx;
        int targetIndex = Math.max(0, Math.min(totalCells - 1, linearIndex + step));
        int targetRow = targetIndex / totalCols;
        int targetCol = targetIndex % totalCols;
        TableColumn target = (TableColumn)columns.get(targetCol);
        if (target == null) {
            return;
        }
        HorizontalScrollState snapshot = PfmeaWindowController.captureHorizontalScrollState(tv);
        selectionModel.clearAndSelect(targetRow, target);
        focusModel.focus(targetRow, target);
        TableColumn targetColumn = target;
        int rowFinal = targetRow;
        boolean shouldEdit = tv.isEditable() && targetColumn.isEditable();
        Platform.runLater(() -> {
            PfmeaWindowController.ensureColumnVisible(tv, targetColumn, snapshot);
            if (shouldEdit) {
                tv.edit(rowFinal, targetColumn);
            }
        });
    }

    private static HorizontalScrollState captureHorizontalScrollState(TableView<?> tv) {
        ScrollBar bar = PfmeaWindowController.findHorizontalScrollBar(tv);
        if (bar == null) {
            return null;
        }
        return new HorizontalScrollState(bar.getValue());
    }

    private static void ensureColumnVisible(TableView<?> tv, TableColumn<?, ?> target, HorizontalScrollState before) {
        double current;
        ScrollBar bar = PfmeaWindowController.findHorizontalScrollBar(tv);
        if (bar == null || target == null) {
            return;
        }
        double viewport = bar.getVisibleAmount();
        if (viewport <= 0.0) {
            return;
        }
        double left = PfmeaWindowController.computeColumnLeft(tv, target);
        double right = left + Math.max(target.getWidth(), 1.0);
        double desired = current = before != null ? before.value : bar.getValue();
        if (right > current + viewport) {
            desired = right - viewport;
        } else if (left < current) {
            desired = left;
        }
        desired = Math.max(bar.getMin(), Math.min(bar.getMax(), desired));
        bar.setValue(desired);
    }

    private static double computeColumnLeft(TableView tv, TableColumn target) {
        Object colObj;
        TableColumn col;
        double left = 0.0;
        Iterator iterator = tv.getVisibleLeafColumns().iterator();
        while (iterator.hasNext() && (col = (TableColumn)(colObj = iterator.next())) != target) {
            left += col.getWidth();
        }
        return left;
    }

    private static ScrollBar findHorizontalScrollBar(TableView<?> tv) {
        ScrollBar sb;
        if (tv == null) {
            return null;
        }
        Object cached = tv.getProperties().get((Object)HSCROLL_CACHE_KEY);
        if (cached instanceof ScrollBar && (sb = (ScrollBar)cached).getParent() != null) {
            return sb;
        }
        ScrollBar found = PfmeaWindowController.lookupHorizontalScrollBar(tv);
        if (found != null) {
            tv.getProperties().put((Object)HSCROLL_CACHE_KEY, (Object)found);
        }
        return found;
    }

    private static ScrollBar lookupHorizontalScrollBar(TableView<?> tv) {
        if (tv == null || tv.getScene() == null) {
            return null;
        }
        for (Node node : tv.lookupAll(".scroll-bar")) {
            ScrollBar sb;
            if (!(node instanceof ScrollBar) || (sb = (ScrollBar)node).getOrientation() != Orientation.HORIZONTAL) continue;
            return sb;
        }
        return null;
    }

    private void applyFailureChainHighlight(TableRow<PfmeaRow> row) {
        if (row == null) {
            return;
        }
        if (this.failureChainSearch == null || this.failureChainSearch.getLastQuery().isEmpty() || row.isEmpty()) {
            row.setStyle("");
            return;
        }
        if (this.failureChainSearch.getCurrentMatchRow() == row.getIndex()) {
            if (row.isSelected()) {
                row.setStyle(SEARCH_HIGHLIGHT_SELECTED_STYLE);
            } else {
                row.setStyle(SEARCH_HIGHLIGHT_STYLE);
            }
        } else {
            row.setStyle("");
        }
    }

    private void updateSearchPattern() {
        if (this.failureChainSearch == null) {
            this.searchHighlightPattern = null;
            return;
        }
        String query = this.failureChainSearch.getLastQuery();
        this.searchHighlightPattern = query == null || query.isBlank() ? null : Pattern.compile(Pattern.quote(query.trim()), 2);
    }

    private /* synthetic */ void lambda$configureRowContextMenu$6(TableRow row, ContextMenuEvent evt) {
        if (!row.isEmpty()) {
            this.tblRows.getSelectionModel().clearAndSelect(row.getIndex());
        }
    }

    private /* synthetic */ void lambda$configureRowContextMenu$5(TableRow row, ActionEvent evt) {
        if (row.isEmpty()) {
            return;
        }
        this.duplicateRow((PfmeaRow)row.getItem());
    }

    private /* synthetic */ void lambda$configureRowContextMenu$4(TableRow row, ActionEvent evt) {
        if (row.isEmpty()) {
            return;
        }
        this.addRowAt(row.getIndex() + 1, true);
    }

    private /* synthetic */ void lambda$configureRowContextMenu$3(TableRow row, ActionEvent evt) {
        if (row.isEmpty()) {
            return;
        }
        this.tblRows.getSelectionModel().clearAndSelect(row.getIndex());
        this.onDeleteSelectedChain();
    }

    private /* synthetic */ void lambda$configureRowContextMenu$2(TableRow row, ObservableValue obs, Boolean old, Boolean sel) {
        this.applyFailureChainHighlight((TableRow<PfmeaRow>)row);
    }

    private /* synthetic */ void lambda$configureRowContextMenu$1(TableRow row, ObservableValue obs, Number old, Number idx) {
        this.applyFailureChainHighlight((TableRow<PfmeaRow>)row);
    }

    private /* synthetic */ TableCell lambda$enumCol$1(final Enum[] options, final StringConverter converter, final TableColumn column, TableColumn col) {
        return new TableCell<PfmeaRow, E>(this){
            private final ComboBox<E> cb;
            {
                Objects.requireNonNull(this$0);
                this.cb = new ComboBox(FXCollections.observableArrayList((Object[])options));
                this.cb.setConverter(converter);
                this.cb.setMaxWidth(Double.MAX_VALUE);
                this.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
                    TableView tv;
                    if (e.getButton() != MouseButton.PRIMARY || e.getClickCount() < 2) {
                        return;
                    }
                    if (!this.isEmpty() && !this.isEditing() && (tv = this.getTableView()) != null) {
                        tv.edit(this.getIndex(), column);
                        e.consume();
                    }
                });
                this.cb.setOnAction(ev -> {
                    if (this.isEditing()) {
                        this.commitEdit((E)((Enum)this.cb.getValue()));
                    }
                });
                this.cb.focusedProperty().addListener((o, was, isNow) -> {
                    if (!isNow.booleanValue() && this.isEditing()) {
                        this.commitEdit((E)((Enum)this.cb.getValue()));
                    }
                });
                this.cb.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
                    if (e.getCode() == KeyCode.TAB) {
                        if (this.isEditing()) {
                            this.commitEdit((E)((Enum)this.cb.getValue()));
                        }
                        PfmeaWindowController.navigateFromCell(this, e.isShiftDown() ? -1 : 1);
                        e.consume();
                    } else if (e.getCode() == KeyCode.ESCAPE) {
                        this.cancelEdit();
                        e.consume();
                    }
                });
            }

            public void startEdit() {
                super.startEdit();
                if (this.isEmpty()) {
                    return;
                }
                this.cb.getSelectionModel().select((Object)((Enum)this.getItem()));
                this.setGraphic((Node)this.cb);
                this.setText(null);
                Platform.runLater(() -> {
                    this.cb.requestFocus();
                    this.cb.show();
                });
            }

            public void cancelEdit() {
                super.cancelEdit();
                this.setText(converter.toString((Object)((Enum)this.getItem())));
                this.setGraphic(null);
            }

            public void commitEdit(E newValue) {
                super.commitEdit(newValue);
                this.setText(converter.toString(newValue));
                this.setGraphic(null);
            }

            protected void updateItem(E item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else if (this.isEditing()) {
                    this.cb.getSelectionModel().select(item);
                    this.setGraphic((Node)this.cb);
                    this.setText(null);
                } else {
                    this.setText(converter.toString(item));
                    this.setGraphic(null);
                    this.setAlignment(Pos.CENTER);
                }
            }
        };
    }

    private static enum ExportFormat {
        PDF,
        EXCEL;

    }

    private static enum MentionKind {
        HIGHER,
        FOCUS,
        LOWER;

    }

    private static final class HorizontalScrollState {
        final double value;

        HorizontalScrollState(double value) {
            this.value = value;
        }
    }
}

