/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.controllers.util.DragDropStyler;
import com.qualidadeeprodutividade.processItem.Parameter;
import com.qualidadeeprodutividade.processItem.ProcessItem;
import com.qualidadeeprodutividade.processItem.ProcessStructureCloner;
import com.qualidadeeprodutividade.processItem.ProcessType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;

public class ProcessExchangeController {
    @FXML
    private AnchorPane root;
    @FXML
    private TreeView<Object> treeProcessOrigin;
    @FXML
    private TreeView<Object> treeProcessDestination;
    @FXML
    private Button btnSaveOnly;
    @FXML
    private Button btnSaveExit;
    private Image icSave;
    private Image icExit;
    private Stage owner;
    private ProcessItem destinationRoot;
    private List<ProcessItem> availableProcesses = List.of();
    private Runnable saveAction = () -> {};
    private Runnable changeHook = () -> {};
    private static final String DND_MARKER = "PROCESS_EXCHANGE_NODE";
    private static final PseudoClass DND_TARGET = PseudoClass.getPseudoClass((String)"drag-target");
    private Object dragPayload;
    private TreeCell<Object> highlightedCell;
    private Image icProcess;
    private Image icParameter;

    @FXML
    private void initialize() {
        this.loadIcons();
        this.configureButtons();
        this.configureTrees();
        this.rebuildOriginTree();
        this.rebuildDestinationTree();
    }

    public void setOwnerStage(Stage stage) {
        this.owner = stage;
    }

    public void setDestinationProcess(ProcessItem root) {
        this.destinationRoot = root;
        this.rebuildDestinationTree();
    }

    public void setAvailableProcesses(List<ProcessItem> processes) {
        if (processes == null || processes.isEmpty()) {
            this.availableProcesses = List.of();
        } else {
            ArrayList<ProcessItem> copy = new ArrayList<ProcessItem>();
            for (ProcessItem process : processes) {
                if (process == null) continue;
                copy.add(process);
            }
            this.availableProcesses = copy.isEmpty() ? List.of() : List.copyOf(copy);
        }
        this.rebuildOriginTree();
    }

    public void setSaveAction(Runnable action) {
        this.saveAction = action == null ? () -> {} : action;
    }

    public void setChangeHook(Runnable hook) {
        this.changeHook = hook == null ? () -> {} : hook;
    }

    private void configureButtons() {
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setTooltip(new Tooltip("Salvar e continuar editando"));
            this.btnSaveOnly.setOnAction(e -> this.onSaveOnly());
            this.btnSaveOnly.setGraphic((Node)this.icon20(this.icSave));
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setTooltip(new Tooltip("Salvar e fechar"));
            this.btnSaveExit.setOnAction(e -> this.onSaveAndExit());
            this.btnSaveExit.setGraphic((Node)this.icon20(this.icExit));
        }
    }

    private void configureTrees() {
        if (this.treeProcessOrigin != null) {
            this.treeProcessOrigin.setShowRoot(false);
            DragDropStyler.ensure(this.treeProcessOrigin);
            this.treeProcessOrigin.setCellFactory(tv -> this.createOriginCell());
        }
        if (this.treeProcessDestination != null) {
            this.treeProcessDestination.setShowRoot(true);
            DragDropStyler.ensure(this.treeProcessDestination);
            this.treeProcessDestination.setCellFactory(tv -> this.createDestinationCell());
        }
    }

    private TreeCell<Object> createOriginCell() {
        TreeCell<Object> cell = new TreeCell<Object>(this){
            final /* synthetic */ ProcessExchangeController this$0;
            {
                ProcessExchangeController processExchangeController = this$0;
                Objects.requireNonNull(processExchangeController);
                this.this$0 = processExchangeController;
            }

            protected void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                this.this$0.updateCellDisplay(this, item, empty);
            }
        };
        cell.setOnDragDetected(arg_0 -> this.lambda$createOriginCell$0((TreeCell)cell, arg_0));
        cell.setOnDragDone(event -> {
            this.dragPayload = null;
        });
        return cell;
    }

    private TreeCell<Object> createDestinationCell() {
        TreeCell<Object> cell = new TreeCell<Object>(this){
            final /* synthetic */ ProcessExchangeController this$0;
            {
                ProcessExchangeController processExchangeController = this$0;
                Objects.requireNonNull(processExchangeController);
                this.this$0 = processExchangeController;
            }

            protected void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                this.this$0.updateCellDisplay(this, item, empty);
            }
        };
        cell.setOnDragOver(arg_0 -> this.lambda$createDestinationCell$0((TreeCell)cell, arg_0));
        cell.setOnDragDropped(arg_0 -> this.lambda$createDestinationCell$1((TreeCell)cell, arg_0));
        cell.setOnDragExited(arg_0 -> this.lambda$createDestinationCell$2((TreeCell)cell, arg_0));
        return cell;
    }

    private boolean handleDrop(TreeItem<Object> target) {
        ProcessItem destination;
        block11: {
            block10: {
                Object object;
                if (target == null || !((object = target.getValue()) instanceof ProcessItem)) break block10;
                destination = (ProcessItem)object;
                if (this.dragPayload != null) break block11;
            }
            return false;
        }
        if (!this.canAccept(destination, this.dragPayload)) {
            return false;
        }
        Object object = this.dragPayload;
        if (object instanceof ProcessItem) {
            ProcessItem sourceItem = (ProcessItem)object;
            clone = ProcessStructureCloner.cloneProcessItem(sourceItem);
            if (clone == null) {
                return false;
            }
            destination.addChild((ProcessItem)clone);
        } else {
            clone = this.dragPayload;
            if (clone instanceof Parameter) {
                Parameter sourceParam = (Parameter)clone;
                if ((clone = ProcessStructureCloner.cloneParameter(sourceParam)) == null) {
                    return false;
                }
                destination.addParameter((Parameter)clone);
            } else {
                return false;
            }
        }
        this.notifyStructureChange();
        return true;
    }

    private boolean isValidDrag(Dragboard db) {
        return this.dragPayload != null && db != null && db.hasString() && DND_MARKER.equals(db.getString());
    }

    private TreeItem<Object> resolveDropTarget(TreeItem<Object> candidate) {
        TreeItem current;
        for (current = candidate; current != null && !(current.getValue() instanceof ProcessItem); current = current.getParent()) {
        }
        return current;
    }

    private void rebuildOriginTree() {
        if (this.treeProcessOrigin == null) {
            return;
        }
        TreeItem pseudoRoot = new TreeItem((Object)"root");
        for (ProcessItem process : this.availableProcesses) {
            pseudoRoot.getChildren().add(this.buildTree(process));
        }
        pseudoRoot.setExpanded(true);
        this.treeProcessOrigin.setRoot(pseudoRoot);
    }

    private void rebuildDestinationTree() {
        if (this.treeProcessDestination == null) {
            return;
        }
        if (this.destinationRoot == null) {
            this.treeProcessDestination.setRoot(null);
            return;
        }
        TreeItem<Object> rootItem = this.buildTree(this.destinationRoot);
        rootItem.setExpanded(true);
        this.treeProcessDestination.setRoot(rootItem);
    }

    private TreeItem<Object> buildTree(Object value) {
        TreeItem ti = new TreeItem(value);
        if (value instanceof ProcessItem) {
            ProcessItem process = (ProcessItem)value;
            if (process.getChildren() != null) {
                for (ProcessItem child : process.getChildren()) {
                    ti.getChildren().add(this.buildTree(child));
                }
            }
            if (process.getParameters() != null) {
                for (Parameter parameter : process.getParameters()) {
                    ti.getChildren().add((Object)new TreeItem((Object)parameter));
                }
            }
        }
        return ti;
    }

    private void updateCellDisplay(TreeCell<Object> cell, Object value, boolean empty) {
        if (empty || value == null) {
            cell.setText(null);
            cell.setGraphic(null);
            return;
        }
        if (value instanceof ProcessItem) {
            ProcessItem process = (ProcessItem)value;
            cell.setText(this.safe(process.getDescription()));
            Image icon = this.iconForProcess(process);
            cell.setGraphic((Node)(icon == null ? null : new ImageView(icon)));
        } else if (value instanceof Parameter) {
            Parameter parameter = (Parameter)value;
            cell.setText(this.safe(parameter.getDescription()));
            cell.setGraphic((Node)(this.icParameter == null ? null : new ImageView(this.icParameter)));
        } else if (value instanceof String) {
            String text = (String)value;
            cell.setText(text);
            cell.setGraphic(null);
        } else {
            cell.setText(value.toString());
            cell.setGraphic(null);
        }
    }

    private Image iconForProcess(ProcessItem process) {
        if (process == null) {
            return this.icProcess;
        }
        ProcessType type = this.normalizedType(process);
        switch (type) {
            default: {
                throw new MatchException(null, null);
            }
            case PROCESS: 
            case OPERATION: 
            case ACTIVITY: 
        }
        return this.icProcess;
    }

    private boolean isDraggable(Object value) {
        if (value instanceof Parameter) {
            return true;
        }
        if (value instanceof ProcessItem) {
            ProcessItem process = (ProcessItem)value;
            ProcessType type = this.normalizedType(process);
            return type == ProcessType.OPERATION || type == ProcessType.ACTIVITY;
        }
        return false;
    }

    private boolean canAccept(ProcessItem destination, Object payload) {
        ProcessType destType = this.normalizedType(destination);
        if (payload instanceof ProcessItem) {
            ProcessItem item = (ProcessItem)payload;
            ProcessType payloadType = this.normalizedType(item);
            if (payloadType == ProcessType.OPERATION) {
                return destType == ProcessType.PROCESS;
            }
            if (payloadType == ProcessType.ACTIVITY) {
                return destType == ProcessType.OPERATION;
            }
            return false;
        }
        if (payload instanceof Parameter) {
            return destType == ProcessType.PROCESS || destType == ProcessType.OPERATION || destType == ProcessType.ACTIVITY;
        }
        return false;
    }

    private ProcessType normalizedType(ProcessItem item) {
        if (item == null) {
            return ProcessType.ACTIVITY;
        }
        if (item == this.destinationRoot) {
            return ProcessType.PROCESS;
        }
        ProcessType type = item.getType();
        return type == null ? ProcessType.ACTIVITY : type;
    }

    private void showDropTarget(TreeCell<Object> cell) {
        if (cell == null) {
            return;
        }
        if (this.highlightedCell != cell) {
            this.clearDropHighlight();
            this.highlightedCell = cell;
            cell.pseudoClassStateChanged(DND_TARGET, true);
        }
    }

    private void clearDropHighlight(TreeCell<Object> cell) {
        if (cell != null) {
            cell.pseudoClassStateChanged(DND_TARGET, false);
            if (cell == this.highlightedCell) {
                this.highlightedCell = null;
            }
        }
    }

    private void clearDropHighlight() {
        this.clearDropHighlight(this.highlightedCell);
    }

    private void notifyStructureChange() {
        this.changeHook.run();
        this.rebuildDestinationTree();
    }

    private void onSaveOnly() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.runSaveAction();
    }

    private void onSaveAndExit() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.runSaveAction()) {
            this.closeWindow();
        }
    }

    private boolean runSaveAction() {
        try {
            this.saveAction.run();
            return true;
        }
        catch (Exception ex) {
            new Alert(Alert.AlertType.ERROR, "Falha ao salvar:\n" + ex.getMessage(), new ButtonType[0]).showAndWait();
            return false;
        }
    }

    private boolean ensureEditPermission() {
        return true;
    }

    private void closeWindow() {
        Stage stage = this.owner;
        if (stage == null && this.root != null && this.root.getScene() != null) {
            stage = (Stage)this.root.getScene().getWindow();
        }
        if (stage != null) {
            stage.close();
        }
    }

    private void loadIcons() {
        this.icProcess = this.loadIcon("process");
        this.icParameter = this.loadIcon("characteristic");
        this.icSave = this.loadIcon("save");
        this.icExit = this.loadIcon("exit");
    }

    private Image loadIcon(String name) {
        InputStream stream = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        if (stream == null) {
            return null;
        }
        return new Image(stream, 32.0, 32.0, true, true);
    }

    private ImageView icon20(Image img) {
        if (img == null) {
            return null;
        }
        ImageView iv = new ImageView(img);
        iv.setPreserveRatio(true);
        iv.setFitWidth(20.0);
        iv.setFitHeight(20.0);
        iv.setSmooth(true);
        return iv;
    }

    private String safe(String value) {
        return value == null || value.isBlank() ? "(sem descricao)" : value;
    }

    private /* synthetic */ void lambda$createDestinationCell$2(TreeCell cell, DragEvent event) {
        this.clearDropHighlight((TreeCell<Object>)cell);
    }

    private /* synthetic */ void lambda$createDestinationCell$1(TreeCell cell, DragEvent event) {
        TreeItem<Object> target;
        boolean success = false;
        if (this.isValidDrag(event.getDragboard()) && (target = this.resolveDropTarget((TreeItem<Object>)cell.getTreeItem())) != null) {
            success = this.handleDrop(target);
        }
        event.setDropCompleted(success);
        this.dragPayload = null;
        this.clearDropHighlight((TreeCell<Object>)cell);
        event.consume();
    }

    private /* synthetic */ void lambda$createDestinationCell$0(TreeCell cell, DragEvent event) {
        if (!this.isValidDrag(event.getDragboard())) {
            return;
        }
        TreeItem<Object> target = this.resolveDropTarget((TreeItem<Object>)cell.getTreeItem());
        if (target != null && target.getValue() instanceof ProcessItem) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            this.showDropTarget((TreeCell<Object>)cell);
        }
        event.consume();
    }

    private /* synthetic */ void lambda$createOriginCell$0(TreeCell cell, MouseEvent event) {
        Object value = cell.getItem();
        if (value == null || !this.isDraggable(value)) {
            return;
        }
        this.dragPayload = value;
        Dragboard db = cell.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
        ClipboardContent content = new ClipboardContent();
        content.putString(DND_MARKER);
        db.setContent((Map)content);
        event.consume();
    }
}

