/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.controllers.ProcessExchangeController;
import com.qualidadeeprodutividade.controllers.util.DragDropStyler;
import com.qualidadeeprodutividade.processItem.Ishikawa;
import com.qualidadeeprodutividade.processItem.Parameter;
import com.qualidadeeprodutividade.processItem.ProcessCategory;
import com.qualidadeeprodutividade.processItem.ProcessItem;
import com.qualidadeeprodutividade.processItem.ProcessType;
import com.qualidadeeprodutividade.processItem.ValueCategory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.cell.CheckBoxTreeTableCell;
import javafx.scene.control.cell.ComboBoxTreeTableCell;
import javafx.scene.control.cell.TextFieldTreeTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import javafx.util.converter.NumberStringConverter;

public class ProcessTreeManagerController {
    @FXML
    private TreeTableView<Object> ttvProcess;
    @FXML
    private TextField txtSearch;
    @FXML
    private Button btnNext;
    @FXML
    private Button btnCollapseAll;
    @FXML
    private Button btnExpandAll;
    @FXML
    private ImageView imgHeaderIcon;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab tabProcessTreeEditor;
    @FXML
    private Tab tabFlowchart;
    @FXML
    private WebView webFlowchart;
    @FXML
    private TreeTableColumn<Object, String> colDescription;
    @FXML
    private TreeTableColumn<Object, String> colFunction;
    @FXML
    private TreeTableColumn<Object, ProcessType> colType;
    @FXML
    private TreeTableColumn<Object, Ishikawa> colIshikawa;
    @FXML
    private TreeTableColumn<Object, ProcessCategory> colCategory;
    @FXML
    private TreeTableColumn<Object, ValueCategory> colValueCategory;
    @FXML
    private TreeTableColumn<Object, Number> colTime;
    @FXML
    private TreeTableColumn<Object, Number> colDistance;
    @FXML
    private TreeTableColumn<Object, String> colTarget;
    @FXML
    private TreeTableColumn<Object, String> colUpper;
    @FXML
    private TreeTableColumn<Object, String> colLower;
    @FXML
    private TreeTableColumn<Object, Boolean> colAttr;
    @FXML
    private TreeTableColumn<Object, Boolean> colCTS;
    @FXML
    private TreeTableColumn<Object, Boolean> colCTQ;
    @FXML
    private TreeTableColumn<Object, Boolean> colCTP;
    @FXML
    private Button btnAddOperation;
    @FXML
    private Button btnAddActivity;
    @FXML
    private Button btnAddParameter;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnSaveOnly;
    @FXML
    private Button btnSaveExit;
    @FXML
    private Button btnImport;
    @FXML
    private Label lblPath;
    private Stage ownerStage;
    private Runnable dirtyHook = () -> {};
    private boolean hasUnsavedChanges = false;
    private boolean programmaticClose = false;
    private ProcessItem processRoot;
    private Runnable saveAction;
    private boolean flowchartPageRequested = false;
    private boolean flowchartReady = false;
    private static final String DND_MARKER = "PROCESS_TREE_NODE";
    private static final PseudoClass DND_TARGET_PSEUDO = PseudoClass.getPseudoClass((String)"drag-target");
    private TreeItem<Object> draggedItem;
    private TreeTableRow<Object> dropTargetRow;
    private final List<TreeItem<Object>> searchMatches = new ArrayList<TreeItem<Object>>();
    private int currentSearchIndex = -1;
    private String lastSearchQuery = "";
    private List<ProcessItem> projectProcesses = List.of();
    private Image icProcess;
    private Image icOperation;
    private Image icActivity;
    private Image icParameter;

    public void setSaveAction(Runnable r) {
        this.saveAction = r;
    }

    public void setOwnerStage(Stage stage) {
        this.ownerStage = stage;
        this.installCloseHandler();
    }

    public void setDirtyHook(Runnable r) {
        Runnable delegate = r == null ? () -> {} : r;
        this.dirtyHook = () -> {
            this.hasUnsavedChanges = true;
            delegate.run();
        };
    }

    public void setProjectProcesses(List<ProcessItem> processes) {
        this.projectProcesses = processes == null ? List.of() : List.copyOf(processes);
    }

    public void setProcessRoot(ProcessItem root) {
        this.processRoot = root;
        if (this.processRoot != null && this.processRoot.getType() != ProcessType.PROCESS) {
            this.processRoot.setType(ProcessType.PROCESS);
        }
        this.buildAndSetTree();
        this.hasUnsavedChanges = false;
        this.clearProcessSearch();
        if (this.txtSearch != null && !ProcessTreeManagerController.normalizeQuery(this.txtSearch.getText()).isEmpty()) {
            Platform.runLater(() -> this.performProcessSearch(true));
        }
        this.scheduleFlowchartRefresh();
        if (this.ttvProcess != null && this.ttvProcess.getRoot() != null) {
            TreeItem rootItem = this.ttvProcess.getRoot();
            this.ttvProcess.getSelectionModel().select((Object)rootItem);
            Object val = rootItem.getValue();
            boolean canOp = val != null && this.canAddOperationUnder(val);
            boolean canAct = val != null && this.canAddActivityUnder(val);
            boolean canPar = val != null && this.canAddParameterUnder(val);
            boolean canDel = false;
            if (this.btnAddOperation != null) {
                this.btnAddOperation.setDisable(!canOp);
            }
            if (this.btnAddActivity != null) {
                this.btnAddActivity.setDisable(!canAct);
            }
            if (this.btnAddParameter != null) {
                this.btnAddParameter.setDisable(!canPar);
            }
            if (this.btnDelete != null) {
                this.btnDelete.setDisable(!canDel);
            }
        }
        this.updatePath((TreeItem<Object>)((TreeItem)this.ttvProcess.getSelectionModel().getSelectedItem()));
        if (this.btnImport != null) {
            this.btnImport.setDisable(this.processRoot == null);
        }
    }

    private void markDirty() {
        this.hasUnsavedChanges = true;
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        this.scheduleFlowchartRefresh();
    }

    private void configureHeaderIcon() {
        if (this.imgHeaderIcon == null) {
            return;
        }
        URL iconUrl = this.getClass().getResource("/icons/process.png");
        if (iconUrl == null) {
            System.err.println("Icon resource not found: /icons/process.png");
            return;
        }
        this.imgHeaderIcon.setImage(new Image(iconUrl.toExternalForm()));
    }

    private void loadNodeIcons() {
        this.icProcess = this.loadIcon("process");
        this.icOperation = this.loadIcon("operation");
        this.icActivity = this.loadIcon("activity");
        this.icParameter = this.loadIcon("parameter");
    }

    private Image loadIcon(String name) {
        InputStream is = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        if (is == null) {
            is = this.getClass().getResourceAsStream("/icons/" + name + ".jpg");
        }
        return is == null ? null : new Image(is, 24.0, 24.0, true, true);
    }

    private ImageView iconForValue(Object value) {
        Image icon = this.selectNodeIcon(value);
        return icon == null ? null : new ImageView(icon);
    }

    private void setGraphicPreservingSize(Button btn, Image img, double size) {
        if (btn == null) {
            return;
        }
        double prefW = btn.getPrefWidth();
        double prefH = btn.getPrefHeight();
        double minW = btn.getMinWidth();
        double minH = btn.getMinHeight();
        double maxW = btn.getMaxWidth();
        double maxH = btn.getMaxHeight();
        btn.setGraphic((Node)this.iv(img, size));
        btn.setContentDisplay(ContentDisplay.CENTER);
        if (!Double.isNaN(prefW)) {
            btn.setPrefWidth(prefW);
        }
        if (!Double.isNaN(prefH)) {
            btn.setPrefHeight(prefH);
        }
        if (!Double.isNaN(minW)) {
            btn.setMinWidth(minW);
        }
        if (!Double.isNaN(minH)) {
            btn.setMinHeight(minH);
        }
        if (!Double.isNaN(maxW)) {
            btn.setMaxWidth(maxW);
        }
        if (!Double.isNaN(maxH)) {
            btn.setMaxHeight(maxH);
        }
    }

    private ImageView iv(Image img, double size) {
        if (img == null) {
            return null;
        }
        ImageView v = new ImageView(img);
        v.setPreserveRatio(true);
        v.setFitWidth(size);
        v.setFitHeight(size);
        v.setSmooth(true);
        return v;
    }

    private Image selectNodeIcon(Object value) {
        if (value instanceof Parameter) {
            return this.icParameter;
        }
        if (value instanceof ProcessItem) {
            ProcessItem pi = (ProcessItem)value;
            ProcessType type = pi.getType();
            if (type == ProcessType.OPERATION) {
                return this.icOperation != null ? this.icOperation : this.icProcess;
            }
            if (type == ProcessType.ACTIVITY) {
                return this.icActivity != null ? this.icActivity : this.icProcess;
            }
            return this.icProcess;
        }
        return null;
    }

    @FXML
    private void initialize() {
        boolean canDel;
        this.configureHeaderIcon();
        this.loadNodeIcons();
        this.configureSearchControls();
        this.btnAddOperation.setTooltip(new Tooltip("Add Operation under Process"));
        this.btnAddActivity.setTooltip(new Tooltip("Add Activity under Operation"));
        this.btnAddParameter.setTooltip(new Tooltip("Add Parameter under Process/Operation/Activity"));
        this.btnDelete.setTooltip(new Tooltip("Remove selected node"));
        if (this.btnImport != null) {
            this.btnImport.setTooltip(new Tooltip("Import operations, activities or parameters"));
            this.btnImport.setOnAction(e -> this.openProcessExchangeWindow());
        }
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setTooltip(new Tooltip("Save changes without closing"));
            this.btnSaveOnly.setOnAction(e -> this.onSaveOnly());
        }
        this.btnSaveExit.setTooltip(new Tooltip("Save and close the current process"));
        if (this.btnCollapseAll != null) {
            this.btnCollapseAll.setTooltip(new Tooltip("Collapse the entire tree"));
            this.btnCollapseAll.setOnAction(e -> this.collapseProcessTree());
        }
        if (this.btnExpandAll != null) {
            this.btnExpandAll.setTooltip(new Tooltip("Expand the entire tree"));
            this.btnExpandAll.setOnAction(e -> this.expandProcessTree());
        }
        Image icOp = this.icOperation;
        Image icAct = this.icActivity;
        Image icPar = this.icParameter;
        Image icDelete = this.loadIcon("trash");
        Image icSave = this.loadIcon("save");
        Image icExit = this.loadIcon("exit");
        Image icImport = this.loadIcon("import");
        Image icExpand = this.loadIcon("plus");
        Image icCollapse = this.loadIcon("minus");
        Image icSearch = this.loadIcon("search");
        if (this.btnAddOperation != null) {
            this.btnAddOperation.setGraphic((Node)this.iv(icOp, 18.0));
        }
        if (this.btnAddActivity != null) {
            this.btnAddActivity.setGraphic((Node)this.iv(icAct, 18.0));
        }
        if (this.btnAddParameter != null) {
            this.btnAddParameter.setGraphic((Node)this.iv(icPar, 18.0));
        }
        if (this.btnDelete != null) {
            this.btnDelete.setGraphic((Node)this.iv(icDelete, 20.0));
        }
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setGraphic((Node)this.iv(icSave, 20.0));
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setGraphic((Node)this.iv(icExit, 20.0));
        }
        this.setGraphicPreservingSize(this.btnImport, icImport, 18.0);
        this.setGraphicPreservingSize(this.btnExpandAll, icExpand, 16.0);
        this.setGraphicPreservingSize(this.btnCollapseAll, icCollapse, 16.0);
        this.setGraphicPreservingSize(this.btnNext, icSearch, 16.0);
        if (this.tabPane != null && this.tabFlowchart != null) {
            this.tabPane.getSelectionModel().selectedItemProperty().addListener((obs, oldTab, newTab) -> {
                if (newTab == this.tabFlowchart) {
                    this.loadFlowchartPage();
                    this.scheduleFlowchartRefresh();
                }
            });
            if (this.tabPane.getSelectionModel().getSelectedItem() == this.tabFlowchart) {
                this.loadFlowchartPage();
            }
        }
        if (this.ttvProcess == null) {
            return;
        }
        DragDropStyler.ensure(this.ttvProcess);
        this.colFunction.setStyle("-fx-alignment: CENTER;");
        this.colType.setStyle("-fx-alignment: CENTER;");
        this.colIshikawa.setStyle("-fx-alignment: CENTER;");
        this.colCategory.setStyle("-fx-alignment: CENTER;");
        this.colValueCategory.setStyle("-fx-alignment: CENTER;");
        this.colTime.setStyle("-fx-alignment: CENTER;");
        this.colDistance.setStyle("-fx-alignment: CENTER;");
        this.colTarget.setStyle("-fx-alignment: CENTER;");
        this.colUpper.setStyle("-fx-alignment: CENTER;");
        this.colLower.setStyle("-fx-alignment: CENTER;");
        this.colAttr.setStyle("-fx-alignment: CENTER;");
        this.colCTS.setStyle("-fx-alignment: CENTER;");
        this.colCTQ.setStyle("-fx-alignment: CENTER;");
        this.colCTP.setStyle("-fx-alignment: CENTER;");
        this.ttvProcess.setEditable(true);
        this.ttvProcess.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> this.updatePath((TreeItem<Object>)nv));
        this.colDescription.setCellFactory(col -> this.makeCommitOnBlurTextCell(true));
        this.colDescription.setOnEditCommit(ev -> {
            Object rowObj = ev.getRowValue().getValue();
            String newVal = (String)ev.getNewValue();
            if (rowObj instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)rowObj;
                pi.descriptionProperty().set((Object)newVal);
            } else if (rowObj instanceof Parameter) {
                Parameter p = (Parameter)rowObj;
                p.descriptionProperty().set((Object)newVal);
            }
            this.markDirty();
            this.updatePath((TreeItem<Object>)((TreeItem)this.ttvProcess.getSelectionModel().getSelectedItem()));
        });
        this.colFunction.setCellFactory(col -> this.makeCommitOnBlurTextCell());
        this.colFunction.setOnEditCommit(ev -> {
            Object rowObj = ev.getRowValue().getValue();
            String newVal = (String)ev.getNewValue();
            if (rowObj instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)rowObj;
                pi.functionProperty().set((Object)newVal);
                this.markDirty();
            }
        });
        this.colDescription.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)row;
                return pi.descriptionProperty();
            }
            if (row instanceof Parameter) {
                Parameter p = (Parameter)row;
                return p.descriptionProperty();
            }
            return new SimpleStringProperty("");
        });
        this.colFunction.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)row;
                return pi.functionProperty();
            }
            return new SimpleStringProperty("");
        });
        this.colType.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)row;
                return new ReadOnlyObjectWrapper((Object)pi.getType());
            }
            return new ReadOnlyObjectWrapper(null);
        });
        this.colType.setEditable(false);
        this.colType.setSortable(false);
        this.colIshikawa.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)row;
                return new ReadOnlyObjectWrapper((Object)pi.getIshikawa());
            }
            return new ReadOnlyObjectWrapper(null);
        });
        this.colCategory.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)row;
                return new ReadOnlyObjectWrapper((Object)pi.getCategory());
            }
            return new ReadOnlyObjectWrapper(null);
        });
        this.colValueCategory.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)row;
                return new ReadOnlyObjectWrapper((Object)pi.getValueCategory());
            }
            return new ReadOnlyObjectWrapper(null);
        });
        this.colTime.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)row;
                return pi.timeProperty();
            }
            return new ReadOnlyObjectWrapper(null);
        });
        this.colDistance.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)row;
                return pi.distanceProperty();
            }
            return new ReadOnlyObjectWrapper(null);
        });
        this.colTarget.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof Parameter) {
                Parameter p = (Parameter)row;
                return p.targetValueTextProperty();
            }
            return new ReadOnlyStringWrapper("");
        });
        this.colUpper.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof Parameter) {
                Parameter p = (Parameter)row;
                return p.upperLimitTextProperty();
            }
            return new ReadOnlyStringWrapper("");
        });
        this.colLower.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof Parameter) {
                Parameter p = (Parameter)row;
                return p.lowerLimitTextProperty();
            }
            return new ReadOnlyStringWrapper("");
        });
        this.colAttr.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof Parameter) {
                Parameter p = (Parameter)row;
                return p.attributeProperty();
            }
            return new ReadOnlyObjectWrapper(null);
        });
        this.colCTS.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof Parameter) {
                Parameter p = (Parameter)row;
                return p.criticalToSafetyProperty();
            }
            return new ReadOnlyObjectWrapper(null);
        });
        this.colCTQ.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof Parameter) {
                Parameter p = (Parameter)row;
                return p.criticalToQualityProperty();
            }
            return new ReadOnlyObjectWrapper(null);
        });
        this.colCTP.setCellValueFactory(cd -> {
            Object row = cd.getValue().getValue();
            if (row instanceof Parameter) {
                Parameter p = (Parameter)row;
                return p.criticalToProcessProperty();
            }
            return new ReadOnlyObjectWrapper(null);
        });
        this.colIshikawa.setEditable(true);
        this.colIshikawa.setCellFactory(col -> this.enumCellForProcess(Ishikawa.values()));
        this.colIshikawa.setOnEditCommit(ev -> {
            Object row = ev.getRowValue().getValue();
            if (row instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)row;
                pi.ishikawaProperty().set((Object)((Ishikawa)((Object)((Object)ev.getNewValue()))));
                this.markDirty();
            }
        });
        this.colCategory.setEditable(true);
        this.colCategory.setCellFactory(col -> this.enumCellForProcess(ProcessCategory.values()));
        this.colCategory.setOnEditCommit(ev -> {
            Object row = ev.getRowValue().getValue();
            if (row instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)row;
                pi.categoryProperty().set((Object)((ProcessCategory)((Object)((Object)ev.getNewValue()))));
                this.markDirty();
            }
        });
        this.colValueCategory.setEditable(true);
        this.colValueCategory.setCellFactory(col -> this.enumCellForProcess(ValueCategory.values()));
        this.colValueCategory.setOnEditCommit(ev -> {
            Object row = ev.getRowValue().getValue();
            if (row instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)row;
                pi.valueCategoryProperty().set((Object)((ValueCategory)((Object)((Object)ev.getNewValue()))));
                this.markDirty();
            }
        });
        this.colTime.setEditable(true);
        this.colTime.setCellFactory(c -> this.makeNumberCellForActivityOnly());
        this.colTime.setOnEditCommit(ev -> {
            Object obj = ev.getRowValue().getValue();
            if (obj instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)obj;
                Number n = (Number)ev.getNewValue();
                pi.timeProperty().set(n == null ? 0.0 : n.doubleValue());
                this.recomputeUpFrom((TreeItem<Object>)ev.getRowValue().getParent());
                this.markDirty();
            }
        });
        this.colDistance.setEditable(true);
        this.colDistance.setCellFactory(c -> this.makeNumberCellForActivityOnly());
        this.colDistance.setOnEditCommit(ev -> {
            Object obj = ev.getRowValue().getValue();
            if (obj instanceof ProcessItem) {
                ProcessItem pi = (ProcessItem)obj;
                Number n = (Number)ev.getNewValue();
                pi.distanceProperty().set(n == null ? 0.0 : n.doubleValue());
                this.recomputeUpFrom((TreeItem<Object>)ev.getRowValue().getParent());
                this.markDirty();
            }
        });
        this.colTarget.setEditable(true);
        this.colTarget.setCellFactory(c -> this.makeTextCellForParameterOnly());
        this.colTarget.setOnEditCommit(ev -> {
            Object row = ev.getRowValue().getValue();
            if (row instanceof Parameter) {
                Parameter p = (Parameter)row;
                p.setTargetValueText((String)ev.getNewValue());
                this.markDirty();
                ev.getTreeTableView().refresh();
            }
        });
        this.colUpper.setEditable(true);
        this.colUpper.setCellFactory(c -> this.makeTextCellForParameterOnly());
        this.colUpper.setOnEditCommit(ev -> {
            Object obj = ev.getRowValue().getValue();
            if (obj instanceof Parameter) {
                Parameter p = (Parameter)obj;
                p.setUpperLimitText((String)ev.getNewValue());
                this.markDirty();
            }
        });
        this.colLower.setEditable(true);
        this.colLower.setCellFactory(c -> this.makeTextCellForParameterOnly());
        this.colLower.setOnEditCommit(ev -> {
            Object obj = ev.getRowValue().getValue();
            if (obj instanceof Parameter) {
                Parameter p = (Parameter)obj;
                p.setLowerLimitText((String)ev.getNewValue());
                this.markDirty();
            }
        });
        this.colAttr.setEditable(true);
        this.colCTS.setEditable(true);
        this.colCTQ.setEditable(true);
        this.colCTP.setEditable(true);
        this.colAttr.setCellFactory(c -> this.makeBooleanCellForParameterOnly());
        this.colCTS.setCellFactory(c -> this.makeBooleanCellForParameterOnly());
        this.colCTQ.setCellFactory(c -> this.makeBooleanCellForParameterOnly());
        this.colCTP.setCellFactory(c -> this.makeBooleanCellForParameterOnly());
        this.setupContextMenu();
        this.ttvProcess.getSelectionModel().selectedItemProperty().addListener((o, oldTi, newTi) -> this.updateButtonsFor((TreeItem<Object>)newTi));
        this.ttvProcess.focusedProperty().addListener((o, was, isNow) -> {
            TreeItem cur = (TreeItem)this.ttvProcess.getSelectionModel().getSelectedItem();
            this.updateButtonsFor((TreeItem<Object>)cur);
        });
        TreeItem ti = (TreeItem)this.ttvProcess.getSelectionModel().getSelectedItem();
        Object val = ti == null ? null : ti.getValue();
        boolean canOp = val != null && this.canAddOperationUnder(val);
        boolean canAct = val != null && this.canAddActivityUnder(val);
        boolean canPar = val != null && this.canAddParameterUnder(val);
        boolean bl = canDel = ti != null && !this.isRoot((TreeItem<Object>)ti);
        if (this.btnAddOperation != null) {
            this.btnAddOperation.setDisable(!canOp);
        }
        if (this.btnAddActivity != null) {
            this.btnAddActivity.setDisable(!canAct);
        }
        if (this.btnAddParameter != null) {
            this.btnAddParameter.setDisable(!canPar);
        }
        if (this.btnDelete != null) {
            this.btnDelete.setDisable(!canDel);
        }
    }

    private void setupContextMenu() {
        ContextMenu cm = new ContextMenu();
        MenuItem miAddOp = new MenuItem("Add Operation");
        miAddOp.setOnAction(e -> this.onAddOperation());
        MenuItem miAddAct = new MenuItem("Add Activity");
        miAddAct.setOnAction(e -> this.onAddActivity());
        MenuItem miAddPar = new MenuItem("Add Parameter");
        miAddPar.setOnAction(e -> this.onAddParameter());
        MenuItem miDuplicate = new MenuItem("Duplicate");
        miDuplicate.setOnAction(e -> this.onDuplicateProcessNode());
        MenuItem miDel = new MenuItem("Delete");
        miDel.setOnAction(e -> this.onDelete());
        MenuItem miSave = new MenuItem("Save & Exit");
        miSave.setOnAction(e -> this.onSaveAndExit());
        cm.getItems().setAll((Object[])new MenuItem[]{miAddOp, miAddAct, miAddPar, new SeparatorMenuItem(), miDuplicate, new SeparatorMenuItem(), miDel, new SeparatorMenuItem(), miSave});
        this.ttvProcess.setRowFactory(tv -> {
            TreeTableRow row = new TreeTableRow();
            row.emptyProperty().addListener((obs, wasEmpty, isEmpty) -> {
                if (isEmpty.booleanValue()) {
                    this.clearProcessDropTargetRow((TreeTableRow<Object>)row);
                }
            });
            row.treeItemProperty().addListener((obs, oldItem, newItem) -> {
                if (this.dropTargetRow == row && oldItem != newItem) {
                    this.clearProcessDropTargetRow((TreeTableRow<Object>)row);
                }
            });
            row.setOnDragDetected(event -> {
                if (row.isEmpty()) {
                    return;
                }
                TreeItem item = row.getTreeItem();
                if (item == null || item == tv.getRoot()) {
                    return;
                }
                this.draggedItem = item;
                Dragboard db = row.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                ClipboardContent content = new ClipboardContent();
                content.putString(DND_MARKER);
                db.setContent((Map)content);
                event.consume();
            });
            row.setOnDragOver(event -> {
                if (this.draggedItem == null) {
                    return;
                }
                Dragboard db = event.getDragboard();
                if (!db.hasString() || !DND_MARKER.equals(db.getString())) {
                    return;
                }
                TreeItem<Object> target = this.resolveDropTarget((TreeItem<Object>)row.getTreeItem());
                if (target != null && this.isDropAllowed(this.draggedItem, target)) {
                    this.showProcessDropTarget(target, (TreeTableRow<Object>)row);
                    event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                    event.consume();
                } else {
                    this.clearProcessDropTargetRow((TreeTableRow<Object>)row);
                }
            });
            row.setOnDragDropped(event -> {
                TreeItem<Object> target;
                if (this.draggedItem == null) {
                    return;
                }
                Dragboard db = event.getDragboard();
                boolean success = false;
                if (db.hasString() && DND_MARKER.equals(db.getString()) && (target = this.resolveDropTarget((TreeItem<Object>)row.getTreeItem())) != null && this.isDropAllowed(this.draggedItem, target)) {
                    this.handleDrop(this.draggedItem, target);
                    success = true;
                }
                event.setDropCompleted(success);
                this.draggedItem = null;
                this.clearProcessDropTargetRow((TreeTableRow<Object>)row);
                event.consume();
            });
            row.setOnDragExited(event -> this.clearProcessDropTargetRow((TreeTableRow<Object>)row));
            row.setOnDragDone(event -> {
                this.draggedItem = null;
                this.clearProcessDropTargetRow((TreeTableRow<Object>)row);
                event.consume();
            });
            row.setOnContextMenuRequested(event -> {
                if (row.isEmpty()) {
                    return;
                }
                tv.getSelectionModel().select((Object)row.getTreeItem());
                this.refreshContextMenuFor((TreeItem<Object>)row.getTreeItem(), (TreeTableView<Object>)tv, miAddOp, miAddAct, miAddPar, miDuplicate, miDel);
            });
            row.contextMenuProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
                if (row.isEmpty()) {
                    return null;
                }
                this.refreshContextMenuFor((TreeItem<Object>)row.getTreeItem(), (TreeTableView<Object>)tv, miAddOp, miAddAct, miAddPar, miDuplicate, miDel);
                return cm;
            }, (Observable[])new Observable[]{row.emptyProperty(), row.itemProperty(), row.treeItemProperty()}));
            return row;
        });
        this.ttvProcess.setOnDragOver(event -> {
            if (this.draggedItem == null) {
                return;
            }
            Dragboard db = event.getDragboard();
            if (!db.hasString() || !DND_MARKER.equals(db.getString())) {
                return;
            }
            TreeItem root = this.ttvProcess.getRoot();
            if (root != null && this.isDropAllowed(this.draggedItem, (TreeItem<Object>)root)) {
                this.showProcessDropTarget((TreeItem<Object>)root, null);
                event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            } else {
                this.clearProcessDropTargetRow();
            }
            event.consume();
        });
        this.ttvProcess.setOnDragDropped(event -> {
            TreeItem root;
            if (this.draggedItem == null) {
                return;
            }
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (db.hasString() && DND_MARKER.equals(db.getString()) && (root = this.ttvProcess.getRoot()) != null && this.isDropAllowed(this.draggedItem, (TreeItem<Object>)root)) {
                this.handleDrop(this.draggedItem, (TreeItem<Object>)root);
                success = true;
            }
            event.setDropCompleted(success);
            this.draggedItem = null;
            this.clearProcessDropTargetRow();
            event.consume();
        });
        this.ttvProcess.setOnDragDone(event -> this.clearProcessDropTargetRow());
        this.ttvProcess.setOnDragExited(event -> this.clearProcessDropTargetRow());
    }

    private TreeItem<Object> resolveDropTarget(TreeItem<Object> candidate) {
        if (candidate == null) {
            return null;
        }
        if (candidate.getValue() instanceof Parameter && candidate.getParent() != null) {
            return candidate.getParent();
        }
        return candidate;
    }

    private boolean isDropAllowed(TreeItem<Object> source, TreeItem<Object> target) {
        if (source == null || target == null || source == target) {
            return false;
        }
        if (this.isAncestor(source, target)) {
            return false;
        }
        Object targetVal = target.getValue();
        if (!(targetVal instanceof ProcessItem)) {
            return false;
        }
        ProcessItem parentPI = (ProcessItem)targetVal;
        ProcessType parentType = parentPI.getType();
        Object sourceVal = source.getValue();
        if (sourceVal instanceof ProcessItem) {
            ProcessItem childPI = (ProcessItem)sourceVal;
            ProcessType childType = childPI.getType();
            if (childType == ProcessType.OPERATION) {
                return this.isProcessContainer(parentPI);
            }
            if (childType == ProcessType.ACTIVITY) {
                return parentType == ProcessType.OPERATION;
            }
            return false;
        }
        if (sourceVal instanceof Parameter) {
            return this.isProcessContainer(parentPI) || parentType == ProcessType.OPERATION || parentType == ProcessType.ACTIVITY;
        }
        return false;
    }

    private boolean isAncestor(TreeItem<Object> ancestor, TreeItem<Object> node) {
        for (TreeItem p = node; p != null; p = p.getParent()) {
            if (p != ancestor) continue;
            return true;
        }
        return false;
    }

    private void handleDrop(TreeItem<Object> source, TreeItem<Object> target) {
        Object targetVal;
        if (source == null || target == null || source == target) {
            return;
        }
        TreeItem oldParent = source.getParent();
        Object movedVal = source.getValue();
        if (oldParent != null) {
            this.unlinkFromDomain(oldParent.getValue(), movedVal);
            oldParent.getChildren().remove(source);
            this.recomputeUpFrom((TreeItem<Object>)oldParent);
        }
        if (!((targetVal = target.getValue()) instanceof ProcessItem)) {
            return;
        }
        ProcessItem parentPI = (ProcessItem)targetVal;
        this.linkIntoDomain(parentPI, movedVal);
        this.insertChildNode(target, source);
        this.recomputeUpFrom(target);
        this.markDirty();
        this.expandTo(source);
        this.ttvProcess.getSelectionModel().select(source);
        this.updateButtonsFor(source);
        this.ttvProcess.refresh();
    }

    private void linkIntoDomain(ProcessItem parentPI, Object childVal) {
        if (childVal instanceof ProcessItem) {
            ProcessItem childPI = (ProcessItem)childVal;
            if (!parentPI.getChildren().contains((Object)childPI)) {
                parentPI.getChildren().add((Object)childPI);
            }
        } else if (childVal instanceof Parameter) {
            Parameter param = (Parameter)childVal;
            if (!parentPI.getParameters().contains((Object)param)) {
                parentPI.getParameters().add((Object)param);
            }
        }
    }

    private void insertChildNode(TreeItem<Object> parent, TreeItem<Object> child) {
        if (parent == null || child == null) {
            return;
        }
        parent.getChildren().remove(child);
        if (child.getValue() instanceof Parameter) {
            int idx = this.findParameterInsertIndex(parent);
            parent.getChildren().add(idx, child);
        } else {
            parent.getChildren().add(child);
        }
    }

    private void showProcessDropTarget(TreeItem<Object> target, TreeTableRow<Object> fallbackRow) {
        TreeTableRow<Object> row = this.findTreeTableRow(target);
        if (row == null) {
            row = fallbackRow;
        }
        if (row == null) {
            this.clearProcessDropTargetRow();
            return;
        }
        if (this.dropTargetRow != row) {
            this.clearProcessDropTargetRow();
            this.dropTargetRow = row;
        }
        this.dropTargetRow.pseudoClassStateChanged(DND_TARGET_PSEUDO, true);
    }

    private TreeTableRow<Object> findTreeTableRow(TreeItem<Object> item) {
        if (this.ttvProcess == null || item == null) {
            return null;
        }
        for (Node node : this.ttvProcess.lookupAll(".tree-table-row-cell")) {
            TreeTableRow row;
            if (!(node instanceof TreeTableRow) || (row = (TreeTableRow)node).getTreeItem() != item) continue;
            TreeTableRow typed = row;
            return typed;
        }
        return null;
    }

    private void clearProcessDropTargetRow() {
        if (this.dropTargetRow != null) {
            this.dropTargetRow.pseudoClassStateChanged(DND_TARGET_PSEUDO, false);
            this.dropTargetRow = null;
        }
    }

    private void clearProcessDropTargetRow(TreeTableRow<Object> row) {
        if (row != null && row == this.dropTargetRow) {
            this.clearProcessDropTargetRow();
        }
    }

    private int findParameterInsertIndex(TreeItem<Object> parent) {
        TreeItem ch;
        int idx = 0;
        Iterator iterator = parent.getChildren().iterator();
        while (iterator.hasNext() && (ch = (TreeItem)iterator.next()).getValue() instanceof Parameter) {
            ++idx;
        }
        return idx;
    }

    private void refreshContextMenuFor(TreeItem<Object> ti, TreeTableView<Object> tv, MenuItem miAddOp, MenuItem miAddAct, MenuItem miAddPar, MenuItem miDuplicate, MenuItem miDel) {
        if (ti == null) {
            miAddOp.setDisable(true);
            miAddAct.setDisable(true);
            miAddPar.setDisable(true);
            miDuplicate.setDisable(true);
            miDel.setDisable(true);
            return;
        }
        Object val = ti.getValue();
        ProcessItem pi = val instanceof ProcessItem ? (ProcessItem)val : null;
        ProcessType type = pi == null ? null : pi.getType();
        boolean allowOp = this.isProcessContainer(pi);
        boolean allowAct = type == ProcessType.OPERATION;
        boolean allowPar = allowOp || type == ProcessType.OPERATION || type == ProcessType.ACTIVITY;
        boolean allowDel = ti != tv.getRoot();
        boolean allowDuplicate = ti != tv.getRoot() && ti.getParent() != null && ti.getParent().getValue() instanceof ProcessItem && (val instanceof ProcessItem || val instanceof Parameter);
        miAddOp.setDisable(!allowOp);
        miAddAct.setDisable(!allowAct);
        miAddPar.setDisable(!allowPar);
        miDuplicate.setDisable(!allowDuplicate);
        miDel.setDisable(!allowDel);
    }

    private void openProcessExchangeWindow() {
        if (this.processRoot == null) {
            return;
        }
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/ProcessExchange.fxml"));
            Parent content = (Parent)loader.load();
            ProcessExchangeController controller = (ProcessExchangeController)loader.getController();
            Stage dialog = new Stage();
            dialog.setTitle("Process Exchange");
            dialog.setResizable(false);
            controller.setOwnerStage(dialog);
            controller.setSaveAction(this.saveAction);
            controller.setDestinationProcess(this.processRoot);
            List<ProcessItem> available = this.projectProcesses == null || this.projectProcesses.isEmpty() ? (this.processRoot == null ? List.of() : List.of(this.processRoot)) : this.projectProcesses;
            controller.setAvailableProcesses(available);
            controller.setChangeHook(() -> {
                this.buildAndSetTree();
                this.markDirty();
            });
            if (this.ownerStage != null) {
                dialog.initOwner((Window)this.ownerStage);
            }
            dialog.initModality(Modality.WINDOW_MODAL);
            dialog.setScene(new Scene(content));
            dialog.sizeToScene();
            dialog.show();
        }
        catch (IOException ex) {
            this.showError(ex, "Failed to open Process Exchange window");
        }
    }

    private void toast(String msg) {
        Tooltip tp = new Tooltip(msg);
        Window w = this.ttvProcess.getScene() == null ? null : this.ttvProcess.getScene().getWindow();
        tp.show(w);
        tp.hide();
    }

    private void buildAndSetTree() {
        if (this.ttvProcess == null || this.processRoot == null) {
            return;
        }
        TreeItem<Object> rootItem = this.makeProcessTree(this.processRoot);
        this.ttvProcess.setShowRoot(true);
        this.ttvProcess.setRoot(rootItem);
        rootItem.setExpanded(true);
        this.scheduleFlowchartRefresh();
    }

    private void expandProcessTree() {
        this.applyProcessExpansion(true);
    }

    private void collapseProcessTree() {
        this.applyProcessExpansion(false);
    }

    private void applyProcessExpansion(boolean expanded) {
        if (this.ttvProcess == null) {
            return;
        }
        TreeItem rootItem = this.ttvProcess.getRoot();
        if (rootItem == null) {
            return;
        }
        this.setExpandedRecursively(rootItem, expanded);
    }

    private void setExpandedRecursively(TreeItem<?> item, boolean expanded) {
        if (item == null) {
            return;
        }
        item.setExpanded(expanded);
        for (TreeItem child : item.getChildren()) {
            this.setExpandedRecursively(child, expanded);
        }
    }

    private TreeItem<Object> makeProcessTree(ProcessItem proc) {
        TreeItem procNode = new TreeItem((Object)proc);
        for (Parameter p : proc.getParameters()) {
            this.watchParameterFlags(p);
            procNode.getChildren().add((Object)new TreeItem((Object)p));
        }
        for (ProcessItem child : proc.getChildren()) {
            procNode.getChildren().add(this.makeProcessTree(child));
        }
        return procNode;
    }

    private TextFieldTreeTableCell<Object, String> makeCommitOnBlurTextCell() {
        return this.makeCommitOnBlurTextCell(false);
    }

    private TextFieldTreeTableCell<Object, String> makeCommitOnBlurTextCell(boolean showIcon) {
        DefaultStringConverter conv = new DefaultStringConverter();
        final boolean iconEnabled = showIcon;
        return new TextFieldTreeTableCell<Object, String>(this, (StringConverter)conv){
            private TextField editor;
            private ChangeListener<TreeItem<Object>> selectionListener;
            final /* synthetic */ ProcessTreeManagerController this$0;
            {
                ProcessTreeManagerController processTreeManagerController = this$0;
                Objects.requireNonNull(processTreeManagerController);
                this.this$0 = processTreeManagerController;
                super(arg0);
            }

            public void startEdit() {
                super.startEdit();
                if (!this.isEditing()) {
                    return;
                }
                this.editor = new TextField((String)this.getItem());
                this.editor.setOnAction(e -> this.commitSafely());
                this.editor.focusedProperty().addListener((o, was, isNow) -> {
                    if (!isNow.booleanValue()) {
                        this.commitSafely();
                    }
                });
                TreeTableView ttv = this.getTreeTableView();
                if (ttv != null) {
                    this.selectionListener = (o, oldTi, newTi) -> {
                        if (this.isEditing()) {
                            this.commitSafely();
                        }
                    };
                    ttv.getSelectionModel().selectedItemProperty().addListener(this.selectionListener);
                }
                this.setText(null);
                this.setGraphic((Node)this.editor);
                this.editor.requestFocus();
                this.editor.selectAll();
            }

            public void cancelEdit() {
                super.cancelEdit();
                this.cleanup();
                this.setText((String)this.getItem());
                if (iconEnabled) {
                    this.setGraphic((Node)this.this$0.iconForValue(this.getCurrentRowValue()));
                } else {
                    this.setGraphic(null);
                }
            }

            public void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                    return;
                }
                if (this.isEditing()) {
                    this.setText(null);
                    if (this.editor != null) {
                        this.editor.setText((String)this.getItem());
                    }
                    this.setGraphic((Node)this.editor);
                } else {
                    this.setText((String)this.getItem());
                    if (iconEnabled) {
                        this.setGraphic((Node)this.this$0.iconForValue(this.getCurrentRowValue()));
                    } else {
                        this.setGraphic(null);
                    }
                }
            }

            private void commitSafely() {
                try {
                    String txt = this.editor == null ? (String)this.getItem() : this.editor.getText();
                    super.commitEdit((Object)txt);
                }
                finally {
                    this.cleanup();
                }
            }

            private Object getCurrentRowValue() {
                TreeTableView ttv = this.getTreeTableView();
                if (ttv == null) {
                    return null;
                }
                int idx = this.getIndex();
                if (idx < 0) {
                    return null;
                }
                TreeItem ti = ttv.getTreeItem(idx);
                return ti == null ? null : ti.getValue();
            }

            private void cleanup() {
                TreeTableView ttv = this.getTreeTableView();
                if (ttv != null && this.selectionListener != null) {
                    ttv.getSelectionModel().selectedItemProperty().removeListener(this.selectionListener);
                }
                this.selectionListener = null;
                this.editor = null;
            }
        };
    }

    private <E> ComboBoxTreeTableCell<Object, E> enumCellForProcess(E[] values) {
        return new ComboBoxTreeTableCell<Object, E>(this, FXCollections.observableArrayList((Object[])values)){
            {
                Objects.requireNonNull(this$0);
                super(arg0);
            }

            public void startEdit() {
                Object row;
                TreeTableView ttv = this.getTreeTableView();
                int idx = this.getIndex();
                TreeItem treeItem = ttv == null || idx < 0 ? null : ttv.getTreeItem(idx);
                Object object = row = treeItem == null ? null : treeItem.getValue();
                if (!(row instanceof ProcessItem)) {
                    return;
                }
                super.startEdit();
            }

            public void cancelEdit() {
                super.cancelEdit();
                this.setGraphic(null);
            }
        };
    }

    private void watchParameterFlags(Parameter p) {
        p.attributeProperty().addListener((o, ov, nv) -> this.markDirty());
        p.criticalToSafetyProperty().addListener((o, ov, nv) -> this.markDirty());
        p.criticalToQualityProperty().addListener((o, ov, nv) -> this.markDirty());
        p.criticalToProcessProperty().addListener((o, ov, nv) -> this.markDirty());
    }

    private void loadFlowchartPage() {
        if (this.flowchartPageRequested || this.webFlowchart == null) {
            return;
        }
        this.flowchartPageRequested = true;
        WebEngine engine = this.webFlowchart.getEngine();
        URL url = this.getClass().getResource("/html/process-flowchart.html");
        if (url == null) {
            engine.loadContent("<h3>process-flowchart.html not found.</h3>");
            return;
        }
        engine.getLoadWorker().stateProperty().addListener((o, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> {
                    this.flowchartReady = true;
                    this.sendProcessFlowToPage();
                });
            }
        });
        engine.load(url.toExternalForm());
    }

    private void sendProcessFlowToPage() {
        if (this.webFlowchart == null) {
            return;
        }
        String json = this.toProcessFlowJson(this.processRoot);
        try {
            String script = "window.renderProcessFlow && window.renderProcessFlow(JSON.parse('" + ProcessTreeManagerController.escapeForJsLiteral(json) + "'));";
            this.webFlowchart.getEngine().executeScript(script);
        }
        catch (Exception ex) {
            System.err.println("[ProcessFlow] renderProcessFlow call failed: " + ex.getMessage());
        }
    }

    private void scheduleFlowchartRefresh() {
        if (!this.flowchartReady || this.webFlowchart == null) {
            return;
        }
        Platform.runLater(this::sendProcessFlowToPage);
    }

    private String toProcessFlowJson(ProcessItem root) {
        int i;
        String subject = root == null ? "Process Flow" : this.processItemName(root);
        StringBuilder sb = new StringBuilder(8192);
        sb.append("{\"subject\":\"").append(ProcessTreeManagerController.escapeJson(subject)).append("\",");
        ArrayList<ProcessItem> operations = new ArrayList<ProcessItem>();
        this.collectOperations(root, operations);
        sb.append("\"operations\":[");
        for (i = 0; i < operations.size(); ++i) {
            this.appendOperation(sb, (ProcessItem)operations.get(i));
            if (i + 1 >= operations.size()) continue;
            sb.append(',');
        }
        sb.append("],\"links\":[");
        i = 0;
        while (i + 1 < operations.size()) {
            sb.append("{\"source\":\"").append(ProcessTreeManagerController.escapeJson(this.nodeId((ProcessItem)operations.get(i)))).append("\",\"target\":\"").append(ProcessTreeManagerController.escapeJson(this.nodeId((ProcessItem)operations.get(i + 1)))).append("\"}");
            if (i + 2 < operations.size()) {
                sb.append(',');
            }
            ++i;
        }
        sb.append("]}");
        return sb.toString();
    }

    private void appendOperation(StringBuilder sb, ProcessItem item) {
        sb.append('{');
        ProcessTreeManagerController.appendQuoted(sb, "id", this.nodeId(item));
        sb.append(',');
        ProcessTreeManagerController.appendQuoted(sb, "name", this.processItemName(item));
        sb.append(',');
        ProcessTreeManagerController.appendQuotedOrNull(sb, "category", item.getCategory() == null ? null : item.getCategory().name());
        sb.append(',');
        ProcessTreeManagerController.appendQuotedOrNull(sb, "categoryLabel", item.getCategory() == null ? null : item.getCategory().getLabel());
        sb.append(',');
        ProcessTreeManagerController.appendQuotedOrNull(sb, "valueCategory", this.valueCategoryKey(item.getValueCategory()));
        sb.append(',');
        ProcessTreeManagerController.appendQuotedOrNull(sb, "function", ProcessTreeManagerController.trimToNull(item.getFunction()));
        sb.append(',');
        ProcessTreeManagerController.appendQuotedOrNull(sb, "time", this.numberString(item.getTime(), "s"));
        sb.append(',');
        ProcessTreeManagerController.appendQuotedOrNull(sb, "distance", this.numberString(item.getDistance(), "m"));
        sb.append(',');
        sb.append("\"activities\":[");
        ObservableList<ProcessItem> children = item.getChildren();
        boolean firstActivity = true;
        if (children != null) {
            for (ProcessItem child : children) {
                if (child.getType() != ProcessType.ACTIVITY) continue;
                if (!firstActivity) {
                    sb.append(',');
                }
                firstActivity = false;
                this.appendActivity(sb, child);
            }
        }
        sb.append(']');
        sb.append('}');
    }

    private void appendActivity(StringBuilder sb, ProcessItem activity) {
        sb.append('{');
        ProcessTreeManagerController.appendQuoted(sb, "name", this.processItemName(activity));
        sb.append(',');
        ProcessTreeManagerController.appendQuotedOrNull(sb, "valueCategory", this.valueCategoryKey(activity.getValueCategory()));
        sb.append('}');
    }

    private void collectOperations(ProcessItem root, List<ProcessItem> operations) {
        if (root == null) {
            return;
        }
        if (root.getType() == ProcessType.OPERATION) {
            operations.add(root);
        }
        if (root.getChildren() == null) {
            return;
        }
        for (ProcessItem child : root.getChildren()) {
            this.collectOperations(child, operations);
        }
    }

    private String numberString(double value, String unit) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return null;
        }
        double rounded = (double)Math.round(value * 100.0) / 100.0;
        String text = Math.abs(rounded - (double)((long)rounded)) < 1.0E-9 ? Long.toString((long)rounded) : Double.toString(rounded);
        return unit == null || unit.isBlank() ? text : text + " " + unit;
    }

    private String processItemName(ProcessItem item) {
        if (item == null) {
            return "Process";
        }
        String desc = ProcessTreeManagerController.trimToNull(item.getDescription());
        if (desc != null) {
            return desc;
        }
        ProcessType type = item.getType();
        return type != null ? type.name() : "Process Item";
    }

    private String valueCategoryKey(ValueCategory vc) {
        return vc == null ? "VA" : vc.name();
    }

    private String nodeId(ProcessItem item) {
        Object id;
        Object object = id = item == null ? null : ProcessTreeManagerController.trimToNull(item.getId());
        if (id == null && item != null) {
            id = "pi-" + Integer.toHexString(System.identityHashCode(item));
        }
        return id == null ? "pi-root" : id;
    }

    private static String trimToNull(String s) {
        if (s == null) {
            return null;
        }
        String trimmed = s.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    private static void appendQuoted(StringBuilder sb, String key, String value) {
        sb.append('\"').append(key).append("\":\"").append(ProcessTreeManagerController.escapeJson(value == null ? "" : value)).append('\"');
    }

    private static void appendQuotedOrNull(StringBuilder sb, String key, String value) {
        sb.append('\"').append(key).append("\":");
        if (value == null || value.isBlank()) {
            sb.append("null");
        } else {
            sb.append('\"').append(ProcessTreeManagerController.escapeJson(value)).append('\"');
        }
    }

    private static String escapeForJsLiteral(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(s.length() + 16);
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    out.append("\\\\");
                    continue block8;
                }
                case '\'': {
                    out.append("\\'");
                    continue block8;
                }
                case '\"': {
                    out.append("\\\"");
                    continue block8;
                }
                case '\n': {
                    out.append("\\n");
                    continue block8;
                }
                case '\r': {
                    out.append("\\r");
                    continue block8;
                }
                case '\t': {
                    out.append("\\t");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c == '\u2028' || c == '\u2029') {
                        out.append(String.format("\\u%04x", c));
                        continue block8;
                    }
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    private static String escapeJson(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(s.length() + 16);
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    out.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    out.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    out.append("\\b");
                    continue block9;
                }
                case '\f': {
                    out.append("\\f");
                    continue block9;
                }
                case '\n': {
                    out.append("\\n");
                    continue block9;
                }
                case '\r': {
                    out.append("\\r");
                    continue block9;
                }
                case '\t': {
                    out.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        out.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    private TreeItem<Object> getSelection() {
        return this.ttvProcess == null ? null : (TreeItem)this.ttvProcess.getSelectionModel().getSelectedItem();
    }

    private boolean isRoot(TreeItem<Object> ti) {
        return ti != null && ti == this.ttvProcess.getRoot();
    }

    private boolean isProcessItem(Object o) {
        return o instanceof ProcessItem;
    }

    private ProcessItem asPI(Object o) {
        ProcessItem pi;
        return o instanceof ProcessItem ? (pi = (ProcessItem)o) : null;
    }

    private boolean isProcessContainer(ProcessItem pi) {
        if (pi == null) {
            return false;
        }
        return pi == this.processRoot || pi.getType() == ProcessType.PROCESS;
    }

    private boolean canAddOperationUnder(Object parentVal) {
        return this.isProcessContainer(this.asPI(parentVal));
    }

    private boolean canAddActivityUnder(Object parentVal) {
        ProcessItem pi = this.asPI(parentVal);
        return pi != null && pi.getType() == ProcessType.OPERATION;
    }

    private boolean canAddParameterUnder(Object parentVal) {
        ProcessItem pi = this.asPI(parentVal);
        if (pi == null) {
            return false;
        }
        ProcessType t = pi.getType();
        return this.isProcessContainer(pi) || t == ProcessType.OPERATION || t == ProcessType.ACTIVITY;
    }

    private void expandTo(TreeItem<Object> ti) {
        for (TreeItem p = ti; p != null; p = p.getParent()) {
            p.setExpanded(true);
        }
    }

    private void refreshTreeRow(TreeItem<Object> ti) {
        this.ttvProcess.refresh();
    }

    @FXML
    private void onAddOperation() {
        ProcessItem parentPI;
        if (!this.ensureEditPermission()) {
            return;
        }
        TreeItem sel = (TreeItem)this.ttvProcess.getSelectionModel().getSelectedItem();
        if (sel == null) {
            sel = this.ttvProcess.getRoot();
        }
        if (sel == null) {
            return;
        }
        Object val = sel.getValue();
        if (!(val instanceof ProcessItem) || !this.isProcessContainer(parentPI = (ProcessItem)val)) {
            this.toast("Operation can only be added under Process.");
            return;
        }
        ProcessItem pi = new ProcessItem();
        pi.setDescription("New Operation");
        pi.setFunction("");
        pi.setType(ProcessType.OPERATION);
        pi.setIshikawa(Ishikawa.METHOD);
        pi.setCategory(ProcessCategory.OPERATION);
        pi.setValueCategory(ValueCategory.VA);
        pi.setTime(0.0);
        pi.setDistance(0.0);
        parentPI.getChildren().add((Object)pi);
        TreeItem childTI = new TreeItem((Object)pi);
        sel.getChildren().add((Object)childTI);
        this.recomputeUpFrom((TreeItem<Object>)sel);
        this.focusProcessMatch((TreeItem<Object>)childTI);
        this.markDirty();
        this.ttvProcess.refresh();
        this.updateButtonsFor((TreeItem<Object>)((TreeItem)this.ttvProcess.getSelectionModel().getSelectedItem()));
    }

    @FXML
    private void onAddActivity() {
        if (!this.ensureEditPermission()) {
            return;
        }
        TreeItem sel = (TreeItem)this.ttvProcess.getSelectionModel().getSelectedItem();
        if (sel == null) {
            sel = this.ttvProcess.getRoot();
        }
        if (sel == null) {
            return;
        }
        Object val = sel.getValue();
        if (!(val instanceof ProcessItem)) {
            this.toast("Select an Operation to add an Activity.");
            return;
        }
        ProcessItem parentPI = (ProcessItem)val;
        if (parentPI.getType() != ProcessType.OPERATION) {
            this.toast("Activity can only be added under Operation.");
            return;
        }
        ProcessItem pi = new ProcessItem();
        pi.setDescription("New Activity");
        pi.setFunction("");
        pi.setType(ProcessType.ACTIVITY);
        pi.setIshikawa(Ishikawa.METHOD);
        pi.setCategory(ProcessCategory.OPERATION);
        pi.setValueCategory(ValueCategory.VA);
        pi.setTime(0.0);
        pi.setDistance(0.0);
        parentPI.getChildren().add((Object)pi);
        TreeItem childTI = new TreeItem((Object)pi);
        sel.getChildren().add((Object)childTI);
        this.recomputeUpFrom((TreeItem<Object>)sel);
        this.focusProcessMatch((TreeItem<Object>)childTI);
        this.markDirty();
        this.ttvProcess.refresh();
        this.updateButtonsFor((TreeItem<Object>)((TreeItem)this.ttvProcess.getSelectionModel().getSelectedItem()));
    }

    @FXML
    private void onAddParameter() {
        if (!this.ensureEditPermission()) {
            return;
        }
        TreeItem sel = (TreeItem)this.ttvProcess.getSelectionModel().getSelectedItem();
        if (sel == null) {
            sel = this.ttvProcess.getRoot();
        }
        if (sel == null) {
            return;
        }
        Object val = sel.getValue();
        if (!(val instanceof ProcessItem)) {
            this.toast("Select Process/Operation/Activity to add a Parameter.");
            return;
        }
        ProcessItem parentPI = (ProcessItem)val;
        ProcessType t = parentPI.getType();
        if (!this.isProcessContainer(parentPI) && t != ProcessType.OPERATION && t != ProcessType.ACTIVITY) {
            this.toast("Parameter only under Process, Operation or Activity.");
            return;
        }
        Parameter p = new Parameter();
        p.setDescription("New Parameter");
        p.setTargetValueText("");
        p.setUpperLimitText("");
        p.setLowerLimitText("");
        p.attributeProperty().set(false);
        p.criticalToSafetyProperty().set(false);
        p.criticalToQualityProperty().set(false);
        p.criticalToProcessProperty().set(false);
        parentPI.getParameters().add((Object)p);
        TreeItem childTI = new TreeItem((Object)p);
        sel.getChildren().add((Object)childTI);
        this.focusProcessMatch((TreeItem<Object>)childTI);
        this.watchParameterFlags(p);
        this.markDirty();
        this.ttvProcess.refresh();
        this.updateButtonsFor((TreeItem<Object>)((TreeItem)this.ttvProcess.getSelectionModel().getSelectedItem()));
    }

    @FXML
    private void onDelete() {
        String name;
        if (!this.ensureEditPermission()) {
            return;
        }
        TreeItem<Object> sel = this.getSelection();
        if (sel == null || this.isRoot(sel)) {
            this.toast("Nothing to delete (root is immutable).");
            return;
        }
        Object val = sel.getValue();
        if (val instanceof ProcessItem) {
            ProcessItem pi = (ProcessItem)val;
            name = this.safe(pi.getDescription());
        } else if (val instanceof Parameter) {
            Parameter pa = (Parameter)val;
            name = this.safe(pa.getDescription());
        } else {
            name = "item";
        }
        Alert a = new Alert(Alert.AlertType.CONFIRMATION);
        a.setHeaderText("Delete selected node?");
        a.setContentText(name);
        Optional r = a.showAndWait();
        if (r.isEmpty() || r.get() != ButtonType.OK) {
            return;
        }
        TreeItem parent = sel.getParent();
        if (parent != null) {
            this.unlinkFromDomain(parent.getValue(), val);
            parent.getChildren().remove(sel);
            this.markDirty();
            this.refreshTreeRow((TreeItem<Object>)parent);
            this.ttvProcess.getSelectionModel().select((Object)parent);
        }
        this.recomputeUpFrom((TreeItem<Object>)parent);
        this.ttvProcess.refresh();
        this.updateButtonsFor((TreeItem<Object>)((TreeItem)this.ttvProcess.getSelectionModel().getSelectedItem()));
    }

    private String safe(String s) {
        return s == null ? "" : s;
    }

    private void onDuplicateProcessNode() {
        Object object;
        TreeItem sel;
        if (!this.ensureEditPermission()) {
            return;
        }
        TreeItem treeItem = sel = this.ttvProcess == null ? null : (TreeItem)this.ttvProcess.getSelectionModel().getSelectedItem();
        if (sel == null) {
            return;
        }
        TreeItem parentTi = sel.getParent();
        if (parentTi == null || !((object = parentTi.getValue()) instanceof ProcessItem)) {
            return;
        }
        ProcessItem parentPI = (ProcessItem)object;
        Object val = sel.getValue();
        TreeItem newNode = null;
        if (val instanceof ProcessItem) {
            ProcessItem pi = (ProcessItem)val;
            ProcessItem clone = this.cloneProcessItem(pi);
            int domainIdx = parentPI.getChildren().indexOf((Object)pi);
            if (domainIdx < 0) {
                domainIdx = parentPI.getChildren().size() - 1;
            }
            parentPI.getChildren().add(domainIdx + 1, (Object)clone);
            newNode = this.makeProcessTree(clone);
        } else if (val instanceof Parameter) {
            Parameter param = (Parameter)val;
            Parameter cloneParam = this.cloneParameter(param);
            int domainIdx = parentPI.getParameters().indexOf((Object)param);
            if (domainIdx < 0) {
                domainIdx = parentPI.getParameters().size() - 1;
            }
            parentPI.getParameters().add(domainIdx + 1, (Object)cloneParam);
            this.watchParameterFlags(cloneParam);
            newNode = new TreeItem((Object)cloneParam);
        } else {
            return;
        }
        if (newNode == null) {
            return;
        }
        int treeIdx = parentTi.getChildren().indexOf((Object)sel);
        if (treeIdx < 0) {
            treeIdx = parentTi.getChildren().size() - 1;
        }
        parentTi.getChildren().add(treeIdx + 1, (Object)newNode);
        parentTi.setExpanded(true);
        this.focusProcessMatch((TreeItem<Object>)newNode);
        this.updateButtonsFor((TreeItem<Object>)newNode);
        this.markDirty();
        this.scheduleFlowchartRefresh();
    }

    private void unlinkFromDomain(Object parentVal, Object childVal) {
        ProcessItem parentPI;
        block7: {
            block6: {
                if (!(parentVal instanceof ProcessItem)) break block6;
                parentPI = (ProcessItem)parentVal;
                if (childVal != null) break block7;
            }
            return;
        }
        if (childVal instanceof ProcessItem) {
            ProcessItem childPI = (ProcessItem)childVal;
            parentPI.getChildren().remove((Object)childPI);
        } else if (childVal instanceof Parameter) {
            Parameter param = (Parameter)childVal;
            parentPI.getParameters().remove((Object)param);
        }
    }

    @FXML
    private void onSaveOnly() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.performSave(false);
    }

    @FXML
    private void onSaveAndExit() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.performSave(true);
    }

    private void performSave(boolean closeAfter) {
        this.commitPendingEdits();
        try {
            this.saveCurrentTree();
            this.hasUnsavedChanges = false;
            if (closeAfter) {
                this.closeWindow();
            }
        }
        catch (Exception ex) {
            this.showError(ex, "Error while saving.");
        }
    }

    private void commitPendingEdits() {
        if (this.ttvProcess != null) {
            this.ttvProcess.edit(-1, null);
        }
    }

    private void closeWindow() {
        Stage window = null;
        if (this.ownerStage != null) {
            window = this.ownerStage;
        } else if (this.ttvProcess != null && this.ttvProcess.getScene() != null) {
            window = this.ttvProcess.getScene().getWindow();
        }
        if (window == null) {
            return;
        }
        this.programmaticClose = true;
        if (window instanceof Stage) {
            Stage stage = window;
            stage.close();
        } else {
            window.hide();
        }
    }

    private void installCloseHandler() {
        if (this.ownerStage == null) {
            return;
        }
        this.ownerStage.setOnCloseRequest(evt -> {
            if (this.programmaticClose) {
                this.programmaticClose = false;
                return;
            }
            evt.consume();
            this.promptSaveBeforeClose();
        });
    }

    private void promptSaveBeforeClose() {
        if (!this.hasUnsavedChanges) {
            this.closeWindow();
            return;
        }
        Alert confirm = new Alert(Alert.AlertType.CONFIRMATION);
        confirm.setTitle("Save changes?");
        confirm.setHeaderText("Do you want to save before closing?");
        confirm.setContentText("Select Yes to save changes to the Process Tree.");
        confirm.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        if (this.ownerStage != null) {
            confirm.initOwner((Window)this.ownerStage);
        }
        confirm.showAndWait().ifPresent(result -> {
            if (result == ButtonType.YES) {
                this.performSave(true);
            } else if (result == ButtonType.NO) {
                this.hasUnsavedChanges = false;
                this.closeWindow();
            }
        });
    }

    private void saveCurrentTree() {
        if (this.processRoot == null) {
            throw new IllegalStateException("Process Root is null.");
        }
        if (this.saveAction == null) {
            throw new IllegalStateException("Save action not set.");
        }
        this.saveAction.run();
    }

    private void showError(Throwable t, String msg) {
        Alert a = new Alert(Alert.AlertType.ERROR);
        a.setHeaderText(msg);
        a.setContentText(t == null ? msg : t.getMessage());
        a.showAndWait();
    }

    private boolean ensureEditPermission() {
        return true;
    }

    private void updateButtonsFor(TreeItem<Object> ti) {
        if (this.ttvProcess == null || this.btnAddOperation == null || this.btnAddActivity == null || this.btnAddParameter == null || this.btnDelete == null) {
            return;
        }
        Object val = ti == null ? null : ti.getValue();
        ProcessItem pi = val instanceof ProcessItem ? (ProcessItem)val : null;
        ProcessType t = pi == null ? null : pi.getType();
        boolean allowOp = this.isProcessContainer(pi);
        boolean allowAct = t == ProcessType.OPERATION;
        boolean allowPar = this.isProcessContainer(pi) || t == ProcessType.OPERATION || t == ProcessType.ACTIVITY;
        boolean allowDel = ti != null && ti != this.ttvProcess.getRoot();
        this.btnAddOperation.setDisable(!allowOp);
        this.btnAddActivity.setDisable(!allowAct);
        this.btnAddParameter.setDisable(!allowPar);
        this.btnDelete.setDisable(!allowDel);
    }

    private TextFieldTreeTableCell<Object, String> makeTextCellForParameterOnly() {
        return new TextFieldTreeTableCell<Object, String>(this, (StringConverter)new DefaultStringConverter()){
            private TextField editor;
            private ChangeListener<TreeItem<Object>> selListener;
            {
                Objects.requireNonNull(this$0);
                super(arg0);
            }

            public void startEdit() {
                boolean isParam;
                TreeTableView ttv = this.getTreeTableView();
                TreeItem ti = ttv == null ? null : ttv.getTreeItem(this.getIndex());
                boolean bl = isParam = ti != null && ti.getValue() instanceof Parameter;
                if (!isParam) {
                    return;
                }
                super.startEdit();
                if (!this.isEditing()) {
                    return;
                }
                this.editor = new TextField((String)this.getItem());
                this.editor.setOnAction(e -> this.commitSafely());
                this.editor.focusedProperty().addListener((o, was, isNow) -> {
                    if (!isNow.booleanValue()) {
                        this.commitSafely();
                    }
                });
                if (ttv != null) {
                    this.selListener = (o, oldTi, newTi) -> {
                        if (this.isEditing()) {
                            this.commitSafely();
                        }
                    };
                    ttv.getSelectionModel().selectedItemProperty().addListener(this.selListener);
                }
                this.setText(null);
                this.setGraphic((Node)this.editor);
                this.editor.requestFocus();
                this.editor.selectAll();
            }

            public void cancelEdit() {
                super.cancelEdit();
                this.cleanup();
                this.setGraphic(null);
                this.setText((String)this.getItem());
            }

            public void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                    return;
                }
                TreeTableView ttv = this.getTreeTableView();
                TreeItem ti = ttv == null ? null : ttv.getTreeItem(this.getIndex());
                boolean isParam = ti != null && ti.getValue() instanceof Parameter;
                this.setEditable(isParam);
                if (this.isEditing()) {
                    this.setText(null);
                    if (this.editor != null) {
                        this.editor.setText(item == null ? "" : item);
                    }
                } else {
                    this.setGraphic(null);
                    this.setText(item == null ? "" : item);
                }
            }

            private void commitSafely() {
                try {
                    String value = this.editor == null ? (this.getItem() == null ? "" : (String)this.getItem()) : this.editor.getText();
                    super.commitEdit((Object)(value == null ? "" : value));
                }
                finally {
                    this.cleanup();
                }
            }

            private void cleanup() {
                TreeTableView ttv = this.getTreeTableView();
                if (ttv != null && this.selListener != null) {
                    ttv.getSelectionModel().selectedItemProperty().removeListener(this.selListener);
                }
                this.selListener = null;
                this.editor = null;
            }
        };
    }

    private TreeTableCell<Object, Boolean> makeBooleanCellForParameterOnly() {
        return new CheckBoxTreeTableCell<Object, Boolean>(this){
            {
                Objects.requireNonNull(this$0);
            }

            public void startEdit() {
                TreeItem ti;
                TreeTableView ttv = this.getTreeTableView();
                TreeItem treeItem = ti = ttv == null ? null : ttv.getTreeItem(this.getIndex());
                if (ti == null || !(ti.getValue() instanceof Parameter)) {
                    return;
                }
                super.startEdit();
            }

            public void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    return;
                }
                TreeTableView ttv = this.getTreeTableView();
                TreeItem ti = ttv == null ? null : ttv.getTreeItem(this.getIndex());
                boolean isParam = ti != null && ti.getValue() instanceof Parameter;
                this.setDisable(!isParam);
                if (!isParam) {
                    this.setGraphic(null);
                }
            }
        };
    }

    private void recomputeTimeDistanceFor(TreeItem<Object> ti) {
        if (ti == null) {
            return;
        }
        Object v = ti.getValue();
        if (!(v instanceof ProcessItem)) {
            return;
        }
        ProcessItem pi = (ProcessItem)v;
        ProcessType t = pi.getType();
        if (t != ProcessType.PROCESS && t != ProcessType.OPERATION) {
            return;
        }
        double sumT = 0.0;
        double sumD = 0.0;
        for (TreeItem ch : ti.getChildren()) {
            Object cv = ch.getValue();
            if (!(cv instanceof ProcessItem)) continue;
            ProcessItem cpi = (ProcessItem)cv;
            sumT += cpi.getTime();
            sumD += cpi.getDistance();
        }
        pi.setTime(sumT);
        pi.setDistance(sumD);
    }

    private void recomputeUpFrom(TreeItem<Object> start) {
        for (TreeItem p = start; p != null; p = p.getParent()) {
            this.recomputeTimeDistanceFor(p);
        }
    }

    private TextFieldTreeTableCell<Object, Number> makeNumberCellForActivityOnly() {
        NumberStringConverter conv = new NumberStringConverter();
        return new TextFieldTreeTableCell<Object, Number>(this, (StringConverter)conv){
            private TextField editor;
            private ChangeListener<TreeItem<Object>> selListener;
            {
                Objects.requireNonNull(this$0);
                super(arg0);
            }

            public void startEdit() {
                ProcessItem pi;
                Object object;
                boolean isAct;
                TreeTableView ttv = this.getTreeTableView();
                TreeItem ti = ttv == null ? null : ttv.getTreeItem(this.getIndex());
                boolean bl = isAct = ti != null && (object = ti.getValue()) instanceof ProcessItem && (pi = (ProcessItem)object).getType() == ProcessType.ACTIVITY;
                if (!isAct) {
                    return;
                }
                super.startEdit();
                if (!this.isEditing()) {
                    return;
                }
                this.editor = new TextField(this.getItem() == null ? "" : ((Number)this.getItem()).toString());
                this.editor.setOnAction(e -> this.commitSafely());
                this.editor.focusedProperty().addListener((o, was, isNow) -> {
                    if (!isNow.booleanValue()) {
                        this.commitSafely();
                    }
                });
                if (ttv != null) {
                    this.selListener = (o, oldTi, newTi) -> {
                        if (this.isEditing()) {
                            this.commitSafely();
                        }
                    };
                    ttv.getSelectionModel().selectedItemProperty().addListener(this.selListener);
                }
                this.setText(null);
                this.setGraphic((Node)this.editor);
                this.editor.requestFocus();
                this.editor.selectAll();
            }

            public void cancelEdit() {
                super.cancelEdit();
                this.cleanup();
                this.setGraphic(null);
                this.setText(this.getItem() == null ? "" : ((Number)this.getItem()).toString());
            }

            public void updateItem(Number item, boolean empty) {
                ProcessItem pi;
                Object object;
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                    return;
                }
                TreeTableView ttv = this.getTreeTableView();
                TreeItem ti = ttv == null ? null : ttv.getTreeItem(this.getIndex());
                boolean isAct = ti != null && (object = ti.getValue()) instanceof ProcessItem && (pi = (ProcessItem)object).getType() == ProcessType.ACTIVITY;
                this.setEditable(isAct);
                if (this.isEditing()) {
                    this.setText(null);
                    if (this.editor != null) {
                        this.editor.setText(item == null ? "" : item.toString());
                    }
                } else {
                    this.setGraphic(null);
                    this.setText(item == null ? "" : item.toString());
                }
            }

            private void commitSafely() {
                try {
                    String s = this.editor == null ? (this.getItem() == null ? "" : ((Number)this.getItem()).toString()) : this.editor.getText();
                    Number n = this.parseNumber(s);
                    super.commitEdit((Object)n);
                }
                finally {
                    this.cleanup();
                }
            }

            private Number parseNumber(String s) {
                try {
                    if (s == null || s.isBlank()) {
                        return null;
                    }
                    return Double.valueOf(s.replace(',', '.'));
                }
                catch (Exception ex) {
                    return (Number)this.getItem();
                }
            }

            private void cleanup() {
                TreeTableView ttv = this.getTreeTableView();
                if (ttv != null && this.selListener != null) {
                    ttv.getSelectionModel().selectedItemProperty().removeListener(this.selListener);
                }
                this.selListener = null;
                this.editor = null;
            }
        };
    }

    private void configureSearchControls() {
        if (this.txtSearch == null || this.btnNext == null || this.ttvProcess == null) {
            return;
        }
        this.btnNext.setDisable(false);
        this.txtSearch.setOnAction(e -> this.performProcessSearch(true));
        this.btnNext.setOnAction(e -> this.goToNextProcessMatch());
        this.txtSearch.textProperty().addListener((obs, old, value) -> this.invalidateProcessSearch(value == null || value.isBlank()));
        this.ttvProcess.rootProperty().addListener((obs, oldRoot, newRoot) -> this.clearProcessSearch());
    }

    private void performProcessSearch(boolean resetIndex) {
        if (this.txtSearch == null || this.ttvProcess == null) {
            return;
        }
        String query = ProcessTreeManagerController.normalizeQuery(this.txtSearch.getText());
        if (query.isEmpty()) {
            this.clearProcessSearch();
            return;
        }
        TreeItem rootItem = this.ttvProcess.getRoot();
        if (rootItem == null) {
            this.clearProcessSearch();
            return;
        }
        TreeItem<Object> previous = !this.searchMatches.isEmpty() && this.currentSearchIndex >= 0 && this.currentSearchIndex < this.searchMatches.size() ? this.searchMatches.get(this.currentSearchIndex) : null;
        ArrayList<TreeItem<Object>> found = new ArrayList<TreeItem<Object>>();
        this.collectProcessMatches((TreeItem<Object>)rootItem, query, found);
        this.searchMatches.clear();
        this.searchMatches.addAll(found);
        this.lastSearchQuery = query;
        if (this.searchMatches.isEmpty()) {
            this.currentSearchIndex = -1;
            this.clearProcessSelection();
            return;
        }
        this.currentSearchIndex = resetIndex || previous == null || !this.searchMatches.contains(previous) ? 0 : this.searchMatches.indexOf(previous);
        this.focusProcessMatch(this.searchMatches.get(this.currentSearchIndex));
    }

    private void goToNextProcessMatch() {
        if (this.txtSearch == null || this.ttvProcess == null) {
            return;
        }
        String query = ProcessTreeManagerController.normalizeQuery(this.txtSearch.getText());
        if (query.isEmpty()) {
            this.clearProcessSearch();
            return;
        }
        if (!query.equals(this.lastSearchQuery) || this.searchMatches.isEmpty()) {
            this.performProcessSearch(this.searchMatches.isEmpty());
            if (this.searchMatches.isEmpty()) {
                return;
            }
        }
        this.currentSearchIndex = (this.currentSearchIndex + 1) % this.searchMatches.size();
        this.focusProcessMatch(this.searchMatches.get(this.currentSearchIndex));
    }

    private void clearProcessSearch() {
        this.invalidateProcessSearch(true);
    }

    private void collectProcessMatches(TreeItem<Object> node, String query, List<TreeItem<Object>> out) {
        if (node == null) {
            return;
        }
        String text = ProcessTreeManagerController.normalizeQuery(this.processSearchText(node.getValue()));
        if (!text.isEmpty() && text.contains(query)) {
            out.add(node);
        }
        for (TreeItem child : node.getChildren()) {
            this.collectProcessMatches((TreeItem<Object>)child, query, out);
        }
    }

    private void focusProcessMatch(TreeItem<Object> item) {
        if (this.ttvProcess == null || item == null) {
            return;
        }
        this.expandPath(item);
        this.ttvProcess.getSelectionModel().select(item);
        this.ttvProcess.requestFocus();
        int row = this.ttvProcess.getRow(item);
        if (row >= 0) {
            if (this.ttvProcess.getFocusModel() != null) {
                this.ttvProcess.getFocusModel().focus(row);
            }
            this.centerTreeTableRow(row);
        }
    }

    private void expandPath(TreeItem<?> item) {
        for (TreeItem current = item; current != null; current = current.getParent()) {
            current.setExpanded(true);
        }
    }

    private void centerTreeTableRow(int rowIndex) {
        int visible = this.approximateVisibleRowCount(this.ttvProcess);
        int target = Math.max(0, rowIndex - visible / 2);
        this.ttvProcess.scrollTo(target);
        Platform.runLater(() -> {
            int adjusted = Math.max(0, rowIndex - visible / 2);
            this.ttvProcess.scrollTo(adjusted);
            this.ttvProcess.scrollTo(rowIndex);
        });
    }

    private int approximateVisibleRowCount(TreeTableView<?> view) {
        if (view == null) {
            return 10;
        }
        double height = view.getHeight();
        double rowHeight = view.getFixedCellSize();
        if (rowHeight <= 0.0) {
            rowHeight = 24.0;
        }
        if (height <= 0.0) {
            return 10;
        }
        return Math.max(1, (int)Math.round(height / rowHeight));
    }

    private String processSearchText(Object value) {
        if (value instanceof ProcessItem) {
            ProcessItem pi = (ProcessItem)value;
            StringBuilder sb = new StringBuilder();
            this.appendIfNotBlank(sb, ProcessTreeManagerController.trimToNull(pi.getDescription()));
            this.appendIfNotBlank(sb, ProcessTreeManagerController.trimToNull(pi.getFunction()));
            if (pi.getType() != null) {
                this.appendIfNotBlank(sb, pi.getType().name());
            }
            if (pi.getCategory() != null) {
                this.appendIfNotBlank(sb, pi.getCategory().name());
            }
            if (pi.getValueCategory() != null) {
                this.appendIfNotBlank(sb, pi.getValueCategory().name());
            }
            return sb.toString();
        }
        if (value instanceof Parameter) {
            Parameter parameter = (Parameter)value;
            StringBuilder sb = new StringBuilder();
            this.appendIfNotBlank(sb, ProcessTreeManagerController.trimToNull(parameter.getDescription()));
            if (parameter.isAttribute()) {
                this.appendIfNotBlank(sb, "attribute");
            }
            return sb.toString();
        }
        return value == null ? "" : value.toString();
    }

    private void appendIfNotBlank(StringBuilder sb, String text) {
        if (text == null || text.isBlank()) {
            return;
        }
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(text);
    }

    private static String normalizeQuery(String value) {
        if (value == null) {
            return "";
        }
        return value.strip().toLowerCase(Locale.ROOT);
    }

    private void invalidateProcessSearch(boolean clearSelection) {
        boolean hadMatches = !this.searchMatches.isEmpty();
        this.searchMatches.clear();
        this.currentSearchIndex = -1;
        this.lastSearchQuery = "";
        if (clearSelection || hadMatches) {
            this.clearProcessSelection();
        }
    }

    private void clearProcessSelection() {
        if (this.ttvProcess == null) {
            return;
        }
        this.ttvProcess.getSelectionModel().clearSelection();
        if (this.ttvProcess.getFocusModel() != null) {
            this.ttvProcess.getFocusModel().focus(-1);
        }
    }

    private ProcessItem cloneProcessItem(ProcessItem original) {
        if (original == null) {
            return null;
        }
        ProcessItem copy = new ProcessItem();
        copy.setDescription(original.getDescription());
        copy.setFunction(original.getFunction());
        copy.setType(original.getType());
        copy.setIshikawa(original.getIshikawa());
        copy.setTime(original.getTime());
        copy.setDistance(original.getDistance());
        copy.setCategory(original.getCategory());
        copy.setValueCategory(original.getValueCategory());
        for (Parameter param : original.getParameters()) {
            Parameter paramClone = this.cloneParameter(param);
            if (paramClone == null) continue;
            copy.addParameter(paramClone);
        }
        for (ProcessItem child : original.getChildren()) {
            ProcessItem childClone = this.cloneProcessItem(child);
            if (childClone == null) continue;
            copy.addChild(childClone);
        }
        return copy;
    }

    private Parameter cloneParameter(Parameter original) {
        if (original == null) {
            return null;
        }
        Parameter copy = new Parameter();
        copy.setDescription(original.getDescription());
        copy.setTargetValueText(original.getTargetValueText());
        copy.setLowerLimitText(original.getLowerLimitText());
        copy.setUpperLimitText(original.getUpperLimitText());
        copy.setAttribute(original.isAttribute());
        copy.setCriticalToSafety(original.isCriticalToSafety());
        copy.setCriticalToQuality(original.isCriticalToQuality());
        copy.setCriticalToProcess(original.isCriticalToProcess());
        return copy;
    }

    private void updatePath(TreeItem<Object> ti) {
        if (this.lblPath == null) {
            return;
        }
        if (ti == null) {
            this.lblPath.setText("");
            return;
        }
        this.lblPath.setText(this.buildPathString(ti));
    }

    private String buildPathString(TreeItem<Object> ti) {
        LinkedList<String> parts = new LinkedList<String>();
        for (TreeItem p = ti; p != null; p = p.getParent()) {
            Parameter pa;
            ProcessItem pi;
            Object v = p.getValue();
            String name = v instanceof ProcessItem ? ((pi = (ProcessItem)v).getDescription() == null || pi.getDescription().isBlank() ? "Process" : pi.getDescription()) : (v instanceof Parameter ? ((pa = (Parameter)v).getDescription() == null || pa.getDescription().isBlank() ? "Parameter" : pa.getDescription()) : (v == null ? "" : v.toString()));
            parts.addFirst(name);
        }
        return String.join((CharSequence)" / ", parts);
    }
}

