/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.controllers.StructureExchangeController;
import com.qualidadeeprodutividade.controllers.util.DragDropStyler;
import com.qualidadeeprodutividade.item.Characteristic;
import com.qualidadeeprodutividade.item.Item;
import com.qualidadeeprodutividade.item.ItemType;
import com.qualidadeeprodutividade.item.ProductRequirement;
import com.qualidadeeprodutividade.item.StructureCloner;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.control.cell.TextFieldTreeCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Text;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;

public class ProductTreeManagerController {
    @FXML
    private BorderPane root;
    @FXML
    private ImageView imgHeaderIcon;
    @FXML
    private TreeView<Object> tree;
    @FXML
    private Button btnAddSystem;
    @FXML
    private Button btnAddPart;
    @FXML
    private Button btnAddChar;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnSaveOnly;
    @FXML
    private Button btnSaveExit;
    @FXML
    private Button btnStructExchange;
    @FXML
    private TextField txtSearch;
    @FXML
    private Button btnNext;
    @FXML
    private Button btnCollapseAll;
    @FXML
    private Button btnExpandAll;
    @FXML
    private Label lblPath;
    @FXML
    private TableView<PropertyRow> tblDetails;
    @FXML
    private TableColumn<PropertyRow, String> colProp;
    @FXML
    private TableColumn<PropertyRow, String> colValue;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab tabTreeEditor;
    @FXML
    private Tab tabTreeViewer;
    @FXML
    private WebView webTreeViewer;
    @FXML
    private Tab tabRequirement;
    @FXML
    private TableView<ProductRequirement> tblRequirements;
    @FXML
    private TableColumn<ProductRequirement, String> colRequirementDescription;
    @FXML
    private TableColumn<ProductRequirement, String> colRequirementSpecification;
    @FXML
    private TableColumn<ProductRequirement, String> colRequirementTolerance;
    @FXML
    private TableColumn<ProductRequirement, Integer> colRequirementCustomerImportance;
    @FXML
    private TableColumn<ProductRequirement, Double> colRequirementPercent;
    @FXML
    private Button btnRequirementAdd;
    @FXML
    private Button btnRequirementRemove;
    @FXML
    private Button btnRequirementDuplicate;
    private Runnable saveAction;
    private Runnable dirtyHook = () -> {};
    private Stage owner;
    private Item productRoot;
    private List<Item> projectProducts = List.of();
    private ContextMenu currentMenu;
    private boolean treeViewerPageRequested = false;
    private boolean treeViewerReady = false;
    private final List<TreeItem<Object>> searchMatches = new ArrayList<TreeItem<Object>>();
    private int currentSearchIndex = -1;
    private String lastSearchQuery = "";
    private static final String PRODUCT_DND_MARKER = "PRODUCT_TREE_NODE";
    private boolean requirementsTabActive = false;
    private Item requirementOwner;
    private ObservableList<ProductRequirement> activeRequirementList;
    private final ObservableList<ProductRequirement> emptyRequirements = FXCollections.observableArrayList();
    private final ListChangeListener<ProductRequirement> requirementListListener = change -> this.recalcRequirementPercentages();
    private static final PseudoClass DND_TARGET_PSEUDO = PseudoClass.getPseudoClass((String)"drag-target");
    private TreeItem<Object> draggedItem;
    private TreeCell<Object> dropTargetCell;
    private boolean hasUnsavedChanges = false;
    private boolean programmaticClose = false;
    private Image icMainProduct;
    private Image icSystem;
    private Image icPart;
    private Image icChar;

    public void setSaveAction(Runnable r) {
        this.saveAction = r;
    }

    public void setDirtyHook(Runnable r) {
        Runnable delegate = r == null ? () -> {} : r;
        this.dirtyHook = () -> {
            this.hasUnsavedChanges = true;
            delegate.run();
        };
    }

    public void setOwnerStage(Stage owner) {
        this.owner = owner;
        this.installCloseHandler();
    }

    private Image loadIcon(String name) {
        InputStream is = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        if (is == null) {
            is = this.getClass().getResourceAsStream("/icons/" + name + ".jpg");
        }
        return is == null ? null : new Image(is, 24.0, 24.0, true, true);
    }

    private void configureHeaderIcon() {
        if (this.imgHeaderIcon == null) {
            return;
        }
        URL iconUrl = this.getClass().getResource("/icons/product.png");
        if (iconUrl == null) {
            System.err.println("Icon resource not found: /icons/product.png");
            return;
        }
        this.imgHeaderIcon.setImage(new Image(iconUrl.toExternalForm()));
    }

    private ImageView iv(Image img) {
        return img == null ? null : new ImageView(img);
    }

    private ImageView iv(Image img, double size) {
        if (img == null) {
            return null;
        }
        ImageView view = new ImageView(img);
        view.setPreserveRatio(true);
        view.setFitWidth(size);
        view.setFitHeight(size);
        view.setSmooth(true);
        return view;
    }

    public void setProductRoot(Item productRoot) {
        this.productRoot = productRoot;
        this.bindRequirementsTo(productRoot);
        this.rebuildTree();
        this.scheduleTreeViewerRefresh();
        this.hasUnsavedChanges = false;
    }

    public void setProjectProducts(List<Item> products) {
        this.projectProducts = products == null ? List.of() : List.copyOf(products);
    }

    private void markDirty() {
        this.hasUnsavedChanges = true;
        if (this.dirtyHook != null) {
            this.dirtyHook.run();
        }
        this.scheduleTreeViewerRefresh();
    }

    private void loadTreeViewerPage() {
        if (this.treeViewerPageRequested || this.webTreeViewer == null) {
            return;
        }
        this.treeViewerPageRequested = true;
        WebEngine engine = this.webTreeViewer.getEngine();
        URL url = this.getClass().getResource("/html/product-tree.html");
        if (url == null) {
            engine.loadContent("<h3>product-tree.html not found.</h3>");
            return;
        }
        engine.getLoadWorker().stateProperty().addListener((obs, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> {
                    this.treeViewerReady = true;
                    this.sendProductTreeToPage();
                });
            }
        });
        engine.load(url.toExternalForm());
    }

    private void sendProductTreeToPage() {
        if (this.webTreeViewer == null) {
            return;
        }
        String json = this.toProductTreeJson(this.productRoot);
        try {
            this.webTreeViewer.getEngine().executeScript("window.renderProductTree && window.renderProductTree(" + json + ");");
        }
        catch (Exception ex) {
            System.err.println("[ProductTree] renderProductTree call failed: " + ex.getMessage());
        }
    }

    private void scheduleTreeViewerRefresh() {
        if (this.treeViewerReady && this.webTreeViewer != null) {
            Platform.runLater(this::sendProductTreeToPage);
        }
    }

    private String toProductTreeJson(Item root) {
        String subject = root == null ? "No product selected" : this.itemDisplayName(root);
        StringBuilder sb = new StringBuilder(4096);
        sb.append("{\"subject\":\"").append(ProductTreeManagerController.escapeJson(subject)).append("\",\"tree\":");
        if (root == null) {
            sb.append("null");
        } else {
            this.appendItemNode(sb, root);
        }
        sb.append('}');
        return sb.toString();
    }

    private void appendItemNode(StringBuilder sb, Item item) {
        sb.append('{');
        this.appendQuoted(sb, "id", item.getId());
        sb.append(',');
        this.appendQuoted(sb, "kind", "ITEM");
        sb.append(',');
        this.appendQuoted(sb, "itemType", this.itemTypeForJson(item));
        sb.append(',');
        this.appendQuoted(sb, "name", this.itemDisplayName(item));
        sb.append(',');
        this.appendQuotedOrNull(sb, "subtitle", this.itemSubtitle(item));
        sb.append(',');
        this.appendQuoted(sb, "tooltip", this.itemTooltip(item));
        sb.append(',');
        this.appendQuotedOrNull(sb, "partNumber", ProductTreeManagerController.trimToNull(item.getPartNumber()));
        sb.append(',');
        this.appendQuotedOrNull(sb, "function", ProductTreeManagerController.trimToNull(item.getFunction()));
        sb.append(",\"children\":[");
        boolean first = true;
        if (item.getChildren() != null) {
            for (Item child : item.getChildren()) {
                if (!first) {
                    sb.append(',');
                }
                this.appendItemNode(sb, child);
                first = false;
            }
        }
        if (item.getCharacteristics() != null) {
            for (Characteristic ch : item.getCharacteristics()) {
                if (!first) {
                    sb.append(',');
                }
                this.appendCharacteristicNode(sb, ch);
                first = false;
            }
        }
        sb.append("]}");
    }

    private void appendCharacteristicNode(StringBuilder sb, Characteristic ch) {
        sb.append('{');
        this.appendQuoted(sb, "id", ch.getId());
        sb.append(',');
        this.appendQuoted(sb, "kind", "CHARACTERISTIC");
        sb.append(',');
        this.appendQuoted(sb, "name", this.characteristicName(ch));
        sb.append(',');
        this.appendQuotedOrNull(sb, "subtitle", this.characteristicSubtitle(ch));
        sb.append(',');
        this.appendQuoted(sb, "tooltip", this.characteristicTooltip(ch));
        sb.append(',');
        this.appendQuotedOrNull(sb, "targetValueText", ProductTreeManagerController.trimToNull(ch.getTargetValueText()));
        sb.append(',');
        this.appendQuotedOrNull(sb, "lowerLimitText", ProductTreeManagerController.trimToNull(ch.getLowerLimitText()));
        sb.append(',');
        this.appendQuotedOrNull(sb, "upperLimitText", ProductTreeManagerController.trimToNull(ch.getUpperLimitText()));
        sb.append(',');
        this.appendQuotedOrNull(sb, "cpkText", ProductTreeManagerController.trimToNull(ch.getCpkText()));
        sb.append(',');
        sb.append("\"attribute\":").append(ch.isAttribute());
        sb.append(',');
        sb.append("\"criticalToSafety\":").append(ch.isCriticalToSafety());
        sb.append(',');
        sb.append("\"criticalToQuality\":").append(ch.isCriticalToQuality());
        sb.append(',');
        sb.append("\"criticalToProcess\":").append(ch.isCriticalToProcess());
        sb.append(',');
        String target = ProductTreeManagerController.formatDouble(ch.getTargetValue());
        sb.append("\"targetValue\":").append(target == null ? "null" : target);
        sb.append(',');
        String lower = ProductTreeManagerController.formatDouble(ch.getLowerLimit());
        sb.append("\"lowerLimit\":").append(lower == null ? "null" : lower);
        sb.append(',');
        String upper = ProductTreeManagerController.formatDouble(ch.getUpperLimit());
        sb.append("\"upperLimit\":").append(upper == null ? "null" : upper);
        sb.append(',');
        String cpkVal = ProductTreeManagerController.formatDouble(ch.getCpk());
        sb.append("\"cpk\":").append(cpkVal == null ? "null" : cpkVal);
        sb.append(",\"children\":[]}");
    }

    private void appendQuoted(StringBuilder sb, String key, String value) {
        sb.append('\"').append(key).append("\":\"").append(ProductTreeManagerController.escapeJson(value == null ? "" : value)).append('\"');
    }

    private void appendQuotedOrNull(StringBuilder sb, String key, String value) {
        sb.append('\"').append(key).append("\":");
        if (value == null || value.isBlank()) {
            sb.append("null");
        } else {
            sb.append('\"').append(ProductTreeManagerController.escapeJson(value)).append('\"');
        }
    }

    private String itemTypeForJson(Item item) {
        ItemType type = item.getType();
        if ((type == null || type == ItemType.PRODUCT) && item == this.productRoot) {
            return "PRODUCT";
        }
        return type == null ? "ITEM" : type.name();
    }

    private String itemDisplayName(Item item) {
        if (item == null) {
            return "(item)";
        }
        String desc = ProductTreeManagerController.trimToNull(item.getDescription());
        if (desc != null) {
            return desc;
        }
        String fallback = this.formatItemType(item.getType());
        if (fallback == null || fallback.isBlank()) {
            fallback = item == this.productRoot ? "Product" : "Item";
        }
        return fallback;
    }

    private String itemSubtitle(Item item) {
        return null;
    }

    private String itemTooltip(Item item) {
        String function;
        if (item == null) {
            return "";
        }
        StringBuilder tip = new StringBuilder();
        String typeLabel = this.formatItemType(item.getType());
        if (typeLabel == null || typeLabel.isBlank()) {
            typeLabel = item == this.productRoot ? "Product" : "Item";
        }
        tip.append("Type: ").append(typeLabel);
        String pn = ProductTreeManagerController.trimToNull(item.getPartNumber());
        if (pn != null) {
            tip.append("\nPart number: ").append(pn);
        }
        if ((function = ProductTreeManagerController.trimToNull(item.getFunction())) != null) {
            tip.append("\nFunction: ").append(function);
        }
        int childItems = item.getChildren() == null ? 0 : item.getChildren().size();
        int charCount = item.getCharacteristics() == null ? 0 : item.getCharacteristics().size();
        tip.append("\nItems: ").append(childItems).append(" | Characteristics: ").append(charCount);
        return tip.toString();
    }

    private String characteristicName(Characteristic ch) {
        if (ch == null) {
            return "(characteristic)";
        }
        String desc = ProductTreeManagerController.trimToNull(ch.getDescription());
        return desc == null ? "(characteristic)" : desc;
    }

    private String characteristicSubtitle(Characteristic ch) {
        return null;
    }

    private String characteristicTooltip(Characteristic ch) {
        String cpk;
        String upper;
        String lower;
        if (ch == null) {
            return "";
        }
        StringBuilder tip = new StringBuilder();
        tip.append("Characteristic: ").append(this.characteristicName(ch));
        String target = ProductTreeManagerController.trimToNull(ch.getTargetValueText());
        if (target == null) {
            target = ProductTreeManagerController.formatDouble(ch.getTargetValue());
        }
        if (target != null) {
            tip.append("\nTarget: ").append(target);
        }
        if ((lower = ProductTreeManagerController.trimToNull(ch.getLowerLimitText())) == null) {
            lower = ProductTreeManagerController.formatDouble(ch.getLowerLimit());
        }
        if ((upper = ProductTreeManagerController.trimToNull(ch.getUpperLimitText())) == null) {
            upper = ProductTreeManagerController.formatDouble(ch.getUpperLimit());
        }
        if (lower != null || upper != null) {
            tip.append("\nLimits: [").append(lower == null ? "?" : lower).append(" .. ").append(upper == null ? "?" : upper).append(']');
        }
        if ((cpk = ProductTreeManagerController.trimToNull(ch.getCpkText())) == null) {
            cpk = ProductTreeManagerController.formatDouble(ch.getCpk());
        }
        if (cpk != null) {
            tip.append("\nCpk: ").append(cpk);
        }
        ArrayList<String> flags = new ArrayList<String>();
        if (ch.isAttribute()) {
            flags.add("Attribute");
        }
        if (ch.isCriticalToSafety()) {
            flags.add("Critical to Safety");
        }
        if (ch.isCriticalToQuality()) {
            flags.add("Critical to Quality");
        }
        if (ch.isCriticalToProcess()) {
            flags.add("Critical to Process");
        }
        if (!flags.isEmpty()) {
            tip.append("\nFlags: ").append(String.join((CharSequence)", ", flags));
        }
        return tip.toString();
    }

    private static String trimToNull(String s) {
        if (s == null) {
            return null;
        }
        String trimmed = s.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    private static String formatDouble(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return null;
        }
        String text = Double.toString(value);
        if (text.indexOf(69) >= 0 || text.indexOf(101) >= 0) {
            return text;
        }
        if (text.indexOf(46) >= 0) {
            while (text.endsWith("0")) {
                text = text.substring(0, text.length() - 1);
            }
            if (text.endsWith(".")) {
                text = text.substring(0, text.length() - 1);
            }
        }
        return text;
    }

    private static String escapeJson(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(s.length() + 16);
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    out.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    out.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    out.append("\\b");
                    continue block9;
                }
                case '\f': {
                    out.append("\\f");
                    continue block9;
                }
                case '\n': {
                    out.append("\\n");
                    continue block9;
                }
                case '\r': {
                    out.append("\\r");
                    continue block9;
                }
                case '\t': {
                    out.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        out.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    @FXML
    private void initialize() {
        this.configureHeaderIcon();
        this.configureSearchControls();
        this.configureRequirementTab();
        this.btnAddSystem.setTooltip(new Tooltip("Add a System under Product or System"));
        this.btnAddPart.setTooltip(new Tooltip("Add a Part under Product or System"));
        this.btnAddChar.setTooltip(new Tooltip("Add a Characteristic under Product, System or Part"));
        this.btnDelete.setTooltip(new Tooltip("Remove selected node"));
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setTooltip(new Tooltip("Save changes without closing"));
            this.btnSaveOnly.setOnAction(e -> this.onSaveOnly());
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setTooltip(new Tooltip("Save and close the current product"));
            this.btnSaveExit.setOnAction(e -> this.onSaveAndExit());
        }
        if (this.btnStructExchange != null) {
            this.btnStructExchange.setTooltip(new Tooltip("Open Structure Exchange"));
            this.btnStructExchange.setOnAction(e -> this.openStructureExchangeWindow());
        }
        if (this.btnCollapseAll != null) {
            this.btnCollapseAll.setTooltip(new Tooltip("Collapse the entire tree"));
            this.btnCollapseAll.setOnAction(e -> this.collapseEntireTree());
        }
        if (this.btnExpandAll != null) {
            this.btnExpandAll.setTooltip(new Tooltip("Expand the entire tree"));
            this.btnExpandAll.setOnAction(e -> this.expandEntireTree());
        }
        this.icMainProduct = this.loadIcon("mainProduct");
        this.icSystem = this.loadIcon("system");
        this.icPart = this.loadIcon("part");
        this.icChar = this.loadIcon("characteristic");
        Image icDelete = this.loadIcon("trash");
        Image icSave = this.loadIcon("save");
        Image icSaveExit = this.loadIcon("exit");
        Image icExchange = this.loadIcon("import");
        Image icExpand = this.loadIcon("plus");
        Image icCollapse = this.loadIcon("minus");
        Image icReqAdd = this.loadIcon("plus");
        Image icReqDelete = icDelete;
        Image icReqCopy = this.loadIcon("copy");
        Image icSearch = this.loadIcon("search");
        if (this.btnAddSystem != null) {
            this.btnAddSystem.setGraphic((Node)this.iv(this.icSystem, 24.0));
        }
        if (this.btnAddPart != null) {
            this.btnAddPart.setGraphic((Node)this.iv(this.icPart, 24.0));
        }
        if (this.btnAddChar != null) {
            this.btnAddChar.setGraphic((Node)this.iv(this.icChar, 24.0));
        }
        if (this.btnDelete != null) {
            this.btnDelete.setGraphic((Node)this.iv(icDelete, 20.0));
        }
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setGraphic((Node)this.iv(icSave, 20.0));
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setGraphic((Node)this.iv(icSaveExit, 20.0));
        }
        if (this.btnStructExchange != null) {
            this.btnStructExchange.setGraphic((Node)this.iv(icExchange, 16.0));
        }
        if (this.btnExpandAll != null) {
            this.btnExpandAll.setGraphic((Node)this.iv(icExpand, 16.0));
        }
        if (this.btnCollapseAll != null) {
            this.btnCollapseAll.setGraphic((Node)this.iv(icCollapse, 16.0));
        }
        if (this.btnNext != null) {
            this.btnNext.setText(null);
            this.btnNext.setGraphic((Node)this.iv(icSearch, 16.0));
        }
        if (this.btnRequirementAdd != null) {
            this.btnRequirementAdd.setText(null);
            this.btnRequirementAdd.setGraphic((Node)this.iv(icReqAdd, 16.0));
        }
        if (this.btnRequirementRemove != null) {
            this.btnRequirementRemove.setText(null);
            this.btnRequirementRemove.setGraphic((Node)this.iv(icReqDelete, 16.0));
        }
        if (this.btnRequirementDuplicate != null) {
            this.btnRequirementDuplicate.setText(null);
            this.btnRequirementDuplicate.setGraphic((Node)this.iv(icReqCopy, 16.0));
        }
        this.tree.setEditable(false);
        this.tblDetails.setEditable(true);
        this.tblDetails.setFixedCellSize(-1.0);
        DragDropStyler.ensure(this.tree);
        this.tree.setCellFactory(tv -> {
            TextFieldTreeCell<Object> cell = new TextFieldTreeCell<Object>(this, (StringConverter)new StringConverter<Object>(this){
                final /* synthetic */ ProductTreeManagerController this$0;
                {
                    ProductTreeManagerController productTreeManagerController = this$0;
                    Objects.requireNonNull(productTreeManagerController);
                    this.this$0 = productTreeManagerController;
                }

                public String toString(Object v) {
                    if (v == null) {
                        return "";
                    }
                    if (v instanceof Item) {
                        Item it = (Item)v;
                        return this.this$0.safe(it.getDescription());
                    }
                    if (v instanceof Characteristic) {
                        Characteristic ch = (Characteristic)v;
                        return this.this$0.safe(ch.getDescription());
                    }
                    if (v instanceof String) {
                        String s = (String)v;
                        return s;
                    }
                    return String.valueOf(v);
                }

                public Object fromString(String s) {
                    return s;
                }
            }){
                final /* synthetic */ ProductTreeManagerController this$0;
                {
                    ProductTreeManagerController productTreeManagerController = this$0;
                    Objects.requireNonNull(productTreeManagerController);
                    this.this$0 = productTreeManagerController;
                    super(arg0);
                }

                public void updateItem(Object val, boolean empty) {
                    super.updateItem(val, empty);
                    if (empty || val == null) {
                        this.this$0.clearDropTargetHighlight((TreeCell<Object>)this);
                        this.setText(null);
                        this.setGraphic(null);
                        return;
                    }
                    if (val instanceof Item) {
                        Item it = (Item)val;
                        this.setText(this.this$0.safe(it.getDescription()));
                        if (it == this.this$0.productRoot) {
                            this.setGraphic((Node)this.this$0.iv(this.this$0.icMainProduct));
                        } else {
                            ItemType t = it.getType() == null ? ItemType.PART : it.getType();
                            switch (t) {
                                case SYSTEM: {
                                    this.setGraphic((Node)this.this$0.iv(this.this$0.icSystem));
                                    break;
                                }
                                case PART: {
                                    this.setGraphic((Node)this.this$0.iv(this.this$0.icPart));
                                    break;
                                }
                                case PRODUCT: {
                                    this.setGraphic((Node)this.this$0.iv(this.this$0.icMainProduct));
                                }
                            }
                        }
                    } else if (val instanceof Characteristic) {
                        Characteristic ch = (Characteristic)val;
                        this.setText(this.this$0.safe(ch.getDescription()));
                        this.setGraphic((Node)this.this$0.iv(this.this$0.icChar));
                    } else if (val instanceof String) {
                        String s = (String)val;
                        this.setText(s);
                        this.setGraphic(null);
                    } else {
                        this.setText(String.valueOf(val));
                        this.setGraphic(null);
                    }
                }

                public void commitEdit(Object newValue) {
                    String text;
                    Object val = this.getItem();
                    super.commitEdit(newValue);
                    String string = text = newValue == null ? "" : newValue.toString();
                    if (val instanceof Item) {
                        Item it = (Item)val;
                        it.setDescription(text);
                        this.this$0.markDirty();
                    } else if (val instanceof Characteristic) {
                        Characteristic ch = (Characteristic)val;
                        ch.setDescription(text);
                        this.this$0.markDirty();
                    }
                    this.this$0.tree.refresh();
                    this.this$0.rebuildDetailsForSelection();
                }
            };
            cell.setOnDragDetected(arg_0 -> this.lambda$initialize$6((TextFieldTreeCell)cell, arg_0));
            cell.setOnDragOver(arg_0 -> this.lambda$initialize$7((TextFieldTreeCell)cell, arg_0));
            cell.setOnDragDropped(arg_0 -> this.lambda$initialize$8((TextFieldTreeCell)cell, arg_0));
            cell.setOnDragExited(arg_0 -> this.lambda$initialize$9((TextFieldTreeCell)cell, arg_0));
            cell.setOnDragDone(arg_0 -> this.lambda$initialize$10((TextFieldTreeCell)cell, arg_0));
            return cell;
        });
        this.tree.getSelectionModel().selectedItemProperty().addListener((o, oldTi, newTi) -> {
            this.updateButtons();
            this.updatePathLabel();
            this.rebuildDetails((TreeItem<Object>)newTi);
        });
        this.btnAddSystem.setOnAction(e -> this.onAddSystem());
        this.btnAddPart.setOnAction(e -> this.onAddPart());
        this.btnAddChar.setOnAction(e -> this.onAddCharacteristic());
        this.btnDelete.setOnAction(e -> this.onDeleteSelected());
        this.tree.setOnContextMenuRequested(this::showContextMenu);
        this.tree.setOnDragOver(event -> {
            if (this.draggedItem == null) {
                return;
            }
            Dragboard db = event.getDragboard();
            if (!db.hasString() || !PRODUCT_DND_MARKER.equals(db.getString())) {
                return;
            }
            TreeItem rootItem = this.tree.getRoot();
            if (rootItem != null && this.isDropAllowed(this.draggedItem, (TreeItem<Object>)rootItem)) {
                this.showDropTarget((TreeItem<Object>)rootItem, null);
                event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            } else {
                this.clearDropTargetHighlight();
            }
            event.consume();
        });
        this.tree.setOnDragDropped(event -> {
            TreeItem rootItem;
            if (this.draggedItem == null) {
                return;
            }
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (db.hasString() && PRODUCT_DND_MARKER.equals(db.getString()) && (rootItem = this.tree.getRoot()) != null && this.isDropAllowed(this.draggedItem, (TreeItem<Object>)rootItem)) {
                this.handleDrop(this.draggedItem, (TreeItem<Object>)rootItem);
                success = true;
            }
            event.setDropCompleted(success);
            this.draggedItem = null;
            this.clearDropTargetHighlight();
            event.consume();
        });
        this.tree.setOnDragDone(event -> this.clearDropTargetHighlight());
        this.tree.setOnDragExited(event -> this.clearDropTargetHighlight());
        this.colProp.setCellValueFactory(cd -> ((PropertyRow)cd.getValue()).labelProperty());
        this.colValue.setCellValueFactory(cd -> ((PropertyRow)cd.getValue()).valueProperty());
        this.colProp.setEditable(false);
        this.colProp.setReorderable(false);
        this.colProp.setSortable(false);
        this.colValue.setCellFactory(col -> new PropertyValueCell(this, (TableColumn<PropertyRow, String>)col));
        this.tblDetails.setEditable(true);
        this.colValue.setEditable(true);
        this.colValue.setOnEditCommit(ev -> {
            PropertyRow row = (PropertyRow)ev.getRowValue();
            if (row != null && "Type".equalsIgnoreCase((String)row.labelProperty().get())) {
                return;
            }
            row.valueProperty().set((Object)((String)ev.getNewValue()));
            this.applyRowToDomain(row);
            this.refreshSelectedNode();
            this.markDirty();
        });
        this.updateButtons();
        this.updatePathLabel();
        if (this.tabPane != null) {
            this.tabPane.getSelectionModel().selectedItemProperty().addListener((obs, oldTab, newTab) -> {
                if (this.tabTreeViewer != null && newTab == this.tabTreeViewer) {
                    this.loadTreeViewerPage();
                    this.scheduleTreeViewerRefresh();
                }
                if (this.tabRequirement != null) {
                    this.setRequirementsTabActive(newTab == this.tabRequirement);
                }
            });
            if (this.tabTreeViewer != null && this.tabPane.getSelectionModel().getSelectedItem() == this.tabTreeViewer) {
                this.loadTreeViewerPage();
            }
            if (this.tabRequirement != null) {
                this.setRequirementsTabActive(this.tabPane.getSelectionModel().getSelectedItem() == this.tabRequirement);
            } else {
                this.setRequirementsTabActive(false);
            }
        } else {
            this.setRequirementsTabActive(false);
        }
    }

    private void openStructureExchangeWindow() {
        try {
            Stage ownerWindow;
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/com/qualidadeeprodutividade/StructureExchange.fxml"));
            Parent content = (Parent)loader.load();
            StructureExchangeController controller = (StructureExchangeController)loader.getController();
            Stage dialog = new Stage();
            dialog.setTitle("Structure Exchange");
            dialog.setResizable(false);
            controller.setOwnerStage(dialog);
            controller.setSaveAction(this.saveAction);
            controller.setDestinationProduct(this.productRoot);
            List<Item> available = this.projectProducts == null || this.projectProducts.isEmpty() ? (this.productRoot == null ? List.of() : List.of(this.productRoot)) : this.projectProducts;
            controller.setAvailableProducts(available);
            controller.setChangeHook(() -> {
                this.rebuildTree();
                this.markDirty();
            });
            Object object = this.owner != null ? this.owner : (ownerWindow = this.root != null && this.root.getScene() != null ? this.root.getScene().getWindow() : null);
            if (ownerWindow != null) {
                dialog.initOwner((Window)ownerWindow);
                dialog.initModality(Modality.WINDOW_MODAL);
            }
            dialog.setScene(new Scene(content));
            dialog.sizeToScene();
            dialog.show();
        }
        catch (IOException ex) {
            this.showError("Failed to open Structure Exchange window", ex);
        }
    }

    private void showError(String message, Exception ex) {
        Stage ownerWindow;
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Error");
        alert.setHeaderText(message);
        alert.setContentText(ex == null ? "" : String.valueOf(ex.getMessage()));
        Object object = this.owner != null ? this.owner : (ownerWindow = this.root != null && this.root.getScene() != null ? this.root.getScene().getWindow() : null);
        if (ownerWindow != null) {
            alert.initOwner((Window)ownerWindow);
        }
        alert.showAndWait();
    }

    private boolean ensureEditPermission() {
        return true;
    }

    private void rebuildTree() {
        TreeItem<Object> target;
        if (this.tree == null) {
            return;
        }
        if (this.productRoot == null) {
            this.tree.setRoot(null);
            this.bindRequirementsTo(null);
            this.scheduleTreeViewerRefresh();
            return;
        }
        TreeItem previousSelection = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        Object previousValue = previousSelection == null ? null : previousSelection.getValue();
        TreeItem<Object> rootTi = this.buildNode(this.productRoot);
        rootTi.setExpanded(true);
        this.tree.setRoot(rootTi);
        TreeItem<Object> treeItem = target = previousValue == null ? rootTi : this.findTreeItemByValue(rootTi, previousValue);
        if (target == null) {
            target = rootTi;
        }
        this.tree.getSelectionModel().select(target);
        this.scheduleTreeViewerRefresh();
    }

    private void expandEntireTree() {
        this.applyExpansionState(true);
    }

    private void collapseEntireTree() {
        this.applyExpansionState(false);
    }

    private void applyExpansionState(boolean expanded) {
        if (this.tree == null) {
            return;
        }
        TreeItem<Object> rootItem = this.tree.getRoot();
        if (rootItem == null && this.productRoot != null) {
            rootItem = this.buildNode(this.productRoot);
            this.tree.setRoot(rootItem);
        }
        if (rootItem == null) {
            return;
        }
        this.setExpandedRecursively(rootItem, expanded);
    }

    private void setExpandedRecursively(TreeItem<?> item, boolean expanded) {
        if (item == null) {
            return;
        }
        item.setExpanded(expanded);
        for (TreeItem child : item.getChildren()) {
            this.setExpandedRecursively(child, expanded);
        }
    }

    private TreeItem<Object> buildNode(Object val) {
        TreeItem ti = new TreeItem(val);
        if (val instanceof Item) {
            Item it = (Item)val;
            if (it.getChildren() != null) {
                for (Item child : it.getChildren()) {
                    ti.getChildren().add(this.buildNode(child));
                }
            }
            if (it.getCharacteristics() != null) {
                for (Characteristic ch : it.getCharacteristics()) {
                    ti.getChildren().add((Object)new TreeItem((Object)ch));
                }
            }
        }
        return ti;
    }

    private TreeItem<Object> findTreeItemByValue(TreeItem<Object> root, Object value) {
        if (root == null || value == null) {
            return null;
        }
        Object current = root.getValue();
        if (current == value || current != null && current.equals(value)) {
            return root;
        }
        for (TreeItem child : root.getChildren()) {
            TreeItem<Object> found = this.findTreeItemByValue((TreeItem<Object>)child, value);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private void rebuildDetailsForSelection() {
        this.rebuildDetails((TreeItem<Object>)((TreeItem)this.tree.getSelectionModel().getSelectedItem()));
    }

    private void rebuildDetails(TreeItem<Object> sel) {
        this.cancelDetailsEditing();
        ObservableList rows = FXCollections.observableArrayList();
        if (sel == null) {
            this.tblDetails.setItems(rows);
            return;
        }
        Object val = sel.getValue();
        if (val instanceof Item) {
            Item it = (Item)val;
            rows.add((Object)PropertyRow.of(it, "Part Number", this.show(it.getPartNumber())));
            rows.add((Object)PropertyRow.of(it, "Description", this.show(it.getDescription())));
            rows.add((Object)new PropertyRowMultiline(it, "Function", this.show(it.getFunction())));
            rows.add((Object)PropertyRow.of(it, "Type", it.getType() == null ? "" : this.formatItemType(it.getType())));
        } else if (val instanceof Characteristic) {
            Characteristic ch = (Characteristic)val;
            rows.clear();
            rows.add((Object)PropertyRow.of(ch, "Description", this.safe(ch.getDescription())));
            rows.add((Object)PropertyRow.of(ch, "Target Value", this.show(ch.getTargetValueText())));
            rows.add((Object)PropertyRow.of(ch, "Lower Specification Limit", this.show(ch.getLowerLimitText())));
            rows.add((Object)PropertyRow.of(ch, "Upper Specification Limit", this.show(ch.getUpperLimitText())));
            rows.add((Object)PropertyRow.of(ch, "Cpk", this.show(ch.getCpkText())));
            this.addBoolRow((ObservableList<PropertyRow>)rows, ch, "Attribute", ch.attributeProperty());
            this.addBoolRow((ObservableList<PropertyRow>)rows, ch, "Critical to Safety", ch.criticalToSafetyProperty());
            this.addBoolRow((ObservableList<PropertyRow>)rows, ch, "Critical to Quality", ch.criticalToQualityProperty());
            this.addBoolRow((ObservableList<PropertyRow>)rows, ch, "Critical to Process", ch.criticalToProcessProperty());
            PropertyRow last = (PropertyRow)rows.get(rows.size() - 1);
            if (last instanceof PropertyRowBoolean) {
                PropertyRowBoolean rb1 = (PropertyRowBoolean)last;
                rb1.booleanProperty().addListener((o, a, v) -> this.markDirty());
            }
        }
        this.tblDetails.setItems(rows);
    }

    private void cancelDetailsEditing() {
        if (this.tblDetails == null) {
            return;
        }
        if (this.tblDetails.getEditingCell() != null) {
            this.tblDetails.edit(-1, null);
        }
    }

    private void applyRowToDomain(PropertyRow row) {
        if (row == null) {
            return;
        }
        Object val = row.getOwner();
        if (val == null) {
            return;
        }
        String key = (String)row.labelProperty().get();
        String v = (String)row.valueProperty().get();
        if (val instanceof Item) {
            Item it = (Item)val;
            switch (key) {
                case "Part Number": {
                    it.setPartNumber(v);
                    this.refreshSelectedNode();
                    break;
                }
                case "Description": {
                    it.setDescription(v);
                    this.refreshSelectedNode();
                    break;
                }
                case "Function": {
                    it.setFunction(v);
                    this.refreshSelectedNode();
                    break;
                }
            }
        } else if (val instanceof Characteristic) {
            Characteristic ch = (Characteristic)val;
            switch (key) {
                case "Description": {
                    ch.setDescription(v);
                    break;
                }
                case "Target Value": {
                    ch.setTargetValueText(v);
                    break;
                }
                case "Lower Specification Limit": {
                    ch.setLowerLimitText(v);
                    break;
                }
                case "Upper Specification Limit": {
                    ch.setUpperLimitText(v);
                    break;
                }
                case "Cpk": {
                    ch.setCpkText(v);
                    break;
                }
                case "Attribute?": {
                    ch.setAttribute(this.parseBoolean(v));
                    break;
                }
                case "Critical to Safety": {
                    ch.setCriticalToSafety(this.parseBoolean(v));
                    break;
                }
                case "Critical to Quality": {
                    ch.setCriticalToQuality(this.parseBoolean(v));
                    break;
                }
                case "Critical to Process": {
                    ch.setCriticalToProcess(this.parseBoolean(v));
                }
            }
        }
    }

    private void onAddSystem() {
        boolean ok;
        Object object;
        if (!this.ensureEditPermission()) {
            return;
        }
        TreeItem sel = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (sel == null || !((object = sel.getValue()) instanceof Item)) {
            return;
        }
        Item parent = (Item)object;
        boolean bl = ok = this.isProduct(parent) || parent.getType() == ItemType.SYSTEM;
        if (!ok) {
            this.info("Error", "Product Tree Error", "A System can only be added under a Product or a System.");
            return;
        }
        Item sys = new Item();
        sys.setType(ItemType.SYSTEM);
        sys.setDescription("New System");
        parent.addChild(sys);
        sel.getChildren().add(this.buildNode(sys));
        sel.setExpanded(true);
        this.tree.getSelectionModel().select((Object)((TreeItem)sel.getChildren().get(sel.getChildren().size() - 1)));
        this.markDirty();
    }

    private void onAddPart() {
        boolean ok;
        Object object;
        if (!this.ensureEditPermission()) {
            return;
        }
        TreeItem sel = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (sel == null || !((object = sel.getValue()) instanceof Item)) {
            return;
        }
        Item parent = (Item)object;
        boolean bl = ok = this.isProduct(parent) || parent.getType() == ItemType.SYSTEM;
        if (!ok) {
            this.info("Error", "Product Tree Error", "A part can only be added under a Product or a System.");
            return;
        }
        Item part = new Item();
        part.setType(ItemType.PART);
        part.setDescription("New Part");
        parent.addChild(part);
        sel.getChildren().add(this.buildNode(part));
        sel.setExpanded(true);
        this.tree.getSelectionModel().select((Object)((TreeItem)sel.getChildren().get(sel.getChildren().size() - 1)));
        this.markDirty();
    }

    private void onAddCharacteristic() {
        boolean ok;
        Object object;
        if (!this.ensureEditPermission()) {
            return;
        }
        TreeItem sel = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (sel == null || !((object = sel.getValue()) instanceof Item)) {
            return;
        }
        Item parent = (Item)object;
        boolean bl = ok = this.isProduct(parent) || parent.getType() == ItemType.SYSTEM || parent.getType() == ItemType.PART;
        if (!ok) {
            this.info("Error", "Product Tree Error", "A characteristic can only be added under a Product, System or Part.");
            return;
        }
        Characteristic ch = new Characteristic();
        ch.setDescription("New Characteristic");
        parent.addCharacteristic(ch);
        sel.getChildren().add((Object)new TreeItem((Object)ch));
        sel.setExpanded(true);
        this.tree.getSelectionModel().select((Object)((TreeItem)sel.getChildren().get(sel.getChildren().size() - 1)));
        this.markDirty();
    }

    private void onDuplicateNode() {
        Object object;
        if (!this.ensureEditPermission()) {
            return;
        }
        TreeItem sel = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (sel == null) {
            return;
        }
        TreeItem parentTi = sel.getParent();
        if (parentTi == null || !((object = parentTi.getValue()) instanceof Item)) {
            return;
        }
        Item parentItem = (Item)object;
        Object val = sel.getValue();
        TreeItem newNode = null;
        if (val instanceof Item) {
            Item it = (Item)val;
            Item clone = StructureCloner.cloneItem(it);
            int domainIdx = parentItem.getChildren().indexOf((Object)it);
            if (domainIdx < 0) {
                domainIdx = parentItem.getChildren().size() - 1;
            }
            parentItem.getChildren().add(domainIdx + 1, (Object)clone);
            newNode = this.buildNode(clone);
        } else if (val instanceof Characteristic) {
            Characteristic ch = (Characteristic)val;
            Characteristic clone = StructureCloner.cloneCharacteristic(ch);
            int domainIdx = parentItem.getCharacteristics().indexOf((Object)ch);
            if (domainIdx < 0) {
                domainIdx = parentItem.getCharacteristics().size() - 1;
            }
            parentItem.getCharacteristics().add(domainIdx + 1, (Object)clone);
            newNode = new TreeItem((Object)clone);
        } else {
            return;
        }
        int treeIdx = parentTi.getChildren().indexOf((Object)sel);
        if (treeIdx < 0) {
            treeIdx = parentTi.getChildren().size() - 1;
        }
        parentTi.getChildren().add(treeIdx + 1, (Object)newNode);
        parentTi.setExpanded(true);
        this.tree.getSelectionModel().select((Object)newNode);
        this.tree.scrollTo(this.tree.getRow(newNode));
        this.updateButtons();
        this.updatePathLabel();
        this.rebuildDetails((TreeItem<Object>)newNode);
        this.markDirty();
    }

    private void onDeleteSelected() {
        Object object;
        Item it;
        if (!this.ensureEditPermission()) {
            return;
        }
        TreeItem sel = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (sel == null) {
            return;
        }
        Object val = sel.getValue();
        if (val instanceof Item && (it = (Item)val) == this.productRoot) {
            this.info("Error", "Prdduct Tree Error", "Cannot delete the Product root.");
            return;
        }
        if (!this.confirm("Delete selected node? This cannot be undone.")) {
            return;
        }
        TreeItem parentTi = sel.getParent();
        if (parentTi != null && (object = parentTi.getValue()) instanceof Item) {
            Item pi = (Item)object;
            if (val instanceof Item) {
                Item ci = (Item)val;
                pi.removeChild(ci);
            } else if (val instanceof Characteristic) {
                Characteristic ch = (Characteristic)val;
                pi.removeCharacteristic(ch);
            }
            parentTi.getChildren().remove((Object)sel);
            this.tree.getSelectionModel().select((Object)parentTi);
            this.rebuildDetails((TreeItem<Object>)parentTi);
            this.markDirty();
        }
    }

    private void onSaveOnly() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.performSave();
    }

    private void onSaveAndExit() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.performSave()) {
            this.closeWindow();
        }
    }

    private boolean performSave() {
        this.commitPendingEdits();
        try {
            if (this.saveAction != null) {
                this.saveAction.run();
            }
            this.hasUnsavedChanges = false;
            return true;
        }
        catch (Exception ex) {
            new Alert(Alert.AlertType.ERROR, "Falha ao salvar:\n" + ex.getMessage(), new ButtonType[0]).showAndWait();
            return false;
        }
    }

    private void commitPendingEdits() {
        if (this.tblDetails != null && this.tblDetails.getEditingCell() != null) {
            this.tblDetails.edit(-1, null);
        }
    }

    private void closeWindow() {
        Stage window = null;
        if (this.owner != null) {
            window = this.owner;
        } else if (this.root != null && this.root.getScene() != null) {
            window = this.root.getScene().getWindow();
        }
        if (window == null) {
            return;
        }
        this.programmaticClose = true;
        if (window instanceof Stage) {
            Stage stage = window;
            stage.close();
        } else {
            window.hide();
        }
    }

    private void installCloseHandler() {
        if (this.owner == null) {
            return;
        }
        this.owner.setOnCloseRequest(evt -> {
            if (this.programmaticClose) {
                this.programmaticClose = false;
                return;
            }
            evt.consume();
            this.promptSaveBeforeClose();
        });
    }

    private void promptSaveBeforeClose() {
        if (!this.hasUnsavedChanges) {
            this.closeWindow();
            return;
        }
        Alert confirm = new Alert(Alert.AlertType.CONFIRMATION);
        confirm.setTitle("Save changes?");
        confirm.setHeaderText("Do you want to save before closing?");
        confirm.setContentText("Select Yes to save the current Product Tree.");
        confirm.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        if (this.owner != null) {
            confirm.initOwner((Window)this.owner);
        }
        confirm.showAndWait().ifPresent(result -> {
            if (result == ButtonType.YES) {
                if (this.performSave()) {
                    this.closeWindow();
                }
            } else if (result == ButtonType.NO) {
                this.hasUnsavedChanges = false;
                this.closeWindow();
            }
        });
    }

    private void updateButtons() {
        if (this.requirementsTabActive) {
            this.btnAddSystem.setDisable(true);
            this.btnAddPart.setDisable(true);
            this.btnAddChar.setDisable(true);
            this.btnDelete.setDisable(true);
            return;
        }
        TreeItem sel = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (sel == null) {
            this.btnAddSystem.setDisable(true);
            this.btnAddPart.setDisable(true);
            this.btnAddChar.setDisable(true);
            this.btnDelete.setDisable(true);
            return;
        }
        Object v = sel.getValue();
        boolean canAddSystem = false;
        boolean canAddPart = false;
        boolean canAddChar = false;
        boolean canDelete = true;
        if (v instanceof Item) {
            Item it = (Item)v;
            ItemType t = it.getType();
            if (it == this.productRoot || t == ItemType.PRODUCT) {
                canAddSystem = true;
                canAddPart = true;
                canAddChar = true;
                canDelete = it != this.productRoot;
            } else if (t == ItemType.SYSTEM) {
                canAddSystem = true;
                canAddPart = true;
                canAddChar = true;
            } else if (t == ItemType.PART) {
                canAddSystem = false;
                canAddPart = false;
                canAddChar = true;
            }
        } else {
            canAddSystem = false;
            canAddPart = false;
            canAddChar = false;
        }
        this.btnAddSystem.setDisable(!canAddSystem);
        this.btnAddPart.setDisable(!canAddPart);
        this.btnAddChar.setDisable(!canAddChar);
        this.btnDelete.setDisable(!canDelete);
    }

    private void updatePathLabel() {
        TreeItem sel = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (sel == null) {
            this.lblPath.setText("");
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (TreeItem ti = sel; ti != null; ti = ti.getParent()) {
            String name;
            Object v = ti.getValue();
            if (v instanceof Item) {
                Item it = (Item)v;
                v0 = this.safe(it.getDescription());
            } else if (v instanceof Characteristic) {
                Characteristic ch = (Characteristic)v;
                v0 = this.safe(ch.getDescription());
            } else {
                v0 = name = String.valueOf(v);
            }
            if (sb.length() > 0) {
                sb.insert(0, " / ");
            }
            sb.insert(0, name);
        }
        this.lblPath.setText(sb.toString());
    }

    private void configureRequirementTab() {
        if (this.tblRequirements == null) {
            return;
        }
        this.tblRequirements.setEditable(true);
        this.tblRequirements.setFixedCellSize(-1.0);
        this.tblRequirements.getSelectionModel().setCellSelectionEnabled(true);
        this.tblRequirements.setPlaceholder((Node)new Label("No product requirements defined yet"));
        this.wrapRequirementColumn(this.colRequirementDescription, ProductRequirement::descriptionProperty);
        this.wrapRequirementColumn(this.colRequirementSpecification, ProductRequirement::specificationProperty);
        this.wrapRequirementColumn(this.colRequirementTolerance, ProductRequirement::toleranceProperty);
        if (this.colRequirementCustomerImportance != null) {
            this.colRequirementCustomerImportance.setStyle("-fx-alignment: TOP_CENTER;");
            this.colRequirementCustomerImportance.setCellValueFactory(cell -> ((ProductRequirement)cell.getValue()).customerImportanceProperty().asObject());
            this.colRequirementCustomerImportance.setCellFactory(col -> {
                ComboBoxTableCell cell = new ComboBoxTableCell((Object[])new Integer[]{1, 2, 3, 4, 5});
                cell.setAlignment(Pos.TOP_CENTER);
                return cell;
            });
            this.colRequirementCustomerImportance.setOnEditCommit(edit -> {
                ProductRequirement row = (ProductRequirement)edit.getRowValue();
                Integer value = (Integer)edit.getNewValue();
                if (row != null && value != null) {
                    row.setCustomerImportance(value);
                    this.recalcRequirementPercentages();
                    this.markDirty();
                }
            });
        }
        if (this.colRequirementPercent != null) {
            this.colRequirementPercent.setCellValueFactory(cell -> ((ProductRequirement)cell.getValue()).percentProperty().asObject());
            this.colRequirementPercent.setEditable(false);
            this.colRequirementPercent.setStyle("-fx-alignment: TOP_CENTER;");
            this.colRequirementPercent.setCellFactory(col -> new TableCell<ProductRequirement, Double>(this){
                {
                    Objects.requireNonNull(this$0);
                    this.setAlignment(Pos.TOP_CENTER);
                }

                protected void updateItem(Double value, boolean empty) {
                    super.updateItem((Object)value, empty);
                    if (empty || value == null) {
                        this.setText(null);
                    } else {
                        double percentValue = value * 100.0;
                        this.setText(String.format(Locale.US, "%.1f%%", percentValue));
                    }
                }
            });
        }
        if (this.btnRequirementAdd != null) {
            this.btnRequirementAdd.setTooltip(new Tooltip("Add requirement"));
            this.btnRequirementAdd.setOnAction(e -> this.onAddRequirement());
        }
        if (this.btnRequirementRemove != null) {
            this.btnRequirementRemove.setTooltip(new Tooltip("Remove requirement"));
            this.btnRequirementRemove.setOnAction(e -> this.onRemoveRequirement());
        }
        if (this.btnRequirementDuplicate != null) {
            this.btnRequirementDuplicate.setTooltip(new Tooltip("Duplicate requirement"));
            this.btnRequirementDuplicate.setOnAction(e -> this.onDuplicateRequirement());
        }
        this.tblRequirements.setItems(this.emptyRequirements);
        this.updateRequirementControls();
    }

    private void wrapRequirementColumn(TableColumn<ProductRequirement, String> column, Function<ProductRequirement, StringProperty> accessor) {
        if (column == null) {
            return;
        }
        column.setStyle("-fx-alignment: CENTER;");
        column.setCellValueFactory(cell -> (ObservableValue)accessor.apply((ProductRequirement)cell.getValue()));
        column.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new DefaultStringConverter()));
        column.setOnEditCommit(edit -> {
            ProductRequirement row = (ProductRequirement)edit.getRowValue();
            if (row != null) {
                ((StringProperty)accessor.apply(row)).set((Object)((String)edit.getNewValue()));
                this.markDirty();
            }
        });
    }

    private void setRequirementsTabActive(boolean active) {
        this.requirementsTabActive = active;
        this.updateButtons();
        this.updateRequirementControls();
    }

    private void bindRequirementsTo(Item owner) {
        if (this.tblRequirements == null) {
            return;
        }
        if (this.activeRequirementList != null) {
            this.activeRequirementList.removeListener(this.requirementListListener);
        }
        this.requirementOwner = owner;
        if (owner == null) {
            this.activeRequirementList = null;
            this.tblRequirements.setItems(this.emptyRequirements);
        } else {
            this.activeRequirementList = owner.getRequirements();
            if (this.activeRequirementList != null) {
                this.activeRequirementList.addListener(this.requirementListListener);
                this.tblRequirements.setItems(this.activeRequirementList);
            } else {
                this.tblRequirements.setItems(this.emptyRequirements);
            }
        }
        this.recalcRequirementPercentages();
        this.tblRequirements.refresh();
        this.updateRequirementControls();
    }

    private void updateRequirementControls() {
        boolean enableButtons;
        boolean hasOwner;
        boolean bl = hasOwner = this.requirementOwner != null;
        if (this.tblRequirements != null) {
            this.tblRequirements.setDisable(!hasOwner);
        }
        boolean bl2 = enableButtons = this.requirementsTabActive && hasOwner;
        if (this.btnRequirementAdd != null) {
            this.btnRequirementAdd.setDisable(!enableButtons);
        }
        if (this.btnRequirementRemove != null) {
            this.btnRequirementRemove.setDisable(!enableButtons);
        }
        if (this.btnRequirementDuplicate != null) {
            this.btnRequirementDuplicate.setDisable(!enableButtons);
        }
    }

    private void recalcRequirementPercentages() {
        if (this.activeRequirementList == null || this.activeRequirementList.isEmpty()) {
            if (this.activeRequirementList != null) {
                for (ProductRequirement req : this.activeRequirementList) {
                    req.setPercent(0.0);
                }
            }
            if (this.tblRequirements != null) {
                this.tblRequirements.refresh();
            }
            return;
        }
        int importanceSum = 0;
        for (ProductRequirement req : this.activeRequirementList) {
            int value = Math.max(0, req.getCustomerImportance());
            importanceSum += value;
        }
        for (ProductRequirement req : this.activeRequirementList) {
            double percent = importanceSum == 0 ? 0.0 : (double)Math.max(0, req.getCustomerImportance()) / (double)importanceSum;
            req.setPercent(percent);
        }
        if (this.tblRequirements != null) {
            this.tblRequirements.refresh();
        }
    }

    private void onAddRequirement() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.requirementOwner == null) {
            return;
        }
        ProductRequirement req = new ProductRequirement();
        this.requirementOwner.getRequirements().add((Object)req);
        this.recalcRequirementPercentages();
        this.markDirty();
        this.selectRequirement(req);
    }

    private void onRemoveRequirement() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.requirementOwner == null || this.tblRequirements == null) {
            return;
        }
        ProductRequirement selected = (ProductRequirement)this.tblRequirements.getSelectionModel().getSelectedItem();
        if (selected == null) {
            return;
        }
        this.requirementOwner.getRequirements().remove((Object)selected);
        this.recalcRequirementPercentages();
        this.markDirty();
        this.updateRequirementControls();
    }

    private void onDuplicateRequirement() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.requirementOwner == null || this.tblRequirements == null) {
            return;
        }
        ProductRequirement source = (ProductRequirement)this.tblRequirements.getSelectionModel().getSelectedItem();
        if (source == null) {
            return;
        }
        ProductRequirement copy = StructureCloner.cloneRequirement(source);
        ObservableList<ProductRequirement> list = this.requirementOwner.getRequirements();
        int idx = list.indexOf((Object)source);
        if (idx < 0) {
            idx = list.size() - 1;
        }
        list.add(Math.max(0, idx) + 1, (Object)copy);
        this.recalcRequirementPercentages();
        this.markDirty();
        this.selectRequirement(copy);
    }

    private void selectRequirement(ProductRequirement target) {
        if (this.tblRequirements == null || target == null) {
            return;
        }
        int idx = this.tblRequirements.getItems().indexOf((Object)target);
        if (idx >= 0) {
            this.tblRequirements.getSelectionModel().clearAndSelect(idx);
            this.tblRequirements.scrollTo(idx);
        }
    }

    private void showContextMenu(ContextMenuEvent e) {
        Item selectedItem;
        Object object;
        if (this.currentMenu != null && this.currentMenu.isShowing()) {
            this.currentMenu.hide();
        }
        TreeItem selectedTreeItem = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        ContextMenu menu = new ContextMenu();
        menu.setAutoHide(true);
        MenuItem miAddSystem = new MenuItem("Add System");
        miAddSystem.setOnAction(ev -> this.onAddSystem());
        MenuItem miAddPart = new MenuItem("Add Part");
        miAddPart.setOnAction(ev -> this.onAddPart());
        MenuItem miAddChar = new MenuItem("Add Characteristic");
        miAddChar.setOnAction(ev -> this.onAddCharacteristic());
        MenuItem miDuplicate = new MenuItem("Duplicate");
        miDuplicate.setOnAction(ev -> this.onDuplicateNode());
        MenuItem miDelete = new MenuItem("Delete");
        miDelete.setOnAction(ev -> this.onDeleteSelected());
        MenuItem miSave = new MenuItem("Save & Exit");
        miSave.setOnAction(ev -> this.onSaveAndExit());
        boolean isItemNode = selectedTreeItem != null && selectedTreeItem.getValue() instanceof Item;
        boolean isRootItem = selectedTreeItem != null && (object = selectedTreeItem.getValue()) instanceof Item && (selectedItem = (Item)object) == this.productRoot;
        boolean canAddSystem = false;
        boolean canAddPart = false;
        boolean canAddChar = false;
        if (isItemNode) {
            ItemType nodeType;
            Item selectedItem2 = (Item)selectedTreeItem.getValue();
            ItemType itemType = nodeType = selectedItem2 == this.productRoot || selectedItem2.getType() == ItemType.PRODUCT ? ItemType.PRODUCT : selectedItem2.getType();
            if (nodeType == ItemType.PRODUCT) {
                canAddSystem = true;
                canAddPart = true;
                canAddChar = true;
            } else if (nodeType == ItemType.SYSTEM) {
                canAddSystem = true;
                canAddPart = true;
                canAddChar = true;
            } else if (nodeType == ItemType.PART) {
                canAddSystem = false;
                canAddPart = false;
                canAddChar = true;
            }
        }
        miAddSystem.setDisable(!canAddSystem);
        miAddPart.setDisable(!canAddPart);
        miAddChar.setDisable(!canAddChar);
        miDelete.setDisable(isRootItem);
        boolean canDuplicate = selectedTreeItem != null && selectedTreeItem.getParent() != null && selectedTreeItem.getParent().getValue() instanceof Item && (selectedTreeItem.getValue() instanceof Item || selectedTreeItem.getValue() instanceof Characteristic);
        miDuplicate.setDisable(!canDuplicate);
        menu.getItems().setAll((Object[])new MenuItem[]{miAddSystem, miAddPart, miAddChar, new SeparatorMenuItem(), miDuplicate, new SeparatorMenuItem(), miDelete, new SeparatorMenuItem(), miSave});
        EventHandler hideOnAnyClick = mouseEvent -> {
            if (menu.isShowing()) {
                menu.hide();
            }
        };
        menu.setOnShown(ev -> {
            this.currentMenu = menu;
            Scene scene = this.tree.getScene();
            if (scene != null) {
                scene.addEventFilter(MouseEvent.MOUSE_PRESSED, hideOnAnyClick);
            }
        });
        menu.setOnHidden(ev -> {
            Scene scene = this.tree.getScene();
            if (scene != null) {
                scene.removeEventFilter(MouseEvent.MOUSE_PRESSED, hideOnAnyClick);
            }
            if (this.currentMenu == menu) {
                this.currentMenu = null;
            }
        });
        menu.show(this.tree, e.getScreenX(), e.getScreenY());
        e.consume();
    }

    private boolean isDraggable(TreeItem<Object> item) {
        if (item == null) {
            return false;
        }
        Object value = item.getValue();
        if (value instanceof Characteristic) {
            return item.getParent() != null;
        }
        if (value instanceof Item) {
            Item it = (Item)value;
            return it != this.productRoot && !this.isProduct(it);
        }
        return false;
    }

    private TreeItem<Object> resolveDropTarget(TreeItem<Object> candidate) {
        if (candidate == null) {
            return null;
        }
        if (candidate.getValue() instanceof Characteristic && candidate.getParent() != null) {
            return candidate.getParent();
        }
        return candidate;
    }

    private boolean isDropAllowed(TreeItem<Object> source, TreeItem<Object> target) {
        if (source == null || target == null || source == target) {
            return false;
        }
        if (this.isAncestor(source, target)) {
            return false;
        }
        Object targetVal = target.getValue();
        if (!(targetVal instanceof Item)) {
            return false;
        }
        Item targetItem = (Item)targetVal;
        Object movedVal = source.getValue();
        if (movedVal instanceof Item) {
            Item movedItem = (Item)movedVal;
            if (movedItem == this.productRoot || this.isProduct(movedItem)) {
                return false;
            }
            ItemType childType = movedItem.getType();
            return this.canHostItemOfType(targetItem, childType);
        }
        if (movedVal instanceof Characteristic) {
            return this.canHostCharacteristic(targetItem);
        }
        return false;
    }

    private boolean canHostItemOfType(Item parent, ItemType childType) {
        ItemType effectiveChild;
        if (parent == null) {
            return false;
        }
        ItemType parentType = parent.getType();
        boolean parentIsProduct = this.isProduct(parent);
        ItemType itemType = effectiveChild = childType == null ? ItemType.PART : childType;
        if (effectiveChild == ItemType.SYSTEM) {
            return parentIsProduct || parentType == ItemType.SYSTEM;
        }
        if (effectiveChild == ItemType.PART) {
            return parentIsProduct || parentType == ItemType.SYSTEM;
        }
        return false;
    }

    private boolean canHostCharacteristic(Item parent) {
        if (parent == null) {
            return false;
        }
        return this.isProduct(parent) || parent.getType() == ItemType.SYSTEM || parent.getType() == ItemType.PART;
    }

    private boolean isAncestor(TreeItem<Object> ancestor, TreeItem<Object> node) {
        for (TreeItem cur = node; cur != null; cur = cur.getParent()) {
            if (cur != ancestor) continue;
            return true;
        }
        return false;
    }

    private void handleDrop(TreeItem<Object> source, TreeItem<Object> target) {
        if (source == null || target == null || source == target) {
            return;
        }
        TreeItem<Object> resolvedTarget = this.resolveDropTarget(target);
        if (resolvedTarget == null) {
            return;
        }
        TreeItem oldParent = source.getParent();
        if (oldParent == null) {
            return;
        }
        if (oldParent == resolvedTarget) {
            return;
        }
        Object movedVal = source.getValue();
        this.detachFromDomain((TreeItem<Object>)oldParent, movedVal);
        oldParent.getChildren().remove(source);
        Object targetVal = resolvedTarget.getValue();
        if (!(targetVal instanceof Item)) {
            return;
        }
        Item parentItem = (Item)targetVal;
        this.attachToDomain(parentItem, movedVal);
        this.insertChildNode(resolvedTarget, source);
        this.expandPath(source);
        this.tree.getSelectionModel().select(source);
        this.updateButtons();
        this.updatePathLabel();
        this.rebuildDetails(source);
        this.tree.refresh();
        this.markDirty();
        this.scheduleTreeViewerRefresh();
    }

    private void detachFromDomain(TreeItem<Object> parentNode, Object childVal) {
        if (parentNode == null || childVal == null) {
            return;
        }
        Object parentVal = parentNode.getValue();
        if (!(parentVal instanceof Item)) {
            return;
        }
        Item parentItem = (Item)parentVal;
        if (childVal instanceof Item) {
            Item childItem = (Item)childVal;
            parentItem.getChildren().remove((Object)childItem);
        } else if (childVal instanceof Characteristic) {
            Characteristic ch = (Characteristic)childVal;
            parentItem.getCharacteristics().remove((Object)ch);
        }
    }

    private void attachToDomain(Item parentItem, Object childVal) {
        if (parentItem == null || childVal == null) {
            return;
        }
        if (childVal instanceof Item) {
            Item childItem = (Item)childVal;
            if (!parentItem.getChildren().contains((Object)childItem)) {
                parentItem.getChildren().add((Object)childItem);
            }
        } else if (childVal instanceof Characteristic) {
            Characteristic ch = (Characteristic)childVal;
            if (!parentItem.getCharacteristics().contains((Object)ch)) {
                parentItem.getCharacteristics().add((Object)ch);
            }
        }
    }

    private void insertChildNode(TreeItem<Object> parent, TreeItem<Object> child) {
        if (parent == null || child == null) {
            return;
        }
        parent.getChildren().remove(child);
        if (child.getValue() instanceof Item) {
            int idx = this.findCharacteristicInsertIndex(parent);
            parent.getChildren().add(idx, child);
        } else {
            parent.getChildren().add(child);
        }
    }

    private int findCharacteristicInsertIndex(TreeItem<Object> parent) {
        TreeItem ch;
        int idx = 0;
        Iterator iterator = parent.getChildren().iterator();
        while (iterator.hasNext() && (ch = (TreeItem)iterator.next()).getValue() instanceof Item) {
            ++idx;
        }
        return idx;
    }

    private void showDropTarget(TreeItem<Object> target, TreeCell<Object> fallbackCell) {
        TreeCell<Object> cell = this.findTreeCell(target);
        if (cell == null) {
            cell = fallbackCell;
        }
        if (cell == null) {
            this.clearDropTargetHighlight();
            return;
        }
        if (this.dropTargetCell != cell) {
            this.clearDropTargetHighlight();
            this.dropTargetCell = cell;
        }
        this.dropTargetCell.pseudoClassStateChanged(DND_TARGET_PSEUDO, true);
    }

    private TreeCell<Object> findTreeCell(TreeItem<Object> item) {
        if (this.tree == null || item == null) {
            return null;
        }
        for (Node node : this.tree.lookupAll(".tree-cell")) {
            TreeCell cell;
            if (!(node instanceof TreeCell) || (cell = (TreeCell)node).getTreeItem() != item) continue;
            TreeCell typed = cell;
            return typed;
        }
        return null;
    }

    private void clearDropTargetHighlight() {
        if (this.dropTargetCell != null) {
            this.dropTargetCell.pseudoClassStateChanged(DND_TARGET_PSEUDO, false);
            this.dropTargetCell = null;
        }
    }

    private void clearDropTargetHighlight(TreeCell<Object> cell) {
        if (cell != null && cell == this.dropTargetCell) {
            this.clearDropTargetHighlight();
        }
    }

    private void configureSearchControls() {
        if (this.txtSearch == null || this.btnNext == null || this.tree == null) {
            return;
        }
        this.btnNext.setDisable(false);
        this.txtSearch.setOnAction(e -> this.performTreeSearch(true));
        this.btnNext.setOnAction(e -> this.goToNextMatch());
        this.txtSearch.textProperty().addListener((obs, old, value) -> {
            if (value == null || value.isBlank()) {
                this.clearSearchResults();
            } else {
                this.lastSearchQuery = "";
                this.searchMatches.clear();
                this.currentSearchIndex = -1;
            }
        });
        this.tree.rootProperty().addListener((obs, oldRoot, newRoot) -> this.clearSearchResults());
    }

    private void performTreeSearch(boolean resetIndex) {
        if (this.txtSearch == null || this.tree == null) {
            return;
        }
        String query = ProductTreeManagerController.normalizeQuery(this.txtSearch.getText());
        if (query.isEmpty()) {
            this.clearSearchResults();
            return;
        }
        TreeItem rootItem = this.tree.getRoot();
        if (rootItem == null) {
            this.clearSearchResults();
            return;
        }
        TreeItem<Object> previous = null;
        if (!this.searchMatches.isEmpty() && this.currentSearchIndex >= 0 && this.currentSearchIndex < this.searchMatches.size()) {
            previous = this.searchMatches.get(this.currentSearchIndex);
        }
        ArrayList<TreeItem<Object>> found = new ArrayList<TreeItem<Object>>();
        this.collectMatches((TreeItem<Object>)rootItem, query, found);
        this.searchMatches.clear();
        this.searchMatches.addAll(found);
        this.lastSearchQuery = query;
        if (this.searchMatches.isEmpty()) {
            this.currentSearchIndex = -1;
            return;
        }
        this.currentSearchIndex = resetIndex || previous == null || !this.searchMatches.contains(previous) ? 0 : this.searchMatches.indexOf(previous);
        this.focusOn(this.searchMatches.get(this.currentSearchIndex));
    }

    private void goToNextMatch() {
        if (this.txtSearch == null || this.tree == null) {
            return;
        }
        String query = ProductTreeManagerController.normalizeQuery(this.txtSearch.getText());
        if (query.isEmpty()) {
            this.clearSearchResults();
            return;
        }
        if (!query.equals(this.lastSearchQuery) || this.searchMatches.isEmpty()) {
            this.performTreeSearch(this.searchMatches.isEmpty());
            if (this.searchMatches.isEmpty()) {
                return;
            }
        }
        this.currentSearchIndex = (this.currentSearchIndex + 1) % this.searchMatches.size();
        this.focusOn(this.searchMatches.get(this.currentSearchIndex));
    }

    private void clearSearchResults() {
        this.searchMatches.clear();
        this.currentSearchIndex = -1;
        this.lastSearchQuery = "";
    }

    private void collectMatches(TreeItem<Object> node, String query, List<TreeItem<Object>> out) {
        if (node == null) {
            return;
        }
        String text = ProductTreeManagerController.normalizeQuery(this.searchTextFor(node.getValue()));
        if (!text.isEmpty() && text.contains(query)) {
            out.add(node);
        }
        for (TreeItem child : node.getChildren()) {
            this.collectMatches((TreeItem<Object>)child, query, out);
        }
    }

    private void focusOn(TreeItem<Object> item) {
        if (this.tree == null || item == null) {
            return;
        }
        this.expandPath(item);
        this.tree.getSelectionModel().select(item);
        this.tree.requestFocus();
        int row = this.tree.getRow(item);
        if (row >= 0) {
            if (this.tree.getFocusModel() != null) {
                this.tree.getFocusModel().focus(row);
            }
            this.centerTreeRow(row);
        }
    }

    private void expandPath(TreeItem<?> item) {
        for (TreeItem current = item; current != null; current = current.getParent()) {
            current.setExpanded(true);
        }
    }

    private void centerTreeRow(int rowIndex) {
        int visible = this.approximateVisibleRowCount(this.tree);
        int target = Math.max(0, rowIndex - visible / 2);
        this.tree.scrollTo(target);
        Platform.runLater(() -> {
            int adjusted = Math.max(0, rowIndex - visible / 2);
            this.tree.scrollTo(adjusted);
            this.tree.scrollTo(rowIndex);
        });
    }

    private int approximateVisibleRowCount(TreeView<?> view) {
        if (view == null) {
            return 10;
        }
        double height = view.getHeight();
        double rowHeight = view.getFixedCellSize();
        if (rowHeight <= 0.0) {
            rowHeight = 24.0;
        }
        if (height <= 0.0) {
            return 10;
        }
        return Math.max(1, (int)Math.round(height / rowHeight));
    }

    private String searchTextFor(Object value) {
        if (value instanceof Item) {
            Item it = (Item)value;
            StringBuilder sb = new StringBuilder();
            this.appendIfNotBlank(sb, this.safe(it.getDescription()));
            this.appendIfNotBlank(sb, ProductTreeManagerController.trimToNull(it.getPartNumber()));
            this.appendIfNotBlank(sb, ProductTreeManagerController.trimToNull(it.getFunction()));
            return sb.toString();
        }
        if (value instanceof Characteristic) {
            Characteristic ch = (Characteristic)value;
            StringBuilder sb = new StringBuilder();
            this.appendIfNotBlank(sb, this.safe(ch.getDescription()));
            this.appendIfNotBlank(sb, ProductTreeManagerController.trimToNull(ch.getTargetValueText()));
            this.appendIfNotBlank(sb, ProductTreeManagerController.trimToNull(ch.getLowerLimitText()));
            this.appendIfNotBlank(sb, ProductTreeManagerController.trimToNull(ch.getUpperLimitText()));
            return sb.toString();
        }
        return value == null ? "" : value.toString();
    }

    private void appendIfNotBlank(StringBuilder sb, String text) {
        if (text == null || text.isBlank()) {
            return;
        }
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(text);
    }

    private static String normalizeQuery(String value) {
        if (value == null) {
            return "";
        }
        return value.strip().toLowerCase(Locale.ROOT);
    }

    private String safe(String s) {
        return s == null || s.isBlank() ? "(unnamed)" : s;
    }

    private boolean isProduct(Item it) {
        return it == this.productRoot || it.getType() == ItemType.PRODUCT;
    }

    private boolean confirm(String msg) {
        Alert a = new Alert(Alert.AlertType.CONFIRMATION, msg, new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        if (this.owner != null) {
            a.initOwner((Window)this.owner);
        }
        return a.showAndWait().filter(bt -> bt == ButtonType.OK).isPresent();
    }

    private void info(String title, String header, String msg) {
        Alert a = new Alert(Alert.AlertType.INFORMATION, msg, new ButtonType[]{ButtonType.OK});
        a.setTitle(title);
        a.setHeaderText(header);
        a.setContentText(msg);
        if (this.owner != null) {
            a.initOwner((Window)this.owner);
        }
        a.showAndWait();
    }

    private String show(String s) {
        return s == null ? "" : s;
    }

    private boolean parseBoolean(String s) {
        if (s == null) {
            return false;
        }
        return (s = s.trim().toLowerCase()).equals("true") || s.equals("yes") || s.equals("y") || s.equals("1");
    }

    private void refreshSelectedNode() {
        TreeItem ti = (TreeItem)this.tree.getSelectionModel().getSelectedItem();
        if (ti == null) {
            return;
        }
        this.tree.refresh();
        ti.setValue(ti.getValue());
        this.scheduleTreeViewerRefresh();
    }

    private String formatItemType(ItemType type) {
        if (type == null) {
            return "";
        }
        String raw = type.name().toLowerCase();
        return Character.toUpperCase(raw.charAt(0)) + raw.substring(1);
    }

    private void addBoolRow(ObservableList<PropertyRow> rows, Characteristic owner, String label, BooleanProperty prop) {
        PropertyRowBoolean r = new PropertyRowBoolean(owner, label, prop);
        r.booleanProperty().addListener((o, a, v) -> this.markDirty());
        rows.add((Object)r);
    }

    private /* synthetic */ void lambda$initialize$10(TextFieldTreeCell cell, DragEvent event) {
        this.draggedItem = null;
        this.clearDropTargetHighlight((TreeCell<Object>)cell);
        event.consume();
    }

    private /* synthetic */ void lambda$initialize$9(TextFieldTreeCell cell, DragEvent event) {
        this.clearDropTargetHighlight((TreeCell<Object>)cell);
    }

    private /* synthetic */ void lambda$initialize$8(TextFieldTreeCell cell, DragEvent event) {
        TreeItem<Object> target;
        if (this.draggedItem == null) {
            return;
        }
        Dragboard db = event.getDragboard();
        boolean success = false;
        if (db.hasString() && PRODUCT_DND_MARKER.equals(db.getString()) && (target = this.resolveDropTarget((TreeItem<Object>)cell.getTreeItem())) != null && this.isDropAllowed(this.draggedItem, target)) {
            this.handleDrop(this.draggedItem, target);
            success = true;
        }
        event.setDropCompleted(success);
        this.draggedItem = null;
        this.clearDropTargetHighlight((TreeCell<Object>)cell);
        event.consume();
    }

    private /* synthetic */ void lambda$initialize$7(TextFieldTreeCell cell, DragEvent event) {
        if (this.draggedItem == null) {
            return;
        }
        Dragboard db = event.getDragboard();
        if (!db.hasString() || !PRODUCT_DND_MARKER.equals(db.getString())) {
            return;
        }
        TreeItem<Object> target = this.resolveDropTarget((TreeItem<Object>)cell.getTreeItem());
        if (target != null && this.isDropAllowed(this.draggedItem, target)) {
            this.showDropTarget(target, (TreeCell<Object>)cell);
            event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            event.consume();
        } else {
            this.clearDropTargetHighlight((TreeCell<Object>)cell);
        }
    }

    private /* synthetic */ void lambda$initialize$6(TextFieldTreeCell cell, MouseEvent event) {
        if (cell.isEmpty()) {
            return;
        }
        TreeItem item = cell.getTreeItem();
        if (!this.isDraggable((TreeItem<Object>)item)) {
            return;
        }
        this.draggedItem = item;
        Dragboard db = cell.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
        ClipboardContent content = new ClipboardContent();
        content.putString(PRODUCT_DND_MARKER);
        db.setContent((Map)content);
        event.consume();
    }

    public static class PropertyRow {
        private final Object owner;
        private final StringProperty label = new SimpleStringProperty();
        private final StringProperty value = new SimpleStringProperty();

        public PropertyRow() {
            this(null);
        }

        public PropertyRow(Object owner) {
            this.owner = owner;
        }

        public Object getOwner() {
            return this.owner;
        }

        public StringProperty labelProperty() {
            return this.label;
        }

        public StringProperty valueProperty() {
            return this.value;
        }

        public static PropertyRow of(Object owner, String label, String value) {
            PropertyRow pr = new PropertyRow(owner);
            pr.label.set((Object)label);
            pr.value.set((Object)(value == null ? "" : value));
            return pr;
        }

        public boolean isMultiline() {
            return false;
        }
    }

    public static class PropertyRowMultiline
    extends PropertyRow {
        public PropertyRowMultiline(Object owner, String label, String value) {
            super(owner);
            this.labelProperty().set((Object)label);
            this.valueProperty().set((Object)(value == null ? "" : value));
        }

        @Override
        public boolean isMultiline() {
            return true;
        }
    }

    public static class PropertyRowBoolean
    extends PropertyRow {
        private final BooleanProperty bool = new SimpleBooleanProperty();

        public PropertyRowBoolean(Object owner, String label, BooleanProperty modelProp) {
            super(owner);
            this.labelProperty().set((Object)label);
            this.bool.bindBidirectional((Property)modelProp);
            this.valueProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.bool).then("true").otherwise("false"));
        }

        public BooleanProperty booleanProperty() {
            return this.bool;
        }
    }

    private class PropertyValueCell
    extends TableCell<PropertyRow, String> {
        private final TableColumn<PropertyRow, String> owner;
        private final CheckBox check;
        private final Text multilineDisplay;
        private final Text measurer;
        private TextArea multilineEditor;
        private TextField singleLineEditor;
        private boolean updatingCheck;
        final /* synthetic */ ProductTreeManagerController this$0;

        PropertyValueCell(ProductTreeManagerController productTreeManagerController, TableColumn<PropertyRow, String> owner) {
            ProductTreeManagerController productTreeManagerController2 = productTreeManagerController;
            Objects.requireNonNull(productTreeManagerController2);
            this.this$0 = productTreeManagerController2;
            this.check = new CheckBox();
            this.multilineDisplay = new Text();
            this.measurer = new Text();
            this.owner = owner;
            this.setAlignment(Pos.CENTER_LEFT);
            this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            this.multilineDisplay.wrappingWidthProperty().bind((ObservableValue)owner.widthProperty().subtract(16));
            owner.widthProperty().addListener((o, ov, nv) -> {
                if (this.isEditing()) {
                    if (this.isCurrentMultiline()) {
                        this.adjustMultilineEditorHeight();
                    }
                } else if (this.isCurrentMultiline()) {
                    this.adjustMultilineDisplayHeight((String)this.getItem());
                }
            });
            this.check.selectedProperty().addListener((obs, oldV, newV) -> {
                if (this.updatingCheck) {
                    return;
                }
                PropertyRow row = this.getCurrentRow();
                if (!(row instanceof PropertyRowBoolean)) {
                    return;
                }
                PropertyRowBoolean b = (PropertyRowBoolean)row;
                b.booleanProperty().set(newV.booleanValue());
                productTreeManagerController.applyRowToDomain(b);
                productTreeManagerController.refreshSelectedNode();
                productTreeManagerController.markDirty();
            });
        }

        public void startEdit() {
            PropertyRow row = this.getCurrentRow();
            if (row == null || row instanceof PropertyRowBoolean) {
                return;
            }
            if (this.isTypeRow(row)) {
                return;
            }
            super.startEdit();
            if (!this.isEditing()) {
                return;
            }
            if (row.isMultiline()) {
                this.beginMultilineEdit();
            } else {
                this.beginSingleLineEdit();
            }
        }

        public void cancelEdit() {
            boolean multiline = this.isCurrentMultiline();
            super.cancelEdit();
            this.singleLineEditor = null;
            if (multiline) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.multilineDisplay.setText((String)this.getItem());
                this.adjustMultilineDisplayHeight((String)this.getItem());
                this.setGraphic((Node)this.multilineDisplay);
                this.setText(null);
            } else {
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                this.setGraphic(null);
                this.setText((String)this.getItem());
                this.resetRowHeight();
            }
        }

        public void commitEdit(String newValue) {
            boolean multiline = this.isCurrentMultiline();
            super.commitEdit((Object)(newValue == null ? "" : newValue));
            this.singleLineEditor = null;
            if (multiline) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.multilineDisplay.setText((String)this.getItem());
                this.adjustMultilineDisplayHeight((String)this.getItem());
                this.setGraphic((Node)this.multilineDisplay);
                this.setText(null);
            } else {
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                this.setGraphic(null);
                this.setText((String)this.getItem());
                this.resetRowHeight();
            }
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setGraphic(null);
                this.setText(null);
                this.setEditable(false);
                this.setDisable(false);
                this.resetRowHeight();
                return;
            }
            PropertyRow row = this.getCurrentRow();
            if (row == null) {
                this.setGraphic(null);
                this.setText(null);
                this.resetRowHeight();
                return;
            }
            if (row instanceof PropertyRowBoolean) {
                PropertyRowBoolean b = (PropertyRowBoolean)row;
                this.setEditable(false);
                this.setDisable(false);
                this.setAlignment(Pos.CENTER);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.updatingCheck = true;
                this.check.setSelected(b.booleanProperty().get());
                this.updatingCheck = false;
                this.setGraphic((Node)this.check);
                this.setText(null);
                this.resetRowHeight();
                return;
            }
            if (this.isTypeRow(row)) {
                this.setEditable(false);
                this.setDisable(true);
                this.setAlignment(Pos.CENTER_LEFT);
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                this.setGraphic(null);
                this.setText(item);
                this.resetRowHeight();
                return;
            }
            this.setEditable(true);
            this.setDisable(false);
            if (row.isMultiline()) {
                this.setAlignment(Pos.TOP_LEFT);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.multilineDisplay.setText(item == null ? "" : item);
                this.adjustMultilineDisplayHeight(item);
                this.setGraphic((Node)this.multilineDisplay);
                this.setText(null);
            } else {
                this.setAlignment(Pos.CENTER_LEFT);
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                this.setGraphic(null);
                this.setText(item);
                this.resetRowHeight();
            }
        }

        private void beginSingleLineEdit() {
            this.singleLineEditor = new TextField((String)this.getItem());
            this.singleLineEditor.setOnAction(e -> this.commitEdit(this.singleLineEditor.getText()));
            this.singleLineEditor.focusedProperty().addListener((obs, oldV, newV) -> {
                if (!newV.booleanValue()) {
                    this.commitEdit(this.singleLineEditor.getText());
                }
            });
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.setGraphic((Node)this.singleLineEditor);
            this.setText(null);
            this.singleLineEditor.requestFocus();
            this.singleLineEditor.selectAll();
        }

        private void beginMultilineEdit() {
            if (this.multilineEditor == null) {
                this.multilineEditor = new TextArea();
                this.multilineEditor.setWrapText(true);
                this.multilineEditor.setPrefRowCount(3);
                this.multilineEditor.setMinHeight(Double.NEGATIVE_INFINITY);
                this.multilineEditor.setMaxWidth(Double.MAX_VALUE);
                this.multilineEditor.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
                    if (e.getCode() == KeyCode.ESCAPE) {
                        this.cancelEdit();
                        e.consume();
                    } else if (e.getCode() == KeyCode.TAB) {
                        this.commitEdit(this.multilineEditor.getText());
                        e.consume();
                        this.moveSelection(e.isShiftDown() ? -1 : 1);
                    } else if (e.getCode() == KeyCode.ENTER && e.isControlDown()) {
                        this.commitEdit(this.multilineEditor.getText());
                        e.consume();
                    }
                });
                this.multilineEditor.addEventFilter(KeyEvent.KEY_TYPED, e -> {
                    if ("\t".equals(e.getCharacter())) {
                        e.consume();
                    }
                });
                this.multilineEditor.focusedProperty().addListener((obs, was, isNow) -> {
                    if (!isNow.booleanValue() && this.isEditing()) {
                        this.commitEdit(this.multilineEditor.getText());
                    }
                });
                this.multilineEditor.textProperty().addListener((obs, ov, nv) -> this.adjustMultilineEditorHeight());
            }
            this.multilineEditor.setText((String)this.getItem());
            this.adjustMultilineEditorHeight();
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.setGraphic((Node)this.multilineEditor);
            this.setText(null);
            Platform.runLater(() -> {
                this.multilineEditor.requestFocus();
                this.multilineEditor.positionCaret(this.multilineEditor.getText().length());
            });
        }

        private void adjustMultilineDisplayHeight(String value) {
            String text = value == null || value.isEmpty() ? " " : value;
            double wrap = Math.max(60.0, this.owner.getWidth() > 0.0 ? this.owner.getWidth() - 16.0 : 300.0);
            this.measurer.setWrappingWidth(wrap);
            this.measurer.setText(text + "\n");
            double h = Math.ceil(this.measurer.getLayoutBounds().getHeight());
            double target = Math.max(28.0, h);
            this.setPrefHeight(target + 2.0);
            this.setMinHeight(target + 2.0);
            if (this.getTableRow() != null) {
                this.getTableRow().setPrefHeight(target);
                this.getTableRow().requestLayout();
            }
        }

        private void adjustMultilineEditorHeight() {
            if (this.multilineEditor == null) {
                return;
            }
            String text = this.multilineEditor.getText();
            double colW = this.owner.getWidth() > 0.0 ? this.owner.getWidth() : 300.0;
            double wrap = Math.max(60.0, colW - 16.0);
            this.measurer.setWrappingWidth(wrap);
            this.measurer.setText((text == null || text.isEmpty() ? " " : text) + "\n");
            double textH = Math.ceil(this.measurer.getLayoutBounds().getHeight());
            double editorChrome = this.multilineEditor.snappedTopInset() + this.multilineEditor.snappedBottomInset();
            double cellChrome = this.snappedTopInset() + this.snappedBottomInset();
            double rowChrome = 0.0;
            if (this.getTableRow() != null) {
                rowChrome = this.getTableRow().snappedTopInset() + this.getTableRow().snappedBottomInset();
            }
            double editorH = Math.max(48.0, textH + editorChrome + 2.0);
            double cellH = editorH + cellChrome;
            double rowH = cellH + rowChrome;
            this.multilineEditor.setPrefWidth(wrap);
            this.multilineEditor.setPrefHeight(editorH);
            this.setPrefHeight(cellH);
            this.setMinHeight(cellH);
            if (this.getTableRow() != null) {
                this.getTableRow().setPrefHeight(rowH);
                this.getTableRow().setMinHeight(rowH);
                this.getTableRow().requestLayout();
            }
        }

        private void resetRowHeight() {
            this.setPrefHeight(-1.0);
            this.setMinHeight(-1.0);
            if (this.getTableRow() != null) {
                this.getTableRow().setPrefHeight(-1.0);
                this.getTableRow().requestLayout();
            }
        }

        private PropertyRow getCurrentRow() {
            TableRow tableRow = this.getTableRow();
            return tableRow == null ? null : (PropertyRow)tableRow.getItem();
        }

        private boolean isCurrentMultiline() {
            PropertyRow row = this.getCurrentRow();
            return row != null && row.isMultiline();
        }

        private boolean isTypeRow(PropertyRow row) {
            if (row == null) {
                return false;
            }
            String label = (String)row.labelProperty().get();
            return label != null && label.equalsIgnoreCase("Type");
        }

        private void moveSelection(int step) {
            int max;
            if (this.this$0.tblDetails == null || this.this$0.colValue == null) {
                return;
            }
            int row = this.getIndex();
            if (row < 0) {
                return;
            }
            int n = max = this.this$0.tblDetails.getItems() == null ? -1 : this.this$0.tblDetails.getItems().size() - 1;
            if (max < 0) {
                return;
            }
            int target = row + step;
            if (target < 0) {
                target = 0;
            }
            if (target > max) {
                target = max;
            }
            this.this$0.tblDetails.getSelectionModel().select(target, this.this$0.colValue);
            this.this$0.tblDetails.scrollTo(target);
            this.this$0.tblDetails.edit(target, this.this$0.colValue);
        }
    }
}

