/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers;

import com.qualidadeeprodutividade.controllers.util.DragDropStyler;
import com.qualidadeeprodutividade.item.Characteristic;
import com.qualidadeeprodutividade.item.Item;
import com.qualidadeeprodutividade.item.ItemType;
import com.qualidadeeprodutividade.item.StructureCloner;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;

public class StructureExchangeController {
    @FXML
    private AnchorPane root;
    @FXML
    private TreeView<Object> treeProductOrigin;
    @FXML
    private TreeView<Object> treeProductDestination;
    @FXML
    private Label lblDestinationProduct;
    @FXML
    private Button btnSaveOnly;
    @FXML
    private Button btnSaveExit;
    private Image icSave;
    private Image icExit;
    private Stage owner;
    private Item destinationRoot;
    private List<Item> availableProducts = List.of();
    private Runnable saveAction;
    private Runnable changeHook = () -> {};
    private static final String DND_MARKER = "STRUCTURE_EXCHANGE_NODE";
    private static final PseudoClass DND_TARGET = PseudoClass.getPseudoClass((String)"drag-target");
    private Object dragPayload;
    private TreeCell<Object> highlightedCell;
    private Image icProduct;
    private Image icSystem;
    private Image icPart;
    private Image icChar;

    @FXML
    private void initialize() {
        this.loadIcons();
        this.configureTrees();
        this.configureButtons();
        this.rebuildOriginTree();
        this.rebuildDestinationTree();
        this.updateDestinationLabel();
    }

    public void setOwnerStage(Stage stage) {
        this.owner = stage;
    }

    public void setSaveAction(Runnable saveAction) {
        this.saveAction = saveAction;
    }

    public void setDestinationProduct(Item root) {
        this.destinationRoot = root;
        this.rebuildDestinationTree();
        this.updateDestinationLabel();
    }

    public void setAvailableProducts(List<Item> products) {
        if (products == null || products.isEmpty()) {
            this.availableProducts = List.of();
        } else {
            ArrayList<Item> copy = new ArrayList<Item>();
            for (Item product : products) {
                if (product == null) continue;
                copy.add(product);
            }
            this.availableProducts = List.copyOf(copy);
        }
        this.rebuildOriginTree();
    }

    public void setChangeHook(Runnable hook) {
        this.changeHook = hook == null ? () -> {} : hook;
    }

    private void configureButtons() {
        if (this.btnSaveOnly != null) {
            this.btnSaveOnly.setTooltip(new Tooltip("Salvar e continuar editando"));
            this.btnSaveOnly.setOnAction(e -> this.onSaveOnly());
            this.btnSaveOnly.setGraphic((Node)this.icon20(this.icSave));
        }
        if (this.btnSaveExit != null) {
            this.btnSaveExit.setTooltip(new Tooltip("Salvar e fechar"));
            this.btnSaveExit.setOnAction(e -> this.onSaveAndExit());
            this.btnSaveExit.setGraphic((Node)this.icon20(this.icExit));
        }
    }

    private void configureTrees() {
        if (this.treeProductOrigin != null) {
            this.treeProductOrigin.setShowRoot(false);
            DragDropStyler.ensure(this.treeProductOrigin);
            this.treeProductOrigin.setCellFactory(tv -> this.createOriginCell());
        }
        if (this.treeProductDestination != null) {
            this.treeProductDestination.setShowRoot(true);
            DragDropStyler.ensure(this.treeProductDestination);
            this.treeProductDestination.setCellFactory(tv -> this.createDestinationCell());
            this.treeProductDestination.setOnDragOver(event -> {
                Item item;
                Object patt0$temp;
                if (!this.isValidDrag(event.getDragboard())) {
                    return;
                }
                TreeItem rootItem = this.treeProductDestination.getRoot();
                if (rootItem != null && (patt0$temp = rootItem.getValue()) instanceof Item && this.canAccept(item = (Item)patt0$temp, this.dragPayload)) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                }
                event.consume();
            });
            this.treeProductDestination.setOnDragDropped(event -> {
                TreeItem rootItem;
                boolean success = false;
                if (this.isValidDrag(event.getDragboard()) && (rootItem = this.treeProductDestination.getRoot()) != null) {
                    success = this.handleDrop((TreeItem<Object>)rootItem);
                }
                event.setDropCompleted(success);
                this.clearDropHighlight();
                event.consume();
            });
        }
    }

    private TreeCell<Object> createOriginCell() {
        TreeCell<Object> cell = new TreeCell<Object>(this){
            final /* synthetic */ StructureExchangeController this$0;
            {
                StructureExchangeController structureExchangeController = this$0;
                Objects.requireNonNull(structureExchangeController);
                this.this$0 = structureExchangeController;
            }

            protected void updateItem(Object value, boolean empty) {
                super.updateItem(value, empty);
                this.this$0.updateCellDisplay(this, value, empty);
            }
        };
        cell.setOnDragDetected(arg_0 -> this.lambda$createOriginCell$0((TreeCell)cell, arg_0));
        cell.setOnDragDone(event -> {
            this.dragPayload = null;
            event.consume();
        });
        return cell;
    }

    private TreeCell<Object> createDestinationCell() {
        TreeCell<Object> cell = new TreeCell<Object>(this){
            final /* synthetic */ StructureExchangeController this$0;
            {
                StructureExchangeController structureExchangeController = this$0;
                Objects.requireNonNull(structureExchangeController);
                this.this$0 = structureExchangeController;
            }

            protected void updateItem(Object value, boolean empty) {
                super.updateItem(value, empty);
                this.this$0.updateCellDisplay(this, value, empty);
            }
        };
        cell.setOnDragOver(arg_0 -> this.lambda$createDestinationCell$0((TreeCell)cell, arg_0));
        cell.setOnDragDropped(arg_0 -> this.lambda$createDestinationCell$1((TreeCell)cell, arg_0));
        cell.setOnDragExited(arg_0 -> this.lambda$createDestinationCell$2((TreeCell)cell, arg_0));
        return cell;
    }

    private TreeItem<Object> resolveDropTarget(TreeItem<Object> candidate) {
        TreeItem current;
        for (current = candidate; current != null && !(current.getValue() instanceof Item); current = current.getParent()) {
        }
        return current;
    }

    private boolean isValidDrag(Dragboard db) {
        return this.dragPayload != null && db != null && db.hasString() && DND_MARKER.equals(db.getString());
    }

    private boolean handleDrop(TreeItem<Object> target) {
        Item destination;
        block11: {
            block10: {
                Object object;
                if (target == null || !((object = target.getValue()) instanceof Item)) break block10;
                destination = (Item)object;
                if (this.dragPayload != null) break block11;
            }
            return false;
        }
        if (!this.canAccept(destination, this.dragPayload)) {
            return false;
        }
        Object object = this.dragPayload;
        if (object instanceof Item) {
            Item sourceItem = (Item)object;
            clone = StructureCloner.cloneItem(sourceItem);
            if (clone == null) {
                return false;
            }
            destination.addChild((Item)clone);
            target.getChildren().add(this.buildTree(clone));
        } else {
            clone = this.dragPayload;
            if (clone instanceof Characteristic) {
                Characteristic sourceChar = (Characteristic)clone;
                if ((clone = StructureCloner.cloneCharacteristic(sourceChar)) == null) {
                    return false;
                }
                destination.addCharacteristic((Characteristic)clone);
                target.getChildren().add((Object)new TreeItem(clone));
            } else {
                return false;
            }
        }
        target.setExpanded(true);
        this.notifyStructureChange();
        return true;
    }

    private boolean isDraggable(Object value) {
        if (value instanceof Characteristic) {
            return true;
        }
        if (value instanceof Item) {
            Item item = (Item)value;
            ItemType type = this.normalizedType(item);
            return type == ItemType.SYSTEM || type == ItemType.PART;
        }
        return false;
    }

    private boolean canAccept(Item destination, Object payload) {
        if (destination == null || payload == null) {
            return false;
        }
        ItemType destType = this.normalizedType(destination);
        if (payload instanceof Item) {
            Item sourceItem = (Item)payload;
            ItemType sourceType = this.normalizedType(sourceItem);
            if (sourceType == ItemType.SYSTEM || sourceType == ItemType.PART) {
                return destType == ItemType.PRODUCT || destType == ItemType.SYSTEM;
            }
            return false;
        }
        if (payload instanceof Characteristic) {
            return destType == ItemType.PRODUCT || destType == ItemType.SYSTEM || destType == ItemType.PART;
        }
        return false;
    }

    private ItemType normalizedType(Item item) {
        if (item == null) {
            return ItemType.PART;
        }
        if (item == this.destinationRoot) {
            return ItemType.PRODUCT;
        }
        ItemType type = item.getType();
        return type == null ? ItemType.PART : type;
    }

    private void showDropTarget(TreeCell<Object> cell) {
        if (cell == null) {
            return;
        }
        if (this.highlightedCell != cell) {
            this.clearDropHighlight();
            this.highlightedCell = cell;
            cell.pseudoClassStateChanged(DND_TARGET, true);
        }
    }

    private void clearDropHighlight(TreeCell<Object> cell) {
        if (cell != null) {
            cell.pseudoClassStateChanged(DND_TARGET, false);
            if (cell == this.highlightedCell) {
                this.highlightedCell = null;
            }
        }
    }

    private void clearDropHighlight() {
        if (this.highlightedCell != null) {
            this.highlightedCell.pseudoClassStateChanged(DND_TARGET, false);
            this.highlightedCell = null;
        }
    }

    private void notifyStructureChange() {
        if (this.treeProductDestination != null) {
            this.treeProductDestination.refresh();
        }
        if (this.changeHook != null) {
            this.changeHook.run();
        }
    }

    private void rebuildOriginTree() {
        if (this.treeProductOrigin == null) {
            return;
        }
        if (this.availableProducts == null || this.availableProducts.isEmpty()) {
            this.treeProductOrigin.setRoot(null);
            return;
        }
        TreeItem pseudoRoot = new TreeItem((Object)"root");
        for (Item product : this.availableProducts) {
            pseudoRoot.getChildren().add(this.buildTree(product));
        }
        pseudoRoot.setExpanded(true);
        this.treeProductOrigin.setRoot(pseudoRoot);
    }

    private void rebuildDestinationTree() {
        if (this.treeProductDestination == null) {
            return;
        }
        if (this.destinationRoot == null) {
            this.treeProductDestination.setRoot(null);
            return;
        }
        TreeItem<Object> rootItem = this.buildTree(this.destinationRoot);
        rootItem.setExpanded(true);
        this.treeProductDestination.setRoot(rootItem);
    }

    private TreeItem<Object> buildTree(Object value) {
        TreeItem ti = new TreeItem(value);
        if (value instanceof Item) {
            Item item = (Item)value;
            if (item.getChildren() != null) {
                for (Item child : item.getChildren()) {
                    ti.getChildren().add(this.buildTree(child));
                }
            }
            if (item.getCharacteristics() != null) {
                for (Characteristic ch : item.getCharacteristics()) {
                    ti.getChildren().add((Object)new TreeItem((Object)ch));
                }
            }
        }
        return ti;
    }

    private void updateCellDisplay(TreeCell<Object> cell, Object value, boolean empty) {
        if (empty || value == null) {
            cell.setText(null);
            cell.setGraphic(null);
            return;
        }
        if (value instanceof Item) {
            Item item = (Item)value;
            cell.setText(this.safe(item.getDescription()));
            ItemType type = this.normalizedType(item);
            Image icon = switch (type) {
                default -> throw new MatchException(null, null);
                case ItemType.PRODUCT -> this.icProduct;
                case ItemType.SYSTEM -> this.icSystem;
                case ItemType.PART -> this.icPart;
            };
            cell.setGraphic((Node)(icon == null ? null : new ImageView(icon)));
        } else if (value instanceof Characteristic) {
            Characteristic ch = (Characteristic)value;
            cell.setText(this.safe(ch.getDescription()));
            cell.setGraphic((Node)(this.icChar == null ? null : new ImageView(this.icChar)));
        } else if (value instanceof String) {
            String s = (String)value;
            cell.setText(s);
            cell.setGraphic(null);
        } else {
            cell.setText(String.valueOf(value));
            cell.setGraphic(null);
        }
    }

    private void loadIcons() {
        this.icProduct = this.loadIcon("mainProduct");
        this.icSystem = this.loadIcon("system");
        this.icPart = this.loadIcon("part");
        this.icChar = this.loadIcon("characteristic");
        this.icSave = this.loadIcon("save");
        this.icExit = this.loadIcon("exit");
    }

    private Image loadIcon(String name) {
        InputStream stream = this.getClass().getResourceAsStream("/icons/" + name + ".png");
        if (stream == null) {
            return null;
        }
        return new Image(stream, 32.0, 32.0, true, true);
    }

    private ImageView icon20(Image img) {
        if (img == null) {
            return null;
        }
        ImageView iv = new ImageView(img);
        iv.setPreserveRatio(true);
        iv.setFitWidth(20.0);
        iv.setFitHeight(20.0);
        iv.setSmooth(true);
        return iv;
    }

    private void updateDestinationLabel() {
        if (this.lblDestinationProduct == null) {
            return;
        }
        if (this.destinationRoot == null) {
            this.lblDestinationProduct.setText("Produto de destino n\u00e3o selecionado");
        } else {
            this.lblDestinationProduct.setText("Destino: " + this.safe(this.destinationRoot.getDescription()));
        }
    }

    private void onSaveOnly() {
        if (!this.ensureEditPermission()) {
            return;
        }
        this.performSave();
    }

    private void onSaveAndExit() {
        if (!this.ensureEditPermission()) {
            return;
        }
        if (this.performSave()) {
            this.closeWindow();
        }
    }

    private boolean performSave() {
        try {
            if (this.saveAction != null) {
                this.saveAction.run();
            }
            return true;
        }
        catch (Exception ex) {
            new Alert(Alert.AlertType.ERROR, "Falha ao salvar:\n" + ex.getMessage(), new ButtonType[0]).showAndWait();
            return false;
        }
    }

    private boolean ensureEditPermission() {
        return true;
    }

    private void closeWindow() {
        Stage stage = this.owner;
        if (stage == null && this.root != null && this.root.getScene() != null) {
            stage = (Stage)this.root.getScene().getWindow();
        }
        if (stage != null) {
            stage.close();
        }
    }

    private String safe(String value) {
        return value == null || value.isBlank() ? "(sem descri\u00e7\u00e3o)" : value;
    }

    private /* synthetic */ void lambda$createDestinationCell$2(TreeCell cell, DragEvent event) {
        this.clearDropHighlight((TreeCell<Object>)cell);
    }

    private /* synthetic */ void lambda$createDestinationCell$1(TreeCell cell, DragEvent event) {
        TreeItem<Object> target;
        boolean success = false;
        if (this.isValidDrag(event.getDragboard()) && (target = this.resolveDropTarget((TreeItem<Object>)cell.getTreeItem())) != null) {
            success = this.handleDrop(target);
        }
        event.setDropCompleted(success);
        this.dragPayload = null;
        this.clearDropHighlight((TreeCell<Object>)cell);
        event.consume();
    }

    private /* synthetic */ void lambda$createDestinationCell$0(TreeCell cell, DragEvent event) {
        Item item;
        Object patt0$temp;
        if (!this.isValidDrag(event.getDragboard())) {
            return;
        }
        TreeItem<Object> target = this.resolveDropTarget((TreeItem<Object>)cell.getTreeItem());
        if (target != null && (patt0$temp = target.getValue()) instanceof Item && this.canAccept(item = (Item)patt0$temp, this.dragPayload)) {
            this.showDropTarget((TreeCell<Object>)cell);
            event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
        } else {
            this.clearDropHighlight((TreeCell<Object>)cell);
        }
        event.consume();
    }

    private /* synthetic */ void lambda$createOriginCell$0(TreeCell cell, MouseEvent event) {
        if (cell.isEmpty()) {
            return;
        }
        Object value = cell.getItem();
        if (!this.isDraggable(value)) {
            return;
        }
        this.dragPayload = value;
        Dragboard db = cell.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
        ClipboardContent content = new ClipboardContent();
        content.putString(DND_MARKER);
        db.setContent((Map)content);
        event.consume();
    }
}

