/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers.util;

import com.qualidadeeprodutividade.controlPlan.ControlPlan;
import com.qualidadeeprodutividade.controlPlan.ControlPlanRow;
import com.qualidadeeprodutividade.eightd.EightD;
import com.qualidadeeprodutividade.fmea.Dfmea;
import com.qualidadeeprodutividade.fmea.Pfmea;
import com.qualidadeeprodutividade.io.mapper.ProjectMapper;
import com.qualidadeeprodutividade.item.Characteristic;
import com.qualidadeeprodutividade.item.Item;
import com.qualidadeeprodutividade.processItem.Parameter;
import com.qualidadeeprodutividade.processItem.ProcessItem;
import com.qualidadeeprodutividade.project.Project;
import java.util.UUID;

public final class DocumentCloneUtils {
    private DocumentCloneUtils() {
    }

    public static Item cloneItem(Item original) {
        if (original == null) {
            return null;
        }
        Project temp = new Project();
        temp.addProductTree(original);
        Project clonedProject = ProjectMapper.fromDto(ProjectMapper.toDto(temp));
        if (clonedProject.getProductTrees().isEmpty()) {
            return null;
        }
        Item copy = (Item)clonedProject.getProductTrees().get(0);
        DocumentCloneUtils.resetItemGraphIds(copy);
        copy.setDescription(DocumentCloneUtils.withCopySuffix(copy.getDescription()));
        return copy;
    }

    public static ProcessItem cloneProcessItem(ProcessItem original) {
        if (original == null) {
            return null;
        }
        Project temp = new Project();
        temp.addProcessTree(original);
        Project clonedProject = ProjectMapper.fromDto(ProjectMapper.toDto(temp));
        if (clonedProject.getProcessTrees().isEmpty()) {
            return null;
        }
        ProcessItem copy = (ProcessItem)clonedProject.getProcessTrees().get(0);
        DocumentCloneUtils.resetProcessItemGraphIds(copy);
        copy.setDescription(DocumentCloneUtils.withCopySuffix(copy.getDescription()));
        return copy;
    }

    public static Dfmea cloneDfmea(Dfmea original) {
        if (original == null) {
            return null;
        }
        Project temp = new Project();
        temp.getDfmeas().add((Object)original);
        Project clonedProject = ProjectMapper.fromDto(ProjectMapper.toDto(temp));
        if (clonedProject.getDfmeas().isEmpty()) {
            return null;
        }
        Dfmea copy = (Dfmea)clonedProject.getDfmeas().get(0);
        copy.setDfmeaSubject(DocumentCloneUtils.withCopySuffix(copy.getDfmeaSubject()));
        copy.setAssociatedProduct(original.getAssociatedProduct());
        return copy;
    }

    public static Pfmea clonePfmea(Pfmea original) {
        if (original == null) {
            return null;
        }
        Project temp = new Project();
        temp.getPfmeas().add((Object)original);
        Project clonedProject = ProjectMapper.fromDto(ProjectMapper.toDto(temp));
        if (clonedProject.getPfmeas().isEmpty()) {
            return null;
        }
        Pfmea copy = (Pfmea)clonedProject.getPfmeas().get(0);
        copy.setPfmeaSubject(DocumentCloneUtils.withCopySuffix(copy.getPfmeaSubject()));
        return copy;
    }

    public static ControlPlan cloneControlPlan(ControlPlan original) {
        if (original == null) {
            return null;
        }
        Project temp = new Project();
        temp.getControlPlans().add((Object)original);
        Project clonedProject = ProjectMapper.fromDto(ProjectMapper.toDto(temp));
        if (clonedProject.getControlPlans().isEmpty()) {
            return null;
        }
        ControlPlan copy = (ControlPlan)clonedProject.getControlPlans().get(0);
        copy.setCpPartNumber(DocumentCloneUtils.withCopySuffix(copy.getCpPartNumber()));
        DocumentCloneUtils.resetControlPlanRowIds(copy);
        return copy;
    }

    public static EightD cloneEightD(EightD original) {
        if (original == null) {
            return null;
        }
        Project temp = new Project();
        temp.getEightDReports().add((Object)original);
        Project clonedProject = ProjectMapper.fromDto(ProjectMapper.toDto(temp));
        if (clonedProject.getEightDReports().isEmpty()) {
            return null;
        }
        EightD copy = (EightD)clonedProject.getEightDReports().get(0);
        if (copy.getInternalClaimNumber() != null && !copy.getInternalClaimNumber().isBlank()) {
            copy.setInternalClaimNumber(DocumentCloneUtils.withCopySuffix(copy.getInternalClaimNumber()));
        } else if (copy.getCustomerClaimNumber() != null && !copy.getCustomerClaimNumber().isBlank()) {
            copy.setCustomerClaimNumber(DocumentCloneUtils.withCopySuffix(copy.getCustomerClaimNumber()));
        } else if (copy.getPartNumber() != null && !copy.getPartNumber().isBlank()) {
            copy.setPartNumber(DocumentCloneUtils.withCopySuffix(copy.getPartNumber()));
        }
        return copy;
    }

    private static void resetItemGraphIds(Item item) {
        if (item == null) {
            return;
        }
        item.setId(null);
        for (Characteristic characteristic : item.getCharacteristics()) {
            characteristic.setId(null);
        }
        for (Item child : item.getChildren()) {
            DocumentCloneUtils.resetItemGraphIds(child);
        }
    }

    private static void resetProcessItemGraphIds(ProcessItem item) {
        if (item == null) {
            return;
        }
        item.setId(null);
        for (Parameter parameter : item.getParameters()) {
            parameter.setId(null);
        }
        for (ProcessItem child : item.getChildren()) {
            DocumentCloneUtils.resetProcessItemGraphIds(child);
        }
    }

    private static void resetControlPlanRowIds(ControlPlan controlPlan) {
        if (controlPlan == null) {
            return;
        }
        for (ControlPlanRow row : controlPlan.getControlChains()) {
            row.setId(UUID.randomUUID());
        }
    }

    private static String withCopySuffix(String value) {
        String base = DocumentCloneUtils.safe(value);
        if (base.endsWith(" (copy)")) {
            return base;
        }
        return base + " (copy)";
    }

    private static String safe(String value) {
        return value == null ? "" : value;
    }
}

