/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public final class MentionSuggestionBehavior<T> {
    private static final String INSTALLED_KEY = MentionSuggestionBehavior.class.getName() + ".installed";
    private final TextInputControl control;
    private final ContextMenu menu;
    private final Config<T> config;
    private List<T> lastSuggestions = Collections.emptyList();
    private boolean updatingText = false;

    public static <T> Config<T> config() {
        return new Config();
    }

    public static boolean isDefaultMentionChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_' || ch == '-';
    }

    public static int[] findMentionSpan(String text, int caret, Predicate<Character> allowedQueryChar) {
        char ch;
        int start;
        if (text == null || text.isEmpty()) {
            return null;
        }
        int c = Math.max(0, Math.min(caret, text.length()));
        if (c == 0) {
            return null;
        }
        Predicate<Character> allow = allowedQueryChar != null ? allowedQueryChar : MentionSuggestionBehavior::isDefaultMentionChar;
        for (start = c - 1; start >= 0 && (ch = text.charAt(start)) != '@'; --start) {
            if (allow.test(Character.valueOf(ch))) continue;
            return null;
        }
        if (start < 0 || text.charAt(start) != '@') {
            return null;
        }
        return new int[]{start, c};
    }

    public static <T> MentionSuggestionBehavior<T> install(TextInputControl control, ContextMenu menu, Config<T> config) {
        Objects.requireNonNull(control, "control");
        Objects.requireNonNull(menu, "menu");
        Objects.requireNonNull(config, "config");
        Object installed = control.getProperties().get((Object)INSTALLED_KEY);
        if (installed instanceof MentionSuggestionBehavior) {
            MentionSuggestionBehavior existing = (MentionSuggestionBehavior)installed;
            return existing;
        }
        MentionSuggestionBehavior<T> behavior = new MentionSuggestionBehavior<T>(control, menu, config);
        control.getProperties().put((Object)INSTALLED_KEY, behavior);
        return behavior;
    }

    private static <T> void defaultMenuBuilder(ContextMenu menu, List<T> suggestions, Consumer<T> onChoose) {
        menu.getItems().clear();
        for (Object suggestion : suggestions) {
            MenuItem item = new MenuItem(String.valueOf(suggestion));
            item.setMnemonicParsing(false);
            item.setOnAction(e -> onChoose.accept(suggestion));
            menu.getItems().add((Object)item);
        }
    }

    private MentionSuggestionBehavior(TextInputControl control, ContextMenu menu, Config<T> config) {
        this.control = control;
        this.menu = menu;
        this.config = config;
        this.menu.setAutoHide(true);
        this.menu.setHideOnEscape(true);
        this.control.textProperty().addListener((o, ov, nv) -> this.maybeShow());
        this.control.caretPositionProperty().addListener((o, ov, nv) -> this.maybeShow());
        this.control.focusedProperty().addListener((o, was, isNow) -> {
            if (!isNow.booleanValue()) {
                this.hide();
            }
        });
        if (config.acceptFirstOnEnterOrTab) {
            this.control.addEventFilter(KeyEvent.KEY_PRESSED, this::handleAcceptKeys);
        }
    }

    private void handleAcceptKeys(KeyEvent event) {
        boolean accept;
        if (event.isConsumed()) {
            return;
        }
        if (!this.menu.isShowing()) {
            return;
        }
        if (event.getCode() == KeyCode.ESCAPE) {
            this.hide();
            event.consume();
            return;
        }
        boolean bl = accept = event.getCode() == KeyCode.ENTER && !event.isControlDown() || event.getCode() == KeyCode.TAB;
        if (!accept) {
            return;
        }
        if (this.lastSuggestions.isEmpty()) {
            return;
        }
        if (this.choose(this.lastSuggestions.get(0))) {
            event.consume();
        }
    }

    private void maybeShow() {
        int caret;
        if (this.updatingText) {
            return;
        }
        String text = this.control.getText();
        int[] span = MentionSuggestionBehavior.findMentionSpan(text, caret = this.control.getCaretPosition(), this.config.allowedQueryChar);
        if (span == null) {
            this.hide();
            return;
        }
        String rawQuery = text.substring(Math.min(span[0] + 1, span[1]), span[1]);
        String query = this.config.trimQuery ? rawQuery.trim() : rawQuery;
        List suggestions = this.config.suggestions.apply(query);
        if (suggestions == null || suggestions.isEmpty()) {
            this.hide();
            return;
        }
        this.lastSuggestions = new ArrayList(suggestions);
        this.config.menuBuilder.build(this.menu, this.lastSuggestions, this::choose);
        this.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean choose(T chosen) {
        int caret;
        if (chosen == null) {
            return false;
        }
        String text = this.control.getText();
        int[] span = MentionSuggestionBehavior.findMentionSpan(text, caret = this.control.getCaretPosition(), this.config.allowedQueryChar);
        if (span == null) {
            this.hide();
            return false;
        }
        String insert = this.config.insertionText.apply(chosen);
        if (insert == null) {
            insert = "";
        }
        String before = text.substring(0, span[0]);
        String after = text.substring(span[1]);
        String newText = before + insert + after;
        int newCaret = before.length() + insert.length();
        this.updatingText = true;
        try {
            this.control.setText(newText);
            this.control.positionCaret(newCaret);
        }
        finally {
            this.updatingText = false;
        }
        this.hide();
        if (this.config.afterInsert != null) {
            InsertContext ctx = new InsertContext(this.control, text, newText, span[0], span[1], caret, newCaret);
            this.config.afterInsert.accept(ctx, (InsertContext)chosen);
        }
        Platform.runLater(() -> ((TextInputControl)this.control).requestFocus());
        return true;
    }

    private void show() {
        if (this.menu.isShowing()) {
            return;
        }
        Point2D point = this.control.localToScreen(0.0, this.control.getHeight());
        if (point != null) {
            this.menu.show((Node)this.control, point.getX(), point.getY());
        } else {
            this.menu.show((Node)this.control, Side.BOTTOM, 0.0, 0.0);
        }
    }

    private void hide() {
        this.lastSuggestions = Collections.emptyList();
        this.menu.hide();
    }

    public static final class Config<T> {
        private Predicate<Character> allowedQueryChar = MentionSuggestionBehavior::isDefaultMentionChar;
        private boolean trimQuery = true;
        private Function<String, List<T>> suggestions = q -> Collections.emptyList();
        private MenuBuilder<T> menuBuilder = MentionSuggestionBehavior::defaultMenuBuilder;
        private Function<T, String> insertionText = obj -> obj == null ? "" : obj.toString();
        private BiConsumer<InsertContext, T> afterInsert;
        private boolean acceptFirstOnEnterOrTab = false;

        public Config<T> allowedQueryChar(Predicate<Character> allowedQueryChar) {
            this.allowedQueryChar = allowedQueryChar;
            return this;
        }

        public Config<T> trimQuery(boolean trimQuery) {
            this.trimQuery = trimQuery;
            return this;
        }

        public Config<T> suggestions(Function<String, List<T>> suggestions) {
            this.suggestions = suggestions;
            return this;
        }

        public Config<T> menuBuilder(MenuBuilder<T> menuBuilder) {
            this.menuBuilder = menuBuilder;
            return this;
        }

        public Config<T> insertionText(Function<T, String> insertionText) {
            this.insertionText = insertionText;
            return this;
        }

        public Config<T> afterInsert(BiConsumer<InsertContext, T> afterInsert) {
            this.afterInsert = afterInsert;
            return this;
        }

        public Config<T> acceptFirstOnEnterOrTab(boolean accept) {
            this.acceptFirstOnEnterOrTab = accept;
            return this;
        }
    }

    @FunctionalInterface
    public static interface MenuBuilder<T> {
        public void build(ContextMenu var1, List<T> var2, Consumer<T> var3);
    }

    public static final class InsertContext {
        private final TextInputControl control;
        private final String oldText;
        private final String newText;
        private final int spanStart;
        private final int spanEnd;
        private final int oldCaret;
        private final int newCaret;

        private InsertContext(TextInputControl control, String oldText, String newText, int spanStart, int spanEnd, int oldCaret, int newCaret) {
            this.control = control;
            this.oldText = oldText;
            this.newText = newText;
            this.spanStart = spanStart;
            this.spanEnd = spanEnd;
            this.oldCaret = oldCaret;
            this.newCaret = newCaret;
        }

        public TextInputControl control() {
            return this.control;
        }

        public String oldText() {
            return this.oldText;
        }

        public String newText() {
            return this.newText;
        }

        public int spanStart() {
            return this.spanStart;
        }

        public int spanEnd() {
            return this.spanEnd;
        }

        public int oldCaret() {
            return this.oldCaret;
        }

        public int newCaret() {
            return this.newCaret;
        }
    }
}

