/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;

public final class TableClipboardHelper {
    private static final KeyCodeCombination COPY = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
    private static final KeyCodeCombination PASTE = new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
    private static final Object UNPARSEABLE = new Object();
    private static final List<DateTimeFormatter> DATE_FORMATS = List.of(DateTimeFormatter.ISO_LOCAL_DATE, DateTimeFormatter.ofPattern("dd/MM/yyyy"), DateTimeFormatter.ofPattern("dd-MM-yyyy"), DateTimeFormatter.ofPattern("dd.MM.yyyy"));

    private TableClipboardHelper() {
    }

    public static void install(TableView<?> table, Runnable onPaste) {
        if (table == null) {
            return;
        }
        table.addEventFilter(KeyEvent.KEY_PRESSED, e -> TableClipboardHelper.handleKeyPressed(table, onPaste, e));
    }

    private static void handleKeyPressed(TableView<?> table, Runnable onPaste, KeyEvent event) {
        if (COPY.match(event)) {
            if (!TableClipboardHelper.copySelection(table)) {
                TableClipboardHelper.copyFocusedCell(table);
            }
            event.consume();
            return;
        }
        if (PASTE.match(event)) {
            if (TableClipboardHelper.pasteIntoTable(table) && onPaste != null) {
                onPaste.run();
            }
            event.consume();
        }
    }

    private static boolean copySelection(TableView<?> table) {
        if (table == null || table.getSelectionModel() == null) {
            return false;
        }
        ObservableList selectedCells = table.getSelectionModel().getSelectedCells();
        if (selectedCells == null || selectedCells.isEmpty()) {
            return false;
        }
        ArrayList visibleColumns = new ArrayList(TableClipboardHelper.visibleLeafColumns(table));
        if (visibleColumns.isEmpty()) {
            return false;
        }
        int minRow = Integer.MAX_VALUE;
        int maxRow = Integer.MIN_VALUE;
        int minCol = Integer.MAX_VALUE;
        int maxCol = Integer.MIN_VALUE;
        for (TablePosition position : selectedCells) {
            if (position == null || position.getTableColumn() == null) continue;
            minRow = Math.min(minRow, position.getRow());
            maxRow = Math.max(maxRow, position.getRow());
            int columnIndex = TableClipboardHelper.visibleLeafIndex(table, position.getTableColumn());
            if (columnIndex < 0) continue;
            minCol = Math.min(minCol, columnIndex);
            maxCol = Math.max(maxCol, columnIndex);
        }
        if (minRow == Integer.MAX_VALUE || minCol == Integer.MAX_VALUE) {
            return false;
        }
        ObservableList items = table.getItems();
        if (items == null || items.isEmpty()) {
            return false;
        }
        StringBuilder buffer = new StringBuilder();
        for (int row = minRow; row <= maxRow; ++row) {
            if (row < 0 || row >= items.size()) continue;
            for (int col = minCol; col <= maxCol; ++col) {
                if (col < 0 || col >= visibleColumns.size()) continue;
                TableColumn column = (TableColumn)visibleColumns.get(col);
                Object value = column.getCellData(row);
                buffer.append(TableClipboardHelper.encodeCellValue(value));
                if (col >= maxCol) continue;
                buffer.append('\t');
            }
            if (row >= maxRow) continue;
            buffer.append('\n');
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(buffer.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
        return true;
    }

    public static boolean clearFocusedCell(TableView<?> table) {
        return TableClipboardHelper.clearFocusedCell(table, null);
    }

    public static boolean clearFocusedCell(TableView<?> table, Consumer<Runnable> undoRecorder) {
        if (table == null) {
            return false;
        }
        TablePosition<?, ?> position = TableClipboardHelper.getFocusedCell(table);
        if (position == null) {
            return false;
        }
        int rowIndex = position.getRow();
        TableColumn column = position.getTableColumn();
        if (rowIndex < 0 || column == null || !column.isEditable()) {
            return false;
        }
        return TableClipboardHelper.clearCellValue(table, column, rowIndex, undoRecorder);
    }

    private static boolean copyFocusedCell(TableView<?> table) {
        TablePosition<?, ?> position = TableClipboardHelper.getFocusedCell(table);
        if (position == null) {
            return false;
        }
        TableColumn column = position.getTableColumn();
        if (column == null) {
            return false;
        }
        Object value = column.getCellData(position.getRow());
        String text = TableClipboardHelper.encodeCellValue(value);
        ClipboardContent content = new ClipboardContent();
        content.putString(text);
        Clipboard.getSystemClipboard().setContent((Map)content);
        return true;
    }

    private static boolean pasteIntoTable(TableView<?> table) {
        int targetRow;
        TablePosition<?, ?> position = TableClipboardHelper.getFocusedCell(table);
        if (position == null) {
            return false;
        }
        TableColumn column = position.getTableColumn();
        if (column == null) {
            return false;
        }
        ObservableList items = table.getItems();
        int rowIndex = position.getRow();
        if (rowIndex < 0 || rowIndex >= items.size()) {
            return false;
        }
        String rawText = Clipboard.getSystemClipboard().getString();
        if (rawText == null) {
            return false;
        }
        List<String[]> matrix = TableClipboardHelper.parseClipboardMatrix(rawText);
        if (matrix.isEmpty()) {
            return false;
        }
        ArrayList visibleColumns = new ArrayList(TableClipboardHelper.visibleLeafColumns(table));
        if (visibleColumns.isEmpty()) {
            return false;
        }
        int startColumn = TableClipboardHelper.visibleLeafIndex(table, column);
        if (startColumn < 0) {
            startColumn = 0;
        }
        boolean changed = false;
        for (int rowOffset = 0; rowOffset < matrix.size() && (targetRow = rowIndex + rowOffset) < items.size(); ++rowOffset) {
            int targetColIndex;
            String[] tokens = matrix.get(rowOffset);
            for (int colOffset = 0; colOffset < tokens.length && (targetColIndex = startColumn + colOffset) < visibleColumns.size(); ++colOffset) {
                TableColumn targetColumn = (TableColumn)visibleColumns.get(targetColIndex);
                if (targetColumn == null || !targetColumn.isEditable() || !TableClipboardHelper.applyValueToCell(table, targetColumn, targetRow, tokens[colOffset])) continue;
                changed = true;
            }
        }
        if (changed) {
            table.refresh();
            TableColumn finalColumn = column;
            int finalRowIndex = rowIndex;
            Platform.runLater(() -> {
                TableView.TableViewSelectionModel selectionModel = table.getSelectionModel();
                TableClipboardHelper.clearAndSelect(selectionModel, finalRowIndex, finalColumn);
            });
        }
        return changed;
    }

    private static TablePosition<?, ?> getFocusedCell(TableView<?> table) {
        TablePosition first;
        TablePosition focused;
        if (table == null) {
            return null;
        }
        if (table.getFocusModel() != null && (focused = table.getFocusModel().getFocusedCell()) != null && focused.getTableColumn() != null) {
            return focused;
        }
        ObservableList selectedCells = table.getSelectionModel().getSelectedCells();
        if (!selectedCells.isEmpty() && (first = (TablePosition)selectedCells.get(0)).getTableColumn() != null) {
            return first;
        }
        return null;
    }

    private static boolean applyValueToCell(TableView<?> table, TableColumn<?, ?> column, int rowIndex, String rawText) {
        ObservableValue observable = column.getCellObservableValue(rowIndex);
        if (observable == null) {
            return false;
        }
        if (observable instanceof StringProperty) {
            StringProperty sp = (StringProperty)observable;
            String normalized = TableClipboardHelper.normalizeString(rawText);
            if (Objects.equals(sp.get(), normalized)) {
                return false;
            }
            sp.set((Object)normalized);
            return true;
        }
        if (observable instanceof IntegerProperty) {
            IntegerProperty ip = (IntegerProperty)observable;
            Integer parsed = TableClipboardHelper.parseInteger(rawText);
            if (parsed == null || ip.get() == parsed.intValue()) {
                return false;
            }
            ip.set(parsed.intValue());
            return true;
        }
        if (observable instanceof DoubleProperty) {
            DoubleProperty dp = (DoubleProperty)observable;
            Double parsed = TableClipboardHelper.parseDouble(rawText);
            if (parsed == null || Double.compare(dp.get(), parsed) == 0) {
                return false;
            }
            dp.set(parsed.doubleValue());
            return true;
        }
        if (observable instanceof BooleanProperty) {
            BooleanProperty bp = (BooleanProperty)observable;
            boolean parsed = TableClipboardHelper.parseBoolean(rawText);
            if (bp.get() == parsed) {
                return false;
            }
            bp.set(parsed);
            return true;
        }
        if (observable instanceof ObjectProperty) {
            ObjectProperty op = (ObjectProperty)observable;
            Object converted = TableClipboardHelper.convertForObjectProperty(op, column, table, TableClipboardHelper.normalizeString(rawText));
            if (converted == UNPARSEABLE) {
                return false;
            }
            if (Objects.equals(op.getValue(), converted)) {
                return false;
            }
            ObjectProperty raw = op;
            raw.set(converted);
            return true;
        }
        return false;
    }

    private static boolean clearCellValue(TableView<?> table, TableColumn<?, ?> column, int rowIndex, Consumer<Runnable> undoRecorder) {
        ObservableValue observable = column.getCellObservableValue(rowIndex);
        if (observable == null) {
            return false;
        }
        if (observable instanceof StringProperty) {
            StringProperty sp = (StringProperty)observable;
            String current = (String)sp.get();
            if (current == null || current.isEmpty()) {
                return false;
            }
            if (undoRecorder != null) {
                String previous = current;
                undoRecorder.accept(() -> sp.set((Object)previous));
            }
            sp.set((Object)"");
            return true;
        }
        if (observable instanceof IntegerProperty) {
            IntegerProperty ip = (IntegerProperty)observable;
            int current = ip.get();
            if (current == 0) {
                return false;
            }
            if (undoRecorder != null) {
                int previous = current;
                undoRecorder.accept(() -> ip.set(previous));
            }
            ip.set(0);
            return true;
        }
        if (observable instanceof DoubleProperty) {
            DoubleProperty dp = (DoubleProperty)observable;
            double current = dp.get();
            if (current == 0.0) {
                return false;
            }
            if (undoRecorder != null) {
                double previous = current;
                undoRecorder.accept(() -> dp.set(previous));
            }
            dp.set(0.0);
            return true;
        }
        if (observable instanceof BooleanProperty) {
            BooleanProperty bp = (BooleanProperty)observable;
            if (!bp.get()) {
                return false;
            }
            if (undoRecorder != null) {
                boolean previous = bp.get();
                undoRecorder.accept(() -> bp.set(previous));
            }
            bp.set(false);
            return true;
        }
        if (observable instanceof ObjectProperty) {
            ObjectProperty op = (ObjectProperty)observable;
            if (op.getValue() == null) {
                return false;
            }
            ObjectProperty raw = op;
            if (undoRecorder != null) {
                Object previous = raw.get();
                undoRecorder.accept(() -> raw.set(previous));
            }
            raw.set(null);
            return true;
        }
        return false;
    }

    private static List<String[]> parseClipboardMatrix(String text) {
        if (text == null || text.isEmpty()) {
            return List.of();
        }
        String normalized = text.replace("\r\n", "\n").replace('\r', '\n');
        ArrayList<String[]> rows = new ArrayList<String[]>();
        ArrayList<String> currentRow = new ArrayList<String>();
        StringBuilder cell = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < normalized.length(); ++i) {
            char ch = normalized.charAt(i);
            if (inQuotes) {
                if (ch == '\"') {
                    if (i + 1 < normalized.length() && normalized.charAt(i + 1) == '\"') {
                        cell.append('\"');
                        ++i;
                        continue;
                    }
                    inQuotes = false;
                    continue;
                }
                cell.append(ch);
                continue;
            }
            if (ch == '\"') {
                inQuotes = true;
                continue;
            }
            if (ch == '\t') {
                currentRow.add(cell.toString());
                cell.setLength(0);
                continue;
            }
            if (ch == '\n') {
                currentRow.add(cell.toString());
                rows.add((String[])currentRow.toArray(String[]::new));
                currentRow = new ArrayList();
                cell.setLength(0);
                continue;
            }
            cell.append(ch);
        }
        currentRow.add(cell.toString());
        rows.add((String[])currentRow.toArray(String[]::new));
        TableClipboardHelper.trimTrailingEmptyRows(rows);
        return rows;
    }

    private static void trimTrailingEmptyRows(List<String[]> matrix) {
        while (!matrix.isEmpty()) {
            String[] last = matrix.get(matrix.size() - 1);
            boolean blankRow = true;
            for (String cell : last) {
                if (cell == null || cell.isBlank()) continue;
                blankRow = false;
                break;
            }
            if (!blankRow) break;
            matrix.remove(matrix.size() - 1);
        }
    }

    private static String normalizeString(String value) {
        if (value == null) {
            return "";
        }
        return value.replace("\r\n", "\n").replace('\r', '\n');
    }

    private static String encodeCellValue(Object value) {
        if (value == null) {
            return "";
        }
        String text = value.toString();
        if (text.contains("\"") || text.contains("\n") || text.contains("\t")) {
            String escaped = text.replace("\"", "\"\"");
            return "\"" + escaped + "\"";
        }
        return text;
    }

    private static List<TableColumn<?, ?>> visibleLeafColumns(TableView<?> table) {
        if (table == null) {
            return List.of();
        }
        return table.getVisibleLeafColumns();
    }

    private static int visibleLeafIndex(TableView<?> table, TableColumn<?, ?> column) {
        if (table == null || column == null) {
            return -1;
        }
        return table.getVisibleLeafIndex(column);
    }

    private static void clearAndSelect(TableView.TableViewSelectionModel<?> selectionModel, int row, TableColumn<?, ?> column) {
        if (selectionModel == null || column == null) {
            return;
        }
        selectionModel.clearAndSelect(row, column);
    }

    private static Integer parseInteger(String text) {
        if (text == null || text.isBlank()) {
            return null;
        }
        try {
            return Integer.parseInt(text.trim());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static Double parseDouble(String text) {
        if (text == null || text.isBlank()) {
            return null;
        }
        try {
            return Double.parseDouble(text.trim().replace(',', '.'));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static Object convertForObjectProperty(ObjectProperty<?> property, TableColumn<?, ?> column, TableView<?> table, String text) {
        String trimmed;
        String string = trimmed = text == null ? "" : text.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        Class<?> targetType = TableClipboardHelper.detectTargetType(property, column, table);
        if (targetType == null || targetType == Object.class) {
            return trimmed;
        }
        Object converted = TableClipboardHelper.convertText(trimmed, targetType);
        return converted != null ? converted : UNPARSEABLE;
    }

    private static Class<?> detectTargetType(ObjectProperty<?> property, TableColumn<?, ?> column, TableView<?> table) {
        Object current = property.getValue();
        if (current != null) {
            return current.getClass();
        }
        if (column != null && table != null) {
            ObservableList items = table.getItems();
            for (int i = 0; i < items.size(); ++i) {
                Object sample = column.getCellData(i);
                if (sample == null) continue;
                return sample.getClass();
            }
        }
        Object bean = property.getBean();
        String name = property.getName();
        if (bean != null && name != null && !name.isBlank()) {
            try {
                Method method = bean.getClass().getMethod(name + "Property", new Class[0]);
                Type generic = method.getGenericReturnType();
                Class<?> resolved = TableClipboardHelper.resolvePropertyGenericType(generic);
                if (resolved != null) {
                    return resolved;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Class<?> resolvePropertyGenericType(Type type) {
        ParameterizedType parameterized;
        Type[] args;
        if (type instanceof ParameterizedType && (args = (parameterized = (ParameterizedType)type).getActualTypeArguments()).length == 1) {
            ParameterizedType nested;
            Type raw;
            Type arg = args[0];
            if (arg instanceof Class) {
                Class clazz = (Class)arg;
                return clazz;
            }
            if (arg instanceof ParameterizedType && (raw = (nested = (ParameterizedType)arg).getRawType()) instanceof Class) {
                Class clazz = (Class)raw;
                return clazz;
            }
        }
        return null;
    }

    private static Object convertText(String text, Class<?> targetType) {
        if (targetType == null) {
            return text;
        }
        if (String.class.isAssignableFrom(targetType) || CharSequence.class.isAssignableFrom(targetType)) {
            return text;
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return TableClipboardHelper.parseInteger(text);
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            Integer parsed = TableClipboardHelper.parseInteger(text);
            return parsed == null ? null : Long.valueOf(parsed.longValue());
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return TableClipboardHelper.parseDouble(text);
        }
        if (targetType == Float.class || targetType == Float.TYPE) {
            Double parsed = TableClipboardHelper.parseDouble(text);
            return parsed == null ? null : Float.valueOf(parsed.floatValue());
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return TableClipboardHelper.parseBoolean(text);
        }
        if (LocalDate.class.isAssignableFrom(targetType)) {
            return TableClipboardHelper.parseLocalDate(text);
        }
        if (Enum.class.isAssignableFrom(targetType)) {
            Class<?> enumType = targetType;
            return TableClipboardHelper.parseEnum(enumType, text);
        }
        if (Number.class.isAssignableFrom(targetType)) {
            return TableClipboardHelper.parseDouble(text);
        }
        return text;
    }

    private static LocalDate parseLocalDate(String text) {
        for (DateTimeFormatter formatter : DATE_FORMATS) {
            try {
                return LocalDate.parse(text, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    private static Object parseEnum(Class<? extends Enum<?>> enumType, String text) {
        Enum<?>[] constants = enumType.getEnumConstants();
        if (constants == null || constants.length == 0) {
            return null;
        }
        String normalized = text.trim();
        if (normalized.isEmpty()) {
            return null;
        }
        String normalizedName = normalized.replace(' ', '_');
        for (Enum<?> constant : constants) {
            if (!constant.name().equalsIgnoreCase(normalizedName) && !constant.toString().equalsIgnoreCase(normalized)) continue;
            return constant;
        }
        try {
            int numeric = Integer.parseInt(normalized);
            try {
                Method fromValue = enumType.getMethod("fromValue", Integer.TYPE);
                Object result = fromValue.invoke(null, numeric);
                if (result != null) {
                    return result;
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            for (Enum<?> constant : constants) {
                if (constant.ordinal() == numeric || constant.ordinal() + 1 == numeric) {
                    return constant;
                }
                try {
                    Number number;
                    Method getValue = enumType.getMethod("getValue", new Class[0]);
                    Object val = getValue.invoke(constant, new Object[0]);
                    if (!(val instanceof Number) || (number = (Number)val).intValue() != numeric) continue;
                    return constant;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static boolean parseBoolean(String text) {
        if (text == null) {
            return false;
        }
        String normalized = text.trim().toLowerCase();
        return List.of("true", "yes", "y", "1", "sim").contains(normalized);
    }
}

