/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers.util;

import java.net.URL;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;

public final class TableHeaderStyler {
    private static String stylesheetUrl;

    private TableHeaderStyler() {
    }

    public static void ensure(Control control) {
        if (control == null) {
            return;
        }
        String url = TableHeaderStyler.stylesheet();
        if (url == null) {
            return;
        }
        ObservableList sheets = control.getStylesheets();
        if (!sheets.contains((Object)url)) {
            sheets.add((Object)url);
        }
    }

    public static void ensureAll(Control ... controls) {
        if (controls == null) {
            return;
        }
        for (Control c : controls) {
            TableHeaderStyler.ensure(c);
        }
    }

    private static String stylesheet() {
        if (stylesheetUrl != null) {
            return stylesheetUrl;
        }
        URL resource = TableHeaderStyler.class.getResource("/css/fmea-table-header.css");
        if (resource != null) {
            stylesheetUrl = resource.toExternalForm();
        }
        return stylesheetUrl;
    }
}

