/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;

public final class TableSearchNavigator<T> {
    private final TableView<T> table;
    private final TextField searchField;
    private final Button nextButton;
    private final Function<T, String> rowTextProvider;
    private List<Integer> matches = Collections.emptyList();
    private int currentMatchIndex = -1;
    private String lastQuery = "";
    private Runnable stateListener;

    private TableSearchNavigator(TableView<T> table, TextField searchField, Button nextButton, Function<T, String> rowTextProvider) {
        this.table = table;
        this.searchField = searchField;
        this.nextButton = nextButton;
        this.rowTextProvider = rowTextProvider;
    }

    public static <T> TableSearchNavigator<T> install(TableView<T> table, TextField searchField, Button nextButton) {
        return TableSearchNavigator.install(table, searchField, nextButton, row -> TableSearchNavigator.defaultRowText(table, row));
    }

    public static <T> TableSearchNavigator<T> install(TableView<T> table, TextField searchField, Button nextButton, Function<T, String> rowTextProvider) {
        if (table == null || searchField == null || nextButton == null) {
            return null;
        }
        Function<Object, String> provider = rowTextProvider != null ? rowTextProvider : row -> TableSearchNavigator.defaultRowText(table, row);
        TableSearchNavigator<T> navigator = new TableSearchNavigator<T>(table, searchField, nextButton, provider);
        navigator.init();
        return navigator;
    }

    private void init() {
        this.nextButton.setDisable(false);
        this.searchField.setOnAction(e -> this.performSearch(true));
        this.nextButton.setOnAction(e -> this.goNext());
        this.searchField.textProperty().addListener((obs, old, value) -> {
            if (value == null || value.isBlank()) {
                this.resetSearchState();
            } else {
                this.lastQuery = "";
                this.matches = Collections.emptyList();
                this.currentMatchIndex = -1;
                this.notifyStateChanged();
            }
        });
        this.table.getItems().addListener(change -> {
            if (this.lastQuery.isEmpty()) {
                return;
            }
            Platform.runLater(() -> this.performSearch(false));
        });
    }

    private void goNext() {
        if (TableSearchNavigator.normalize(this.searchField.getText()).isEmpty()) {
            this.resetSearchState();
            return;
        }
        if (!TableSearchNavigator.normalize(this.searchField.getText()).equals(this.lastQuery) || this.matches.isEmpty()) {
            this.performSearch(this.matches.isEmpty());
            if (this.matches.isEmpty()) {
                return;
            }
        }
        this.currentMatchIndex = (this.currentMatchIndex + 1) % this.matches.size();
        this.selectCurrent();
    }

    private void performSearch(boolean resetIndex) {
        int prevIndex;
        String query = TableSearchNavigator.normalize(this.searchField.getText());
        if (query.isEmpty()) {
            this.resetSearchState();
            return;
        }
        ObservableList items = this.table.getItems();
        if (items == null) {
            this.resetSearchState();
            return;
        }
        T previousItem = null;
        if (!this.matches.isEmpty() && this.currentMatchIndex >= 0 && this.currentMatchIndex < this.matches.size() && (prevIndex = this.matches.get(this.currentMatchIndex).intValue()) >= 0 && prevIndex < items.size()) {
            previousItem = (T)items.get(prevIndex);
        }
        ArrayList<Integer> found = new ArrayList<Integer>();
        for (int i = 0; i < items.size(); ++i) {
            String haystack = TableSearchNavigator.normalize(this.rowTextProvider.apply(items.get(i)));
            if (haystack.isEmpty() || !haystack.contains(query)) continue;
            found.add(i);
        }
        this.matches = found;
        this.lastQuery = query;
        if (this.matches.isEmpty()) {
            this.currentMatchIndex = -1;
            this.notifyStateChanged();
            return;
        }
        this.currentMatchIndex = resetIndex || previousItem == null ? 0 : this.resolveIndexForItem(previousItem, (List<T>)items, this.matches);
        this.selectCurrent();
    }

    private int resolveIndexForItem(T item, List<T> items, List<Integer> indices) {
        if (item == null) {
            return 0;
        }
        for (int i = 0; i < indices.size(); ++i) {
            int rowIndex = indices.get(i);
            if (rowIndex < 0 || rowIndex >= items.size() || items.get(rowIndex) != item) continue;
            return i;
        }
        return 0;
    }

    private void selectCurrent() {
        if (this.currentMatchIndex < 0 || this.currentMatchIndex >= this.matches.size()) {
            return;
        }
        int rowIndex = this.matches.get(this.currentMatchIndex);
        if (rowIndex < 0 || rowIndex >= this.table.getItems().size()) {
            return;
        }
        this.table.getSelectionModel().clearAndSelect(rowIndex);
        this.table.requestFocus();
        if (this.table.getFocusModel() != null) {
            this.table.getFocusModel().focus(rowIndex);
        }
        this.centerOnRow(rowIndex);
        this.notifyStateChanged();
    }

    private void resetSearchState() {
        this.matches = Collections.emptyList();
        this.currentMatchIndex = -1;
        this.lastQuery = "";
        this.notifyStateChanged();
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        return value.strip().toLowerCase(Locale.ROOT);
    }

    private static <T> String defaultRowText(TableView<T> table, T row) {
        if (row == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (TableColumn<T, ?> column : TableSearchNavigator.leafColumns(table)) {
            Object cellValue = column.getCellData(row);
            if (cellValue == null) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(cellValue.toString());
        }
        return sb.toString();
    }

    private static <T> List<TableColumn<T, ?>> leafColumns(TableView<T> table) {
        if (table == null) {
            return List.of();
        }
        ArrayList result = new ArrayList();
        for (TableColumn column : table.getColumns()) {
            TableSearchNavigator.collectLeafColumns(column, result);
        }
        return result;
    }

    private static <T> void collectLeafColumns(TableColumn<?, ?> column, List<TableColumn<T, ?>> out) {
        if (column == null) {
            return;
        }
        if (column.getColumns().isEmpty()) {
            out.add(column);
            return;
        }
        for (TableColumn child : column.getColumns()) {
            TableSearchNavigator.collectLeafColumns(child, out);
        }
    }

    public String getLastQuery() {
        return this.lastQuery;
    }

    public int getCurrentMatchRow() {
        if (this.currentMatchIndex < 0 || this.currentMatchIndex >= this.matches.size()) {
            return -1;
        }
        return this.matches.get(this.currentMatchIndex);
    }

    public List<Integer> getMatches() {
        return Collections.unmodifiableList(this.matches);
    }

    public void setOnStateChanged(Runnable listener) {
        this.stateListener = listener;
    }

    private void notifyStateChanged() {
        if (this.stateListener != null) {
            this.stateListener.run();
        }
    }

    private void centerOnRow(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        int target = Math.max(0, rowIndex - this.approximateVisibleRowCount() / 2);
        this.table.scrollTo(target);
        Platform.runLater(() -> {
            int updatedTarget = Math.max(0, rowIndex - this.approximateVisibleRowCount() / 2);
            this.table.scrollTo(updatedTarget);
            this.table.scrollTo(rowIndex);
        });
    }

    private int approximateVisibleRowCount() {
        double height = this.table.getHeight();
        double rowHeight = this.table.getFixedCellSize();
        if (rowHeight <= 0.0) {
            rowHeight = 24.0;
        }
        if (height <= 0.0) {
            return 10;
        }
        return Math.max(1, (int)Math.round(height / rowHeight));
    }
}

