/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers.util;

import java.net.URL;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;

public final class TableSelectionStyler {
    private static String stylesheetUrl;

    private TableSelectionStyler() {
    }

    public static void ensure(Control control) {
        if (control == null) {
            return;
        }
        String url = TableSelectionStyler.stylesheet();
        if (url == null) {
            return;
        }
        ObservableList sheets = control.getStylesheets();
        if (!sheets.contains((Object)url)) {
            sheets.add((Object)url);
        }
    }

    public static void ensureAll(Control ... controls) {
        if (controls == null) {
            return;
        }
        for (Control c : controls) {
            TableSelectionStyler.ensure(c);
        }
    }

    private static String stylesheet() {
        if (stylesheetUrl != null) {
            return stylesheetUrl;
        }
        URL resource = TableSelectionStyler.class.getResource("/css/table-selection.css");
        if (resource != null) {
            stylesheetUrl = resource.toExternalForm();
        }
        return stylesheetUrl;
    }
}

