/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers.util;

import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public final class TableUtils {
    private TableUtils() {
    }

    public static void setHeaderBackground(TableColumn<?, ?> column, String color) {
        if (column == null || color == null || color.isBlank()) {
            return;
        }
        Node node = column.getGraphic();
        if (node instanceof Region) {
            Region region = (Region)node;
            String current = region.getStyle();
            String applied = "-fx-background-color: " + color.trim() + "; -fx-background-insets: 0; -fx-background-radius: 0;";
            region.setStyle((String)(current == null || current.isBlank() ? "" : current + " ") + applied);
        }
    }

    public static void wrapHeader(TableColumn<?, ?> column) {
        if (column == null) {
            return;
        }
        String text = column.getText();
        TableUtils.wrapHeader(null, column, text == null ? "" : text);
    }

    public static void wrapHeader(TableView<?> table, TableColumn<?, ?> column, String text) {
        if (column == null) {
            return;
        }
        Text header = new Text(text == null ? "" : text);
        header.setTextAlignment(TextAlignment.CENTER);
        header.wrappingWidthProperty().bind((ObservableValue)column.widthProperty().subtract(12));
        StackPane box = new StackPane(new Node[]{header});
        box.setAlignment(Pos.CENTER);
        box.prefWidthProperty().bind((ObservableValue)column.widthProperty());
        column.setText(null);
        column.setGraphic((Node)box);
        if (table != null) {
            Platform.runLater(() -> table.layout());
        }
    }

    public static void makeHeaderVertical(TableView<?> table, TableColumn<?, ?> column, double prefHeight) {
        if (column == null) {
            return;
        }
        String title = column.getText();
        column.setText(null);
        Label label = new Label(title == null ? "" : title);
        label.setRotate(-90.0);
        label.setWrapText(false);
        label.setPadding(new Insets(6.0, 6.0, 6.0, 6.0));
        label.setAlignment(Pos.CENTER);
        Group g = new Group(new Node[]{label});
        StackPane box = new StackPane(new Node[]{g});
        box.setAlignment(Pos.CENTER);
        box.setPrefHeight(prefHeight);
        box.setMinHeight(Double.NEGATIVE_INFINITY);
        column.setGraphic((Node)box);
        if (table != null) {
            Platform.runLater(() -> table.layout());
        }
    }
}

