/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.controllers.util;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class WrapTextAreaTableCell<S>
extends TableCell<S, String> {
    private static final String HIGHLIGHT_KEY = "wrapHighlight";
    private final TextFlow display = new TextFlow();
    private final Text measurer = new Text();
    private TextArea editor;
    private final TableColumn<S, String> ownerColumn;
    private final Supplier<Pattern> highlightPatternSupplier;
    private final BiConsumer<TableCell<S, ?>, Integer> tabNavigator;
    private final EditorConfigurer<S> editorConfigurer;

    public WrapTextAreaTableCell(TableColumn<S, String> ownerColumn, Supplier<Pattern> highlightPatternSupplier, BiConsumer<TableCell<S, ?>, Integer> tabNavigator) {
        this(ownerColumn, highlightPatternSupplier, tabNavigator, null);
    }

    public WrapTextAreaTableCell(TableColumn<S, String> ownerColumn, Supplier<Pattern> highlightPatternSupplier, BiConsumer<TableCell<S, ?>, Integer> tabNavigator, EditorConfigurer<S> editorConfigurer) {
        this.ownerColumn = ownerColumn;
        this.highlightPatternSupplier = highlightPatternSupplier;
        this.tabNavigator = tabNavigator;
        this.editorConfigurer = editorConfigurer;
        this.display.setLineSpacing(1.2);
        this.display.setTextAlignment(TextAlignment.CENTER);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.setAlignment(Pos.CENTER);
        this.setPrefHeight(-1.0);
        this.setMinHeight(-1.0);
        ownerColumn.widthProperty().addListener((o, ov, nv) -> {
            if (!this.isEditing() && !this.isEmpty()) {
                this.autoSizeDisplay((String)this.getItem());
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
            TableView tv;
            if (e.getButton() != MouseButton.PRIMARY || e.getClickCount() < 2) {
                return;
            }
            if (!this.isEmpty() && !this.isEditing() && (tv = this.getTableView()) != null) {
                tv.edit(this.getIndex(), ownerColumn);
                e.consume();
            }
        });
        this.selectedProperty().addListener((obs, was, isSel) -> this.refreshSelectionFill());
    }

    protected void updateItem(String value, boolean empty) {
        super.updateItem((Object)value, empty);
        if (empty) {
            this.setGraphic(null);
            this.setText(null);
            this.setPrefHeight(-1.0);
            this.setMinHeight(-1.0);
            return;
        }
        if (this.isEditing()) {
            if (this.editor == null) {
                this.createEditor();
            }
            this.editor.setText(value);
            this.autoSizeEditor();
            this.setGraphic((Node)this.editor);
            this.setText(null);
        } else {
            this.updateDisplayContent(value);
            this.setGraphic((Node)this.display);
            this.setText(null);
            this.autoSizeDisplay(value);
        }
    }

    public void startEdit() {
        super.startEdit();
        if (this.isEmpty()) {
            return;
        }
        if (this.editor == null) {
            this.createEditor();
        }
        this.editor.setText((String)this.getItem());
        this.autoSizeEditor();
        this.setGraphic((Node)this.editor);
        this.setText(null);
        Platform.runLater(() -> this.editor.requestFocus());
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.updateDisplayContent((String)this.getItem());
        this.setGraphic((Node)this.display);
        this.setText(null);
        this.autoSizeDisplay((String)this.getItem());
    }

    public void commitEdit(String newValue) {
        super.commitEdit((Object)newValue);
        this.updateDisplayContent(newValue);
        this.setGraphic((Node)this.display);
        this.setText(null);
        this.autoSizeDisplay(newValue);
    }

    protected TextArea editor() {
        return this.editor;
    }

    public TextFlow displayNode() {
        return this.display;
    }

    private void createEditor() {
        this.editor = new TextArea();
        this.editor.setWrapText(true);
        this.editor.setPrefRowCount(3);
        this.editor.setMinHeight(Double.NEGATIVE_INFINITY);
        this.editor.setMaxWidth(Double.MAX_VALUE);
        this.editor.addEventFilter(KeyEvent.KEY_PRESSED, this::handleKeyPressed);
        this.editor.addEventFilter(KeyEvent.KEY_TYPED, e -> {
            if ("\t".equals(e.getCharacter())) {
                e.consume();
            }
        });
        this.editor.focusedProperty().addListener((o, was, isNow) -> {
            if (!isNow.booleanValue() && this.isEditing()) {
                this.commitEdit(this.editor.getText());
            }
        });
        this.editor.textProperty().addListener((o, ov, nv) -> this.autoSizeEditor());
        this.ownerColumn.widthProperty().addListener((o, ov, nv) -> this.autoSizeEditor());
        if (this.editorConfigurer != null) {
            this.editorConfigurer.configure(this, this.editor);
        }
    }

    private void handleKeyPressed(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        switch (e.getCode()) {
            case ESCAPE: {
                if (this.isEditing()) {
                    this.cancelEdit();
                    this.refocusCell();
                }
                e.consume();
                break;
            }
            case TAB: {
                this.commitEdit(this.editor.getText());
                if (this.tabNavigator != null) {
                    int step = e.isShiftDown() ? -1 : 1;
                    this.tabNavigator.accept(this, step);
                }
                e.consume();
                break;
            }
            case ENTER: {
                if (!e.isControlDown()) break;
                this.commitEdit(this.editor.getText());
                this.refocusCell();
                e.consume();
                break;
            }
        }
    }

    private void autoSizeEditor() {
        if (this.editor == null) {
            return;
        }
        double wrap = Math.max(60.0, this.ownerColumn.getWidth() > 0.0 ? this.ownerColumn.getWidth() - 16.0 : 300.0);
        this.measurer.setWrappingWidth(wrap);
        this.measurer.setText(this.editor.getText() + "\n");
        double measured = Math.ceil(this.measurer.getLayoutBounds().getHeight());
        double target = Math.max(28.0, measured + 12.0);
        this.editor.setPrefWidth(wrap);
        this.editor.setPrefHeight(target);
        this.setPrefHeight(target + 8.0);
        this.setMinHeight(target + 8.0);
        TableRow row = this.getTableRow();
        if (row != null) {
            row.setPrefHeight(target + 8.0);
            row.requestLayout();
        }
        this.requestLayout();
    }

    private void autoSizeDisplay(String text) {
        if (text == null) {
            text = "";
        }
        double wrap = Math.max(60.0, this.ownerColumn.getWidth() > 0.0 ? this.ownerColumn.getWidth() - 16.0 : 300.0);
        this.measurer.setWrappingWidth(wrap);
        this.measurer.setText((text.isEmpty() ? " " : text) + "\n");
        double measured = Math.ceil(this.measurer.getLayoutBounds().getHeight());
        double target = Math.max(28.0, measured + 12.0);
        this.setPrefHeight(target + 8.0);
        this.setMinHeight(target + 8.0);
        TableRow row = this.getTableRow();
        if (row != null) {
            row.setPrefHeight(target + 8.0);
            row.requestLayout();
        }
    }

    private void updateDisplayContent(String value) {
        Pattern highlightPattern;
        String text = value == null ? "" : value;
        this.display.getChildren().clear();
        double wrap = Math.max(60.0, this.ownerColumn.getWidth() > 0.0 ? this.ownerColumn.getWidth() - 16.0 : 300.0);
        this.display.setPrefWidth(wrap);
        Pattern pattern = highlightPattern = this.highlightPatternSupplier == null ? null : this.highlightPatternSupplier.get();
        if (highlightPattern == null || text.isBlank()) {
            this.display.getChildren().add((Object)this.buildTextSegment(text.isEmpty() ? " " : text, false));
            return;
        }
        Matcher matcher = highlightPattern.matcher(text);
        int last = 0;
        while (matcher.find()) {
            if (matcher.start() > last) {
                this.display.getChildren().add((Object)this.buildTextSegment(text.substring(last, matcher.start()), false));
            }
            this.display.getChildren().add((Object)this.buildTextSegment(text.substring(matcher.start(), matcher.end()), true));
            last = matcher.end();
        }
        if (last < text.length()) {
            this.display.getChildren().add((Object)this.buildTextSegment(text.substring(last), false));
        }
        if (this.display.getChildren().isEmpty()) {
            this.display.getChildren().add((Object)this.buildTextSegment(" ", false));
        }
        this.refreshSelectionFill();
    }

    private Text buildTextSegment(String segment, boolean highlight) {
        Text t = new Text(segment);
        t.getProperties().put((Object)HIGHLIGHT_KEY, (Object)highlight);
        this.applyTextStyle(t, highlight, this.isSelected());
        return t;
    }

    private void refreshSelectionFill() {
        boolean selected = this.isSelected();
        for (Node node : this.display.getChildren()) {
            if (!(node instanceof Text)) continue;
            Text t = (Text)node;
            boolean highlight = Boolean.TRUE.equals(t.getProperties().get((Object)HIGHLIGHT_KEY));
            this.applyTextStyle(t, highlight, selected);
        }
    }

    private void applyTextStyle(Text text, boolean highlight, boolean selected) {
        StringBuilder style = new StringBuilder();
        if (highlight) {
            style.append("-fx-fill: -fx-selection-bar-text; -fx-background-color: -fx-selection-bar; -fx-font-weight: bold;");
        } else if (selected) {
            style.append("-fx-fill: -fx-selection-bar-text;");
        } else {
            style.append("-fx-fill: -fx-text-base-color;");
        }
        text.setStyle(style.toString());
    }

    private void refocusCell() {
        TableView table = this.getTableView();
        TableColumn column = this.getTableColumn();
        int row = this.getIndex();
        if (table == null || column == null || row < 0) {
            return;
        }
        TableView.TableViewSelectionModel selection = table.getSelectionModel();
        TableView.TableViewFocusModel focus = table.getFocusModel();
        if (selection != null) {
            selection.clearAndSelect(row, column);
        }
        if (focus != null) {
            focus.focus(row, column);
        }
    }

    @FunctionalInterface
    public static interface EditorConfigurer<S> {
        public void configure(WrapTextAreaTableCell<S> var1, TextArea var2);
    }
}

