/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.eightd;

import com.qualidadeeprodutividade.eightd.EightD;
import com.qualidadeeprodutividade.eightd.EightDContainmentAction;
import com.qualidadeeprodutividade.eightd.EightDContainmentInventoryRow;
import com.qualidadeeprodutividade.eightd.EightDCorrectiveAction;
import com.qualidadeeprodutividade.eightd.EightDEffectivenessVerification;
import com.qualidadeeprodutividade.eightd.EightDEvent;
import com.qualidadeeprodutividade.eightd.EightDExportOptions;
import com.qualidadeeprodutividade.eightd.EightDImage;
import com.qualidadeeprodutividade.eightd.EightDPreventiveAction;
import com.qualidadeeprodutividade.eightd.EightDTeamMember;
import com.qualidadeeprodutividade.eightd.IshikawaDiagramRenderer;
import com.qualidadeeprodutividade.pdf.PdfAssets;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class EightDExcelExporter {
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ISO_LOCAL_DATE;

    private EightDExcelExporter() {
    }

    public static void export(EightD model, EightDExportOptions options, Path targetPath, Path logoPath) throws IOException {
        Objects.requireNonNull(model, "8D report is null");
        Objects.requireNonNull(targetPath, "Target path is null");
        if (options == null) {
            options = EightDExportOptions.allEnabled();
        }
        if (targetPath.getParent() != null) {
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        }
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            Sheet sheet = workbook.createSheet("8D Report");
            sheet.setDisplayGridlines(false);
            sheet.setPrintGridlines(false);
            Styles styles = new Styles((Workbook)workbook);
            int rowIndex = 0;
            rowIndex = EightDExcelExporter.writeTitle(sheet, rowIndex, styles, model);
            rowIndex = EightDExcelExporter.writeHeaderBlock(sheet, rowIndex, styles, model);
            if (options.includeD1TeamMembers()) {
                rowIndex = EightDExcelExporter.writeD1(sheet, rowIndex, styles, model);
            }
            if (options.includeD2ProblemDescription()) {
                rowIndex = EightDExcelExporter.writeD2(sheet, rowIndex, styles, model, options);
            }
            if (options.includeD3ContainmentActions()) {
                rowIndex = EightDExcelExporter.writeD3(sheet, rowIndex, styles, model, options);
            }
            if (options.includeD4PossibleCauses()) {
                rowIndex = EightDExcelExporter.writeD4(sheet, rowIndex, styles, (Workbook)workbook, model, options);
            }
            if (options.includeD5CorrectiveActions()) {
                rowIndex = EightDExcelExporter.writeD5(sheet, rowIndex, styles, model);
            }
            if (options.includeD6EffectivenessVerification()) {
                rowIndex = EightDExcelExporter.writeD6(sheet, rowIndex, styles, model);
            }
            if (options.includeD7PreventiveActions()) {
                rowIndex = EightDExcelExporter.writeD7(sheet, rowIndex, styles, model);
            }
            if (options.includeD8ReviewApprovals()) {
                rowIndex = EightDExcelExporter.writeD8(sheet, rowIndex, styles, model);
            }
            rowIndex = EightDExcelExporter.writeCustomerSignature(sheet, rowIndex, styles);
            EightDExcelExporter.placeLogo((Workbook)workbook, sheet, logoPath);
            for (int i = 0; i <= 8; ++i) {
                sheet.autoSizeColumn(i);
            }
            try (OutputStream out = Files.newOutputStream(targetPath, new OpenOption[0]);){
                workbook.write(out);
            }
        }
        catch (Exception ex) {
            throw new IOException("Failed to export 8D to Excel", ex);
        }
    }

    private static int writeTitle(Sheet sheet, int rowIndex, Styles styles, EightD model) {
        String claim = EightDExcelExporter.firstNonBlank(model.getInternalClaimNumber(), model.getCustomerClaimNumber(), "8D Report");
        Row titleRow = sheet.createRow(rowIndex++);
        titleRow.setHeightInPoints(30.0f);
        Cell titleCell = titleRow.createCell(0);
        titleCell.setCellValue("8D Corrective Action Report - " + claim);
        titleCell.setCellStyle(styles.title);
        sheet.addMergedRegion(new CellRangeAddress(titleRow.getRowNum(), titleRow.getRowNum(), 0, 8));
        Row subtitle = sheet.createRow(rowIndex++);
        subtitle.createCell(0).setCellValue("Status: " + EightDExcelExporter.nz(model.getStatus(), "N/A"));
        subtitle.createCell(2).setCellValue("Date Opened: " + EightDExcelExporter.formatDate(model.getDateOpened()));
        subtitle.createCell(4).setCellValue("Date Revised: " + EightDExcelExporter.formatDate(model.getDateRevised()));
        subtitle.createCell(6).setCellValue("Closed Date: " + EightDExcelExporter.formatDate(model.getClosedDate()));
        for (int c : List.of(Integer.valueOf(0), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(6))) {
            subtitle.getCell(c).setCellStyle(styles.small);
        }
        return rowIndex + 1;
    }

    private static int writeHeaderBlock(Sheet sheet, int rowIndex, Styles styles, EightD model) {
        rowIndex = EightDExcelExporter.writeKeyValueRow(sheet, rowIndex, styles, "Internal Claim Number", model.getInternalClaimNumber(), "Customer Claim Number", model.getCustomerClaimNumber());
        rowIndex = EightDExcelExporter.writeKeyValueRow(sheet, rowIndex, styles, "Customer", model.getCustomer(), "Customer Contact", model.getCustomerContact());
        rowIndex = EightDExcelExporter.writeKeyValueRow(sheet, rowIndex, styles, "Internal Contact", model.getInternalContact(), "Containment Due Date", EightDExcelExporter.formatDate(model.getContainmentDueDate()));
        rowIndex = EightDExcelExporter.writeKeyValueRow(sheet, rowIndex, styles, "Part Number", model.getPartNumber(), "Part Description", model.getPartDescription());
        rowIndex = EightDExcelExporter.writeKeyValueRow(sheet, rowIndex, styles, "Quantity", model.getQuantity(), "Status", model.getStatus());
        Row ncLabel = sheet.createRow(rowIndex++);
        Cell label = ncLabel.createCell(0);
        label.setCellValue("Non-conformance description");
        label.setCellStyle(styles.sectionLabel);
        sheet.addMergedRegion(new CellRangeAddress(ncLabel.getRowNum(), ncLabel.getRowNum(), 0, 8));
        Row ncText = sheet.createRow(rowIndex++);
        ncText.setHeightInPoints(52.0f);
        Cell text = ncText.createCell(0);
        text.setCellValue(EightDExcelExporter.nz(model.getNonConformanceNotification(), "-"));
        text.setCellStyle(styles.wrappedValue);
        sheet.addMergedRegion(new CellRangeAddress(ncText.getRowNum(), ncText.getRowNum(), 0, 8));
        return rowIndex + 1;
    }

    private static int writeD1(Sheet sheet, int rowIndex, Styles styles, EightD model) {
        rowIndex = EightDExcelExporter.writeSectionTitle(sheet, rowIndex, styles, "D1 - Team Members");
        String[] headers = new String[]{"Name", "Role / Function", "Department", "Company", "Responsibility in 8D", "E-mail"};
        rowIndex = EightDExcelExporter.writeTableHeader(sheet, rowIndex, styles, headers);
        if (model.getTeamMembers().isEmpty()) {
            rowIndex = EightDExcelExporter.writeEmptyTableRow(sheet, rowIndex, styles, 6, "No team members added.");
        } else {
            for (EightDTeamMember row : model.getTeamMembers()) {
                rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of(EightDExcelExporter.nz(row.getName(), "-"), EightDExcelExporter.nz(row.getRoleFunction(), "-"), EightDExcelExporter.nz(row.getDepartment(), "-"), EightDExcelExporter.nz(row.getCompany(), "-"), EightDExcelExporter.nz(row.getResponsibility(), "-"), EightDExcelExporter.nz(row.getEmail(), "-")));
            }
        }
        return rowIndex + 1;
    }

    private static int writeD2(Sheet sheet, int rowIndex, Styles styles, EightD model, EightDExportOptions options) {
        rowIndex = EightDExcelExporter.writeSectionTitle(sheet, rowIndex, styles, "D2 - Problem Description");
        Row problem = sheet.createRow(rowIndex++);
        problem.setHeightInPoints(46.0f);
        Cell problemCell = problem.createCell(0);
        problemCell.setCellValue(EightDExcelExporter.nz(model.getProblemDescription(), "-"));
        problemCell.setCellStyle(styles.wrappedValue);
        sheet.addMergedRegion(new CellRangeAddress(problem.getRowNum(), problem.getRowNum(), 0, 8));
        if (!model.getImages().isEmpty()) {
            Row photoTitle = sheet.createRow(rowIndex++);
            Cell title = photoTitle.createCell(0);
            title.setCellValue("Photo Gallery");
            title.setCellStyle(styles.sectionLabel);
            sheet.addMergedRegion(new CellRangeAddress(photoTitle.getRowNum(), photoTitle.getRowNum(), 0, 8));
            for (EightDImage image : model.getImages()) {
                Row imageRow = sheet.createRow(rowIndex++);
                Cell c = imageRow.createCell(0);
                c.setCellValue(EightDExcelExporter.nz(image == null ? null : image.getPath(), "-"));
                c.setCellStyle(styles.value);
                sheet.addMergedRegion(new CellRangeAddress(imageRow.getRowNum(), imageRow.getRowNum(), 0, 8));
            }
        }
        if (options.includeD2IsIsNotTool()) {
            rowIndex = EightDExcelExporter.writeSectionSubTitle(sheet, rowIndex, styles, "D2 Tool - Is x Is Not");
            rowIndex = EightDExcelExporter.writeTableHeader(sheet, rowIndex, styles, new String[]{"Dimension", "Is", "Is Not"});
            rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of("What", EightDExcelExporter.nz(model.getD2IsWhat(), "-"), EightDExcelExporter.nz(model.getD2IsNotWhat(), "-")));
            rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of("Where", EightDExcelExporter.nz(model.getD2IsWhere(), "-"), EightDExcelExporter.nz(model.getD2IsNotWhere(), "-")));
            rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of("When", EightDExcelExporter.nz(model.getD2IsWhen(), "-"), EightDExcelExporter.nz(model.getD2IsNotWhen(), "-")));
            rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of("How many", EightDExcelExporter.nz(model.getD2IsHowMany(), "-"), EightDExcelExporter.nz(model.getD2IsNotHowMany(), "-")));
        }
        if (options.includeD2DiffChangesTool()) {
            rowIndex = EightDExcelExporter.writeSectionSubTitle(sheet, rowIndex, styles, "D2 Tool - Difference & Changes");
            rowIndex = EightDExcelExporter.writeTableHeader(sheet, rowIndex, styles, new String[]{"Row", "Contrast", "Changes"});
            rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of("1", EightDExcelExporter.nz(model.getD2DiffContrast1(), "-"), EightDExcelExporter.nz(model.getD2DiffChange1(), "-")));
            rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of("2", EightDExcelExporter.nz(model.getD2DiffContrast2(), "-"), EightDExcelExporter.nz(model.getD2DiffChange2(), "-")));
            rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of("3", EightDExcelExporter.nz(model.getD2DiffContrast3(), "-"), EightDExcelExporter.nz(model.getD2DiffChange3(), "-")));
            rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of("4", EightDExcelExporter.nz(model.getD2DiffContrast4(), "-"), EightDExcelExporter.nz(model.getD2DiffChange4(), "-")));
        }
        if (options.includeD2EventsTool()) {
            rowIndex = EightDExcelExporter.writeSectionSubTitle(sheet, rowIndex, styles, "D2 Tool - Events");
            rowIndex = EightDExcelExporter.writeTableHeader(sheet, rowIndex, styles, new String[]{"Date", "Description", "Who", "Where"});
            if (model.getEvents().isEmpty()) {
                rowIndex = EightDExcelExporter.writeEmptyTableRow(sheet, rowIndex, styles, 4, "No events added.");
            } else {
                for (EightDEvent event : model.getEvents()) {
                    rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of(EightDExcelExporter.formatDate(event.getDate()), EightDExcelExporter.nz(event.getDescription(), "-"), EightDExcelExporter.nz(event.getWho(), "-"), EightDExcelExporter.nz(event.getWhere(), "-")));
                }
            }
        }
        return rowIndex + 1;
    }

    private static int writeD3(Sheet sheet, int rowIndex, Styles styles, EightD model, EightDExportOptions options) {
        rowIndex = EightDExcelExporter.writeSectionTitle(sheet, rowIndex, styles, "D3 - Containment Actions");
        rowIndex = EightDExcelExporter.writeTableHeader(sheet, rowIndex, styles, new String[]{"Action", "Responsible", "Target Date", "Implementation Date", "Verification Method", "Qty Contained", "Qty Rejected"});
        if (model.getContainmentActions().isEmpty()) {
            rowIndex = EightDExcelExporter.writeEmptyTableRow(sheet, rowIndex, styles, 7, "No containment actions added.");
        } else {
            for (Object row : model.getContainmentActions()) {
                rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of(EightDExcelExporter.nz(((EightDContainmentAction)row).getAction(), "-"), EightDExcelExporter.nz(((EightDContainmentAction)row).getResponsiblePerson(), "-"), EightDExcelExporter.formatDate(((EightDContainmentAction)row).getTargetDate()), EightDExcelExporter.formatDate(((EightDContainmentAction)row).getImplementationDate()), EightDExcelExporter.nz(((EightDContainmentAction)row).getVerificationMethod(), "-"), EightDExcelExporter.nz(((EightDContainmentAction)row).getQtyContained(), "-"), EightDExcelExporter.nz(((EightDContainmentAction)row).getQtyRejected(), "-")));
            }
        }
        if (options.includeD3ContainmentWindowTool()) {
            rowIndex = EightDExcelExporter.writeSectionSubTitle(sheet, rowIndex, styles, "D3 Tool - Containment Window");
            rowIndex = EightDExcelExporter.writeKeyValueRow(sheet, rowIndex, styles, "Containment Champion", model.getD3ContainmentChampion(), "Issue Number", model.getD3ContainmentIssueNumber());
            rowIndex = EightDExcelExporter.writeKeyValueRow(sheet, rowIndex, styles, "Containment Date", EightDExcelExporter.formatDate(model.getD3ContainmentDate()), "Product Name", model.getD3ContainmentProductName());
            rowIndex = EightDExcelExporter.writeKeyValueRow(sheet, rowIndex, styles, "Part Number", model.getD3ContainmentPartNumber(), "Non-conformance", model.getD3ContainmentProductNonconformance());
            rowIndex = EightDExcelExporter.writeKeyValueRow(sheet, rowIndex, styles, "Instructions", model.getD3ContainmentInstructions(), "Segregate To", model.getD3ContainmentSegregateTo());
            rowIndex = EightDExcelExporter.writeTableHeader(sheet, rowIndex, styles, new String[]{"Location", "Potential Qty", "Qty Found", "Suspect Qty", "Lot Checked", "Responsible"});
            if (model.getD3ContainmentInventoryRows().isEmpty()) {
                rowIndex = EightDExcelExporter.writeEmptyTableRow(sheet, rowIndex, styles, 6, "No inventory rows added.");
            } else {
                for (Object row : model.getD3ContainmentInventoryRows()) {
                    rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of(EightDExcelExporter.nz(((EightDContainmentInventoryRow)row).getLocation(), "-"), String.valueOf(((EightDContainmentInventoryRow)row).getPotentialQty()), String.valueOf(((EightDContainmentInventoryRow)row).getQtyFound()), String.valueOf(((EightDContainmentInventoryRow)row).getSuspectQty()), EightDExcelExporter.nz(((EightDContainmentInventoryRow)row).getLotChecked(), "-"), EightDExcelExporter.nz(((EightDContainmentInventoryRow)row).getResponsible(), "-")));
                }
            }
        }
        return rowIndex + 1;
    }

    private static int writeD4(Sheet sheet, int rowIndex, Styles styles, Workbook workbook, EightD model, EightDExportOptions options) throws IOException {
        rowIndex = EightDExcelExporter.writeSectionTitle(sheet, rowIndex, styles, "D4 - Possible Causes");
        rowIndex = EightDExcelExporter.writeTableHeader(sheet, rowIndex, styles, new String[]{"Method", "Machine", "Material", "Manpower"});
        int rows = Math.max(Math.max(model.getPossibleCausesMethod().size(), model.getPossibleCausesMachine().size()), Math.max(model.getPossibleCausesMaterial().size(), model.getPossibleCausesManpower().size()));
        if (rows == 0) {
            rowIndex = EightDExcelExporter.writeEmptyTableRow(sheet, rowIndex, styles, 4, "No possible causes added.");
        } else {
            for (int i = 0; i < rows; ++i) {
                rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of(EightDExcelExporter.valueAt(model.getPossibleCausesMethod(), i), EightDExcelExporter.valueAt(model.getPossibleCausesMachine(), i), EightDExcelExporter.valueAt(model.getPossibleCausesMaterial(), i), EightDExcelExporter.valueAt(model.getPossibleCausesManpower(), i)));
            }
        }
        if (options.includeD4IshikawaTool()) {
            rowIndex = EightDExcelExporter.writeSectionSubTitle(sheet, rowIndex, styles, "D4 Tool - Ishikawa");
            rowIndex = EightDExcelExporter.addIshikawaImage(sheet, workbook, rowIndex, model);
        }
        if (options.includeD4FiveWhysTool()) {
            rowIndex = EightDExcelExporter.writeSectionSubTitle(sheet, rowIndex, styles, "D4 Tool - 5-Why");
            rowIndex = EightDExcelExporter.writeKeyValueRow(sheet, rowIndex, styles, "Failure Description", model.getFiveWhysFailureDescription(), "", "");
            rowIndex = EightDExcelExporter.writeTableHeader(sheet, rowIndex, styles, new String[]{"Why", "Answer"});
            int count = Math.max(model.getFiveWhysWhy().size(), model.getFiveWhysAnswers().size());
            if (count == 0) {
                rowIndex = EightDExcelExporter.writeEmptyTableRow(sheet, rowIndex, styles, 2, "No 5-Why rows added.");
            } else {
                for (int i = 0; i < count; ++i) {
                    rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of(EightDExcelExporter.valueAt(model.getFiveWhysWhy(), i), EightDExcelExporter.valueAt(model.getFiveWhysAnswers(), i)));
                }
            }
            rowIndex = EightDExcelExporter.writeKeyValueRow(sheet, rowIndex, styles, "Proposed Actions", model.getFiveWhysProposedActions(), "", "");
        }
        return rowIndex + 1;
    }

    private static int writeD5(Sheet sheet, int rowIndex, Styles styles, EightD model) {
        rowIndex = EightDExcelExporter.writeSectionTitle(sheet, rowIndex, styles, "D5 - Corrective Actions");
        rowIndex = EightDExcelExporter.writeTableHeader(sheet, rowIndex, styles, new String[]{"Corrective Action", "Responsible", "Target Date", "Implementation Date"});
        if (model.getCorrectiveActions().isEmpty()) {
            rowIndex = EightDExcelExporter.writeEmptyTableRow(sheet, rowIndex, styles, 4, "No corrective actions added.");
        } else {
            for (EightDCorrectiveAction row : model.getCorrectiveActions()) {
                rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of(EightDExcelExporter.nz(row.getAction(), "-"), EightDExcelExporter.nz(row.getResponsiblePerson(), "-"), EightDExcelExporter.formatDate(row.getTargetDate()), EightDExcelExporter.formatDate(row.getImplementationDate())));
            }
        }
        return rowIndex + 1;
    }

    private static int writeD6(Sheet sheet, int rowIndex, Styles styles, EightD model) {
        rowIndex = EightDExcelExporter.writeSectionTitle(sheet, rowIndex, styles, "D6 - Effectiveness Verification");
        rowIndex = EightDExcelExporter.writeTableHeader(sheet, rowIndex, styles, new String[]{"Method", "Result", "Date"});
        if (model.getEffectivenessVerifications().isEmpty()) {
            rowIndex = EightDExcelExporter.writeEmptyTableRow(sheet, rowIndex, styles, 3, "No effectiveness verifications added.");
        } else {
            for (EightDEffectivenessVerification row : model.getEffectivenessVerifications()) {
                rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of(EightDExcelExporter.nz(row.getMethod(), "-"), EightDExcelExporter.nz(row.getResult(), "-"), EightDExcelExporter.formatDate(row.getDate())));
            }
        }
        return rowIndex + 1;
    }

    private static int writeD7(Sheet sheet, int rowIndex, Styles styles, EightD model) {
        rowIndex = EightDExcelExporter.writeSectionTitle(sheet, rowIndex, styles, "D7 - Preventive Actions");
        rowIndex = EightDExcelExporter.writeTableHeader(sheet, rowIndex, styles, new String[]{"Product", "Lines", "Responsible", "Target", "Implementation", "Verification Method", "Verification Result", "Verification Date"});
        if (model.getPreventiveActions().isEmpty()) {
            rowIndex = EightDExcelExporter.writeEmptyTableRow(sheet, rowIndex, styles, 8, "No preventive actions added.");
        } else {
            for (EightDPreventiveAction row : model.getPreventiveActions()) {
                rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of(EightDExcelExporter.nz(row.getProduct(), "-"), EightDExcelExporter.nz(row.getLines(), "-"), EightDExcelExporter.nz(row.getResponsiblePerson(), "-"), EightDExcelExporter.formatDate(row.getTargetDate()), EightDExcelExporter.formatDate(row.getImplementationDate()), EightDExcelExporter.nz(row.getVerificationMethod(), "-"), EightDExcelExporter.nz(row.getVerificationResult(), "-"), EightDExcelExporter.formatDate(row.getVerificationDate())));
            }
        }
        List<String> checklist = EightDExcelExporter.collectD7Checklist(model);
        rowIndex = EightDExcelExporter.writeSectionSubTitle(sheet, rowIndex, styles, "Documents / updates checked");
        if (checklist.isEmpty()) {
            rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of("None selected"));
            sheet.addMergedRegion(new CellRangeAddress(rowIndex - 1, rowIndex - 1, 0, 8));
        } else {
            for (String item : checklist) {
                rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of(item));
                sheet.addMergedRegion(new CellRangeAddress(rowIndex - 1, rowIndex - 1, 0, 8));
            }
        }
        return rowIndex + 1;
    }

    private static int writeD8(Sheet sheet, int rowIndex, Styles styles, EightD model) {
        rowIndex = EightDExcelExporter.writeSectionTitle(sheet, rowIndex, styles, "D8 - Review and Approvals");
        rowIndex = EightDExcelExporter.writeTableHeader(sheet, rowIndex, styles, new String[]{"Role", "Name", "Date", "Signature"});
        rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of("Submitted by", EightDExcelExporter.nz(model.getD8SubmittedBy(), "-"), EightDExcelExporter.formatDate(model.getD8SubmissionDate()), ""));
        rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of("Internal Quality Representative", EightDExcelExporter.nz(model.getD8InternalQualityRepresentative(), "-"), EightDExcelExporter.formatDate(model.getD8InternalQualityApprovalDate()), ""));
        rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of("Internal Representative 1", EightDExcelExporter.nz(model.getD8InternalRepresentative1(), "-"), EightDExcelExporter.formatDate(model.getD8InternalRepresentative1ApprovalDate()), ""));
        rowIndex = EightDExcelExporter.writeTableRow(sheet, rowIndex, styles, List.of("Internal Representative 2", EightDExcelExporter.nz(model.getD8InternalRepresentative2(), "-"), EightDExcelExporter.formatDate(model.getD8InternalRepresentative2ApprovalDate()), ""));
        return rowIndex + 1;
    }

    private static int writeCustomerSignature(Sheet sheet, int rowIndex, Styles styles) {
        rowIndex = EightDExcelExporter.writeSectionTitle(sheet, rowIndex, styles, "Customer Signature");
        rowIndex = EightDExcelExporter.writeTableHeader(sheet, rowIndex, styles, new String[]{"Customer Name", "Signature", "Date", "Comment"});
        Row row = sheet.createRow(rowIndex++);
        row.setHeightInPoints(44.0f);
        for (int i = 0; i < 4; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue("");
            cell.setCellStyle(styles.value);
        }
        return rowIndex;
    }

    private static int addIshikawaImage(Sheet sheet, Workbook workbook, int rowIndex, EightD model) throws IOException {
        ByteArrayOutputStream pngOut = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)IshikawaDiagramRenderer.render(model, 1700, 900), "png", pngOut);
        byte[] imageBytes = pngOut.toByteArray();
        if (imageBytes.length == 0) {
            return rowIndex;
        }
        if (ImageIO.read(new ByteArrayInputStream(imageBytes)) == null) {
            return rowIndex;
        }
        int pictureIdx = workbook.addPicture(imageBytes, 6);
        CreationHelper helper = workbook.getCreationHelper();
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = helper.createClientAnchor();
        anchor.setCol1(0);
        anchor.setRow1(rowIndex);
        anchor.setCol2(8);
        anchor.setRow2(rowIndex + 20);
        drawing.createPicture(anchor, pictureIdx);
        for (int i = 0; i <= 20; ++i) {
            Row row = sheet.getRow(rowIndex + i);
            if (row == null) {
                row = sheet.createRow(rowIndex + i);
            }
            row.setHeightInPoints(20.0f);
        }
        return rowIndex + 21;
    }

    private static int writeSectionTitle(Sheet sheet, int rowIndex, Styles styles, String title) {
        Row row = sheet.createRow(rowIndex++);
        Cell cell = row.createCell(0);
        cell.setCellValue(title);
        cell.setCellStyle(styles.stage);
        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), 0, 8));
        return rowIndex;
    }

    private static int writeSectionSubTitle(Sheet sheet, int rowIndex, Styles styles, String title) {
        Row row = sheet.createRow(rowIndex++);
        Cell cell = row.createCell(0);
        cell.setCellValue(title);
        cell.setCellStyle(styles.sectionLabel);
        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), 0, 8));
        return rowIndex;
    }

    private static int writeTableHeader(Sheet sheet, int rowIndex, Styles styles, String[] headers) {
        Row row = sheet.createRow(rowIndex++);
        for (int i = 0; i < headers.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(headers[i]);
            cell.setCellStyle(styles.header);
        }
        return rowIndex;
    }

    private static int writeTableRow(Sheet sheet, int rowIndex, Styles styles, List<String> values) {
        Row row = sheet.createRow(rowIndex++);
        for (int i = 0; i < values.size(); ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(EightDExcelExporter.nz(values.get(i), "-"));
            cell.setCellStyle(styles.value);
        }
        return rowIndex;
    }

    private static int writeEmptyTableRow(Sheet sheet, int rowIndex, Styles styles, int colSpan, String text) {
        Row row = sheet.createRow(rowIndex++);
        Cell cell = row.createCell(0);
        cell.setCellValue(text);
        cell.setCellStyle(styles.value);
        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), 0, Math.max(0, colSpan - 1)));
        return rowIndex;
    }

    private static int writeKeyValueRow(Sheet sheet, int rowIndex, Styles styles, String key1, String value1, String key2, String value2) {
        Row row = sheet.createRow(rowIndex++);
        Cell k1 = row.createCell(0);
        k1.setCellValue(EightDExcelExporter.nz(key1, ""));
        k1.setCellStyle(styles.label);
        Cell v1 = row.createCell(1);
        v1.setCellValue(EightDExcelExporter.nz(value1, "-"));
        v1.setCellStyle(styles.value);
        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), 1, 3));
        Cell k2 = row.createCell(4);
        k2.setCellValue(EightDExcelExporter.nz(key2, ""));
        k2.setCellStyle(styles.label);
        Cell v2 = row.createCell(5);
        v2.setCellValue(EightDExcelExporter.nz(value2, "-"));
        v2.setCellStyle(styles.value);
        sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), 5, 8));
        return rowIndex;
    }

    private static void placeLogo(Workbook workbook, Sheet sheet, Path logoPath) {
        byte[] logoBytes = PdfAssets.loadLogoBytes(logoPath);
        if (logoBytes == null || logoBytes.length == 0) {
            return;
        }
        try {
            int pictureIdx = workbook.addPicture(logoBytes, 6);
            CreationHelper helper = workbook.getCreationHelper();
            Drawing drawing = sheet.createDrawingPatriarch();
            ClientAnchor anchor = helper.createClientAnchor();
            anchor.setCol1(7);
            anchor.setRow1(0);
            anchor.setCol2(9);
            anchor.setRow2(5);
            drawing.createPicture(anchor, pictureIdx);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static List<String> collectD7Checklist(EightD model) {
        ArrayList<String> items = new ArrayList<String>();
        EightDExcelExporter.appendChecklist(items, model.isD7DesignFmeaChecked(), "Design FMEA", model.getD7DesignFmeaDate());
        EightDExcelExporter.appendChecklist(items, model.isD7ProcessFmeaChecked(), "Process FMEA", model.getD7ProcessFmeaDate());
        EightDExcelExporter.appendChecklist(items, model.isD7ControlPlansChecked(), "Control Plans", model.getD7ControlPlansDate());
        EightDExcelExporter.appendChecklist(items, model.isD7GageDrawingChecked(), "Gage Drawing", model.getD7GageDrawingDate());
        EightDExcelExporter.appendChecklist(items, model.isD7ProcessFlowChecked(), "Process Flow", model.getD7ProcessFlowDate());
        EightDExcelExporter.appendChecklist(items, model.isD7WorkInstructionsChecked(), "Work Instructions", model.getD7WorkInstructionsDate());
        EightDExcelExporter.appendChecklist(items, model.isD7DrawingChecked(), "Drawing", model.getD7DrawingDate());
        EightDExcelExporter.appendChecklist(items, model.isD7DesignStandardsChecked(), "Design Standards", model.getD7DesignStandardsDate());
        EightDExcelExporter.appendChecklist(items, model.isD7PackingSpecsChecked(), "Packing Specs", model.getD7PackingSpecsDate());
        EightDExcelExporter.appendChecklist(items, model.isD7InternalAuditChecked(), "Internal Audit", model.getD7InternalAuditDate());
        EightDExcelExporter.appendChecklist(items, model.isD7ToolingDrawingChecked(), "Tooling Drawing", model.getD7ToolingDrawingDate());
        EightDExcelExporter.appendChecklist(items, model.isD7OperatorTrainingChecked(), "Operator Training", model.getD7OperatorTrainingDate());
        return items;
    }

    private static void appendChecklist(List<String> out, boolean checked, String label, LocalDate date) {
        if (!checked) {
            return;
        }
        out.add(label + " (" + EightDExcelExporter.formatDate(date) + ")");
    }

    private static String valueAt(List<String> values, int index) {
        if (values == null || index < 0 || index >= values.size()) {
            return "-";
        }
        return EightDExcelExporter.nz(values.get(index), "-");
    }

    private static String formatDate(LocalDate date) {
        return date == null ? "-" : DATE_FMT.format(date);
    }

    private static String nz(String value, String fallback) {
        if (value == null) {
            return fallback;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? fallback : trimmed;
    }

    private static String firstNonBlank(String ... values) {
        if (values == null) {
            return "";
        }
        for (String value : values) {
            if (value == null || value.isBlank()) continue;
            return value.trim();
        }
        return "";
    }

    private static final class Styles {
        private final CellStyle title;
        private final CellStyle stage;
        private final CellStyle sectionLabel;
        private final CellStyle header;
        private final CellStyle label;
        private final CellStyle value;
        private final CellStyle wrappedValue;
        private final CellStyle small;

        private Styles(Workbook workbook) {
            Font titleFont = workbook.createFont();
            titleFont.setBold(true);
            titleFont.setFontHeightInPoints((short)15);
            this.title = workbook.createCellStyle();
            this.title.setFont(titleFont);
            this.title.setAlignment(HorizontalAlignment.LEFT);
            Font stageFont = workbook.createFont();
            stageFont.setBold(true);
            stageFont.setFontHeightInPoints((short)12);
            this.stage = workbook.createCellStyle();
            this.stage.setFont(stageFont);
            this.stage.setAlignment(HorizontalAlignment.LEFT);
            Font sectionFont = workbook.createFont();
            sectionFont.setBold(true);
            this.sectionLabel = workbook.createCellStyle();
            this.sectionLabel.setFont(sectionFont);
            this.sectionLabel.setAlignment(HorizontalAlignment.LEFT);
            Font headerFont = workbook.createFont();
            headerFont.setBold(true);
            this.header = workbook.createCellStyle();
            this.header.setFont(headerFont);
            this.header.setAlignment(HorizontalAlignment.CENTER);
            this.header.setVerticalAlignment(VerticalAlignment.CENTER);
            this.header.setWrapText(true);
            this.applyBorder(this.header);
            Font labelFont = workbook.createFont();
            labelFont.setBold(true);
            this.label = workbook.createCellStyle();
            this.label.setFont(labelFont);
            this.label.setAlignment(HorizontalAlignment.RIGHT);
            this.label.setVerticalAlignment(VerticalAlignment.CENTER);
            this.applyBorder(this.label);
            this.value = workbook.createCellStyle();
            this.value.setAlignment(HorizontalAlignment.LEFT);
            this.value.setVerticalAlignment(VerticalAlignment.TOP);
            this.value.setWrapText(true);
            this.applyBorder(this.value);
            this.wrappedValue = workbook.createCellStyle();
            this.wrappedValue.cloneStyleFrom(this.value);
            this.wrappedValue.setVerticalAlignment(VerticalAlignment.TOP);
            this.wrappedValue.setWrapText(true);
            this.small = workbook.createCellStyle();
            Font smallFont = workbook.createFont();
            smallFont.setFontHeightInPoints((short)9);
            this.small.setFont(smallFont);
        }

        private void applyBorder(CellStyle style) {
            style.setBorderTop(BorderStyle.THIN);
            style.setBorderBottom(BorderStyle.THIN);
            style.setBorderLeft(BorderStyle.THIN);
            style.setBorderRight(BorderStyle.THIN);
        }
    }
}

