/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.eightd;

import com.qualidadeeprodutividade.CoreTools;
import com.qualidadeeprodutividade.platform.AppPaths;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;

public final class EightDImageStorage {
    private static final String IMAGES_FOLDER = "eightd-images";
    private static final Pattern UUID_FILE_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}\\.[A-Za-z0-9]+$");
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("^[A-Za-z0-9._-]+$");

    private EightDImageStorage() {
    }

    public static String storeCopy(File source) throws IOException {
        return EightDImageStorage.storeCopy(null, source);
    }

    public static String storeCopy(String projectId, File source) throws IOException {
        if (source == null || !source.isFile()) {
            throw new IllegalArgumentException("source image file is invalid");
        }
        String identifier = UUID.randomUUID().toString();
        String extension = EightDImageStorage.extractExtension(source.getName());
        String storedName = identifier + extension;
        String namespace = EightDImageStorage.normalizeNamespace(projectId);
        Path target = EightDImageStorage.getStorageDirectory(namespace, true).resolve(storedName);
        Files.copy(source.toPath(), target, StandardCopyOption.REPLACE_EXISTING);
        return EightDImageStorage.toManagedIdentifier(namespace, storedName);
    }

    public static File resolveStoredFile(String persistedValue) {
        Path reference;
        if (persistedValue == null || persistedValue.isBlank()) {
            return null;
        }
        try {
            reference = Path.of(persistedValue.trim(), new String[0]);
        }
        catch (RuntimeException ex) {
            return new File(persistedValue.trim());
        }
        if (reference.isAbsolute()) {
            return reference.toFile();
        }
        for (Path path : EightDImageStorage.resolveStorageDirectoryCandidates()) {
            Path candidate = path.resolve(reference).normalize();
            if (!Files.exists(candidate, new LinkOption[0])) continue;
            return candidate.toFile();
        }
        List<Path> managedCandidates = EightDImageStorage.resolveManagedPathCandidates(persistedValue);
        for (Path candidate : managedCandidates) {
            if (!Files.exists(candidate, new LinkOption[0])) continue;
            return candidate.toFile();
        }
        if (!managedCandidates.isEmpty()) {
            return managedCandidates.get(0).toFile();
        }
        Path path = EightDImageStorage.getStorageDirectoryFallback().resolve(reference.getFileName()).normalize();
        return path.toFile();
    }

    public static boolean deleteManagedFile(String persistedValue) {
        List<Path> candidates = EightDImageStorage.resolveManagedPathCandidates(persistedValue);
        if (candidates.isEmpty()) {
            return false;
        }
        boolean deletedAny = false;
        for (Path candidate : candidates) {
            try {
                deletedAny |= Files.deleteIfExists(candidate);
            }
            catch (IOException iOException) {}
        }
        return deletedAny;
    }

    public static boolean isManagedIdentifier(String persistedValue) {
        return !EightDImageStorage.resolveManagedPathCandidates(persistedValue).isEmpty();
    }

    private static Path getStorageDirectory(String namespace, boolean requireWritable) throws IOException {
        IOException lastError = null;
        Iterator<Path> iterator = EightDImageStorage.resolveWritableStorageRoots().iterator();
        while (iterator.hasNext()) {
            Path root;
            Path storage = root = iterator.next();
            if (namespace != null && !namespace.isBlank()) {
                storage = storage.resolve(namespace);
            }
            try {
                Files.createDirectories(storage, new FileAttribute[0]);
                if (requireWritable && !Files.isWritable(storage)) continue;
                return storage;
            }
            catch (IOException ex) {
                lastError = ex;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        throw new IOException("No writable storage directory available for 8D images.");
    }

    private static Path getStorageDirectoryFallback() {
        try {
            return EightDImageStorage.getStorageDirectory(null, false);
        }
        catch (IOException ex) {
            return EightDImageStorage.resolveWritableStorageRoots().get(0);
        }
    }

    private static List<Path> resolveWritableStorageRoots() {
        return List.of(AppPaths.eightDImagesDirectory().normalize());
    }

    private static List<Path> resolveStorageDirectoryCandidates() {
        Path appRootCandidate;
        ArrayList<Path> candidates = new ArrayList<Path>(3);
        Path userDataCandidate = AppPaths.eightDImagesDirectory().normalize();
        candidates.add(userDataCandidate);
        Path legacyHiddenCandidate = AppPaths.legacyHiddenDirectory().resolve(IMAGES_FOLDER).normalize();
        if (!legacyHiddenCandidate.equals(userDataCandidate)) {
            candidates.add(legacyHiddenCandidate);
        }
        if (!(appRootCandidate = EightDImageStorage.resolveAppRoot().resolve(IMAGES_FOLDER).normalize()).equals(userDataCandidate) && !appRootCandidate.equals(legacyHiddenCandidate)) {
            candidates.add(appRootCandidate);
        }
        return candidates;
    }

    private static List<Path> resolveManagedPathCandidates(String persistedValue) {
        Path ref;
        ArrayList<Path> out = new ArrayList<Path>();
        if (persistedValue == null || persistedValue.isBlank()) {
            return out;
        }
        String trimmed = persistedValue.trim();
        try {
            ref = Path.of(trimmed, new String[0]);
        }
        catch (RuntimeException ex) {
            return out;
        }
        if (ref.isAbsolute()) {
            return out;
        }
        if (ref.getNameCount() == 1) {
            String fileName = ref.getFileName().toString();
            if (!EightDImageStorage.isUuidBasedFileName(fileName)) {
                return out;
            }
            for (Path root : EightDImageStorage.resolveStorageDirectoryCandidates()) {
                out.add(root.resolve(fileName).normalize());
            }
            return out;
        }
        if (ref.getNameCount() == 2) {
            String namespace = ref.getName(0).toString();
            String fileName = ref.getName(1).toString();
            if (!NAMESPACE_PATTERN.matcher(namespace).matches() || !EightDImageStorage.isUuidBasedFileName(fileName)) {
                return out;
            }
            for (Path root : EightDImageStorage.resolveStorageDirectoryCandidates()) {
                out.add(root.resolve(namespace).resolve(fileName).normalize());
            }
            return out;
        }
        return out;
    }

    private static String toManagedIdentifier(String namespace, String storedName) {
        if (namespace == null || namespace.isBlank()) {
            return storedName;
        }
        return namespace + "/" + storedName;
    }

    private static String normalizeNamespace(String rawProjectId) {
        if (rawProjectId == null || rawProjectId.isBlank()) {
            return null;
        }
        String raw = rawProjectId.trim();
        StringBuilder out = new StringBuilder(raw.length());
        for (int i = 0; i < raw.length(); ++i) {
            char ch = raw.charAt(i);
            boolean allowed = Character.isLetterOrDigit(ch) || ch == '.' || ch == '_' || ch == '-';
            out.append(allowed ? ch : (char)'_');
        }
        String normalized = out.toString();
        while (normalized.contains("__")) {
            normalized = normalized.replace("__", "_");
        }
        if ((normalized = normalized.strip()).isBlank()) {
            return null;
        }
        return normalized.toLowerCase(Locale.ROOT);
    }

    private static boolean isUuidBasedFileName(String fileName) {
        if (fileName == null || fileName.isBlank()) {
            return false;
        }
        return UUID_FILE_PATTERN.matcher(fileName).matches();
    }

    private static Path resolveAppRoot() {
        Path fromCodeSource = EightDImageStorage.resolveFromCodeSource();
        if (fromCodeSource != null) {
            return fromCodeSource;
        }
        String userDir = System.getProperty("user.dir");
        if (userDir == null || userDir.isBlank()) {
            return Paths.get(".", new String[0]).toAbsolutePath().normalize();
        }
        return Paths.get(userDir, new String[0]).toAbsolutePath().normalize();
    }

    private static Path resolveFromCodeSource() {
        try {
            URI locationUri = CoreTools.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            Path location = Paths.get(locationUri).toAbsolutePath().normalize();
            if (Files.isRegularFile(location, new LinkOption[0])) {
                return location.getParent();
            }
            if (Files.isDirectory(location, new LinkOption[0])) {
                Path fileName = location.getFileName();
                Path parent = location.getParent();
                if (fileName != null && "classes".equalsIgnoreCase(fileName.toString()) && parent != null && parent.getFileName() != null && "target".equalsIgnoreCase(parent.getFileName().toString()) && parent.getParent() != null) {
                    return parent.getParent().toAbsolutePath().normalize();
                }
                return location;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String extractExtension(String fileName) {
        if (fileName == null || fileName.isBlank()) {
            return ".img";
        }
        int dot = fileName.lastIndexOf(46);
        if (dot <= 0 || dot >= fileName.length() - 1) {
            return ".img";
        }
        return fileName.substring(dot);
    }
}

