/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.eightd;

import com.qualidadeeprodutividade.eightd.EightD;
import com.qualidadeeprodutividade.eightd.EightDContainmentAction;
import com.qualidadeeprodutividade.eightd.EightDContainmentInventoryRow;
import com.qualidadeeprodutividade.eightd.EightDCorrectiveAction;
import com.qualidadeeprodutividade.eightd.EightDEffectivenessVerification;
import com.qualidadeeprodutividade.eightd.EightDEvent;
import com.qualidadeeprodutividade.eightd.EightDExportOptions;
import com.qualidadeeprodutividade.eightd.EightDImage;
import com.qualidadeeprodutividade.eightd.EightDImageStorage;
import com.qualidadeeprodutividade.eightd.EightDPreventiveAction;
import com.qualidadeeprodutividade.eightd.EightDTeamMember;
import com.qualidadeeprodutividade.eightd.IshikawaDiagramRenderer;
import com.qualidadeeprodutividade.pdf.PdfAssets;
import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.collections.ObservableList;
import javax.imageio.ImageIO;
import org.openpdf.text.Document;
import org.openpdf.text.DocumentException;
import org.openpdf.text.Element;
import org.openpdf.text.Font;
import org.openpdf.text.FontFactory;
import org.openpdf.text.Image;
import org.openpdf.text.PageSize;
import org.openpdf.text.Paragraph;
import org.openpdf.text.Phrase;
import org.openpdf.text.Rectangle;
import org.openpdf.text.pdf.PdfPCell;
import org.openpdf.text.pdf.PdfPTable;
import org.openpdf.text.pdf.PdfWriter;

public final class EightDPdfGenerator {
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final Font FONT_TITLE = FontFactory.getFont((String)"Helvetica-Bold", (float)22.0f);
    private static final Font FONT_SUBTITLE = FontFactory.getFont((String)"Helvetica", (float)10.0f);
    private static final Font FONT_STAGE = FontFactory.getFont((String)"Helvetica-Bold", (float)14.0f);
    private static final Font FONT_LABEL = FontFactory.getFont((String)"Helvetica-Bold", (float)9.0f);
    private static final Font FONT_TEXT = FontFactory.getFont((String)"Helvetica", (float)9.0f);
    private static final Font FONT_SMALL = FontFactory.getFont((String)"Helvetica", (float)8.0f);

    private EightDPdfGenerator() {
    }

    public static void export(EightD model, EightDExportOptions options, Path targetPath, Path logoPath) throws IOException, DocumentException {
        Objects.requireNonNull(model, "8D report is null");
        Objects.requireNonNull(targetPath, "Target path is null");
        if (options == null) {
            options = EightDExportOptions.allEnabled();
        }
        if (targetPath.getParent() != null) {
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        }
        Rectangle pageSize = PageSize.A2;
        Document document = new Document(pageSize, 28.0f, 28.0f, 24.0f, 28.0f);
        try (FileOutputStream out = new FileOutputStream(targetPath.toFile());){
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            EightDPdfGenerator.addTitle(document, model, logoPath);
            EightDPdfGenerator.addHeaderSection(document, model);
            if (options.includeD1TeamMembers()) {
                EightDPdfGenerator.ensureSectionSpace(document, writer, EightDPdfGenerator.estimateRowsHeight(model.getTeamMembers().size(), 190.0f));
                EightDPdfGenerator.addD1(document, model);
            }
            if (options.includeD2ProblemDescription()) {
                EightDPdfGenerator.ensureSectionSpace(document, writer, 260.0f);
                EightDPdfGenerator.addD2(document, model, options);
            }
            if (options.includeD3ContainmentActions()) {
                EightDPdfGenerator.ensureSectionSpace(document, writer, EightDPdfGenerator.estimateRowsHeight(model.getContainmentActions().size(), 200.0f));
                EightDPdfGenerator.addD3(document, model, options);
            }
            if (options.includeD4PossibleCauses()) {
                EightDPdfGenerator.ensureSectionSpace(document, writer, 300.0f);
                EightDPdfGenerator.addD4(document, writer, model, options);
            }
            if (options.includeD5CorrectiveActions()) {
                EightDPdfGenerator.ensureSectionSpace(document, writer, EightDPdfGenerator.estimateRowsHeight(model.getCorrectiveActions().size(), 180.0f));
                EightDPdfGenerator.addD5(document, model);
            }
            if (options.includeD6EffectivenessVerification()) {
                EightDPdfGenerator.ensureSectionSpace(document, writer, EightDPdfGenerator.estimateRowsHeight(model.getEffectivenessVerifications().size(), 180.0f));
                EightDPdfGenerator.addD6(document, model);
            }
            if (options.includeD7PreventiveActions()) {
                EightDPdfGenerator.ensureSectionSpace(document, writer, EightDPdfGenerator.estimateRowsHeight(model.getPreventiveActions().size(), 220.0f));
                EightDPdfGenerator.addD7(document, model);
            }
            if (options.includeD8ReviewApprovals()) {
                EightDPdfGenerator.ensureSectionSpace(document, writer, 180.0f);
                EightDPdfGenerator.addD8(document, model);
            }
            EightDPdfGenerator.ensureSectionSpace(document, writer, 150.0f);
            EightDPdfGenerator.addCustomerSignatureBlock(document);
            document.close();
        }
    }

    private static void addTitle(Document doc, EightD model, Path logoPath) throws DocumentException {
        String claim = EightDPdfGenerator.firstNonBlank(model.getInternalClaimNumber(), model.getCustomerClaimNumber(), "8D Report");
        Paragraph title = new Paragraph("8D Corrective Action Report - " + claim, FONT_TITLE);
        title.setSpacingAfter(6.0f);
        String subtitleText = "Status: " + EightDPdfGenerator.nz(model.getStatus(), "N/A") + "   Date Opened: " + EightDPdfGenerator.formatDate(model.getDateOpened()) + "   Date Revised: " + EightDPdfGenerator.formatDate(model.getDateRevised()) + "   Closed Date: " + EightDPdfGenerator.formatDate(model.getClosedDate());
        Paragraph subtitle = new Paragraph(subtitleText, FONT_SUBTITLE);
        PdfPTable table = new PdfPTable(new float[]{1.0f, 0.3f});
        table.setWidthPercentage(100.0f);
        PdfPCell textCell = new PdfPCell();
        textCell.setBorder(0);
        textCell.setPadding(0.0f);
        textCell.addElement((Element)title);
        textCell.addElement((Element)subtitle);
        table.addCell(textCell);
        PdfPCell logoCell = new PdfPCell();
        logoCell.setBorder(0);
        logoCell.setPadding(0.0f);
        logoCell.setHorizontalAlignment(2);
        logoCell.setVerticalAlignment(4);
        Image logo = PdfAssets.loadLogo(logoPath);
        if (logo != null) {
            logo.scaleToFit(160.0f, 90.0f);
            logo.setAlignment(2);
            logoCell.addElement((Element)logo);
        }
        table.addCell(logoCell);
        table.setSpacingAfter(8.0f);
        doc.add((Element)table);
    }

    private static void addHeaderSection(Document doc, EightD model) throws DocumentException {
        PdfPTable table = new PdfPTable(new float[]{12.0f, 26.0f, 12.0f, 26.0f});
        table.setWidthPercentage(100.0f);
        EightDPdfGenerator.addKeyValue(table, "Internal Claim Number", EightDPdfGenerator.nz(model.getInternalClaimNumber(), "-"));
        EightDPdfGenerator.addKeyValue(table, "Customer Claim Number", EightDPdfGenerator.nz(model.getCustomerClaimNumber(), "-"));
        EightDPdfGenerator.addKeyValue(table, "Customer", EightDPdfGenerator.nz(model.getCustomer(), "-"));
        EightDPdfGenerator.addKeyValue(table, "Customer Contact", EightDPdfGenerator.nz(model.getCustomerContact(), "-"));
        EightDPdfGenerator.addKeyValue(table, "Internal Contact", EightDPdfGenerator.nz(model.getInternalContact(), "-"));
        EightDPdfGenerator.addKeyValue(table, "Containment Due Date", EightDPdfGenerator.formatDate(model.getContainmentDueDate()));
        EightDPdfGenerator.addKeyValue(table, "Part Number", EightDPdfGenerator.nz(model.getPartNumber(), "-"));
        EightDPdfGenerator.addKeyValue(table, "Part Description", EightDPdfGenerator.nz(model.getPartDescription(), "-"));
        EightDPdfGenerator.addKeyValue(table, "Quantity", EightDPdfGenerator.nz(model.getQuantity(), "-"));
        EightDPdfGenerator.addKeyValue(table, "Status", EightDPdfGenerator.nz(model.getStatus(), "-"));
        table.setSpacingAfter(4.0f);
        doc.add((Element)table);
        Paragraph nonConformanceTitle = new Paragraph("Non-conformance description", FONT_LABEL);
        nonConformanceTitle.setSpacingBefore(2.0f);
        nonConformanceTitle.setSpacingAfter(2.0f);
        doc.add((Element)nonConformanceTitle);
        PdfPTable nonConformance = new PdfPTable(1);
        nonConformance.setWidthPercentage(100.0f);
        PdfPCell ncCell = new PdfPCell(new Phrase(EightDPdfGenerator.nz(model.getNonConformanceNotification(), "-"), FONT_TEXT));
        ncCell.setPadding(6.0f);
        ncCell.setMinimumHeight(50.0f);
        nonConformance.addCell(ncCell);
        nonConformance.setSpacingAfter(8.0f);
        doc.add((Element)nonConformance);
    }

    private static void addD1(Document doc, EightD model) throws DocumentException {
        EightDPdfGenerator.addStageTitle(doc, "D1 - Team Members");
        PdfPTable table = new PdfPTable(new float[]{16.0f, 14.0f, 14.0f, 16.0f, 24.0f, 20.0f});
        table.setWidthPercentage(100.0f);
        EightDPdfGenerator.addHeaderCell(table, "Name");
        EightDPdfGenerator.addHeaderCell(table, "Role / Function");
        EightDPdfGenerator.addHeaderCell(table, "Department");
        EightDPdfGenerator.addHeaderCell(table, "Company");
        EightDPdfGenerator.addHeaderCell(table, "Responsibility in 8D");
        EightDPdfGenerator.addHeaderCell(table, "E-mail");
        ObservableList<EightDTeamMember> members = model.getTeamMembers();
        if (members == null || members.isEmpty()) {
            EightDPdfGenerator.addEmptyRow(table, 6, "No team members added.");
        } else {
            for (EightDTeamMember row : members) {
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getName(), "-"));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getRoleFunction(), "-"));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getDepartment(), "-"));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getCompany(), "-"));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getResponsibility(), "-"));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getEmail(), "-"));
            }
        }
        table.setSpacingAfter(6.0f);
        doc.add((Element)table);
    }

    private static void addD2(Document doc, EightD model, EightDExportOptions options) throws DocumentException {
        PdfPTable table;
        Paragraph title;
        EightDPdfGenerator.addStageTitle(doc, "D2 - Problem Description");
        Paragraph problem = new Paragraph(EightDPdfGenerator.nz(model.getProblemDescription(), "-"), FONT_TEXT);
        problem.setSpacingAfter(6.0f);
        doc.add((Element)problem);
        EightDPdfGenerator.addD2PhotoGallery(doc, model);
        if (options.includeD2IsIsNotTool()) {
            title = new Paragraph("D2 Tool - Is x Is Not", FONT_LABEL);
            title.setSpacingAfter(3.0f);
            doc.add((Element)title);
            table = new PdfPTable(new float[]{16.0f, 24.0f, 24.0f});
            table.setWidthPercentage(100.0f);
            EightDPdfGenerator.addHeaderCell(table, "Dimension");
            EightDPdfGenerator.addHeaderCell(table, "Is");
            EightDPdfGenerator.addHeaderCell(table, "Is Not");
            EightDPdfGenerator.addValueCell(table, "What");
            EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(model.getD2IsWhat(), "-"));
            EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(model.getD2IsNotWhat(), "-"));
            EightDPdfGenerator.addValueCell(table, "Where");
            EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(model.getD2IsWhere(), "-"));
            EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(model.getD2IsNotWhere(), "-"));
            EightDPdfGenerator.addValueCell(table, "When");
            EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(model.getD2IsWhen(), "-"));
            EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(model.getD2IsNotWhen(), "-"));
            EightDPdfGenerator.addValueCell(table, "How many");
            EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(model.getD2IsHowMany(), "-"));
            EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(model.getD2IsNotHowMany(), "-"));
            table.setSpacingAfter(6.0f);
            doc.add((Element)table);
        }
        if (options.includeD2DiffChangesTool()) {
            title = new Paragraph("D2 Tool - Difference & Changes", FONT_LABEL);
            title.setSpacingAfter(3.0f);
            doc.add((Element)title);
            table = new PdfPTable(new float[]{30.0f, 35.0f, 35.0f});
            table.setWidthPercentage(100.0f);
            EightDPdfGenerator.addHeaderCell(table, "Row");
            EightDPdfGenerator.addHeaderCell(table, "Contrast");
            EightDPdfGenerator.addHeaderCell(table, "Changes");
            EightDPdfGenerator.addDiffRow(table, "1", model.getD2DiffContrast1(), model.getD2DiffChange1());
            EightDPdfGenerator.addDiffRow(table, "2", model.getD2DiffContrast2(), model.getD2DiffChange2());
            EightDPdfGenerator.addDiffRow(table, "3", model.getD2DiffContrast3(), model.getD2DiffChange3());
            EightDPdfGenerator.addDiffRow(table, "4", model.getD2DiffContrast4(), model.getD2DiffChange4());
            table.setSpacingAfter(6.0f);
            doc.add((Element)table);
        }
        if (options.includeD2EventsTool()) {
            title = new Paragraph("D2 Tool - Events", FONT_LABEL);
            title.setSpacingAfter(3.0f);
            doc.add((Element)title);
            table = new PdfPTable(new float[]{12.0f, 46.0f, 20.0f, 22.0f});
            table.setWidthPercentage(100.0f);
            EightDPdfGenerator.addHeaderCell(table, "Date");
            EightDPdfGenerator.addHeaderCell(table, "Description");
            EightDPdfGenerator.addHeaderCell(table, "Who");
            EightDPdfGenerator.addHeaderCell(table, "Where");
            ObservableList<EightDEvent> events = model.getEvents();
            if (events == null || events.isEmpty()) {
                EightDPdfGenerator.addEmptyRow(table, 4, "No events added.");
            } else {
                for (EightDEvent event : events) {
                    EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.formatDate(event.getDate()));
                    EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(event.getDescription(), "-"));
                    EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(event.getWho(), "-"));
                    EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(event.getWhere(), "-"));
                }
            }
            table.setSpacingAfter(6.0f);
            doc.add((Element)table);
        }
    }

    private static void addD3(Document doc, EightD model, EightDExportOptions options) throws DocumentException {
        EightDPdfGenerator.addStageTitle(doc, "D3 - Containment Actions");
        PdfPTable actions = new PdfPTable(new float[]{30.0f, 16.0f, 12.0f, 12.0f, 14.0f, 8.0f, 8.0f});
        actions.setWidthPercentage(100.0f);
        EightDPdfGenerator.addHeaderCell(actions, "Action");
        EightDPdfGenerator.addHeaderCell(actions, "Responsible");
        EightDPdfGenerator.addHeaderCell(actions, "Target Date");
        EightDPdfGenerator.addHeaderCell(actions, "Implementation Date");
        EightDPdfGenerator.addHeaderCell(actions, "Verification Method");
        EightDPdfGenerator.addHeaderCell(actions, "Qty Contained");
        EightDPdfGenerator.addHeaderCell(actions, "Qty Rejected");
        ObservableList<EightDContainmentAction> rows = model.getContainmentActions();
        if (rows == null || rows.isEmpty()) {
            EightDPdfGenerator.addEmptyRow(actions, 7, "No containment actions added.");
        } else {
            for (EightDContainmentAction row : rows) {
                EightDPdfGenerator.addValueCell(actions, EightDPdfGenerator.nz(row.getAction(), "-"));
                EightDPdfGenerator.addValueCell(actions, EightDPdfGenerator.nz(row.getResponsiblePerson(), "-"));
                EightDPdfGenerator.addValueCell(actions, EightDPdfGenerator.formatDate(row.getTargetDate()));
                EightDPdfGenerator.addValueCell(actions, EightDPdfGenerator.formatDate(row.getImplementationDate()));
                EightDPdfGenerator.addValueCell(actions, EightDPdfGenerator.nz(row.getVerificationMethod(), "-"));
                EightDPdfGenerator.addValueCell(actions, EightDPdfGenerator.nz(row.getQtyContained(), "-"));
                EightDPdfGenerator.addValueCell(actions, EightDPdfGenerator.nz(row.getQtyRejected(), "-"));
            }
        }
        actions.setSpacingAfter(6.0f);
        doc.add((Element)actions);
        if (!options.includeD3ContainmentWindowTool()) {
            return;
        }
        Paragraph title = new Paragraph("D3 Tool - Containment Window", FONT_LABEL);
        title.setSpacingAfter(3.0f);
        doc.add((Element)title);
        PdfPTable details = new PdfPTable(new float[]{18.0f, 32.0f, 18.0f, 32.0f});
        details.setWidthPercentage(100.0f);
        EightDPdfGenerator.addKeyValue(details, "Containment Champion", EightDPdfGenerator.nz(model.getD3ContainmentChampion(), "-"));
        EightDPdfGenerator.addKeyValue(details, "Issue Number", EightDPdfGenerator.nz(model.getD3ContainmentIssueNumber(), "-"));
        EightDPdfGenerator.addKeyValue(details, "Containment Date", EightDPdfGenerator.formatDate(model.getD3ContainmentDate()));
        EightDPdfGenerator.addKeyValue(details, "Product Name", EightDPdfGenerator.nz(model.getD3ContainmentProductName(), "-"));
        EightDPdfGenerator.addKeyValue(details, "Part Number", EightDPdfGenerator.nz(model.getD3ContainmentPartNumber(), "-"));
        EightDPdfGenerator.addKeyValue(details, "Non-conformance", EightDPdfGenerator.nz(model.getD3ContainmentProductNonconformance(), "-"));
        EightDPdfGenerator.addKeyValue(details, "Instructions", EightDPdfGenerator.nz(model.getD3ContainmentInstructions(), "-"));
        EightDPdfGenerator.addKeyValue(details, "Segregate To", EightDPdfGenerator.nz(model.getD3ContainmentSegregateTo(), "-"));
        EightDPdfGenerator.addKeyValue(details, "ID Conforming", EightDPdfGenerator.nz(model.getD3ContainmentIdentificationConforming(), "-"));
        EightDPdfGenerator.addKeyValue(details, "ID Non-conforming", EightDPdfGenerator.nz(model.getD3ContainmentIdentificationNonConforming(), "-"));
        EightDPdfGenerator.addKeyValue(details, "Quality Manager", EightDPdfGenerator.nz(model.getD3ContainmentQualityManager(), "-"));
        EightDPdfGenerator.addKeyValue(details, "Manager Date", EightDPdfGenerator.formatDate(model.getD3ContainmentQualityManagerDate()));
        details.setSpacingAfter(4.0f);
        doc.add((Element)details);
        PdfPTable inventory = new PdfPTable(new float[]{24.0f, 10.0f, 10.0f, 10.0f, 24.0f, 22.0f});
        inventory.setWidthPercentage(100.0f);
        EightDPdfGenerator.addHeaderCell(inventory, "Location");
        EightDPdfGenerator.addHeaderCell(inventory, "Potential Qty");
        EightDPdfGenerator.addHeaderCell(inventory, "Qty Found");
        EightDPdfGenerator.addHeaderCell(inventory, "Suspect Qty");
        EightDPdfGenerator.addHeaderCell(inventory, "Lot Checked");
        EightDPdfGenerator.addHeaderCell(inventory, "Responsible");
        ObservableList<EightDContainmentInventoryRow> inventoryRows = model.getD3ContainmentInventoryRows();
        if (inventoryRows == null || inventoryRows.isEmpty()) {
            EightDPdfGenerator.addEmptyRow(inventory, 6, "No inventory rows added.");
        } else {
            for (EightDContainmentInventoryRow row : inventoryRows) {
                EightDPdfGenerator.addValueCell(inventory, EightDPdfGenerator.nz(row.getLocation(), "-"));
                EightDPdfGenerator.addValueCell(inventory, String.valueOf(row.getPotentialQty()));
                EightDPdfGenerator.addValueCell(inventory, String.valueOf(row.getQtyFound()));
                EightDPdfGenerator.addValueCell(inventory, String.valueOf(row.getSuspectQty()));
                EightDPdfGenerator.addValueCell(inventory, EightDPdfGenerator.nz(row.getLotChecked(), "-"));
                EightDPdfGenerator.addValueCell(inventory, EightDPdfGenerator.nz(row.getResponsible(), "-"));
            }
        }
        inventory.setSpacingAfter(6.0f);
        doc.add((Element)inventory);
    }

    private static void addD4(Document doc, PdfWriter writer, EightD model, EightDExportOptions options) throws DocumentException {
        EightDPdfGenerator.addStageTitle(doc, "D4 - Possible Causes");
        List<String> methodCauses = EightDPdfGenerator.preferredCauses(model.getIshikawaCausesMethod(), model.getPossibleCausesMethod());
        List<String> machineCauses = EightDPdfGenerator.preferredCauses(model.getIshikawaCausesMachine(), model.getPossibleCausesMachine());
        List<String> measurementsCauses = EightDPdfGenerator.preferredCauses(model.getIshikawaCausesMeasurements(), null);
        List<String> environmentCauses = EightDPdfGenerator.preferredCauses(model.getIshikawaCausesEnvironment(), null);
        List<String> materialCauses = EightDPdfGenerator.preferredCauses(model.getIshikawaCausesMaterial(), model.getPossibleCausesMaterial());
        List<String> manpowerCauses = EightDPdfGenerator.preferredCauses(model.getIshikawaCausesManpower(), model.getPossibleCausesManpower());
        PdfPTable lists = new PdfPTable(new float[]{17.0f, 17.0f, 16.0f, 16.0f, 17.0f, 17.0f});
        lists.setWidthPercentage(100.0f);
        EightDPdfGenerator.addHeaderCell(lists, "Method");
        EightDPdfGenerator.addHeaderCell(lists, "Machine");
        EightDPdfGenerator.addHeaderCell(lists, "Measurements");
        EightDPdfGenerator.addHeaderCell(lists, "Environment");
        EightDPdfGenerator.addHeaderCell(lists, "Material");
        EightDPdfGenerator.addHeaderCell(lists, "Manpower");
        int rows = EightDPdfGenerator.maxSize(methodCauses, machineCauses, measurementsCauses, environmentCauses, materialCauses, manpowerCauses);
        if (rows == 0) {
            EightDPdfGenerator.addEmptyRow(lists, 6, "No possible causes added.");
        } else {
            for (int i = 0; i < rows; ++i) {
                EightDPdfGenerator.addValueCell(lists, EightDPdfGenerator.valueAt(methodCauses, i));
                EightDPdfGenerator.addValueCell(lists, EightDPdfGenerator.valueAt(machineCauses, i));
                EightDPdfGenerator.addValueCell(lists, EightDPdfGenerator.valueAt(measurementsCauses, i));
                EightDPdfGenerator.addValueCell(lists, EightDPdfGenerator.valueAt(environmentCauses, i));
                EightDPdfGenerator.addValueCell(lists, EightDPdfGenerator.valueAt(materialCauses, i));
                EightDPdfGenerator.addValueCell(lists, EightDPdfGenerator.valueAt(manpowerCauses, i));
            }
        }
        lists.setSpacingAfter(6.0f);
        doc.add((Element)lists);
        if (options.includeD4IshikawaTool()) {
            EightDPdfGenerator.ensureSectionSpace(doc, writer, 340.0f);
            Paragraph title = new Paragraph("D4 Tool - Ishikawa", FONT_LABEL);
            title.setSpacingAfter(3.0f);
            doc.add((Element)title);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)IshikawaDiagramRenderer.render(model, 1800, 1000), "png", baos);
                Image image = Image.getInstance((byte[])baos.toByteArray());
                float availableWidth = doc.getPageSize().getWidth() - doc.leftMargin() - doc.rightMargin();
                image.scaleToFit(availableWidth, 470.0f);
                image.setAlignment(0);
                doc.add((Element)image);
            }
            catch (Exception ex) {
                Paragraph error = new Paragraph("Unable to render Ishikawa image: " + ex.getMessage(), FONT_SMALL);
                error.setSpacingAfter(4.0f);
                doc.add((Element)error);
            }
        }
        if (options.includeD4FiveWhysTool()) {
            EightDPdfGenerator.ensureSectionSpace(doc, writer, 180.0f);
            Paragraph title = new Paragraph("D4 Tool - 5-Why", FONT_LABEL);
            title.setSpacingBefore(6.0f);
            title.setSpacingAfter(3.0f);
            doc.add((Element)title);
            PdfPTable summary = new PdfPTable(new float[]{15.0f, 85.0f});
            summary.setWidthPercentage(100.0f);
            EightDPdfGenerator.addKeyValue(summary, "Failure Description", EightDPdfGenerator.nz(model.getFiveWhysFailureDescription(), "-"));
            summary.setSpacingAfter(4.0f);
            doc.add((Element)summary);
            PdfPTable table = new PdfPTable(new float[]{40.0f, 60.0f});
            table.setWidthPercentage(100.0f);
            EightDPdfGenerator.addHeaderCell(table, "Why");
            EightDPdfGenerator.addHeaderCell(table, "Answer");
            int count = Math.max(model.getFiveWhysWhy().size(), model.getFiveWhysAnswers().size());
            if (count == 0) {
                EightDPdfGenerator.addEmptyRow(table, 2, "No 5-Why rows added.");
            } else {
                for (int i = 0; i < count; ++i) {
                    EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.valueAt(model.getFiveWhysWhy(), i));
                    EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.valueAt(model.getFiveWhysAnswers(), i));
                }
            }
            table.setSpacingAfter(4.0f);
            doc.add((Element)table);
            Paragraph actionsTitle = new Paragraph("Proposed Actions", FONT_LABEL);
            actionsTitle.setSpacingAfter(2.0f);
            doc.add((Element)actionsTitle);
            PdfPTable actions = new PdfPTable(1);
            actions.setWidthPercentage(100.0f);
            PdfPCell actionsCell = new PdfPCell(new Phrase(EightDPdfGenerator.nz(model.getFiveWhysProposedActions(), "-"), FONT_TEXT));
            actionsCell.setPadding(6.0f);
            actions.addCell(actionsCell);
            actions.setSpacingAfter(6.0f);
            doc.add((Element)actions);
        }
    }

    private static void addD5(Document doc, EightD model) throws DocumentException {
        EightDPdfGenerator.addStageTitle(doc, "D5 - Corrective Actions");
        PdfPTable table = new PdfPTable(new float[]{44.0f, 20.0f, 18.0f, 18.0f});
        table.setWidthPercentage(100.0f);
        EightDPdfGenerator.addHeaderCell(table, "Corrective Action");
        EightDPdfGenerator.addHeaderCell(table, "Responsible");
        EightDPdfGenerator.addHeaderCell(table, "Target Date");
        EightDPdfGenerator.addHeaderCell(table, "Implementation Date");
        ObservableList<EightDCorrectiveAction> rows = model.getCorrectiveActions();
        if (rows == null || rows.isEmpty()) {
            EightDPdfGenerator.addEmptyRow(table, 4, "No corrective actions added.");
        } else {
            for (EightDCorrectiveAction row : rows) {
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getAction(), "-"));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getResponsiblePerson(), "-"));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.formatDate(row.getTargetDate()));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.formatDate(row.getImplementationDate()));
            }
        }
        table.setSpacingAfter(6.0f);
        doc.add((Element)table);
    }

    private static void addD6(Document doc, EightD model) throws DocumentException {
        EightDPdfGenerator.addStageTitle(doc, "D6 - Effectiveness Verification");
        PdfPTable table = new PdfPTable(new float[]{30.0f, 55.0f, 15.0f});
        table.setWidthPercentage(100.0f);
        EightDPdfGenerator.addHeaderCell(table, "Method");
        EightDPdfGenerator.addHeaderCell(table, "Result");
        EightDPdfGenerator.addHeaderCell(table, "Date");
        ObservableList<EightDEffectivenessVerification> rows = model.getEffectivenessVerifications();
        if (rows == null || rows.isEmpty()) {
            EightDPdfGenerator.addEmptyRow(table, 3, "No effectiveness verifications added.");
        } else {
            for (EightDEffectivenessVerification row : rows) {
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getMethod(), "-"));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getResult(), "-"));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.formatDate(row.getDate()));
            }
        }
        table.setSpacingAfter(6.0f);
        doc.add((Element)table);
    }

    private static void addD7(Document doc, EightD model) throws DocumentException {
        EightDPdfGenerator.addStageTitle(doc, "D7 - Preventive Actions");
        PdfPTable table = new PdfPTable(new float[]{16.0f, 14.0f, 14.0f, 10.0f, 10.0f, 14.0f, 14.0f, 8.0f});
        table.setWidthPercentage(100.0f);
        EightDPdfGenerator.addHeaderCell(table, "Product");
        EightDPdfGenerator.addHeaderCell(table, "Lines");
        EightDPdfGenerator.addHeaderCell(table, "Responsible");
        EightDPdfGenerator.addHeaderCell(table, "Target");
        EightDPdfGenerator.addHeaderCell(table, "Implementation");
        EightDPdfGenerator.addHeaderCell(table, "Verification Method");
        EightDPdfGenerator.addHeaderCell(table, "Verification Result");
        EightDPdfGenerator.addHeaderCell(table, "Verification Date");
        ObservableList<EightDPreventiveAction> rows = model.getPreventiveActions();
        if (rows == null || rows.isEmpty()) {
            EightDPdfGenerator.addEmptyRow(table, 8, "No preventive actions added.");
        } else {
            for (EightDPreventiveAction row : rows) {
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getProduct(), "-"));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getLines(), "-"));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getResponsiblePerson(), "-"));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.formatDate(row.getTargetDate()));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.formatDate(row.getImplementationDate()));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getVerificationMethod(), "-"));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(row.getVerificationResult(), "-"));
                EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.formatDate(row.getVerificationDate()));
            }
        }
        table.setSpacingAfter(4.0f);
        doc.add((Element)table);
        List<String> checklist = EightDPdfGenerator.collectD7Checklist(model);
        Paragraph checklistTitle = new Paragraph("Documents / updates checked", FONT_LABEL);
        checklistTitle.setSpacingAfter(2.0f);
        doc.add((Element)checklistTitle);
        if (checklist.isEmpty()) {
            doc.add((Element)new Paragraph("- None selected", FONT_TEXT));
        } else {
            for (String item : checklist) {
                doc.add((Element)new Paragraph("- " + item, FONT_TEXT));
            }
        }
        Paragraph spacer = new Paragraph(" ", FONT_SMALL);
        spacer.setSpacingAfter(4.0f);
        doc.add((Element)spacer);
    }

    private static void addD8(Document doc, EightD model) throws DocumentException {
        EightDPdfGenerator.addStageTitle(doc, "D8 - Review and Approvals");
        PdfPTable table = new PdfPTable(new float[]{22.0f, 28.0f, 15.0f, 35.0f});
        table.setWidthPercentage(100.0f);
        EightDPdfGenerator.addHeaderCell(table, "Role");
        EightDPdfGenerator.addHeaderCell(table, "Name");
        EightDPdfGenerator.addHeaderCell(table, "Date");
        EightDPdfGenerator.addHeaderCell(table, "Signature");
        EightDPdfGenerator.addApprovalRow(table, "Submitted by", model.getD8SubmittedBy(), model.getD8SubmissionDate());
        EightDPdfGenerator.addApprovalRow(table, "Internal Quality Representative", model.getD8InternalQualityRepresentative(), model.getD8InternalQualityApprovalDate());
        EightDPdfGenerator.addApprovalRow(table, "Internal Representative 1", model.getD8InternalRepresentative1(), model.getD8InternalRepresentative1ApprovalDate());
        EightDPdfGenerator.addApprovalRow(table, "Internal Representative 2", model.getD8InternalRepresentative2(), model.getD8InternalRepresentative2ApprovalDate());
        table.setSpacingAfter(6.0f);
        doc.add((Element)table);
    }

    private static void addCustomerSignatureBlock(Document doc) throws DocumentException {
        Paragraph title = new Paragraph("Customer Signature", FONT_STAGE);
        title.setSpacingBefore(10.0f);
        title.setSpacingAfter(6.0f);
        doc.add((Element)title);
        PdfPTable table = new PdfPTable(new float[]{25.0f, 40.0f, 15.0f, 20.0f});
        table.setWidthPercentage(100.0f);
        EightDPdfGenerator.addHeaderCell(table, "Customer Name");
        EightDPdfGenerator.addHeaderCell(table, "Signature");
        EightDPdfGenerator.addHeaderCell(table, "Date");
        EightDPdfGenerator.addHeaderCell(table, "Comment");
        EightDPdfGenerator.addValueCell(table, " ");
        EightDPdfGenerator.addValueCell(table, "\n\n");
        EightDPdfGenerator.addValueCell(table, " ");
        EightDPdfGenerator.addValueCell(table, " ");
        doc.add((Element)table);
    }

    private static void addD2PhotoGallery(Document doc, EightD model) throws DocumentException {
        ObservableList<EightDImage> images = model.getImages();
        if (images == null || images.isEmpty()) {
            return;
        }
        Paragraph title = new Paragraph("Photo Gallery", FONT_LABEL);
        title.setSpacingAfter(3.0f);
        doc.add((Element)title);
        PdfPTable gallery = new PdfPTable(3);
        gallery.setWidthPercentage(100.0f);
        gallery.setSpacingAfter(6.0f);
        for (EightDImage imageRow : images) {
            PdfPCell cell = new PdfPCell();
            cell.setPadding(4.0f);
            cell.setMinimumHeight(150.0f);
            cell.setVerticalAlignment(5);
            cell.setHorizontalAlignment(1);
            try {
                File file = EightDImageStorage.resolveStoredFile(imageRow == null ? null : imageRow.getPath());
                if (file != null && file.exists() && file.isFile()) {
                    Image image = Image.getInstance((String)file.getAbsolutePath());
                    image.scaleToFit(300.0f, 170.0f);
                    image.setAlignment(1);
                    cell.addElement((Element)image);
                } else {
                    cell.addElement((Element)new Paragraph("Image not found", FONT_SMALL));
                }
            }
            catch (Exception ex) {
                cell.addElement((Element)new Paragraph("Invalid image", FONT_SMALL));
            }
            gallery.addCell(cell);
        }
        int remainder = images.size() % 3;
        if (remainder != 0) {
            for (int i = remainder; i < 3; ++i) {
                gallery.addCell(new PdfPCell(new Phrase(" ")));
            }
        }
        doc.add((Element)gallery);
    }

    private static void addDiffRow(PdfPTable table, String rowName, String contrast, String change) {
        EightDPdfGenerator.addValueCell(table, rowName);
        EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(contrast, "-"));
        EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(change, "-"));
    }

    private static void addApprovalRow(PdfPTable table, String role, String name, LocalDate date) {
        EightDPdfGenerator.addValueCell(table, role);
        EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.nz(name, "-"));
        EightDPdfGenerator.addValueCell(table, EightDPdfGenerator.formatDate(date));
        EightDPdfGenerator.addValueCell(table, " ");
    }

    private static List<String> collectD7Checklist(EightD model) {
        ArrayList<String> items = new ArrayList<String>();
        EightDPdfGenerator.appendChecklist(items, model.isD7DesignFmeaChecked(), "Design FMEA", model.getD7DesignFmeaDate());
        EightDPdfGenerator.appendChecklist(items, model.isD7ProcessFmeaChecked(), "Process FMEA", model.getD7ProcessFmeaDate());
        EightDPdfGenerator.appendChecklist(items, model.isD7ControlPlansChecked(), "Control Plans", model.getD7ControlPlansDate());
        EightDPdfGenerator.appendChecklist(items, model.isD7GageDrawingChecked(), "Gage Drawing", model.getD7GageDrawingDate());
        EightDPdfGenerator.appendChecklist(items, model.isD7ProcessFlowChecked(), "Process Flow", model.getD7ProcessFlowDate());
        EightDPdfGenerator.appendChecklist(items, model.isD7WorkInstructionsChecked(), "Work Instructions", model.getD7WorkInstructionsDate());
        EightDPdfGenerator.appendChecklist(items, model.isD7DrawingChecked(), "Drawing", model.getD7DrawingDate());
        EightDPdfGenerator.appendChecklist(items, model.isD7DesignStandardsChecked(), "Design Standards", model.getD7DesignStandardsDate());
        EightDPdfGenerator.appendChecklist(items, model.isD7PackingSpecsChecked(), "Packing Specs", model.getD7PackingSpecsDate());
        EightDPdfGenerator.appendChecklist(items, model.isD7InternalAuditChecked(), "Internal Audit", model.getD7InternalAuditDate());
        EightDPdfGenerator.appendChecklist(items, model.isD7ToolingDrawingChecked(), "Tooling Drawing", model.getD7ToolingDrawingDate());
        EightDPdfGenerator.appendChecklist(items, model.isD7OperatorTrainingChecked(), "Operator Training", model.getD7OperatorTrainingDate());
        return items;
    }

    private static void appendChecklist(List<String> out, boolean checked, String label, LocalDate date) {
        if (!checked) {
            return;
        }
        out.add(label + " (" + EightDPdfGenerator.formatDate(date) + ")");
    }

    private static void addStageTitle(Document doc, String title) throws DocumentException {
        Paragraph heading = new Paragraph(title, FONT_STAGE);
        heading.setSpacingBefore(8.0f);
        heading.setSpacingAfter(4.0f);
        doc.add((Element)heading);
    }

    private static void addHeaderCell(PdfPTable table, String text) {
        PdfPCell cell = new PdfPCell(new Phrase(EightDPdfGenerator.nz(text, ""), FONT_LABEL));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setPadding(4.0f);
        cell.setBackgroundColor(new Color(236, 239, 241));
        table.addCell(cell);
    }

    private static void addValueCell(PdfPTable table, String text) {
        PdfPCell cell = new PdfPCell(new Phrase(EightDPdfGenerator.nz(text, "-"), FONT_TEXT));
        cell.setPadding(4.0f);
        cell.setVerticalAlignment(4);
        table.addCell(cell);
    }

    private static void addEmptyRow(PdfPTable table, int colspan, String text) {
        PdfPCell cell = new PdfPCell(new Phrase(text, FONT_TEXT));
        cell.setColspan(colspan);
        cell.setHorizontalAlignment(0);
        cell.setPadding(6.0f);
        table.addCell(cell);
    }

    private static void addKeyValue(PdfPTable table, String key, String value) {
        PdfPCell keyCell = new PdfPCell(new Phrase(EightDPdfGenerator.nz(key, ""), FONT_LABEL));
        keyCell.setPadding(4.0f);
        keyCell.setHorizontalAlignment(2);
        keyCell.setVerticalAlignment(5);
        table.addCell(keyCell);
        PdfPCell valueCell = new PdfPCell(new Phrase(EightDPdfGenerator.nz(value, "-"), FONT_TEXT));
        valueCell.setPadding(4.0f);
        valueCell.setVerticalAlignment(5);
        table.addCell(valueCell);
    }

    private static String valueAt(List<String> values, int index) {
        if (values == null || index < 0 || index >= values.size()) {
            return "-";
        }
        return EightDPdfGenerator.nz(values.get(index), "-");
    }

    @SafeVarargs
    private static int maxSize(List<String> ... lists) {
        int max = 0;
        if (lists == null) {
            return 0;
        }
        for (List<String> list : lists) {
            if (list == null || list.size() <= max) continue;
            max = list.size();
        }
        return max;
    }

    private static List<String> preferredCauses(List<String> primary, List<String> fallback) {
        if (EightDPdfGenerator.hasContent(primary)) {
            return primary;
        }
        if (EightDPdfGenerator.hasContent(fallback)) {
            return fallback;
        }
        return List.of();
    }

    private static boolean hasContent(List<String> values) {
        if (values == null || values.isEmpty()) {
            return false;
        }
        for (String value : values) {
            if (value == null || value.isBlank()) continue;
            return true;
        }
        return false;
    }

    private static String formatDate(LocalDate date) {
        return date == null ? "-" : DATE_FMT.format(date);
    }

    private static float estimateRowsHeight(int rowCount, float base) {
        return base + (float)Math.max(0, rowCount) * 16.0f;
    }

    private static void ensureSectionSpace(Document doc, PdfWriter writer, float requiredHeight) {
        float currentY = writer.getVerticalPosition(true);
        if (currentY < doc.bottomMargin() + requiredHeight) {
            doc.newPage();
        }
    }

    private static String nz(String value, String fallback) {
        if (value == null) {
            return fallback;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? fallback : trimmed;
    }

    private static String firstNonBlank(String ... values) {
        if (values == null) {
            return "";
        }
        for (String value : values) {
            if (value == null || value.isBlank()) continue;
            return value.trim();
        }
        return "";
    }
}

