/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.eightd;

import com.qualidadeeprodutividade.eightd.EightD;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IshikawaDiagramRenderer {
    private static final String[] BRANCH_NAMES = new String[]{"Method", "Machine", "Measurements", "Environment", "Material", "Manpower"};

    private IshikawaDiagramRenderer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage render(EightD report, int width, int height) {
        int w = Math.max(900, width);
        int h = Math.max(420, height);
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics2D g2 = image.createGraphics();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, w, h);
            String failure = IshikawaDiagramRenderer.firstNonBlank(report == null ? null : report.getIshikawaFailureDescription(), report == null ? null : report.getNonConformanceNotification(), "Failure Description");
            List<List<String>> causesByBranch = List.of(IshikawaDiagramRenderer.clean(report == null ? null : report.getIshikawaCausesMethod()), IshikawaDiagramRenderer.clean(report == null ? null : report.getIshikawaCausesMachine()), IshikawaDiagramRenderer.clean(report == null ? null : report.getIshikawaCausesMeasurements()), IshikawaDiagramRenderer.clean(report == null ? null : report.getIshikawaCausesEnvironment()), IshikawaDiagramRenderer.clean(report == null ? null : report.getIshikawaCausesMaterial()), IshikawaDiagramRenderer.clean(report == null ? null : report.getIshikawaCausesManpower()));
            int left = Math.max(70, w / 18);
            int right = Math.max(90, w / 18);
            int top = Math.max(50, h / 18);
            int bottom = Math.max(50, h / 18);
            int spineY = h / 2;
            int failureWidth = IshikawaDiagramRenderer.clamp(w / 7, 170, 300);
            int failureX = w - right - failureWidth;
            int spineEndX = failureX - 34;
            int spineStartX = left + 20;
            g2.setColor(new Color(31, 41, 55));
            g2.setStroke(new BasicStroke(4.0f, 1, 1));
            g2.drawLine(spineStartX, spineY, spineEndX, spineY);
            int arrowSize = Math.max(18, w / 75);
            int[] arrowX = new int[]{spineEndX, spineEndX + arrowSize, spineEndX};
            int[] arrowY = new int[]{spineY - arrowSize / 2, spineY, spineY + arrowSize / 2};
            g2.fillPolygon(arrowX, arrowY, 3);
            g2.setFont(new Font("SansSerif", 1, 22));
            g2.setColor(Color.BLACK);
            IshikawaDiagramRenderer.drawWrappedText(g2, failure, failureX + 4, spineY, Math.max(120, failureWidth - 8), 4, HorizontalAlign.LEFT);
            int branchArea = Math.max(320, spineEndX - spineStartX);
            int pairCount = 3;
            int[] pairAnchors = new int[pairCount];
            int firstAnchor = spineStartX + IshikawaDiagramRenderer.clamp((int)Math.round((double)branchArea * 0.3), 180, 360);
            int lastAnchor = spineEndX - IshikawaDiagramRenderer.clamp((int)Math.round((double)branchArea * 0.09), 40, 120);
            double gap = pairCount > 1 ? (double)(lastAnchor - firstAnchor) / (double)(pairCount - 1) : 0.0;
            for (int i = 0; i < pairCount; ++i) {
                pairAnchors[i] = (int)Math.round((double)firstAnchor + gap * (double)i);
            }
            double angle = Math.toRadians(62.0);
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            int baseLength = IshikawaDiagramRenderer.clamp((int)Math.round((double)h * 0.24), 120, 260);
            for (int branchIndex = 0; branchIndex < BRANCH_NAMES.length; ++branchIndex) {
                int branchLabelY;
                boolean topBranch = branchIndex % 2 == 0;
                int direction = topBranch ? -1 : 1;
                int pairIndex = branchIndex / 2;
                int anchorX = pairAnchors[pairIndex];
                List<String> causes = causesByBranch.get(branchIndex);
                int rawLength = baseLength + Math.min(60, causes.size() * 10);
                if (causes.isEmpty()) {
                    rawLength -= 24;
                }
                int maxByLeft = (int)Math.floor((double)(anchorX - (left + 12)) / cos);
                int maxByVertical = topBranch ? (int)Math.floor((double)(spineY - (top + 28)) / sin) : (int)Math.floor((double)(h - bottom - 28 - spineY) / sin);
                int branchLength = IshikawaDiagramRenderer.clamp(Math.min(rawLength, Math.min(maxByLeft, maxByVertical)), 92, 320);
                int endX = (int)Math.round((double)anchorX - cos * (double)branchLength);
                int endY = (int)Math.round((double)spineY + (double)direction * sin * (double)branchLength);
                g2.setStroke(new BasicStroke(3.0f, 1, 1));
                g2.setColor(Color.BLACK);
                g2.drawLine(anchorX, spineY, endX, endY);
                g2.setFont(new Font("SansSerif", 1, 24));
                int labelWidth = 190;
                boolean overflowLeft = endX - labelWidth - 8 < left;
                int n = branchLabelY = topBranch ? endY - 14 : endY + 20;
                if (overflowLeft) {
                    IshikawaDiagramRenderer.drawWrappedText(g2, BRANCH_NAMES[branchIndex], endX + 8, branchLabelY, labelWidth, 2, HorizontalAlign.LEFT);
                } else {
                    IshikawaDiagramRenderer.drawWrappedText(g2, BRANCH_NAMES[branchIndex], endX - 8, branchLabelY, labelWidth, 2, HorizontalAlign.RIGHT);
                }
                if (causes.isEmpty()) continue;
                g2.setFont(new Font("SansSerif", 0, 20));
                for (int causeIndex = 0; causeIndex < causes.size(); ++causeIndex) {
                    double t = ((double)causeIndex + 1.0) / ((double)causes.size() + 1.0);
                    int originX = (int)Math.round((double)anchorX + (double)(endX - anchorX) * t);
                    int originY = (int)Math.round((double)spineY + (double)(endY - spineY) * t);
                    int horizontalLength = IshikawaDiagramRenderer.clamp(56 + causes.get(causeIndex).length() * 2, 56, 140);
                    int targetX = originX - horizontalLength;
                    int targetY = originY;
                    g2.setStroke(new BasicStroke(2.0f, 1, 1));
                    g2.drawLine(originX, originY, targetX, targetY);
                    int maxTextWidth = IshikawaDiagramRenderer.clamp(targetX - left - 14, 140, 440);
                    IshikawaDiagramRenderer.drawWrappedText(g2, causes.get(causeIndex), targetX - 8, targetY, maxTextWidth, 6, HorizontalAlign.RIGHT);
                }
            }
        }
        finally {
            g2.dispose();
        }
        return image;
    }

    private static List<String> clean(List<String> source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String value : source) {
            String trimmed;
            if (value == null || (trimmed = value.trim()).isEmpty()) continue;
            result.add(trimmed);
        }
        return result;
    }

    private static int drawWrappedText(Graphics2D g2, String text, int anchorX, int centerY, int maxWidth, int maxLines, HorizontalAlign align) {
        String normalized;
        String string = normalized = text == null ? "" : text.trim();
        if (normalized.isEmpty()) {
            return 0;
        }
        int width = Math.max(30, maxWidth);
        int lineLimit = Math.max(1, maxLines);
        FontMetrics fm = g2.getFontMetrics();
        List<String> lines = IshikawaDiagramRenderer.wrapLines(normalized, fm, width);
        if (lines.isEmpty()) {
            return 0;
        }
        if (lines.size() > lineLimit) {
            lines = new ArrayList<String>(lines.subList(0, lineLimit));
            int idx = lines.size() - 1;
            String last = lines.get(idx);
            String ellipsis = "...";
            while (!last.isEmpty() && fm.stringWidth(last + ellipsis) > width) {
                last = last.substring(0, last.length() - 1).trim();
            }
            lines.set(idx, (String)(last.isEmpty() ? ellipsis : last + ellipsis));
        }
        int lineHeight = fm.getHeight();
        int totalHeight = lineHeight * lines.size();
        int y = centerY - totalHeight / 2 + fm.getAscent();
        for (String line : lines) {
            int drawX = align == HorizontalAlign.RIGHT ? anchorX - fm.stringWidth(line) : anchorX;
            g2.drawString(line, drawX, y);
            y += lineHeight;
        }
        return totalHeight;
    }

    private static List<String> wrapLines(String text, FontMetrics fm, int maxWidth) {
        if (text == null || text.isBlank()) {
            return Collections.emptyList();
        }
        String[] words = text.trim().split("\\s+");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if (line.length() == 0) {
                line.append(word);
                continue;
            }
            String candidate = String.valueOf(line) + " " + word;
            if (fm.stringWidth(candidate) <= maxWidth) {
                line.setLength(0);
                line.append(candidate);
                continue;
            }
            lines.add(line.toString());
            line.setLength(0);
            line.append(word);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines;
    }

    private static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private static String firstNonBlank(String ... values) {
        if (values == null) {
            return "";
        }
        for (String value : values) {
            if (value == null || value.isBlank()) continue;
            return value.trim();
        }
        return "";
    }

    private static enum HorizontalAlign {
        LEFT,
        RIGHT;

    }
}

