/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.excelimport;

import com.qualidadeeprodutividade.excelimport.ColumnBinding;
import com.qualidadeeprodutividade.excelimport.ColumnMapping;
import com.qualidadeeprodutividade.excelimport.ImportField;
import com.qualidadeeprodutividade.excelimport.ImportSchema;
import java.util.List;
import java.util.Locale;

public final class ColumnMappingParser {
    private ColumnMappingParser() {
    }

    public static ColumnMapping autoMap(List<String> headers, ImportSchema<?> schema) {
        ColumnMapping mapping = new ColumnMapping();
        if (headers == null || schema == null) {
            return mapping;
        }
        for (ImportField<?> f : schema.getFields()) {
            int idx = ColumnMappingParser.findIndex(headers, f);
            if (idx < 0) continue;
            mapping.put(f.name(), new ColumnBinding(headers.get(idx), idx));
        }
        return mapping;
    }

    private static int findIndex(List<String> headers, ImportField<?> field) {
        for (int i = 0; i < headers.size(); ++i) {
            String h = ColumnMappingParser.normalize(headers.get(i));
            if (h.isEmpty()) continue;
            if (ColumnMappingParser.normalize(field.name()).equals(h)) {
                return i;
            }
            for (String alias : field.aliases()) {
                if (!ColumnMappingParser.normalize(alias).equals(h)) continue;
                return i;
            }
        }
        return -1;
    }

    private static String normalize(String v) {
        if (v == null) {
            return "";
        }
        return v.trim().toLowerCase(Locale.ROOT).replace(" ", "").replace("_", "");
    }
}

