/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.excelimport;

import com.qualidadeeprodutividade.excelimport.RowData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public final class ExcelSheetReader {
    private ExcelSheetReader() {
    }

    public static List<RowData> readRows(Sheet sheet) {
        ArrayList<RowData> rows = new ArrayList<RowData>();
        int maxColumns = 0;
        for (Row row : sheet) {
            maxColumns = Math.max(maxColumns, row.getLastCellNum());
        }
        for (Row row : sheet) {
            HashMap<Integer, String> values = new HashMap<Integer, String>();
            for (int c = 0; c < maxColumns; ++c) {
                Cell cell = row.getCell(c);
                values.put(c, ExcelSheetReader.readCell(cell));
            }
            rows.add(new RowData(values));
        }
        return rows;
    }

    private static String readCell(Cell cell) {
        if (cell == null) {
            return "";
        }
        CellType type = cell.getCellType();
        switch (type) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getLocalDateTimeCellValue().toLocalDate().toString();
                }
                double d = cell.getNumericCellValue();
                if (d == (double)((long)d)) {
                    return Long.toString((long)d);
                }
                return Double.toString(d);
            }
            case BOOLEAN: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            case FORMULA: {
                try {
                    return cell.getStringCellValue();
                }
                catch (Exception ex) {
                    try {
                        return Double.toString(cell.getNumericCellValue());
                    }
                    catch (Exception ignore) {
                        return "";
                    }
                }
            }
        }
        return "";
    }
}

