/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.excelimport;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public final class ExcelWorkbookReader {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void read(Path file, SheetHandler handler) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);
             Workbook workbook = WorkbookFactory.create((InputStream)in);){
            for (Sheet sheet : workbook) {
                try {
                    handler.handle(sheet);
                }
                catch (Exception e) {
                    throw new IOException("Failed to handle sheet: " + sheet.getSheetName(), e);
                    return;
                }
            }
        }
    }

    public static List<String> listSheetNames(Path file) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);
             Workbook workbook = WorkbookFactory.create((InputStream)in);){
            for (Sheet sheet : workbook) {
                names.add(sheet.getSheetName());
            }
        }
        catch (Exception ex) {
            throw new IOException("Failed to read workbook: " + ex.getMessage(), ex);
        }
        return names;
    }

    public static interface SheetHandler {
        public void handle(Sheet var1) throws IOException;
    }
}

