/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.excelimport;

import com.qualidadeeprodutividade.excelimport.ImportError;
import com.qualidadeeprodutividade.excelimport.ImportType;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ImportReport {
    private final ImportType type;
    private final String sheetName;
    private final List<ImportError> errors = new ArrayList<ImportError>();
    private int read;
    private int created;
    private int updated;
    private static final DateTimeFormatter TS_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public ImportReport(ImportType type, String sheetName) {
        this.type = type;
        this.sheetName = sheetName;
    }

    public void incrementRead() {
        ++this.read;
    }

    public void incrementCreated() {
        ++this.created;
    }

    public void incrementUpdated() {
        ++this.updated;
    }

    public void addError(ImportError error) {
        this.errors.add(error);
    }

    public ImportType getType() {
        return this.type;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public int getRead() {
        return this.read;
    }

    public int getCreated() {
        return this.created;
    }

    public int getUpdated() {
        return this.updated;
    }

    public List<ImportError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public String toSummaryString() {
        return "%s (sheet %s): read=%d, created=%d, updated=%d, errors=%d".formatted(new Object[]{this.type, this.sheetName, this.read, this.created, this.updated, this.errors.size()});
    }

    public String toText() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sheet ").append(this.sheetName).append(" (").append((Object)this.type).append(")").append("\n");
        sb.append(" - Rows read: ").append(this.read).append("\n");
        sb.append(" - Created: ").append(this.created).append("\n");
        sb.append(" - Updated: ").append(this.updated).append("\n");
        if (this.errors.isEmpty()) {
            sb.append(" - Errors: none").append("\n");
        } else {
            sb.append(" - Errors: ").append(this.errors.size()).append("\n");
            for (ImportError e : this.errors) {
                sb.append("    * Row ").append(e.rowIndex());
                String field = this.escape(e.field());
                if (field != null && !field.isBlank()) {
                    sb.append(", field \"").append(field).append("\"");
                }
                sb.append(": ").append(this.escape(e.message())).append("\n");
            }
        }
        return sb.toString();
    }

    public String toFriendlyLine() {
        return "%s (sheet %s) - read: %d | created: %d | updated: %d | errors: %d".formatted(new Object[]{this.type, this.sheetName, this.read, this.created, this.updated, this.errors.size()});
    }

    public String toCsv() {
        StringBuilder sb = new StringBuilder();
        sb.append("type,sheet,read,created,updated,error_count,timestamp\n");
        sb.append((Object)this.type).append(",").append(this.sheetName).append(",").append(this.read).append(",").append(this.created).append(",").append(this.updated).append(",").append(this.errors.size()).append(",").append(TS_FMT.format(LocalDateTime.now())).append("\n");
        sb.append("\nerrors\nrow,field,message\n");
        for (ImportError e : this.errors) {
            sb.append(e.rowIndex()).append(",").append(this.escape(e.field())).append(",").append(this.escape(e.message())).append("\n");
        }
        return sb.toString();
    }

    public String toJson() {
        String errs = this.errors.stream().map(e -> "{\"row\":" + e.rowIndex() + ",\"field\":\"" + this.escape(e.field()) + "\",\"message\":\"" + this.escape(e.message()) + "\"}").collect(Collectors.joining(","));
        return "{\"type\":\"" + String.valueOf((Object)this.type) + "\",\"sheet\":\"" + this.escape(this.sheetName) + "\",\"read\":" + this.read + ",\"created\":" + this.created + ",\"updated\":" + this.updated + ",\"errors\":[" + errs + "]}";
    }

    private String escape(String value) {
        if (value == null) {
            return "";
        }
        return value.replace("\"", "\\\"");
    }
}

