/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.excelimport;

import com.qualidadeeprodutividade.excelimport.ColumnMapping;
import com.qualidadeeprodutividade.excelimport.ColumnMappingParser;
import com.qualidadeeprodutividade.excelimport.ExcelSheetReader;
import com.qualidadeeprodutividade.excelimport.ExcelWorkbookReader;
import com.qualidadeeprodutividade.excelimport.ImportError;
import com.qualidadeeprodutividade.excelimport.ImportExtras;
import com.qualidadeeprodutividade.excelimport.ImportReport;
import com.qualidadeeprodutividade.excelimport.ImportSchema;
import com.qualidadeeprodutividade.excelimport.ImportType;
import com.qualidadeeprodutividade.excelimport.RowData;
import com.qualidadeeprodutividade.excelimport.RowMapper;
import com.qualidadeeprodutividade.excelimport.RowMappingResult;
import com.qualidadeeprodutividade.excelimport.TemplateGenerator;
import com.qualidadeeprodutividade.excelimport.schemas.ControlPlanSchema;
import com.qualidadeeprodutividade.excelimport.schemas.DfmeaSchema;
import com.qualidadeeprodutividade.excelimport.schemas.PfmeaSchema;
import com.qualidadeeprodutividade.excelimport.schemas.ProcessTreeSchema;
import com.qualidadeeprodutividade.excelimport.schemas.ProductTreeSchema;
import com.qualidadeeprodutividade.project.Project;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.poi.ss.usermodel.Sheet;

public final class ImportService {
    private static final Logger LOG = Logger.getLogger(ImportService.class.getName());
    private final Map<ImportType, ImportSchema<?>> schemas = new HashMap();

    public ImportService() {
        this.register(new ProductTreeSchema());
        this.register(new ProcessTreeSchema());
        this.register(new DfmeaSchema());
        this.register(new PfmeaSchema());
        this.register(new ControlPlanSchema());
    }

    private void register(ImportSchema<?> schema) {
        this.schemas.put(schema.getType(), schema);
    }

    public List<ImportReport> importWorkbook(Path file, Project project) throws IOException {
        ArrayList<ImportReport> reports = new ArrayList<ImportReport>();
        ExcelWorkbookReader.read(file, sheet -> {
            ImportType type = ImportType.fromSheetName(sheet.getSheetName());
            if (type == null) {
                return;
            }
            ImportSchema<?> schema = this.schemas.get((Object)type);
            if (schema == null) {
                return;
            }
            try {
                ImportReport report = this.importSheet(sheet, project, schema);
                reports.add(report);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Failed to import sheet " + sheet.getSheetName() + ": " + ex.getMessage(), ex);
                ImportReport failed = new ImportReport(type, sheet.getSheetName());
                failed.addError(new ImportError(0, "", "Sheet import failed: " + ex.getMessage()));
                reports.add(failed);
            }
        });
        return reports;
    }

    private <T> ImportReport importSheet(Sheet sheet, Project project, ImportSchema<T> schema) {
        ImportReport report = new ImportReport(schema.getType(), sheet.getSheetName());
        List<RowData> rows = ExcelSheetReader.readRows(sheet);
        if (rows.isEmpty()) {
            return report;
        }
        RowData headerRow = rows.get(0);
        List<String> headers = RowMapper.headerStrings(headerRow, headerRow.values().size());
        ColumnMapping mapping = ColumnMappingParser.autoMap(headers, schema);
        RowMapper<T> mapper = new RowMapper<T>(schema);
        for (int i = 1; i < rows.size(); ++i) {
            Optional<T> found;
            RowData data = rows.get(i);
            if (this.isBlankRow(data)) continue;
            report.incrementRead();
            ImportExtras extras = schema.newExtras();
            Object existing = null;
            RowMappingResult<T> draft = mapper.map(data, mapping, i + 1, report);
            if (draft.hasErrors()) continue;
            String key = schema.naturalKey(draft.entity(), draft.extras());
            if (key != null && !key.isBlank() && (found = schema.findExisting(project, key)).isPresent()) {
                existing = found.get();
            }
            if (existing != null) {
                mapper.map(data, mapping, i + 1, report, existing, extras);
                report.incrementUpdated();
                continue;
            }
            mapper.map(data, mapping, i + 1, report, draft.entity(), extras);
            schema.attach(project, draft.entity(), extras);
            report.incrementCreated();
        }
        return report;
    }

    private boolean isBlankRow(RowData row) {
        if (row == null || row.values() == null) {
            return true;
        }
        return row.values().values().stream().allMatch(v -> v == null || v.trim().isEmpty());
    }

    public void writeTemplate(Path target) throws IOException {
        TemplateGenerator.writeTemplate(target, new ArrayList(this.schemas.values()));
    }
}

