/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.excelimport;

public enum ImportType {
    PRODUCT_TREE("ProductTree"),
    PROCESS_TREE("ProcessTree"),
    DFMEA("DFMEA"),
    PFMEA("PFMEA"),
    CONTROL_PLAN("ControlPlan");

    private final String sheetName;

    private ImportType(String sheetName) {
        this.sheetName = sheetName;
    }

    public String sheetName() {
        return this.sheetName;
    }

    public static ImportType fromSheetName(String name) {
        if (name == null) {
            return null;
        }
        String normalized = name.trim().replace(" ", "").toLowerCase();
        for (ImportType t : ImportType.values()) {
            if (!t.sheetName.toLowerCase().equals(normalized)) continue;
            return t;
        }
        return null;
    }
}

