/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.excelimport;

import com.qualidadeeprodutividade.excelimport.ColumnBinding;
import com.qualidadeeprodutividade.excelimport.ColumnMapping;
import com.qualidadeeprodutividade.excelimport.ImportError;
import com.qualidadeeprodutividade.excelimport.ImportExtras;
import com.qualidadeeprodutividade.excelimport.ImportField;
import com.qualidadeeprodutividade.excelimport.ImportReport;
import com.qualidadeeprodutividade.excelimport.ImportSchema;
import com.qualidadeeprodutividade.excelimport.RowData;
import com.qualidadeeprodutividade.excelimport.RowMappingResult;
import java.util.ArrayList;
import java.util.List;

public final class RowMapper<T> {
    private final ImportSchema<T> schema;

    public RowMapper(ImportSchema<T> schema) {
        this.schema = schema;
    }

    public RowMappingResult<T> map(RowData row, ColumnMapping mapping, int rowIndex, ImportReport report) {
        return this.map(row, mapping, rowIndex, report, this.schema.newInstance(), this.schema.newExtras());
    }

    public RowMappingResult<T> map(RowData row, ColumnMapping mapping, int rowIndex, ImportReport report, T instance, ImportExtras extras) {
        if (instance == null) {
            instance = this.schema.newInstance();
        }
        if (extras == null) {
            extras = this.schema.newExtras();
        }
        boolean hasErrors = false;
        for (ImportField<T> field : this.schema.getFields()) {
            String raw;
            ColumnBinding binding = mapping.get(field.name());
            String string = raw = binding == null ? null : row.get(binding.index());
            if ((raw == null || raw.isBlank()) && field.defaultValue() != null) {
                raw = field.defaultValue().toString();
            }
            Object converted = null;
            try {
                String s;
                if (raw != null && !raw.isBlank()) {
                    converted = field.converter().apply(raw);
                }
                if ((converted == null || converted instanceof String && (s = (String)converted).isBlank()) && field.required()) {
                    report.addError(new ImportError(rowIndex, field.name(), "Required field is empty"));
                    hasErrors = true;
                    continue;
                }
                if (field.validator() != null && converted != null && !field.validator().test(converted)) {
                    report.addError(new ImportError(rowIndex, field.name(), "Validation failed"));
                    hasErrors = true;
                    continue;
                }
                if (field.setter() != null && converted != null) {
                    field.setter().accept(instance, converted);
                }
                if (!field.aliases().contains("_extra_parent") || converted == null) continue;
                extras.put("parent", converted.toString());
            }
            catch (Exception ex) {
                report.addError(new ImportError(rowIndex, field.name(), ex.getMessage()));
                hasErrors = true;
            }
        }
        return new RowMappingResult<T>(instance, extras, hasErrors);
    }

    public static List<String> headerStrings(RowData row, int columnCount) {
        ArrayList<String> headers = new ArrayList<String>();
        for (int i = 0; i < columnCount; ++i) {
            headers.add(row.get(i));
        }
        return headers;
    }
}

