/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.excelimport;

import com.qualidadeeprodutividade.excelimport.ImportField;
import com.qualidadeeprodutividade.excelimport.ImportSchema;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class TemplateGenerator {
    private TemplateGenerator() {
    }

    public static void writeTemplate(Path target, List<ImportSchema<?>> schemas) throws IOException {
        if (target == null || schemas == null) {
            return;
        }
        Path parent = target.getParent();
        if (parent != null && Files.notExists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            for (ImportSchema<?> schema : schemas) {
                Sheet sheet = workbook.createSheet(schema.getSuggestedSheetName());
                Row header = sheet.createRow(0);
                int c = 0;
                for (ImportField<?> f : schema.getFields()) {
                    Cell cell = header.createCell(c++);
                    cell.setCellValue(f.name());
                }
                List<String> sample = schema.templateSample();
                if (sample != null && !sample.isEmpty()) {
                    Row sampleRow = sheet.createRow(1);
                    for (int i = 0; i < schema.getFields().size(); ++i) {
                        Cell cell = sampleRow.createCell(i);
                        if (i < sample.size()) {
                            cell.setCellValue(sample.get(i));
                            continue;
                        }
                        cell.setCellValue("");
                    }
                }
                for (int i = 0; i < c; ++i) {
                    sheet.autoSizeColumn(i);
                }
            }
            try (OutputStream out = Files.newOutputStream(target, new OpenOption[0]);){
                workbook.write(out);
            }
        }
    }
}

