/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.excelimport;

import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Optional;

public final class ValueConverters {
    private ValueConverters() {
    }

    public static String asString(String raw) {
        return raw == null ? null : raw.trim();
    }

    public static Integer asInteger(String raw) {
        try {
            return raw == null || raw.isBlank() ? null : Integer.valueOf(Integer.parseInt(raw.trim()));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid integer: " + raw);
        }
    }

    public static Double asDouble(String raw) {
        try {
            return raw == null || raw.isBlank() ? null : Double.valueOf(Double.parseDouble(raw.trim()));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid number: " + raw);
        }
    }

    public static Boolean asBoolean(String raw) {
        if (raw == null || raw.isBlank()) {
            return null;
        }
        String v = raw.trim().toLowerCase(Locale.ROOT);
        return v.equals("true") || v.equals("yes") || v.equals("sim") || v.equals("1");
    }

    public static LocalDate asDate(String raw) {
        if (raw == null || raw.isBlank()) {
            return null;
        }
        for (DateTimeFormatter fmt : new DateTimeFormatter[]{DateTimeFormatter.ISO_LOCAL_DATE, DateTimeFormatter.ofPattern("dd/MM/yyyy"), DateTimeFormatter.ofPattern("MM/dd/yyyy")}) {
            try {
                return LocalDate.parse(raw.trim(), fmt);
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException("Invalid date: " + raw);
    }

    public static <E extends Enum<E>> E asEnum(String raw, Class<E> type) {
        if (raw == null || raw.isBlank() || type == null) {
            return null;
        }
        String norm = raw.trim().toLowerCase(Locale.ROOT).replace(" ", "").replace("_", "");
        for (Enum e : (Enum[])type.getEnumConstants()) {
            Object v;
            Method method2;
            String candidate = e.name().toLowerCase(Locale.ROOT).replace("_", "");
            if (candidate.equals(norm)) {
                return (E)e;
            }
            try {
                method2 = e.getClass().getMethod("getActionPriority", new Class[0]);
                v = method2.invoke((Object)e, new Object[0]);
                if (v != null && norm.equals(v.toString().toLowerCase(Locale.ROOT).replace(" ", ""))) {
                    return (E)e;
                }
            }
            catch (Exception method2) {
                // empty catch block
            }
            try {
                method2 = e.getClass().getMethod("getDfmeaStatus", new Class[0]);
                v = method2.invoke((Object)e, new Object[0]);
                if (v == null || !norm.equals(v.toString().toLowerCase(Locale.ROOT).replace(" ", ""))) continue;
                return (E)e;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Invalid enum value: " + raw);
    }

    public static String normalizeSpaces(String raw) {
        if (raw == null) {
            return null;
        }
        return raw.trim().replaceAll("\\s{2,}", " ");
    }

    public static String defaultIfBlank(String raw, String def) {
        String v = ValueConverters.asString(raw);
        return v == null || v.isBlank() ? def : v;
    }

    public static <T> Optional<T> optional(T value) {
        return Optional.ofNullable(value);
    }
}

