/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.excelimport.schemas;

import com.qualidadeeprodutividade.controlPlan.ControlPlan;
import com.qualidadeeprodutividade.controlPlan.ControlPlanRow;
import com.qualidadeeprodutividade.excelimport.ImportExtras;
import com.qualidadeeprodutividade.excelimport.ImportField;
import com.qualidadeeprodutividade.excelimport.ImportSchema;
import com.qualidadeeprodutividade.excelimport.ImportType;
import com.qualidadeeprodutividade.excelimport.ValueConverters;
import com.qualidadeeprodutividade.project.Project;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class ControlPlanSchema
implements ImportSchema<ControlPlanRow> {
    @Override
    public ImportType getType() {
        return ImportType.CONTROL_PLAN;
    }

    @Override
    public String getSuggestedSheetName() {
        return this.getType().sheetName();
    }

    @Override
    public List<ImportField<ControlPlanRow>> getFields() {
        return List.of(this.field("number", List.of("number", "no"), false, ValueConverters::asString, (r, v) -> r.setNumber((String)v), "Row number / ID (natural key)"), this.field("partOrProcessNumber", List.of("part number", "process number"), false, ValueConverters::asString, (r, v) -> r.setPartOrProcessNumber((String)v), "Part/Process number"), this.field("processNameOrOperationDescription", List.of("process", "operation", "operation description"), true, ValueConverters::asString, (r, v) -> r.setProcessNameOrOperationDescription((String)v), "Process/Operation"), this.field("machineDeviceJigToolForMfg", List.of("machine"), false, ValueConverters::asString, (r, v) -> r.setMachineDeviceJigToolForMfg((String)v), "Machine/Tool"), this.field("characteristicOrParameter", List.of("characteristic", "parameter"), false, ValueConverters::asString, (r, v) -> r.setCharacteristicOrParameter((String)v), "Characteristic/Parameter"), this.field("productCharacteristic", List.of("product characteristic"), false, ValueConverters::asString, (r, v) -> r.setProductCharacteristic((String)v), "Product characteristic"), this.field("processCharacteristic", List.of("process characteristic"), false, ValueConverters::asString, (r, v) -> r.setProcessCharacteristic((String)v), "Process characteristic"), this.field("criticalToQuality", List.of("ctq"), false, ValueConverters::asBoolean, (r, v) -> r.setIsCriticalToQuality((Boolean)v), "Critical to Quality"), this.field("criticalToSafety", List.of("cts"), false, ValueConverters::asBoolean, (r, v) -> r.setIsCriticalToSafety((Boolean)v), "Critical to Safety"), this.field("criticalToProcess", List.of("ctp"), false, ValueConverters::asBoolean, (r, v) -> r.setIsCriticalToProcess((Boolean)v), "Critical to Process"), this.field("attribute", List.of("attribute"), false, ValueConverters::asBoolean, (r, v) -> r.setAttribute((Boolean)v), "Attribute?"), this.field("targetValue", List.of("target"), false, ValueConverters::asString, (r, v) -> r.setTargetValue((String)v), "Target"), this.field("upperLimit", List.of("upper"), false, ValueConverters::asString, (r, v) -> r.setUpperLimit((String)v), "Upper limit"), this.field("lowerLimit", List.of("lower"), false, ValueConverters::asString, (r, v) -> r.setLowerLimit((String)v), "Lower limit"), this.field("evaluationMeasurementTechnique", List.of("measurement", "technique"), false, ValueConverters::asString, (r, v) -> r.setEvaluationMeasurementTechnique((String)v), "Measurement technique"), this.field("sampleSize", List.of("sample size"), false, ValueConverters::asString, (r, v) -> r.setSampleSize((String)v), "Sample size"), this.field("sampleFrequency", List.of("sample frequency"), false, ValueConverters::asString, (r, v) -> r.setSampleFrequency((String)v), "Sample frequency"), this.field("controlMethod", List.of("control method"), false, ValueConverters::asString, (r, v) -> r.setControlMethod((String)v), "Control method"), this.field("reactionPlan", List.of("reaction plan"), false, ValueConverters::asString, (r, v) -> r.setReactionPlan((String)v), "Reaction plan"));
    }

    private ImportField<ControlPlanRow> field(String name, List<String> aliases, boolean required, Function<String, Object> converter, BiConsumer<ControlPlanRow, Object> setter, String description) {
        return new ImportField<ControlPlanRow>(name, aliases, required, converter, setter, null, null, description);
    }

    @Override
    public String naturalKey(ControlPlanRow instance, ImportExtras extras) {
        if (instance == null) {
            return null;
        }
        String number = instance.getNumber();
        if (number != null && !number.isBlank()) {
            return number.trim();
        }
        String process = instance.getProcessNameOrOperationDescription();
        String characteristic = instance.getCharacteristicOrParameter();
        if (process != null && characteristic != null && !process.isBlank() && !characteristic.isBlank()) {
            return (process + "::" + characteristic).toLowerCase();
        }
        return null;
    }

    @Override
    public ControlPlanRow newInstance() {
        return new ControlPlanRow();
    }

    @Override
    public Optional<ControlPlanRow> findExisting(Project project, String naturalKey) {
        ControlPlan cp = this.resolveControlPlan(project);
        if (cp == null || naturalKey == null || naturalKey.isBlank()) {
            return Optional.empty();
        }
        return cp.getControlChains().stream().filter(r -> naturalKey.equalsIgnoreCase(this.naturalKey((ControlPlanRow)r))).findFirst();
    }

    private String naturalKey(ControlPlanRow row) {
        if (row == null) {
            return null;
        }
        String number = row.getNumber();
        if (number != null && !number.isBlank()) {
            return number.trim();
        }
        String process = row.getProcessNameOrOperationDescription();
        String characteristic = row.getCharacteristicOrParameter();
        if (process != null && characteristic != null && !process.isBlank() && !characteristic.isBlank()) {
            return (process + "::" + characteristic).toLowerCase();
        }
        return null;
    }

    @Override
    public void attach(Project project, ControlPlanRow instance, ImportExtras extras) {
        ControlPlan cp = this.resolveControlPlan(project);
        if (cp == null) {
            return;
        }
        if (!cp.getControlChains().contains((Object)instance)) {
            cp.getControlChains().add((Object)instance);
        }
    }

    private ControlPlan resolveControlPlan(Project project) {
        if (project == null) {
            return null;
        }
        if (project.getControlPlans().isEmpty()) {
            ControlPlan cp = new ControlPlan();
            cp.setCpNumber("Imported Control Plan");
            cp.setCpPartNumber("Imported Control Plan");
            project.addControlPlan(cp);
            return cp;
        }
        ControlPlan cp = (ControlPlan)project.getControlPlans().get(0);
        if (cp.getCpPartNumber() == null || cp.getCpPartNumber().isBlank()) {
            String fallback = cp.getCpNumber() != null && !cp.getCpNumber().isBlank() ? cp.getCpNumber() : "Control Plan";
            cp.setCpPartNumber(fallback);
        }
        return cp;
    }

    @Override
    public List<String> templateSample() {
        return List.of("10", "W-001", "Wheel Assembly", "Spoke machine", "OP10", "Spoke tension", "", "Process char", "TRUE", "FALSE", "TRUE", "FALSE", "1100 N", "1200 N", "1000 N", "Tensiometer", "5 pcs", "Each wheel", "SPC chart", "Re-tension and re-true");
    }
}

