/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.excelimport.schemas;

import com.qualidadeeprodutividade.excelimport.ImportExtras;
import com.qualidadeeprodutividade.excelimport.ImportField;
import com.qualidadeeprodutividade.excelimport.ImportSchema;
import com.qualidadeeprodutividade.excelimport.ImportType;
import com.qualidadeeprodutividade.excelimport.ValueConverters;
import com.qualidadeeprodutividade.fmea.Dfmea;
import com.qualidadeeprodutividade.fmea.DfmeaRow;
import com.qualidadeeprodutividade.project.Project;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class DfmeaSchema
implements ImportSchema<DfmeaRow> {
    @Override
    public ImportType getType() {
        return ImportType.DFMEA;
    }

    @Override
    public String getSuggestedSheetName() {
        return this.getType().sheetName();
    }

    @Override
    public List<ImportField<DfmeaRow>> getFields() {
        return List.of(this.field("issueNumber", List.of("issue", "issue number"), false, ValueConverters::asInteger, (r, v) -> r.setIssueNumber((Integer)v), "Issue number (natural key)"), this.field("changeAuthorization", List.of("change authorization"), false, ValueConverters::asString, (r, v) -> r.setChangeAuthorization((String)v), "Change authorization"), this.field("nextHigherLevel", List.of("next higher level"), false, ValueConverters::asString, (r, v) -> r.setNextHigherLevelText((String)v), "Next Higher Level"), this.field("focusElement", List.of("focus element", "focus"), false, ValueConverters::asString, (r, v) -> r.setFocusElementText((String)v), "Focus Element"), this.field("nextLowerLevelOrCharacteristic", List.of("next lower level", "characteristic"), false, ValueConverters::asString, (r, v) -> r.setNextLowerLevelOrCharacteristicText((String)v), "Next Lower Level / Characteristic"), this.field("nextHigherLevelFunction", List.of("higher level function"), false, ValueConverters::asString, (r, v) -> r.setNextHigherLevelFunction((String)v), "Higher Level Function"), this.field("focusElementFunctionRequirement", List.of("focus function"), false, ValueConverters::asString, (r, v) -> r.setFocusElementFunctionRequirement((String)v), "Focus Function/Requirement"), this.field("nextLowerLevelFunctionRequirementOrCharacteristic", List.of("lower function", "lower requirement", "lower characteristic"), false, ValueConverters::asString, (r, v) -> r.setNextLowerLevelFunctionRequirementOrCharacteristic((String)v), "Lower Function/Requirement/Characteristic"), this.field("failureEffect", List.of("failure effect"), true, ValueConverters::asString, (r, v) -> r.setFailureEffect((String)v), "Failure Effect"), this.field("severity", List.of("severity", "s"), false, raw -> DfmeaSchema.toSeverity(raw), (r, v) -> r.setSeverity((DfmeaRow.Severity)((Object)((Object)v))), "Severity (1-10)"), this.field("failureMode", List.of("failure mode"), true, ValueConverters::asString, (r, v) -> r.setFailureMode((String)v), "Failure Mode"), this.field("failureCause", List.of("failure cause"), true, ValueConverters::asString, (r, v) -> r.setFailureCause((String)v), "Failure Cause"), this.field("preventionControl", List.of("prevention control", "pc"), false, ValueConverters::asString, (r, v) -> r.setPreventionControl((String)v), "Prevention Control"), this.field("occurrence", List.of("occurrence", "o"), false, raw -> DfmeaSchema.toOccurrence(raw), (r, v) -> r.setOccurrence((DfmeaRow.Occurrence)((Object)((Object)v))), "Occurrence (1-10)"), this.field("detectionControl", List.of("detection control", "dc"), false, ValueConverters::asString, (r, v) -> r.setDetectionControl((String)v), "Detection Control"), this.field("detection", List.of("detection", "d"), false, raw -> DfmeaSchema.toDetection(raw), (r, v) -> r.setDetection((DfmeaRow.Detection)((Object)((Object)v))), "Detection (1-10)"), this.field("actionPriority", List.of("action priority", "ap"), false, raw -> ValueConverters.asEnum(raw, DfmeaRow.ActionPriority.class), (r, v) -> r.setActionPriority((DfmeaRow.ActionPriority)((Object)((Object)v))), "Action Priority"), this.field("filterCode", List.of("filter code"), false, ValueConverters::asString, (r, v) -> r.setFilterCode((String)v), "Filter Code"), this.field("preventiveAction", List.of("preventive action"), false, ValueConverters::asString, (r, v) -> r.setPreventiveAction((String)v), "Preventive Action"), this.field("detectionAction", List.of("detection action"), false, ValueConverters::asString, (r, v) -> r.setDetectionAction((String)v), "Detection Action"), this.field("responsiblePerson", List.of("responsible"), false, ValueConverters::asString, (r, v) -> r.setResponsiblePerson((String)v), "Responsible"), this.field("targetCompletionDate", List.of("target date"), false, raw -> ValueConverters.asDate(raw), (r, v) -> r.setTargetCompletionDate((LocalDate)v), "Target Date"), this.field("status", List.of("status"), false, raw -> ValueConverters.asEnum(raw, DfmeaRow.DfmeaStatus.class), (r, v) -> r.setStatus((DfmeaRow.DfmeaStatus)((Object)((Object)v))), "Status"), this.field("actionTakenEvidence", List.of("action taken"), false, ValueConverters::asString, (r, v) -> r.setActionTakenEvidence((String)v), "Action Taken"), this.field("completionDate", List.of("completion date"), false, raw -> ValueConverters.asDate(raw), (r, v) -> r.setCompletionDate((LocalDate)v), "Completion Date"), this.field("currentSeverity", List.of("current severity", "cur severity"), false, raw -> DfmeaSchema.toSeverity(raw), (r, v) -> r.setCurrentSeverity((DfmeaRow.Severity)((Object)((Object)v))), "Current Severity"), this.field("currentOccurrence", List.of("current occurrence", "cur occurrence"), false, raw -> DfmeaSchema.toOccurrence(raw), (r, v) -> r.setCurrentOccurrence((DfmeaRow.Occurrence)((Object)((Object)v))), "Current Occurrence"), this.field("currentDetection", List.of("current detection", "cur detection"), false, raw -> DfmeaSchema.toDetection(raw), (r, v) -> r.setCurrentDetection((DfmeaRow.Detection)((Object)((Object)v))), "Current Detection"), this.field("currentActionPriority", List.of("current ap"), false, raw -> ValueConverters.asEnum(raw, DfmeaRow.ActionPriority.class), (r, v) -> r.setCurrentActionPriority((DfmeaRow.ActionPriority)((Object)((Object)v))), "Current Action Priority"), this.field("remarks", List.of("remarks", "obs"), false, ValueConverters::asString, (r, v) -> r.setRemarks((String)v), "Remarks"));
    }

    private ImportField<DfmeaRow> field(String name, List<String> aliases, boolean required, Function<String, Object> converter, BiConsumer<DfmeaRow, Object> setter, String description) {
        return new ImportField<DfmeaRow>(name, aliases, required, converter, setter, null, null, description);
    }

    @Override
    public String naturalKey(DfmeaRow instance, ImportExtras extras) {
        if (instance == null) {
            return null;
        }
        int issue = instance.getIssueNumber();
        if (issue > 0) {
            return Integer.toString(issue);
        }
        String fm = instance.getFailureMode();
        String fc = instance.getFailureCause();
        if (fm != null && fc != null && !fm.isBlank() && !fc.isBlank()) {
            return (fm + "::" + fc).toLowerCase();
        }
        return null;
    }

    @Override
    public DfmeaRow newInstance() {
        return new DfmeaRow();
    }

    @Override
    public Optional<DfmeaRow> findExisting(Project project, String naturalKey) {
        Dfmea dfmea = this.resolveDfmea(project);
        if (dfmea == null || naturalKey == null || naturalKey.isBlank()) {
            return Optional.empty();
        }
        return dfmea.getFailureChains().stream().filter(r -> naturalKey.equalsIgnoreCase(this.naturalKey((DfmeaRow)r))).findFirst();
    }

    private String naturalKey(DfmeaRow row) {
        if (row == null) {
            return null;
        }
        int issue = row.getIssueNumber();
        if (issue > 0) {
            return Integer.toString(issue);
        }
        String fm = row.getFailureMode();
        String fc = row.getFailureCause();
        if (fm != null && fc != null && !fm.isBlank() && !fc.isBlank()) {
            return (fm + "::" + fc).toLowerCase();
        }
        return null;
    }

    @Override
    public void attach(Project project, DfmeaRow instance, ImportExtras extras) {
        Dfmea dfmea = this.resolveDfmea(project);
        if (dfmea == null) {
            return;
        }
        if (!dfmea.getFailureChains().contains((Object)instance)) {
            dfmea.getFailureChains().add((Object)instance);
        }
    }

    private Dfmea resolveDfmea(Project project) {
        if (project == null) {
            return null;
        }
        if (project.getDfmeas().isEmpty()) {
            Dfmea dfmea = new Dfmea();
            dfmea.setDfmeaSubject("Imported DFMEA");
            project.addDfmea(dfmea);
            return dfmea;
        }
        return (Dfmea)project.getDfmeas().get(0);
    }

    private static DfmeaRow.Severity toSeverity(String raw) {
        Integer v = ValueConverters.asInteger(raw);
        return v == null ? null : DfmeaRow.Severity.fromValue(v);
    }

    private static DfmeaRow.Occurrence toOccurrence(String raw) {
        Integer v = ValueConverters.asInteger(raw);
        return v == null ? null : DfmeaRow.Occurrence.fromValue(v);
    }

    private static DfmeaRow.Detection toDetection(String raw) {
        Integer v = ValueConverters.asInteger(raw);
        return v == null ? null : DfmeaRow.Detection.fromValue(v);
    }

    @Override
    public List<String> templateSample() {
        return List.of("1", "CHG-01", "Frame", "Head Tube", "Down Tube", "Support steering", "Handlebar support", "Align front end", "Excess flex under load", "8", "Tube ovalization", "Thin wall", "Gauge check", "6", "Visual + caliper", "5", "HIGH", "A1", "Thicker tube spec", "100% incoming check", "Process Eng", "2024-08-01", "OPEN", "", "", "8", "6", "4", "MEDIUM", "Watch for vibration");
    }
}

