/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.excelimport.schemas;

import com.qualidadeeprodutividade.excelimport.ImportExtras;
import com.qualidadeeprodutividade.excelimport.ImportField;
import com.qualidadeeprodutividade.excelimport.ImportSchema;
import com.qualidadeeprodutividade.excelimport.ImportType;
import com.qualidadeeprodutividade.excelimport.ValueConverters;
import com.qualidadeeprodutividade.fmea.Pfmea;
import com.qualidadeeprodutividade.fmea.PfmeaRow;
import com.qualidadeeprodutividade.project.Project;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class PfmeaSchema
implements ImportSchema<PfmeaRow> {
    @Override
    public ImportType getType() {
        return ImportType.PFMEA;
    }

    @Override
    public String getSuggestedSheetName() {
        return this.getType().sheetName();
    }

    @Override
    public List<ImportField<PfmeaRow>> getFields() {
        return List.of(this.field("issueNumber", List.of("issue", "issue number"), false, ValueConverters::asInteger, (r, v) -> r.setIssueNumber((Integer)v), "Issue number (natural key)"), this.field("changeAuthorization", List.of("change authorization"), false, ValueConverters::asString, (r, v) -> r.setChangeAuthorization((String)v), "Change authorization"), this.field("nextHigherLevel", List.of("next higher level"), false, ValueConverters::asString, (r, v) -> r.setNextHigherLevelText((String)v), "Next Higher Level"), this.field("focusElement", List.of("focus element", "focus"), false, ValueConverters::asString, (r, v) -> r.setFocusElementText((String)v), "Focus Element"), this.field("nextLowerLevelOrParameter", List.of("next lower level", "parameter"), false, ValueConverters::asString, (r, v) -> r.setNextLowerLevelOrParameterText((String)v), "Next Lower Level / Parameter"), this.field("nextHigherLevelFunction", List.of("higher level function"), false, ValueConverters::asString, (r, v) -> r.setNextHigherLevelFunction((String)v), "Higher Level Function"), this.field("focusElementFunctionRequirement", List.of("focus function"), false, ValueConverters::asString, (r, v) -> r.setFocusElementFunctionRequirement((String)v), "Focus Function/Requirement"), this.field("nextLowerLevelFunctionRequirementOrParameter", List.of("lower function", "lower requirement", "lower parameter"), false, ValueConverters::asString, (r, v) -> r.setNextLowerLevelFunctionRequirementOrParameter((String)v), "Lower Function/Requirement/Parameter"), this.field("failureEffect", List.of("failure effect"), true, ValueConverters::asString, (r, v) -> r.setFailureEffect((String)v), "Failure Effect"), this.field("severity", List.of("severity", "s"), false, raw -> PfmeaSchema.toSeverity(raw), (r, v) -> r.setSeverity((PfmeaRow.Severity)((Object)((Object)v))), "Severity (1-10)"), this.field("failureMode", List.of("failure mode"), true, ValueConverters::asString, (r, v) -> r.setFailureMode((String)v), "Failure Mode"), this.field("failureCause", List.of("failure cause"), true, ValueConverters::asString, (r, v) -> r.setFailureCause((String)v), "Failure Cause"), this.field("preventionControl", List.of("prevention control", "pc"), false, ValueConverters::asString, (r, v) -> r.setPreventionControl((String)v), "Prevention Control"), this.field("occurrence", List.of("occurrence", "o"), false, raw -> PfmeaSchema.toOccurrence(raw), (r, v) -> r.setOccurrence((PfmeaRow.Occurrence)((Object)((Object)v))), "Occurrence (1-10)"), this.field("detectionControl", List.of("detection control", "dc"), false, ValueConverters::asString, (r, v) -> r.setDetectionControl((String)v), "Detection Control"), this.field("detection", List.of("detection", "d"), false, raw -> PfmeaSchema.toDetection(raw), (r, v) -> r.setDetection((PfmeaRow.Detection)((Object)((Object)v))), "Detection (1-10)"), this.field("actionPriority", List.of("action priority", "ap"), false, raw -> ValueConverters.asEnum(raw, PfmeaRow.ActionPriority.class), (r, v) -> r.setActionPriority((PfmeaRow.ActionPriority)((Object)((Object)v))), "Action Priority"), this.field("filterCode", List.of("filter code"), false, ValueConverters::asString, (r, v) -> r.setFilterCode((String)v), "Filter Code"), this.field("preventiveAction", List.of("preventive action"), false, ValueConverters::asString, (r, v) -> r.setPreventiveAction((String)v), "Preventive Action"), this.field("detectionAction", List.of("detection action"), false, ValueConverters::asString, (r, v) -> r.setDetectionAction((String)v), "Detection Action"), this.field("responsiblePerson", List.of("responsible"), false, ValueConverters::asString, (r, v) -> r.setResponsiblePerson((String)v), "Responsible"), this.field("targetCompletionDate", List.of("target date"), false, raw -> ValueConverters.asDate(raw), (r, v) -> r.setTargetCompletionDate((LocalDate)v), "Target Date"), this.field("status", List.of("status"), false, raw -> ValueConverters.asEnum(raw, PfmeaRow.PfmeaStatus.class), (r, v) -> r.setStatus((PfmeaRow.PfmeaStatus)((Object)((Object)v))), "Status"), this.field("actionTakenEvidence", List.of("action taken"), false, ValueConverters::asString, (r, v) -> r.setActionTakenEvidence((String)v), "Action Taken"), this.field("completionDate", List.of("completion date"), false, raw -> ValueConverters.asDate(raw), (r, v) -> r.setCompletionDate((LocalDate)v), "Completion Date"), this.field("currentSeverity", List.of("current severity", "cur severity"), false, raw -> PfmeaSchema.toSeverity(raw), (r, v) -> r.setCurrentSeverity((PfmeaRow.Severity)((Object)((Object)v))), "Current Severity"), this.field("currentOccurrence", List.of("current occurrence", "cur occurrence"), false, raw -> PfmeaSchema.toOccurrence(raw), (r, v) -> r.setCurrentOccurrence((PfmeaRow.Occurrence)((Object)((Object)v))), "Current Occurrence"), this.field("currentDetection", List.of("current detection", "cur detection"), false, raw -> PfmeaSchema.toDetection(raw), (r, v) -> r.setCurrentDetection((PfmeaRow.Detection)((Object)((Object)v))), "Current Detection"), this.field("currentActionPriority", List.of("current ap"), false, raw -> ValueConverters.asEnum(raw, PfmeaRow.ActionPriority.class), (r, v) -> r.setCurrentActionPriority((PfmeaRow.ActionPriority)((Object)((Object)v))), "Current Action Priority"), this.field("remarks", List.of("remarks", "obs"), false, ValueConverters::asString, (r, v) -> r.setRemarks((String)v), "Remarks"));
    }

    private ImportField<PfmeaRow> field(String name, List<String> aliases, boolean required, Function<String, Object> converter, BiConsumer<PfmeaRow, Object> setter, String description) {
        return new ImportField<PfmeaRow>(name, aliases, required, converter, setter, null, null, description);
    }

    @Override
    public String naturalKey(PfmeaRow instance, ImportExtras extras) {
        if (instance == null) {
            return null;
        }
        Integer issue = instance.getIssueNumber();
        if (issue != null && issue > 0) {
            return issue.toString();
        }
        String fm = instance.getFailureMode();
        String fc = instance.getFailureCause();
        if (fm != null && fc != null && !fm.isBlank() && !fc.isBlank()) {
            return (fm + "::" + fc).toLowerCase();
        }
        return null;
    }

    @Override
    public PfmeaRow newInstance() {
        return new PfmeaRow();
    }

    @Override
    public Optional<PfmeaRow> findExisting(Project project, String naturalKey) {
        Pfmea pfmea = this.resolvePfmea(project);
        if (pfmea == null || naturalKey == null || naturalKey.isBlank()) {
            return Optional.empty();
        }
        return pfmea.getFailureChains().stream().filter(r -> naturalKey.equalsIgnoreCase(this.naturalKey((PfmeaRow)r))).findFirst();
    }

    private String naturalKey(PfmeaRow row) {
        if (row == null) {
            return null;
        }
        Integer issue = row.getIssueNumber();
        if (issue != null && issue > 0) {
            return issue.toString();
        }
        String fm = row.getFailureMode();
        String fc = row.getFailureCause();
        if (fm != null && fc != null && !fm.isBlank() && !fc.isBlank()) {
            return (fm + "::" + fc).toLowerCase();
        }
        return null;
    }

    @Override
    public void attach(Project project, PfmeaRow instance, ImportExtras extras) {
        Pfmea pfmea = this.resolvePfmea(project);
        if (pfmea == null) {
            return;
        }
        if (!pfmea.getFailureChains().contains((Object)instance)) {
            pfmea.getFailureChains().add((Object)instance);
        }
    }

    private Pfmea resolvePfmea(Project project) {
        if (project == null) {
            return null;
        }
        if (project.getPfmeas().isEmpty()) {
            Pfmea pfmea = new Pfmea();
            pfmea.setPfmeaSubject("Imported PFMEA");
            project.addPfmea(pfmea);
            return pfmea;
        }
        return (Pfmea)project.getPfmeas().get(0);
    }

    private static PfmeaRow.Severity toSeverity(String raw) {
        Integer v = ValueConverters.asInteger(raw);
        return v == null ? null : PfmeaRow.Severity.fromValue(v);
    }

    private static PfmeaRow.Occurrence toOccurrence(String raw) {
        Integer v = ValueConverters.asInteger(raw);
        return v == null ? null : PfmeaRow.Occurrence.fromValue(v);
    }

    private static PfmeaRow.Detection toDetection(String raw) {
        Integer v = ValueConverters.asInteger(raw);
        return v == null ? null : PfmeaRow.Detection.fromValue(v);
    }

    @Override
    public List<String> templateSample() {
        return List.of("1", "CHG-01", "Frame Welding", "BB Shell", "Chainstay", "Join tubes", "Maintain geometry", "Align rear triangle", "Porosity in weld", "7", "Crack at BB", "Contaminated joint", "Poka-yoke fixture", "5", "Visual + UT", "6", "HIGH", "B2", "Clean/prep surfaces", "Torque audit", "Welding Lead", "2024-08-05", "OPEN", "", "", "7", "5", "4", "MEDIUM", "Focus on purge gas");
    }
}

