/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.excelimport.schemas;

import com.qualidadeeprodutividade.excelimport.ImportExtras;
import com.qualidadeeprodutividade.excelimport.ImportField;
import com.qualidadeeprodutividade.excelimport.ImportSchema;
import com.qualidadeeprodutividade.excelimport.ImportType;
import com.qualidadeeprodutividade.excelimport.ValueConverters;
import com.qualidadeeprodutividade.processItem.Ishikawa;
import com.qualidadeeprodutividade.processItem.ProcessCategory;
import com.qualidadeeprodutividade.processItem.ProcessItem;
import com.qualidadeeprodutividade.processItem.ProcessType;
import com.qualidadeeprodutividade.processItem.ValueCategory;
import com.qualidadeeprodutividade.project.Project;
import java.util.List;
import java.util.Optional;

public final class ProcessTreeSchema
implements ImportSchema<ProcessItem> {
    @Override
    public ImportType getType() {
        return ImportType.PROCESS_TREE;
    }

    @Override
    public String getSuggestedSheetName() {
        return this.getType().sheetName();
    }

    @Override
    public List<ImportField<ProcessItem>> getFields() {
        return List.of(new ImportField<ProcessItem>("description", List.of("description", "name", "operation"), true, ValueConverters::asString, (p, v) -> p.setDescription((String)v), null, null, "Description (natural key)"), new ImportField<ProcessItem>("function", List.of("function"), false, ValueConverters::asString, (p, v) -> p.setFunction((String)v), null, null, "Function"), new ImportField<ProcessItem>("type", List.of("processtype", "type"), false, raw -> ValueConverters.asEnum(raw, ProcessType.class), (p, v) -> p.setType((ProcessType)((Object)((Object)v))), null, (Object)ProcessType.OPERATION, "Type (PROCESS/OPERATION/ACTIVITY)"), new ImportField<ProcessItem>("ishikawa", List.of("ishikawa"), false, raw -> ValueConverters.asEnum(raw, Ishikawa.class), (p, v) -> p.setIshikawa((Ishikawa)((Object)((Object)v))), null, (Object)Ishikawa.METHOD, "Ishikawa category"), new ImportField<ProcessItem>("category", List.of("category"), false, raw -> ValueConverters.asEnum(raw, ProcessCategory.class), (p, v) -> p.setCategory((ProcessCategory)((Object)((Object)v))), null, (Object)ProcessCategory.OPERATION, "Category"), new ImportField<ProcessItem>("valueCategory", List.of("valuecategory", "vc"), false, raw -> ValueConverters.asEnum(raw, ValueCategory.class), (p, v) -> p.setValueCategory((ValueCategory)((Object)((Object)v))), null, (Object)ValueCategory.VA, "Value category"), new ImportField<ProcessItem>("time", List.of("time", "tempo"), false, ValueConverters::asDouble, (p, v) -> p.setTime((Double)v), null, 0.0, "Time"), new ImportField<ProcessItem>("distance", List.of("distance"), false, ValueConverters::asDouble, (p, v) -> p.setDistance((Double)v), null, 0.0, "Distance"), new ImportField("parent", List.of("parent", "parentdescription", "_extra_parent"), false, ValueConverters::asString, null, null, null, "Parent description (for hierarchy)"));
    }

    @Override
    public String naturalKey(ProcessItem instance, ImportExtras extras) {
        if (instance == null) {
            return null;
        }
        String desc = instance.getDescription();
        return desc == null || desc.isBlank() ? null : desc.trim().toLowerCase();
    }

    @Override
    public ProcessItem newInstance() {
        return new ProcessItem();
    }

    @Override
    public Optional<ProcessItem> findExisting(Project project, String naturalKey) {
        if (project == null || naturalKey == null || naturalKey.isBlank()) {
            return Optional.empty();
        }
        return this.findRecursive((List<ProcessItem>)project.getProcessTrees(), naturalKey.trim().toLowerCase());
    }

    private Optional<ProcessItem> findRecursive(List<ProcessItem> nodes, String key) {
        for (ProcessItem p : nodes) {
            String desc = p.getDescription();
            if (desc != null && desc.trim().equalsIgnoreCase(key)) {
                return Optional.of(p);
            }
            Optional<ProcessItem> child = this.findRecursive((List<ProcessItem>)p.getChildren(), key);
            if (!child.isPresent()) continue;
            return child;
        }
        return Optional.empty();
    }

    @Override
    public void attach(Project project, ProcessItem instance, ImportExtras extras) {
        Optional<ProcessItem> parent;
        if (project == null || instance == null) {
            return;
        }
        String parentKey = extras.get("parent");
        if (parentKey != null && !parentKey.isBlank() && (parent = this.findExisting(project, parentKey)).isPresent()) {
            parent.get().addChild(instance);
            return;
        }
        if (!project.getProcessTrees().contains((Object)instance)) {
            project.addProcessTree(instance);
        }
    }

    @Override
    public List<String> templateSample() {
        return List.of("Tube Cutting", "Cut tubes to length", "OPERATION", "METHOD", "OPERATION", "VA", "12.5", "3.2", "");
    }
}

