/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.excelimport.schemas;

import com.qualidadeeprodutividade.excelimport.ImportExtras;
import com.qualidadeeprodutividade.excelimport.ImportField;
import com.qualidadeeprodutividade.excelimport.ImportSchema;
import com.qualidadeeprodutividade.excelimport.ImportType;
import com.qualidadeeprodutividade.excelimport.ValueConverters;
import com.qualidadeeprodutividade.item.Item;
import com.qualidadeeprodutividade.item.ItemType;
import com.qualidadeeprodutividade.project.Project;
import java.util.List;
import java.util.Optional;

public final class ProductTreeSchema
implements ImportSchema<Item> {
    @Override
    public ImportType getType() {
        return ImportType.PRODUCT_TREE;
    }

    @Override
    public String getSuggestedSheetName() {
        return this.getType().sheetName();
    }

    @Override
    public List<ImportField<Item>> getFields() {
        return List.of(new ImportField<Item>("partNumber", List.of("pn", "part number", "code"), true, ValueConverters::asString, (item, v) -> item.setPartNumber((String)v), null, null, "Part Number (natural key)"), new ImportField<Item>("description", List.of("name", "description", "desc"), true, ValueConverters::asString, (item, v) -> item.setDescription((String)v), null, null, "Name/description"), new ImportField<Item>("function", List.of("function"), false, ValueConverters::asString, (item, v) -> item.setFunction((String)v), null, null, "Function"), new ImportField<Item>("type", List.of("itemtype", "type"), false, raw -> ValueConverters.asEnum(raw, ItemType.class), (item, v) -> item.setType((ItemType)((Object)((Object)v))), null, (Object)ItemType.PART, "Type (PART/SUBSYSTEM/COMPONENT)"), new ImportField("parentPartNumber", List.of("parent", "parentpartnumber", "_extra_parent"), false, ValueConverters::asString, null, null, null, "Parent Part Number (for hierarchy)"));
    }

    @Override
    public String naturalKey(Item instance, ImportExtras extras) {
        if (instance == null) {
            return null;
        }
        String pn = instance.getPartNumber();
        if (pn != null && !pn.isBlank()) {
            return pn.trim();
        }
        String desc = instance.getDescription();
        return desc == null || desc.isBlank() ? null : desc.trim();
    }

    @Override
    public Item newInstance() {
        return new Item();
    }

    @Override
    public Optional<Item> findExisting(Project project, String naturalKey) {
        if (project == null || naturalKey == null || naturalKey.isBlank()) {
            return Optional.empty();
        }
        return this.findRecursive((List<Item>)project.getProductTrees(), naturalKey.trim());
    }

    private Optional<Item> findRecursive(List<Item> nodes, String key) {
        for (Item i : nodes) {
            if (key.equalsIgnoreCase(ProductTreeSchema.defaultIfBlank(i.getPartNumber(), i.getDescription()))) {
                return Optional.of(i);
            }
            Optional<Item> child = this.findRecursive((List<Item>)i.getChildren(), key);
            if (!child.isPresent()) continue;
            return child;
        }
        return Optional.empty();
    }

    @Override
    public void attach(Project project, Item instance, ImportExtras extras) {
        Optional<Item> parent;
        if (project == null || instance == null) {
            return;
        }
        String parentKey = extras.get("parent");
        if (parentKey != null && !parentKey.isBlank() && (parent = this.findExisting(project, parentKey)).isPresent()) {
            parent.get().addChild(instance);
            return;
        }
        this.ensureRootType(instance);
        if (!project.getProductTrees().contains((Object)instance)) {
            project.addProductTree(instance);
        }
    }

    @Override
    public List<String> templateSample() {
        return List.of("PRD-001", "Example Product", "Support rider weight", "PRODUCT", "");
    }

    private void ensureRootType(Item instance) {
        if (instance == null) {
            return;
        }
        if (instance.getType() != ItemType.PRODUCT) {
            instance.setType(ItemType.PRODUCT);
        }
    }

    private static String defaultIfBlank(String primary, String fallback) {
        if (primary != null && !primary.isBlank()) {
            return primary.trim();
        }
        return fallback == null ? null : fallback.trim();
    }
}

