/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.export;

import java.io.File;
import java.util.prefs.Preferences;
import javafx.stage.FileChooser;

public final class ExportDirectoryPreferences {
    private static final Preferences PREFS = Preferences.userNodeForPackage(ExportDirectoryPreferences.class);
    private static final String KEY_LAST_EXPORT_DIR = "export.lastDirectory";

    private ExportDirectoryPreferences() {
    }

    public static void applyInitialDirectory(FileChooser chooser) {
        if (chooser == null) {
            return;
        }
        File initial = ExportDirectoryPreferences.getLastExportDirectory();
        if (initial != null && initial.isDirectory()) {
            chooser.setInitialDirectory(initial);
        }
    }

    public static File getLastExportDirectory() {
        File homeDir;
        File dir;
        String remembered = PREFS.get(KEY_LAST_EXPORT_DIR, null);
        if (remembered != null && !remembered.isBlank() && (dir = new File(remembered)).isDirectory()) {
            return dir;
        }
        String home = System.getProperty("user.home");
        if (home != null && !home.isBlank() && (homeDir = new File(home)).isDirectory()) {
            return homeDir;
        }
        File cwd = new File(".").getAbsoluteFile();
        return cwd.isDirectory() ? cwd : null;
    }

    public static void rememberExportDirectory(File directory) {
        if (directory == null || !directory.isDirectory()) {
            return;
        }
        PREFS.put(KEY_LAST_EXPORT_DIR, directory.getAbsolutePath());
    }
}

