/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.export;

import java.util.regex.Pattern;

public final class ExportFileNameUtil {
    private static final Pattern INVALID_CHARS = Pattern.compile("[\\\\/:*?\"<>|]+");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");

    private ExportFileNameUtil() {
    }

    public static String suggestedName(String baseName, String fallbackBaseName, String extension) {
        String safeBase = ExportFileNameUtil.sanitizeBase(baseName, fallbackBaseName);
        String safeExt = ExportFileNameUtil.sanitizeExtension(extension);
        return safeBase + "." + safeExt;
    }

    public static String sanitizeBase(String baseName, String fallbackBaseName) {
        String cleaned = ExportFileNameUtil.normalize(baseName);
        if (cleaned.isBlank()) {
            cleaned = ExportFileNameUtil.normalize(fallbackBaseName);
        }
        if (cleaned.isBlank()) {
            cleaned = "export";
        }
        return cleaned;
    }

    private static String sanitizeExtension(String extension) {
        if (extension == null) {
            return "dat";
        }
        String cleaned = extension.trim().toLowerCase();
        if (cleaned.startsWith(".")) {
            cleaned = cleaned.substring(1);
        }
        cleaned = INVALID_CHARS.matcher(cleaned).replaceAll("");
        return (cleaned = WHITESPACE.matcher(cleaned).replaceAll("")).isBlank() ? "dat" : cleaned;
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        String cleaned = INVALID_CHARS.matcher(value).replaceAll(" ");
        cleaned = WHITESPACE.matcher(cleaned).replaceAll(" ").trim();
        while (cleaned.endsWith(".")) {
            cleaned = cleaned.substring(0, cleaned.length() - 1).trim();
        }
        return cleaned;
    }
}

