/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.export;

import com.qualidadeeprodutividade.export.ExportLogoPreferences;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public final class ExportLogoDialog {
    private ExportLogoDialog() {
    }

    public static ExportLogoSelection prompt(Window owner) {
        boolean rememberedCustom;
        Dialog dialog = new Dialog();
        dialog.setTitle("Export Logo");
        dialog.setHeaderText("Select which logo to include in exported files (PDF/Excel)");
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        if (owner != null) {
            dialog.initOwner(owner);
        }
        ToggleGroup group = new ToggleGroup();
        RadioButton rbDefault = new RadioButton("Use CoreTools default logo");
        rbDefault.setToggleGroup(group);
        RadioButton rbCustom = new RadioButton("Use custom logo");
        rbCustom.setToggleGroup(group);
        TextField pathField = new TextField();
        pathField.setPromptText("Select a PNG/JPG/JPEG file...");
        pathField.setPrefColumnCount(36);
        Button browseButton = new Button("Browse...");
        browseButton.setOnAction(evt -> {
            File selected;
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select logo image");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Images (*.png, *.jpg, *.jpeg)", new String[]{"*.png", "*.jpg", "*.jpeg"}), new FileChooser.ExtensionFilter("PNG (*.png)", new String[]{"*.png"}), new FileChooser.ExtensionFilter("JPEG (*.jpg, *.jpeg)", new String[]{"*.jpg", "*.jpeg"})});
            Path current = ExportLogoDialog.safePath(pathField.getText());
            if (current != null && Files.exists(current, new LinkOption[0])) {
                File parent = current.toFile().getParentFile();
                if (parent != null && parent.isDirectory()) {
                    chooser.setInitialDirectory(parent);
                }
                chooser.setInitialFileName(current.getFileName().toString());
            }
            File file = selected = owner != null ? chooser.showOpenDialog(owner) : chooser.showOpenDialog(null);
            if (selected != null) {
                pathField.setText(selected.getAbsolutePath());
            }
        });
        Path remembered = ExportLogoPreferences.getRememberedLogoPath().orElse(null);
        boolean bl = rememberedCustom = remembered != null;
        if (rememberedCustom) {
            rbCustom.setSelected(true);
            pathField.setText(remembered.toString());
        } else {
            rbDefault.setSelected(true);
        }
        GridPane content = new GridPane();
        content.setHgap(10.0);
        content.setVgap(10.0);
        content.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        content.add((Node)rbDefault, 0, 0, 3, 1);
        content.add((Node)rbCustom, 0, 1, 3, 1);
        content.add((Node)new Label("File:"), 0, 2);
        content.add((Node)pathField, 1, 2);
        content.add((Node)browseButton, 2, 2);
        dialog.getDialogPane().setContent((Node)content);
        Node okButton = dialog.getDialogPane().lookupButton(ButtonType.OK);
        Runnable updateState = () -> {
            boolean isCustom = group.getSelectedToggle() == rbCustom;
            pathField.setDisable(!isCustom);
            browseButton.setDisable(!isCustom);
            if (!isCustom) {
                okButton.setDisable(false);
                return;
            }
            Path p = ExportLogoDialog.safePath(pathField.getText());
            okButton.setDisable(p == null || !Files.isRegularFile(p, new LinkOption[0]));
        };
        group.selectedToggleProperty().addListener((obs, oldVal, newVal) -> updateState.run());
        pathField.textProperty().addListener((obs, oldVal, newVal) -> updateState.run());
        updateState.run();
        dialog.setResultConverter(button -> {
            Path customPath;
            if (button != ButtonType.OK) {
                return null;
            }
            boolean isCustom = group.getSelectedToggle() == rbCustom;
            Path path = customPath = isCustom ? ExportLogoDialog.safePath(pathField.getText()) : null;
            if (isCustom && (customPath == null || !Files.isRegularFile(customPath, new LinkOption[0]))) {
                return null;
            }
            if (isCustom) {
                ExportLogoPreferences.saveCustomLogo(customPath);
            } else {
                ExportLogoPreferences.saveDefaultLogo();
            }
            return new ExportLogoSelection(customPath);
        });
        return dialog.showAndWait().orElse(null);
    }

    private static Path safePath(String raw) {
        if (raw == null || raw.isBlank()) {
            return null;
        }
        try {
            return Path.of(raw.trim(), new String[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public record ExportLogoSelection(Path logoPath) {
    }
}

