/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.export;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.prefs.Preferences;

public final class ExportLogoPreferences {
    private static final Preferences PREFS = Preferences.userNodeForPackage(ExportLogoPreferences.class);
    private static final String KEY_USE_CUSTOM = "export.logo.useCustom";
    private static final String KEY_CUSTOM_PATH = "export.logo.customPath";

    private ExportLogoPreferences() {
    }

    public static Optional<Path> getRememberedLogoPath() {
        if (!PREFS.getBoolean(KEY_USE_CUSTOM, false)) {
            return Optional.empty();
        }
        String raw = PREFS.get(KEY_CUSTOM_PATH, "");
        if (raw == null || raw.isBlank()) {
            return Optional.empty();
        }
        try {
            Path p = Path.of(raw.trim(), new String[0]);
            return Files.isRegularFile(p, new LinkOption[0]) ? Optional.of(p) : Optional.empty();
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    public static void saveDefaultLogo() {
        PREFS.putBoolean(KEY_USE_CUSTOM, false);
        PREFS.remove(KEY_CUSTOM_PATH);
    }

    public static void saveCustomLogo(Path logoPath) {
        if (logoPath == null) {
            ExportLogoPreferences.saveDefaultLogo();
            return;
        }
        PREFS.putBoolean(KEY_USE_CUSTOM, true);
        PREFS.put(KEY_CUSTOM_PATH, logoPath.toString());
    }
}

