/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.fmea;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class ApTableCache {
    private static final byte[][][] MATRIX = new byte[11][11][11];
    private static volatile boolean loaded = false;
    private static final Object LOCK = new Object();

    private ApTableCache() {
    }

    public static PriorityLevel levelAt(int severity, int occurrence, int detection) {
        ApTableCache.ensureLoaded();
        if (severity < 1 || severity > 10 || occurrence < 1 || occurrence > 10 || detection < 1 || detection > 10) {
            return PriorityLevel.LOW;
        }
        return PriorityLevel.fromCode(MATRIX[severity][occurrence][detection]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureLoaded() {
        if (loaded) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            if (loaded) {
                return;
            }
            ApTableCache.initializeDefaults();
            try (InputStream is = ApTableCache.class.getResourceAsStream("/ap_table.csv");){
                if (is == null) {
                    System.err.println("[AP] /ap_table.csv not found on classpath; using LOW defaults.");
                } else {
                    ApTableCache.parseCsv(is);
                    System.out.println("[AP] Action Priority table cached from /ap_table.csv.");
                }
            }
            catch (Exception ex) {
                System.err.println("[AP] Failed to load /ap_table.csv: " + ex.getMessage());
            }
            loaded = true;
        }
    }

    private static void initializeDefaults() {
        for (int s = 1; s <= 10; ++s) {
            for (int o = 1; o <= 10; ++o) {
                for (int d = 1; d <= 10; ++d) {
                    ApTableCache.MATRIX[s][o][d] = PriorityLevel.LOW.code;
                }
            }
        }
    }

    private static void parseCsv(InputStream stream) throws IOException {
        String[] delimiters = new String[]{"\\t+", "\\s*;\\s*", "\\s*,\\s*"};
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
            String line;
            String header = null;
            while ((line = br.readLine()) != null) {
                if ((line = ApTableCache.stripBOM(line).trim()).isEmpty() || line.startsWith("#")) continue;
                header = line;
                break;
            }
            if (header == null) {
                return;
            }
            String chosenDelim = null;
            int si = -1;
            int oi = -1;
            int di = -1;
            int api = -1;
            for (String delim : delimiters) {
                String[] hdr = header.split(delim, -1);
                for (int i = 0; i < hdr.length; ++i) {
                    hdr[i] = ApTableCache.normalize(hdr[i]);
                }
                int _si = -1;
                int _oi = -1;
                int _di = -1;
                int _api = -1;
                for (int i = 0; i < hdr.length; ++i) {
                    String h = hdr[i];
                    if (_si < 0 && (h.equals("severity") || h.equals("s"))) {
                        _si = i;
                        continue;
                    }
                    if (_oi < 0 && (h.equals("occurrence") || h.equals("o"))) {
                        _oi = i;
                        continue;
                    }
                    if (_di < 0 && (h.equals("detection") || h.equals("d"))) {
                        _di = i;
                        continue;
                    }
                    if (_api >= 0 || !h.equals("action priority") && !h.equals("action_priority") && !h.equals("actionpriority") && !h.equals("ap")) continue;
                    _api = i;
                }
                if (_si < 0 || _oi < 0 || _di < 0 || _api < 0) continue;
                chosenDelim = delim;
                si = _si;
                oi = _oi;
                di = _di;
                api = _api;
                break;
            }
            if (chosenDelim == null) {
                throw new IOException("AP header missing required columns (Severity, Occurrence, Detection, Action Priority).");
            }
            while ((line = br.readLine()) != null) {
                int d;
                int o;
                int s;
                int maxIdx;
                String[] parts;
                if ((line = ApTableCache.stripBOM(line).trim()).isEmpty() || line.startsWith("#") || (parts = line.split(chosenDelim, -1)).length <= (maxIdx = Math.max(Math.max(si, oi), Math.max(di, api)))) continue;
                String ps = ApTableCache.normalize(parts[si]);
                String po = ApTableCache.normalize(parts[oi]);
                String pd = ApTableCache.normalize(parts[di]);
                String pa = ApTableCache.normalize(parts[api]);
                try {
                    s = Integer.parseInt(ps);
                    o = Integer.parseInt(po);
                    d = Integer.parseInt(pd);
                }
                catch (NumberFormatException ignore) {
                    continue;
                }
                PriorityLevel level = ApTableCache.parsePriority(pa);
                if (level == null || s < 1 || s > 10 || o < 1 || o > 10 || d < 1 || d > 10) continue;
                ApTableCache.MATRIX[s][o][d] = level.code;
            }
        }
    }

    private static PriorityLevel parsePriority(String token) {
        if (token == null || token.isEmpty()) {
            return null;
        }
        char c = token.charAt(0);
        if (c == 'h') {
            return PriorityLevel.HIGH;
        }
        if (c == 'm') {
            return PriorityLevel.MEDIUM;
        }
        if (c == 'l') {
            return PriorityLevel.LOW;
        }
        return null;
    }

    private static String stripBOM(String line) {
        if (line != null && !line.isEmpty() && line.charAt(0) == '\ufeff') {
            return line.substring(1);
        }
        return line;
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        if ((value = value.trim()).length() >= 2 && (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'"))) {
            value = value.substring(1, value.length() - 1).trim();
        }
        return value.toLowerCase();
    }

    public static enum PriorityLevel {
        HIGH(3),
        MEDIUM(2),
        LOW(1);

        private final byte code;

        private PriorityLevel(byte code) {
            this.code = code;
        }

        static PriorityLevel fromCode(byte code) {
            return switch (code) {
                case 3 -> HIGH;
                case 2 -> MEDIUM;
                default -> LOW;
            };
        }
    }
}

