/*
 * Decompiled with CFR 0.152.
 */
package com.qualidadeeprodutividade.fmea;

import com.qualidadeeprodutividade.fmea.ApprovalStatus;
import com.qualidadeeprodutividade.fmea.ConfidentialityLevel;
import com.qualidadeeprodutividade.fmea.DfmeaRow;
import com.qualidadeeprodutividade.fmea.RevisionEntry;
import com.qualidadeeprodutividade.item.Item;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Dfmea {
    private final String uuid = UUID.randomUUID().toString();
    private final StringProperty companyName = new SimpleStringProperty((Object)this, "companyName", "");
    private final StringProperty engineeringLocation = new SimpleStringProperty((Object)this, "engineeringLocation", "");
    private final StringProperty customerName = new SimpleStringProperty((Object)this, "customerName", "");
    private final StringProperty modelYearPlatform = new SimpleStringProperty((Object)this, "modelYearPlatform", "");
    private final StringProperty dfmeaSubject = new SimpleStringProperty((Object)this, "dfmeaSubject", "");
    private final ObjectProperty<LocalDate> dfmeaStartDate = new SimpleObjectProperty((Object)this, "dfmeaStartDate", null);
    private final ObjectProperty<LocalDate> dfmeaLastRevisionDate = new SimpleObjectProperty((Object)this, "dfmeaLastRevisionDate", null);
    private final StringProperty crossFunctionalTeam = new SimpleStringProperty((Object)this, "crossFunctionalTeam", "");
    private final StringProperty dfmeaIdNumber = new SimpleStringProperty((Object)this, "dfmeaIdNumber", "");
    private final StringProperty dfmeaRevision = new SimpleStringProperty((Object)this, "dfmeaRevision", "");
    private final StringProperty designResponsibility = new SimpleStringProperty((Object)this, "designResponsibility", "");
    private final ObjectProperty<ConfidentialityLevel> confidentialityLevel = new SimpleObjectProperty((Object)this, "confidentialityLevel", (Object)ConfidentialityLevel.INTERNAL);
    private final ObservableList<RevisionEntry> revisionHistory = FXCollections.observableArrayList();
    private final ObservableList<DfmeaRow> failureChains = FXCollections.observableArrayList();
    private final ObjectProperty<Item> associatedProduct = new SimpleObjectProperty((Object)this, "associatedProduct");

    public final Item getAssociatedProduct() {
        return (Item)this.associatedProduct.get();
    }

    public final void setAssociatedProduct(Item it) {
        this.associatedProduct.set((Object)it);
        if (it != null && (this.getCustomerName() == null || this.getCustomerName().isBlank())) {
            this.setProductName(it.getDescription());
        }
    }

    public final ObjectProperty<Item> associatedProductProperty() {
        return this.associatedProduct;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getCompanyName() {
        return (String)this.companyName.get();
    }

    public void setCompanyName(String value) {
        this.companyName.set((Object)value);
    }

    public StringProperty companyNameProperty() {
        return this.companyName;
    }

    public String getEngineeringLocation() {
        return (String)this.engineeringLocation.get();
    }

    public void setEngineeringLocation(String value) {
        this.engineeringLocation.set((Object)value);
    }

    public StringProperty engineeringLocationProperty() {
        return this.engineeringLocation;
    }

    public String getCustomerName() {
        return (String)this.customerName.get();
    }

    public void setProductName(String value) {
        this.customerName.set((Object)value);
    }

    public StringProperty productNameProperty() {
        return this.customerName;
    }

    public String getModelYearPlatform() {
        return (String)this.modelYearPlatform.get();
    }

    public void setModelYearPlatform(String value) {
        this.modelYearPlatform.set((Object)value);
    }

    public StringProperty modelYearPlatformProperty() {
        return this.modelYearPlatform;
    }

    public String getDfmeaSubject() {
        return (String)this.dfmeaSubject.get();
    }

    public void setDfmeaSubject(String value) {
        this.dfmeaSubject.set((Object)value);
    }

    public StringProperty dfmeaSubjectProperty() {
        return this.dfmeaSubject;
    }

    public LocalDate getDfmeaStartDate() {
        return (LocalDate)this.dfmeaStartDate.get();
    }

    public void setDfmeaStartDate(LocalDate value) {
        this.dfmeaStartDate.set((Object)value);
    }

    public ObjectProperty<LocalDate> dfmeaStartDateProperty() {
        return this.dfmeaStartDate;
    }

    public LocalDate getDfmeaLastRevisionDate() {
        return (LocalDate)this.dfmeaLastRevisionDate.get();
    }

    public void setDfmeaLastRevisionDate(LocalDate value) {
        this.dfmeaLastRevisionDate.set((Object)value);
    }

    public ObjectProperty<LocalDate> dfmeaLastRevisionDateProperty() {
        return this.dfmeaLastRevisionDate;
    }

    public String getCrossFunctionalTeam() {
        return (String)this.crossFunctionalTeam.get();
    }

    public void setCrossFunctionalTeam(String value) {
        this.crossFunctionalTeam.set((Object)value);
    }

    public StringProperty crossFunctionalTeamProperty() {
        return this.crossFunctionalTeam;
    }

    public String getDfmeaIdNumber() {
        return (String)this.dfmeaIdNumber.get();
    }

    public void setDfmeaIdNumber(String value) {
        this.dfmeaIdNumber.set((Object)value);
    }

    public StringProperty dfmeaIdNumberProperty() {
        return this.dfmeaIdNumber;
    }

    public String getDfmeaRevision() {
        return (String)this.dfmeaRevision.get();
    }

    public void setDfmeaRevision(String value) {
        this.dfmeaRevision.set((Object)value);
    }

    public StringProperty dfmeaRevisionProperty() {
        return this.dfmeaRevision;
    }

    public String getDesignResponsibility() {
        return (String)this.designResponsibility.get();
    }

    public void setDesignResponsibility(String value) {
        this.designResponsibility.set((Object)value);
    }

    public StringProperty designResponsibilityProperty() {
        return this.designResponsibility;
    }

    public ConfidentialityLevel getConfidentialityLevel() {
        return (ConfidentialityLevel)((Object)this.confidentialityLevel.get());
    }

    public void setConfidentialityLevel(ConfidentialityLevel level) {
        this.confidentialityLevel.set((Object)level);
    }

    public ObjectProperty<ConfidentialityLevel> confidentialityLevelProperty() {
        return this.confidentialityLevel;
    }

    public ObservableList<DfmeaRow> getFailureChains() {
        return this.failureChains;
    }

    public DfmeaRow addEmptyChain() {
        DfmeaRow row = new DfmeaRow();
        this.failureChains.add((Object)row);
        return row;
    }

    public boolean removeChain(DfmeaRow row) {
        return this.failureChains.remove((Object)row);
    }

    public ObservableList<RevisionEntry> getRevisionHistory() {
        return this.revisionHistory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dfmea)) {
            return false;
        }
        Dfmea other = (Dfmea)o;
        return Objects.equals(this.uuid, other.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public String toString() {
        return this.getDfmeaSubject();
    }

    public RevisionEntry addRevision(String revisionNumber, LocalDate revisionDate, String authorName, String descriptionOfChanges, ApprovalStatus approvalStatus) {
        RevisionEntry entry = new RevisionEntry(revisionNumber, revisionDate, authorName, descriptionOfChanges, approvalStatus);
        this.revisionHistory.add((Object)entry);
        return entry;
    }

    public boolean removeRevision(RevisionEntry entry) {
        return this.revisionHistory.remove((Object)entry);
    }

    public Optional<RevisionEntry> latestApprovedRevision() {
        return this.revisionHistory.stream().filter(e -> e.getApprovalStatus() == ApprovalStatus.APPROVED).max(Comparator.comparing(e -> e.getRevisionDate() != null ? e.getRevisionDate() : LocalDate.MIN));
    }

    public void approveRevision(RevisionEntry entry) {
        entry.setApprovalStatus(ApprovalStatus.APPROVED);
    }
}

